/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.CastSupport;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedInlineTable;
import org.apache.spark.sql.catalyst.analysis.package$;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.catalyst.trees.AlwaysProcess$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class ResolveInlineTables$
extends Rule<LogicalPlan>
implements CastSupport,
AliasHelper {
    public static ResolveInlineTables$ MODULE$;

    static {
        new ResolveInlineTables$();
    }

    @Override
    public AttributeMap<Alias> getAliasMap(Project plan2) {
        return AliasHelper.getAliasMap$((AliasHelper)this, plan2);
    }

    @Override
    public AttributeMap<Alias> getAliasMap(Aggregate plan2) {
        return AliasHelper.getAliasMap$((AliasHelper)this, plan2);
    }

    @Override
    public AttributeMap<Alias> getAliasMap(Seq<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    @Override
    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$(this, expr, aliasMap);
    }

    @Override
    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$(this, expr, aliasMap);
    }

    @Override
    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$(this, e);
    }

    @Override
    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$(this, e);
    }

    @Override
    public Cast cast(Expression child, DataType dataType) {
        return CastSupport.cast$(this, child, dataType);
    }

    @Override
    public LogicalPlan apply(LogicalPlan plan2) {
        return plan2.resolveOperatorsWithPruning(AlwaysProcess$.MODULE$.fn(), this.ruleId(), (PartialFunction<LogicalPlan, LogicalPlan>)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                UnresolvedInlineTable unresolvedInlineTable;
                A1 A1 = x1;
                if (A1 instanceof UnresolvedInlineTable && (unresolvedInlineTable = (UnresolvedInlineTable)A1).expressionsResolved()) {
                    ResolveInlineTables$.MODULE$.validateInputDimension(unresolvedInlineTable);
                    ResolveInlineTables$.MODULE$.validateInputEvaluable(unresolvedInlineTable);
                    return (B1)ResolveInlineTables$.MODULE$.convert(unresolvedInlineTable);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                UnresolvedInlineTable unresolvedInlineTable;
                LogicalPlan logicalPlan = x1;
                return logicalPlan instanceof UnresolvedInlineTable && (unresolvedInlineTable = (UnresolvedInlineTable)logicalPlan).expressionsResolved();
            }
        });
    }

    public void validateInputDimension(UnresolvedInlineTable table) {
        if (table.rows().nonEmpty()) {
            int numCols = table.names().size();
            ((IterableLike)table.rows().zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                ResolveInlineTables$.$anonfun$validateInputDimension$1(numCols, table, x0$1);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public void validateInputEvaluable(UnresolvedInlineTable table) {
        table.rows().foreach((Function1 & Serializable & scala.Serializable)row -> {
            row.foreach((Function1 & Serializable & scala.Serializable)e -> {
                ResolveInlineTables$.$anonfun$validateInputEvaluable$2(e);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
    }

    public LocalRelation convert(UnresolvedInlineTable table) {
        Seq fields = (Seq)((TraversableLike)((IterableLike)table.rows().transpose((Function1)Predef$.MODULE$.$conforms())).zip(table.names(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Seq column = (Seq)tuple2._1();
                String name = (String)tuple2._2();
                Seq inputTypes = (Seq)column.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.dataType(), Seq$.MODULE$.canBuildFrom());
                DataType tpe = (DataType)TypeCoercion$.MODULE$.findWiderTypeWithoutStringPromotion((Seq<DataType>)inputTypes).getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.AnalysisErrorAt(table).failAnalysis(new StringBuilder(52).append("incompatible types found in column ").append(name).append(" for inline table").toString()));
                return new StructField(name, tpe, column.exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.nullable())), StructField$.MODULE$.apply$default$4());
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom());
        Seq<AttributeReference> attributes = StructType$.MODULE$.apply((Seq<StructField>)fields).toAttributes();
        Predef$.MODULE$.assert(fields.size() == table.names().size());
        Seq newRows = (Seq)table.rows().map((Function1 & Serializable & scala.Serializable)row -> InternalRow$.MODULE$.fromSeq((Seq<Object>)((Seq)((TraversableLike)row.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                Object object;
                Expression e = (Expression)tuple2._1();
                int ci = tuple2._2$mcI$sp();
                DataType targetType = ((StructField)fields.apply(ci)).dataType();
                try {
                    Expression castedExpr = e.dataType().sameType(targetType) ? e : MODULE$.cast(e, targetType);
                    object = castedExpr.eval(castedExpr.eval$default$1());
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option.isEmpty()) {
                        Throwable ex = (Throwable)option.get();
                        throw package$.MODULE$.AnalysisErrorAt(table).failAnalysis(new StringBuilder(32).append("failed to evaluate expression ").append(e.sql()).append(": ").append(ex.getMessage()).toString(), ex);
                    }
                    throw throwable;
                }
                return object;
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom()))), Seq$.MODULE$.canBuildFrom());
        return new LocalRelation(attributes, (Seq<InternalRow>)newRows, LocalRelation$.MODULE$.apply$default$3());
    }

    public static final /* synthetic */ void $anonfun$validateInputDimension$1(int numCols$1, UnresolvedInlineTable table$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Seq row = (Seq)tuple2._1();
            int ri = tuple2._2$mcI$sp();
            if (row.size() != numCols$1) {
                throw package$.MODULE$.AnalysisErrorAt(table$1).failAnalysis(new StringBuilder(44).append("expected ").append(numCols$1).append(" columns but found ").append(row.size()).append(" columns in row ").append(ri).toString());
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$validateInputEvaluable$2(Expression e) {
        if (!e.resolved() || !MODULE$.trimAliases(e).foldable()) {
            throw package$.MODULE$.AnalysisErrorAt(e).failAnalysis(new StringBuilder(54).append("cannot evaluate expression ").append(e.sql()).append(" in inline table definition").toString());
        }
    }

    private ResolveInlineTables$() {
        MODULE$ = this;
        CastSupport.$init$(this);
        AliasHelper.$init$(this);
    }
}

