/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.statsEstimation;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.ResolvedNamespace;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.Ascending$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeMap$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.expressions.SortDirection;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.expressions.SortOrder$;
import org.apache.spark.sql.catalyst.plans.PlanTest;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat$;
import org.apache.spark.sql.catalyst.plans.logical.CommentOnNamespace;
import org.apache.spark.sql.catalyst.plans.logical.Distinct;
import org.apache.spark.sql.catalyst.plans.logical.GlobalLimit;
import org.apache.spark.sql.catalyst.plans.logical.Histogram;
import org.apache.spark.sql.catalyst.plans.logical.HistogramBin;
import org.apache.spark.sql.catalyst.plans.logical.Intersect;
import org.apache.spark.sql.catalyst.plans.logical.LocalLimit;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.plans.logical.Range;
import org.apache.spark.sql.catalyst.plans.logical.Range$;
import org.apache.spark.sql.catalyst.plans.logical.RepartitionByExpression;
import org.apache.spark.sql.catalyst.plans.logical.RepartitionByExpression$;
import org.apache.spark.sql.catalyst.plans.logical.Sample;
import org.apache.spark.sql.catalyst.plans.logical.Sort;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.plans.logical.Statistics$;
import org.apache.spark.sql.catalyst.plans.logical.Tail;
import org.apache.spark.sql.catalyst.plans.logical.Union;
import org.apache.spark.sql.catalyst.plans.logical.Union$;
import org.apache.spark.sql.catalyst.statsEstimation.DummyLogicalPlan;
import org.apache.spark.sql.catalyst.statsEstimation.StatsEstimationTestBase;
import org.apache.spark.sql.catalyst.statsEstimation.StatsTestPlan;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.SupportsNamespaces;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.mockito.Mockito;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001Y4Aa\u0003\u0007\u00013!)\u0001\u0006\u0001C\u0001S!91\u0006\u0001b\u0001\n\u0003a\u0003BB\u001a\u0001A\u0003%Q\u0006C\u00045\u0001\t\u0007I\u0011A\u001b\t\rq\u0002\u0001\u0015!\u00037\u0011\u001di\u0004A1A\u0005\u0002yBaA\u0011\u0001!\u0002\u0013y\u0004\"B\"\u0001\t\u0013!\u0005b\u00024\u0001#\u0003%Ia\u001a\u0005\u0006\u0007\u0002!IA\u001d\u0002\u001a\u0005\u0006\u001c\u0018nY*uCR\u001cXi\u001d;j[\u0006$\u0018n\u001c8Tk&$XM\u0003\u0002\u000e\u001d\u0005y1\u000f^1ug\u0016\u001bH/[7bi&|gN\u0003\u0002\u0010!\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\u0012%\u0005\u00191/\u001d7\u000b\u0005M!\u0012!B:qCJ\\'BA\u000b\u0017\u0003\u0019\t\u0007/Y2iK*\tq#A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u00015y!\u0003CA\u000e\u001d\u001b\u0005\u0011\u0012BA\u000f\u0013\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u0011qDI\u0007\u0002A)\u0011\u0011ED\u0001\u0006a2\fgn]\u0005\u0003G\u0001\u0012\u0001\u0002\u00157b]R+7\u000f\u001e\t\u0003K\u0019j\u0011\u0001D\u0005\u0003O1\u0011qc\u0015;biN,5\u000f^5nCRLwN\u001c+fgR\u0014\u0015m]3\u0002\rqJg.\u001b;?)\u0005Q\u0003CA\u0013\u0001\u0003%\tG\u000f\u001e:jEV$X-F\u0001.!\tq\u0013'D\u00010\u0015\t\u0001d\"A\u0006fqB\u0014Xm]:j_:\u001c\u0018B\u0001\u001a0\u0005I\tE\u000f\u001e:jEV$XMU3gKJ,gnY3\u0002\u0015\u0005$HO]5ckR,\u0007%A\u0004d_2\u001cF/\u0019;\u0016\u0003Y\u0002\"a\u000e\u001e\u000e\u0003aR!!\u000f\u0011\u0002\u000f1|w-[2bY&\u00111\b\u000f\u0002\u000b\u0007>dW/\u001c8Ti\u0006$\u0018\u0001C2pYN#\u0018\r\u001e\u0011\u0002\tAd\u0017M\\\u000b\u0002\u007fA\u0011Q\u0005Q\u0005\u0003\u00032\u0011Qb\u0015;biN$Vm\u001d;QY\u0006t\u0017!\u00029mC:\u0004\u0013AC2iK\u000e\\7\u000b^1ugR)QiS(U-B\u0011a)S\u0007\u0002\u000f*\t\u0001*A\u0003tG\u0006d\u0017-\u0003\u0002K\u000f\n!QK\\5u\u0011\u0015i\u0004\u00021\u0001M!\t9T*\u0003\u0002Oq\tYAj\\4jG\u0006d\u0007\u000b\\1o\u0011\u0015\u0001\u0006\u00021\u0001R\u0003I)\u0007\u0010]3di\u0016$7\u000b^1ug\u000e\u0013wn\u00148\u0011\u0005]\u0012\u0016BA*9\u0005)\u0019F/\u0019;jgRL7m\u001d\u0005\u0006+\"\u0001\r!U\u0001\u0014Kb\u0004Xm\u0019;fIN#\u0018\r^:DE>|eM\u001a\u0005\b/\"\u0001\n\u00111\u0001Y\u00031)\u0007\u0010\u001e:b\u0007>tg-[4t!\u0011I\u0006mY2\u000f\u0005is\u0006CA.H\u001b\u0005a&BA/\u0019\u0003\u0019a$o\\8u}%\u0011qlR\u0001\u0007!J,G-\u001a4\n\u0005\u0005\u0014'aA'ba*\u0011ql\u0012\t\u00033\u0012L!!\u001a2\u0003\rM#(/\u001b8h\u0003Q\u0019\u0007.Z2l'R\fGo\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\t\u0001N\u000b\u0002YS.\n!\u000e\u0005\u0002la6\tAN\u0003\u0002n]\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003_\u001e\u000b!\"\u00198o_R\fG/[8o\u0013\t\tHNA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016$2!R:u\u0011\u0015i$\u00021\u0001M\u0011\u0015)(\u00021\u0001R\u00035)\u0007\u0010]3di\u0016$7\u000b^1ug\u0002")
public class BasicStatsEstimationSuite
extends SparkFunSuite
implements PlanTest,
StatsEstimationTestBase {
    private final AttributeReference attribute;
    private final ColumnStat colStat;
    private final StatsTestPlan plan;
    private boolean originalCBOValue;
    private boolean originalPlanStatsValue;
    private String sparkHome;
    private volatile boolean bitmap$0;

    @Override
    public /* synthetic */ void org$apache$spark$sql$catalyst$statsEstimation$StatsEstimationTestBase$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$catalyst$statsEstimation$StatsEstimationTestBase$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public void beforeAll() {
        StatsEstimationTestBase.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        StatsEstimationTestBase.afterAll$(this);
    }

    @Override
    public long getColSize(Attribute attribute, ColumnStat colStat) {
        return StatsEstimationTestBase.getColSize$(this, attribute, colStat);
    }

    @Override
    public AttributeReference attr(String colName) {
        return StatsEstimationTestBase.attr$(this, colName);
    }

    @Override
    public AttributeMap<ColumnStat> toAttributeMap(Seq<Tuple2<String, ColumnStat>> colStats, LogicalPlan plan) {
        return StatsEstimationTestBase.toAttributeMap$(this, colStats, plan);
    }

    @Override
    public ColumnStat rangeColumnStat(int distinctCount, int nullCount) {
        return StatsEstimationTestBase.rangeColumnStat$(this, distinctCount, nullCount);
    }

    @Override
    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$(this, plan);
    }

    @Override
    public LogicalPlan rewriteNameFromAttrNullability(LogicalPlan plan) {
        return PlanTestBase.rewriteNameFromAttrNullability$(this, plan);
    }

    @Override
    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$(this, plan);
    }

    @Override
    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public boolean comparePlans$default$3() {
        return PlanTestBase.comparePlans$default$3$(this);
    }

    @Override
    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$(this, e1, e2);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$(this, pairs, f);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression buildBalancedPredicate(Seq<Expression> expressions, Function2<Expression, Expression, Expression> op) {
        return PredicateHelper.buildBalancedPredicate$((PredicateHelper)this, expressions, op);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public boolean isNullIntolerant(Expression expr) {
        return PredicateHelper.isNullIntolerant$((PredicateHelper)this, (Expression)expr);
    }

    public Seq<Attribute> outputWithNullability(Seq<Attribute> output, Seq<ExprId> nonNullAttrExprIds) {
        return PredicateHelper.outputWithNullability$((PredicateHelper)this, output, nonNullAttrExprIds);
    }

    public boolean isLikelySelective(Expression e) {
        return PredicateHelper.isLikelySelective$((PredicateHelper)this, (Expression)e);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Seq<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    @Override
    public boolean originalCBOValue() {
        return this.originalCBOValue;
    }

    @Override
    public void originalCBOValue_$eq(boolean x$1) {
        this.originalCBOValue = x$1;
    }

    @Override
    public boolean originalPlanStatsValue() {
        return this.originalPlanStatsValue;
    }

    @Override
    public void originalPlanStatsValue_$eq(boolean x$1) {
        this.originalPlanStatsValue = x$1;
    }

    private String sparkHome$lzycompute() {
        BasicStatsEstimationSuite basicStatsEstimationSuite = this;
        synchronized (basicStatsEstimationSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        if (!this.bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return this.sparkHome;
    }

    public AttributeReference attribute() {
        return this.attribute;
    }

    public ColumnStat colStat() {
        return this.colStat;
    }

    public StatsTestPlan plan() {
        return this.plan;
    }

    private void checkStats(LogicalPlan plan, Statistics expectedStatsCboOn, Statistics expectedStatsCboOff, Map<String, String> extraConfigs) {
        Seq cboEnabledConfig = (Seq)((TraversableLike)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CBO_ENABLED().key()), (Object)"true"), (List)Nil$.MODULE$)).$plus$plus((GenTraversableOnce)extraConfigs.toSeq(), Seq$.MODULE$.canBuildFrom());
        this.withSQLConf((Seq<Tuple2<String, String>>)cboEnabledConfig, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            plan.invalidateStatsCache();
            Statistics $org_scalatest_assert_macro_left = plan.stats();
            Statistics $org_scalatest_assert_macro_right = expectedStatsCboOn;
            Statistics statistics = $org_scalatest_assert_macro_left;
            Statistics statistics2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(statistics != null ? !statistics.equals(statistics2) : statistics2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicStatsEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 360));
        });
        Seq cboDisabledConfig = (Seq)((TraversableLike)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CBO_ENABLED().key()), (Object)"false"), (List)Nil$.MODULE$)).$plus$plus((GenTraversableOnce)extraConfigs.toSeq(), Seq$.MODULE$.canBuildFrom());
        this.withSQLConf((Seq<Tuple2<String, String>>)cboDisabledConfig, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            plan.invalidateStatsCache();
            Statistics $org_scalatest_assert_macro_left = plan.stats();
            Statistics $org_scalatest_assert_macro_right = expectedStatsCboOff;
            Statistics statistics = $org_scalatest_assert_macro_left;
            Statistics statistics2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(statistics != null ? !statistics.equals(statistics2) : statistics2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicStatsEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 365));
        });
    }

    private void checkStats(LogicalPlan plan, Statistics expectedStats) {
        this.checkStats(plan, expectedStats, expectedStats, this.checkStats$default$4());
    }

    private Map<String, String> checkStats$default$4() {
        return Predef$.MODULE$.Map().empty();
    }

    public static final /* synthetic */ void $anonfun$new$19(BasicStatsEstimationSuite $this, LogicalPlan rep) {
        Statistics expectedStats = new Statistics((BigInt)$this.plan().size().get(), (Option)new Some((Object)$this.plan().rowCount()), $this.plan().attributeStats(), Statistics$.MODULE$.apply$default$4());
        $this.checkStats(rep, expectedStats, expectedStats, $this.checkStats$default$4());
    }

    public BasicStatsEstimationSuite() {
        AliasHelper.$init$((AliasHelper)this);
        PredicateHelper.$init$((PredicateHelper)this);
        SQLHelper.$init$(this);
        SQLConfHelper.$init$((SQLConfHelper)this);
        PlanTestBase.$init$(this);
        StatsEstimationTestBase.$init$(this);
        this.attribute = this.attr("key");
        this.colStat = new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(10)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)10)), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8());
        Seq x$1 = (Seq)new .colon.colon((Object)this.attribute(), (List)Nil$.MODULE$);
        AttributeMap x$2 = AttributeMap$.MODULE$.apply((Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.attribute()), (Object)this.colStat()), (List)Nil$.MODULE$));
        BigInt x$3 = BigInt$.MODULE$.int2bigInt(10);
        Some x$4 = new Some((Object)BigInt$.MODULE$.int2bigInt(120));
        this.plan = new StatsTestPlan((Seq<Attribute>)x$1, x$3, (AttributeMap<ColumnStat>)x$2, (Option<BigInt>)x$4);
        this.test("range with positive step", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Range range = new Range(1L, 5L, 1L, (Option)None$.MODULE$, Range$.MODULE$.apply$default$5(), Range$.MODULE$.apply$default$6());
            HistogramBin[] histogramBins = (HistogramBin[])((Object[])new HistogramBin[]{new HistogramBin(1.0, 2.0, 2L), new HistogramBin(2.0, 3.0, 1L), new HistogramBin(3.0, 4.0, 1L)});
            Some histogram = new Some((Object)new Histogram((double)4 / (double)3, histogramBins));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(range.numElements());
            int $org_scalatest_assert_macro_right = 4;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicStatsEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
            Statistics rangeStats = new Statistics(BigInt$.MODULE$.int2bigInt(32), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(4)), AttributeMap$.MODULE$.apply((Seq)range.output().map((Function1 & Serializable & scala.Serializable)attr -> {
                Some x$5 = new Some((Object)BigInt$.MODULE$.int2bigInt(4));
                Some x$6 = new Some((Object)BoxesRunTime.boxToInteger((int)1));
                Some x$7 = new Some((Object)BoxesRunTime.boxToInteger((int)4));
                Some x$8 = new Some((Object)BigInt$.MODULE$.int2bigInt(0));
                Some x$9 = new Some((Object)BoxesRunTime.boxToLong((long)LongType$.MODULE$.defaultSize()));
                Some x$10 = new Some((Object)BoxesRunTime.boxToLong((long)LongType$.MODULE$.defaultSize()));
                Some x$11 = histogram;
                int x$12 = ColumnStat$.MODULE$.apply$default$8();
                return new Tuple2(attr, (Object)new ColumnStat((Option)x$5, (Option)x$6, (Option)x$7, (Option)x$8, (Option)x$10, (Option)x$9, (Option)x$11, x$12));
            }, Seq$.MODULE$.canBuildFrom())), Statistics$.MODULE$.apply$default$4());
            Map extraConfig = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.HISTOGRAM_ENABLED().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.HISTOGRAM_NUM_BINS().key()), (Object)"3")}));
            this.checkStats((LogicalPlan)range, rangeStats, rangeStats, (Map<String, String>)extraConfig);
        }, new Position("BasicStatsEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
        this.test("range with positive step where end minus start not divisible by step", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Range range = new Range(-4L, 5L, 2L, (Option)None$.MODULE$, Range$.MODULE$.apply$default$5(), Range$.MODULE$.apply$default$6());
            HistogramBin[] histogramBins = (HistogramBin[])((Object[])new HistogramBin[]{new HistogramBin(-4.0, -2.0, 2L), new HistogramBin(-2.0, 2.0, 2L), new HistogramBin(2.0, 4.0, 1L)});
            Some histogram = new Some((Object)new Histogram((double)5 / (double)3, histogramBins));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(range.numElements());
            int $org_scalatest_assert_macro_right = 5;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicStatsEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
            Statistics rangeStats = new Statistics(BigInt$.MODULE$.int2bigInt(40), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(5)), AttributeMap$.MODULE$.apply((Seq)range.output().map((Function1 & Serializable & scala.Serializable)attr -> {
                Some x$13 = new Some((Object)BigInt$.MODULE$.int2bigInt(5));
                Some x$14 = new Some((Object)BoxesRunTime.boxToInteger((int)-4));
                Some x$15 = new Some((Object)BoxesRunTime.boxToInteger((int)4));
                Some x$16 = new Some((Object)BigInt$.MODULE$.int2bigInt(0));
                Some x$17 = new Some((Object)BoxesRunTime.boxToLong((long)LongType$.MODULE$.defaultSize()));
                Some x$18 = new Some((Object)BoxesRunTime.boxToLong((long)LongType$.MODULE$.defaultSize()));
                Some x$19 = histogram;
                int x$20 = ColumnStat$.MODULE$.apply$default$8();
                return new Tuple2(attr, (Object)new ColumnStat((Option)x$13, (Option)x$14, (Option)x$15, (Option)x$16, (Option)x$18, (Option)x$17, (Option)x$19, x$20));
            }, Seq$.MODULE$.canBuildFrom())), Statistics$.MODULE$.apply$default$4());
            Map extraConfig = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.HISTOGRAM_ENABLED().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.HISTOGRAM_NUM_BINS().key()), (Object)"3")}));
            this.checkStats((LogicalPlan)range, rangeStats, rangeStats, (Map<String, String>)extraConfig);
        }, new Position("BasicStatsEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
        this.test("range with negative step", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Range range = new Range(-10L, -20L, -2L, (Option)None$.MODULE$, Range$.MODULE$.apply$default$5(), Range$.MODULE$.apply$default$6());
            HistogramBin[] histogramBins = (HistogramBin[])((Object[])new HistogramBin[]{new HistogramBin(-18.0, -16.0, 2L), new HistogramBin(-16.0, -12.0, 2L), new HistogramBin(-12.0, -10.0, 1L)});
            Some histogram = new Some((Object)new Histogram((double)5 / (double)3, histogramBins));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(range.numElements());
            int $org_scalatest_assert_macro_right = 5;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicStatsEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
            Statistics rangeStats = new Statistics(BigInt$.MODULE$.int2bigInt(40), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(5)), AttributeMap$.MODULE$.apply((Seq)range.output().map((Function1 & Serializable & scala.Serializable)attr -> {
                Some x$21 = new Some((Object)BigInt$.MODULE$.int2bigInt(5));
                Some x$22 = new Some((Object)BoxesRunTime.boxToInteger((int)-18));
                Some x$23 = new Some((Object)BoxesRunTime.boxToInteger((int)-10));
                Some x$24 = new Some((Object)BigInt$.MODULE$.int2bigInt(0));
                Some x$25 = new Some((Object)BoxesRunTime.boxToLong((long)LongType$.MODULE$.defaultSize()));
                Some x$26 = new Some((Object)BoxesRunTime.boxToLong((long)LongType$.MODULE$.defaultSize()));
                Some x$27 = histogram;
                int x$28 = ColumnStat$.MODULE$.apply$default$8();
                return new Tuple2(attr, (Object)new ColumnStat((Option)x$21, (Option)x$22, (Option)x$23, (Option)x$24, (Option)x$26, (Option)x$25, (Option)x$27, x$28));
            }, Seq$.MODULE$.canBuildFrom())), Statistics$.MODULE$.apply$default$4());
            Map extraConfig = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.HISTOGRAM_ENABLED().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.HISTOGRAM_NUM_BINS().key()), (Object)"3")}));
            this.checkStats((LogicalPlan)range, rangeStats, rangeStats, (Map<String, String>)extraConfig);
        }, new Position("BasicStatsEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
        this.test("range with negative step where end minus start not divisible by step", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Range range = new Range(-10L, -20L, -3L, (Option)None$.MODULE$, Range$.MODULE$.apply$default$5(), Range$.MODULE$.apply$default$6());
            HistogramBin[] histogramBins = (HistogramBin[])((Object[])new HistogramBin[]{new HistogramBin(-19.0, -16.0, 2L), new HistogramBin(-16.0, -13.0, 1L), new HistogramBin(-13.0, -10.0, 1L)});
            Some histogram = new Some((Object)new Histogram((double)4 / (double)3, histogramBins));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(range.numElements());
            int $org_scalatest_assert_macro_right = 4;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicStatsEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
            Statistics rangeStats = new Statistics(BigInt$.MODULE$.int2bigInt(32), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(4)), AttributeMap$.MODULE$.apply((Seq)range.output().map((Function1 & Serializable & scala.Serializable)attr -> {
                Some x$29 = new Some((Object)BigInt$.MODULE$.int2bigInt(4));
                Some x$30 = new Some((Object)BoxesRunTime.boxToInteger((int)-19));
                Some x$31 = new Some((Object)BoxesRunTime.boxToInteger((int)-10));
                Some x$32 = new Some((Object)BigInt$.MODULE$.int2bigInt(0));
                Some x$33 = new Some((Object)BoxesRunTime.boxToLong((long)LongType$.MODULE$.defaultSize()));
                Some x$34 = new Some((Object)BoxesRunTime.boxToLong((long)LongType$.MODULE$.defaultSize()));
                Some x$35 = histogram;
                int x$36 = ColumnStat$.MODULE$.apply$default$8();
                return new Tuple2(attr, (Object)new ColumnStat((Option)x$29, (Option)x$30, (Option)x$31, (Option)x$32, (Option)x$34, (Option)x$33, (Option)x$35, x$36));
            }, Seq$.MODULE$.canBuildFrom())), Statistics$.MODULE$.apply$default$4());
            Map extraConfig = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.HISTOGRAM_ENABLED().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.HISTOGRAM_NUM_BINS().key()), (Object)"3")}));
            this.checkStats((LogicalPlan)range, rangeStats, rangeStats, (Map<String, String>)extraConfig);
        }, new Position("BasicStatsEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
        this.test("range with empty output", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Range range = new Range(-10L, -10L, -1L, (Option)None$.MODULE$, Range$.MODULE$.apply$default$5(), Range$.MODULE$.apply$default$6());
            Statistics rangeStats = new Statistics(BigInt$.MODULE$.int2bigInt(0), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), Statistics$.MODULE$.apply$default$3(), Statistics$.MODULE$.apply$default$4());
            Map extraConfig = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.HISTOGRAM_ENABLED().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.HISTOGRAM_NUM_BINS().key()), (Object)"3")}));
            this.checkStats((LogicalPlan)range, rangeStats, rangeStats, (Map<String, String>)extraConfig);
        }, new Position("BasicStatsEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
        this.test("windows", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan windows = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.plan()).window((Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.min((Expression)this.attribute(), package.expressions$.MODULE$.min$default$2())).as((Symbol)SymbolLiteral.bootstrap("apply", "sum_attr")), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)this.attribute(), (List)Nil$.MODULE$), (Seq)Nil$.MODULE$);
            Statistics windowsStats = new Statistics(((BigInt)this.plan().size().get()).$times(BigInt$.MODULE$.int2bigInt(16)).$div(BigInt$.MODULE$.int2bigInt(12)), Statistics$.MODULE$.apply$default$2(), Statistics$.MODULE$.apply$default$3(), Statistics$.MODULE$.apply$default$4());
            this.checkStats(windows, windowsStats, windowsStats, this.checkStats$default$4());
        }, new Position("BasicStatsEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
        this.test("limit estimation: limit < child's rowCount", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LocalLimit localLimit = new LocalLimit((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2)), (LogicalPlan)this.plan());
            GlobalLimit globalLimit = new GlobalLimit((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2)), (LogicalPlan)this.plan());
            Statistics qual$1 = this.plan().stats();
            AttributeMap x$37 = AttributeMap$.MODULE$.apply((Seq)Nil$.MODULE$);
            BigInt x$38 = qual$1.copy$default$1();
            Option x$39 = qual$1.copy$default$2();
            boolean x$40 = qual$1.copy$default$4();
            this.checkStats((LogicalPlan)localLimit, qual$1.copy(x$38, x$39, x$37, x$40));
            this.checkStats((LogicalPlan)globalLimit, new Statistics(BigInt$.MODULE$.int2bigInt(24), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(2)), Statistics$.MODULE$.apply$default$3(), Statistics$.MODULE$.apply$default$4()));
        }, new Position("BasicStatsEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 188));
        this.test("limit estimation: limit > child's rowCount", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LocalLimit localLimit = new LocalLimit((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)20)), (LogicalPlan)this.plan());
            GlobalLimit globalLimit = new GlobalLimit((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)20)), (LogicalPlan)this.plan());
            Statistics qual$2 = this.plan().stats();
            AttributeMap x$41 = AttributeMap$.MODULE$.apply((Seq)Nil$.MODULE$);
            BigInt x$42 = qual$2.copy$default$1();
            Option x$43 = qual$2.copy$default$2();
            boolean x$44 = qual$2.copy$default$4();
            this.checkStats((LogicalPlan)localLimit, qual$2.copy(x$42, x$43, x$41, x$44));
            Statistics qual$3 = this.plan().stats();
            AttributeMap x$45 = AttributeMap$.MODULE$.apply((Seq)Nil$.MODULE$);
            BigInt x$46 = qual$3.copy$default$1();
            Option x$47 = qual$3.copy$default$2();
            boolean x$48 = qual$3.copy$default$4();
            this.checkStats((LogicalPlan)globalLimit, qual$3.copy(x$46, x$47, x$45, x$48));
        }, new Position("BasicStatsEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
        this.test("limit estimation: limit = 0", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LocalLimit localLimit = new LocalLimit((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0)), (LogicalPlan)this.plan());
            GlobalLimit globalLimit = new GlobalLimit((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0)), (LogicalPlan)this.plan());
            Statistics stats = new Statistics(BigInt$.MODULE$.int2bigInt(1), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), Statistics$.MODULE$.apply$default$3(), Statistics$.MODULE$.apply$default$4());
            this.checkStats((LogicalPlan)localLimit, stats);
            this.checkStats((LogicalPlan)globalLimit, stats);
        }, new Position("BasicStatsEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 204));
        this.test("tail estimation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkStats((LogicalPlan)new Tail((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), (LogicalPlan)this.plan()), new Statistics(BigInt$.MODULE$.int2bigInt(12), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(1)), Statistics$.MODULE$.apply$default$3(), Statistics$.MODULE$.apply$default$4()));
            Statistics qual$4 = this.plan().stats();
            AttributeMap x$49 = AttributeMap$.MODULE$.apply((Seq)Nil$.MODULE$);
            BigInt x$50 = qual$4.copy$default$1();
            Option x$51 = qual$4.copy$default$2();
            boolean x$52 = qual$4.copy$default$4();
            this.checkStats((LogicalPlan)new Tail((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)20)), (LogicalPlan)this.plan()), qual$4.copy(x$50, x$51, x$49, x$52));
            this.checkStats((LogicalPlan)new Tail((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0)), (LogicalPlan)this.plan()), new Statistics(BigInt$.MODULE$.int2bigInt(1), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), Statistics$.MODULE$.apply$default$3(), Statistics$.MODULE$.apply$default$4()));
        }, new Position("BasicStatsEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 212));
        this.test("sample estimation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Sample sample = new Sample(0.0, 0.5, false, (long)(package$.MODULE$.random() * (double)1000), (LogicalPlan)this.plan());
            this.checkStats((LogicalPlan)sample, new Statistics(BigInt$.MODULE$.int2bigInt(60), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(5)), Statistics$.MODULE$.apply$default$3(), Statistics$.MODULE$.apply$default$4()));
            Statistics childStats = new Statistics(BigInt$.MODULE$.int2bigInt(120), Statistics$.MODULE$.apply$default$2(), Statistics$.MODULE$.apply$default$3(), Statistics$.MODULE$.apply$default$4());
            DummyLogicalPlan childPlan = new DummyLogicalPlan(childStats, childStats);
            Sample sample2 = new Sample(0.0, 0.11, false, (long)(package$.MODULE$.random() * (double)1000), (LogicalPlan)childPlan);
            this.checkStats((LogicalPlan)sample2, new Statistics(BigInt$.MODULE$.int2bigInt(14), Statistics$.MODULE$.apply$default$2(), Statistics$.MODULE$.apply$default$3(), Statistics$.MODULE$.apply$default$4()));
        }, new Position("BasicStatsEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 218));
        this.test("estimate statistics when the conf changes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String x$53 = "c1";
            IntegerType$ x$54 = IntegerType$.MODULE$;
            boolean x$55 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$56 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$57 = AttributeReference$.MODULE$.apply$default$5(x$53, (DataType)x$54, x$55, x$56);
            Seq x$58 = AttributeReference$.MODULE$.apply$default$6(x$53, (DataType)x$54, x$55, x$56);
            Statistics expectedDefaultStats = new Statistics(BigInt$.MODULE$.int2bigInt(40), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(10)), AttributeMap$.MODULE$.apply((Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new AttributeReference(x$53, (DataType)x$54, x$55, x$56, x$57, x$58)), (Object)new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(10)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)10)), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8())), (List)Nil$.MODULE$)), Statistics$.MODULE$.apply$default$4());
            String x$59 = "c1";
            IntegerType$ x$60 = IntegerType$.MODULE$;
            boolean x$61 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$62 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$63 = AttributeReference$.MODULE$.apply$default$5(x$59, (DataType)x$60, x$61, x$62);
            Seq x$64 = AttributeReference$.MODULE$.apply$default$6(x$59, (DataType)x$60, x$61, x$62);
            Statistics expectedCboStats = new Statistics(BigInt$.MODULE$.int2bigInt(4), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(1)), AttributeMap$.MODULE$.apply((Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new AttributeReference(x$59, (DataType)x$60, x$61, x$62, x$63, x$64)), (Object)new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(10)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)5)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)5)), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8())), (List)Nil$.MODULE$)), Statistics$.MODULE$.apply$default$4());
            DummyLogicalPlan plan = new DummyLogicalPlan(expectedDefaultStats, expectedCboStats);
            this.checkStats(plan, expectedCboStats, expectedDefaultStats, this.checkStats$default$4());
        }, new Position("BasicStatsEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 230));
        this.test("command should report a dummy stats", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            CommentOnNamespace plan = new CommentOnNamespace((LogicalPlan)new ResolvedNamespace((CatalogPlugin)Mockito.mock(SupportsNamespaces.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ns"})), "comment");
            this.checkStats((LogicalPlan)plan, Statistics$.MODULE$.DUMMY(), Statistics$.MODULE$.DUMMY(), this.checkStats$default$4());
        }, new Position("BasicStatsEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 253));
        this.test("Improve Repartition statistics estimation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)RepartitionByExpression$.MODULE$.apply(this.plan().output(), (LogicalPlan)this.plan(), 10), (List)new .colon.colon((Object)new RepartitionByExpression((Seq)Nil$.MODULE$, (LogicalPlan)this.plan(), (Option)None$.MODULE$), (List)new .colon.colon((Object)package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.plan()).repartition(Predef$.MODULE$.int2Integer(2)), (List)new .colon.colon((Object)package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.plan()).coalesce(Predef$.MODULE$.int2Integer(3)), (List)new .colon.colon((Object)package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.plan()).rebalance((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.plan()).rebalance(this.plan().output()), (List)Nil$.MODULE$))))))).foreach((Function1 & Serializable & scala.Serializable)rep -> {
            BasicStatsEstimationSuite.$anonfun$new$19(this, rep);
            return BoxedUnit.UNIT;
        }), new Position("BasicStatsEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 262));
        this.test("SPARK-34031: Union operator missing rowCount when enable CBO", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            StatsTestPlan statsTestPlan = this.plan();
            StatsTestPlan statsTestPlan2 = this.plan();
            StatsTestPlan statsTestPlan3 = this.plan();
            Union union = new Union((Seq)Nil$.MODULE$.$colon$colon((Object)statsTestPlan3).$colon$colon((Object)statsTestPlan2).$colon$colon((Object)statsTestPlan), Union$.MODULE$.apply$default$2(), Union$.MODULE$.apply$default$3());
            int childrenSize = union.children().size();
            BigInt sizeInBytes = ((BigInt)this.plan().size().get()).$times(BigInt$.MODULE$.int2bigInt(childrenSize));
            Some rowCount = new Some((Object)this.plan().rowCount().$times(BigInt$.MODULE$.int2bigInt(childrenSize)));
            Some x$65 = new Some((Object)BoxesRunTime.boxToInteger((int)1));
            Some x$66 = new Some((Object)BoxesRunTime.boxToInteger((int)10));
            Some x$67 = new Some((Object)BigInt$.MODULE$.int2bigInt(0));
            Option x$68 = ColumnStat$.MODULE$.apply$default$1();
            Option x$69 = ColumnStat$.MODULE$.apply$default$5();
            Option x$70 = ColumnStat$.MODULE$.apply$default$6();
            Option x$71 = ColumnStat$.MODULE$.apply$default$7();
            int x$72 = ColumnStat$.MODULE$.apply$default$8();
            AttributeMap attributeStats = AttributeMap$.MODULE$.apply((Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.attribute()), (Object)new ColumnStat(x$68, (Option)x$65, (Option)x$66, (Option)x$67, x$69, x$70, x$71, x$72)), (List)Nil$.MODULE$));
            this.checkStats((LogicalPlan)union, new Statistics(sizeInBytes, (Option)rowCount, attributeStats, Statistics$.MODULE$.apply$default$4()), new Statistics(sizeInBytes, Statistics$.MODULE$.apply$default$2(), Statistics$.MODULE$.apply$default$3(), Statistics$.MODULE$.apply$default$4()), this.checkStats$default$4());
        }, new Position("BasicStatsEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 280));
        this.test("SPARK-34121: Intersect operator missing rowCount when enable CBO", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Intersect intersect = new Intersect((LogicalPlan)this.plan(), (LogicalPlan)this.plan(), false);
            BigInt sizeInBytes = (BigInt)this.plan().size().get();
            Some rowCount = new Some((Object)this.plan().rowCount());
            this.checkStats((LogicalPlan)intersect, new Statistics(sizeInBytes, (Option)rowCount, Statistics$.MODULE$.apply$default$3(), Statistics$.MODULE$.apply$default$4()), new Statistics(sizeInBytes, Statistics$.MODULE$.apply$default$2(), Statistics$.MODULE$.apply$default$3(), Statistics$.MODULE$.apply$default$4()), this.checkStats$default$4());
        }, new Position("BasicStatsEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 296));
        this.test("SPARK-35185: Improve Distinct statistics estimation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Distinct distinct = new Distinct((LogicalPlan)this.plan());
            BigInt sizeInBytes = (BigInt)this.plan().size().get();
            this.checkStats((LogicalPlan)distinct, new Statistics(sizeInBytes, (Option)new Some((Object)this.plan().rowCount()), this.plan().attributeStats(), Statistics$.MODULE$.apply$default$4()), new Statistics(sizeInBytes, Statistics$.MODULE$.apply$default$2(), Statistics$.MODULE$.apply$default$3(), Statistics$.MODULE$.apply$default$4()), this.checkStats$default$4());
        }, new Position("BasicStatsEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 306));
        this.test("row size and column stats estimation for sort", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String x$73 = "cbool";
            BooleanType$ x$74 = BooleanType$.MODULE$;
            boolean x$75 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$76 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$77 = AttributeReference$.MODULE$.apply$default$5(x$73, (DataType)x$74, x$75, x$76);
            Seq x$78 = AttributeReference$.MODULE$.apply$default$6(x$73, (DataType)x$74, x$75, x$76);
            String x$79 = "cbyte";
            ByteType$ x$80 = ByteType$.MODULE$;
            boolean x$81 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$82 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$83 = AttributeReference$.MODULE$.apply$default$5(x$79, (DataType)x$80, x$81, x$82);
            Seq x$84 = AttributeReference$.MODULE$.apply$default$6(x$79, (DataType)x$80, x$81, x$82);
            AttributeMap columnInfo = AttributeMap$.MODULE$.apply((Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new AttributeReference(x$73, (DataType)x$74, x$75, x$76, x$77, x$78)), (Object)new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(2)), (Option)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)), (Option)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)1L)), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8())), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new AttributeReference(x$79, (DataType)x$80, x$81, x$82, x$83, x$84)), (Object)new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(2)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)2)), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)1L)), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8())), (List)Nil$.MODULE$)));
            int expectedSize = 16;
            StatsTestPlan child = new StatsTestPlan((Seq<Attribute>)columnInfo.keys().toSeq(), BigInt$.MODULE$.int2bigInt(2), (AttributeMap<ColumnStat>)columnInfo, (Option<BigInt>)new Some((Object)BigInt$.MODULE$.int2bigInt(expectedSize)));
            SortOrder sortOrder = SortOrder$.MODULE$.apply((Expression)columnInfo.keys().head(), (SortDirection)Ascending$.MODULE$, SortOrder$.MODULE$.apply$default$3());
            Sort sort = new Sort((Seq)new .colon.colon((Object)sortOrder, (List)Nil$.MODULE$), true, (LogicalPlan)child);
            Statistics expectedSortStats = new Statistics(BigInt$.MODULE$.int2bigInt(expectedSize), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(2)), columnInfo, Statistics$.MODULE$.apply$default$4());
            this.checkStats((LogicalPlan)sort, expectedSortStats, new Statistics(BigInt$.MODULE$.int2bigInt(expectedSize), Statistics$.MODULE$.apply$default$2(), Statistics$.MODULE$.apply$default$3(), Statistics$.MODULE$.apply$default$4()), this.checkStats$default$4());
        }, new Position("BasicStatsEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 315));
    }
}

