/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.optimizer;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.Contains;
import org.apache.spark.sql.catalyst.expressions.EndsWith;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Length;
import org.apache.spark.sql.catalyst.expressions.LikeAny;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.Not;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.expressions.StartsWith;
import org.apache.spark.sql.catalyst.optimizer.LikeSimplificationSuite$Optimize$;
import org.apache.spark.sql.catalyst.plans.PlanTest;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001=3A!\u0003\u0006\u0001/!)!\u0005\u0001C\u0001G\u001d)a\u0005\u0001E\u0001O\u0019)\u0011\u0006\u0001E\u0001U!)!e\u0001C\u0001o!9\u0001h\u0001b\u0001\n\u0003I\u0004B\u0002%\u0004A\u0003%!\bC\u0004J\u0001\t\u0007I\u0011\u0001&\t\r9\u0003\u0001\u0015!\u0003L\u0005]a\u0015n[3TS6\u0004H.\u001b4jG\u0006$\u0018n\u001c8Tk&$XM\u0003\u0002\f\u0019\u0005Iq\u000e\u001d;j[&TXM\u001d\u0006\u0003\u001b9\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003\u001fA\t1a]9m\u0015\t\t\"#A\u0003ta\u0006\u00148N\u0003\u0002\u0014)\u00051\u0011\r]1dQ\u0016T\u0011!F\u0001\u0004_J<7\u0001A\n\u0004\u0001aa\u0002CA\r\u001b\u001b\u0005\u0001\u0012BA\u000e\u0011\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u0011Q\u0004I\u0007\u0002=)\u0011q\u0004D\u0001\u0006a2\fgn]\u0005\u0003Cy\u0011\u0001\u0002\u00157b]R+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0011\u0002\"!\n\u0001\u000e\u0003)\t\u0001b\u00149uS6L'0\u001a\t\u0003Q\ri\u0011\u0001\u0001\u0002\t\u001fB$\u0018.\\5{KN\u00111a\u000b\t\u0004Y=\nT\"A\u0017\u000b\u00059b\u0011!\u0002:vY\u0016\u001c\u0018B\u0001\u0019.\u00051\u0011V\u000f\\3Fq\u0016\u001cW\u000f^8s!\t\u0011T'D\u00014\u0015\t!d$A\u0004m_\u001eL7-\u00197\n\u0005Y\u001a$a\u0003'pO&\u001c\u0017\r\u001c)mC:$\u0012aJ\u0001\bE\u0006$8\r[3t+\u0005Q\u0004cA\u001eC\t6\tAH\u0003\u0002>}\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003\u007f\u0001\u000b!bY8mY\u0016\u001cG/[8o\u0015\u0005\t\u0015!B:dC2\f\u0017BA\"=\u0005\u0011a\u0015n\u001d;\u0011\u0005\u00153U\"A\u0002\n\u0005\u001d{#!\u0002\"bi\u000eD\u0017\u0001\u00032bi\u000eDWm\u001d\u0011\u0002\u0019Q,7\u000f\u001e*fY\u0006$\u0018n\u001c8\u0016\u0003-\u0003\"A\r'\n\u00055\u001b$!\u0004'pG\u0006d'+\u001a7bi&|g.A\u0007uKN$(+\u001a7bi&|g\u000e\t")
public class LikeSimplificationSuite
extends SparkFunSuite
implements PlanTest {
    private volatile LikeSimplificationSuite$Optimize$ Optimize$module;
    private final LocalRelation testRelation;
    private String sparkHome;
    private volatile boolean bitmap$0;

    @Override
    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$(this, plan);
    }

    @Override
    public LogicalPlan rewriteNameFromAttrNullability(LogicalPlan plan) {
        return PlanTestBase.rewriteNameFromAttrNullability$(this, plan);
    }

    @Override
    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$(this, plan);
    }

    @Override
    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public boolean comparePlans$default$3() {
        return PlanTestBase.comparePlans$default$3$(this);
    }

    @Override
    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$(this, e1, e2);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$(this, pairs, f);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression buildBalancedPredicate(Seq<Expression> expressions, Function2<Expression, Expression, Expression> op) {
        return PredicateHelper.buildBalancedPredicate$((PredicateHelper)this, expressions, op);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public boolean isNullIntolerant(Expression expr) {
        return PredicateHelper.isNullIntolerant$((PredicateHelper)this, (Expression)expr);
    }

    public Seq<Attribute> outputWithNullability(Seq<Attribute> output, Seq<ExprId> nonNullAttrExprIds) {
        return PredicateHelper.outputWithNullability$((PredicateHelper)this, output, nonNullAttrExprIds);
    }

    public boolean isLikelySelective(Expression e) {
        return PredicateHelper.isLikelySelective$((PredicateHelper)this, (Expression)e);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Seq<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    public LikeSimplificationSuite$Optimize$ Optimize() {
        if (this.Optimize$module == null) {
            this.Optimize$lzycompute$1();
        }
        return this.Optimize$module;
    }

    private String sparkHome$lzycompute() {
        LikeSimplificationSuite likeSimplificationSuite = this;
        synchronized (likeSimplificationSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        if (!this.bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return this.sparkHome;
    }

    public LocalRelation testRelation() {
        return this.testRelation;
    }

    private final void Optimize$lzycompute$1() {
        LikeSimplificationSuite likeSimplificationSuite = this;
        synchronized (likeSimplificationSuite) {
            if (this.Optimize$module == null) {
                this.Optimize$module = new LikeSimplificationSuite$Optimize$(this);
            }
        }
    }

    public LikeSimplificationSuite() {
        AliasHelper.$init$((AliasHelper)this);
        PredicateHelper.$init$((PredicateHelper)this);
        SQLHelper.$init$(this);
        SQLConfHelper.$init$((SQLConfHelper)this);
        PlanTestBase.$init$(this);
        this.testRelation = LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).string()}));
        this.test("simplify Like into StartsWith", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            package.ExpressionConversions.DslSymbol qual$1 = package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a"));
            Literal x$1 = package.expressions$.MODULE$.stringToLiteral("abc%");
            char x$2 = qual$1.like$default$2();
            package.ExpressionConversions.DslSymbol qual$2 = package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a"));
            Literal x$3 = package.expressions$.MODULE$.stringToLiteral("abc\\%");
            char x$4 = qual$2.like$default$2();
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslExpression(qual$1.like((Expression)x$1, x$2)).$bar$bar(qual$2.like((Expression)x$3, x$4)));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            package.ExpressionConversions.DslSymbol qual$3 = package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a"));
            Literal x$5 = package.expressions$.MODULE$.stringToLiteral("abc\\%");
            char x$6 = qual$3.like$default$2();
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)new StartsWith((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)package.expressions$.MODULE$.stringToLiteral("abc"))).$bar$bar(qual$3.like((Expression)x$5, x$6)))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("LikeSimplificationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
        this.test("simplify Like into EndsWith", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            package.ExpressionConversions.DslSymbol qual$4 = package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a"));
            Literal x$7 = package.expressions$.MODULE$.stringToLiteral("%xyz");
            char x$8 = qual$4.like$default$2();
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where(qual$4.like((Expression)x$7, x$8));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)new EndsWith((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)package.expressions$.MODULE$.stringToLiteral("xyz")))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("LikeSimplificationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
        this.test("simplify Like into startsWith and EndsWith", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            package.ExpressionConversions.DslSymbol qual$5 = package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a"));
            Literal x$9 = package.expressions$.MODULE$.stringToLiteral("abc\\%def");
            char x$10 = qual$5.like$default$2();
            package.ExpressionConversions.DslSymbol qual$6 = package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a"));
            Literal x$11 = package.expressions$.MODULE$.stringToLiteral("abc%def");
            char x$12 = qual$6.like$default$2();
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslExpression(qual$5.like((Expression)x$9, x$10)).$bar$bar(qual$6.like((Expression)x$11, x$12)));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            package.ExpressionConversions.DslSymbol qual$7 = package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a"));
            Literal x$13 = package.expressions$.MODULE$.stringToLiteral("abc\\%def");
            char x$14 = qual$7.like$default$2();
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslExpression(qual$7.like((Expression)x$13, x$14)).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)new Length((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")))).$greater$eq((Expression)package.expressions$.MODULE$.intToLiteral(6))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)new StartsWith((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)package.expressions$.MODULE$.stringToLiteral("abc"))).$amp$amp((Expression)new EndsWith((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)package.expressions$.MODULE$.stringToLiteral("def"))))))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("LikeSimplificationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
        this.test("simplify Like into Contains", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            package.ExpressionConversions.DslSymbol qual$8 = package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a"));
            Literal x$15 = package.expressions$.MODULE$.stringToLiteral("%mn%");
            char x$16 = qual$8.like$default$2();
            package.ExpressionConversions.DslSymbol qual$9 = package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a"));
            Literal x$17 = package.expressions$.MODULE$.stringToLiteral("%mn\\%");
            char x$18 = qual$9.like$default$2();
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslExpression(qual$8.like((Expression)x$15, x$16)).$bar$bar(qual$9.like((Expression)x$17, x$18)));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            package.ExpressionConversions.DslSymbol qual$10 = package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a"));
            Literal x$19 = package.expressions$.MODULE$.stringToLiteral("%mn\\%");
            char x$20 = qual$10.like$default$2();
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)new Contains((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)package.expressions$.MODULE$.stringToLiteral("mn"))).$bar$bar(qual$10.like((Expression)x$19, x$20)))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("LikeSimplificationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
        this.test("simplify Like into EqualTo", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            package.ExpressionConversions.DslSymbol qual$11 = package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a"));
            Literal x$21 = package.expressions$.MODULE$.stringToLiteral("");
            char x$22 = qual$11.like$default$2();
            package.ExpressionConversions.DslSymbol qual$12 = package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a"));
            Literal x$23 = package.expressions$.MODULE$.stringToLiteral("abc");
            char x$24 = qual$12.like$default$2();
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslExpression(qual$11.like((Expression)x$21, x$22)).$bar$bar(qual$12.like((Expression)x$23, x$24)));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq((Expression)package.expressions$.MODULE$.stringToLiteral(""))).$bar$bar((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq((Expression)package.expressions$.MODULE$.stringToLiteral("abc"))))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("LikeSimplificationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
        this.test("null pattern", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            package.ExpressionConversions.DslSymbol qual$13 = package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a"));
            Literal x$25 = new Literal(null, (DataType)StringType$.MODULE$);
            char x$26 = qual$13.like$default$2();
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where(qual$13.like((Expression)x$25, x$26))).analyze();
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)originalQuery);
            this.comparePlans(optimized, package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)new Literal(null, (DataType)BooleanType$.MODULE$))).analyze(), this.comparePlans$default$3());
        }, new Position("LikeSimplificationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
        this.test("test like escape syntax", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan originalQuery1 = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).like((Expression)package.expressions$.MODULE$.stringToLiteral("abc#%"), '#'));
            LogicalPlan optimized1 = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery1).analyze());
            this.comparePlans(optimized1, package.plans$.MODULE$.DslLogicalPlan(originalQuery1).analyze(), this.comparePlans$default$3());
            LogicalPlan originalQuery2 = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).like((Expression)package.expressions$.MODULE$.stringToLiteral("abc#%abc"), '#'));
            LogicalPlan optimized2 = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery2).analyze());
            this.comparePlans(optimized2, package.plans$.MODULE$.DslLogicalPlan(originalQuery2).analyze(), this.comparePlans$default$3());
        }, new Position("LikeSimplificationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
        this.test("SPARK-33677: LikeSimplification should be skipped if pattern contains any escapeChar", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            package.ExpressionConversions.DslSymbol qual$14 = package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a"));
            Literal x$27 = package.expressions$.MODULE$.stringToLiteral("abc%");
            char x$28 = qual$14.like$default$2();
            package.ExpressionConversions.DslSymbol qual$15 = package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a"));
            Literal x$29 = package.expressions$.MODULE$.stringToLiteral("\\abc%");
            char x$30 = qual$15.like$default$2();
            LogicalPlan originalQuery1 = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslExpression(qual$14.like((Expression)x$27, x$28)).$bar$bar(qual$15.like((Expression)x$29, x$30)));
            LogicalPlan optimized1 = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery1).analyze());
            package.ExpressionConversions.DslSymbol qual$16 = package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a"));
            Literal x$31 = package.expressions$.MODULE$.stringToLiteral("\\abc%");
            char x$32 = qual$16.like$default$2();
            LogicalPlan correctAnswer1 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)new StartsWith((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)package.expressions$.MODULE$.stringToLiteral("abc"))).$bar$bar(qual$16.like((Expression)x$31, x$32)))).analyze();
            this.comparePlans(optimized1, correctAnswer1, this.comparePlans$default$3());
            package.ExpressionConversions.DslSymbol qual$17 = package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a"));
            Literal x$33 = package.expressions$.MODULE$.stringToLiteral("%xyz");
            char x$34 = qual$17.like$default$2();
            package.ExpressionConversions.DslSymbol qual$18 = package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a"));
            Literal x$35 = package.expressions$.MODULE$.stringToLiteral("%xyz\\");
            char x$36 = qual$18.like$default$2();
            LogicalPlan originalQuery2 = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslExpression(qual$17.like((Expression)x$33, x$34)).$bar$bar(qual$18.like((Expression)x$35, x$36)));
            LogicalPlan optimized2 = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery2).analyze());
            package.ExpressionConversions.DslSymbol qual$19 = package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a"));
            Literal x$37 = package.expressions$.MODULE$.stringToLiteral("%xyz\\");
            char x$38 = qual$19.like$default$2();
            LogicalPlan correctAnswer2 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)new EndsWith((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)package.expressions$.MODULE$.stringToLiteral("xyz"))).$bar$bar(qual$19.like((Expression)x$37, x$38)))).analyze();
            this.comparePlans(optimized2, correctAnswer2, this.comparePlans$default$3());
            package.ExpressionConversions.DslSymbol qual$20 = package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a"));
            Literal x$39 = package.expressions$.MODULE$.stringToLiteral("abc%def");
            char x$40 = qual$20.like$default$2();
            LogicalPlan originalQuery3 = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).like((Expression)package.expressions$.MODULE$.stringToLiteral("@bc%def"), '@')).$bar$bar(qual$20.like((Expression)x$39, x$40)));
            LogicalPlan optimized3 = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery3).analyze());
            LogicalPlan correctAnswer3 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).like((Expression)package.expressions$.MODULE$.stringToLiteral("@bc%def"), '@')).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)new Length((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")))).$greater$eq((Expression)package.expressions$.MODULE$.intToLiteral(6))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)new StartsWith((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)package.expressions$.MODULE$.stringToLiteral("abc"))).$amp$amp((Expression)new EndsWith((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)package.expressions$.MODULE$.stringToLiteral("def"))))))).analyze();
            this.comparePlans(optimized3, correctAnswer3, this.comparePlans$default$3());
            package.ExpressionConversions.DslSymbol qual$21 = package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a"));
            Literal x$41 = package.expressions$.MODULE$.stringToLiteral("%mn%");
            char x$42 = qual$21.like$default$2();
            LogicalPlan originalQuery4 = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslExpression(qual$21.like((Expression)x$41, x$42)).$bar$bar(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).like((Expression)package.expressions$.MODULE$.stringToLiteral("%mn%"), '%')));
            LogicalPlan optimized4 = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery4).analyze());
            LogicalPlan correctAnswer4 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)new Contains((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)package.expressions$.MODULE$.stringToLiteral("mn"))).$bar$bar(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).like((Expression)package.expressions$.MODULE$.stringToLiteral("%mn%"), '%')))).analyze();
            this.comparePlans(optimized4, correctAnswer4, this.comparePlans$default$3());
            package.ExpressionConversions.DslSymbol qual$22 = package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a"));
            Literal x$43 = package.expressions$.MODULE$.stringToLiteral("abc");
            char x$44 = qual$22.like$default$2();
            LogicalPlan originalQuery5 = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslExpression(qual$22.like((Expression)x$43, x$44)).$bar$bar(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).like((Expression)package.expressions$.MODULE$.stringToLiteral("abbc"), 'b')));
            LogicalPlan optimized5 = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery5).analyze());
            LogicalPlan correctAnswer5 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq((Expression)package.expressions$.MODULE$.stringToLiteral("abc"))).$bar$bar(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).like((Expression)package.expressions$.MODULE$.stringToLiteral("abbc"), 'b')))).analyze();
            this.comparePlans(optimized5, correctAnswer5, this.comparePlans$default$3());
        }, new Position("LikeSimplificationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
        this.test("simplify LikeAll", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).likeAll((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("abc%"), package.expressions$.MODULE$.stringToLiteral("abc\\%"), package.expressions$.MODULE$.stringToLiteral("%xyz"), package.expressions$.MODULE$.stringToLiteral("abc\\%def"), package.expressions$.MODULE$.stringToLiteral("abc%def"), package.expressions$.MODULE$.stringToLiteral("%mn%"), package.expressions$.MODULE$.stringToLiteral("%mn\\%"), package.expressions$.MODULE$.stringToLiteral(""), package.expressions$.MODULE$.stringToLiteral("abc")})));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)new StartsWith((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)package.expressions$.MODULE$.stringToLiteral("abc"))).$amp$amp((Expression)new EndsWith((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)package.expressions$.MODULE$.stringToLiteral("xyz")))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)new Length((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")))).$greater$eq((Expression)package.expressions$.MODULE$.intToLiteral(6))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)new StartsWith((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)package.expressions$.MODULE$.stringToLiteral("abc"))).$amp$amp((Expression)new EndsWith((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)package.expressions$.MODULE$.stringToLiteral("def")))))).$amp$amp((Expression)new Contains((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)package.expressions$.MODULE$.stringToLiteral("mn")))).$amp$amp((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq((Expression)package.expressions$.MODULE$.stringToLiteral("")))).$amp$amp((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq((Expression)package.expressions$.MODULE$.stringToLiteral("abc")))).$amp$amp(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).likeAll((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("abc\\%"), package.expressions$.MODULE$.stringToLiteral("abc\\%def"), package.expressions$.MODULE$.stringToLiteral("%mn\\%")}))))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("LikeSimplificationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169));
        this.test("simplify NotLikeAll", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).notLikeAll((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("abc%"), package.expressions$.MODULE$.stringToLiteral("abc\\%"), package.expressions$.MODULE$.stringToLiteral("%xyz"), package.expressions$.MODULE$.stringToLiteral("abc\\%def"), package.expressions$.MODULE$.stringToLiteral("abc%def"), package.expressions$.MODULE$.stringToLiteral("%mn%"), package.expressions$.MODULE$.stringToLiteral("%mn\\%"), package.expressions$.MODULE$.stringToLiteral(""), package.expressions$.MODULE$.stringToLiteral("abc")})));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)new Not((Expression)new StartsWith((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)package.expressions$.MODULE$.stringToLiteral("abc")))).$amp$amp((Expression)new Not((Expression)new EndsWith((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)package.expressions$.MODULE$.stringToLiteral("xyz"))))).$amp$amp((Expression)new Not((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)new Length((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")))).$greater$eq((Expression)package.expressions$.MODULE$.intToLiteral(6))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)new StartsWith((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)package.expressions$.MODULE$.stringToLiteral("abc"))).$amp$amp((Expression)new EndsWith((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)package.expressions$.MODULE$.stringToLiteral("def"))))))).$amp$amp((Expression)new Not((Expression)new Contains((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)package.expressions$.MODULE$.stringToLiteral("mn"))))).$amp$amp((Expression)new Not((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq((Expression)package.expressions$.MODULE$.stringToLiteral(""))))).$amp$amp((Expression)new Not((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq((Expression)package.expressions$.MODULE$.stringToLiteral("abc"))))).$amp$amp(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).notLikeAll((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("abc\\%"), package.expressions$.MODULE$.stringToLiteral("abc\\%def"), package.expressions$.MODULE$.stringToLiteral("%mn\\%")}))))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("LikeSimplificationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
        this.test("simplify LikeAny", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).likeAny((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("abc%"), package.expressions$.MODULE$.stringToLiteral("abc\\%"), package.expressions$.MODULE$.stringToLiteral("%xyz"), package.expressions$.MODULE$.stringToLiteral("abc\\%def"), package.expressions$.MODULE$.stringToLiteral("abc%def"), package.expressions$.MODULE$.stringToLiteral("%mn%"), package.expressions$.MODULE$.stringToLiteral("%mn\\%"), package.expressions$.MODULE$.stringToLiteral(""), package.expressions$.MODULE$.stringToLiteral("abc")})));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)new StartsWith((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)package.expressions$.MODULE$.stringToLiteral("abc"))).$bar$bar((Expression)new EndsWith((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)package.expressions$.MODULE$.stringToLiteral("xyz")))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)new Length((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")))).$greater$eq((Expression)package.expressions$.MODULE$.intToLiteral(6))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)new StartsWith((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)package.expressions$.MODULE$.stringToLiteral("abc"))).$amp$amp((Expression)new EndsWith((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)package.expressions$.MODULE$.stringToLiteral("def")))))).$bar$bar((Expression)new Contains((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)package.expressions$.MODULE$.stringToLiteral("mn")))).$bar$bar((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq((Expression)package.expressions$.MODULE$.stringToLiteral("")))).$bar$bar((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq((Expression)package.expressions$.MODULE$.stringToLiteral("abc")))).$bar$bar(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).likeAny((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("abc\\%"), package.expressions$.MODULE$.stringToLiteral("abc\\%def"), package.expressions$.MODULE$.stringToLiteral("%mn\\%")}))))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("LikeSimplificationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 203));
        this.test("simplify NotLikeAny", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).notLikeAny((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("abc%"), package.expressions$.MODULE$.stringToLiteral("abc\\%"), package.expressions$.MODULE$.stringToLiteral("%xyz"), package.expressions$.MODULE$.stringToLiteral("abc\\%def"), package.expressions$.MODULE$.stringToLiteral("abc%def"), package.expressions$.MODULE$.stringToLiteral("%mn%"), package.expressions$.MODULE$.stringToLiteral("%mn\\%"), package.expressions$.MODULE$.stringToLiteral(""), package.expressions$.MODULE$.stringToLiteral("abc")})));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)new Not((Expression)new StartsWith((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)package.expressions$.MODULE$.stringToLiteral("abc")))).$bar$bar((Expression)new Not((Expression)new EndsWith((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)package.expressions$.MODULE$.stringToLiteral("xyz"))))).$bar$bar((Expression)new Not((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)new Length((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")))).$greater$eq((Expression)package.expressions$.MODULE$.intToLiteral(6))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)new StartsWith((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)package.expressions$.MODULE$.stringToLiteral("abc"))).$amp$amp((Expression)new EndsWith((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)package.expressions$.MODULE$.stringToLiteral("def"))))))).$bar$bar((Expression)new Not((Expression)new Contains((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)package.expressions$.MODULE$.stringToLiteral("mn"))))).$bar$bar((Expression)new Not((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq((Expression)package.expressions$.MODULE$.stringToLiteral(""))))).$bar$bar((Expression)new Not((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq((Expression)package.expressions$.MODULE$.stringToLiteral("abc"))))).$bar$bar(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).notLikeAny((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("abc\\%"), package.expressions$.MODULE$.stringToLiteral("abc\\%def"), package.expressions$.MODULE$.stringToLiteral("%mn\\%")}))))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("LikeSimplificationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 220));
        this.test("SPARK-40228: Simplify multiLike if child is foldable expression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.comparePlans((LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where(package.expressions$.MODULE$.DslString("a").likeAny((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("abc%"), package.expressions$.MODULE$.stringToLiteral(""), package.expressions$.MODULE$.stringToLiteral("ab")})))).analyze()), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)new StartsWith((Expression)package.expressions$.MODULE$.stringToLiteral("a"), (Expression)package.expressions$.MODULE$.stringToLiteral("abc"))).$bar$bar((Expression)new EqualTo((Expression)package.expressions$.MODULE$.stringToLiteral("a"), (Expression)package.expressions$.MODULE$.stringToLiteral("")))).$bar$bar((Expression)new EqualTo((Expression)package.expressions$.MODULE$.stringToLiteral("a"), (Expression)package.expressions$.MODULE$.stringToLiteral("ab")))).$bar$bar((Expression)new LikeAny((Expression)package.expressions$.MODULE$.stringToLiteral("a"), (Seq)Nil$.MODULE$)))).analyze(), this.comparePlans$default$3()), new Position("LikeSimplificationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 237));
        this.test("SPARK-40228: Do not simplify multiLike if child is not a cheap expression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where(package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).substring((Expression)package.expressions$.MODULE$.intToLiteral(1), (Expression)package.expressions$.MODULE$.intToLiteral(5))).likeAny((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("abc%"), package.expressions$.MODULE$.stringToLiteral(""), package.expressions$.MODULE$.stringToLiteral("ab")})))).analyze();
            this.comparePlans((LogicalPlan)this.Optimize().execute((TreeNode)originalQuery), originalQuery, this.comparePlans$default$3());
        }, new Position("LikeSimplificationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 243));
    }
}

