/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.dsl.package$expressions$;
import org.apache.spark.sql.catalyst.expressions.AggregateWindowFunction;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NthValue$;
import org.apache.spark.sql.catalyst.expressions.OffsetWindowFunction;
import org.apache.spark.sql.catalyst.expressions.SpecifiedWindowFrame;
import org.apache.spark.sql.catalyst.expressions.UnspecifiedFrame$;
import org.apache.spark.sql.catalyst.expressions.WindowFrame;
import org.apache.spark.sql.catalyst.trees.BinaryLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnyDataType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple3;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@ExpressionDescription(usage="\n    _FUNC_(input[, offset]) - Returns the value of `input` at the row that is the `offset`th row\n      from beginning of the window frame. Offset starts at 1. If ignoreNulls=true, we will skip\n      nulls when finding the `offset`th row. Otherwise, every row counts for the `offset`. If\n      there is no such an `offset`th row (e.g., when the offset is 10, size of the window frame\n      is less than 10), null is returned.\n  ", examples="\n    Examples:\n      > SELECT a, b, _FUNC_(b, 2) OVER (PARTITION BY a ORDER BY b) FROM VALUES ('A1', 2), ('A1', 1), ('A2', 3), ('A1', 1) tab(a, b);\n       A1\t1\t1\n       A1\t1\t1\n       A1\t2\t1\n       A2\t3\tNULL\n  ", arguments="\n    Arguments:\n      * input - the target column or expression that the function operates on.\n      * offset - a positive int literal to indicate the offset in the window frame. It starts\n          with 1.\n      * ignoreNulls - an optional specification that indicates the NthValue should skip null\n          values in the determination of which row to use.\n  ", since="3.1.0", group="window_funcs")
@ScalaSignature(bytes="\u0006\u0001\tUc\u0001\u0002\u0017.\u0001jB\u0001b\u0016\u0001\u0003\u0016\u0004%\t\u0001\u0017\u0005\t3\u0002\u0011\t\u0012)A\u0005\u0017\"A!\f\u0001BK\u0002\u0013\u0005\u0001\f\u0003\u0005\\\u0001\tE\t\u0015!\u0003L\u0011!a\u0006A!f\u0001\n\u0003i\u0006\u0002C1\u0001\u0005#\u0005\u000b\u0011\u00020\t\u000b\t\u0004A\u0011A2\t\u000b\t\u0004A\u0011\u00015\t\u00111\u0004\u0001R1A\u0005B5DQ!\u001d\u0001\u0005BaCQA\u001d\u0001\u0005BaCqa\u001d\u0001C\u0002\u0013\u0005C\u000f\u0003\u0004y\u0001\u0001\u0006I!\u001e\u0005\u0006s\u0002!\tE\u001f\u0005\b\u0003\u0007\u0001A\u0011IA\u0003\u0011\u001d\t)\u0003\u0001C!\u0003OA!\"!\u000e\u0001\u0011\u000b\u0007I\u0011BA\u001c\u0011)\ty\u0004\u0001EC\u0002\u0013%\u0011\u0011\t\u0005\u000b\u0003\u0013\u0002\u0001R1A\u0005\n\u0005\u0005\u0003BCA&\u0001!\u0015\r\u0011\"\u0011\u0002N!Q\u0011\u0011\u000b\u0001\t\u0006\u0004%\t%a\u0015\t\u0015\u0005]\u0003\u0001#b\u0001\n\u0003\nI\u0006\u0003\u0006\u0002^\u0001A)\u0019!C!\u0003\u0003Bq!a\u0018\u0001\t\u0003\n\t\u0007\u0003\u00043\u0001\u0011\u0005\u0013\u0011\r\u0005\b\u0003g\u0002A\u0011KA;\u0011%\ty\bAA\u0001\n\u0003\t\t\tC\u0005\u0002\n\u0002\t\n\u0011\"\u0001\u0002\f\"I\u0011\u0011\u0015\u0001\u0012\u0002\u0013\u0005\u00111\u0012\u0005\n\u0003G\u0003\u0011\u0013!C\u0001\u0003KC\u0011\"!+\u0001\u0003\u0003%\t%a+\t\u0013\u0005m\u0006!!A\u0005\u0002\u0005u\u0006\"CAc\u0001\u0005\u0005I\u0011AAd\u0011%\t\u0019\u000eAA\u0001\n\u0003\n)\u000eC\u0005\u0002d\u0002\t\t\u0011\"\u0001\u0002f\"I\u0011\u0011\u001e\u0001\u0002\u0002\u0013\u0005\u00131^\u0004\n\u0005+i\u0013\u0011!E\u0001\u0005/1\u0001\u0002L\u0017\u0002\u0002#\u0005!\u0011\u0004\u0005\u0007E\u001a\"\tAa\n\t\u0013\t%b%!A\u0005F\t-\u0002\"\u0003B\u0017M\u0005\u0005I\u0011\u0011B\u0018\u0011%\u00119DJA\u0001\n\u0003\u0013I\u0004C\u0005\u0003L\u0019\n\t\u0011\"\u0003\u0003N\tAa\n\u001e5WC2,XM\u0003\u0002/_\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t\u0001\u0014'\u0001\u0005dCR\fG._:u\u0015\t\u00114'A\u0002tc2T!\u0001N\u001b\u0002\u000bM\u0004\u0018M]6\u000b\u0005Y:\u0014AB1qC\u000eDWMC\u00019\u0003\ry'oZ\u0002\u0001'\u001d\u00011h\u0010\"F\u001dR\u0003\"\u0001P\u001f\u000e\u00035J!AP\u0017\u0003/\u0005;wM]3hCR,w+\u001b8e_^4UO\\2uS>t\u0007C\u0001\u001fA\u0013\t\tUF\u0001\u000bPM\u001a\u001cX\r^,j]\u0012|wOR;oGRLwN\u001c\t\u0003y\rK!\u0001R\u0017\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u00042AR%L\u001b\u00059%B\u0001%0\u0003\u0015!(/Z3t\u0013\tQuI\u0001\u0006CS:\f'/\u001f'jW\u0016\u0004\"\u0001\u0010'\n\u00055k#AC#yaJ,7o]5p]B\u0011qJU\u0007\u0002!*\t\u0011+A\u0003tG\u0006d\u0017-\u0003\u0002T!\n9\u0001K]8ek\u000e$\bCA(V\u0013\t1\u0006K\u0001\u0007TKJL\u0017\r\\5{C\ndW-A\u0003j]B,H/F\u0001L\u0003\u0019Ig\u000e];uA\u00051qN\u001a4tKR\fqa\u001c4gg\u0016$\b%A\u0006jO:|'/\u001a(vY2\u001cX#\u00010\u0011\u0005={\u0016B\u00011Q\u0005\u001d\u0011un\u001c7fC:\fA\"[4o_J,g*\u001e7mg\u0002\na\u0001P5oSRtD\u0003\u00023fM\u001e\u0004\"\u0001\u0010\u0001\t\u000b];\u0001\u0019A&\t\u000bi;\u0001\u0019A&\t\u000bq;\u0001\u0019\u00010\u0015\u0007\u0011L7\u000eC\u0003k\u0011\u0001\u00071*A\u0003dQ&dG\rC\u0003[\u0011\u0001\u00071*A\u0004eK\u001a\fW\u000f\u001c;\u0016\u00039\u0004\"\u0001P8\n\u0005Al#a\u0002'ji\u0016\u0014\u0018\r\\\u0001\u0005Y\u00164G/A\u0003sS\u001eDG/A\u0003ge\u0006lW-F\u0001v!\tad/\u0003\u0002x[\tYq+\u001b8e_^4%/Y7f\u0003\u00191'/Y7fA\u0005AA-\u0019;b)f\u0004X-F\u0001|!\tax0D\u0001~\u0015\tq\u0018'A\u0003usB,7/C\u0002\u0002\u0002u\u0014\u0001\u0002R1uCRK\b/Z\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cXCAA\u0004!\u0019\tI!!\u0007\u0002 9!\u00111BA\u000b\u001d\u0011\ti!a\u0005\u000e\u0005\u0005=!bAA\ts\u00051AH]8pizJ\u0011!U\u0005\u0004\u0003/\u0001\u0016a\u00029bG.\fw-Z\u0005\u0005\u00037\tiBA\u0002TKFT1!a\u0006Q!\ra\u0018\u0011E\u0005\u0004\u0003Gi(\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003M\u0019\u0007.Z2l\u0013:\u0004X\u000f\u001e#bi\u0006$\u0016\u0010]3t)\t\tI\u0003\u0005\u0003\u0002,\u0005ERBAA\u0017\u0015\r\tycL\u0001\tC:\fG._:jg&!\u00111GA\u0017\u0005=!\u0016\u0010]3DQ\u0016\u001c7NU3tk2$\u0018!C8gMN,GOV1m+\t\tI\u0004E\u0002P\u0003wI1!!\u0010Q\u0005\u0011auN\\4\u0002\rI,7/\u001e7u+\t\t\u0019\u0005E\u0002=\u0003\u000bJ1!a\u0012.\u0005I\tE\u000f\u001e:jEV$XMU3gKJ,gnY3\u0002\u000b\r|WO\u001c;\u0002'\u0005<wMQ;gM\u0016\u0014\u0018\t\u001e;sS\n,H/Z:\u0016\u0005\u0005=\u0003CBA\u0005\u00033\t\u0019%A\u0007j]&$\u0018.\u00197WC2,Xm]\u000b\u0003\u0003+\u0002R!!\u0003\u0002\u001a9\f\u0011#\u001e9eCR,W\t\u001f9sKN\u001c\u0018n\u001c8t+\t\tY\u0006E\u0003\u0002\n\u0005e1*\u0001\nfm\u0006dW/\u0019;f\u000bb\u0004(/Z:tS>t\u0017A\u00039sKR$\u0018PT1nKV\u0011\u00111\r\t\u0005\u0003K\niG\u0004\u0003\u0002h\u0005%\u0004cAA\u0007!&\u0019\u00111\u000e)\u0002\rA\u0013X\rZ3g\u0013\u0011\ty'!\u001d\u0003\rM#(/\u001b8h\u0015\r\tY\u0007U\u0001\u0018o&$\bNT3x\u0007\"LG\u000e\u001a:f]&sG/\u001a:oC2$R\u0001ZA<\u0003wBa!!\u001f\u001b\u0001\u0004Y\u0015a\u00028fo2+g\r\u001e\u0005\u0007\u0003{R\u0002\u0019A&\u0002\u00119,wOU5hQR\fAaY8qsR9A-a!\u0002\u0006\u0006\u001d\u0005bB,\u001c!\u0003\u0005\ra\u0013\u0005\b5n\u0001\n\u00111\u0001L\u0011\u001da6\u0004%AA\u0002y\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u000e*\u001a1*a$,\u0005\u0005E\u0005\u0003BAJ\u0003;k!!!&\u000b\t\u0005]\u0015\u0011T\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a'Q\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003?\u000b)JA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005\u001d&f\u00010\u0002\u0010\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!!,\u0011\t\u0005=\u0016\u0011X\u0007\u0003\u0003cSA!a-\u00026\u0006!A.\u00198h\u0015\t\t9,\u0001\u0003kCZ\f\u0017\u0002BA8\u0003c\u000bA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a0\u0011\u0007=\u000b\t-C\u0002\u0002DB\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!3\u0002PB\u0019q*a3\n\u0007\u00055\u0007KA\u0002B]fD\u0011\"!5\"\u0003\u0003\u0005\r!a0\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t9\u000e\u0005\u0004\u0002Z\u0006}\u0017\u0011Z\u0007\u0003\u00037T1!!8Q\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003C\fYN\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGc\u00010\u0002h\"I\u0011\u0011[\u0012\u0002\u0002\u0003\u0007\u0011\u0011Z\u0001\u0007KF,\u0018\r\\:\u0015\u0007y\u000bi\u000fC\u0005\u0002R\u0012\n\t\u00111\u0001\u0002J\":\u0002!!=\u0002x\u0006e\u0018Q`A\u0000\u0005\u0007\u0011)A!\u0003\u0003\f\t=!\u0011\u0003\t\u0004y\u0005M\u0018bAA{[\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAA~\u0003\re#\u0002\t\u0011!A}3UKT\"`Q%t\u0007/\u001e;\\Y\u0001zgMZ:fivK\u0003%\f\u0011SKR,(O\\:!i\",\u0007E^1mk\u0016\u0004sN\u001a\u0011aS:\u0004X\u000f\u001e1!CR\u0004C\u000f[3!e><\b\u0005\u001e5bi\u0002J7\u000f\t;iK\u0002\u0002wN\u001a4tKR\u0004G\u000f\u001b\u0011s_^T\u0001\u0005\t\u0011!A\u00012'o\\7!E\u0016<\u0017N\u001c8j]\u001e\u0004sN\u001a\u0011uQ\u0016\u0004s/\u001b8e_^\u0004cM]1nK:\u0002sJ\u001a4tKR\u00043\u000f^1siN\u0004\u0013\r\u001e\u00112]\u0001Je\rI5h]>\u0014XMT;mYNlDO];fY\u0001:X\rI<jY2\u00043o[5q\u0015\u0001\u0002\u0003\u0005\t\u0011!]VdGn\u001d\u0011xQ\u0016t\u0007EZ5oI&tw\r\t;iK\u0002\u0002wN\u001a4tKR\u0004G\u000f\u001b\u0011s_^t\u0003e\u0014;iKJ<\u0018n]3-A\u00154XM]=!e><\beY8v]R\u001c\bEZ8sAQDW\r\t1pM\u001a\u001cX\r\u001e1/A%3'\u0002\t\u0011!A\u0001\u0002C\u000f[3sK\u0002J7\u000f\t8pAM,8\r\u001b\u0011b]\u0002\u0002wN\u001a4tKR\u0004G\u000f\u001b\u0011s_^\u0004\u0003&\u001a\u0018h]1\u0002s\u000f[3oAQDW\rI8gMN,G\u000fI5tAE\u0002D\u0006I:ju\u0016\u0004sN\u001a\u0011uQ\u0016\u0004s/\u001b8e_^\u0004cM]1nK*\u0001\u0003\u0005\t\u0011!A%\u001c\b\u0005\\3tg\u0002\"\b.\u00198!cAJC\u0006\t8vY2\u0004\u0013n\u001d\u0011sKR,(O\\3e])\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\u0011\t!AAR\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002\nG\u0006\t2-A}3UKT\"`Q\td\u0003EM\u0015!\u001fZ+%\u000b\t\u0015Q\u0003J#\u0016\nV%P\u001d\u0002\u0012\u0015\fI1!\u001fJ#UI\u0015\u0011C3\u0002\u0012\u0017\u0006\t$S\u001f6\u0003c+\u0011'V\u000bN\u0003\u0003fJ!2O1\u0002#'\u000b\u0017!Q\u001d\n\u0015g\n\u0017!c%b\u0003\u0005K\u0014Be\u001db\u0003eM\u0015-A!:\u0013)M\u0014-AEJ\u0003\u0005^1cQ\u0005d\u0003EY\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0005\u000b\u0014\"M\u00052\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0005\u000b\u0014\"M\u00052\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0005\u000b\u0014BM\u00052\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0005\u0013\u0014bM\u0005O+2c%\u0002\t\u0011\u0002\u0013\u0005\u0014x-^7f]R\u001c\u0018E\u0001B\u0004\u0003\tM'\u0002\t\u0011!A\u0005\u0013x-^7f]R\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011j]B,H\u000fI\u0017!i\",\u0007\u0005^1sO\u0016$\beY8mk6t\u0007e\u001c:!Kb\u0004(/Z:tS>t\u0007\u0005\u001e5bi\u0002\"\b.\u001a\u0011gk:\u001cG/[8oA=\u0004XM]1uKN\u0004sN\u001c\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011+A=4gm]3uA5\u0002\u0013\r\t9pg&$\u0018N^3!S:$\b\u0005\\5uKJ\fG\u000e\t;pA%tG-[2bi\u0016\u0004C\u000f[3!_\u001a47/\u001a;!S:\u0004C\u000f[3!o&tGm\\<!MJ\fW.\u001a\u0018!\u0013R\u00043\u000f^1siNT\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011xSRD\u0007%\r\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011+A%<gn\u001c:f\u001dVdGn\u001d\u0011.A\u0005t\u0007e\u001c9uS>t\u0017\r\u001c\u0011ta\u0016\u001c\u0017NZ5dCRLwN\u001c\u0011uQ\u0006$\b%\u001b8eS\u000e\fG/Z:!i\",\u0007E\u0014;i-\u0006dW/\u001a\u0011tQ>,H\u000e\u001a\u0011tW&\u0004\bE\\;mY*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t<bYV,7\u000fI5oAQDW\r\t3fi\u0016\u0014X.\u001b8bi&|g\u000eI8gA]D\u0017n\u00195!e><\b\u0005^8!kN,gF\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\u0011i!A\u00034]Er\u0003'A\u0003he>,\b/\t\u0002\u0003\u0014\u0005aq/\u001b8e_^|f-\u001e8dg\u0006Aa\n\u001e5WC2,X\r\u0005\u0002=MM!aEa\u0007U!!\u0011iBa\tL\u0017z#WB\u0001B\u0010\u0015\r\u0011\t\u0003U\u0001\beVtG/[7f\u0013\u0011\u0011)Ca\b\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007\u0006\u0002\u0003\u0018\u0005AAo\\*ue&tw\r\u0006\u0002\u0002.\u0006)\u0011\r\u001d9msR9AM!\r\u00034\tU\u0002\"B,*\u0001\u0004Y\u0005\"\u0002.*\u0001\u0004Y\u0005\"\u0002/*\u0001\u0004q\u0016aB;oCB\u0004H.\u001f\u000b\u0005\u0005w\u00119\u0005E\u0003P\u0005{\u0011\t%C\u0002\u0003@A\u0013aa\u00149uS>t\u0007CB(\u0003D-[e,C\u0002\u0003FA\u0013a\u0001V;qY\u0016\u001c\u0004\u0002\u0003B%U\u0005\u0005\t\u0019\u00013\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GC\u0001B(!\u0011\tyK!\u0015\n\t\tM\u0013\u0011\u0017\u0002\u0007\u001f\nTWm\u0019;")
public class NthValue
extends AggregateWindowFunction
implements OffsetWindowFunction,
ImplicitCastInputTypes,
BinaryLike<Expression> {
    private Literal default;
    private long offsetVal;
    private AttributeReference result;
    private AttributeReference count;
    private Seq<AttributeReference> aggBufferAttributes;
    private Seq<Literal> initialValues;
    private Seq<Expression> updateExpressions;
    private AttributeReference evaluateExpression;
    private final Expression input;
    private final Expression offset;
    private final boolean ignoreNulls;
    private final WindowFrame frame;
    private transient Seq<Expression> children;
    private SpecifiedWindowFrame fakeFrame;
    private volatile int bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple3<Expression, Expression, Object>> unapply(NthValue nthValue) {
        return NthValue$.MODULE$.unapply(nthValue);
    }

    public static Function1<Tuple3<Expression, Expression, Object>, NthValue> tupled() {
        return NthValue$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Object, NthValue>>> curried() {
        return NthValue$.MODULE$.curried();
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return BinaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return BinaryLike.withNewChildrenInternal$(this, newChildren);
    }

    private Seq<Expression> children$lzycompute() {
        NthValue nthValue = this;
        synchronized (nthValue) {
            if (!this.bitmap$trans$0) {
                this.children = BinaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        return !this.bitmap$trans$0 ? this.children$lzycompute() : this.children;
    }

    private SpecifiedWindowFrame fakeFrame$lzycompute() {
        NthValue nthValue = this;
        synchronized (nthValue) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.fakeFrame = OffsetWindowFunction.fakeFrame$(this);
                this.bitmap$0 |= 0x100;
            }
        }
        return this.fakeFrame;
    }

    @Override
    public SpecifiedWindowFrame fakeFrame() {
        return (this.bitmap$0 & 0x100) == 0 ? this.fakeFrame$lzycompute() : this.fakeFrame;
    }

    @Override
    public Expression input() {
        return this.input;
    }

    @Override
    public Expression offset() {
        return this.offset;
    }

    @Override
    public boolean ignoreNulls() {
        return this.ignoreNulls;
    }

    private Literal default$lzycompute() {
        NthValue nthValue = this;
        synchronized (nthValue) {
            if ((this.bitmap$0 & 1) == 0) {
                this.default = Literal$.MODULE$.create(null, this.input().dataType());
                this.bitmap$0 |= 1;
            }
        }
        return this.default;
    }

    @Override
    public Literal default() {
        return (this.bitmap$0 & 1) == 0 ? this.default$lzycompute() : this.default;
    }

    @Override
    public Expression left() {
        return this.input();
    }

    @Override
    public Expression right() {
        return this.offset();
    }

    @Override
    public WindowFrame frame() {
        return this.frame;
    }

    @Override
    public DataType dataType() {
        return this.input().dataType();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)AnyDataType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult check = ExpectsInputTypes.checkInputDataTypes$(this);
        return check.isFailure() ? check : (!this.offset().foldable() ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(39).append("Offset expression '").append(this.offset()).append("' must be a literal.").toString()) : (this.offsetVal() <= 0L ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(72).append("The 'offset' argument of nth_value must be greater than zero but it is ").append(this.offsetVal()).append(".").toString()) : TypeCheckResult$TypeCheckSuccess$.MODULE$));
    }

    private long offsetVal$lzycompute() {
        NthValue nthValue = this;
        synchronized (nthValue) {
            if ((this.bitmap$0 & 2) == 0) {
                this.offsetVal = BoxesRunTime.unboxToInt((Object)this.offset().eval(this.offset().eval$default$1()));
                this.bitmap$0 |= 2;
            }
        }
        return this.offsetVal;
    }

    private long offsetVal() {
        return (this.bitmap$0 & 2) == 0 ? this.offsetVal$lzycompute() : this.offsetVal;
    }

    private AttributeReference result$lzycompute() {
        NthValue nthValue = this;
        synchronized (nthValue) {
            if ((this.bitmap$0 & 4) == 0) {
                String x$1 = "result";
                DataType x$2 = this.input().dataType();
                boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
                Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, x$2, x$3, x$4);
                Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, x$2, x$3, x$4);
                this.result = new AttributeReference(x$1, x$2, x$3, x$4, x$5, x$6);
                this.bitmap$0 |= 4;
            }
        }
        return this.result;
    }

    private AttributeReference result() {
        return (this.bitmap$0 & 4) == 0 ? this.result$lzycompute() : this.result;
    }

    private AttributeReference count$lzycompute() {
        NthValue nthValue = this;
        synchronized (nthValue) {
            if ((this.bitmap$0 & 8) == 0) {
                String x$1 = "count";
                LongType$ x$2 = LongType$.MODULE$;
                boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
                Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, x$2, x$3, x$4);
                Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, x$2, x$3, x$4);
                this.count = new AttributeReference(x$1, x$2, x$3, x$4, x$5, x$6);
                this.bitmap$0 |= 8;
            }
        }
        return this.count;
    }

    private AttributeReference count() {
        return (this.bitmap$0 & 8) == 0 ? this.count$lzycompute() : this.count;
    }

    private Seq<AttributeReference> aggBufferAttributes$lzycompute() {
        NthValue nthValue = this;
        synchronized (nthValue) {
            if ((this.bitmap$0 & 0x10) == 0) {
                AttributeReference attributeReference = this.result();
                AttributeReference attributeReference2 = this.count();
                this.aggBufferAttributes = Nil$.MODULE$.$colon$colon((Object)attributeReference2).$colon$colon((Object)attributeReference);
                this.bitmap$0 |= 0x10;
            }
        }
        return this.aggBufferAttributes;
    }

    @Override
    public Seq<AttributeReference> aggBufferAttributes() {
        return (this.bitmap$0 & 0x10) == 0 ? this.aggBufferAttributes$lzycompute() : this.aggBufferAttributes;
    }

    private Seq<Literal> initialValues$lzycompute() {
        NthValue nthValue = this;
        synchronized (nthValue) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.initialValues = (Seq)new .colon.colon((Object)this.default(), (List)new .colon.colon((Object)Literal$.MODULE$.apply(BoxesRunTime.boxToLong((long)1L)), (List)Nil$.MODULE$));
                this.bitmap$0 |= 0x20;
            }
        }
        return this.initialValues;
    }

    public Seq<Literal> initialValues() {
        return (this.bitmap$0 & 0x20) == 0 ? this.initialValues$lzycompute() : this.initialValues;
    }

    private Seq<Expression> updateExpressions$lzycompute() {
        NthValue nthValue = this;
        synchronized (nthValue) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.updateExpressions = this.ignoreNulls() ? (Seq)new .colon.colon((Object)new If((Expression)((Object)package$expressions$.MODULE$.DslExpression((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.count()).$eq$eq$eq(package$expressions$.MODULE$.longToLiteral(this.offsetVal())))).$amp$amp((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.input()).isNotNull()))), this.input(), this.result()), (List)new .colon.colon((Object)new If((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.input()).isNull()), this.count(), package$expressions$.MODULE$.DslExpression(this.count()).$plus(package$expressions$.MODULE$.longToLiteral(1L))), (List)Nil$.MODULE$)) : (Seq)new .colon.colon((Object)new If((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.count()).$eq$eq$eq(package$expressions$.MODULE$.longToLiteral(this.offsetVal()))), this.input(), this.result()), (List)new .colon.colon((Object)package$expressions$.MODULE$.DslExpression(this.count()).$plus(package$expressions$.MODULE$.longToLiteral(1L)), (List)Nil$.MODULE$));
                this.bitmap$0 |= 0x40;
            }
        }
        return this.updateExpressions;
    }

    @Override
    public Seq<Expression> updateExpressions() {
        return (this.bitmap$0 & 0x40) == 0 ? this.updateExpressions$lzycompute() : this.updateExpressions;
    }

    private AttributeReference evaluateExpression$lzycompute() {
        NthValue nthValue = this;
        synchronized (nthValue) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.evaluateExpression = this.result();
                this.bitmap$0 |= 0x80;
            }
        }
        return this.evaluateExpression;
    }

    @Override
    public AttributeReference evaluateExpression() {
        return (this.bitmap$0 & 0x80) == 0 ? this.evaluateExpression$lzycompute() : this.evaluateExpression;
    }

    @Override
    public String prettyName() {
        return "nth_value";
    }

    @Override
    public String sql() {
        return new StringBuilder(4).append(this.prettyName()).append("(").append(this.input().sql()).append(", ").append(this.offset().sql()).append(")").append((Object)(this.ignoreNulls() ? " ignore nulls" : "")).toString();
    }

    @Override
    public NthValue withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3());
    }

    public NthValue copy(Expression input, Expression offset, boolean ignoreNulls) {
        return new NthValue(input, offset, ignoreNulls);
    }

    public Expression copy$default$1() {
        return this.input();
    }

    public Expression copy$default$2() {
        return this.offset();
    }

    public boolean copy$default$3() {
        return this.ignoreNulls();
    }

    @Override
    public String productPrefix() {
        return "NthValue";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.input();
                break;
            }
            case 1: {
                object = this.offset();
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this.ignoreNulls());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof NthValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof NthValue)) return false;
        boolean bl = true;
        if (!bl) return false;
        NthValue nthValue = (NthValue)x$1;
        Expression expression = this.input();
        Expression expression2 = nthValue.input();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.offset();
        Expression expression4 = nthValue.offset();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (this.ignoreNulls() != nthValue.ignoreNulls()) return false;
        if (!nthValue.canEqual(this)) return false;
        return true;
    }

    public NthValue(Expression input, Expression offset, boolean ignoreNulls) {
        this.input = input;
        this.offset = offset;
        this.ignoreNulls = ignoreNulls;
        OffsetWindowFunction.$init$(this);
        ExpectsInputTypes.$init$(this);
        BinaryLike.$init$(this);
        this.frame = UnspecifiedFrame$.MODULE$;
    }

    public NthValue(Expression child, Expression offset) {
        this(child, offset, false);
    }
}

