/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ElementAt$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GetArrayItemUtil;
import org.apache.spark.sql.catalyst.expressions.GetMapValueUtil;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.SupportQueryContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(array, index) - Returns element of array at given (1-based) index. If Index is 0,\n      Spark will throw an error. If index < 0, accesses elements from the last to the first.\n      The function returns NULL if the index exceeds the length of the array and\n      `spark.sql.ansi.enabled` is set to false.\n      If `spark.sql.ansi.enabled` is set to true, it throws ArrayIndexOutOfBoundsException\n      for invalid indices.\n\n    _FUNC_(map, key) - Returns value for given key. The function returns NULL\n      if the key is not contained in the map and `spark.sql.ansi.enabled` is set to false.\n      If `spark.sql.ansi.enabled` is set to true, it throws NoSuchElementException instead.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 2, 3), 2);\n       2\n      > SELECT _FUNC_(map(1, 'a', 2, 'b'), 2);\n       b\n  ", since="2.4.0", group="map_funcs")
@ScalaSignature(bytes="\u0006\u0001\tme\u0001\u0002\u00192\u0001zB\u0001\"\u0017\u0001\u0003\u0016\u0004%\tA\u0017\u0005\t=\u0002\u0011\t\u0012)A\u00057\"Aq\f\u0001BK\u0002\u0013\u0005!\f\u0003\u0005a\u0001\tE\t\u0015!\u0003\\\u0011!\t\u0007A!f\u0001\n\u0003\u0011\u0007\u0002C5\u0001\u0005#\u0005\u000b\u0011B2\t\u0011)\u0004!Q3A\u0005\u0002-D\u0001b\u001c\u0001\u0003\u0012\u0003\u0006I\u0001\u001c\u0005\u0006a\u0002!\t!\u001d\u0005\u0006a\u0002!\ta\u001e\u0005\tu\u0002A)\u0019!C\u0005w\"I\u0011Q\u0002\u0001\t\u0006\u0004%Ia\u001b\u0005\n\u0003#\u0001\u0001R1A\u0005\n-D!\"!\u0006\u0001\u0011\u000b\u0007I\u0011BA\f\u0011%\t9\u0004\u0001EC\u0002\u0013\u00053\u0010C\u0004\u0002<\u0001!\t%!\u0010\t\u000f\u0005-\u0003\u0001\"\u0011\u0002N!9\u00111\f\u0001\u0005\n\u0005u\u0003BBA8\u0001\u0011\u00053\u000eC\u0004\u0002r\u0001!\t%a\u001d\t\u0015\u0005m\u0004\u0001#b\u0001\n\u0013\ti\bC\u0004\u0002\b\u0002!\t%!#\t\u000f\u0005\u0015\u0006\u0001\"\u0011\u0002(\"9\u0011\u0011\u0018\u0001\u0005R\u0005m\u0006bBAc\u0001\u0011\u0005\u0013q\u0019\u0005\n\u0003\u0013\u0004\u0011\u0011!C\u0001\u0003\u0017D\u0011\"!6\u0001#\u0003%\t!a6\t\u0013\u00055\b!%A\u0005\u0002\u0005]\u0007\"CAx\u0001E\u0005I\u0011AAy\u0011%\t)\u0010AI\u0001\n\u0003\t9\u0010C\u0005\u0002|\u0002\t\t\u0011\"\u0011\u0002~\"I!Q\u0002\u0001\u0002\u0002\u0013\u0005!q\u0002\u0005\n\u0005#\u0001\u0011\u0011!C\u0001\u0005'A\u0011B!\u0007\u0001\u0003\u0003%\tEa\u0007\t\u0013\t%\u0002!!A\u0005\u0002\t-\u0002\"\u0003B\u0018\u0001\u0005\u0005I\u0011\tB\u0019\u000f%\u0011)&MA\u0001\u0012\u0003\u00119F\u0002\u00051c\u0005\u0005\t\u0012\u0001B-\u0011\u0019\u0001h\u0005\"\u0001\u0003h!I!\u0011\u000e\u0014\u0002\u0002\u0013\u0015#1\u000e\u0005\n\u0005[2\u0013\u0011!CA\u0005_B\u0011B!\u001f'#\u0003%\t!!=\t\u0013\tmd%%A\u0005\u0002\u0005]\b\"\u0003B?M\u0005\u0005I\u0011\u0011B@\u0011%\u0011iIJI\u0001\n\u0003\t\t\u0010C\u0005\u0003\u0010\u001a\n\n\u0011\"\u0001\u0002x\"I!\u0011\u0013\u0014\u0002\u0002\u0013%!1\u0013\u0002\n\u000b2,W.\u001a8u\u0003RT!AM\u001a\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003iU\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003m]\n1a]9m\u0015\tA\u0014(A\u0003ta\u0006\u00148N\u0003\u0002;w\u00051\u0011\r]1dQ\u0016T\u0011\u0001P\u0001\u0004_J<7\u0001A\n\b\u0001}\u001ae)\u0013)W!\t\u0001\u0015)D\u00012\u0013\t\u0011\u0015G\u0001\tCS:\f'/_#yaJ,7o]5p]B\u0011\u0001\tR\u0005\u0003\u000bF\u0012qbR3u\u001b\u0006\u0004h+\u00197vKV#\u0018\u000e\u001c\t\u0003\u0001\u001eK!\u0001S\u0019\u0003!\u001d+G/\u0011:sCfLE/Z7Vi&d\u0007C\u0001&N\u001d\t\u00015*\u0003\u0002Mc\u00059\u0001/Y2lC\u001e,\u0017B\u0001(P\u00059qU\u000f\u001c7J]R|G.\u001a:b]RT!\u0001T\u0019\u0011\u0005E#V\"\u0001*\u000b\u0003M\u000bQa]2bY\u0006L!!\u0016*\u0003\u000fA\u0013x\u000eZ;diB\u0011\u0011kV\u0005\u00031J\u0013AbU3sS\u0006d\u0017N_1cY\u0016\fA\u0001\\3giV\t1\f\u0005\u0002A9&\u0011Q,\r\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017!\u00027fMR\u0004\u0013!\u0002:jO\"$\u0018A\u0002:jO\"$\b%\u0001\feK\u001a\fW\u000f\u001c;WC2,XmT;u\u001f\u001a\u0014u.\u001e8e+\u0005\u0019\u0007cA)eM&\u0011QM\u0015\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\u0001;\u0017B\u000152\u0005\u001da\u0015\u000e^3sC2\fq\u0003Z3gCVdGOV1mk\u0016|U\u000f^(g\u0005>,h\u000e\u001a\u0011\u0002\u0017\u0019\f\u0017\u000e\\(o\u000bJ\u0014xN]\u000b\u0002YB\u0011\u0011+\\\u0005\u0003]J\u0013qAQ8pY\u0016\fg.\u0001\u0007gC&dwJ\\#se>\u0014\b%\u0001\u0004=S:LGO\u0010\u000b\u0006eN$XO\u001e\t\u0003\u0001\u0002AQ!W\u0005A\u0002mCQaX\u0005A\u0002mCq!Y\u0005\u0011\u0002\u0003\u00071\rC\u0004k\u0013A\u0005\t\u0019\u00017\u0015\u0007ID\u0018\u0010C\u0003Z\u0015\u0001\u00071\fC\u0003`\u0015\u0001\u00071,\u0001\u0006nCB\\U-\u001f+za\u0016,\u0012\u0001 \t\u0004{\u0006\u0005Q\"\u0001@\u000b\u0005},\u0014!\u0002;za\u0016\u001c\u0018bAA\u0002}\nAA)\u0019;b)f\u0004X\rK\u0002\f\u0003\u000f\u00012!UA\u0005\u0013\r\tYA\u0015\u0002\niJ\fgn]5f]R\fA#\\1q-\u0006dW/Z\"p]R\f\u0017N\\:Ok2d\u0007f\u0001\u0007\u0002\b\u0005\t\u0012M\u001d:bs\u000e{g\u000e^1j]NtU\u000f\u001c7)\u00075\t9!\u0001\u0005pe\u0012,'/\u001b8h+\t\tI\u0002\u0005\u0004\u0002\u001c\u0005%\u0012q\u0006\b\u0005\u0003;\t9C\u0004\u0003\u0002 \u0005\u0015RBAA\u0011\u0015\r\t\u0019#P\u0001\u0007yI|w\u000e\u001e \n\u0003MK!\u0001\u0014*\n\t\u0005-\u0012Q\u0006\u0002\t\u001fJ$WM]5oO*\u0011AJ\u0015\t\u0004#\u0006E\u0012bAA\u001a%\n\u0019\u0011I\\=)\u00079\t9!\u0001\u0005eCR\fG+\u001f9fQ\ry\u0011qA\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cXCAA !\u0019\tY\"!\u0011\u0002F%!\u00111IA\u0017\u0005\r\u0019V-\u001d\t\u0004{\u0006\u001d\u0013bAA%}\n\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\u0014G\",7m[%oaV$H)\u0019;b)f\u0004Xm\u001d\u000b\u0003\u0003\u001f\u0002B!!\u0015\u0002X5\u0011\u00111\u000b\u0006\u0004\u0003+\u001a\u0014\u0001C1oC2L8/[:\n\t\u0005e\u00131\u000b\u0002\u0010)f\u0004Xm\u00115fG.\u0014Vm];mi\u0006Ya.\u001e7mC\nLG.\u001b;z)\u0015a\u0017qLA3\u0011\u001d\t\tG\u0005a\u0001\u0003G\n\u0001\"\u001a7f[\u0016tGo\u001d\t\u0006\u00037\t\te\u0017\u0005\b\u0003O\u0012\u0002\u0019AA5\u0003\u001dy'\u000fZ5oC2\u00042!UA6\u0013\r\tiG\u0015\u0002\u0004\u0013:$\u0018\u0001\u00038vY2\f'\r\\3\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\r\u0005=\u0012QOA=\u0011\u001d\t9\b\u0006a\u0001\u0003_\tQA^1mk\u0016Dq!a\u001a\u0015\u0001\u0004\ty#A\u0006e_\u0016cW-\\3oi\u0006#XCAA@!%\t\u0016\u0011QA\u0018\u0003_\ty#C\u0002\u0002\u0004J\u0013\u0011BR;oGRLwN\u001c\u001a)\u0007U\t9!A\u0005e_\u001e+gnQ8eKR1\u00111RAL\u0003C\u0003B!!$\u0002\u00146\u0011\u0011q\u0012\u0006\u0004\u0003#\u000b\u0014aB2pI\u0016<WM\\\u0005\u0005\u0003+\u000byI\u0001\u0005FqB\u00148i\u001c3f\u0011\u001d\tIJ\u0006a\u0001\u00037\u000b1a\u0019;y!\u0011\ti)!(\n\t\u0005}\u0015q\u0012\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u001d\t\u0019K\u0006a\u0001\u0003\u0017\u000b!!\u001a<\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-\u0006\u0002\u0002*B!\u00111VAZ\u001d\u0011\ti+a,\u0011\u0007\u0005}!+C\u0002\u00022J\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA[\u0003o\u0013aa\u0015;sS:<'bAAY%\u00069r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\u0006e\u0006u\u0016\u0011\u0019\u0005\u0007\u0003\u007fC\u0002\u0019A.\u0002\u000f9,w\u000fT3gi\"1\u00111\u0019\rA\u0002m\u000b\u0001B\\3x%&<\u0007\u000e^\u0001\u0011S:LG/U;fef\u001cuN\u001c;fqR$\"!!+\u0002\t\r|\u0007/\u001f\u000b\ne\u00065\u0017qZAi\u0003'Dq!\u0017\u000e\u0011\u0002\u0003\u00071\fC\u0004`5A\u0005\t\u0019A.\t\u000f\u0005T\u0002\u0013!a\u0001G\"9!N\u0007I\u0001\u0002\u0004a\u0017AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u00033T3aWAnW\t\ti\u000e\u0005\u0003\u0002`\u0006%XBAAq\u0015\u0011\t\u0019/!:\u0002\u0013Ut7\r[3dW\u0016$'bAAt%\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005-\u0018\u0011\u001d\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\t\u0019PK\u0002d\u00037\fabY8qs\u0012\"WMZ1vYR$C'\u0006\u0002\u0002z*\u001aA.a7\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\ty\u0010\u0005\u0003\u0003\u0002\t-QB\u0001B\u0002\u0015\u0011\u0011)Aa\u0002\u0002\t1\fgn\u001a\u0006\u0003\u0005\u0013\tAA[1wC&!\u0011Q\u0017B\u0002\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\tI'\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005=\"Q\u0003\u0005\n\u0005/\t\u0013\u0011!a\u0001\u0003S\n1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001B\u000f!\u0019\u0011yB!\n\u000205\u0011!\u0011\u0005\u0006\u0004\u0005G\u0011\u0016AC2pY2,7\r^5p]&!!q\u0005B\u0011\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u00071\u0014i\u0003C\u0005\u0003\u0018\r\n\t\u00111\u0001\u00020\u00051Q-];bYN$2\u0001\u001cB\u001a\u0011%\u00119\u0002JA\u0001\u0002\u0004\ty\u0003K\n\u0001\u0005o\u0011iDa\u0010\u0003D\t\u0015#\u0011\nB&\u0005\u001f\u0012\t\u0006E\u0002A\u0005sI1Aa\u000f2\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#A!\u0011\u0002\u000bkR\u0001\u0005\t\u0011!?\u001a+fjQ0)CJ\u0014\u0018-\u001f\u0017!S:$W\r_\u0015![\u0001\u0012V\r^;s]N\u0004S\r\\3nK:$\be\u001c4!CJ\u0014\u0018-\u001f\u0011bi\u0002:\u0017N^3oA!\nTFY1tK\u0012L\u0003%\u001b8eKbt\u0003%\u00134!\u0013:$W\r\u001f\u0011jg\u0002\u0002DF\u0003\u0011!A\u0001\u0002\u0003e\u00159be.\u0004s/\u001b7mAQD'o\\<!C:\u0004SM\u001d:pe:\u0002\u0013J\u001a\u0011j]\u0012,\u0007\u0010\t\u001f!a1\u0002\u0013mY2fgN,7\u000fI3mK6,g\u000e^:!MJ|W\u000e\t;iK\u0002b\u0017m\u001d;!i>\u0004C\u000f[3!M&\u00148\u000f\u001e\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011UQ\u0016\u0004c-\u001e8di&|g\u000e\t:fiV\u0014hn\u001d\u0011O+2c\u0005%\u001b4!i\",\u0007%\u001b8eKb\u0004S\r_2fK\u0012\u001c\b\u0005\u001e5fA1,gn\u001a;iA=4\u0007\u0005\u001e5fA\u0005\u0014(/Y=!C:$'\u0002\t\u0011!A\u0001\u0002\u0003m\u001d9be.t3/\u001d7/C:\u001c\u0018NL3oC\ndW\r\u001a1!SN\u00043/\u001a;!i>\u0004c-\u00197tK:R\u0001\u0005\t\u0011!A\u0001Je\r\t1ta\u0006\u00148NL:rY:\ngn]5/K:\f'\r\\3eA\u0002J7\u000fI:fi\u0002\"x\u000e\t;sk\u0016d\u0003%\u001b;!i\"\u0014xn^:!\u0003J\u0014\u0018-_%oI\u0016Dx*\u001e;PM\n{WO\u001c3t\u000bb\u001cW\r\u001d;j_:T\u0001\u0005\t\u0011!A\u00012wN\u001d\u0011j]Z\fG.\u001b3!S:$\u0017nY3t])Q\u0001\u0005\t\u0011!?\u001a+fjQ0)[\u0006\u0004H\u0006I6fs&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011wC2,X\r\t4pe\u0002:\u0017N^3oA-,\u0017P\f\u0011UQ\u0016\u0004c-\u001e8di&|g\u000e\t:fiV\u0014hn\u001d\u0011O+2c%\u0002\t\u0011!A\u0001\u0002\u0013N\u001a\u0011uQ\u0016\u00043.Z=!SN\u0004cn\u001c;!G>tG/Y5oK\u0012\u0004\u0013N\u001c\u0011uQ\u0016\u0004S.\u00199!C:$\u0007\u0005Y:qCJ\\gf]9m]\u0005t7/\u001b\u0018f]\u0006\u0014G.\u001a3aA%\u001c\be]3uAQ|\u0007EZ1mg\u0016t#\u0002\t\u0011!A\u0001\u0002\u0013J\u001a\u0011agB\f'o\u001b\u0018tc2t\u0013M\\:j]\u0015t\u0017M\u00197fI\u0002\u0004\u0013n\u001d\u0011tKR\u0004Co\u001c\u0011ueV,G\u0006I5uAQD'o\\<tA9{7+^2i\u000b2,W.\u001a8u\u000bb\u001cW\r\u001d;j_:\u0004\u0013N\\:uK\u0006$gF\u0003\u0011!\u0003!)\u00070Y7qY\u0016\u001c\u0018E\u0001B$\u0003qT\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\u0019:sCfD\u0013\u0007\f\u00113Y\u0001\u001a\u0014\u0006\f\u00113SmR\u0001\u0005\t\u0011!A\u0001\u0002#G\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015nCBD\u0013\u0007\f\u0011(C\u001eb\u0003E\r\u0017!O\t<\u0013\u0006\f\u00113SmR\u0001\u0005\t\u0011!A\u0001\u0002#M\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\u0011i%A\u00033]Qr\u0003'A\u0003he>,\b/\t\u0002\u0003T\u0005IQ.\u00199`MVt7m]\u0001\n\u000b2,W.\u001a8u\u0003R\u0004\"\u0001\u0011\u0014\u0014\t\u0019\u0012YF\u0016\t\n\u0005;\u0012\u0019gW.dYJl!Aa\u0018\u000b\u0007\t\u0005$+A\u0004sk:$\u0018.\\3\n\t\t\u0015$q\f\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:$DC\u0001B,\u0003!!xn\u0015;sS:<GCAA\u0000\u0003\u0015\t\u0007\u000f\u001d7z)%\u0011(\u0011\u000fB:\u0005k\u00129\bC\u0003ZS\u0001\u00071\fC\u0003`S\u0001\u00071\fC\u0004bSA\u0005\t\u0019A2\t\u000f)L\u0003\u0013!a\u0001Y\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$3'A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00135\u0003\u001d)h.\u00199qYf$BA!!\u0003\nB!\u0011\u000b\u001aBB!\u001d\t&QQ.\\G2L1Aa\"S\u0005\u0019!V\u000f\u001d7fi!A!1\u0012\u0017\u0002\u0002\u0003\u0007!/A\u0002yIA\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001a\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C'A\u0006sK\u0006$'+Z:pYZ,GC\u0001BK!\u0011\u0011\tAa&\n\t\te%1\u0001\u0002\u0007\u001f\nTWm\u0019;")
public class ElementAt
extends BinaryExpression
implements GetMapValueUtil,
GetArrayItemUtil,
package.NullIntolerant {
    private transient DataType mapKeyType;
    private transient boolean mapValueContainsNull;
    private transient boolean arrayContainsNull;
    private transient Ordering<Object> ordering;
    private transient DataType dataType;
    private transient Function2<Object, Object, Object> doElementAt;
    private final Expression left;
    private final Expression right;
    private final Option<Literal> defaultValueOutOfBound;
    private final boolean failOnError;
    private String queryContext;
    private volatile transient byte bitmap$trans$0;

    public static boolean $lessinit$greater$default$4() {
        return ElementAt$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Literal> $lessinit$greater$default$3() {
        return ElementAt$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple4<Expression, Expression, Option<Literal>, Object>> unapply(ElementAt elementAt) {
        return ElementAt$.MODULE$.unapply(elementAt);
    }

    public static boolean apply$default$4() {
        return ElementAt$.MODULE$.apply$default$4();
    }

    public static Option<Literal> apply$default$3() {
        return ElementAt$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple4<Expression, Expression, Option<Literal>, Object>, ElementAt> tupled() {
        return ElementAt$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Option<Literal>, Function1<Object, ElementAt>>>> curried() {
        return ElementAt$.MODULE$.curried();
    }

    @Override
    public boolean computeNullabilityFromArray(Expression child, Expression ordinal, boolean failOnError, Function2<Seq<Expression>, Object, Object> nullability) {
        return GetArrayItemUtil.computeNullabilityFromArray$(this, child, ordinal, failOnError, nullability);
    }

    @Override
    public Object getValueEval(Object value, Object ordinal, DataType keyType, Ordering<Object> ordering, boolean failOnError) {
        return GetMapValueUtil.getValueEval$(this, value, ordinal, keyType, ordering, failOnError);
    }

    @Override
    public ExprCode doGetValueGenCode(CodegenContext ctx, ExprCode ev, MapType mapType, boolean failOnError) {
        return GetMapValueUtil.doGetValueGenCode$(this, ctx, ev, mapType, failOnError);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$catalyst$expressions$SupportQueryContext$$super$copyTagsFrom(Expression other) {
        super.copyTagsFrom(other);
    }

    @Override
    public void copyTagsFrom(Expression other) {
        SupportQueryContext.copyTagsFrom$(this, other);
    }

    @Override
    public String queryContext() {
        return this.queryContext;
    }

    @Override
    public void queryContext_$eq(String x$1) {
        this.queryContext = x$1;
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    public Option<Literal> defaultValueOutOfBound() {
        return this.defaultValueOutOfBound;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    private DataType mapKeyType$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.mapKeyType = ((MapType)this.left().dataType()).keyType();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.mapKeyType;
    }

    private DataType mapKeyType() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.mapKeyType$lzycompute() : this.mapKeyType;
    }

    private boolean mapValueContainsNull$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.mapValueContainsNull = ((MapType)this.left().dataType()).valueContainsNull();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.mapValueContainsNull;
    }

    private boolean mapValueContainsNull() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.mapValueContainsNull$lzycompute() : this.mapValueContainsNull;
    }

    private boolean arrayContainsNull$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.arrayContainsNull = ((ArrayType)this.left().dataType()).containsNull();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.arrayContainsNull;
    }

    private boolean arrayContainsNull() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.arrayContainsNull$lzycompute() : this.arrayContainsNull;
    }

    private Ordering<Object> ordering$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.ordering = TypeUtils$.MODULE$.getInterpretedOrdering(this.mapKeyType());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.ordering;
    }

    private Ordering<Object> ordering() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.ordering$lzycompute() : this.ordering;
    }

    private DataType dataType$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
                DataType dataType;
                DataType dataType2 = this.left().dataType();
                if (dataType2 instanceof ArrayType) {
                    DataType elementType;
                    ArrayType arrayType = (ArrayType)dataType2;
                    dataType = elementType = arrayType.elementType();
                } else if (dataType2 instanceof MapType) {
                    DataType valueType;
                    MapType mapType = (MapType)dataType2;
                    dataType = valueType = mapType.valueType();
                } else {
                    throw new MatchError((Object)dataType2);
                }
                this.dataType = dataType;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x10);
            }
        }
        return this.dataType;
    }

    @Override
    public DataType dataType() {
        return (byte)(this.bitmap$trans$0 & 0x10) == 0 ? this.dataType$lzycompute() : this.dataType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Seq<AbstractDataType> inputTypes() {
        Tuple2 tuple2 = new Tuple2((Object)this.left().dataType(), (Object)this.right().dataType());
        if (tuple2 != null) {
            DataType arr = (DataType)tuple2._1();
            DataType e2 = (DataType)tuple2._2();
            if (arr instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)arr;
                if (e2 instanceof IntegralType) {
                    IntegralType integralType;
                    IntegralType integralType2 = integralType = (IntegralType)e2;
                    LongType$ longType$ = LongType$.MODULE$;
                    if (integralType2 == null ? longType$ != null : !integralType2.equals(longType$)) {
                        return (Seq)new .colon.colon((Object)arrayType, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$));
                    }
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType e2 = (DataType)tuple2._2();
            if (dataType instanceof MapType) {
                Seq seq;
                MapType mapType = (MapType)dataType;
                DataType keyType = mapType.keyType();
                DataType valueType = mapType.valueType();
                boolean hasNull = mapType.valueContainsNull();
                Option option = (Option)TypeCoercion$.MODULE$.findTightestCommonType().apply((Object)keyType, (Object)e2);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    DataType dt = (DataType)some.value();
                    seq = (Seq)new .colon.colon((Object)new MapType(dt, valueType, hasNull), (List)new .colon.colon((Object)dt, (List)Nil$.MODULE$));
                    return seq;
                } else {
                    seq = (Seq)Nil$.MODULE$;
                }
                return seq;
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        return (Seq)Nil$.MODULE$;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public TypeCheckResult checkInputDataTypes() {
        DataType e1;
        void var1_8;
        Tuple2 tuple2 = new Tuple2((Object)this.left().dataType(), (Object)this.right().dataType());
        if (tuple2 != null) {
            DataType e2 = (DataType)tuple2._2();
            if (tuple2._1() instanceof ArrayType) {
                DataType dataType = e2;
                IntegerType$ integerType$ = IntegerType$.MODULE$;
                if (dataType == null ? integerType$ != null : !dataType.equals(integerType$)) {
                    TypeCheckResult.TypeCheckFailure typeCheckFailure = new TypeCheckResult.TypeCheckFailure(new StringBuilder(67).append("Input to function ").append(this.prettyName()).append(" should have ").append("been ").append(ArrayType$.MODULE$.simpleString()).append(" followed by a ").append(IntegerType$.MODULE$.simpleString()).append(", but it's ").append("[").append(this.left().dataType().catalogString()).append(", ").append(this.right().dataType().catalogString()).append("].").toString());
                    return var1_8;
                }
            }
        }
        if (tuple2 != null) {
            MapType mapType;
            DataType e12;
            DataType dataType = (DataType)tuple2._1();
            DataType e2 = (DataType)tuple2._2();
            if (dataType instanceof MapType && !e2.sameType(e12 = (mapType = (MapType)dataType).keyType())) {
                TypeCheckResult.TypeCheckFailure typeCheckFailure = new TypeCheckResult.TypeCheckFailure(new StringBuilder(89).append("Input to function ").append(this.prettyName()).append(" should have ").append("been ").append(MapType$.MODULE$.simpleString()).append(" followed by a value of same key type, but it's ").append("[").append(this.left().dataType().catalogString()).append(", ").append(this.right().dataType().catalogString()).append("].").toString());
                return var1_8;
            }
        }
        if (tuple2 != null && !((e1 = (DataType)tuple2._1()) instanceof MapType) && !(e1 instanceof ArrayType)) {
            TypeCheckResult.TypeCheckFailure typeCheckFailure = new TypeCheckResult.TypeCheckFailure(new StringBuilder(74).append("The first argument to function ").append(this.prettyName()).append(" should ").append("have been ").append(ArrayType$.MODULE$.simpleString()).append(" or ").append(MapType$.MODULE$.simpleString()).append(" type, but its ").append(this.left().dataType().catalogString()).append(" type.").toString());
            return var1_8;
        }
        TypeCheckResult$TypeCheckSuccess$ typeCheckResult$TypeCheckSuccess$ = TypeCheckResult$TypeCheckSuccess$.MODULE$;
        return var1_8;
    }

    private boolean nullability(Seq<Expression> elements, int ordinal) {
        return ordinal == 0 ? false : (elements.length() < package$.MODULE$.abs(ordinal) ? !this.failOnError() : (ordinal < 0 ? ((Expression)elements.apply(elements.length() + ordinal)).nullable() : ((Expression)elements.apply(ordinal - 1)).nullable()));
    }

    @Override
    public boolean nullable() {
        boolean bl;
        DataType dataType = this.left().dataType();
        if (dataType instanceof ArrayType) {
            bl = this.computeNullabilityFromArray(this.left(), this.right(), this.failOnError(), (Function2<Seq<Expression>, Object, Object>)(Function2 & Serializable & scala.Serializable)(elements, ordinal) -> BoxesRunTime.boxToBoolean((boolean)this.nullability((Seq<Expression>)elements, BoxesRunTime.unboxToInt((Object)ordinal))));
        } else if (dataType instanceof MapType) {
            bl = this.failOnError() ? this.mapValueContainsNull() : true;
        } else {
            throw new MatchError((Object)dataType);
        }
        return bl;
    }

    @Override
    public Object nullSafeEval(Object value, Object ordinal) {
        return this.doElementAt().apply(value, ordinal);
    }

    private Function2<Object, Object, Object> doElementAt$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 0x20) == 0) {
                Function2 & Serializable & scala.Serializable intersect;
                DataType dataType = this.left().dataType();
                if (dataType instanceof ArrayType) {
                    intersect = (Function2 & Serializable & scala.Serializable)(value, ordinal) -> {
                        Object object;
                        ArrayData array = (ArrayData)value;
                        int index = BoxesRunTime.unboxToInt((Object)ordinal);
                        if (array.numElements() < package$.MODULE$.abs(index)) {
                            Object object2;
                            if (this.failOnError()) {
                                throw QueryExecutionErrors$.MODULE$.invalidElementAtIndexError(index, array.numElements());
                            }
                            Option<Literal> option = this.defaultValueOutOfBound();
                            if (option instanceof Some) {
                                Some some = (Some)option;
                                Literal value2 = (Literal)some.value();
                                object2 = value2.eval(value2.eval$default$1());
                            } else if (None$.MODULE$.equals(option)) {
                                object2 = null;
                            } else {
                                throw new MatchError(option);
                            }
                            object = object2;
                        } else {
                            if (index == 0) {
                                throw QueryExecutionErrors$.MODULE$.sqlArrayIndexNotStartAtOneError();
                            }
                            int idx = index > 0 ? index - 1 : array.numElements() + index;
                            object = this.arrayContainsNull() && array.isNullAt(idx) ? null : array.get(idx, this.dataType());
                        }
                        return object;
                    };
                } else if (dataType instanceof MapType) {
                    intersect = (Function2 & Serializable & scala.Serializable)(value, ordinal) -> this.getValueEval(value, ordinal, this.mapKeyType(), this.ordering(), this.failOnError());
                } else {
                    throw new MatchError((Object)dataType);
                }
                this.doElementAt = intersect;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x20);
            }
        }
        return this.doElementAt;
    }

    private Function2<Object, Object, Object> doElementAt() {
        return (byte)(this.bitmap$trans$0 & 0x20) == 0 ? this.doElementAt$lzycompute() : this.doElementAt;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        DataType dataType = this.left().dataType();
        if (dataType instanceof ArrayType) {
            exprCode = this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(eval1, eval2) -> {
                String string;
                String nullCheck;
                String index = ctx.freshName("elementAtIndex");
                String string2 = nullCheck = this.arrayContainsNull() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(99).append("\n               |if (").append((String)eval1).append(".isNullAt(").append(index).append(")) {\n               |  ").append(ev.isNull()).append(" = true;\n               |} else\n             ").toString())).stripMargin() : "";
                if (this.failOnError()) {
                    string = new StringBuilder(72).append("throw QueryExecutionErrors.invalidElementAtIndexError(").append(index).append(", ").append((String)eval1).append(".numElements());").toString();
                } else {
                    String string3;
                    Option<Literal> option = this.defaultValueOutOfBound();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        Literal value = (Literal)some.value();
                        ExprCode defaultValueEval = value.genCode(ctx);
                        string3 = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(82).append("\n                  ").append(defaultValueEval.code()).append("\n                  ").append(ev.isNull()).append(" = ").append(defaultValueEval.isNull()).append(";\n                  ").append(ev.value()).append(" = ").append(defaultValueEval.value()).append(";\n                ").toString())).stripMargin();
                    } else if (None$.MODULE$.equals(option)) {
                        string3 = new StringBuilder(8).append(ev.isNull()).append(" = true;").toString();
                    } else {
                        throw new MatchError(option);
                    }
                    string = string3;
                }
                String indexOutOfBoundBranch = string;
                return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(469).append("\n             |int ").append(index).append(" = (int) ").append((String)eval2).append(";\n             |if (").append((String)eval1).append(".numElements() < Math.abs(").append(index).append(")) {\n             |  ").append(indexOutOfBoundBranch).append("\n             |} else {\n             |  if (").append(index).append(" == 0) {\n             |    throw QueryExecutionErrors.sqlArrayIndexNotStartAtOneError();\n             |  } else if (").append(index).append(" > 0) {\n             |    ").append(index).append("--;\n             |  } else {\n             |    ").append(index).append(" += ").append((String)eval1).append(".numElements();\n             |  }\n             |  ").append(nullCheck).append("\n             |  {\n             |    ").append(ev.value()).append(" = ").append(CodeGenerator$.MODULE$.getValue((String)eval1, this.dataType(), index)).append(";\n             |  }\n             |}\n           ").toString())).stripMargin();
            });
        } else if (dataType instanceof MapType) {
            exprCode = this.doGetValueGenCode(ctx, ev, (MapType)this.left().dataType(), this.failOnError());
        } else {
            throw new MatchError((Object)dataType);
        }
        return exprCode;
    }

    @Override
    public String prettyName() {
        return "element_at";
    }

    @Override
    public ElementAt withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3(), this.copy$default$4());
    }

    @Override
    public String initQueryContext() {
        return this.failOnError() ? this.origin().context() : "";
    }

    public ElementAt copy(Expression left, Expression right, Option<Literal> defaultValueOutOfBound, boolean failOnError) {
        return new ElementAt(left, right, defaultValueOutOfBound, failOnError);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    public Option<Literal> copy$default$3() {
        return this.defaultValueOutOfBound();
    }

    public boolean copy$default$4() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "ElementAt";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.left();
                break;
            }
            case 1: {
                object = this.right();
                break;
            }
            case 2: {
                object = this.defaultValueOutOfBound();
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToBoolean((boolean)this.failOnError());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ElementAt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ElementAt)) return false;
        boolean bl = true;
        if (!bl) return false;
        ElementAt elementAt = (ElementAt)x$1;
        Expression expression = this.left();
        Expression expression2 = elementAt.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = elementAt.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<Literal> option = this.defaultValueOutOfBound();
        Option<Literal> option2 = elementAt.defaultValueOutOfBound();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (this.failOnError() != elementAt.failOnError()) return false;
        if (!elementAt.canEqual(this)) return false;
        return true;
    }

    public ElementAt(Expression left, Expression right, Option<Literal> defaultValueOutOfBound, boolean failOnError) {
        this.left = left;
        this.right = right;
        this.defaultValueOutOfBound = defaultValueOutOfBound;
        this.failOnError = failOnError;
        ExpectsInputTypes.$init$(this);
        SupportQueryContext.$init$(this);
        GetMapValueUtil.$init$(this);
        GetArrayItemUtil.$init$(this);
    }

    public ElementAt(Expression left, Expression right) {
        this(left, right, (Option<Literal>)None$.MODULE$, SQLConf$.MODULE$.get().ansiEnabled());
    }
}

