/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.util.Locale;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.matching.Regex;

public final class DateTimeFormatterHelper$ {
    public static DateTimeFormatterHelper$ MODULE$;
    private DateTimeFormatter fractionFormatter;
    private final Cache<Tuple3<String, Locale, Object>, DateTimeFormatter> cache;
    private final Regex extractor;
    private final boolean bugInStandAloneForm;
    private final Set<Object> weekBasedLetters;
    private final Set<Object> unsupportedLetters;
    private final Set<Object> unsupportedLettersForParsing;
    private final Set<String> unsupportedPatternLengths;
    private volatile boolean bitmap$0;

    static {
        new DateTimeFormatterHelper$();
    }

    public Cache<Tuple3<String, Locale, Object>, DateTimeFormatter> cache() {
        return this.cache;
    }

    public final Regex extractor() {
        return this.extractor;
    }

    public DateTimeFormatterBuilder createBuilder() {
        return new DateTimeFormatterBuilder().parseCaseInsensitive();
    }

    public DateTimeFormatter toFormatter(DateTimeFormatterBuilder builder, Locale locale) {
        return builder.toFormatter(locale).withChronology(IsoChronology.INSTANCE).withResolverStyle(ResolverStyle.STRICT);
    }

    /*
     * WARNING - void declaration
     */
    public DateTimeFormatterBuilder createBuilderWithVarLengthSecondFraction(String pattern) {
        void var2_2;
        DateTimeFormatterBuilder builder = this.createBuilder();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pattern.split("'"))).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String string = (String)tuple2._1();
                int idx = tuple2._2$mcI$sp();
                if ("".equals(string) && idx != 0) {
                    return builder.appendLiteral("'");
                }
            }
            if (tuple2 != null) {
                String patternPart = (String)tuple2._1();
                int idx = tuple2._2$mcI$sp();
                if (idx % 2 == 0) {
                    String rest = patternPart;
                    while (new StringOps(Predef$.MODULE$.augmentString(rest)).nonEmpty()) {
                        String string = rest;
                        Option option = MODULE$.extractor().unapplySeq((CharSequence)string);
                        if (option.isEmpty()) throw new IllegalArgumentException(new StringBuilder(31).append("Unrecognized datetime pattern: ").append(pattern).toString());
                        if (option.get() == null) throw new IllegalArgumentException(new StringBuilder(31).append("Unrecognized datetime pattern: ").append(pattern).toString());
                        if (((LinearSeqOptimized)option.get()).lengthCompare(3) != 0) throw new IllegalArgumentException(new StringBuilder(31).append("Unrecognized datetime pattern: ").append(pattern).toString());
                        String prefix = (String)((LinearSeqOptimized)option.get()).apply(0);
                        String secondFraction = (String)((LinearSeqOptimized)option.get()).apply(1);
                        String suffix = (String)((LinearSeqOptimized)option.get()).apply(2);
                        builder.appendPattern(prefix);
                        Object object = new StringOps(Predef$.MODULE$.augmentString(secondFraction)).nonEmpty() ? builder.appendFraction(ChronoField.NANO_OF_SECOND, 1, secondFraction.length(), false) : BoxedUnit.UNIT;
                        rest = suffix;
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            String patternPart = (String)tuple2._1();
            return builder.appendLiteral(patternPart);
        });
        return var2_2;
    }

    public DateTimeFormatter buildFormatter(String pattern, Locale locale, boolean varLenEnabled) {
        DateTimeFormatterBuilder builder = varLenEnabled ? this.createBuilderWithVarLengthSecondFraction(pattern) : this.createBuilder().appendPattern(pattern);
        return this.toFormatter(builder, locale);
    }

    private DateTimeFormatter fractionFormatter$lzycompute() {
        DateTimeFormatterHelper$ dateTimeFormatterHelper$ = this;
        synchronized (dateTimeFormatterHelper$) {
            if (!this.bitmap$0) {
                DateTimeFormatterBuilder builder = this.createBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true);
                this.fractionFormatter = this.toFormatter(builder, TimestampFormatter$.MODULE$.defaultLocale());
                this.bitmap$0 = true;
            }
        }
        return this.fractionFormatter;
    }

    public DateTimeFormatter fractionFormatter() {
        return !this.bitmap$0 ? this.fractionFormatter$lzycompute() : this.fractionFormatter;
    }

    private final boolean bugInStandAloneForm() {
        return this.bugInStandAloneForm;
    }

    public final Set<Object> weekBasedLetters() {
        return this.weekBasedLetters;
    }

    public final Set<Object> unsupportedLetters() {
        return this.unsupportedLetters;
    }

    public final Set<Object> unsupportedLettersForParsing() {
        return this.unsupportedLettersForParsing;
    }

    public final Set<String> unsupportedPatternLengths() {
        return this.unsupportedPatternLengths;
    }

    public String convertIncompatiblePattern(String pattern, boolean isParsing) {
        boolean eraDesignatorContained = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pattern.split("'"))).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).exists((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DateTimeFormatterHelper$.$anonfun$convertIncompatiblePattern$1(x0$1)));
        return new StringOps(Predef$.MODULE$.augmentString(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringBuilder(1).append(pattern).append(" ").toString().split("'"))).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            String string;
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                String patternPart = (String)tuple2._1();
                int index = tuple2._2$mcI$sp();
                if (index % 2 == 0) {
                    new StringOps(Predef$.MODULE$.augmentString(patternPart)).withFilter((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)DateTimeFormatterHelper$.$anonfun$convertIncompatiblePattern$3(BoxesRunTime.unboxToChar((Object)c)))).foreach((Function1 & Serializable & scala.Serializable)c -> DateTimeFormatterHelper$.$anonfun$convertIncompatiblePattern$4(BoxesRunTime.unboxToChar((Object)c)));
                    new StringOps(Predef$.MODULE$.augmentString(patternPart)).withFilter((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)DateTimeFormatterHelper$.$anonfun$convertIncompatiblePattern$5(isParsing, BoxesRunTime.unboxToChar((Object)c)))).foreach((Function1 & Serializable & scala.Serializable)c -> DateTimeFormatterHelper$.$anonfun$convertIncompatiblePattern$6(BoxesRunTime.unboxToChar((Object)c)));
                    MODULE$.unsupportedPatternLengths().withFilter((Function1 & Serializable & scala.Serializable)style -> BoxesRunTime.boxToBoolean((boolean)patternPart.contains(style))).foreach((Function1 & Serializable & scala.Serializable)style -> {
                        throw new IllegalArgumentException(new StringBuilder(26).append("Too many pattern letters: ").append(new StringOps(Predef$.MODULE$.augmentString(style)).head()).toString());
                    });
                    if (MODULE$.bugInStandAloneForm() && (patternPart.contains("LLL") || patternPart.contains("qqq"))) {
                        throw new IllegalArgumentException("Java 8 has a bug to support stand-alone form (3 or more 'L' or 'q' in the pattern string). Please use 'M' or 'Q' instead, or upgrade your Java version. For more details, please read https://bugs.openjdk.java.net/browse/JDK-8114833");
                    }
                    string = !eraDesignatorContained ? patternPart.replace("y", "u") : patternPart;
                } else {
                    string = patternPart;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            String string2 = string;
            return string2;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("'"))).stripSuffix(" ");
    }

    public static final /* synthetic */ boolean $anonfun$convertIncompatiblePattern$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String patternPart = (String)tuple2._1();
        int index = tuple2._2$mcI$sp();
        boolean bl = index % 2 == 0 && patternPart.contains("G");
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$convertIncompatiblePattern$3(char c) {
        return MODULE$.weekBasedLetters().contains((Object)BoxesRunTime.boxToCharacter((char)c));
    }

    public static final /* synthetic */ Nothing$ $anonfun$convertIncompatiblePattern$4(char c) {
        throw new IllegalArgumentException(new StringBuilder(112).append("All week-based patterns are unsupported since").append(" Spark 3.0, detected: ").append(c).append(", Please use the SQL function EXTRACT instead").toString());
    }

    public static final /* synthetic */ boolean $anonfun$convertIncompatiblePattern$5(boolean isParsing$1, char c) {
        return MODULE$.unsupportedLetters().contains((Object)BoxesRunTime.boxToCharacter((char)c)) || isParsing$1 && MODULE$.unsupportedLettersForParsing().contains((Object)BoxesRunTime.boxToCharacter((char)c));
    }

    public static final /* synthetic */ Nothing$ $anonfun$convertIncompatiblePattern$6(char c) {
        throw new IllegalArgumentException(new StringBuilder(27).append("Illegal pattern character: ").append(c).toString());
    }

    private DateTimeFormatterHelper$() {
        MODULE$ = this;
        this.cache = CacheBuilder.newBuilder().maximumSize(128L).build();
        this.extractor = new StringOps(Predef$.MODULE$.augmentString("^([^S]*)(S*)(.*)$")).r();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("LLL qqq", Locale.US);
        String string = formatter.format(LocalDate.of(2000, 1, 1));
        String string2 = "1 1";
        this.bugInStandAloneForm = !(string != null ? !string.equals(string2) : string2 != null);
        this.weekBasedLetters = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapCharArray(new char[]{'Y', 'W', 'w', 'u', 'e', 'c'}));
        this.unsupportedLetters = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapCharArray(new char[]{'A', 'B', 'n', 'N', 'p'}));
        this.unsupportedLettersForParsing = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapCharArray(new char[]{'E', 'F', 'q', 'Q'}));
        this.unsupportedPatternLengths = ((TraversableOnce)((TraversableLike)((TraversableLike)new .colon.colon((Object)"G", (List)new .colon.colon((Object)"M", (List)new .colon.colon((Object)"L", (List)new .colon.colon((Object)"E", (List)new .colon.colon((Object)"Q", (List)new .colon.colon((Object)"q", (List)Nil$.MODULE$))))))).map((Function1 & Serializable & scala.Serializable)x$1 -> new StringOps(Predef$.MODULE$.augmentString(x$1)).$times(5), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)((TraversableLike)new .colon.colon((Object)"y", (List)Nil$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$2 -> new StringOps(Predef$.MODULE$.augmentString(x$2)).$times(7), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).toSet();
    }
}

