/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import org.apache.spark.SparkDateTimeException;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.MakeTimestamp$;
import org.apache.spark.sql.catalyst.expressions.SeptenaryExpression;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function7;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple10;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(year, month, day, hour, min, sec[, timezone]) - Create timestamp from year, month, day, hour, min, sec and timezone fields. The result data type is consistent with the value of configuration `spark.sql.timestampType`. If the configuration `spark.sql.ansi.enabled` is false, the function returns NULL on invalid inputs. Otherwise, it will throw an error instead.", arguments="\n    Arguments:\n      * year - the year to represent, from 1 to 9999\n      * month - the month-of-year to represent, from 1 (January) to 12 (December)\n      * day - the day-of-month to represent, from 1 to 31\n      * hour - the hour-of-day to represent, from 0 to 23\n      * min - the minute-of-hour to represent, from 0 to 59\n      * sec - the second-of-minute and its micro-fraction to represent, from 0 to 60.\n              The value can be either an integer like 13 , or a fraction like 13.123.\n              If the sec argument equals to 60, the seconds field is set\n              to 0 and 1 minute is added to the final timestamp.\n      * timezone - the time zone identifier. For example, CET, UTC and etc.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(2014, 12, 28, 6, 30, 45.887);\n       2014-12-28 06:30:45.887\n      > SELECT _FUNC_(2014, 12, 28, 6, 30, 45.887, 'CET');\n       2014-12-27 21:30:45.887\n      > SELECT _FUNC_(2019, 6, 30, 23, 59, 60);\n       2019-07-01 00:00:00\n      > SELECT _FUNC_(2019, 6, 30, 23, 59, 1);\n       2019-06-30 23:59:01\n      > SELECT _FUNC_(null, 7, 22, 15, 30, 0);\n       NULL\n  ", group="datetime_funcs", since="3.0.0")
@ScalaSignature(bytes="\u0006\u0001\r\u0005b\u0001B!C\u0001>C\u0001B\u001b\u0001\u0003\u0016\u0004%\ta\u001b\u0005\t_\u0002\u0011\t\u0012)A\u0005Y\"A\u0001\u000f\u0001BK\u0002\u0013\u00051\u000e\u0003\u0005r\u0001\tE\t\u0015!\u0003m\u0011!\u0011\bA!f\u0001\n\u0003Y\u0007\u0002C:\u0001\u0005#\u0005\u000b\u0011\u00027\t\u0011Q\u0004!Q3A\u0005\u0002-D\u0001\"\u001e\u0001\u0003\u0012\u0003\u0006I\u0001\u001c\u0005\tm\u0002\u0011)\u001a!C\u0001W\"Aq\u000f\u0001B\tB\u0003%A\u000e\u0003\u0005y\u0001\tU\r\u0011\"\u0001l\u0011!I\bA!E!\u0002\u0013a\u0007\u0002\u0003>\u0001\u0005+\u0007I\u0011A>\t\u0011}\u0004!\u0011#Q\u0001\nqD!\"!\u0001\u0001\u0005+\u0007I\u0011AA\u0002\u0011)\ti\u0002\u0001B\tB\u0003%\u0011Q\u0001\u0005\u000b\u0003?\u0001!Q3A\u0005\u0002\u0005\u0005\u0002BCA\u0015\u0001\tE\t\u0015!\u0003\u0002$!Q\u00111\u0006\u0001\u0003\u0016\u0004%\t%!\f\t\u0015\u0005m\u0002A!E!\u0002\u0013\ty\u0003C\u0004\u0002>\u0001!\t!a\u0010\t\u000f\u0005u\u0002\u0001\"\u0001\u0002X!9\u0011Q\b\u0001\u0005\u0002\u0005\u0015\u0004bBA;\u0001\u0011\u0005\u0013q\u000f\u0005\b\u0003\u0013\u0003A\u0011IAF\u0011\u001d\t)\n\u0001C!\u0003CAq!a&\u0001\t\u0003\nI\nC\u0004\u0002\u001e\u0002!I!a(\t\u000f\u0005U\u0007\u0001\"\u0011\u0002X\"9\u0011\u0011\u001e\u0001\u0005B\u0005-\bb\u0002B\u0004\u0001\u0011\u0005#\u0011\u0002\u0005\b\u0005\u0017\u0001A\u0011\u000bB\u0007\u0011%\u0011I\u0002AA\u0001\n\u0003\u0011Y\u0002C\u0005\u00032\u0001\t\n\u0011\"\u0001\u00034!I!\u0011\n\u0001\u0012\u0002\u0013\u0005!1\u0007\u0005\n\u0005\u0017\u0002\u0011\u0013!C\u0001\u0005gA\u0011B!\u0014\u0001#\u0003%\tAa\r\t\u0013\t=\u0003!%A\u0005\u0002\tM\u0002\"\u0003B)\u0001E\u0005I\u0011\u0001B\u001a\u0011%\u0011\u0019\u0006AI\u0001\n\u0003\u0011)\u0006C\u0005\u0003Z\u0001\t\n\u0011\"\u0001\u0003\\!I!q\f\u0001\u0012\u0002\u0013\u0005!\u0011\r\u0005\n\u0005K\u0002\u0011\u0013!C\u0001\u0005OB\u0011Ba\u001b\u0001\u0003\u0003%\tE!\u001c\t\u0013\te\u0004!!A\u0005\u0002\tm\u0004\"\u0003B?\u0001\u0005\u0005I\u0011\u0001B@\u0011%\u0011)\tAA\u0001\n\u0003\u00129\tC\u0005\u0003\u0016\u0002\t\t\u0011\"\u0001\u0003\u0018\"I!1\u0014\u0001\u0002\u0002\u0013\u0005#QT\u0004\n\u0005\u000f\u0014\u0015\u0011!E\u0001\u0005\u00134\u0001\"\u0011\"\u0002\u0002#\u0005!1\u001a\u0005\b\u0003{\u0019D\u0011\u0001Bm\u0011%\u0011YnMA\u0001\n\u000b\u0012i\u000eC\u0005\u0003`N\n\t\u0011\"!\u0003b\"I!q_\u001a\u0012\u0002\u0013\u0005!Q\u000b\u0005\n\u0005s\u001c\u0014\u0013!C\u0001\u00057B\u0011Ba?4#\u0003%\tA!\u0019\t\u0013\tu8'%A\u0005\u0002\t\u001d\u0004\"\u0003B\u0000g\u0005\u0005I\u0011QB\u0001\u0011%\u0019yaMI\u0001\n\u0003\u0011)\u0006C\u0005\u0004\u0012M\n\n\u0011\"\u0001\u0003\\!I11C\u001a\u0012\u0002\u0013\u0005!\u0011\r\u0005\n\u0007+\u0019\u0014\u0013!C\u0001\u0005OB\u0011ba\u00064\u0003\u0003%Ia!\u0007\u0003\u001b5\u000b7.\u001a+j[\u0016\u001cH/Y7q\u0015\t\u0019E)A\u0006fqB\u0014Xm]:j_:\u001c(BA#G\u0003!\u0019\u0017\r^1msN$(BA$I\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0013*\u000bQa\u001d9be.T!a\u0013'\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0015aA8sO\u000e\u00011c\u0002\u0001Q)^S\u0016m\u001a\t\u0003#Jk\u0011AQ\u0005\u0003'\n\u00131cU3qi\u0016t\u0017M]=FqB\u0014Xm]:j_:\u0004\"!U+\n\u0005Y\u0013%a\u0006+j[\u0016TvN\\3Bo\u0006\u0014X-\u0012=qe\u0016\u001c8/[8o!\t\t\u0006,\u0003\u0002Z\u0005\n1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u0002\\=:\u0011\u0011\u000bX\u0005\u0003;\n\u000bq\u0001]1dW\u0006<W-\u0003\u0002`A\nqa*\u001e7m\u0013:$x\u000e\\3sC:$(BA/C!\t\u0011W-D\u0001d\u0015\u0005!\u0017!B:dC2\f\u0017B\u00014d\u0005\u001d\u0001&o\u001c3vGR\u0004\"A\u00195\n\u0005%\u001c'\u0001D*fe&\fG.\u001b>bE2,\u0017\u0001B=fCJ,\u0012\u0001\u001c\t\u0003#6L!A\u001c\"\u0003\u0015\u0015C\bO]3tg&|g.A\u0003zK\u0006\u0014\b%A\u0003n_:$\b.\u0001\u0004n_:$\b\u000eI\u0001\u0004I\u0006L\u0018\u0001\u00023bs\u0002\nA\u0001[8ve\u0006)\u0001n\\;sA\u0005\u0019Q.\u001b8\u0002\t5Lg\u000eI\u0001\u0004g\u0016\u001c\u0017\u0001B:fG\u0002\n\u0001\u0002^5nKj|g.Z\u000b\u0002yB\u0019!- 7\n\u0005y\u001c'AB(qi&|g.A\u0005uS6,'p\u001c8fA\u0005QA/[7f5>tW-\u00133\u0016\u0005\u0005\u0015\u0001\u0003\u00022~\u0003\u000f\u0001B!!\u0003\u0002\u00189!\u00111BA\n!\r\tiaY\u0007\u0003\u0003\u001fQ1!!\u0005O\u0003\u0019a$o\\8u}%\u0019\u0011QC2\u0002\rA\u0013X\rZ3g\u0013\u0011\tI\"a\u0007\u0003\rM#(/\u001b8h\u0015\r\t)bY\u0001\fi&lWMW8oK&#\u0007%A\u0006gC&dwJ\\#se>\u0014XCAA\u0012!\r\u0011\u0017QE\u0005\u0004\u0003O\u0019'a\u0002\"p_2,\u0017M\\\u0001\rM\u0006LGn\u00148FeJ|'\u000fI\u0001\tI\u0006$\u0018\rV=qKV\u0011\u0011q\u0006\t\u0005\u0003c\t9$\u0004\u0002\u00024)\u0019\u0011Q\u0007$\u0002\u000bQL\b/Z:\n\t\u0005e\u00121\u0007\u0002\t\t\u0006$\u0018\rV=qK\u0006IA-\u0019;b)f\u0004X\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015-\u0005\u0005\u00131IA#\u0003\u000f\nI%a\u0013\u0002N\u0005=\u0013\u0011KA*\u0003+\u0002\"!\u0015\u0001\t\u000b),\u0002\u0019\u00017\t\u000bA,\u0002\u0019\u00017\t\u000bI,\u0002\u0019\u00017\t\u000bQ,\u0002\u0019\u00017\t\u000bY,\u0002\u0019\u00017\t\u000ba,\u0002\u0019\u00017\t\u000fi,\u0002\u0013!a\u0001y\"I\u0011\u0011A\u000b\u0011\u0002\u0003\u0007\u0011Q\u0001\u0005\n\u0003?)\u0002\u0013!a\u0001\u0003GA\u0011\"a\u000b\u0016!\u0003\u0005\r!a\f\u0015\u001d\u0005\u0005\u0013\u0011LA.\u0003;\ny&!\u0019\u0002d!)!N\u0006a\u0001Y\")\u0001O\u0006a\u0001Y\")!O\u0006a\u0001Y\")AO\u0006a\u0001Y\")aO\u0006a\u0001Y\")\u0001P\u0006a\u0001YR\u0001\u0012\u0011IA4\u0003S\nY'!\u001c\u0002p\u0005E\u00141\u000f\u0005\u0006U^\u0001\r\u0001\u001c\u0005\u0006a^\u0001\r\u0001\u001c\u0005\u0006e^\u0001\r\u0001\u001c\u0005\u0006i^\u0001\r\u0001\u001c\u0005\u0006m^\u0001\r\u0001\u001c\u0005\u0006q^\u0001\r\u0001\u001c\u0005\u0006u^\u0001\r\u0001\\\u0001\tG\"LG\u000e\u001a:f]V\u0011\u0011\u0011\u0010\t\u0006\u0003w\n\u0019\t\u001c\b\u0005\u0003{\n\tI\u0004\u0003\u0002\u000e\u0005}\u0014\"\u00013\n\u0005u\u001b\u0017\u0002BAC\u0003\u000f\u00131aU3r\u0015\ti6-\u0001\u0006j]B,H\u000fV=qKN,\"!!$\u0011\r\u0005m\u00141QAH!\u0011\t\t$!%\n\t\u0005M\u00151\u0007\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016\f\u0001B\\;mY\u0006\u0014G.Z\u0001\ro&$\b\u000eV5nKj{g.\u001a\u000b\u0004)\u0006m\u0005bBA\u00017\u0001\u0007\u0011qA\u0001\ti>l\u0015n\u0019:pgR\u0001\u0012\u0011UAT\u0003_\u000b\t,a-\u00026\u0006]\u0016\u0011\u0019\t\u0004E\u0006\r\u0016bAASG\n\u0019\u0011I\\=\t\r)d\u0002\u0019AAU!\r\u0011\u00171V\u0005\u0004\u0003[\u001b'aA%oi\"1\u0001\u000f\ba\u0001\u0003SCaA\u001d\u000fA\u0002\u0005%\u0006B\u0002;\u001d\u0001\u0004\tI\u000b\u0003\u0004w9\u0001\u0007\u0011\u0011\u0016\u0005\b\u0003sc\u0002\u0019AA^\u00031\u0019XmY!oI6K7M]8t!\u0011\t\t$!0\n\t\u0005}\u00161\u0007\u0002\b\t\u0016\u001c\u0017.\\1m\u0011\u001d\t\u0019\r\ba\u0001\u0003\u000b\faA_8oK&#\u0007\u0003BAd\u0003#l!!!3\u000b\t\u0005-\u0017QZ\u0001\u0005i&lWM\u0003\u0002\u0002P\u0006!!.\u0019<b\u0013\u0011\t\u0019.!3\u0003\ri{g.Z%e\u00031qW\u000f\u001c7TC\u001a,WI^1m)A\t\t+!7\u0002\\\u0006u\u0017q\\Aq\u0003G\f)\u000f\u0003\u0004k;\u0001\u0007\u0011\u0011\u0015\u0005\u0007av\u0001\r!!)\t\rIl\u0002\u0019AAQ\u0011\u0019!X\u00041\u0001\u0002\"\"1a/\ba\u0001\u0003CCa\u0001_\u000fA\u0002\u0005\u0005\u0006B\u0002>\u001e\u0001\u0004\t9\u000f\u0005\u0003c{\u0006\u0005\u0016!\u00033p\u000f\u0016t7i\u001c3f)\u0019\ti/!?\u0003\u0004A!\u0011q^A{\u001b\t\t\tPC\u0002\u0002t\n\u000bqaY8eK\u001e,g.\u0003\u0003\u0002x\u0006E(\u0001C#yaJ\u001cu\u000eZ3\t\u000f\u0005mh\u00041\u0001\u0002~\u0006\u00191\r\u001e=\u0011\t\u0005=\u0018q`\u0005\u0005\u0005\u0003\t\tP\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000f\t\u0015a\u00041\u0001\u0002n\u0006\u0011QM^\u0001\t]>$WMT1nKV\u0011\u0011qA\u0001\u0018o&$\bNT3x\u0007\"LG\u000e\u001a:f]&sG/\u001a:oC2$B!!\u0011\u0003\u0010!9!\u0011\u0003\u0011A\u0002\tM\u0011a\u00038fo\u000eC\u0017\u000e\u001c3sK:\u0004R!a\u001f\u0003\u00161LAAa\u0006\u0002\b\nQ\u0011J\u001c3fq\u0016$7+Z9\u0002\t\r|\u0007/\u001f\u000b\u0017\u0003\u0003\u0012iBa\b\u0003\"\t\r\"Q\u0005B\u0014\u0005S\u0011YC!\f\u00030!9!.\tI\u0001\u0002\u0004a\u0007b\u00029\"!\u0003\u0005\r\u0001\u001c\u0005\be\u0006\u0002\n\u00111\u0001m\u0011\u001d!\u0018\u0005%AA\u00021DqA^\u0011\u0011\u0002\u0003\u0007A\u000eC\u0004yCA\u0005\t\u0019\u00017\t\u000fi\f\u0003\u0013!a\u0001y\"I\u0011\u0011A\u0011\u0011\u0002\u0003\u0007\u0011Q\u0001\u0005\n\u0003?\t\u0003\u0013!a\u0001\u0003GA\u0011\"a\u000b\"!\u0003\u0005\r!a\f\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!Q\u0007\u0016\u0004Y\n]2F\u0001B\u001d!\u0011\u0011YD!\u0012\u000e\u0005\tu\"\u0002\u0002B \u0005\u0003\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t\r3-\u0001\u0006b]:|G/\u0019;j_:LAAa\u0012\u0003>\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0014AD2paf$C-\u001a4bk2$H\u0005N\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00136\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIY\nabY8qs\u0012\"WMZ1vYR$s'\u0006\u0002\u0003X)\u001aAPa\u000e\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%qU\u0011!Q\f\u0016\u0005\u0003\u000b\u00119$\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001d\u0016\u0005\t\r$\u0006BA\u0012\u0005o\tqbY8qs\u0012\"WMZ1vYR$\u0013\u0007M\u000b\u0003\u0005SRC!a\f\u00038\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"Aa\u001c\u0011\t\tE$qO\u0007\u0003\u0005gRAA!\u001e\u0002N\u0006!A.\u00198h\u0013\u0011\tIBa\u001d\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005%\u0016A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003C\u0013\t\tC\u0005\u0003\u0004:\n\t\u00111\u0001\u0002*\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"A!#\u0011\r\t-%\u0011SAQ\u001b\t\u0011iIC\u0002\u0003\u0010\u000e\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011\u0019J!$\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003G\u0011I\nC\u0005\u0003\u0004B\n\t\u00111\u0001\u0002\"\u00061Q-];bYN$B!a\t\u0003 \"I!1Q\u0019\u0002\u0002\u0003\u0007\u0011\u0011\u0015\u0015\u0018\u0001\t\r&\u0011\u0016BV\u0005_\u0013\tL!.\u00038\nm&Q\u0018Ba\u0005\u0007\u00042!\u0015BS\u0013\r\u00119K\u0011\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\u0011i+\u0001Bq?\u001a+fjQ0)s\u0016\f'\u000f\f\u0011n_:$\b\u000e\f\u0011eCfd\u0003\u0005[8ve2\u0002S.\u001b8-AM,7m\u0017\u0017!i&lWM_8oKvK\u0003%\f\u0011De\u0016\fG/\u001a\u0011uS6,7\u000f^1na\u00022'o\\7!s\u0016\f'\u000f\f\u0011n_:$\b\u000e\f\u0011eCfd\u0003\u0005[8ve2\u0002S.\u001b8-AM,7\rI1oI\u0002\"\u0018.\\3{_:,\u0007EZ5fY\u0012\u001ch\u0006\t+iK\u0002\u0012Xm];mi\u0002\"\u0017\r^1!if\u0004X\rI5tA\r|gn]5ti\u0016tG\u000fI<ji\"\u0004C\u000f[3!m\u0006dW/\u001a\u0011pM\u0002\u001awN\u001c4jOV\u0014\u0018\r^5p]\u0002\u00027\u000f]1sW:\u001a\u0018\u000f\u001c\u0018uS6,7\u000f^1naRK\b/\u001a1/A%3\u0007\u0005\u001e5fA\r|gNZ5hkJ\fG/[8oA\u0001\u001c\b/\u0019:l]M\fHNL1og&tSM\\1cY\u0016$\u0007\rI5tA\u0019\fGn]3-AQDW\r\t4v]\u000e$\u0018n\u001c8!e\u0016$XO\u001d8tA9+F\n\u0014\u0011p]\u0002JgN^1mS\u0012\u0004\u0013N\u001c9viNt\u0003e\u0014;iKJ<\u0018n]3-A%$\be^5mY\u0002\"\bN]8xA\u0005t\u0007%\u001a:s_J\u0004\u0013N\\:uK\u0006$g&A\u0005be\u001e,X.\u001a8ug\u0006\u0012!1W\u0001\u0006\u0018*\u0001\u0003\u0005\t\u0011Be\u001e,X.\u001a8ugjR\u0001\u0005\t\u0011!A\u0001R\u0003%_3be\u0002j\u0003\u0005\u001e5fAe,\u0017M\u001d\u0011u_\u0002\u0012X\r\u001d:fg\u0016tG\u000f\f\u0011ge>l\u0007%\r\u0011u_\u0002J\u0014(O\u001d\u000bA\u0001\u0002\u0003\u0005\t\u0011+A5|g\u000e\u001e5![\u0001\"\b.\u001a\u0011n_:$\b.L8g[e,\u0017M\u001d\u0011u_\u0002\u0012X\r\u001d:fg\u0016tG\u000f\f\u0011ge>l\u0007%\r\u0011)\u0015\u0006tW/\u0019:zS\u0001\"x\u000eI\u00193A!\"UmY3nE\u0016\u0014\u0018F\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011eCf\u0004S\u0006\t;iK\u0002\"\u0017-_\u0017pM6jwN\u001c;iAQ|\u0007E]3qe\u0016\u001cXM\u001c;-A\u0019\u0014x.\u001c\u00112AQ|\u0007eM\u0019\u000bA\u0001\u0002\u0003\u0005\t\u0011+A!|WO\u001d\u0011.AQDW\r\t5pkJlsNZ\u0017eCf\u0004Co\u001c\u0011sKB\u0014Xm]3oi2\u0002cM]8nAA\u0002Co\u001c\u00113g)\u0001\u0003\u0005\t\u0011!A)\u0002S.\u001b8![\u0001\"\b.\u001a\u0011nS:,H/Z\u0017pM6Bw.\u001e:!i>\u0004#/\u001a9sKN,g\u000e\u001e\u0017!MJ|W\u000e\t\u0019!i>\u0004S'\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!g\u0016\u001c\u0007%\f\u0011uQ\u0016\u00043/Z2p]\u0012lsNZ\u0017nS:,H/\u001a\u0011b]\u0012\u0004\u0013\u000e^:![&\u001c'o\\\u0017ge\u0006\u001cG/[8oAQ|\u0007E]3qe\u0016\u001cXM\u001c;-A\u0019\u0014x.\u001c\u00111AQ|\u0007E\u000e\u0019/\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!AQCW\r\t<bYV,\u0007eY1oA\t,\u0007%Z5uQ\u0016\u0014\b%\u00198!S:$XmZ3sA1L7.\u001a\u00112g\u0001b\u0003e\u001c:!C\u00022'/Y2uS>t\u0007\u0005\\5lK\u0002\n4GL\u00193g9R\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0013J\u001a\u0011uQ\u0016\u00043/Z2!CJ<W/\\3oi\u0002*\u0017/^1mg\u0002\"x\u000e\t\u001c1Y\u0001\"\b.\u001a\u0011tK\u000e|g\u000eZ:!M&,G\u000e\u001a\u0011jg\u0002\u001aX\r\u001e\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011u_\u0002\u0002\u0004%\u00198eAE\u0002S.\u001b8vi\u0016\u0004\u0013n\u001d\u0011bI\u0012,G\r\t;pAQDW\r\t4j]\u0006d\u0007\u0005^5nKN$\u0018-\u001c9/\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001\"\u0018.\\3{_:,\u0007%\f\u0011uQ\u0016\u0004C/[7fAi|g.\u001a\u0011jI\u0016tG/\u001b4jKJt\u0003ER8sA\u0015D\u0018-\u001c9mK2\u00023)\u0012+-AU#6\tI1oI\u0002*Go\u0019\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0005s\u000b1Q\u0004\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)eA\nD\u0007\f\u00112e1\u0002#\u0007\u000f\u0017!m1\u00023\u0007\r\u0017!iUr\u0003\bO\u001c*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0012\u0004'\r\u001b.cIj#\u0007\u000f\u00111mi\u001a\u0004G\u000f\u001b6]aBtG\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u00153aE\"D\u0006I\u00193Y\u0001\u0012\u0004\b\f\u00117Y\u0001\u001a\u0004\u0007\f\u00115k9B\u0004h\u000e\u0017!O\r+EkJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AI\u0002\u0014\u0007N\u00172e5\u0012t\u0007\t\u001a2uM\u0002$\bN\u001b/qa:$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\f\u000b\u001a1ceb\u0003E\u000e\u0017!gAb\u0003EM\u001a-AUJD\u0006\t\u001c1SmR\u0001\u0005\t\u0011!A\u0001\u0002#\u0007M\u0019:[A:T\u0006M\u0019!aAR\u0004\u0007\r\u001e1a)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C#\u0007M\u0019:Y\u00012D\u0006I\u001a1Y\u0001\u00124\u0007\f\u00116s1\u0002\u0013'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!eA\n\u0014(\f\u00197[M\u0002\u0004EM\u001a;keR\u0004'\r\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)]VdG\u000e\f\u00118Y\u0001\u0012$\u0007\f\u00112k1\u00023\u0007\r\u0017!a%Z$\u0002\t\u0011!A\u0001\u0002\u0003ET+M\u0019*\u0001\u0003%A\u0003he>,\b/\t\u0002\u0003@\u0006qA-\u0019;fi&lWm\u00184v]\u000e\u001c\u0018!B:j]\u000e,\u0017E\u0001Bc\u0003\u0015\u0019d\u0006\r\u00181\u00035i\u0015m[3US6,7\u000f^1naB\u0011\u0011kM\n\u0005g\t5w\rE\n\u0003P\nUG\u000e\u001c7mY2d\u0018QAA\u0012\u0003_\t\t%\u0004\u0002\u0003R*\u0019!1[2\u0002\u000fI,h\u000e^5nK&!!q\u001bBi\u0005I\t%m\u001d;sC\u000e$h)\u001e8di&|g.\r\u0019\u0015\u0005\t%\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\t=\u0014!B1qa2LHCFA!\u0005G\u0014)Oa:\u0003j\n-(Q\u001eBx\u0005c\u0014\u0019P!>\t\u000b)4\u0004\u0019\u00017\t\u000bA4\u0004\u0019\u00017\t\u000bI4\u0004\u0019\u00017\t\u000bQ4\u0004\u0019\u00017\t\u000bY4\u0004\u0019\u00017\t\u000ba4\u0004\u0019\u00017\t\u000fi4\u0004\u0013!a\u0001y\"I\u0011\u0011\u0001\u001c\u0011\u0002\u0003\u0007\u0011Q\u0001\u0005\n\u0003?1\u0004\u0013!a\u0001\u0003GA\u0011\"a\u000b7!\u0003\u0005\r!a\f\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uI]\nq\"\u00199qYf$C-\u001a4bk2$H\u0005O\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%s\u0005\u0001\u0012\r\u001d9ms\u0012\"WMZ1vYR$\u0013\u0007M\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0019\u0019aa\u0003\u0011\t\tl8Q\u0001\t\u0011E\u000e\u001dA\u000e\u001c7mY2d\u0018QAA\u0012\u0003_I1a!\u0003d\u0005\u001d!V\u000f\u001d7fcAB\u0011b!\u0004<\u0003\u0003\u0005\r!!\u0011\u0002\u0007a$\u0003'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeN\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001d\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u0013:\u0003q!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%cA\n1B]3bIJ+7o\u001c7wKR\u001111\u0004\t\u0005\u0005c\u001ai\"\u0003\u0003\u0004 \tM$AB(cU\u0016\u001cG\u000f")
public class MakeTimestamp
extends SeptenaryExpression
implements TimeZoneAwareExpression,
ImplicitCastInputTypes,
package.NullIntolerant,
scala.Serializable {
    private final Expression year;
    private final Expression month;
    private final Expression day;
    private final Expression hour;
    private final Expression min;
    private final Expression sec;
    private final Option<Expression> timezone;
    private final Option<String> timeZoneId;
    private final boolean failOnError;
    private final DataType dataType;
    private boolean resolved;
    private final Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static DataType $lessinit$greater$default$10() {
        return MakeTimestamp$.MODULE$.$lessinit$greater$default$10();
    }

    public static boolean $lessinit$greater$default$9() {
        return MakeTimestamp$.MODULE$.$lessinit$greater$default$9();
    }

    public static Option<String> $lessinit$greater$default$8() {
        return MakeTimestamp$.MODULE$.$lessinit$greater$default$8();
    }

    public static Option<Expression> $lessinit$greater$default$7() {
        return MakeTimestamp$.MODULE$.$lessinit$greater$default$7();
    }

    public static Option<Tuple10<Expression, Expression, Expression, Expression, Expression, Expression, Option<Expression>, Option<String>, Object, DataType>> unapply(MakeTimestamp makeTimestamp) {
        return MakeTimestamp$.MODULE$.unapply(makeTimestamp);
    }

    public static DataType apply$default$10() {
        return MakeTimestamp$.MODULE$.apply$default$10();
    }

    public static boolean apply$default$9() {
        return MakeTimestamp$.MODULE$.apply$default$9();
    }

    public static Option<String> apply$default$8() {
        return MakeTimestamp$.MODULE$.apply$default$8();
    }

    public static Option<Expression> apply$default$7() {
        return MakeTimestamp$.MODULE$.apply$default$7();
    }

    public static Function1<Tuple10<Expression, Expression, Expression, Expression, Expression, Expression, Option<Expression>, Option<String>, Object, DataType>, MakeTimestamp> tupled() {
        return MakeTimestamp$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Option<Expression>, Function1<Option<String>, Function1<Object, Function1<DataType, MakeTimestamp>>>>>>>>>> curried() {
        return MakeTimestamp$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Seq<Enumeration.Value> nodePatternsInternal() {
        return TimeZoneAwareExpression.nodePatternsInternal$(this);
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    private boolean resolved$lzycompute() {
        MakeTimestamp makeTimestamp = this;
        synchronized (makeTimestamp) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        MakeTimestamp makeTimestamp = this;
        synchronized (makeTimestamp) {
            if (!this.bitmap$trans$0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        return !this.bitmap$trans$0 ? this.zoneId$lzycompute() : this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression year() {
        return this.year;
    }

    public Expression month() {
        return this.month;
    }

    public Expression day() {
        return this.day;
    }

    public Expression hour() {
        return this.hour;
    }

    public Expression min() {
        return this.min;
    }

    public Expression sec() {
        return this.sec;
    }

    public Option<Expression> timezone() {
        return this.timezone;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    @Override
    public DataType dataType() {
        return this.dataType;
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)((TraversableLike)new .colon.colon((Object)this.year(), (List)new .colon.colon((Object)this.month(), (List)new .colon.colon((Object)this.day(), (List)new .colon.colon((Object)this.hour(), (List)new .colon.colon((Object)this.min(), (List)new .colon.colon((Object)this.sec(), (List)Nil$.MODULE$))))))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.timezone()), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)((TraversableLike)new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)new DecimalType(16, 6), (List)Nil$.MODULE$))))))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.timezone().map((Function1 & Serializable & scala.Serializable)x$14 -> StringType$.MODULE$)), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public boolean nullable() {
        return this.failOnError() ? this.children().exists((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)x$15.nullable())) : true;
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        Expression x$5 = this.copy$default$4();
        Expression x$6 = this.copy$default$5();
        Expression x$7 = this.copy$default$6();
        Option<Expression> x$8 = this.copy$default$7();
        boolean x$9 = this.copy$default$9();
        DataType x$10 = this.copy$default$10();
        return this.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, (Option<String>)x$1, x$9, x$10);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object toMicros(int year, int month, int day, int hour, int min, Decimal secAndMicros, ZoneId zoneId) {
        try {
            Long l;
            LocalDateTime localDateTime;
            Predef$.MODULE$.assert(secAndMicros.scale() == 6, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Seconds fraction must have 6 digits for microseconds but got ").append(secAndMicros.scale()).toString());
            long unscaledSecFrac = secAndMicros.toUnscaledLong();
            int totalMicros = (int)unscaledSecFrac;
            int seconds = Math.floorDiv(totalMicros, (int)1000000L);
            int nanos = Math.floorMod(totalMicros, (int)1000000L) * (int)1000L;
            if (seconds == 60) {
                if (nanos != 0) throw QueryExecutionErrors$.MODULE$.invalidFractionOfSecondError();
                localDateTime = LocalDateTime.of(year, month, day, hour, min, 0, 0).plusMinutes(1L);
            } else {
                localDateTime = LocalDateTime.of(year, month, day, hour, min, seconds, nanos);
            }
            LocalDateTime ldt = localDateTime;
            DataType dataType = this.dataType();
            TimestampType$ timestampType$ = TimestampType$.MODULE$;
            if (!(dataType != null ? !dataType.equals(timestampType$) : timestampType$ != null)) {
                l = BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.instantToMicros(ldt.atZone(zoneId).toInstant()));
                return l;
            }
            l = BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.localDateTimeToMicros(ldt));
            return l;
        }
        catch (Throwable throwable) {
            boolean bl = false;
            DateTimeException dateTimeException = null;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof SparkDateTimeException) {
                SparkDateTimeException sparkDateTimeException = (SparkDateTimeException)throwable2;
                if (this.failOnError()) {
                    throw sparkDateTimeException;
                }
            }
            if (throwable2 instanceof DateTimeException) {
                bl = true;
                dateTimeException = (DateTimeException)throwable2;
                if (this.failOnError()) {
                    throw QueryExecutionErrors$.MODULE$.ansiDateTimeError(dateTimeException);
                }
            }
            if (!bl) throw throwable;
            return null;
        }
    }

    @Override
    public Object nullSafeEval(Object year, Object month, Object day, Object hour, Object min, Object sec, Option<Object> timezone) {
        ZoneId zid = (ZoneId)timezone.map((Function1 & Serializable & scala.Serializable)tz -> DateTimeUtils$.MODULE$.getZoneId(((UTF8String)tz).toString())).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.zoneId());
        return this.toMicros(BoxesRunTime.unboxToInt((Object)year), BoxesRunTime.unboxToInt((Object)month), BoxesRunTime.unboxToInt((Object)day), BoxesRunTime.unboxToInt((Object)hour), BoxesRunTime.unboxToInt((Object)min), (Decimal)sec, zid);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String dtu = new StringOps(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName())).stripSuffix("$");
        String zid = ctx.addReferenceObj("zoneId", this.zoneId(), ZoneId.class.getName());
        String d = new StringOps(Predef$.MODULE$.augmentString(Decimal$.MODULE$.getClass().getName())).stripSuffix("$");
        String failOnErrorBranch = this.failOnError() ? "throw QueryExecutionErrors.ansiDateTimeError(e);" : new StringBuilder(8).append(ev.isNull()).append(" = true;").toString();
        String failOnSparkErrorBranch = this.failOnError() ? "throw e;" : new StringBuilder(8).append(ev.isNull()).append(" = true;").toString();
        return this.nullSafeCodeGen(ctx, ev, (Function7<String, String, String, String, String, String, Option<String>, String>)(Function7 & Serializable & scala.Serializable)(year, month, day, hour, min, secAndNanos, timezone) -> {
            String zoneId = (String)timezone.map((Function1 & Serializable & scala.Serializable)tz -> new StringBuilder(23).append(dtu).append(".getZoneId(").append((String)tz).append(".toString())").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> zid);
            DataType dataType = this.dataType();
            TimestampType$ timestampType$ = TimestampType$.MODULE$;
            String toMicrosCode = !(dataType != null ? !dataType.equals(timestampType$) : timestampType$ != null) ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(121).append("\n           |java.time.Instant instant = ldt.atZone(").append(zoneId).append(").toInstant();\n           |").append(ev.value()).append(" = ").append(dtu).append(".instantToMicros(instant);\n           |").toString())).stripMargin() : new StringBuilder(31).append(ev.value()).append(" = ").append(dtu).append(".localDateTimeToMicros(ldt);").toString();
            return new StringBuilder(809).append("\n      try {\n        org.apache.spark.sql.types.Decimal secFloor = ").append((String)secAndNanos).append(".floor();\n        org.apache.spark.sql.types.Decimal nanosPerSec = ").append(d).append("$.MODULE$.apply(1000000000L, 10, 0);\n        int nanos = ((").append((String)secAndNanos).append(".$minus(secFloor)).$times(nanosPerSec)).toInt();\n        int seconds = secFloor.toInt();\n        java.time.LocalDateTime ldt;\n        if (seconds == 60) {\n          if (nanos == 0) {\n            ldt = java.time.LocalDateTime.of(\n              ").append((String)year).append(", ").append((String)month).append(", ").append((String)day).append(", ").append((String)hour).append(", ").append((String)min).append(", 0, 0).plusMinutes(1);\n          } else {\n            throw QueryExecutionErrors.invalidFractionOfSecondError();\n          }\n        } else {\n          ldt = java.time.LocalDateTime.of(").append((String)year).append(", ").append((String)month).append(", ").append((String)day).append(", ").append((String)hour).append(", ").append((String)min).append(", seconds, nanos);\n        }\n        ").append(toMicrosCode).append("\n      } catch (org.apache.spark.SparkDateTimeException e) {\n        ").append(failOnSparkErrorBranch).append("\n      } catch (java.time.DateTimeException e) {\n        ").append(failOnErrorBranch).append("\n      }").toString();
        });
    }

    @Override
    public String nodeName() {
        return "make_timestamp";
    }

    @Override
    public MakeTimestamp withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        None$ timezoneOpt = this.timezone().isDefined() ? new Some(newChildren.apply(6)) : None$.MODULE$;
        return this.copy((Expression)newChildren.apply(0), (Expression)newChildren.apply(1), (Expression)newChildren.apply(2), (Expression)newChildren.apply(3), (Expression)newChildren.apply(4), (Expression)newChildren.apply(5), (Option<Expression>)timezoneOpt, this.copy$default$8(), this.copy$default$9(), this.copy$default$10());
    }

    public MakeTimestamp copy(Expression year, Expression month, Expression day, Expression hour, Expression min, Expression sec, Option<Expression> timezone, Option<String> timeZoneId, boolean failOnError, DataType dataType) {
        return new MakeTimestamp(year, month, day, hour, min, sec, timezone, timeZoneId, failOnError, dataType);
    }

    public Expression copy$default$1() {
        return this.year();
    }

    public DataType copy$default$10() {
        return this.dataType();
    }

    public Expression copy$default$2() {
        return this.month();
    }

    public Expression copy$default$3() {
        return this.day();
    }

    public Expression copy$default$4() {
        return this.hour();
    }

    public Expression copy$default$5() {
        return this.min();
    }

    public Expression copy$default$6() {
        return this.sec();
    }

    public Option<Expression> copy$default$7() {
        return this.timezone();
    }

    public Option<String> copy$default$8() {
        return this.timeZoneId();
    }

    public boolean copy$default$9() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "MakeTimestamp";
    }

    public int productArity() {
        return 10;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.year();
                break;
            }
            case 1: {
                object = this.month();
                break;
            }
            case 2: {
                object = this.day();
                break;
            }
            case 3: {
                object = this.hour();
                break;
            }
            case 4: {
                object = this.min();
                break;
            }
            case 5: {
                object = this.sec();
                break;
            }
            case 6: {
                object = this.timezone();
                break;
            }
            case 7: {
                object = this.timeZoneId();
                break;
            }
            case 8: {
                object = BoxesRunTime.boxToBoolean((boolean)this.failOnError());
                break;
            }
            case 9: {
                object = this.dataType();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MakeTimestamp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MakeTimestamp)) return false;
        boolean bl = true;
        if (!bl) return false;
        MakeTimestamp makeTimestamp = (MakeTimestamp)x$1;
        Expression expression = this.year();
        Expression expression2 = makeTimestamp.year();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.month();
        Expression expression4 = makeTimestamp.month();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.day();
        Expression expression6 = makeTimestamp.day();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        Expression expression7 = this.hour();
        Expression expression8 = makeTimestamp.hour();
        if (expression7 == null) {
            if (expression8 != null) {
                return false;
            }
        } else if (!expression7.equals(expression8)) return false;
        Expression expression9 = this.min();
        Expression expression10 = makeTimestamp.min();
        if (expression9 == null) {
            if (expression10 != null) {
                return false;
            }
        } else if (!expression9.equals(expression10)) return false;
        Expression expression11 = this.sec();
        Expression expression12 = makeTimestamp.sec();
        if (expression11 == null) {
            if (expression12 != null) {
                return false;
            }
        } else if (!expression11.equals(expression12)) return false;
        Option<Expression> option = this.timezone();
        Option<Expression> option2 = makeTimestamp.timezone();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<String> option3 = this.timeZoneId();
        Option<String> option4 = makeTimestamp.timeZoneId();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        if (this.failOnError() != makeTimestamp.failOnError()) return false;
        DataType dataType = this.dataType();
        DataType dataType2 = makeTimestamp.dataType();
        if (dataType == null) {
            if (dataType2 != null) {
                return false;
            }
        } else if (!dataType.equals(dataType2)) return false;
        if (!makeTimestamp.canEqual(this)) return false;
        return true;
    }

    public MakeTimestamp(Expression year, Expression month, Expression day, Expression hour, Expression min, Expression sec, Option<Expression> timezone, Option<String> timeZoneId, boolean failOnError, DataType dataType) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.min = min;
        this.sec = sec;
        this.timezone = timezone;
        this.timeZoneId = timeZoneId;
        this.failOnError = failOnError;
        this.dataType = dataType;
        TimeZoneAwareExpression.$init$(this);
        ExpectsInputTypes.$init$(this);
    }

    public MakeTimestamp(Expression year, Expression month, Expression day, Expression hour, Expression min, Expression sec) {
        this(year, month, day, hour, min, sec, (Option<Expression>)None$.MODULE$, (Option<String>)None$.MODULE$, SQLConf$.MODULE$.get().ansiEnabled(), SQLConf$.MODULE$.get().timestampType());
    }

    public MakeTimestamp(Expression year, Expression month, Expression day, Expression hour, Expression min, Expression sec, Expression timezone) {
        this(year, month, day, hour, min, sec, (Option<Expression>)new Some((Object)timezone), (Option<String>)None$.MODULE$, SQLConf$.MODULE$.get().ansiEnabled(), SQLConf$.MODULE$.get().timestampType());
    }
}

