/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.LengthOfJsonArray$;
import org.apache.spark.sql.catalyst.expressions.SharedFactory$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.json.CreateJacksonParser$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(jsonArray) - Returns the number of elements in the outermost JSON array.", arguments="\n    Arguments:\n      * jsonArray - A JSON array. `NULL` is returned in case of any other valid JSON string,\n          `NULL` or an invalid JSON.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('[1,2,3,4]');\n        4\n      > SELECT _FUNC_('[1,2,3,{\"f1\":1,\"f2\":[5,6]},4]');\n        5\n      > SELECT _FUNC_('[1,2');\n        NULL\n  ", group="json_funcs", since="3.1.0")
@ScalaSignature(bytes="\u0006\u0001\u0005]g\u0001\u0002\u000e\u001c\u0001\"B\u0001b\u0010\u0001\u0003\u0016\u0004%\t\u0001\u0011\u0005\t\t\u0002\u0011\t\u0012)A\u0005\u0003\")Q\t\u0001C\u0001\r\")\u0011\n\u0001C!\u0015\")Q\f\u0001C!=\")q\f\u0001C!A\")A\r\u0001C!K\")a\u000e\u0001C!_\")\u0011\u0010\u0001C\u0005u\"9\u0011Q\u0003\u0001\u0005R\u0005]\u0001\"CA\u000f\u0001\u0005\u0005I\u0011AA\u0010\u0011%\t\u0019\u0003AI\u0001\n\u0003\t)\u0003C\u0005\u0002<\u0001\t\t\u0011\"\u0011\u0002>!I\u0011Q\n\u0001\u0002\u0002\u0013\u0005\u0011q\n\u0005\n\u0003/\u0002\u0011\u0011!C\u0001\u00033B\u0011\"a\u0018\u0001\u0003\u0003%\t%!\u0019\t\u0013\u0005=\u0004!!A\u0005\u0002\u0005E\u0004\"CA;\u0001\u0005\u0005I\u0011IA<\u000f%\t\tkGA\u0001\u0012\u0003\t\u0019K\u0002\u0005\u001b7\u0005\u0005\t\u0012AAS\u0011\u0019)E\u0003\"\u0001\u00024\"I\u0011Q\u0017\u000b\u0002\u0002\u0013\u0015\u0013q\u0017\u0005\n\u0003s#\u0012\u0011!CA\u0003wC\u0011\"a0\u0015\u0003\u0003%\t)!1\t\u0013\u00055G#!A\u0005\n\u0005='!\u0005'f]\u001e$\bn\u00144Kg>t\u0017I\u001d:bs*\u0011A$H\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\u001f?\u0005A1-\u0019;bYf\u001cHO\u0003\u0002!C\u0005\u00191/\u001d7\u000b\u0005\t\u001a\u0013!B:qCJ\\'B\u0001\u0013&\u0003\u0019\t\u0007/Y2iK*\ta%A\u0002pe\u001e\u001c\u0001a\u0005\u0004\u0001S5\u001ad\u0007\u0010\t\u0003U-j\u0011aG\u0005\u0003Ym\u0011q\"\u00168bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003]Ej\u0011a\f\u0006\u0003am\tqaY8eK\u001e,g.\u0003\u00023_\ty1i\u001c3fO\u0016tg)\u00197mE\u0006\u001c7\u000e\u0005\u0002+i%\u0011Qg\u0007\u0002\u0012\u000bb\u0004Xm\u0019;t\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bCA\u001c;\u001b\u0005A$\"A\u001d\u0002\u000bM\u001c\u0017\r\\1\n\u0005mB$a\u0002)s_\u0012,8\r\u001e\t\u0003ouJ!A\u0010\u001d\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u000b\rD\u0017\u000e\u001c3\u0016\u0003\u0005\u0003\"A\u000b\"\n\u0005\r[\"AC#yaJ,7o]5p]\u000611\r[5mI\u0002\na\u0001P5oSRtDCA$I!\tQ\u0003\u0001C\u0003@\u0007\u0001\u0007\u0011)\u0001\u0006j]B,H\u000fV=qKN,\u0012a\u0013\t\u0004\u0019R;fBA'S\u001d\tq\u0015+D\u0001P\u0015\t\u0001v%\u0001\u0004=e>|GOP\u0005\u0002s%\u00111\u000bO\u0001\ba\u0006\u001c7.Y4f\u0013\t)fKA\u0002TKFT!a\u0015\u001d\u0011\u0005a[V\"A-\u000b\u0005i{\u0012!\u0002;za\u0016\u001c\u0018B\u0001/Z\u0005!!\u0015\r^1UsB,\u0017\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003]\u000b\u0001B\\;mY\u0006\u0014G.Z\u000b\u0002CB\u0011qGY\u0005\u0003Gb\u0012qAQ8pY\u0016\fg.\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\u0012A\u001a\t\u0003O.t!\u0001[5\u0011\u00059C\u0014B\u000169\u0003\u0019\u0001&/\u001a3fM&\u0011A.\u001c\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005)D\u0014\u0001B3wC2$\"\u0001]:\u0011\u0005]\n\u0018B\u0001:9\u0005\r\te.\u001f\u0005\bi\"\u0001\n\u00111\u0001v\u0003\u0015Ig\u000e];u!\t1x/D\u0001\u001e\u0013\tAXDA\u0006J]R,'O\\1m%><\u0018\u0001\u00049beN,7i\\;oi\u0016\u0014H\u0003\u00029|\u0003'AQ\u0001`\u0005A\u0002u\fa\u0001]1sg\u0016\u0014\bc\u0001@\u0002\u00105\tqP\u0003\u0003\u0002\u0002\u0005\r\u0011\u0001B2pe\u0016TA!!\u0002\u0002\b\u00059!.Y2lg>t'\u0002BA\u0005\u0003\u0017\t\u0011BZ1ti\u0016\u0014\b0\u001c7\u000b\u0005\u00055\u0011aA2p[&\u0019\u0011\u0011C@\u0003\u0015)\u001bxN\u001c)beN,'\u000fC\u0003u\u0013\u0001\u0007Q/\u0001\u000bxSRDg*Z<DQ&dG-\u00138uKJt\u0017\r\u001c\u000b\u0004\u000f\u0006e\u0001BBA\u000e\u0015\u0001\u0007\u0011)\u0001\u0005oK^\u001c\u0005.\u001b7e\u0003\u0011\u0019w\u000e]=\u0015\u0007\u001d\u000b\t\u0003C\u0004@\u0017A\u0005\t\u0019A!\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\u0005\u0016\u0004\u0003\u0006%2FAA\u0016!\u0011\ti#a\u000e\u000e\u0005\u0005=\"\u0002BA\u0019\u0003g\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005U\u0002(\u0001\u0006b]:|G/\u0019;j_:LA!!\u000f\u00020\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\ty\u0004\u0005\u0003\u0002B\u0005-SBAA\"\u0015\u0011\t)%a\u0012\u0002\t1\fgn\u001a\u0006\u0003\u0003\u0013\nAA[1wC&\u0019A.a\u0011\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005E\u0003cA\u001c\u0002T%\u0019\u0011Q\u000b\u001d\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007A\fY\u0006C\u0005\u0002^=\t\t\u00111\u0001\u0002R\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a\u0019\u0011\u000b\u0005\u0015\u00141\u000e9\u000e\u0005\u0005\u001d$bAA5q\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u00055\u0014q\r\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002b\u0003gB\u0001\"!\u0018\u0012\u0003\u0003\u0005\r\u0001]\u0001\u0007KF,\u0018\r\\:\u0015\u0007\u0005\fI\b\u0003\u0005\u0002^I\t\t\u00111\u0001qQ]\u0001\u0011QPAB\u0003\u000b\u000bI)a#\u0002\u0010\u0006E\u0015QSAL\u00037\u000bi\nE\u0002+\u0003\u007fJ1!!!\u001c\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!a\"\u0002\u001f~3UKT\"`Q)\u001cxN\\!se\u0006L\u0018\u0006I\u0017!%\u0016$XO\u001d8tAQDW\r\t8v[\n,'\u000fI8gA\u0015dW-\\3oiN\u0004\u0013N\u001c\u0011uQ\u0016\u0004s.\u001e;fe6|7\u000f\u001e\u0011K'>s\u0005%\u0019:sCft\u0013!C1sOVlWM\u001c;tC\t\ti)AA\u0015\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u0002#n]8o\u0003J\u0014\u0018-\u001f\u0011.A\u0005\u0003#jU(OA\u0005\u0014(/Y=/A\u0001tU\u000b\u0014'aA%\u001c\bE]3ukJtW\r\u001a\u0011j]\u0002\u001a\u0017m]3!_\u001a\u0004\u0013M\\=!_RDWM\u001d\u0011wC2LG\r\t&T\u001f:\u00033\u000f\u001e:j]\u001ed#\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A:+F\n\u00141!_J\u0004\u0013M\u001c\u0011j]Z\fG.\u001b3!\u0015N{eJ\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0002\u0014\u0006\tYF\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(7Fb#\u0007L\u001a-iu;\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011!i)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~CseW\u0019-e1\u001aDf\u001f\u0012gc\tR\u0014\u0007\f\u0012ge\tR4,\u000e\u00177;vdC'X\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0002SG\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(7Fb#gJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001rU\u000b\u0014'\u000bA\u0001\nQa\u001a:pkB\f#!!'\u0002\u0015)\u001cxN\\0gk:\u001c7/A\u0003tS:\u001cW-\t\u0002\u0002 \u0006)1GL\u0019/a\u0005\tB*\u001a8hi\"|eMS:p]\u0006\u0013(/Y=\u0011\u0005)\"2\u0003\u0002\u000b\u0002(r\u0002b!!+\u00020\u0006;UBAAV\u0015\r\ti\u000bO\u0001\beVtG/[7f\u0013\u0011\t\t,a+\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0017\u0007\u0006\u0002\u0002$\u0006AAo\\*ue&tw\r\u0006\u0002\u0002@\u0005)\u0011\r\u001d9msR\u0019q)!0\t\u000b}:\u0002\u0019A!\u0002\u000fUt\u0017\r\u001d9msR!\u00111YAe!\u00119\u0014QY!\n\u0007\u0005\u001d\u0007H\u0001\u0004PaRLwN\u001c\u0005\t\u0003\u0017D\u0012\u0011!a\u0001\u000f\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003#\u0004B!!\u0011\u0002T&!\u0011Q[A\"\u0005\u0019y%M[3di\u0002")
public class LengthOfJsonArray
extends UnaryExpression
implements CodegenFallback,
ExpectsInputTypes,
scala.Serializable {
    private final Expression child;

    public static Option<Expression> unapply(LengthOfJsonArray lengthOfJsonArray) {
        return LengthOfJsonArray$.MODULE$.unapply(lengthOfJsonArray);
    }

    public static <A> Function1<Expression, A> andThen(Function1<LengthOfJsonArray, A> function1) {
        return LengthOfJsonArray$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, LengthOfJsonArray> compose(Function1<A, Expression> function1) {
        return LengthOfJsonArray$.MODULE$.compose(function1);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)new .colon.colon((Object)StringType$.MODULE$, (List)Nil$.MODULE$);
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public String prettyName() {
        return "json_array_length";
    }

    @Override
    public Object eval(InternalRow input) {
        Object object;
        Object object2 = new Object();
        try {
            UTF8String json = (UTF8String)this.child().eval(input);
            if (json == null) {
                return null;
            }
            try {
                object = Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> CreateJacksonParser$.MODULE$.utf8String(SharedFactory$.MODULE$.jsonFactory(), json), (Function1 & Serializable & scala.Serializable)parser -> {
                    if (parser.nextToken() == null) {
                        throw new NonLocalReturnControl(object2, null);
                    }
                    return this.parseCounter((JsonParser)parser, input);
                });
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                boolean bl = throwable2 instanceof JsonProcessingException ? true : throwable2 instanceof IOException;
                if (!bl) {
                    throw throwable;
                }
                Object var2_7 = null;
                object = var2_7;
            }
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object2) {
                object = ex.value();
            }
            throw ex;
        }
        return object;
    }

    private Object parseCounter(JsonParser parser, InternalRow input) {
        int length = 0;
        JsonToken jsonToken = parser.currentToken();
        JsonToken jsonToken2 = JsonToken.START_ARRAY;
        if (jsonToken == null ? jsonToken2 != null : !jsonToken.equals(jsonToken2)) {
            return null;
        }
        while (true) {
            JsonToken jsonToken3 = parser.nextToken();
            JsonToken jsonToken4 = JsonToken.END_ARRAY;
            if (!(jsonToken3 == null ? jsonToken4 != null : !jsonToken3.equals(jsonToken4))) break;
            ++length;
            parser.skipChildren();
        }
        return BoxesRunTime.boxToInteger((int)length);
    }

    @Override
    public LengthOfJsonArray withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public LengthOfJsonArray copy(Expression child) {
        return new LengthOfJsonArray(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "LengthOfJsonArray";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return this.child();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof LengthOfJsonArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof LengthOfJsonArray)) return false;
        boolean bl = true;
        if (!bl) return false;
        LengthOfJsonArray lengthOfJsonArray = (LengthOfJsonArray)x$1;
        Expression expression = this.child();
        Expression expression2 = lengthOfJsonArray.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!lengthOfJsonArray.canEqual(this)) return false;
        return true;
    }

    public LengthOfJsonArray(Expression child) {
        this.child = child;
        CodegenFallback.$init$(this);
        ExpectsInputTypes.$init$(this);
    }
}

