/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import com.google.common.io.ByteStreams;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.CastBase;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GetArrayStructFields;
import org.apache.spark.sql.catalyst.expressions.GetStructField;
import org.apache.spark.sql.catalyst.expressions.InheritAnalysisRules;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.PrettyAttribute;
import org.apache.spark.sql.catalyst.expressions.PrettyPythonUDF;
import org.apache.spark.sql.catalyst.expressions.PythonUDF;
import org.apache.spark.sql.catalyst.util.package;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

public final class package$
implements Logging {
    public static package$ MODULE$;
    private final AtomicBoolean truncationWarningPrinted;
    private final String METADATA_COL_ATTR_KEY;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new package$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public <A> A quietly(Function0<A> f) {
        Object object;
        PrintStream origErr = System.err;
        PrintStream origOut = System.out;
        try {
            System.setErr(new PrintStream(new OutputStream(){

                public final void write(int x$1) {
                    package$.org$apache$spark$sql$catalyst$util$package$$$anonfun$quietly$1(x$1);
                }
            }));
            System.setOut(new PrintStream(new OutputStream(){

                public final void write(int x$1) {
                    package$.org$apache$spark$sql$catalyst$util$package$$$anonfun$quietly$3(x$1);
                }
            }));
            object = f.apply();
        }
        finally {
            System.setErr(origErr);
            System.setOut(origOut);
        }
        return (A)object;
    }

    public String fileToString(File file, Charset encoding) {
        String string;
        try (FileInputStream inStream = new FileInputStream(file);){
            string = new String(ByteStreams.toByteArray((InputStream)inStream), encoding);
        }
        return string;
    }

    public Charset fileToString$default$2() {
        return StandardCharsets.UTF_8;
    }

    public byte[] resourceToBytes(String resource, ClassLoader classLoader) {
        byte[] byArray;
        try (InputStream inStream = classLoader.getResourceAsStream(resource);){
            byArray = ByteStreams.toByteArray((InputStream)inStream);
        }
        return byArray;
    }

    public ClassLoader resourceToBytes$default$2() {
        return Utils$.MODULE$.getSparkClassLoader();
    }

    public String resourceToString(String resource, String encoding, ClassLoader classLoader) {
        return new String(this.resourceToBytes(resource, classLoader), encoding);
    }

    public String resourceToString$default$2() {
        return StandardCharsets.UTF_8.name();
    }

    public ClassLoader resourceToString$default$3() {
        return Utils$.MODULE$.getSparkClassLoader();
    }

    public File stringToFile(File file, String str) {
        Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> new PrintWriter(file), (Function1 & Serializable & scala.Serializable)out -> {
            out.write(str);
            return BoxedUnit.UNIT;
        });
        return file;
    }

    public Seq<String> sideBySide(String left, String right) {
        return this.sideBySide((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])left.split("\n")), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])right.split("\n")));
    }

    public Seq<String> sideBySide(Seq<String> left, Seq<String> right) {
        int maxLeftSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)left.map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.length()), Seq$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Int$.MODULE$));
        Seq leftPadded = (Seq)left.$plus$plus((GenTraversableOnce)Seq$.MODULE$.fill(scala.math.package$.MODULE$.max(right.size() - left.size(), 0), (Function0 & Serializable & scala.Serializable)() -> ""), Seq$.MODULE$.canBuildFrom());
        Seq rightPadded = (Seq)right.$plus$plus((GenTraversableOnce)Seq$.MODULE$.fill(scala.math.package$.MODULE$.max(left.size() - right.size(), 0), (Function0 & Serializable & scala.Serializable)() -> ""), Seq$.MODULE$.canBuildFrom());
        return (Seq)((TraversableLike)leftPadded.zip((GenIterable)rightPadded, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String l = (String)tuple2._1();
            String r = (String)tuple2._2();
            String string = l;
            String string2 = r;
            String string3 = new java.lang.StringBuilder(0).append(!(string != null ? !string.equals(string2) : string2 != null) ? " " : "!").append(l).append(new StringOps(Predef$.MODULE$.augmentString(" ")).$times(maxLeftSize - l.length() + 3)).append(r).toString();
            return string3;
        }, Seq$.MODULE$.canBuildFrom());
    }

    public String stackTraceToString(Throwable t) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> new PrintWriter(out), (Function1 & Serializable & scala.Serializable)writer -> {
            package$.$anonfun$stackTraceToString$2(t, writer);
            return BoxedUnit.UNIT;
        });
        return new String(out.toByteArray(), StandardCharsets.UTF_8);
    }

    public Expression usePrettyExpression(Expression e) {
        return (Expression)e.transform(new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                CastBase castBase;
                Object object;
                boolean bl = false;
                Literal literal = null;
                A1 A1 = x1;
                if (A1 instanceof Attribute) {
                    Attribute attribute = (Attribute)A1;
                    object = new PrettyAttribute(attribute);
                    return (B1)object;
                }
                if (A1 instanceof Literal) {
                    bl = true;
                    literal = (Literal)A1;
                    Object s = literal.value();
                    DataType dataType = literal.dataType();
                    if (s instanceof UTF8String) {
                        UTF8String uTF8String = (UTF8String)s;
                        if (StringType$.MODULE$.equals(dataType)) {
                            object = new PrettyAttribute(uTF8String.toString(), StringType$.MODULE$);
                            return (B1)object;
                        }
                    }
                }
                if (bl) {
                    Object v = literal.value();
                    DataType t = literal.dataType();
                    if (t instanceof NumericType) {
                        NumericType numericType = (NumericType)t;
                        if (v != null) {
                            object = new PrettyAttribute(v.toString(), numericType);
                            return (B1)object;
                        }
                    }
                }
                if (bl) {
                    Object object2 = literal.value();
                    DataType dataType = literal.dataType();
                    if (object2 == null) {
                        object = new PrettyAttribute("NULL", dataType);
                        return (B1)object;
                    }
                }
                if (A1 instanceof GetStructField) {
                    GetStructField getStructField = (GetStructField)A1;
                    String name = (String)getStructField.name().getOrElse((Function0 & Serializable & scala.Serializable)() -> getStructField.childSchema().apply(getStructField.ordinal()).name());
                    object = new PrettyAttribute(new java.lang.StringBuilder(1).append(package$.MODULE$.usePrettyExpression(getStructField.child()).sql()).append(".").append(name).toString(), getStructField.dataType());
                    return (B1)object;
                }
                if (A1 instanceof GetArrayStructFields) {
                    GetArrayStructFields getArrayStructFields = (GetArrayStructFields)A1;
                    object = new PrettyAttribute(new java.lang.StringBuilder(0).append(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)package$.MODULE$.usePrettyExpression(getArrayStructFields.child())), ".")).append(getArrayStructFields.field().name()).toString(), getArrayStructFields.dataType());
                    return (B1)object;
                }
                if (A1 instanceof InheritAnalysisRules) {
                    A1 A12 = A1;
                    object = new PrettyAttribute(((InheritAnalysisRules)((Object)A12)).makeSQLString((Seq<String>)((Seq)((InheritAnalysisRules)((Object)A12)).parameters().map((Function1 & Serializable & scala.Serializable)e -> package$.MODULE$.toPrettySQL((Expression)e), Seq$.MODULE$.canBuildFrom()))), A12.dataType());
                    return (B1)object;
                }
                if (A1 instanceof CastBase && !BoxesRunTime.unboxToBoolean((Object)(castBase = (CastBase)A1).getTagValue(Cast$.MODULE$.USER_SPECIFIED_CAST()).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false))) {
                    object = new PrettyAttribute(package$.MODULE$.usePrettyExpression(castBase.child()).sql(), castBase.dataType());
                    return (B1)object;
                }
                if (A1 instanceof PythonUDF) {
                    PythonUDF pythonUDF = (PythonUDF)A1;
                    object = new PrettyPythonUDF(pythonUDF.name(), pythonUDF.dataType(), pythonUDF.children());
                    return (B1)object;
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Expression x1) {
                CastBase castBase;
                Object object;
                boolean bl = false;
                Literal literal = null;
                Expression expression = x1;
                if (expression instanceof Attribute) {
                    return true;
                }
                if (expression instanceof Literal) {
                    bl = true;
                    literal = (Literal)expression;
                    Object s = literal.value();
                    DataType dataType = literal.dataType();
                    if (s instanceof UTF8String && StringType$.MODULE$.equals(dataType)) {
                        return true;
                    }
                }
                if (bl) {
                    Object v = literal.value();
                    DataType t = literal.dataType();
                    if (t instanceof NumericType && v != null) {
                        return true;
                    }
                }
                if (bl && (object = literal.value()) == null) {
                    return true;
                }
                if (expression instanceof GetStructField) {
                    return true;
                }
                if (expression instanceof GetArrayStructFields) {
                    return true;
                }
                if (expression instanceof InheritAnalysisRules) {
                    return true;
                }
                if (expression instanceof CastBase && !BoxesRunTime.unboxToBoolean((Object)(castBase = (CastBase)expression).getTagValue(Cast$.MODULE$.USER_SPECIFIED_CAST()).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false))) {
                    return true;
                }
                if (!(expression instanceof PythonUDF)) return false;
                return true;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.sql.catalyst.expressions.GetStructField ), $anonfun$applyOrElse$2(org.apache.spark.sql.catalyst.expressions.Expression ), $anonfun$applyOrElse$3(), $anonfun$isDefinedAt$1()}, serializedLambda);
            }
        });
    }

    public String quoteIdentifier(String name) {
        return new java.lang.StringBuilder(2).append("`").append(name.replace("`", "``")).append("`").toString();
    }

    public String quoteIfNeeded(String part) {
        return part.matches("[a-zA-Z0-9_]+") && !part.matches("\\d+") ? part : new java.lang.StringBuilder(2).append("`").append(part.replace("`", "``")).append("`").toString();
    }

    public String toPrettySQL(Expression e) {
        return this.usePrettyExpression(e).sql();
    }

    public String escapeSingleQuotedString(String str) {
        StringBuilder builder = new StringBuilder();
        new StringOps(Predef$.MODULE$.augmentString(str)).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> package$.$anonfun$escapeSingleQuotedString$1(builder, BoxesRunTime.unboxToChar((Object)x0$1)));
        return builder.toString();
    }

    private AtomicBoolean truncationWarningPrinted() {
        return this.truncationWarningPrinted;
    }

    public <T> String truncatedString(Seq<T> seq, String start, String sep, String end, int maxFields) {
        String string;
        if (seq.length() > maxFields) {
            if (this.truncationWarningPrinted().compareAndSet(false, true)) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(114).append("Truncated the string representation of a plan since it was too large. This ").append("behavior can be adjusted by setting '").append(SQLConf$.MODULE$.MAX_TO_STRING_FIELDS().key()).append("'.").toString());
            }
            int numFields = scala.math.package$.MODULE$.max(0, maxFields - 1);
            string = ((TraversableOnce)seq.take(numFields)).mkString(start, sep, new java.lang.StringBuilder(16).append(sep).append("... ").append(seq.length() - numFields).append(" more fields").append(end).toString());
        } else {
            string = seq.mkString(start, sep, end);
        }
        return string;
    }

    public <T> String truncatedString(Seq<T> seq, String sep, int maxFields) {
        return this.truncatedString(seq, "", sep, "", maxFields);
    }

    public String METADATA_COL_ATTR_KEY() {
        return this.METADATA_COL_ATTR_KEY;
    }

    public package.MetadataColumnHelper MetadataColumnHelper(Attribute attr) {
        return new package.MetadataColumnHelper(attr);
    }

    public static final /* synthetic */ void org$apache$spark$sql$catalyst$util$package$$$anonfun$quietly$1(int x$1) {
    }

    public static final /* synthetic */ void org$apache$spark$sql$catalyst$util$package$$$anonfun$quietly$3(int x$2) {
    }

    public static final /* synthetic */ void $anonfun$stackTraceToString$2(Throwable t$1, PrintWriter writer) {
        t$1.printStackTrace(writer);
        writer.flush();
    }

    public static final /* synthetic */ StringBuilder $anonfun$escapeSingleQuotedString$1(StringBuilder builder$1, char x0$1) {
        StringBuilder stringBuilder;
        char c = x0$1;
        switch (c) {
            case '\'': {
                stringBuilder = builder$1.$plus$plus$eq("\\'");
                break;
            }
            default: {
                stringBuilder = builder$1.$plus$eq(c);
                break;
            }
        }
        return stringBuilder;
    }

    private package$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.truncationWarningPrinted = new AtomicBoolean(false);
        this.METADATA_COL_ATTR_KEY = "__metadata_col";
    }
}

