/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.BinaryComparison;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GreaterThan$;
import org.apache.spark.sql.catalyst.expressions.package;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="expr1 _FUNC_ expr2 - Returns true if `expr1` is greater than `expr2`.", arguments="\n    Arguments:\n      * expr1, expr2 - the two expressions must be same type or can be casted to a common type,\n          and must be a type that can be ordered. For example, map type is not orderable, so it\n          is not supported. For complex types such array/struct, the data types of fields must\n          be orderable.\n  ", examples="\n    Examples:\n      > SELECT 2 _FUNC_ 1;\n       true\n      > SELECT 2 _FUNC_ 1.1;\n       true\n      > SELECT to_date('2009-07-30 04:17:52') _FUNC_ to_date('2009-07-30 04:17:52');\n       false\n      > SELECT to_date('2009-07-30 04:17:52') _FUNC_ to_date('2009-08-01 04:17:52');\n       false\n      > SELECT 1 _FUNC_ NULL;\n       NULL\n  ", since="1.0.0", group="predicate_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005]e\u0001B\r\u001b\u0001\u001eB\u0001\u0002\u0010\u0001\u0003\u0016\u0004%\t!\u0010\u0005\t\u0003\u0002\u0011\t\u0012)A\u0005}!A!\t\u0001BK\u0002\u0013\u0005Q\b\u0003\u0005D\u0001\tE\t\u0015!\u0003?\u0011\u0015!\u0005\u0001\"\u0001F\u0011\u0015I\u0005\u0001\"\u0011K\u0011\u00151\u0006\u0001\"\u0015X\u0011\u0015y\u0006\u0001\"\u0015a\u0011\u001d)\u0007!!A\u0005\u0002\u0019Dq!\u001b\u0001\u0012\u0002\u0013\u0005!\u000eC\u0004v\u0001E\u0005I\u0011\u00016\t\u000fY\u0004\u0011\u0011!C!o\"Aq\u0010AA\u0001\n\u0003\t\t\u0001C\u0005\u0002\n\u0001\t\t\u0011\"\u0001\u0002\f!I\u0011\u0011\u0003\u0001\u0002\u0002\u0013\u0005\u00131\u0003\u0005\n\u0003C\u0001\u0011\u0011!C\u0001\u0003GA\u0011\"!\f\u0001\u0003\u0003%\t%a\f\b\u0013\u0005e#$!A\t\u0002\u0005mc\u0001C\r\u001b\u0003\u0003E\t!!\u0018\t\r\u0011\u001bB\u0011AA6\u0011%\tigEA\u0001\n\u000b\ny\u0007C\u0005\u0002rM\t\t\u0011\"!\u0002t!I\u0011\u0011P\n\u0002\u0002\u0013\u0005\u00151\u0010\u0005\n\u0003\u001b\u001b\u0012\u0011!C\u0005\u0003\u001f\u00131b\u0012:fCR,'\u000f\u00165b]*\u00111\u0004H\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\u001e=\u0005A1-\u0019;bYf\u001cHO\u0003\u0002 A\u0005\u00191/\u001d7\u000b\u0005\u0005\u0012\u0013!B:qCJ\\'BA\u0012%\u0003\u0019\t\u0007/Y2iK*\tQ%A\u0002pe\u001e\u001c\u0001aE\u0003\u0001Q1\u001a\u0014\b\u0005\u0002*U5\t!$\u0003\u0002,5\t\u0001\")\u001b8bef\u001cu.\u001c9be&\u001cxN\u001c\t\u0003[Ar!!\u000b\u0018\n\u0005=R\u0012a\u00029bG.\fw-Z\u0005\u0003cI\u0012aBT;mY&sGo\u001c7fe\u0006tGO\u0003\u000205A\u0011AgN\u0007\u0002k)\ta'A\u0003tG\u0006d\u0017-\u0003\u00029k\t9\u0001K]8ek\u000e$\bC\u0001\u001b;\u0013\tYTG\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0003mK\u001a$X#\u0001 \u0011\u0005%z\u0014B\u0001!\u001b\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0006Y\u00164G\u000fI\u0001\u0006e&<\u0007\u000e^\u0001\u0007e&<\u0007\u000e\u001e\u0011\u0002\rqJg.\u001b;?)\r1u\t\u0013\t\u0003S\u0001AQ\u0001P\u0003A\u0002yBQAQ\u0003A\u0002y\naa]=nE>dW#A&\u0011\u00051\u001bfBA'R!\tqU'D\u0001P\u0015\t\u0001f%\u0001\u0004=e>|GOP\u0005\u0003%V\na\u0001\u0015:fI\u00164\u0017B\u0001+V\u0005\u0019\u0019FO]5oO*\u0011!+N\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u00041nk\u0006C\u0001\u001bZ\u0013\tQVGA\u0002B]fDQ\u0001X\u0004A\u0002a\u000ba!\u001b8qkR\f\u0004\"\u00020\b\u0001\u0004A\u0016AB5oaV$('A\fxSRDg*Z<DQ&dGM]3o\u0013:$XM\u001d8bYR\u0019a(Y2\t\u000b\tD\u0001\u0019\u0001 \u0002\u000f9,w\u000fT3gi\")A\r\u0003a\u0001}\u0005Aa.Z<SS\u001eDG/\u0001\u0003d_BLHc\u0001$hQ\"9A(\u0003I\u0001\u0002\u0004q\u0004b\u0002\"\n!\u0003\u0005\rAP\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\u0005Y'F\u0001 mW\u0005i\u0007C\u00018t\u001b\u0005y'B\u00019r\u0003%)hn\u00195fG.,GM\u0003\u0002sk\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005Q|'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070F\u0001y!\tIh0D\u0001{\u0015\tYH0\u0001\u0003mC:<'\"A?\u0002\t)\fg/Y\u0005\u0003)j\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a\u0001\u0011\u0007Q\n)!C\u0002\u0002\bU\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$2\u0001WA\u0007\u0011%\tyADA\u0001\u0002\u0004\t\u0019!A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003+\u0001R!a\u0006\u0002\u001eak!!!\u0007\u000b\u0007\u0005mQ'\u0001\u0006d_2dWm\u0019;j_:LA!a\b\u0002\u001a\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t)#a\u000b\u0011\u0007Q\n9#C\u0002\u0002*U\u0012qAQ8pY\u0016\fg\u000e\u0003\u0005\u0002\u0010A\t\t\u00111\u0001Y\u0003\u0019)\u0017/^1mgR!\u0011QEA\u0019\u0011!\ty!EA\u0001\u0002\u0004A\u0006f\u0006\u0001\u00026\u0005m\u0012QHA!\u0003\u0007\n9%!\u0013\u0002N\u0005=\u00131KA+!\rI\u0013qG\u0005\u0004\u0003sQ\"!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003\u007f\tQ)\u001a=qeF\u0002sLR+O\u0007~\u0003S\r\u001f9se\u0001j\u0003EU3ukJt7\u000f\t;sk\u0016\u0004\u0013N\u001a\u0011aKb\u0004(/\r1!SN\u0004sM]3bi\u0016\u0014\b\u0005\u001e5b]\u0002\u0002W\r\u001f9se\u0001t\u0013!C1sOVlWM\u001c;tC\t\t)%\u0001BJ\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u0002S\r\u001f9sc1\u0002S\r\u001f9se\u0001j\u0003\u0005\u001e5fAQ<x\u000eI3yaJ,7o]5p]N\u0004S.^:uA\t,\u0007e]1nK\u0002\"\u0018\u0010]3!_J\u00043-\u00198!E\u0016\u00043-Y:uK\u0012\u0004Co\u001c\u0011bA\r|W.\\8oAQL\b/\u001a\u0017\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0013M\u001c3![V\u001cH\u000f\t2fA\u0005\u0004C/\u001f9fAQD\u0017\r\u001e\u0011dC:\u0004#-\u001a\u0011pe\u0012,'/\u001a3/A\u0019{'\u000fI3yC6\u0004H.\u001a\u0017![\u0006\u0004\b\u0005^=qK\u0002J7\u000f\t8pi\u0002z'\u000fZ3sC\ndW\r\f\u0011t_\u0002JGO\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A%\u001c\bE\\8uAM,\b\u000f]8si\u0016$g\u0006\t$pe\u0002\u001aw.\u001c9mKb\u0004C/\u001f9fg\u0002\u001aXo\u00195!CJ\u0014\u0018-_\u0018tiJ,8\r\u001e\u0017!i\",\u0007\u0005Z1uC\u0002\"\u0018\u0010]3tA=4\u0007EZ5fY\u0012\u001c\b%\\;ti*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t2fA=\u0014H-\u001a:bE2,gF\u0003\u0011!\u0003!)\u00070Y7qY\u0016\u001c\u0018EAA&\u0003\t}%\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000b\t\u001a!?\u001a+fjQ0!cmR\u0001\u0005\t\u0011!A\u0001\u0002CO];f\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002\u0012\u0004e\u0018$V\u001d\u000e{\u0006%\r\u00182w)\u0001\u0003\u0005\t\u0011!A\u0001\"(/^3\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UAQ|w\fZ1uK\":#\u0007\r\u0019:[A:Tf\r\u0019!aQR\u0014g\u000e\u001e6e\u001dJ\u0003e\u0018$V\u001d\u000e{\u0006\u0005^8`I\u0006$X\rK\u00143aAJT\u0006M\u001c.gA\u0002\u0003\u0007\u000e\u001e2oi*$gJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0019\fGn]3\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UAQ|w\fZ1uK\":#\u0007\r\u0019:[A:Tf\r\u0019!aQR\u0014g\u000e\u001e6e\u001dJ\u0003e\u0018$V\u001d\u000e{\u0006\u0005^8`I\u0006$X\rK\u00143aAJT\u0006\r\u001d.aE\u0002\u0003\u0007\u000e\u001e2oi*$gJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0019\fGn]3\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UAE\u0002sLR+O\u0007~\u0003c*\u0016'Mw)\u0001\u0003\u0005\t\u0011!A\u0001rU\u000b\u0014'\u000bA\u0001\nQa]5oG\u0016\f#!!\u0015\u0002\u000bEr\u0003G\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005]\u0013a\u00049sK\u0012L7-\u0019;f?\u001a,hnY:\u0002\u0017\u001d\u0013X-\u0019;feRC\u0017M\u001c\t\u0003SM\u0019BaEA0sA9\u0011\u0011MA4}y2UBAA2\u0015\r\t)'N\u0001\beVtG/[7f\u0013\u0011\tI'a\u0019\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0006\u0002\u0002\\\u0005AAo\\*ue&tw\rF\u0001y\u0003\u0015\t\u0007\u000f\u001d7z)\u00151\u0015QOA<\u0011\u0015ad\u00031\u0001?\u0011\u0015\u0011e\u00031\u0001?\u0003\u001d)h.\u00199qYf$B!! \u0002\nB)A'a \u0002\u0004&\u0019\u0011\u0011Q\u001b\u0003\r=\u0003H/[8o!\u0015!\u0014Q\u0011 ?\u0013\r\t9)\u000e\u0002\u0007)V\u0004H.\u001a\u001a\t\u0011\u0005-u#!AA\u0002\u0019\u000b1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005E\u0005cA=\u0002\u0014&\u0019\u0011Q\u0013>\u0003\r=\u0013'.Z2u\u0001")
public class GreaterThan
extends BinaryComparison
implements package.NullIntolerant,
Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(GreaterThan greaterThan) {
        return GreaterThan$.MODULE$.unapply(greaterThan);
    }

    public static Function1<Tuple2<Expression, Expression>, GreaterThan> tupled() {
        return GreaterThan$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, GreaterThan>> curried() {
        return GreaterThan$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public String symbol() {
        return ">";
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        return BoxesRunTime.boxToBoolean((boolean)this.ordering().gt(input1, input2));
    }

    @Override
    public Expression withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public GreaterThan copy(Expression left, Expression right) {
        return new GreaterThan(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "GreaterThan";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof GreaterThan;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof GreaterThan)) return false;
        boolean bl = true;
        if (!bl) return false;
        GreaterThan greaterThan = (GreaterThan)x$1;
        Expression expression = this.left();
        Expression expression2 = greaterThan.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = greaterThan.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!greaterThan.canEqual(this)) return false;
        return true;
    }

    public GreaterThan(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
}

