/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.File;
import java.io.Serializable;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Period;
import java.time.ZoneId;
import java.util.Random;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute$;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.BoundReference;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.aggregate.HistogramNumeric;
import org.apache.spark.sql.catalyst.expressions.aggregate.NumericHistogramSerializer$;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.util.NumericHistogram;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001)4A\u0001C\u0005\u00011!)\u0011\u0006\u0001C\u0001U!9Q\u0006\u0001b\u0001\n\u0013q\u0003BB\u001c\u0001A\u0003%q\u0006C\u00049\u0001\t\u0007I\u0011B\u001d\t\r!\u0003\u0001\u0015!\u0003;\u0011\u0015I\u0005\u0001\"\u0003K\u0011\u00159\u0006\u0001\"\u0003Y\u0005UA\u0015n\u001d;pOJ\fWNT;nKJL7mU;ji\u0016T!AC\u0006\u0002\u0013\u0005<wM]3hCR,'B\u0001\u0007\u000e\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u00059y\u0011\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005A\t\u0012aA:rY*\u0011!cE\u0001\u0006gB\f'o\u001b\u0006\u0003)U\ta!\u00199bG\",'\"\u0001\f\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001IRd\t\t\u00035mi\u0011!E\u0005\u00039E\u0011Qb\u00159be.4UO\\*vSR,\u0007C\u0001\u0010\"\u001b\u0005y\"B\u0001\u0011\u000e\u0003\u0015\u0001H.\u00198t\u0013\t\u0011sDA\u0005T#2CU\r\u001c9feB\u0011AeJ\u0007\u0002K)\u0011a%E\u0001\tS:$XM\u001d8bY&\u0011\u0001&\n\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\t1\u0006\u0005\u0002-\u00015\t\u0011\"\u0001\u0004sC:$w.\\\u000b\u0002_A\u0011\u0001'N\u0007\u0002c)\u0011!gM\u0001\u0005kRLGNC\u00015\u0003\u0011Q\u0017M^1\n\u0005Y\n$A\u0002*b]\u0012|W.A\u0004sC:$w.\u001c\u0011\u0002\t\u0011\fG/Y\u000b\u0002uA\u00191H\u0011#\u000e\u0003qR!!\u0010 \u0002\u0013%lW.\u001e;bE2,'BA A\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u0002\u0003\u0006)1oY1mC&\u00111\t\u0010\u0002\u000b\u0013:$W\r_3e'\u0016\f\bCA#G\u001b\u0005\u0001\u0015BA$A\u0005\rIe\u000e^\u0001\u0006I\u0006$\u0018\rI\u0001\u000eG>l\u0007/\u0019:f\u000bF,\u0018\r\\:\u0015\u0007-sU\u000b\u0005\u0002F\u0019&\u0011Q\n\u0011\u0002\b\u0005>|G.Z1o\u0011\u0015ye\u00011\u0001Q\u0003\u0011aWM\u001a;\u0011\u0005E\u001bV\"\u0001*\u000b\u0005Iz\u0011B\u0001+S\u0005AqU/\\3sS\u000eD\u0015n\u001d;pOJ\fW\u000eC\u0003W\r\u0001\u0007\u0001+A\u0003sS\u001eDG/A\u0006bgN,'\u000f^#rk\u0006dWCA-a)\rQV,\u001b\t\u0003\u000bnK!\u0001\u0018!\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u001f\u001e\u0001\rA\u0018\t\u0003?\u0002d\u0001\u0001B\u0003b\u000f\t\u0007!MA\u0001U#\t\u0019g\r\u0005\u0002FI&\u0011Q\r\u0011\u0002\b\u001d>$\b.\u001b8h!\t)u-\u0003\u0002i\u0001\n\u0019\u0011I\\=\t\u000bY;\u0001\u0019\u00010")
public class HistogramNumericSuite
extends SparkFunSuite
implements SQLHelper {
    private final Random random;
    private final IndexedSeq<Object> data;
    private String sparkHome;
    private volatile boolean bitmap$0;

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$(this, pairs, f);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    private String sparkHome$lzycompute() {
        HistogramNumericSuite histogramNumericSuite = this;
        synchronized (histogramNumericSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        return !this.bitmap$0 ? this.sparkHome$lzycompute() : this.sparkHome;
    }

    private Random random() {
        return this.random;
    }

    private IndexedSeq<Object> data() {
        return this.data;
    }

    private boolean compareEquals(NumericHistogram left, NumericHistogram right) {
        return left.getNumBins() == right.getNumBins() && left.getUsedBins() == right.getUsedBins() && RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), left.getUsedBins()).forall((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> {
            NumericHistogram.Coord leftCoord = left.getBin(i);
            NumericHistogram.Coord rightCoord = right.getBin(i);
            return leftCoord.x == rightCoord.x && leftCoord.y == rightCoord.y;
        });
    }

    private <T> void assertEqual(T left, T right) {
        T $org_scalatest_assert_macro_right;
        T $org_scalatest_assert_macro_left;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "==", $org_scalatest_assert_macro_right, BoxesRunTime.equals($org_scalatest_assert_macro_left = left, $org_scalatest_assert_macro_right = right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HistogramNumericSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 272));
    }

    public static final /* synthetic */ void $anonfun$new$5(int nBins$1, NumericHistogram buffer$2, IndexedSeq group) {
        NumericHistogram partialBuffer = new NumericHistogram();
        partialBuffer.allocate(nBins$1);
        group.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x -> partialBuffer.add((double)x));
        buffer$2.merge(partialBuffer);
    }

    public static final /* synthetic */ Assertion $anonfun$new$4(int valueCount$1, int nBins) {
        double sum;
        NumericHistogram buffer = new NumericHistogram();
        buffer.allocate(nBins);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), valueCount$1).grouped(nBins).foreach((Function1 & Serializable & scala.Serializable)group -> {
            HistogramNumericSuite.$anonfun$new$5(nBins, buffer, group);
            return BoxedUnit.UNIT;
        });
        double $org_scalatest_assert_macro_left = sum = BoxesRunTime.unboxToDouble((Object)((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), buffer.getUsedBins()).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> {
            NumericHistogram.Coord coord = buffer.getBin(i);
            return coord.x * coord.y;
        }, IndexedSeq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        int $org_scalatest_assert_macro_right = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), valueCount$1).sum((Numeric)Numeric.IntIsIntegral$.MODULE$);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left <= (double)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HistogramNumericSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
    }

    public static final /* synthetic */ boolean $anonfun$new$17(Tuple3 check$ifrefutable$1) {
        Tuple3 tuple3 = check$ifrefutable$1;
        boolean bl = tuple3 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$new$20(DoubleRef ys$1, Object row) {
        Object object = row;
        if (object instanceof GenericInternalRow) {
            GenericInternalRow genericInternalRow = (GenericInternalRow)object;
            Object[] $org_scalatest_assert_macro_left = genericInternalRow.values();
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HistogramNumericSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 251));
            ys$1.elem += BoxesRunTime.unboxToDouble((Object)genericInternalRow.values()[1]);
        } else {
            throw new MatchError(object);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public HistogramNumericSuite() {
        SQLHelper.$init$(this);
        this.random = new Random();
        this.data = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10000).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x$1 -> this.random().nextInt(10000), IndexedSeq$.MODULE$.canBuildFrom());
        this.test("serialize and de-serialize", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            NumericHistogram emptyBuffer = new NumericHistogram();
            emptyBuffer.allocate(5);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.compareEquals(emptyBuffer, NumericHistogramSerializer$.MODULE$.deserialize(NumericHistogramSerializer$.MODULE$.serialize(emptyBuffer))), "HistogramNumericSuite.this.compareEquals(emptyBuffer, NumericHistogramSerializer.deserialize(NumericHistogramSerializer.serialize(emptyBuffer)))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HistogramNumericSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
            NumericHistogram buffer = new NumericHistogram();
            buffer.allocate(this.data().size() / 3);
            this.data().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)value -> buffer.add((double)value));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.compareEquals(buffer, NumericHistogramSerializer$.MODULE$.deserialize(NumericHistogramSerializer$.MODULE$.serialize(buffer))), "HistogramNumericSuite.this.compareEquals(buffer, NumericHistogramSerializer.deserialize(NumericHistogramSerializer.serialize(buffer)))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HistogramNumericSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
            HistogramNumeric agg = new HistogramNumeric((Expression)new BoundReference(0, (DataType)DoubleType$.MODULE$, true), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)5)));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(this.compareEquals(agg.deserialize(agg.serialize(buffer)), buffer), "HistogramNumericSuite.this.compareEquals(agg.deserialize(agg.serialize(buffer)), buffer)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HistogramNumericSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
        }, new Position("HistogramNumericSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
        this.test("class NumericHistogram, basic operations", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int valueCount = 5;
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 5}))).foreach((Function1 & Serializable & scala.Serializable)nBins -> HistogramNumericSuite.$anonfun$new$4(valueCount, BoxesRunTime.unboxToInt((Object)nBins)));
        }, new Position("HistogramNumericSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
        this.test("class HistogramNumeric, sql string", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("histogram_numeric(a, 3)", new HistogramNumeric((Expression)package.expressions$.MODULE$.DslString("a").attr(), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3))).sql());
            this.assertEqual("histogram_numeric(DISTINCT a, 3)", new HistogramNumeric((Expression)package.expressions$.MODULE$.DslString("a").attr(), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3))).sql(true));
        }, new Position("HistogramNumericSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
        this.test("class HistogramNumeric, fails analysis if nBins is not a constant", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String x$1 = "a";
            IntegerType$ x$2 = IntegerType$.MODULE$;
            boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, (DataType)x$2, x$3, x$4);
            Seq x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, (DataType)x$2, x$3, x$4);
            AttributeReference attribute = new AttributeReference(x$1, (DataType)x$2, x$3, x$4, x$5, x$6);
            String x$7 = "b";
            IntegerType$ x$8 = IntegerType$.MODULE$;
            boolean x$9 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$10 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$11 = AttributeReference$.MODULE$.apply$default$5(x$7, (DataType)x$8, x$9, x$10);
            Seq x$12 = AttributeReference$.MODULE$.apply$default$6(x$7, (DataType)x$8, x$9, x$10);
            HistogramNumeric wrongNB = new HistogramNumeric((Expression)attribute, (Expression)new AttributeReference(x$7, (DataType)x$8, x$9, x$10, x$11, x$12));
            this.assertEqual(wrongNB.checkInputDataTypes(), new TypeCheckResult.TypeCheckFailure("histogram_numeric needs the nBins provided must be a constant literal."));
        }, new Position("HistogramNumericSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
        this.test("class HistogramNumeric, fails analysis if nBins is invalid", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String x$13 = "a";
            IntegerType$ x$14 = IntegerType$.MODULE$;
            boolean x$15 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$16 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$17 = AttributeReference$.MODULE$.apply$default$5(x$13, (DataType)x$14, x$15, x$16);
            Seq x$18 = AttributeReference$.MODULE$.apply$default$6(x$13, (DataType)x$14, x$15, x$16);
            AttributeReference attribute = new AttributeReference(x$13, (DataType)x$14, x$15, x$16, x$17, x$18);
            HistogramNumeric wrongNB = new HistogramNumeric((Expression)attribute, (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)));
            this.assertEqual(wrongNB.checkInputDataTypes(), new TypeCheckResult.TypeCheckFailure("histogram_numeric needs nBins to be at least 2, but you supplied 1."));
        }, new Position("HistogramNumericSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
        this.test("class HistogramNumeric, automatically add type casting for parameters", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq relations = (Seq)new .colon.colon((Object)LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).double()})), (List)new .colon.colon((Object)LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int()})), (List)new .colon.colon((Object)LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).timestamp()})), (List)new .colon.colon((Object)LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).dayTimeInterval()})), (List)new .colon.colon((Object)LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).yearMonthInterval()})), (List)Nil$.MODULE$)))));
            Seq nBinsExpressions = (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToByte((byte)((byte)2))), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToShort((short)((short)100))), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)100)), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1000L)), (List)Nil$.MODULE$))));
            relations.foreach((Function1 & Serializable & scala.Serializable)relation -> {
                nBinsExpressions.foreach((Function1 & Serializable & scala.Serializable)nBins -> {
                    Alias alias;
                    Expression agg;
                    Expression analyzed;
                    Seq $org_scalatest_assert_macro_left = relation.output();
                    int $org_scalatest_assert_macro_right = 1;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HistogramNumericSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
                    DataType relationAttributeType = ((Expression)relation.output().apply(0)).dataType();
                    HistogramNumeric agg2 = new HistogramNumeric((Expression)UnresolvedAttribute$.MODULE$.apply("a"), (Expression)nBins);
                    Expression expression = analyzed = (Expression)package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)relation).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{agg2}))).analyze().expressions().head();
                    if (!(expression instanceof Alias) || !((agg = (alias = (Alias)expression).child()) instanceof HistogramNumeric)) {
                        throw $this.fail(new Position("HistogramNumericSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
                    }
                    HistogramNumeric histogramNumeric = (HistogramNumeric)agg;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(histogramNumeric.resolved(), "agg.resolved", Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HistogramNumericSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
                    DataType $org_scalatest_assert_macro_left2 = histogramNumeric.child().dataType();
                    DataType $org_scalatest_assert_macro_right2 = relationAttributeType;
                    DataType dataType = $org_scalatest_assert_macro_left2;
                    DataType dataType2 = $org_scalatest_assert_macro_right2;
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(dataType != null ? !dataType.equals(dataType2) : dataType2 != null), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HistogramNumericSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
                    DataType $org_scalatest_assert_macro_left3 = histogramNumeric.nBins().dataType();
                    IntegerType$ $org_scalatest_assert_macro_right3 = IntegerType$.MODULE$;
                    DataType dataType3 = $org_scalatest_assert_macro_left3;
                    IntegerType$ integerType$ = $org_scalatest_assert_macro_right3;
                    Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(dataType3 != null ? !dataType3.equals(integerType$) : integerType$ != null), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HistogramNumericSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
                    ArrayType expectedType = ArrayType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("x", relationAttributeType, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("y", (DataType)DoubleType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))));
                    DataType $org_scalatest_assert_macro_left4 = histogramNumeric.dataType();
                    ArrayType $org_scalatest_assert_macro_right4 = expectedType;
                    DataType dataType4 = $org_scalatest_assert_macro_left4;
                    ArrayType arrayType = $org_scalatest_assert_macro_right4;
                    Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(dataType4 != null ? !dataType4.equals(arrayType) : arrayType != null), Prettifier$.MODULE$.default());
                    Assertion assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("HistogramNumericSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
                    return assertion;
                });
                return BoxedUnit.UNIT;
            });
        }, new Position("HistogramNumericSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
        this.test("HistogramNumeric: nulls in nBins expression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String x$19 = "a";
            DoubleType$ x$20 = DoubleType$.MODULE$;
            boolean x$21 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$22 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$23 = AttributeReference$.MODULE$.apply$default$5(x$19, (DataType)x$20, x$21, x$22);
            Seq x$24 = AttributeReference$.MODULE$.apply$default$6(x$19, (DataType)x$20, x$21, x$22);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new HistogramNumeric((Expression)new AttributeReference(x$19, (DataType)x$20, x$21, x$22, x$23, x$24), (Expression)new Literal(null, (DataType)IntegerType$.MODULE$)).checkInputDataTypes());
            TypeCheckResult.TypeCheckFailure $org_scalatest_assert_macro_right = new TypeCheckResult.TypeCheckFailure("histogram_numeric needs nBins value must not be null.");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HistogramNumericSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
        }, new Position("HistogramNumericSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161));
        this.test("class HistogramNumeric, null handling", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Cast childExpression = new Cast((Expression)new BoundReference(0, (DataType)IntegerType$.MODULE$, true), (DataType)DoubleType$.MODULE$, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4());
            HistogramNumeric agg = new HistogramNumeric((Expression)childExpression, (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)5)));
            GenericInternalRow buffer = new GenericInternalRow(new Object[1]);
            agg.initialize((InternalRow)buffer);
            Object $org_scalatest_assert_macro_left = agg.eval((InternalRow)buffer);
            Object $org_scalatest_assert_macro_right = null;
            Object object = $org_scalatest_assert_macro_left;
            Object var6_5 = null;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "==", null, !(object != null ? !object.equals(var6_5) : var6_5 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HistogramNumericSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
            agg.update((InternalRow)buffer, InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null})));
            Object $org_scalatest_assert_macro_left2 = agg.eval((InternalRow)buffer);
            Object $org_scalatest_assert_macro_right2 = null;
            Object object2 = $org_scalatest_assert_macro_left2;
            Object var10_9 = null;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left2, "==", null, !(object2 != null ? !object2.equals(var10_9) : var10_9 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HistogramNumericSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
            agg.update((InternalRow)buffer, InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)})));
            Object $org_scalatest_assert_macro_left3 = agg.eval((InternalRow)buffer);
            Object $org_scalatest_assert_macro_right3 = null;
            Object object3 = $org_scalatest_assert_macro_left3;
            Object var14_13 = null;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left3, "!=", null, object3 == null ? var14_13 != null : !object3.equals(var14_13), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HistogramNumericSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 181));
        }, new Position("HistogramNumericSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
        this.test("class HistogramNumeric, exercise many different numeric input types", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq inputs = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)Literal$.MODULE$.apply(null), (Object)Literal$.MODULE$.apply(null), (Object)Literal$.MODULE$.apply(null)), new Tuple3((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2))), new Tuple3((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)0L)), (Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)), (Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)2L))), new Tuple3((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToShort((short)((short)0))), (Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToShort((short)((short)1))), (Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToShort((short)((short)2)))), new Tuple3((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)0.0f)), (Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)1.0f)), (Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)2.0f))), new Tuple3((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)1.0)), (Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)2.0))), new Tuple3((Object)Literal$.MODULE$.apply((Object)Timestamp.valueOf("2017-03-01 00:00:00")), (Object)Literal$.MODULE$.apply((Object)Timestamp.valueOf("2017-03-02 00:00:00")), (Object)Literal$.MODULE$.apply((Object)Timestamp.valueOf("2017-03-03 00:00:00"))), new Tuple3((Object)Literal$.MODULE$.apply((Object)Duration.ofSeconds(1111L)), (Object)Literal$.MODULE$.apply((Object)Duration.ofSeconds(1211L)), (Object)Literal$.MODULE$.apply((Object)Duration.ofSeconds(1311L))), new Tuple3((Object)Literal$.MODULE$.apply((Object)Period.ofMonths(10)), (Object)Literal$.MODULE$.apply((Object)Period.ofMonths(11)), (Object)Literal$.MODULE$.apply((Object)Period.ofMonths(12)))}));
            inputs.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)HistogramNumericSuite.$anonfun$new$17(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                BoxedUnit boxedUnit;
                block9: {
                    Tuple3 tuple3;
                    block6: {
                        DataType lhs;
                        DataType $org_scalatest_assert_macro_left;
                        HistogramNumeric aggPropagateOutputType;
                        Literal right;
                        Literal middle;
                        Literal left;
                        block8: {
                            DataType dataType;
                            block7: {
                                StructType structType;
                                StructField[] structFieldArray;
                                Option option;
                                tuple3 = x$2;
                                if (tuple3 == null) break block6;
                                left = (Literal)tuple3._1();
                                middle = (Literal)tuple3._2();
                                right = (Literal)tuple3._3();
                                this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.HISTOGRAM_NUMERIC_PROPAGATE_INPUT_TYPE().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                                    block3: {
                                        DataType dataType;
                                        block2: {
                                            String string;
                                            StructType structType;
                                            StructField[] structFieldArray;
                                            Option option;
                                            HistogramNumeric aggDoubleOutputType = new HistogramNumeric((Expression)new BoundReference(0, left.dataType(), true), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)5)));
                                            dataType = aggDoubleOutputType.dataType();
                                            if (!(dataType instanceof ArrayType)) break block2;
                                            ArrayType arrayType = (ArrayType)dataType;
                                            DataType dataType2 = arrayType.elementType();
                                            boolean bl = arrayType.containsNull();
                                            if (!(dataType2 instanceof StructType) || (option = Array$.MODULE$.unapplySeq((Object)(structFieldArray = (structType = (StructType)dataType2).fields()))).isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(2) != 0) break block2;
                                            StructField structField = (StructField)((SeqLike)option.get()).apply(0);
                                            StructField structField2 = (StructField)((SeqLike)option.get()).apply(1);
                                            if (structField == null) break block2;
                                            String string2 = structField.name();
                                            DataType dataType3 = structField.dataType();
                                            if ("x".equals(string2) && DoubleType$.MODULE$.equals(dataType3) && structField2 != null && "y".equals(string = structField2.name()) && bl) break block3;
                                        }
                                        throw new MatchError((Object)dataType);
                                    }
                                    boolean bl = true;
                                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(bl, "aggDoubleOutputType.dataType match {\n  case (elementType: org.apache.spark.sql.types.DataType, containsNull: Boolean)org.apache.spark.sql.types.ArrayType((fields: Array[org.apache.spark.sql.types.StructField])org.apache.spark.sql.types.StructType(scala.Array.unapplySeq[org.apache.spark.sql.types.StructField](<unapply-selector>) <unapply> ((name: String, dataType: org.apache.spark.sql.types.DataType, nullable: Boolean, metadata: org.apache.spark.sql.types.Metadata)org.apache.spark.sql.types.StructField(\"x\", org.apache.spark.sql.types.DoubleType, _, _), (name: String, dataType: org.apache.spark.sql.types.DataType, nullable: Boolean, metadata: org.apache.spark.sql.types.Metadata)org.apache.spark.sql.types.StructField(\"y\", _, _, _))), true) => true\n}", Prettifier$.MODULE$.default());
                                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HistogramNumericSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 218));
                                });
                                aggPropagateOutputType = new HistogramNumeric((Expression)new BoundReference(0, left.dataType(), true), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)5)));
                                $org_scalatest_assert_macro_left = aggPropagateOutputType.left().dataType();
                                dataType = aggPropagateOutputType.dataType();
                                if (!(dataType instanceof ArrayType)) break block7;
                                ArrayType arrayType = (ArrayType)dataType;
                                DataType dataType2 = arrayType.elementType();
                                boolean bl = arrayType.containsNull();
                                if (!(dataType2 instanceof StructType) || (option = Array$.MODULE$.unapplySeq((Object)(structFieldArray = (structType = (StructType)dataType2).fields()))).isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(2) != 0) break block7;
                                StructField structField = (StructField)((SeqLike)option.get()).apply(0);
                                StructField structField2 = (StructField)((SeqLike)option.get()).apply(1);
                                if (structField == null) break block7;
                                String string = structField.name();
                                lhs = structField.dataType();
                                boolean bl2 = structField.nullable();
                                if (!"x".equals(string) || !bl2 || structField2 == null) break block7;
                                String string2 = structField2.name();
                                boolean bl3 = structField2.nullable();
                                if ("y".equals(string2) && bl3 && bl) break block8;
                            }
                            throw new MatchError((Object)dataType);
                        }
                        DataType dataType = lhs;
                        DataType $org_scalatest_assert_macro_right = dataType;
                        DataType dataType3 = $org_scalatest_assert_macro_left;
                        DataType dataType4 = $org_scalatest_assert_macro_right;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(dataType3 != null ? !dataType3.equals(dataType4) : dataType4 != null), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HistogramNumericSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 226));
                        GenericInternalRow buffer = new GenericInternalRow(new Object[1]);
                        aggPropagateOutputType.initialize((InternalRow)buffer);
                        aggPropagateOutputType.update((InternalRow)buffer, InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{left.value()})));
                        aggPropagateOutputType.update((InternalRow)buffer, InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{middle.value()})));
                        aggPropagateOutputType.update((InternalRow)buffer, InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{right.value()})));
                        Object result = aggPropagateOutputType.eval((InternalRow)buffer);
                        DataType dataType5 = left.dataType();
                        NullType$ nullType$ = NullType$.MODULE$;
                        if (dataType5 == null ? nullType$ != null : !dataType5.equals(nullType$)) {
                            Object $org_scalatest_assert_macro_left2 = result;
                            Object $org_scalatest_assert_macro_right2 = null;
                            Object object = $org_scalatest_assert_macro_left2;
                            Object var34_31 = null;
                            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left2, "!=", null, object == null ? var34_31 != null : !object.equals(var34_31), Prettifier$.MODULE$.default());
                            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HistogramNumericSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 243));
                            DoubleRef ys = DoubleRef.create((double)0.0);
                            Object object2 = result;
                            if (!(object2 instanceof GenericArrayData)) {
                                throw new MatchError(object2);
                            }
                            GenericArrayData genericArrayData = (GenericArrayData)object2;
                            Predef$.MODULE$.genericArrayOps((Object)genericArrayData.array()).foreach((Function1 & Serializable & scala.Serializable)row -> {
                                HistogramNumericSuite.$anonfun$new$20(ys, row);
                                return BoxedUnit.UNIT;
                            });
                            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                            double $org_scalatest_assert_macro_left3 = ys.elem;
                            int $org_scalatest_assert_macro_right3 = 1;
                            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 > (double)$org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
                            boxedUnit = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HistogramNumericSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 256));
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        break block9;
                    }
                    throw new MatchError((Object)tuple3);
                }
                BoxedUnit boxedUnit3 = boxedUnit;
                return boxedUnit3;
            });
        }, new Position("HistogramNumericSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
    }
}

