/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.Period;
import java.util.concurrent.TimeUnit;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.scalacheck.Arbitrary$;
import org.scalacheck.Gen;
import org.scalacheck.Gen$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class LiteralGenerator$ {
    public static LiteralGenerator$ MODULE$;
    private Gen<Literal> byteLiteralGen;
    private Gen<Literal> shortLiteralGen;
    private Gen<Literal> integerLiteralGen;
    private Gen<Literal> longLiteralGen;
    private Gen<Literal> floatLiteralGen;
    private Gen<Literal> doubleLiteralGen;
    private Gen<Literal> stringLiteralGen;
    private Gen<Literal> binaryLiteralGen;
    private Gen<Literal> booleanLiteralGen;
    private Gen<Literal> dateLiteralGen;
    private Gen<Literal> timestampLiteralGen;
    private Gen<Literal> timestampNTZLiteralGen;
    private Gen<Literal> monthIntervalLiterGen;
    private Gen<Literal> calendarIntervalLiterGen;
    private Gen<Literal> limitedIntegerLiteralGen;
    private Gen<Literal> dayTimeIntervalLiteralGen;
    private Gen<Literal> yearMonthIntervalLiteralGen;
    private final int maxIntervalInMonths;
    private volatile int bitmap$0;

    static {
        new LiteralGenerator$();
    }

    private Gen<Literal> byteLiteralGen$lzycompute() {
        LiteralGenerator$ literalGenerator$ = this;
        synchronized (literalGenerator$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.byteLiteralGen = Arbitrary$.MODULE$.arbByte().arbitrary().map((Function1 & Serializable & scala.Serializable)b -> Literal$.MODULE$.create((Object)BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToByte((Object)b)), (DataType)ByteType$.MODULE$));
                this.bitmap$0 |= 1;
            }
        }
        return this.byteLiteralGen;
    }

    public Gen<Literal> byteLiteralGen() {
        return (this.bitmap$0 & 1) == 0 ? this.byteLiteralGen$lzycompute() : this.byteLiteralGen;
    }

    private Gen<Literal> shortLiteralGen$lzycompute() {
        LiteralGenerator$ literalGenerator$ = this;
        synchronized (literalGenerator$) {
            if ((this.bitmap$0 & 2) == 0) {
                this.shortLiteralGen = Arbitrary$.MODULE$.arbShort().arbitrary().map((Function1 & Serializable & scala.Serializable)s -> Literal$.MODULE$.create((Object)BoxesRunTime.boxToShort((short)BoxesRunTime.unboxToShort((Object)s)), (DataType)ShortType$.MODULE$));
                this.bitmap$0 |= 2;
            }
        }
        return this.shortLiteralGen;
    }

    public Gen<Literal> shortLiteralGen() {
        return (this.bitmap$0 & 2) == 0 ? this.shortLiteralGen$lzycompute() : this.shortLiteralGen;
    }

    private Gen<Literal> integerLiteralGen$lzycompute() {
        LiteralGenerator$ literalGenerator$ = this;
        synchronized (literalGenerator$) {
            if ((this.bitmap$0 & 4) == 0) {
                this.integerLiteralGen = Arbitrary$.MODULE$.arbInt().arbitrary().map((Function1 & Serializable & scala.Serializable)i -> Literal$.MODULE$.create((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)), (DataType)IntegerType$.MODULE$));
                this.bitmap$0 |= 4;
            }
        }
        return this.integerLiteralGen;
    }

    public Gen<Literal> integerLiteralGen() {
        return (this.bitmap$0 & 4) == 0 ? this.integerLiteralGen$lzycompute() : this.integerLiteralGen;
    }

    private Gen<Literal> longLiteralGen$lzycompute() {
        LiteralGenerator$ literalGenerator$ = this;
        synchronized (literalGenerator$) {
            if ((this.bitmap$0 & 8) == 0) {
                this.longLiteralGen = Arbitrary$.MODULE$.arbLong().arbitrary().map((Function1 & Serializable & scala.Serializable)l -> Literal$.MODULE$.create((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)l)), (DataType)LongType$.MODULE$));
                this.bitmap$0 |= 8;
            }
        }
        return this.longLiteralGen;
    }

    public Gen<Literal> longLiteralGen() {
        return (this.bitmap$0 & 8) == 0 ? this.longLiteralGen$lzycompute() : this.longLiteralGen;
    }

    private Gen<Literal> floatLiteralGen$lzycompute() {
        LiteralGenerator$ literalGenerator$ = this;
        synchronized (literalGenerator$) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.floatLiteralGen = Gen$.MODULE$.oneOf(Gen$.MODULE$.oneOf((Object)BoxesRunTime.boxToFloat((float)Float.NaN), (Object)BoxesRunTime.boxToFloat((float)Float.POSITIVE_INFINITY), (Seq)Predef$.MODULE$.wrapFloatArray(new float[]{Float.NEGATIVE_INFINITY, Float.MIN_VALUE, Float.MAX_VALUE, -Float.MAX_VALUE, 0.0f, -0.0f, 1.0f, -1.0f})), Arbitrary$.MODULE$.arbFloat().arbitrary(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Gen[0])).map((Function1 & Serializable & scala.Serializable)f -> Literal$.MODULE$.create((Object)BoxesRunTime.boxToFloat((float)BoxesRunTime.unboxToFloat((Object)f)), (DataType)FloatType$.MODULE$));
                this.bitmap$0 |= 0x10;
            }
        }
        return this.floatLiteralGen;
    }

    public Gen<Literal> floatLiteralGen() {
        return (this.bitmap$0 & 0x10) == 0 ? this.floatLiteralGen$lzycompute() : this.floatLiteralGen;
    }

    private Gen<Literal> doubleLiteralGen$lzycompute() {
        LiteralGenerator$ literalGenerator$ = this;
        synchronized (literalGenerator$) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.doubleLiteralGen = Gen$.MODULE$.oneOf(Gen$.MODULE$.oneOf((Object)BoxesRunTime.boxToDouble((double)Double.NaN), (Object)BoxesRunTime.boxToDouble((double)Double.POSITIVE_INFINITY), (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{Double.NEGATIVE_INFINITY, Double.MIN_VALUE, Double.MAX_VALUE, -Double.MAX_VALUE, 0.0, -0.0, 1.0, -1.0})), Arbitrary$.MODULE$.arbDouble().arbitrary(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Gen[0])).map((Function1 & Serializable & scala.Serializable)f -> Literal$.MODULE$.create((Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)f)), (DataType)DoubleType$.MODULE$));
                this.bitmap$0 |= 0x20;
            }
        }
        return this.doubleLiteralGen;
    }

    public Gen<Literal> doubleLiteralGen() {
        return (this.bitmap$0 & 0x20) == 0 ? this.doubleLiteralGen$lzycompute() : this.doubleLiteralGen;
    }

    public Gen<Literal> decimalLiteralGen(int precision, int scale) {
        int $org_scalatest_assert_macro_left = scale;
        int $org_scalatest_assert_macro_right = 0;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), ">=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left >= $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LiteralGenerator.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
        int $org_scalatest_assert_macro_left2 = precision;
        int $org_scalatest_assert_macro_right2 = scale;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), ">=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 >= $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LiteralGenerator.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
        return Arbitrary$.MODULE$.arbBigInt().arbitrary().map((Function1 & Serializable & scala.Serializable)s -> {
            String a = s.$percent(package$.MODULE$.BigInt().apply(10).pow(precision - scale)).toString();
            String b = s.$percent(package$.MODULE$.BigInt().apply(10).pow(scale)).abs().toString();
            return Literal$.MODULE$.create((Object)Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply(new StringBuilder(1).append(a).append(".").append(b).toString()), precision, scale), (DataType)new DecimalType(precision, scale));
        });
    }

    private Gen<Literal> stringLiteralGen$lzycompute() {
        LiteralGenerator$ literalGenerator$ = this;
        synchronized (literalGenerator$) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.stringLiteralGen = Arbitrary$.MODULE$.arbString().arbitrary().map((Function1 & Serializable & scala.Serializable)s -> Literal$.MODULE$.create(s, (DataType)StringType$.MODULE$));
                this.bitmap$0 |= 0x40;
            }
        }
        return this.stringLiteralGen;
    }

    public Gen<Literal> stringLiteralGen() {
        return (this.bitmap$0 & 0x40) == 0 ? this.stringLiteralGen$lzycompute() : this.stringLiteralGen;
    }

    private Gen<Literal> binaryLiteralGen$lzycompute() {
        LiteralGenerator$ literalGenerator$ = this;
        synchronized (literalGenerator$) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.binaryLiteralGen = Gen$.MODULE$.listOf((Function0 & Serializable & scala.Serializable)() -> Arbitrary$.MODULE$.arbByte().arbitrary()).map((Function1 & Serializable & scala.Serializable)ab -> Literal$.MODULE$.create(ab.toArray(ClassTag$.MODULE$.Byte()), (DataType)BinaryType$.MODULE$));
                this.bitmap$0 |= 0x80;
            }
        }
        return this.binaryLiteralGen;
    }

    public Gen<Literal> binaryLiteralGen() {
        return (this.bitmap$0 & 0x80) == 0 ? this.binaryLiteralGen$lzycompute() : this.binaryLiteralGen;
    }

    private Gen<Literal> booleanLiteralGen$lzycompute() {
        LiteralGenerator$ literalGenerator$ = this;
        synchronized (literalGenerator$) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.booleanLiteralGen = Arbitrary$.MODULE$.arbBool().arbitrary().map((Function1 & Serializable & scala.Serializable)b -> Literal$.MODULE$.create((Object)BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)b)), (DataType)BooleanType$.MODULE$));
                this.bitmap$0 |= 0x100;
            }
        }
        return this.booleanLiteralGen;
    }

    public Gen<Literal> booleanLiteralGen() {
        return (this.bitmap$0 & 0x100) == 0 ? this.booleanLiteralGen$lzycompute() : this.booleanLiteralGen;
    }

    private Gen<Literal> dateLiteralGen$lzycompute() {
        LiteralGenerator$ literalGenerator$ = this;
        synchronized (literalGenerator$) {
            if ((this.bitmap$0 & 0x200) == 0) {
                long minDay = LocalDate.of(1, 1, 1).toEpochDay();
                long maxDay = LocalDate.of(9999, 12, 31).toEpochDay();
                this.dateLiteralGen = Gen$.MODULE$.choose((Object)BoxesRunTime.boxToLong((long)minDay), (Object)BoxesRunTime.boxToLong((long)maxDay), Gen.Choose$.MODULE$.chooseLong()).map((Function1 & Serializable & scala.Serializable)day -> Literal$.MODULE$.create((Object)new Date(BoxesRunTime.unboxToLong((Object)day) * 86400000L), (DataType)DateType$.MODULE$));
                this.bitmap$0 |= 0x200;
            }
        }
        return this.dateLiteralGen;
    }

    public Gen<Literal> dateLiteralGen() {
        return (this.bitmap$0 & 0x200) == 0 ? this.dateLiteralGen$lzycompute() : this.dateLiteralGen;
    }

    private Gen<Object> millisGen() {
        long minMillis = Instant.parse("0001-01-01T00:00:00.000000Z").toEpochMilli();
        long maxMillis = Instant.parse("9999-12-31T23:59:59.999999Z").toEpochMilli();
        return Gen$.MODULE$.choose((Object)BoxesRunTime.boxToLong((long)minMillis), (Object)BoxesRunTime.boxToLong((long)maxMillis), Gen.Choose$.MODULE$.chooseLong());
    }

    private Gen<Literal> timestampLiteralGen$lzycompute() {
        LiteralGenerator$ literalGenerator$ = this;
        synchronized (literalGenerator$) {
            if ((this.bitmap$0 & 0x400) == 0) {
                this.timestampLiteralGen = this.millisGen().map((Function1 & Serializable & scala.Serializable)millis -> Literal$.MODULE$.create((Object)new Timestamp(BoxesRunTime.unboxToLong((Object)millis)), (DataType)TimestampType$.MODULE$));
                this.bitmap$0 |= 0x400;
            }
        }
        return this.timestampLiteralGen;
    }

    public Gen<Literal> timestampLiteralGen() {
        return (this.bitmap$0 & 0x400) == 0 ? this.timestampLiteralGen$lzycompute() : this.timestampLiteralGen;
    }

    private Gen<Literal> timestampNTZLiteralGen$lzycompute() {
        LiteralGenerator$ literalGenerator$ = this;
        synchronized (literalGenerator$) {
            if ((this.bitmap$0 & 0x800) == 0) {
                this.timestampNTZLiteralGen = this.millisGen().map((Function1 & Serializable & scala.Serializable)millis -> Literal$.MODULE$.create((Object)DateTimeUtils$.MODULE$.microsToLocalDateTime(BoxesRunTime.unboxToLong((Object)millis) * 1000L), (DataType)TimestampNTZType$.MODULE$));
                this.bitmap$0 |= 0x800;
            }
        }
        return this.timestampNTZLiteralGen;
    }

    public Gen<Literal> timestampNTZLiteralGen() {
        return (this.bitmap$0 & 0x800) == 0 ? this.timestampNTZLiteralGen$lzycompute() : this.timestampNTZLiteralGen;
    }

    private int maxIntervalInMonths() {
        return this.maxIntervalInMonths;
    }

    private Gen<Literal> monthIntervalLiterGen$lzycompute() {
        LiteralGenerator$ literalGenerator$ = this;
        synchronized (literalGenerator$) {
            if ((this.bitmap$0 & 0x1000) == 0) {
                this.monthIntervalLiterGen = Gen$.MODULE$.choose((Object)BoxesRunTime.boxToInteger((int)(-1 * this.maxIntervalInMonths())), (Object)BoxesRunTime.boxToInteger((int)this.maxIntervalInMonths()), Gen.Choose$.MODULE$.chooseInt()).map((Function1 & Serializable & scala.Serializable)months -> Literal$.MODULE$.create((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)months)), (DataType)IntegerType$.MODULE$));
                this.bitmap$0 |= 0x1000;
            }
        }
        return this.monthIntervalLiterGen;
    }

    public Gen<Literal> monthIntervalLiterGen() {
        return (this.bitmap$0 & 0x1000) == 0 ? this.monthIntervalLiterGen$lzycompute() : this.monthIntervalLiterGen;
    }

    private Gen<Literal> calendarIntervalLiterGen$lzycompute() {
        LiteralGenerator$ literalGenerator$ = this;
        synchronized (literalGenerator$) {
            if ((this.bitmap$0 & 0x2000) == 0) {
                long maxDurationInSec = Duration.between(Instant.parse("0001-01-01T00:00:00.000000Z"), Instant.parse("9999-12-31T23:59:59.999999Z")).getSeconds();
                long maxMicros = TimeUnit.SECONDS.toMicros(maxDurationInSec);
                int maxDays = (int)TimeUnit.SECONDS.toDays(maxDurationInSec);
                this.calendarIntervalLiterGen = Gen$.MODULE$.choose((Object)BoxesRunTime.boxToInteger((int)(-1 * this.maxIntervalInMonths())), (Object)BoxesRunTime.boxToInteger((int)this.maxIntervalInMonths()), Gen.Choose$.MODULE$.chooseInt()).flatMap((Function1 & Serializable & scala.Serializable)months -> LiteralGenerator$.$anonfun$calendarIntervalLiterGen$1(maxMicros, maxDays, BoxesRunTime.unboxToInt((Object)months)));
                this.bitmap$0 |= 0x2000;
            }
        }
        return this.calendarIntervalLiterGen;
    }

    public Gen<Literal> calendarIntervalLiterGen() {
        return (this.bitmap$0 & 0x2000) == 0 ? this.calendarIntervalLiterGen$lzycompute() : this.calendarIntervalLiterGen;
    }

    private Gen<Literal> limitedIntegerLiteralGen$lzycompute() {
        LiteralGenerator$ literalGenerator$ = this;
        synchronized (literalGenerator$) {
            if ((this.bitmap$0 & 0x4000) == 0) {
                this.limitedIntegerLiteralGen = Gen$.MODULE$.choose((Object)BoxesRunTime.boxToInteger((int)-100), (Object)BoxesRunTime.boxToInteger((int)100), Gen.Choose$.MODULE$.chooseInt()).map((Function1 & Serializable & scala.Serializable)i -> Literal$.MODULE$.create((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)), (DataType)IntegerType$.MODULE$));
                this.bitmap$0 |= 0x4000;
            }
        }
        return this.limitedIntegerLiteralGen;
    }

    public Gen<Literal> limitedIntegerLiteralGen() {
        return (this.bitmap$0 & 0x4000) == 0 ? this.limitedIntegerLiteralGen$lzycompute() : this.limitedIntegerLiteralGen;
    }

    private Gen<Literal> dayTimeIntervalLiteralGen$lzycompute() {
        LiteralGenerator$ literalGenerator$ = this;
        synchronized (literalGenerator$) {
            if ((this.bitmap$0 & 0x8000) == 0) {
                this.dayTimeIntervalLiteralGen = this.calendarIntervalLiterGen().map((Function1 & Serializable & scala.Serializable)calendarIntervalLiteral -> Literal$.MODULE$.create((Object)((CalendarInterval)calendarIntervalLiteral.value()).extractAsDuration(), (DataType)DayTimeIntervalType$.MODULE$.apply()));
                this.bitmap$0 |= 0x8000;
            }
        }
        return this.dayTimeIntervalLiteralGen;
    }

    public Gen<Literal> dayTimeIntervalLiteralGen() {
        return (this.bitmap$0 & 0x8000) == 0 ? this.dayTimeIntervalLiteralGen$lzycompute() : this.dayTimeIntervalLiteralGen;
    }

    private Gen<Literal> yearMonthIntervalLiteralGen$lzycompute() {
        LiteralGenerator$ literalGenerator$ = this;
        synchronized (literalGenerator$) {
            if ((this.bitmap$0 & 0x10000) == 0) {
                this.yearMonthIntervalLiteralGen = Gen$.MODULE$.choose((Object)BoxesRunTime.boxToInteger((int)(-1 * this.maxIntervalInMonths())), (Object)BoxesRunTime.boxToInteger((int)this.maxIntervalInMonths()), Gen.Choose$.MODULE$.chooseInt()).map((Function1 & Serializable & scala.Serializable)months -> Literal$.MODULE$.create((Object)Period.ofMonths(BoxesRunTime.unboxToInt((Object)months)), (DataType)YearMonthIntervalType$.MODULE$.apply()));
                this.bitmap$0 |= 0x10000;
            }
        }
        return this.yearMonthIntervalLiteralGen;
    }

    public Gen<Literal> yearMonthIntervalLiteralGen() {
        return (this.bitmap$0 & 0x10000) == 0 ? this.yearMonthIntervalLiteralGen$lzycompute() : this.yearMonthIntervalLiteralGen;
    }

    public Gen<Literal> randomGen(DataType dt) {
        DecimalType decimalType;
        Option option;
        Gen<Literal> gen;
        DataType dataType = dt;
        if (ByteType$.MODULE$.equals(dataType)) {
            gen = this.byteLiteralGen();
        } else if (ShortType$.MODULE$.equals(dataType)) {
            gen = this.shortLiteralGen();
        } else if (IntegerType$.MODULE$.equals(dataType)) {
            gen = this.integerLiteralGen();
        } else if (LongType$.MODULE$.equals(dataType)) {
            gen = this.longLiteralGen();
        } else if (DoubleType$.MODULE$.equals(dataType)) {
            gen = this.doubleLiteralGen();
        } else if (FloatType$.MODULE$.equals(dataType)) {
            gen = this.floatLiteralGen();
        } else if (DateType$.MODULE$.equals(dataType)) {
            gen = this.dateLiteralGen();
        } else if (TimestampType$.MODULE$.equals(dataType)) {
            gen = this.timestampLiteralGen();
        } else if (TimestampNTZType$.MODULE$.equals(dataType)) {
            gen = this.timestampNTZLiteralGen();
        } else if (BooleanType$.MODULE$.equals(dataType)) {
            gen = this.booleanLiteralGen();
        } else if (StringType$.MODULE$.equals(dataType)) {
            gen = this.stringLiteralGen();
        } else if (BinaryType$.MODULE$.equals(dataType)) {
            gen = this.binaryLiteralGen();
        } else if (CalendarIntervalType$.MODULE$.equals(dataType)) {
            gen = this.calendarIntervalLiterGen();
        } else if (dataType instanceof DecimalType && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType)).isEmpty()) {
            int precision = ((Tuple2)option.get())._1$mcI$sp();
            int scale = ((Tuple2)option.get())._2$mcI$sp();
            gen = this.decimalLiteralGen(precision, scale);
        } else if (dataType instanceof DayTimeIntervalType) {
            gen = this.dayTimeIntervalLiteralGen();
        } else if (dataType instanceof YearMonthIntervalType) {
            gen = this.yearMonthIntervalLiteralGen();
        } else {
            throw new IllegalArgumentException(new StringBuilder(19).append("not supported type ").append(dataType).toString());
        }
        return gen;
    }

    public static final /* synthetic */ Gen $anonfun$calendarIntervalLiterGen$2(int maxDays$1, int months$1, long micros) {
        return Gen$.MODULE$.choose((Object)BoxesRunTime.boxToInteger((int)(-1 * maxDays$1)), (Object)BoxesRunTime.boxToInteger((int)maxDays$1), Gen.Choose$.MODULE$.chooseInt()).map((Function1 & Serializable & scala.Serializable)days -> Literal$.MODULE$.create((Object)new CalendarInterval(months$1, BoxesRunTime.unboxToInt((Object)days), micros), (DataType)CalendarIntervalType$.MODULE$));
    }

    public static final /* synthetic */ Gen $anonfun$calendarIntervalLiterGen$1(long maxMicros$1, int maxDays$1, int months) {
        return Gen$.MODULE$.choose((Object)BoxesRunTime.boxToLong((long)(-1L * maxMicros$1)), (Object)BoxesRunTime.boxToLong((long)maxMicros$1), Gen.Choose$.MODULE$.chooseLong()).flatMap((Function1 & Serializable & scala.Serializable)micros -> LiteralGenerator$.$anonfun$calendarIntervalLiterGen$2(maxDays$1, months, BoxesRunTime.unboxToLong((Object)micros)));
    }

    private LiteralGenerator$() {
        MODULE$ = this;
        this.maxIntervalInMonths = 120000;
    }
}

