/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.parser;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.FunctionIdentifier$;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.analysis.AnalysisTest;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.analysis.RelationTimeTravel;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAlias;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAlias$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedFunction;
import org.apache.spark.sql.catalyst.analysis.UnresolvedFunction$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedGenerator;
import org.apache.spark.sql.catalyst.analysis.UnresolvedInlineTable;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedStar;
import org.apache.spark.sql.catalyst.analysis.UnresolvedSubqueryColumnAliases;
import org.apache.spark.sql.catalyst.analysis.UnresolvedTableValuedFunction$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.CreateStruct$;
import org.apache.spark.sql.catalyst.expressions.Cube$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.FrameType;
import org.apache.spark.sql.catalyst.expressions.Generator;
import org.apache.spark.sql.catalyst.expressions.GroupingSets$;
import org.apache.spark.sql.catalyst.expressions.LateralSubquery;
import org.apache.spark.sql.catalyst.expressions.LateralSubquery$;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.Overlay;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.expressions.Rollup$;
import org.apache.spark.sql.catalyst.expressions.RowFrame$;
import org.apache.spark.sql.catalyst.expressions.ScalarSubquery;
import org.apache.spark.sql.catalyst.expressions.ScalarSubquery$;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.expressions.SpecifiedWindowFrame;
import org.apache.spark.sql.catalyst.expressions.StringTrim;
import org.apache.spark.sql.catalyst.expressions.StringTrimLeft;
import org.apache.spark.sql.catalyst.expressions.StringTrimRight;
import org.apache.spark.sql.catalyst.expressions.UnspecifiedFrame$;
import org.apache.spark.sql.catalyst.expressions.WindowFrame;
import org.apache.spark.sql.catalyst.expressions.WindowSpecDefinition;
import org.apache.spark.sql.catalyst.expressions.aggregate.PercentileCont;
import org.apache.spark.sql.catalyst.expressions.aggregate.PercentileCont$;
import org.apache.spark.sql.catalyst.expressions.aggregate.PercentileDisc;
import org.apache.spark.sql.catalyst.expressions.aggregate.PercentileDisc$;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.catalyst.plans.Cross$;
import org.apache.spark.sql.catalyst.plans.FullOuter$;
import org.apache.spark.sql.catalyst.plans.Inner$;
import org.apache.spark.sql.catalyst.plans.JoinType;
import org.apache.spark.sql.catalyst.plans.LeftAnti$;
import org.apache.spark.sql.catalyst.plans.LeftOuter$;
import org.apache.spark.sql.catalyst.plans.LeftSemi$;
import org.apache.spark.sql.catalyst.plans.NaturalJoin;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.RightOuter$;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.UsingJoin;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.Distinct;
import org.apache.spark.sql.catalyst.plans.logical.InsertIntoStatement;
import org.apache.spark.sql.catalyst.plans.logical.LateralJoin;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.OneRowRelation;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.plans.logical.Sample;
import org.apache.spark.sql.catalyst.plans.logical.ScriptInputOutputSchema;
import org.apache.spark.sql.catalyst.plans.logical.ScriptTransformation;
import org.apache.spark.sql.catalyst.plans.logical.SubqueryAlias$;
import org.apache.spark.sql.catalyst.plans.logical.Union$;
import org.apache.spark.sql.catalyst.plans.logical.UnresolvedHint;
import org.apache.spark.sql.catalyst.plans.logical.UnresolvedWith;
import org.apache.spark.sql.catalyst.plans.logical.WithWindowDefinition;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StringType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001!4AAB\u0004\u0001)!)q\u0004\u0001C\u0001A!)1\u0005\u0001C\u0005I!)!\t\u0001C\u0005\u0007\")!\t\u0001C\u0005\u0015\")!\u000b\u0001C\u0005'\ny\u0001\u000b\\1o!\u0006\u00148/\u001a:Tk&$XM\u0003\u0002\t\u0013\u00051\u0001/\u0019:tKJT!AC\u0006\u0002\u0011\r\fG/\u00197zgRT!\u0001D\u0007\u0002\u0007M\fHN\u0003\u0002\u000f\u001f\u0005)1\u000f]1sW*\u0011\u0001#E\u0001\u0007CB\f7\r[3\u000b\u0003I\t1a\u001c:h\u0007\u0001\u00192\u0001A\u000b\u001a!\t1r#D\u0001\u000e\u0013\tARBA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u00035ui\u0011a\u0007\u0006\u00039%\t\u0001\"\u00198bYf\u001c\u0018n]\u0005\u0003=m\u0011A\"\u00118bYf\u001c\u0018n\u001d+fgR\fa\u0001P5oSRtD#A\u0011\u0011\u0005\t\u0002Q\"A\u0004\u0002\u0017\u0005\u001c8/\u001a:u\u000bF,\u0018\r\u001c\u000b\u0004K-B\u0004C\u0001\u0014*\u001b\u00059#\"\u0001\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005):#\u0001B+oSRDQ\u0001\f\u0002A\u00025\n!b]9m\u0007>lW.\u00198e!\tqSG\u0004\u00020gA\u0011\u0001gJ\u0007\u0002c)\u0011!gE\u0001\u0007yI|w\u000e\u001e \n\u0005Q:\u0013A\u0002)sK\u0012,g-\u0003\u00027o\t11\u000b\u001e:j]\u001eT!\u0001N\u0014\t\u000be\u0012\u0001\u0019\u0001\u001e\u0002\tAd\u0017M\u001c\t\u0003w\u0001k\u0011\u0001\u0010\u0006\u0003{y\nq\u0001\\8hS\u000e\fGN\u0003\u0002@\u0013\u0005)\u0001\u000f\\1og&\u0011\u0011\t\u0010\u0002\f\u0019><\u0017nY1m!2\fg.A\u0005j]R,'oY3qiR\u0019Q\u0005R#\t\u000b1\u001a\u0001\u0019A\u0017\t\u000b\u0019\u001b\u0001\u0019A$\u0002\u00115,7o]1hKN\u00042A\n%.\u0013\tIuE\u0001\u0006=e\u0016\u0004X-\u0019;fIz\"B!J&M#\")A\u0006\u0002a\u0001[!)Q\n\u0002a\u0001\u001d\u0006QQM\u001d:pe\u000ec\u0017m]:\u0011\u0007\u0019zU&\u0003\u0002QO\t1q\n\u001d;j_:DQA\u0012\u0003A\u0002\u001d\u000b1a\u0019;f)\r!v\u000b\u0017\t\u0003wUK!A\u0016\u001f\u0003\u001dUs'/Z:pYZ,GmV5uQ\")\u0011(\u0002a\u0001u!)\u0011,\u0002a\u00015\u0006Qa.Y7fIBc\u0017M\\:\u0011\u0007\u0019B5\f\u0005\u0003'96r\u0016BA/(\u0005\u0019!V\u000f\u001d7feA!a\u0005\u0018\u001e`!\r\u0001W-\f\b\u0003C\u000et!\u0001\r2\n\u0003!J!\u0001Z\u0014\u0002\u000fA\f7m[1hK&\u0011am\u001a\u0002\u0004'\u0016\f(B\u00013(\u0001")
public class PlanParserSuite
extends SparkFunSuite
implements AnalysisTest {
    private String sparkHome;
    private volatile boolean bitmap$0;

    @Override
    public /* synthetic */ void org$apache$spark$sql$catalyst$analysis$AnalysisTest$$super$comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public Seq<Rule<LogicalPlan>> extendedAnalysisRules() {
        return AnalysisTest.extendedAnalysisRules$(this);
    }

    @Override
    public void createTempView(SessionCatalog catalog, String name, LogicalPlan plan, boolean overrideIfExists) {
        AnalysisTest.createTempView$(this, catalog, name, plan, overrideIfExists);
    }

    @Override
    public void createGlobalTempView(SessionCatalog catalog, String name, LogicalPlan plan, boolean overrideIfExists) {
        AnalysisTest.createGlobalTempView$(this, catalog, name, plan, overrideIfExists);
    }

    @Override
    public Analyzer getAnalyzer() {
        return AnalysisTest.getAnalyzer$(this);
    }

    @Override
    public void checkAnalysis(LogicalPlan inputPlan, LogicalPlan expectedPlan, boolean caseSensitive) {
        AnalysisTest.checkAnalysis$(this, inputPlan, expectedPlan, caseSensitive);
    }

    @Override
    public boolean checkAnalysis$default$3() {
        return AnalysisTest.checkAnalysis$default$3$(this);
    }

    @Override
    public void checkAnalysisWithoutViewWrapper(LogicalPlan inputPlan, LogicalPlan expectedPlan, boolean caseSensitive, boolean inlineCTE) {
        AnalysisTest.checkAnalysisWithoutViewWrapper$(this, inputPlan, expectedPlan, caseSensitive, inlineCTE);
    }

    @Override
    public boolean checkAnalysisWithoutViewWrapper$default$3() {
        return AnalysisTest.checkAnalysisWithoutViewWrapper$default$3$(this);
    }

    @Override
    public boolean checkAnalysisWithoutViewWrapper$default$4() {
        return AnalysisTest.checkAnalysisWithoutViewWrapper$default$4$(this);
    }

    @Override
    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        AnalysisTest.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public boolean comparePlans$default$3() {
        return AnalysisTest.comparePlans$default$3$(this);
    }

    @Override
    public void assertAnalysisSuccess(LogicalPlan inputPlan, boolean caseSensitive) {
        AnalysisTest.assertAnalysisSuccess$(this, inputPlan, caseSensitive);
    }

    @Override
    public boolean assertAnalysisSuccess$default$2() {
        return AnalysisTest.assertAnalysisSuccess$default$2$(this);
    }

    @Override
    public void assertAnalysisError(LogicalPlan inputPlan, Seq<String> expectedErrors, boolean caseSensitive) {
        AnalysisTest.assertAnalysisError$(this, inputPlan, expectedErrors, caseSensitive);
    }

    @Override
    public boolean assertAnalysisError$default$3() {
        return AnalysisTest.assertAnalysisError$default$3$(this);
    }

    @Override
    public void assertAnalysisErrorClass(LogicalPlan inputPlan, String expectedErrorClass, String[] expectedMessageParameters, boolean caseSensitive) {
        AnalysisTest.assertAnalysisErrorClass$(this, inputPlan, expectedErrorClass, expectedMessageParameters, caseSensitive);
    }

    @Override
    public boolean assertAnalysisErrorClass$default$4() {
        return AnalysisTest.assertAnalysisErrorClass$default$4$(this);
    }

    @Override
    public void interceptParseException(Function1<String, Object> parser, String sqlCommand, Seq<String> messages, Option<String> errorClass) {
        AnalysisTest.interceptParseException$(this, parser, sqlCommand, messages, errorClass);
    }

    @Override
    public Option<String> interceptParseException$default$4(Function1<String, Object> parser, String sqlCommand, Seq<String> messages) {
        return AnalysisTest.interceptParseException$default$4$(this, parser, sqlCommand, messages);
    }

    @Override
    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$(this, plan);
    }

    @Override
    public LogicalPlan rewriteNameFromAttrNullability(LogicalPlan plan) {
        return PlanTestBase.rewriteNameFromAttrNullability$(this, plan);
    }

    @Override
    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$(this, plan);
    }

    @Override
    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$(this, e1, e2);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$(this, pairs, f);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression buildBalancedPredicate(Seq<Expression> expressions, Function2<Expression, Expression, Expression> op) {
        return PredicateHelper.buildBalancedPredicate$((PredicateHelper)this, expressions, op);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public boolean isNullIntolerant(Expression expr) {
        return PredicateHelper.isNullIntolerant$((PredicateHelper)this, (Expression)expr);
    }

    public Seq<Attribute> outputWithNullability(Seq<Attribute> output, Seq<ExprId> nonNullAttrExprIds) {
        return PredicateHelper.outputWithNullability$((PredicateHelper)this, output, nonNullAttrExprIds);
    }

    public boolean isLikelySelective(Expression e) {
        return PredicateHelper.isLikelySelective$((PredicateHelper)this, (Expression)e);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Seq<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    private String sparkHome$lzycompute() {
        PlanParserSuite planParserSuite = this;
        synchronized (planParserSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        return !this.bitmap$0 ? this.sparkHome$lzycompute() : this.sparkHome;
    }

    private void assertEqual(String sqlCommand, LogicalPlan plan) {
        this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan(sqlCommand), plan, false);
    }

    private void intercept(String sqlCommand, Seq<String> messages) {
        Function1 & Serializable & scala.Serializable x$1 = (Function1 & Serializable & scala.Serializable)sqlText -> CatalystSqlParser$.MODULE$.parsePlan(sqlText);
        String x$2 = sqlCommand;
        Seq<String> x$3 = messages;
        Option<String> x$4 = this.interceptParseException$default$4((Function1<String, Object>)x$1, x$2, x$3);
        this.interceptParseException((Function1<String, Object>)x$1, x$2, x$3, x$4);
    }

    private void intercept(String sqlCommand, Option<String> errorClass, Seq<String> messages) {
        this.interceptParseException((Function1<String, Object>)(Function1 & Serializable & scala.Serializable)sqlText -> CatalystSqlParser$.MODULE$.parsePlan(sqlText), sqlCommand, messages, errorClass);
    }

    private UnresolvedWith cte(LogicalPlan plan, Seq<Tuple2<String, Tuple2<LogicalPlan, Seq<String>>>> namedPlans) {
        Seq ctes = (Seq)namedPlans.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2;
            String name;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = x0$1;
                    if (tuple22 == null) break block2;
                    name = (String)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            LogicalPlan cte = (LogicalPlan)tuple2._1();
            Seq columnAliases = (Seq)tuple2._2();
            LogicalPlan subquery = columnAliases.isEmpty() ? cte : new UnresolvedSubqueryColumnAliases(columnAliases, cte);
            Tuple2 tuple23 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)SubqueryAlias$.MODULE$.apply(name, subquery));
            return tuple23;
        }, Seq$.MODULE$.canBuildFrom());
        return new UnresolvedWith(plan, ctes);
    }

    public static final /* synthetic */ void $anonfun$new$29(PlanParserSuite $this, String baseSql$1, String s1$1, LogicalPlan p1$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String s2 = (String)tuple2._1();
        Function1 pf2 = (Function1)tuple2._2();
        $this.assertEqual(new StringBuilder(0).append(baseSql$1).append(s1$1).append(s2).toString(), (LogicalPlan)pf2.apply((Object)p1$1));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$28(PlanParserSuite $this, Seq limitWindowClauses$1, String baseSql$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String s1 = (String)tuple2._1();
        LogicalPlan p1 = (LogicalPlan)tuple2._2();
        limitWindowClauses$1.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            PlanParserSuite.$anonfun$new$29($this, baseSql$1, s1, p1, x0$2);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private static final LogicalPlan insert$1(Map partition, boolean overwrite, boolean ifPartitionNotExists, LogicalPlan plan$1) {
        return new InsertIntoStatement(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"s"})), partition, (Seq)Nil$.MODULE$, plan$1, overwrite, ifPartitionNotExists);
    }

    private static final boolean insert$default$2$1() {
        return false;
    }

    private static final boolean insert$default$3$1() {
        return false;
    }

    private static final void test$1(String sql, JoinType jt, Seq tests) {
        tests.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.apply((Object)sql, (Object)jt);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ Seq $anonfun$new$54(int x) {
        return (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)x)), (List)Nil$.MODULE$);
    }

    private final void assertTrimPlans$1(String inputSQL, Expression expectedExpression) {
        this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan(inputSQL), (LogicalPlan)new Project((Seq)new .colon.colon((Object)new UnresolvedAlias(expectedExpression, UnresolvedAlias$.MODULE$.apply$default$2()), (List)Nil$.MODULE$), (LogicalPlan)new OneRowRelation()), this.comparePlans$default$3());
    }

    private final void assertOverlayPlans$1(String inputSQL, Expression expectedExpression) {
        this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan(inputSQL), (LogicalPlan)new Project((Seq)new .colon.colon((Object)new UnresolvedAlias(expectedExpression, UnresolvedAlias$.MODULE$.apply$default$2()), (List)Nil$.MODULE$), (LogicalPlan)new OneRowRelation()), this.comparePlans$default$3());
    }

    public static final /* synthetic */ void $anonfun$new$77(PlanParserSuite $this, String version$1, LogicalPlan plan$2, String keyword) {
        $this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan(new StringBuilder(27).append("SELECT * FROM a.b.c ").append(keyword).append(" AS OF ").append(version$1).toString()), plan$2, $this.comparePlans$default$3());
        $this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan(new StringBuilder(31).append("SELECT * FROM a.b.c FOR ").append(keyword).append(" AS OF ").append(version$1).toString()), plan$2, $this.comparePlans$default$3());
    }

    private final void testVersion$1(String version, LogicalPlan plan) {
        ((IterableLike)new .colon.colon((Object)"VERSION", (List)new .colon.colon((Object)"SYSTEM_VERSION", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)keyword -> {
            PlanParserSuite.$anonfun$new$77(this, version, plan, keyword);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$78(PlanParserSuite $this, String timestamp$1, LogicalPlan plan$3, String keyword) {
        $this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan(new StringBuilder(27).append("SELECT * FROM a.b.c ").append(keyword).append(" AS OF ").append(timestamp$1).toString()), plan$3, $this.comparePlans$default$3());
        $this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan(new StringBuilder(31).append("SELECT * FROM a.b.c FOR ").append(keyword).append(" AS OF ").append(timestamp$1).toString()), plan$3, $this.comparePlans$default$3());
    }

    private final void testTimestamp$1(String timestamp, LogicalPlan plan) {
        ((IterableLike)new .colon.colon((Object)"TIMESTAMP", (List)new .colon.colon((Object)"SYSTEM_TIME", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)keyword -> {
            PlanParserSuite.$anonfun$new$78(this, timestamp, plan, keyword);
            return BoxedUnit.UNIT;
        });
    }

    private final void assertPercentilePlans$1(String inputSQL, Expression expectedExpression) {
        this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan(inputSQL), (LogicalPlan)new Project((Seq)new .colon.colon((Object)new UnresolvedAlias(expectedExpression, UnresolvedAlias$.MODULE$.apply$default$2()), (List)Nil$.MODULE$), (LogicalPlan)new OneRowRelation()), this.comparePlans$default$3());
    }

    public PlanParserSuite() {
        AliasHelper.$init$((AliasHelper)this);
        PredicateHelper.$init$((PredicateHelper)this);
        SQLHelper.$init$(this);
        SQLConfHelper.$init$((SQLConfHelper)this);
        PlanTestBase.$init$(this);
        AnalysisTest.$init$(this);
        this.test("single comment case one", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan plan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            this.assertEqual("-- single comment\nSELECT * FROM a", plan);
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
        this.test("single comment case two", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan plan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            this.assertEqual("-- single comment\\\nwith line continuity\nSELECT * FROM a", plan);
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
        this.test("bracketed comment case one", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan plan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            this.assertEqual(new StringOps(Predef$.MODULE$.augmentString("\n        |/* This is an example of SQL which should not execute:\n        | * select 'multi-line';\n        | */\n        |SELECT * FROM a\n      ")).stripMargin(), plan);
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
        this.test("bracketed comment case two", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan plan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            this.assertEqual(new StringOps(Predef$.MODULE$.augmentString("\n        |/*\n        |SELECT 'trailing' as x1; -- inside block comment\n        |*/\n        |SELECT * FROM a\n      ")).stripMargin(), plan);
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
        this.test("nested bracketed comment case one", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan plan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            this.assertEqual(new StringOps(Predef$.MODULE$.augmentString("\n        |/* This block comment surrounds a query which itself has a block comment...\n        |SELECT /* embedded single line */ 'embedded' AS x2;\n        |*/\n        |SELECT * FROM a\n      ")).stripMargin(), plan);
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
        this.test("nested bracketed comment case two", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan plan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            this.assertEqual(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT -- continued after the following block comments...\n        |/* Deeply nested comment.\n        |   This includes a single apostrophe to make sure we aren't decoding this part as a string.\n        |SELECT 'deep nest' AS n1;\n        |/* Second level of nesting...\n        |SELECT 'deeper nest' as n2;\n        |/* Third level of nesting...\n        |SELECT 'deepest nest' as n3;\n        |*/\n        |Hoo boy. Still two deep...\n        |*/\n        |Now just one deep...\n        |*/\n        |* FROM a\n      ")).stripMargin(), plan);
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
        this.test("nested bracketed comment case three", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan plan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            this.assertEqual(new StringOps(Predef$.MODULE$.augmentString("\n        |/* This block comment surrounds a query which itself has a block comment...\n        |//* I am a nested bracketed comment.\n        |*/\n        |*/\n        |SELECT * FROM a\n      ")).stripMargin(), plan);
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
        this.test("nested bracketed comment case four", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan plan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            this.assertEqual(new StringOps(Predef$.MODULE$.augmentString("\n        |/*/**/*/\n        |SELECT * FROM a\n      ")).stripMargin(), plan);
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
        this.test("nested bracketed comment case five", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan plan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            this.assertEqual(new StringOps(Predef$.MODULE$.augmentString("\n        |/*/*abc*/*/\n        |SELECT * FROM a\n      ")).stripMargin(), plan);
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
        this.test("nested bracketed comment case six", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan plan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            this.assertEqual(new StringOps(Predef$.MODULE$.augmentString("\n        |/*/*foo*//*bar*/*/\n        |SELECT * FROM a\n      ")).stripMargin(), plan);
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
        this.test("nested bracketed comment case seven", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan plan = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new OneRowRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))).as("a")}));
            this.assertEqual(new StringOps(Predef$.MODULE$.augmentString("\n        |/*abc*/\n        |select 1 as a\n        |/*\n        |\n        |2 as b\n        |/*abc */\n        |, 3 as c\n        |\n        |/**/\n        |*/\n      ")).stripMargin(), plan);
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
        this.test("unclosed bracketed comment one", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String query = new StringOps(Predef$.MODULE$.augmentString("\n                  |/*abc*/\n                  |select 1 as a\n                  |/*\n                  |\n                  |2 as b\n                  |/*abc */\n                  |, 3 as c\n                  |\n                  |/**/\n                  |")).stripMargin();
            ParseException e = (ParseException)this.intercept((Function0 & Serializable & scala.Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(query), ClassTag$.MODULE$.apply(ParseException.class), new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
            String $org_scalatest_assert_macro_left = e.getMessage();
            String $org_scalatest_assert_macro_right = "Unclosed bracketed comment";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 197));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
        this.test("unclosed bracketed comment two", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String query = new StringOps(Predef$.MODULE$.augmentString("\n                  |/*abc*/\n                  |select 1 as a\n                  |/*\n                  |\n                  |2 as b\n                  |/*abc */\n                  |, 3 as c\n                  |\n                  |/**/\n                  |select 4 as d\n                  |")).stripMargin();
            ParseException e = (ParseException)this.intercept((Function0 & Serializable & scala.Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(query), ClassTag$.MODULE$.apply(ParseException.class), new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 213));
            String $org_scalatest_assert_macro_left = e.getMessage();
            String $org_scalatest_assert_macro_right = "Unclosed bracketed comment";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 214));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200));
        this.test("case insensitive", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan plan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            this.assertEqual("sELEct * FroM a", plan);
            this.assertEqual("select * fRoM a", plan);
            this.assertEqual("SELECT * FROM a", plan);
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 217));
        this.test("explain", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.intercept("EXPLAIN logical SELECT 1", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported SQL statement"}));
            this.intercept("EXPLAIN formatted SELECT 1", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported SQL statement"}));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 224));
        this.test("set operations", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan a = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            LogicalPlan b = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            this.assertEqual("select * from a union select * from b", (LogicalPlan)new Distinct(package.plans$.MODULE$.DslLogicalPlan(a).union(b)));
            this.assertEqual("select * from a union distinct select * from b", (LogicalPlan)new Distinct(package.plans$.MODULE$.DslLogicalPlan(a).union(b)));
            this.assertEqual("select * from a union all select * from b", package.plans$.MODULE$.DslLogicalPlan(a).union(b));
            this.assertEqual("select * from a except select * from b", package.plans$.MODULE$.DslLogicalPlan(a).except(b, false));
            this.assertEqual("select * from a except distinct select * from b", package.plans$.MODULE$.DslLogicalPlan(a).except(b, false));
            this.assertEqual("select * from a except all select * from b", package.plans$.MODULE$.DslLogicalPlan(a).except(b, true));
            this.assertEqual("select * from a minus select * from b", package.plans$.MODULE$.DslLogicalPlan(a).except(b, false));
            this.assertEqual("select * from a minus all select * from b", package.plans$.MODULE$.DslLogicalPlan(a).except(b, true));
            this.assertEqual("select * from a minus distinct select * from b", package.plans$.MODULE$.DslLogicalPlan(a).except(b, false));
            this.assertEqual("select * from a intersect select * from b", package.plans$.MODULE$.DslLogicalPlan(a).intersect(b, false));
            this.assertEqual("select * from a intersect distinct select * from b", package.plans$.MODULE$.DslLogicalPlan(a).intersect(b, false));
            this.assertEqual("select * from a intersect all select * from b", package.plans$.MODULE$.DslLogicalPlan(a).intersect(b, true));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 229));
        this.test("common table expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("with cte1 as (select * from a) select * from cte1", (LogicalPlan)this.cte(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cte1"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})), (Seq<Tuple2<String, Tuple2<LogicalPlan, Seq<String>>>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cte1"), (Object)new Tuple2((Object)package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})), (Object)Nil$.MODULE$))})));
            this.assertEqual("with cte1 (select 1) select * from cte1", (LogicalPlan)this.cte(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cte1"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})), (Seq<Tuple2<String, Tuple2<LogicalPlan, Seq<String>>>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cte1"), (Object)new Tuple2((Object)package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new OneRowRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.intToLiteral(1)})), (Object)Nil$.MODULE$))})));
            this.assertEqual("with cte1 (select 1), cte2 as (select * from cte1) select * from cte2", (LogicalPlan)this.cte(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cte2"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})), (Seq<Tuple2<String, Tuple2<LogicalPlan, Seq<String>>>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cte1"), (Object)new Tuple2((Object)package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new OneRowRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.intToLiteral(1)})), (Object)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cte2"), (Object)new Tuple2((Object)package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cte1"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})), (Object)Nil$.MODULE$))})));
            this.intercept("with cte1 (select 1), cte1 as (select 1 from cte1) select * from cte1", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CTE definition can't have duplicate names: 'cte1'."}));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 248));
        this.test("simple select query", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("select 1", package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new OneRowRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.intToLiteral(1)})));
            this.assertEqual("select a, b", package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new OneRowRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))})));
            this.assertEqual("select a, b from db.c", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"db", "c"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))})));
            this.assertEqual("select a, b from db.c where x < 1", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"db", "c"}))).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "x")).$less((Expression)package.expressions$.MODULE$.intToLiteral(1)))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))})));
            this.assertEqual("select a, b from db.c having x < 1", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"db", "c"}))).having((Seq)Nil$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}), (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "x")).$less((Expression)package.expressions$.MODULE$.intToLiteral(1))));
            this.assertEqual("select distinct a, b from db.c", (LogicalPlan)new Distinct(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"db", "c"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}))));
            this.assertEqual("select all a, b from db.c", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"db", "c"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))})));
            this.assertEqual("select from tbl", package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new OneRowRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "from")).as("tbl")})));
            this.assertEqual("select a from 1k.2m", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1k", "2m"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))})));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 265));
        this.test("hive-style single-FROM statement", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("from a select b, c", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c"))})));
            this.assertEqual("from db.a select b, c where d < 1", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"db", "a"}))).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "d")).$less((Expression)package.expressions$.MODULE$.intToLiteral(1)))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c"))})));
            this.assertEqual("from a select distinct b, c", (LogicalPlan)new Distinct(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))));
            this.intercept("from a", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Syntax error at or near end of input"}));
            this.intercept("from (from a union all from b) c select *", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Syntax error at or near 'union'"}));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 279));
        this.test("multi select query", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("from a select * select * where s < 10", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))).union(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "s")).$less((Expression)package.expressions$.MODULE$.intToLiteral(10)))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))));
            this.intercept("from a select * select * from x where a.s < 10", (Option<String>)new Some((Object)"PARSE_SYNTAX_ERROR"), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Syntax error at or near 'from'"}));
            this.intercept("from a select * from b", (Option<String>)new Some((Object)"PARSE_SYNTAX_ERROR"), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Syntax error at or near 'from'"}));
            this.assertEqual("from a insert into tbl1 select * insert into tbl2 select * where s < 10", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))).insertInto("tbl1")).union(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "s")).$less((Expression)package.expressions$.MODULE$.intToLiteral(10)))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))).insertInto("tbl2")));
            this.assertEqual("select * from (from a select * select *)", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))).union(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})))).as("__auto_generated_subquery_name")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 290));
        this.test("query organization", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String baseSql = "select * from t";
            LogicalPlan basePlan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            Map ws = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"w1"), (Object)new WindowSpecDefinition((Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$, (WindowFrame)UnspecifiedFrame$.MODULE$))}));
            Seq limitWindowClauses = (Seq)new .colon.colon((Object)new Tuple2((Object)"", (Function1 & Serializable & scala.Serializable)p -> p), (List)new .colon.colon((Object)new Tuple2((Object)" limit 10", (Function1 & Serializable & scala.Serializable)p -> package.plans$.MODULE$.DslLogicalPlan(p).limit((Expression)package.expressions$.MODULE$.intToLiteral(10))), (List)new .colon.colon((Object)new Tuple2((Object)" window w1 as ()", (Function1 & Serializable & scala.Serializable)p -> new WithWindowDefinition(ws, p)), (List)new .colon.colon((Object)new Tuple2((Object)" window w1 as () limit 10", (Function1 & Serializable & scala.Serializable)p -> package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new WithWindowDefinition(ws, p)).limit((Expression)package.expressions$.MODULE$.intToLiteral(10))), (List)Nil$.MODULE$))));
            Seq orderSortDistrClusterClauses = (Seq)new .colon.colon((Object)new Tuple2((Object)"", (Object)basePlan), (List)new .colon.colon((Object)new Tuple2((Object)" order by a, b desc", (Object)package.plans$.MODULE$.DslLogicalPlan(basePlan).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).desc()}))), (List)new .colon.colon((Object)new Tuple2((Object)" sort by a, b desc", (Object)package.plans$.MODULE$.DslLogicalPlan(basePlan).sortBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).desc()}))), (List)Nil$.MODULE$)));
            orderSortDistrClusterClauses.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                PlanParserSuite.$anonfun$new$28(this, limitWindowClauses, baseSql, x0$1);
                return BoxedUnit.UNIT;
            });
            String msg = "Combination of ORDER BY/SORT BY/DISTRIBUTE BY/CLUSTER BY is not supported";
            this.intercept(new StringBuilder(21).append(baseSql).append(" order by a sort by a").toString(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{msg}));
            this.intercept(new StringBuilder(29).append(baseSql).append(" cluster by a distribute by a").toString(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{msg}));
            this.intercept(new StringBuilder(24).append(baseSql).append(" order by a cluster by a").toString(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{msg}));
            this.intercept(new StringBuilder(27).append(baseSql).append(" order by a distribute by a").toString(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{msg}));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 311));
        this.test("insert into", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String sql = "select * from t";
            LogicalPlan plan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            this.assertEqual(new StringBuilder(25).append("insert overwrite table s ").append(sql).toString(), PlanParserSuite.insert$1(Predef$.MODULE$.Map().empty(), true, PlanParserSuite.insert$default$3$1(), plan));
            this.assertEqual(new StringBuilder(57).append("insert overwrite table s partition (e = 1) if not exists ").append(sql).toString(), PlanParserSuite.insert$1((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"e"), (Object)Option$.MODULE$.apply((Object)"1"))})), true, true, plan));
            this.assertEqual(new StringBuilder(14).append("insert into s ").append(sql).toString(), PlanParserSuite.insert$1(Predef$.MODULE$.Map().empty(), PlanParserSuite.insert$default$2$1(), PlanParserSuite.insert$default$3$1(), plan));
            this.assertEqual(new StringBuilder(47).append("insert into table s partition (c = 'd', e = 1) ").append(sql).toString(), PlanParserSuite.insert$1((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)Option$.MODULE$.apply((Object)"d")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"e"), (Object)Option$.MODULE$.apply((Object)"1"))})), PlanParserSuite.insert$default$2$1(), PlanParserSuite.insert$default$3$1(), plan));
            LogicalPlan plan2 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "x")).$greater((Expression)package.expressions$.MODULE$.intToLiteral(5)))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            this.assertEqual("from t insert into s select * limit 1 insert into u select * where x > 5", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(plan).limit((Expression)package.expressions$.MODULE$.intToLiteral(1))).insertInto("s")).union(package.plans$.MODULE$.DslLogicalPlan(plan2).insertInto("u")));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 345));
        this.test("aggregation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String m;
            String sql = "select a, b, sum(c) as c from d group by a, b";
            String sqlWithoutGroupBy = "select a, b, sum(c) as c from d";
            this.assertEqual(sql, package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "sum")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as("c")})));
            this.assertEqual(new StringBuilder(10).append(sql).append(" with cube").toString(), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{Cube$.MODULE$.apply((Seq)new .colon.colon((Object)((Seq)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)((Seq)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)))}), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "sum")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as("c")})));
            this.assertEqual(new StringBuilder(20).append(sqlWithoutGroupBy).append(" group by cube(a, b)").toString(), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{Cube$.MODULE$.apply((Seq)new .colon.colon((Object)((Seq)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)((Seq)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)))}), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "sum")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as("c")})));
            this.assertEqual(new StringBuilder(21).append(sqlWithoutGroupBy).append(" group by cube (a, b)").toString(), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{Cube$.MODULE$.apply((Seq)new .colon.colon((Object)((Seq)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)((Seq)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)))}), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "sum")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as("c")})));
            this.assertEqual(new StringBuilder(12).append(sql).append(" with rollup").toString(), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{Rollup$.MODULE$.apply((Seq)new .colon.colon((Object)((Seq)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)((Seq)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)))}), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "sum")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as("c")})));
            this.assertEqual(new StringBuilder(22).append(sqlWithoutGroupBy).append(" group by rollup(a, b)").toString(), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{Rollup$.MODULE$.apply((Seq)new .colon.colon((Object)((Seq)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)((Seq)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)))}), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "sum")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as("c")})));
            this.assertEqual(new StringBuilder(23).append(sqlWithoutGroupBy).append(" group by rollup (a, b)").toString(), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{Rollup$.MODULE$.apply((Seq)new .colon.colon((Object)((Seq)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)((Seq)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)))}), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "sum")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as("c")})));
            this.assertEqual(new StringBuilder(31).append(sql).append(" grouping sets((a, b), (a), ())").toString(), (LogicalPlan)new Aggregate((Seq)new .colon.colon((Object)GroupingSets$.MODULE$.apply((Seq)new .colon.colon((Object)((Seq)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (List)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), (List)Nil$.MODULE$))), (List)new .colon.colon((Object)((Seq)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)((Seq)Nil$.MODULE$), (List)Nil$.MODULE$))), (Seq)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (List)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), (List)Nil$.MODULE$))), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (List)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "sum")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as("c"), (List)Nil$.MODULE$))), package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))));
            this.assertEqual(new StringBuilder(40).append(sqlWithoutGroupBy).append(" group by grouping sets((a, b), (a), ())").toString(), (LogicalPlan)new Aggregate((Seq)new .colon.colon((Object)GroupingSets$.MODULE$.apply((Seq)new .colon.colon((Object)((Seq)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (List)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), (List)Nil$.MODULE$))), (List)new .colon.colon((Object)((Seq)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)((Seq)Nil$.MODULE$), (List)Nil$.MODULE$)))), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (List)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "sum")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as("c"), (List)Nil$.MODULE$))), package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))));
            String $org_scalatest_assert_macro_left = m = ((ParseException)this.intercept((Function0 & Serializable & scala.Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan("SELECT a, b, count(distinct a, distinct b) as c FROM d GROUP BY a, b"), ClassTag$.MODULE$.apply(ParseException.class), new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 404))).getMessage();
            String $org_scalatest_assert_macro_right = "Syntax error at or near 'b': extra input 'b'";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 407));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 372));
        this.test("limit", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String sql = "select * from t";
            LogicalPlan plan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            this.assertEqual(new StringBuilder(9).append(sql).append(" limit 10").toString(), package.plans$.MODULE$.DslLogicalPlan(plan).limit((Expression)package.expressions$.MODULE$.intToLiteral(10)));
            this.assertEqual(new StringBuilder(25).append(sql).append(" limit cast(9 / 4 as int)").toString(), package.plans$.MODULE$.DslLogicalPlan(plan).limit((Expression)new Cast(package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)9))).$div((Expression)package.expressions$.MODULE$.intToLiteral(4)), (DataType)IntegerType$.MODULE$, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4())));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 411));
        this.test("window spec", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String sql = "select * from t";
            LogicalPlan plan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            WindowSpecDefinition spec = new WindowSpecDefinition((Seq)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (List)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), (List)Nil$.MODULE$)), (Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).asc(), (List)Nil$.MODULE$), (WindowFrame)new SpecifiedWindowFrame((FrameType)RowFrame$.MODULE$, package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))).unary_$minus(), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))));
            Map ws1 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"w1"), (Object)spec), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"w2"), (Object)spec), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"w3"), (Object)spec)}));
            this.assertEqual(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(149).append(sql).append("\n         |window w1 as (partition by a, b order by c rows between 1 preceding and 1 following),\n         |       w2 as w1,\n         |       w3 as w1").toString())).stripMargin(), (LogicalPlan)new WithWindowDefinition(ws1, plan));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 418));
        this.test("lateral view", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            UnresolvedGenerator explode = new UnresolvedGenerator(FunctionIdentifier$.MODULE$.apply("explode"), (Seq)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "x")), (List)Nil$.MODULE$));
            UnresolvedGenerator jsonTuple = new UnresolvedGenerator(FunctionIdentifier$.MODULE$.apply("json_tuple"), (Seq)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "x")), (List)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "y")), (List)Nil$.MODULE$)));
            package.plans$.DslLogicalPlan qual$1 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"})));
            UnresolvedGenerator x$1 = explode;
            Some x$2 = new Some((Object)"expl");
            Seq x$3 = (Seq)new .colon.colon((Object)"x", (List)Nil$.MODULE$);
            Seq x$4 = qual$1.generate$default$2();
            boolean x$5 = qual$1.generate$default$3();
            this.assertEqual("select * from t lateral view explode(x) expl as x", package.plans$.MODULE$.DslLogicalPlan(qual$1.generate((Generator)x$1, x$4, x$5, (Option)x$2, x$3)).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            package.plans$.DslLogicalPlan qual$2 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"})));
            UnresolvedGenerator x$6 = explode;
            Some x$7 = new Some((Object)"expl");
            Seq x$8 = qual$2.generate$default$2();
            boolean x$9 = qual$2.generate$default$3();
            Seq x$10 = qual$2.generate$default$5();
            package.plans$.DslLogicalPlan qual$3 = package.plans$.MODULE$.DslLogicalPlan(qual$2.generate((Generator)x$6, x$8, x$9, (Option)x$7, x$10));
            UnresolvedGenerator x$11 = jsonTuple;
            boolean x$12 = true;
            Some x$13 = new Some((Object)"jtup");
            Seq x$14 = (Seq)new .colon.colon((Object)"q", (List)new .colon.colon((Object)"z", (List)Nil$.MODULE$));
            Seq x$15 = qual$3.generate$default$2();
            this.assertEqual(new StringOps(Predef$.MODULE$.augmentString("select *\n        |from t\n        |lateral view explode(x) expl\n        |lateral view outer json_tuple(x, y) jtup q, z")).stripMargin(), package.plans$.MODULE$.DslLogicalPlan(qual$3.generate((Generator)x$11, x$15, x$12, (Option)x$13, x$14)).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            package.plans$.DslLogicalPlan qual$4 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1"})));
            UnresolvedGenerator x$16 = explode;
            Some x$17 = new Some((Object)"expl");
            Seq x$18 = (Seq)new .colon.colon((Object)"x", (List)Nil$.MODULE$);
            Seq x$19 = qual$4.generate$default$2();
            boolean x$20 = qual$4.generate$default$3();
            LogicalPlan from = qual$4.generate((Generator)x$16, x$19, x$20, (Option)x$17, x$18);
            package.plans$.DslLogicalPlan qual$5 = package.plans$.MODULE$.DslLogicalPlan(from);
            UnresolvedGenerator x$21 = jsonTuple;
            Some x$22 = new Some((Object)"jtup");
            Seq x$23 = (Seq)new .colon.colon((Object)"q", (List)new .colon.colon((Object)"z", (List)Nil$.MODULE$));
            Seq x$24 = qual$5.generate$default$2();
            boolean x$25 = qual$5.generate$default$3();
            this.assertEqual(new StringOps(Predef$.MODULE$.augmentString("from t1\n        |lateral view explode(x) expl as x\n        |insert into t2\n        |select *\n        |lateral view json_tuple(x, y) jtup q, z\n        |insert into t3\n        |select *\n        |where s < 10\n      ")).stripMargin(), (LogicalPlan)Union$.MODULE$.apply(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(qual$5.generate((Generator)x$21, x$24, x$25, (Option)x$22, x$23)).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))).insertInto("t2"), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(from).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "s")).$less((Expression)package.expressions$.MODULE$.intToLiteral(10)))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))).insertInto("t3")));
            package.plans$.DslLogicalPlan qual$6 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"})));
            UnresolvedGenerator x$26 = new UnresolvedGenerator(FunctionIdentifier$.MODULE$.apply("posexplode"), (Seq)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "x")), (List)Nil$.MODULE$));
            Some x$27 = new Some((Object)"posexpl");
            Seq x$28 = (Seq)new .colon.colon((Object)"x", (List)new .colon.colon((Object)"y", (List)Nil$.MODULE$));
            Seq x$29 = qual$6.generate$default$2();
            boolean x$30 = qual$6.generate$default$3();
            LogicalPlan expected = package.plans$.MODULE$.DslLogicalPlan(qual$6.generate((Generator)x$26, x$29, x$30, (Option)x$27, x$28)).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            this.assertEqual("select * from t lateral view posexplode(x) posexpl as x, y", expected);
            this.intercept(new StringOps(Predef$.MODULE$.augmentString("select *\n        |from t\n        |lateral view explode(x) expl\n        |pivot (\n        |  sum(x)\n        |  FOR y IN ('a', 'b')\n        |)")).stripMargin(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LATERAL cannot be used together with PIVOT in FROM clause"}));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 435));
        this.test("joins", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Function2 & Serializable & scala.Serializable testUnconditionalJoin = (Function2 & Serializable & scala.Serializable)(sql, jt) -> {
                this.assertEqual(new StringBuilder(24).append("select * from t as tt ").append(sql).append(" u").toString(), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).as("tt")).join(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"u"})), jt, (Option)None$.MODULE$)).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
                return BoxedUnit.UNIT;
            };
            Function2 & Serializable & scala.Serializable testConditionalJoin = (Function2 & Serializable & scala.Serializable)(sql, jt) -> {
                this.assertEqual(new StringBuilder(33).append("select * from t ").append(sql).append(" u as uu on a = b").toString(), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).join(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"u"}))).as("uu"), jt, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")))))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
                return BoxedUnit.UNIT;
            };
            Function2 & Serializable & scala.Serializable testNaturalJoin = (Function2 & Serializable & scala.Serializable)(sql, jt) -> {
                this.assertEqual(new StringBuilder(35).append("select * from t tt natural ").append(sql).append(" u as uu").toString(), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).as("tt")).join(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"u"}))).as("uu"), (JoinType)new NaturalJoin(jt), (Option)None$.MODULE$)).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
                return BoxedUnit.UNIT;
            };
            Function2 & Serializable & scala.Serializable testUsingJoin = (Function2 & Serializable & scala.Serializable)(sql, jt) -> {
                this.assertEqual(new StringBuilder(30).append("select * from t ").append(sql).append(" u using(a, b)").toString(), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).join(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"u"})), (JoinType)new UsingJoin(jt, (Seq)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)Nil$.MODULE$))), (Option)None$.MODULE$)).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
                return BoxedUnit.UNIT;
            };
            Function2 & Serializable & scala.Serializable testLateralJoin = (Function2 & Serializable & scala.Serializable)(sql, jt) -> {
                this.assertEqual(new StringBuilder(45).append("select * from t ").append(sql).append(" lateral (select * from u) uu").toString(), package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new LateralJoin(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"})), new LateralSubquery(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"u"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))).as("uu"), LateralSubquery$.MODULE$.apply$default$2(), LateralSubquery$.MODULE$.apply$default$3(), LateralSubquery$.MODULE$.apply$default$4()), jt, (Option)None$.MODULE$)).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
                return BoxedUnit.UNIT;
            };
            Seq testAllExceptLateral = (Seq)new .colon.colon((Object)testUnconditionalJoin, (List)new .colon.colon((Object)testConditionalJoin, (List)new .colon.colon((Object)testNaturalJoin, (List)new .colon.colon((Object)testUsingJoin, (List)Nil$.MODULE$))));
            Seq testAll = (Seq)testAllExceptLateral.$colon$plus((Object)testLateralJoin, Seq$.MODULE$.canBuildFrom());
            Seq testExistence = (Seq)new .colon.colon((Object)testUnconditionalJoin, (List)new .colon.colon((Object)testConditionalJoin, (List)new .colon.colon((Object)testUsingJoin, (List)Nil$.MODULE$)));
            PlanParserSuite.test$1("cross join", (JoinType)Cross$.MODULE$, (Seq)new .colon.colon((Object)testUnconditionalJoin, (List)new .colon.colon((Object)testLateralJoin, (List)Nil$.MODULE$)));
            PlanParserSuite.test$1(",", (JoinType)Inner$.MODULE$, (Seq)new .colon.colon((Object)testUnconditionalJoin, (List)new .colon.colon((Object)testLateralJoin, (List)Nil$.MODULE$)));
            PlanParserSuite.test$1("join", (JoinType)Inner$.MODULE$, testAll);
            PlanParserSuite.test$1("inner join", (JoinType)Inner$.MODULE$, testAll);
            PlanParserSuite.test$1("left join", (JoinType)LeftOuter$.MODULE$, testAll);
            PlanParserSuite.test$1("left outer join", (JoinType)LeftOuter$.MODULE$, testAll);
            PlanParserSuite.test$1("right join", (JoinType)RightOuter$.MODULE$, testAllExceptLateral);
            PlanParserSuite.test$1("right outer join", (JoinType)RightOuter$.MODULE$, testAllExceptLateral);
            PlanParserSuite.test$1("full join", (JoinType)FullOuter$.MODULE$, testAllExceptLateral);
            PlanParserSuite.test$1("full outer join", (JoinType)FullOuter$.MODULE$, testAllExceptLateral);
            PlanParserSuite.test$1("left semi join", (JoinType)LeftSemi$.MODULE$, testExistence);
            PlanParserSuite.test$1("semi join", (JoinType)LeftSemi$.MODULE$, testExistence);
            PlanParserSuite.test$1("left anti join", (JoinType)LeftAnti$.MODULE$, testExistence);
            PlanParserSuite.test$1("anti join", (JoinType)LeftAnti$.MODULE$, testExistence);
            this.intercept("select * from a natural cross join b", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            this.intercept("select * from a natural join b on a.id = b.id", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            package.plans$.DslLogicalPlan qual$7 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})));
            LogicalPlan x$31 = package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}));
            JoinType x$32 = qual$7.join$default$2();
            Option x$33 = qual$7.join$default$3();
            package.plans$.DslLogicalPlan qual$8 = package.plans$.MODULE$.DslLogicalPlan(qual$7.join(x$31, x$32, x$33));
            LogicalPlan x$34 = package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"}));
            JoinType x$35 = qual$8.join$default$2();
            Option x$36 = qual$8.join$default$3();
            package.plans$.DslLogicalPlan qual$9 = package.plans$.MODULE$.DslLogicalPlan(qual$8.join(x$34, x$35, x$36));
            LogicalPlan x$37 = package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"d"}));
            RightOuter$ x$38 = RightOuter$.MODULE$;
            Option x$39 = qual$9.join$default$3();
            this.assertEqual("select * from a join b join c right join d", package.plans$.MODULE$.DslLogicalPlan(qual$9.join(x$37, (JoinType)x$38, x$39)).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            package.plans$.DslLogicalPlan qual$10 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1"})));
            LogicalPlan x$40 = package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t2"}));
            Cross$ x$41 = Cross$.MODULE$;
            Option x$42 = qual$10.join$default$3();
            this.assertEqual("select * from t1 cross join t2 join t3 on t3.id = t1.id join t4 on t4.id = t1.id", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(qual$10.join(x$40, (JoinType)x$41, x$42)).join(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t3"})), (JoinType)Inner$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "t3.id")).$eq$eq$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "t1.id")))))).join(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t4"})), (JoinType)Inner$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "t4.id")).$eq$eq$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "t1.id")))))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            this.intercept("select * from t1 inner join t2 inner join t3 on col3 = col2 on col3 = col1", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            this.assertEqual("select * from t1 inner join (t2 inner join t3 on col3 = col2) on col3 = col1", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}))).join(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t2"}))).join(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t3"})), (JoinType)Inner$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "col3")).$eq$eq$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "col2"))))), (JoinType)Inner$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "col3")).$eq$eq$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "col1")))))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            this.assertEqual("select * from t1 inner join (t2 inner join t3) on col3 = col2", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}))).join(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t2"}))).join(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t3"})), (JoinType)Inner$.MODULE$, (Option)None$.MODULE$), (JoinType)Inner$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "col3")).$eq$eq$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "col2")))))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            this.assertEqual("select * from t1 inner join (t2 inner join t3 on col3 = col2)", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}))).join(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t2"}))).join(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t3"})), (JoinType)Inner$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "col3")).$eq$eq$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "col2"))))), (JoinType)Inner$.MODULE$, (Option)None$.MODULE$)).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            package.plans$.DslLogicalPlan qual$11 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1"})));
            LogicalPlan x$43 = package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t3"}));
            JoinType x$44 = qual$11.join$default$2();
            Option x$45 = qual$11.join$default$3();
            this.assertEqual("select * from t1, t3 join t2 on t1.col1 = t2.col2", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(qual$11.join(x$43, x$44, x$45)).join(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t2"})), (JoinType)Inner$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "t1.col1")).$eq$eq$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "t2.col2")))))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            this.assertEqual("select * from t join lateral (select * from u) uu on true", package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new LateralJoin(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"})), new LateralSubquery(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"u"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))).as("uu"), LateralSubquery$.MODULE$.apply$default$2(), LateralSubquery$.MODULE$.apply$default$3(), LateralSubquery$.MODULE$.apply$default$4()), (JoinType)Inner$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.booleanToLiteral(true)))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            this.assertEqual("select * from a, lateral (select * from b) bb, lateral (select * from c) cc", package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new LateralJoin((LogicalPlan)new LateralJoin(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), new LateralSubquery(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))).as("bb"), LateralSubquery$.MODULE$.apply$default$2(), LateralSubquery$.MODULE$.apply$default$3(), LateralSubquery$.MODULE$.apply$default$4()), (JoinType)Inner$.MODULE$, (Option)None$.MODULE$), new LateralSubquery(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))).as("cc"), LateralSubquery$.MODULE$.apply$default$2(), LateralSubquery$.MODULE$.apply$default$3(), LateralSubquery$.MODULE$.apply$default$4()), (JoinType)Inner$.MODULE$, (Option)None$.MODULE$)).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 497));
        this.test("sampled relations", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String sql = "select * from t";
            this.assertEqual(new StringBuilder(22).append(sql).append(" tablesample(100 rows)").toString(), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).limit((Expression)package.expressions$.MODULE$.intToLiteral(100))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            this.assertEqual(new StringBuilder(29).append(sql).append(" tablesample(43 percent) as x").toString(), package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Sample(0.0, 0.43, false, 10L, package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).as("x"))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            this.assertEqual(new StringBuilder(37).append(sql).append(" tablesample(bucket 4 out of 10) as x").toString(), package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Sample(0.0, 0.4, false, 10L, package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).as("x"))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            this.intercept(new StringBuilder(42).append(sql).append(" tablesample(bucket 4 out of 10 on x) as x").toString(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TABLESAMPLE(BUCKET x OUT OF y ON colname) is not supported"}));
            this.intercept(new StringBuilder(38).append(sql).append(" tablesample(bucket 11 out of 10) as x").toString(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(47).append("Sampling fraction (").append(1.1).append(") must be on interval [0, 1]").toString()}));
            this.intercept("SELECT * FROM parquet_t0 TABLESAMPLE(300M) s", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TABLESAMPLE(byteLengthLiteral) is not supported"}));
            this.intercept("SELECT * FROM parquet_t0 TABLESAMPLE(BUCKET 3 OUT OF 32 ON rand()) s", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TABLESAMPLE(BUCKET x OUT OF y ON function) is not supported"}));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 619));
        this.test("sub-query", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan plan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t0"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "id"))}));
            this.assertEqual("select id from (t0)", plan);
            this.assertEqual("select id from ((((((t0))))))", plan);
            this.assertEqual("(select * from t1) union distinct (select * from t2)", (LogicalPlan)new Distinct(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))).union(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t2"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})))));
            this.assertEqual("select * from ((select * from t1) union (select * from t2)) t", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Distinct(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))).union(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t2"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))))).as("t")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            this.assertEqual(new StringOps(Predef$.MODULE$.augmentString("select  id\n        |from (((select id from t0)\n        |       union all\n        |       (select  id from t0))\n        |      union all\n        |      (select id from t0)) as u_1\n      ")).stripMargin(), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(plan).union(plan)).union(plan)).as("u_1")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "id"))})));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 637));
        this.test("scalar sub-query", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("select (select max(b) from s) ss from t", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslExpression((Expression)new ScalarSubquery(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"s"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "max")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}))})), ScalarSubquery$.MODULE$.apply$default$2(), ScalarSubquery$.MODULE$.apply$default$3(), ScalarSubquery$.MODULE$.apply$default$4())).as("ss")})));
            this.assertEqual("select * from t where a = (select b from s)", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq((Expression)new ScalarSubquery(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"s"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))})), ScalarSubquery$.MODULE$.apply$default$2(), ScalarSubquery$.MODULE$.apply$default$3(), ScalarSubquery$.MODULE$.apply$default$4())))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            this.assertEqual("select g from t group by g having a > (select b from s)", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).having((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "g"))}), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "g"))}), (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater((Expression)new ScalarSubquery(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"s"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))})), ScalarSubquery$.MODULE$.apply$default$2(), ScalarSubquery$.MODULE$.apply$default$3(), ScalarSubquery$.MODULE$.apply$default$4()))));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 659));
        this.test("table reference", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("table t", package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"})));
            this.assertEqual("table d.t", package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"d", "t"})));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 672));
        this.test("table valued function", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Literal literal = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2));
            this.assertEqual("select * from range(2)", package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)UnresolvedTableValuedFunction$.MODULE$.apply("range", (Seq)Nil$.MODULE$.$colon$colon((Object)literal), (Seq)Nil$.MODULE$)).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            this.intercept("select * from default.range(2)", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"table valued function cannot specify database name"}));
            this.intercept("select * from spark_catalog.default.range(2)", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"table valued function cannot specify database name"}));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 677));
        this.test("SPARK-20311 range(N) as alias", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Literal literal = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10));
            this.assertEqual("SELECT * FROM range(10) AS t", package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)SubqueryAlias$.MODULE$.apply("t", (LogicalPlan)UnresolvedTableValuedFunction$.MODULE$.apply("range", (Seq)Nil$.MODULE$.$colon$colon((Object)literal), (Seq)Nil$.MODULE$))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            Literal literal2 = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)7));
            String string = "a";
            this.assertEqual("SELECT * FROM range(7) AS t(a)", package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)SubqueryAlias$.MODULE$.apply("t", (LogicalPlan)UnresolvedTableValuedFunction$.MODULE$.apply("range", (Seq)Nil$.MODULE$.$colon$colon((Object)literal2), (Seq)Nil$.MODULE$.$colon$colon((Object)string)))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 689));
        this.test("SPARK-20841 Support table column aliases in FROM clause", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.assertEqual("SELECT * FROM testData AS t(col1, col2)", package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)SubqueryAlias$.MODULE$.apply("t", (LogicalPlan)new UnresolvedSubqueryColumnAliases((Seq)new .colon.colon((Object)"col1", (List)new .colon.colon((Object)"col2", (List)Nil$.MODULE$)), (LogicalPlan)UnresolvedRelation$.MODULE$.apply(TableIdentifier$.MODULE$.apply("testData"))))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))), new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 700));
        this.test("SPARK-20962 Support subquery column aliases in FROM clause", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.assertEqual("SELECT * FROM (SELECT a AS x, b AS y FROM t) t(col1, col2)", package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)SubqueryAlias$.MODULE$.apply("t", (LogicalPlan)new UnresolvedSubqueryColumnAliases((Seq)new .colon.colon((Object)"col1", (List)new .colon.colon((Object)"col2", (List)Nil$.MODULE$)), package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)UnresolvedRelation$.MODULE$.apply(TableIdentifier$.MODULE$.apply("t"))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).as("x"), (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).as("y")}))))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))), new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 712));
        this.test("SPARK-20963 Support aliases for join relations in FROM clause", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan src1 = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)UnresolvedRelation$.MODULE$.apply(TableIdentifier$.MODULE$.apply("src1"))).as("s1");
            LogicalPlan src2 = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)UnresolvedRelation$.MODULE$.apply(TableIdentifier$.MODULE$.apply("src2"))).as("s2");
            this.assertEqual("SELECT * FROM (src1 s1 INNER JOIN src2 s2 ON s1.id = s2.id) dst(a, b, c, d)", package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)SubqueryAlias$.MODULE$.apply("dst", (LogicalPlan)new UnresolvedSubqueryColumnAliases((Seq)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)new .colon.colon((Object)"c", (List)new .colon.colon((Object)"d", (List)Nil$.MODULE$)))), package.plans$.MODULE$.DslLogicalPlan(src1).join(src2, (JoinType)Inner$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "s1.id")).$eq$eq$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "s2.id")))))))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 724));
        this.test("SPARK-34335 Support referencing subquery with column aliases by table alias", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.assertEqual("SELECT t.col1, t.col2 FROM (SELECT a AS x, b AS y FROM t) t(col1, col2)", package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)SubqueryAlias$.MODULE$.apply("t", (LogicalPlan)new UnresolvedSubqueryColumnAliases((Seq)new .colon.colon((Object)"col1", (List)new .colon.colon((Object)"col2", (List)Nil$.MODULE$)), package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)UnresolvedRelation$.MODULE$.apply(TableIdentifier$.MODULE$.apply("t"))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).as("x"), (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).as("y")}))))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t.col1"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t.col2"}))).$((Seq)Nil$.MODULE$)}))), new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 738));
        this.test("inline table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("values 1, 2, 3, 4", (LogicalPlan)new UnresolvedInlineTable((Seq)new .colon.colon((Object)"col1", (List)Nil$.MODULE$), (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4}))).map((Function1 & Serializable & scala.Serializable)x -> PlanParserSuite.$anonfun$new$54(BoxesRunTime.unboxToInt((Object)x)), Seq$.MODULE$.canBuildFrom())));
            Seq seq = (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)"a"), (List)Nil$.MODULE$));
            Seq seq2 = (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2)), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)"b"), (List)Nil$.MODULE$));
            this.assertEqual("values (1, 'a'), (2, 'b') as tbl(a, b)", package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new UnresolvedInlineTable((Seq)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)Nil$.MODULE$)), (Seq)Nil$.MODULE$.$colon$colon((Object)seq2).$colon$colon((Object)seq))).as("tbl"));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 750));
        this.test("simple select query with !> and !<", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("select a, b from db.c where x !< 1", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"db", "c"}))).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "x")).$greater$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))})));
            this.assertEqual("select a, b from db.c where x !> 1", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"db", "c"}))).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "x")).$less$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))})));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 761));
        this.test("select hint syntax", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.intercept("SELECT /*+ HINT() */ * FROM t", (Option<String>)new Some((Object)"PARSE_SYNTAX_ERROR"), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Syntax error at or near"}));
            this.intercept("SELECT /*+ INDEX(a b c) */ * from default.t", (Option<String>)new Some((Object)"PARSE_SYNTAX_ERROR"), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Syntax error at or near 'b'"}));
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ HINT */ * FROM t"), (LogicalPlan)new UnresolvedHint("HINT", (Seq)Nil$.MODULE$, package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))), this.comparePlans$default$3());
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ BROADCASTJOIN(u) */ * FROM t"), (LogicalPlan)new UnresolvedHint("BROADCASTJOIN", (Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"u"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))), this.comparePlans$default$3());
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ MAPJOIN(u) */ * FROM t"), (LogicalPlan)new UnresolvedHint("MAPJOIN", (Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"u"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))), this.comparePlans$default$3());
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ STREAMTABLE(a,b,c) */ * FROM t"), (LogicalPlan)new UnresolvedHint("STREAMTABLE", (Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$))), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))), this.comparePlans$default$3());
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ INDEX(t, emp_job_ix) */ * FROM t"), (LogicalPlan)new UnresolvedHint("INDEX", (Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"emp_job_ix"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$)), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))), this.comparePlans$default$3());
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ MAPJOIN(`default.t`) */ * from `default.t`"), (LogicalPlan)new UnresolvedHint("MAPJOIN", (Seq)new .colon.colon((Object)UnresolvedAttribute$.MODULE$.quoted("default.t"), (List)Nil$.MODULE$), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default.t"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))), this.comparePlans$default$3());
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ MAPJOIN(t) */ a from t where true group by a order by a"), package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new UnresolvedHint("MAPJOIN", (Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).where((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true)))).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))}), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))})))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc()})), this.comparePlans$default$3());
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ COALESCE(10) */ * FROM t"), (LogicalPlan)new UnresolvedHint("COALESCE", (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10)), (List)Nil$.MODULE$), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))), this.comparePlans$default$3());
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ REPARTITION(100) */ * FROM t"), (LogicalPlan)new UnresolvedHint("REPARTITION", (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)100)), (List)Nil$.MODULE$), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))), this.comparePlans$default$3());
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("INSERT INTO s SELECT /*+ REPARTITION(100), COALESCE(500), COALESCE(10) */ * FROM t"), (LogicalPlan)new InsertIntoStatement(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"s"})), Predef$.MODULE$.Map().empty(), (Seq)Nil$.MODULE$, (LogicalPlan)new UnresolvedHint("REPARTITION", (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)100)), (List)Nil$.MODULE$), (LogicalPlan)new UnresolvedHint("COALESCE", (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)500)), (List)Nil$.MODULE$), (LogicalPlan)new UnresolvedHint("COALESCE", (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10)), (List)Nil$.MODULE$), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))))), false, false), this.comparePlans$default$3());
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ BROADCASTJOIN(u), REPARTITION(100) */ * FROM t"), (LogicalPlan)new UnresolvedHint("BROADCASTJOIN", (Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"u"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$), (LogicalPlan)new UnresolvedHint("REPARTITION", (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)100)), (List)Nil$.MODULE$), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})))), this.comparePlans$default$3());
            this.intercept("SELECT /*+ COALESCE(30 + 50) */ * FROM t", (Option<String>)new Some((Object)"PARSE_SYNTAX_ERROR"), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Syntax error at or near"}));
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ REPARTITION(c) */ * FROM t"), (LogicalPlan)new UnresolvedHint("REPARTITION", (Seq)new .colon.colon((Object)UnresolvedAttribute$.MODULE$.apply("c"), (List)Nil$.MODULE$), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))), this.comparePlans$default$3());
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ REPARTITION(100, c) */ * FROM t"), (LogicalPlan)new UnresolvedHint("REPARTITION", (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)100)), (List)new .colon.colon((Object)UnresolvedAttribute$.MODULE$.apply("c"), (List)Nil$.MODULE$)), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))), this.comparePlans$default$3());
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ REPARTITION(100, c), COALESCE(50) */ * FROM t"), (LogicalPlan)new UnresolvedHint("REPARTITION", (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)100)), (List)new .colon.colon((Object)UnresolvedAttribute$.MODULE$.apply("c"), (List)Nil$.MODULE$)), (LogicalPlan)new UnresolvedHint("COALESCE", (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)50)), (List)Nil$.MODULE$), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})))), this.comparePlans$default$3());
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ REPARTITION(100, c), BROADCASTJOIN(u), COALESCE(50) */ * FROM t"), (LogicalPlan)new UnresolvedHint("REPARTITION", (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)100)), (List)new .colon.colon((Object)UnresolvedAttribute$.MODULE$.apply("c"), (List)Nil$.MODULE$)), (LogicalPlan)new UnresolvedHint("BROADCASTJOIN", (Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"u"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$), (LogicalPlan)new UnresolvedHint("COALESCE", (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)50)), (List)Nil$.MODULE$), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))))), this.comparePlans$default$3());
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan(new StringOps(Predef$.MODULE$.augmentString("\n          |SELECT\n          |/*+ REPARTITION(100, c), BROADCASTJOIN(u), COALESCE(50), REPARTITION(300, c) */\n          |* FROM t\n        ")).stripMargin()), (LogicalPlan)new UnresolvedHint("REPARTITION", (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)100)), (List)new .colon.colon((Object)UnresolvedAttribute$.MODULE$.apply("c"), (List)Nil$.MODULE$)), (LogicalPlan)new UnresolvedHint("BROADCASTJOIN", (Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"u"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$), (LogicalPlan)new UnresolvedHint("COALESCE", (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)50)), (List)Nil$.MODULE$), (LogicalPlan)new UnresolvedHint("REPARTITION", (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)300)), (List)new .colon.colon((Object)UnresolvedAttribute$.MODULE$.apply("c"), (List)Nil$.MODULE$)), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})))))), this.comparePlans$default$3());
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ REPARTITION_BY_RANGE(c) */ * FROM t"), (LogicalPlan)new UnresolvedHint("REPARTITION_BY_RANGE", (Seq)new .colon.colon((Object)UnresolvedAttribute$.MODULE$.apply("c"), (List)Nil$.MODULE$), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))), this.comparePlans$default$3());
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ REPARTITION_BY_RANGE(100, c) */ * FROM t"), (LogicalPlan)new UnresolvedHint("REPARTITION_BY_RANGE", (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)100)), (List)new .colon.colon((Object)UnresolvedAttribute$.MODULE$.apply("c"), (List)Nil$.MODULE$)), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))), this.comparePlans$default$3());
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 770));
        this.test("SPARK-20854: select hint syntax with expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Literal literal = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1));
            Literal literal2 = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2));
            Literal literal3 = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3));
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ HINT1(a, array(1, 2, 3)) */ * from t"), (LogicalPlan)new UnresolvedHint("HINT1", (Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)UnresolvedFunction$.MODULE$.apply("array", (Seq)Nil$.MODULE$.$colon$colon((Object)literal3).$colon$colon((Object)literal2).$colon$colon((Object)literal), false), (List)Nil$.MODULE$)), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))), this.comparePlans$default$3());
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ HINT1(a, 5, 'a', b) */ * from t"), (LogicalPlan)new UnresolvedHint("HINT1", (Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)5)), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)"a"), (List)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$)))), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))), this.comparePlans$default$3());
            UnresolvedAttribute unresolvedAttribute = package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$);
            UnresolvedAttribute unresolvedAttribute2 = package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$);
            Literal literal4 = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1));
            Literal literal5 = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2));
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ HINT1('a', (b, c), (1, 2)) */ * from t"), (LogicalPlan)new UnresolvedHint("HINT1", (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)"a"), (List)new .colon.colon((Object)CreateStruct$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)unresolvedAttribute2).$colon$colon((Object)unresolvedAttribute)), (List)new .colon.colon((Object)CreateStruct$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)literal5).$colon$colon((Object)literal4)), (List)Nil$.MODULE$))), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))), this.comparePlans$default$3());
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 884));
        this.test("SPARK-20854: multiple hints", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ HINT1(a, 1) hint2(b, 2) */ * from t"), (LogicalPlan)new UnresolvedHint("HINT1", (Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), (List)Nil$.MODULE$)), (LogicalPlan)new UnresolvedHint("hint2", (Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2)), (List)Nil$.MODULE$)), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})))), this.comparePlans$default$3());
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ HINT1(a, 1),hint2(b, 2) */ * from t"), (LogicalPlan)new UnresolvedHint("HINT1", (Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), (List)Nil$.MODULE$)), (LogicalPlan)new UnresolvedHint("hint2", (Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2)), (List)Nil$.MODULE$)), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})))), this.comparePlans$default$3());
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ HINT1(a, 1) */ /*+ hint2(b, 2) */ * from t"), (LogicalPlan)new UnresolvedHint("HINT1", (Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), (List)Nil$.MODULE$)), (LogicalPlan)new UnresolvedHint("hint2", (Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2)), (List)Nil$.MODULE$)), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})))), this.comparePlans$default$3());
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ HINT1(a, 1), hint2(b, 2) */ /*+ hint3(c, 3) */ * from t"), (LogicalPlan)new UnresolvedHint("HINT1", (Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), (List)Nil$.MODULE$)), (LogicalPlan)new UnresolvedHint("hint2", (Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2)), (List)Nil$.MODULE$)), (LogicalPlan)new UnresolvedHint("hint3", (Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3)), (List)Nil$.MODULE$)), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))))), this.comparePlans$default$3());
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 911));
        this.test("TRIM function", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.intercept("select ltrim(both 'S' from 'SS abc S'", (Option<String>)new Some((Object)"PARSE_SYNTAX_ERROR"), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Syntax error at or near 'from'"}));
            this.intercept("select rtrim(trailing 'S' from 'SS abc S'", (Option<String>)new Some((Object)"PARSE_SYNTAX_ERROR"), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Syntax error at or near 'from'"}));
            this.assertTrimPlans$1("SELECT TRIM(BOTH '@$%&( )abc' FROM '@ $ % & ()abc ' )", (Expression)new StringTrim((Expression)Literal$.MODULE$.apply((Object)"@ $ % & ()abc "), (Option)new Some((Object)Literal$.MODULE$.apply((Object)"@$%&( )abc"))));
            this.assertTrimPlans$1("SELECT TRIM(LEADING 'c []' FROM '[ ccccbcc ')", (Expression)new StringTrimLeft((Expression)Literal$.MODULE$.apply((Object)"[ ccccbcc "), (Option)new Some((Object)Literal$.MODULE$.apply((Object)"c []"))));
            this.assertTrimPlans$1("SELECT TRIM(TRAILING 'c&^,.' FROM 'bc...,,,&&&ccc')", (Expression)new StringTrimRight((Expression)Literal$.MODULE$.apply((Object)"bc...,,,&&&ccc"), (Option)new Some((Object)Literal$.MODULE$.apply((Object)"c&^,."))));
            this.assertTrimPlans$1("SELECT TRIM(BOTH FROM '  bunch o blanks  ')", (Expression)new StringTrim((Expression)Literal$.MODULE$.apply((Object)"  bunch o blanks  "), (Option)None$.MODULE$));
            this.assertTrimPlans$1("SELECT TRIM(LEADING FROM '  bunch o blanks  ')", (Expression)new StringTrimLeft((Expression)Literal$.MODULE$.apply((Object)"  bunch o blanks  "), (Option)None$.MODULE$));
            this.assertTrimPlans$1("SELECT TRIM(TRAILING FROM '  bunch o blanks  ')", (Expression)new StringTrimRight((Expression)Literal$.MODULE$.apply((Object)"  bunch o blanks  "), (Option)None$.MODULE$));
            this.assertTrimPlans$1("SELECT TRIM('xyz' FROM 'yxTomxx')", (Expression)new StringTrim((Expression)Literal$.MODULE$.apply((Object)"yxTomxx"), (Option)new Some((Object)Literal$.MODULE$.apply((Object)"xyz"))));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 951));
        this.test("OVERLAY function", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertOverlayPlans$1("SELECT OVERLAY('Spark SQL' PLACING '_' FROM 6)", (Expression)new Overlay((Expression)Literal$.MODULE$.apply((Object)"Spark SQL"), (Expression)Literal$.MODULE$.apply((Object)"_"), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)6))));
            this.assertOverlayPlans$1("SELECT OVERLAY('Spark SQL' PLACING 'CORE' FROM 7)", (Expression)new Overlay((Expression)Literal$.MODULE$.apply((Object)"Spark SQL"), (Expression)Literal$.MODULE$.apply((Object)"CORE"), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)7))));
            this.assertOverlayPlans$1("SELECT OVERLAY('Spark SQL' PLACING 'ANSI ' FROM 7 FOR 0)", (Expression)new Overlay((Expression)Literal$.MODULE$.apply((Object)"Spark SQL"), (Expression)Literal$.MODULE$.apply((Object)"ANSI "), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)7)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0))));
            this.assertOverlayPlans$1("SELECT OVERLAY('Spark SQL' PLACING 'tructured' FROM 2 FOR 4)", (Expression)new Overlay((Expression)Literal$.MODULE$.apply((Object)"Spark SQL"), (Expression)Literal$.MODULE$.apply((Object)"tructured"), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)4))));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 996));
        this.test("precedence of set operations", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan a = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            LogicalPlan b = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            LogicalPlan c = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            LogicalPlan d = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            String query1 = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM a\n        |UNION\n        |SELECT * FROM b\n        |EXCEPT\n        |SELECT * FROM c\n        |INTERSECT\n        |SELECT * FROM d\n      ")).stripMargin();
            String query2 = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM a\n        |UNION\n        |SELECT * FROM b\n        |EXCEPT ALL\n        |SELECT * FROM c\n        |INTERSECT ALL\n        |SELECT * FROM d\n      ")).stripMargin();
            this.assertEqual(query1, package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Distinct(package.plans$.MODULE$.DslLogicalPlan(a).union(b))).except(package.plans$.MODULE$.DslLogicalPlan(c).intersect(d, false), false));
            this.assertEqual(query2, package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Distinct(package.plans$.MODULE$.DslLogicalPlan(a).union(b))).except(package.plans$.MODULE$.DslLogicalPlan(c).intersect(d, true), true));
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_SETOPS_PRECEDENCE_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.assertEqual(query1, package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Distinct(package.plans$.MODULE$.DslLogicalPlan(a).union(b))).except(c, false)).intersect(d, false));
                this.assertEqual(query2, package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Distinct(package.plans$.MODULE$.DslLogicalPlan(a).union(b))).except(c, true)).intersect(d, true));
            });
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_SETOPS_PRECEDENCE_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.assertEqual(query1, package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Distinct(package.plans$.MODULE$.DslLogicalPlan(a).union(b))).except(package.plans$.MODULE$.DslLogicalPlan(c).intersect(d, false), false));
                this.assertEqual(query2, package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Distinct(package.plans$.MODULE$.DslLogicalPlan(a).union(b))).except(package.plans$.MODULE$.DslLogicalPlan(c).intersect(d, true), true));
            });
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1025));
        this.test("create/alter view as insert into table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String m4;
            String m3;
            String m2;
            String m1;
            String $org_scalatest_assert_macro_left = m1 = ((ParseException)this.intercept((Function0 & Serializable & scala.Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan("CREATE VIEW testView AS INSERT INTO jt VALUES(1, 1)"), ClassTag$.MODULE$.apply(ParseException.class), new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1072))).getMessage();
            String $org_scalatest_assert_macro_right = "Syntax error at or near 'INSERT'";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1075));
            String $org_scalatest_assert_macro_left2 = m2 = ((ParseException)this.intercept((Function0 & Serializable & scala.Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(new StringOps(Predef$.MODULE$.augmentString("\n          |CREATE VIEW testView AS FROM jt\n          |INSERT INTO tbl1 SELECT * WHERE jt.id < 5\n          |INSERT INTO tbl2 SELECT * WHERE jt.id > 4\n        ")).stripMargin()), ClassTag$.MODULE$.apply(ParseException.class), new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1077))).getMessage();
            String $org_scalatest_assert_macro_right2 = "Syntax error at or near 'INSERT'";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1085));
            String $org_scalatest_assert_macro_left3 = m3 = ((ParseException)this.intercept((Function0 & Serializable & scala.Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan("ALTER VIEW testView AS INSERT INTO jt VALUES(1, 1)"), ClassTag$.MODULE$.apply(ParseException.class), new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1086))).getMessage();
            String $org_scalatest_assert_macro_right3 = "Syntax error at or near 'INSERT'";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1089));
            String $org_scalatest_assert_macro_left4 = m4 = ((ParseException)this.intercept((Function0 & Serializable & scala.Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(new StringOps(Predef$.MODULE$.augmentString("\n          |ALTER VIEW testView AS FROM jt\n          |INSERT INTO tbl1 SELECT * WHERE jt.id < 5\n          |INSERT INTO tbl2 SELECT * WHERE jt.id > 4\n        ")).stripMargin()), ClassTag$.MODULE$.apply(ParseException.class), new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1091))).getMessage();
            String $org_scalatest_assert_macro_right4 = "Syntax error at or near 'INSERT'";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.contains($org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1100));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1071));
        this.test("Invalid insert constructs in the query", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String m2;
            String m1;
            String $org_scalatest_assert_macro_left = m1 = ((ParseException)this.intercept((Function0 & Serializable & scala.Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan("SELECT * FROM (INSERT INTO BAR VALUES (2))"), ClassTag$.MODULE$.apply(ParseException.class), new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1104))).getMessage();
            String $org_scalatest_assert_macro_right = "Syntax error at or near 'BAR': missing ')'";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1107));
            String $org_scalatest_assert_macro_left2 = m2 = ((ParseException)this.intercept((Function0 & Serializable & scala.Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan("SELECT * FROM S WHERE C1 IN (INSERT INTO T VALUES (2))"), ClassTag$.MODULE$.apply(ParseException.class), new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1108))).getMessage();
            String $org_scalatest_assert_macro_right2 = "Syntax error at or near 'IN'";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1111));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1103));
        this.test("relation in v2 catalog", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("TABLE testcat.db.tab", package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"testcat", "db", "tab"})));
            this.assertEqual("SELECT * FROM testcat.db.tab", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"testcat", "db", "tab"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            this.assertEqual(new StringOps(Predef$.MODULE$.augmentString("\n        |WITH cte1 AS (SELECT * FROM testcat.db.tab)\n        |SELECT * FROM cte1\n      ")).stripMargin(), (LogicalPlan)this.cte(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cte1"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})), (Seq<Tuple2<String, Tuple2<LogicalPlan, Seq<String>>>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cte1"), (Object)new Tuple2((Object)package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"testcat", "db", "tab"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})), (Object)Nil$.MODULE$))})));
            this.assertEqual("SELECT /*+ BROADCAST(tab) */ * FROM testcat.db.tab", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"testcat", "db", "tab"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))).hint("BROADCAST", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tab"}))).$((Seq)Nil$.MODULE$)})));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1114));
        this.test("CTE with column alias", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.assertEqual("WITH t(x) AS (SELECT c FROM a) SELECT * FROM t", (LogicalPlan)this.cte(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})), (Seq<Tuple2<String, Tuple2<LogicalPlan, Seq<String>>>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"t"), (Object)new Tuple2((Object)package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c"))})), (Object)new .colon.colon((Object)"x", (List)Nil$.MODULE$)))}))), new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1131));
        this.test("statement containing terminal semicolons", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("select 1;", package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new OneRowRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.intToLiteral(1)})));
            this.assertEqual("select a, b;", package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new OneRowRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))})));
            this.assertEqual("select a, b from db.c;;;", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"db", "c"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))})));
            this.assertEqual("select a, b from db.c; ;;  ;", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"db", "c"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))})));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1137));
        this.test("SPARK-32106: TRANSFORM plan", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String x$46 = "key";
            StringType$ x$47 = StringType$.MODULE$;
            boolean x$48 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$49 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$50 = AttributeReference$.MODULE$.apply$default$5(x$46, (DataType)x$47, x$48, x$49);
            Seq x$51 = AttributeReference$.MODULE$.apply$default$6(x$46, (DataType)x$47, x$48, x$49);
            String x$52 = "value";
            StringType$ x$53 = StringType$.MODULE$;
            boolean x$54 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$55 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$56 = AttributeReference$.MODULE$.apply$default$5(x$52, (DataType)x$53, x$54, x$55);
            Seq x$57 = AttributeReference$.MODULE$.apply$default$6(x$52, (DataType)x$53, x$54, x$55);
            this.assertEqual(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT TRANSFORM(a, b, c)\n        |USING 'cat'\n        |FROM testData\n      ")).stripMargin(), (LogicalPlan)new ScriptTransformation("cat", (Seq)new .colon.colon((Object)new AttributeReference(x$46, (DataType)x$47, x$48, x$49, x$50, x$51), (List)new .colon.colon((Object)new AttributeReference(x$52, (DataType)x$53, x$54, x$55, x$56, x$57), (List)Nil$.MODULE$)), (LogicalPlan)new Project((Seq)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (List)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), (List)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c")), (List)Nil$.MODULE$))), (LogicalPlan)UnresolvedRelation$.MODULE$.apply(TableIdentifier$.MODULE$.apply("testData"))), new ScriptInputOutputSchema((Seq)List$.MODULE$.empty(), (Seq)List$.MODULE$.empty(), (Option)None$.MODULE$, (Option)None$.MODULE$, (Seq)List$.MODULE$.empty(), (Seq)List$.MODULE$.empty(), (Option)None$.MODULE$, (Option)None$.MODULE$, true)));
            String x$58 = "a";
            StringType$ x$59 = StringType$.MODULE$;
            boolean x$60 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$61 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$62 = AttributeReference$.MODULE$.apply$default$5(x$58, (DataType)x$59, x$60, x$61);
            Seq x$63 = AttributeReference$.MODULE$.apply$default$6(x$58, (DataType)x$59, x$60, x$61);
            String x$64 = "b";
            StringType$ x$65 = StringType$.MODULE$;
            boolean x$66 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$67 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$68 = AttributeReference$.MODULE$.apply$default$5(x$64, (DataType)x$65, x$66, x$67);
            Seq x$69 = AttributeReference$.MODULE$.apply$default$6(x$64, (DataType)x$65, x$66, x$67);
            String x$70 = "c";
            StringType$ x$71 = StringType$.MODULE$;
            boolean x$72 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$73 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$74 = AttributeReference$.MODULE$.apply$default$5(x$70, (DataType)x$71, x$72, x$73);
            Seq x$75 = AttributeReference$.MODULE$.apply$default$6(x$70, (DataType)x$71, x$72, x$73);
            this.assertEqual(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT TRANSFORM(a, b, c)\n        |USING 'cat' AS (a, b, c)\n        |FROM testData\n      ")).stripMargin(), (LogicalPlan)new ScriptTransformation("cat", (Seq)new .colon.colon((Object)new AttributeReference(x$58, (DataType)x$59, x$60, x$61, x$62, x$63), (List)new .colon.colon((Object)new AttributeReference(x$64, (DataType)x$65, x$66, x$67, x$68, x$69), (List)new .colon.colon((Object)new AttributeReference(x$70, (DataType)x$71, x$72, x$73, x$74, x$75), (List)Nil$.MODULE$))), (LogicalPlan)new Project((Seq)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (List)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), (List)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c")), (List)Nil$.MODULE$))), (LogicalPlan)UnresolvedRelation$.MODULE$.apply(TableIdentifier$.MODULE$.apply("testData"))), new ScriptInputOutputSchema((Seq)List$.MODULE$.empty(), (Seq)List$.MODULE$.empty(), (Option)None$.MODULE$, (Option)None$.MODULE$, (Seq)List$.MODULE$.empty(), (Seq)List$.MODULE$.empty(), (Option)None$.MODULE$, (Option)None$.MODULE$, false)));
            String x$76 = "a";
            IntegerType$ x$77 = IntegerType$.MODULE$;
            boolean x$78 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$79 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$80 = AttributeReference$.MODULE$.apply$default$5(x$76, (DataType)x$77, x$78, x$79);
            Seq x$81 = AttributeReference$.MODULE$.apply$default$6(x$76, (DataType)x$77, x$78, x$79);
            String x$82 = "b";
            StringType$ x$83 = StringType$.MODULE$;
            boolean x$84 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$85 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$86 = AttributeReference$.MODULE$.apply$default$5(x$82, (DataType)x$83, x$84, x$85);
            Seq x$87 = AttributeReference$.MODULE$.apply$default$6(x$82, (DataType)x$83, x$84, x$85);
            String x$88 = "c";
            LongType$ x$89 = LongType$.MODULE$;
            boolean x$90 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$91 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$92 = AttributeReference$.MODULE$.apply$default$5(x$88, (DataType)x$89, x$90, x$91);
            Seq x$93 = AttributeReference$.MODULE$.apply$default$6(x$88, (DataType)x$89, x$90, x$91);
            this.assertEqual(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT TRANSFORM(a, b, c)\n        |USING 'cat' AS (a int, b string, c long)\n        |FROM testData\n      ")).stripMargin(), (LogicalPlan)new ScriptTransformation("cat", (Seq)new .colon.colon((Object)new AttributeReference(x$76, (DataType)x$77, x$78, x$79, x$80, x$81), (List)new .colon.colon((Object)new AttributeReference(x$82, (DataType)x$83, x$84, x$85, x$86, x$87), (List)new .colon.colon((Object)new AttributeReference(x$88, (DataType)x$89, x$90, x$91, x$92, x$93), (List)Nil$.MODULE$))), (LogicalPlan)new Project((Seq)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (List)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), (List)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c")), (List)Nil$.MODULE$))), (LogicalPlan)UnresolvedRelation$.MODULE$.apply(TableIdentifier$.MODULE$.apply("testData"))), new ScriptInputOutputSchema((Seq)List$.MODULE$.empty(), (Seq)List$.MODULE$.empty(), (Option)None$.MODULE$, (Option)None$.MODULE$, (Seq)List$.MODULE$.empty(), (Seq)List$.MODULE$.empty(), (Option)None$.MODULE$, (Option)None$.MODULE$, false)));
            String x$94 = "a";
            StringType$ x$95 = StringType$.MODULE$;
            boolean x$96 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$97 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$98 = AttributeReference$.MODULE$.apply$default$5(x$94, (DataType)x$95, x$96, x$97);
            Seq x$99 = AttributeReference$.MODULE$.apply$default$6(x$94, (DataType)x$95, x$96, x$97);
            String x$100 = "b";
            StringType$ x$101 = StringType$.MODULE$;
            boolean x$102 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$103 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$104 = AttributeReference$.MODULE$.apply$default$5(x$100, (DataType)x$101, x$102, x$103);
            Seq x$105 = AttributeReference$.MODULE$.apply$default$6(x$100, (DataType)x$101, x$102, x$103);
            String x$106 = "c";
            StringType$ x$107 = StringType$.MODULE$;
            boolean x$108 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$109 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$110 = AttributeReference$.MODULE$.apply$default$5(x$106, (DataType)x$107, x$108, x$109);
            Seq x$111 = AttributeReference$.MODULE$.apply$default$6(x$106, (DataType)x$107, x$108, x$109);
            this.assertEqual(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT TRANSFORM(a, b, c)\n        |  ROW FORMAT DELIMITED\n        |  FIELDS TERMINATED BY '\\t'\n        |  COLLECTION ITEMS TERMINATED BY '\u0002'\n        |  MAP KEYS TERMINATED BY '\u0003'\n        |  LINES TERMINATED BY '\\n'\n        |  NULL DEFINED AS 'null'\n        |  USING 'cat' AS (a, b, c)\n        |  ROW FORMAT DELIMITED\n        |  FIELDS TERMINATED BY '\\t'\n        |  COLLECTION ITEMS TERMINATED BY '\u0004'\n        |  MAP KEYS TERMINATED BY '\u0005'\n        |  LINES TERMINATED BY '\\n'\n        |  NULL DEFINED AS 'NULL'\n        |FROM testData\n      ")).stripMargin(), (LogicalPlan)new ScriptTransformation("cat", (Seq)new .colon.colon((Object)new AttributeReference(x$94, (DataType)x$95, x$96, x$97, x$98, x$99), (List)new .colon.colon((Object)new AttributeReference(x$100, (DataType)x$101, x$102, x$103, x$104, x$105), (List)new .colon.colon((Object)new AttributeReference(x$106, (DataType)x$107, x$108, x$109, x$110, x$111), (List)Nil$.MODULE$))), (LogicalPlan)new Project((Seq)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (List)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), (List)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c")), (List)Nil$.MODULE$))), (LogicalPlan)UnresolvedRelation$.MODULE$.apply(TableIdentifier$.MODULE$.apply("testData"))), new ScriptInputOutputSchema((Seq)new .colon.colon((Object)new Tuple2((Object)"TOK_TABLEROWFORMATFIELD", (Object)"\t"), (List)new .colon.colon((Object)new Tuple2((Object)"TOK_TABLEROWFORMATCOLLITEMS", (Object)"\u0002"), (List)new .colon.colon((Object)new Tuple2((Object)"TOK_TABLEROWFORMATMAPKEYS", (Object)"\u0003"), (List)new .colon.colon((Object)new Tuple2((Object)"TOK_TABLEROWFORMATNULL", (Object)"null"), (List)new .colon.colon((Object)new Tuple2((Object)"TOK_TABLEROWFORMATLINES", (Object)"\n"), (List)Nil$.MODULE$))))), (Seq)new .colon.colon((Object)new Tuple2((Object)"TOK_TABLEROWFORMATFIELD", (Object)"\t"), (List)new .colon.colon((Object)new Tuple2((Object)"TOK_TABLEROWFORMATCOLLITEMS", (Object)"\u0004"), (List)new .colon.colon((Object)new Tuple2((Object)"TOK_TABLEROWFORMATMAPKEYS", (Object)"\u0005"), (List)new .colon.colon((Object)new Tuple2((Object)"TOK_TABLEROWFORMATNULL", (Object)"NULL"), (List)new .colon.colon((Object)new Tuple2((Object)"TOK_TABLEROWFORMATLINES", (Object)"\n"), (List)Nil$.MODULE$))))), (Option)None$.MODULE$, (Option)None$.MODULE$, (Seq)List$.MODULE$.empty(), (Seq)List$.MODULE$.empty(), (Option)None$.MODULE$, (Option)None$.MODULE$, false)));
            this.intercept(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT TRANSFORM(a, b, c)\n        |  ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.OpenCSVSerde'\n        |  WITH SERDEPROPERTIES(\n        |    \"separatorChar\" = \"\\t\",\n        |    \"quoteChar\" = \"'\",\n        |    \"escapeChar\" = \"\\\\\")\n        |  USING 'cat' AS (a, b, c)\n        |  ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.OpenCSVSerde'\n        |  WITH SERDEPROPERTIES(\n        |    \"separatorChar\" = \"\\t\",\n        |    \"quoteChar\" = \"'\",\n        |    \"escapeChar\" = \"\\\\\")\n        |FROM testData\n      ")).stripMargin(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TRANSFORM with serde is only supported in hive mode"}));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1144));
        this.test("as of syntax", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.testVersion$1("'Snapshot123456789'", (LogicalPlan)new Project((Seq)new .colon.colon((Object)new UnresolvedStar((Option)None$.MODULE$), (List)Nil$.MODULE$), (LogicalPlan)new RelationTimeTravel((LogicalPlan)new UnresolvedRelation((Seq)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)new .colon.colon((Object)"c", (List)Nil$.MODULE$))), UnresolvedRelation$.MODULE$.apply$default$2(), UnresolvedRelation$.MODULE$.apply$default$3()), (Option)None$.MODULE$, (Option)new Some((Object)"Snapshot123456789"))));
            this.testVersion$1("123456789", (LogicalPlan)new Project((Seq)new .colon.colon((Object)new UnresolvedStar((Option)None$.MODULE$), (List)Nil$.MODULE$), (LogicalPlan)new RelationTimeTravel((LogicalPlan)new UnresolvedRelation((Seq)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)new .colon.colon((Object)"c", (List)Nil$.MODULE$))), UnresolvedRelation$.MODULE$.apply$default$2(), UnresolvedRelation$.MODULE$.apply$default$3()), (Option)None$.MODULE$, (Option)new Some((Object)"123456789"))));
            this.testTimestamp$1("'2019-01-29 00:37:58'", (LogicalPlan)new Project((Seq)new .colon.colon((Object)new UnresolvedStar((Option)None$.MODULE$), (List)Nil$.MODULE$), (LogicalPlan)new RelationTimeTravel((LogicalPlan)new UnresolvedRelation((Seq)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)new .colon.colon((Object)"c", (List)Nil$.MODULE$))), UnresolvedRelation$.MODULE$.apply$default$2(), UnresolvedRelation$.MODULE$.apply$default$3()), (Option)new Some((Object)Literal$.MODULE$.apply((Object)"2019-01-29 00:37:58")), (Option)None$.MODULE$)));
            this.testTimestamp$1("current_date()", (LogicalPlan)new Project((Seq)new .colon.colon((Object)new UnresolvedStar((Option)None$.MODULE$), (List)Nil$.MODULE$), (LogicalPlan)new RelationTimeTravel((LogicalPlan)new UnresolvedRelation((Seq)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)new .colon.colon((Object)"c", (List)Nil$.MODULE$))), UnresolvedRelation$.MODULE$.apply$default$2(), UnresolvedRelation$.MODULE$.apply$default$3()), (Option)new Some((Object)new UnresolvedFunction((Seq)new .colon.colon((Object)"current_date", (List)Nil$.MODULE$), (Seq)Nil$.MODULE$, false, UnresolvedFunction$.MODULE$.apply$default$4(), UnresolvedFunction$.MODULE$.apply$default$5())), (Option)None$.MODULE$)));
            this.intercept("SELECT * FROM a.b.c TIMESTAMP AS OF col", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"timestamp expression cannot refer to any columns"}));
            this.intercept("SELECT * FROM a.b.c TIMESTAMP AS OF (select 1)", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"timestamp expression cannot contain subqueries"}));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1252));
        this.test("PERCENTILE_CONT & PERCENTILE_DISC", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertPercentilePlans$1("SELECT PERCENTILE_CONT(0.1) WITHIN GROUP (ORDER BY col)", (Expression)new PercentileCont((Expression)UnresolvedAttribute$.MODULE$.apply("col"), (Expression)new Literal((Object)Decimal$.MODULE$.apply(0.1), (DataType)new DecimalType(1, 1)), PercentileCont$.MODULE$.apply$default$3()).toAggregateExpression());
            this.assertPercentilePlans$1("SELECT PERCENTILE_CONT(0.1) WITHIN GROUP (ORDER BY col DESC)", (Expression)new PercentileCont((Expression)UnresolvedAttribute$.MODULE$.apply("col"), (Expression)new Literal((Object)Decimal$.MODULE$.apply(0.1), (DataType)new DecimalType(1, 1)), true).toAggregateExpression());
            this.assertPercentilePlans$1("SELECT PERCENTILE_DISC(0.1) WITHIN GROUP (ORDER BY col)", (Expression)new PercentileDisc((Expression)UnresolvedAttribute$.MODULE$.apply("col"), (Expression)new Literal((Object)Decimal$.MODULE$.apply(0.1), (DataType)new DecimalType(1, 1)), PercentileDisc$.MODULE$.apply$default$3(), PercentileDisc$.MODULE$.apply$default$4(), PercentileDisc$.MODULE$.apply$default$5()).toAggregateExpression());
            this.assertPercentilePlans$1("SELECT PERCENTILE_DISC(0.1) WITHIN GROUP (ORDER BY col DESC)", (Expression)new PercentileDisc((Expression)UnresolvedAttribute$.MODULE$.apply("col"), (Expression)new Literal((Object)Decimal$.MODULE$.apply(0.1), (DataType)new DecimalType(1, 1)), true, PercentileDisc$.MODULE$.apply$default$4(), PercentileDisc$.MODULE$.apply$default$5()).toAggregateExpression());
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1297));
    }
}

