/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.time.ZoneId;
import java.util.Arrays;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.RandomDataGenerator$;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AnsiIntervalType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypeTestUtils$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u000153AAB\u0004\u0001!!)Q\u0004\u0001C\u0001=!)\u0011\u0005\u0001C\u0001E!9a\u0007AI\u0001\n\u00039\u0004b\u0002\"\u0001\u0005\u0004%\ta\u0011\u0005\u0007\u0019\u0002\u0001\u000b\u0011\u0002#\u00031I\u000bg\u000eZ8n\t\u0006$\u0018mR3oKJ\fGo\u001c:Tk&$XM\u0003\u0002\t\u0013\u0005\u00191/\u001d7\u000b\u0005)Y\u0011!B:qCJ\\'B\u0001\u0007\u000e\u0003\u0019\t\u0007/Y2iK*\ta\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001#U\u0001\"AE\n\u000e\u0003%I!\u0001F\u0005\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\t12$D\u0001\u0018\u0015\tA\u0012$A\u0003qY\u0006t7O\u0003\u0002\u001b\u000f\u0005A1-\u0019;bYf\u001cH/\u0003\u0002\u001d/\tI1+\u0015'IK2\u0004XM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003}\u0001\"\u0001\t\u0001\u000e\u0003\u001d\t\u0001\u0004^3tiJ\u000bg\u000eZ8n\t\u0006$\u0018mR3oKJ\fG/[8o)\r\u0019\u0013&\r\t\u0003I\u001dj\u0011!\n\u0006\u0002M\u0005)1oY1mC&\u0011\u0001&\n\u0002\u0005+:LG\u000fC\u0003+\u0005\u0001\u00071&\u0001\u0005eCR\fG+\u001f9f!\tas&D\u0001.\u0015\tqs!A\u0003usB,7/\u0003\u00021[\tAA)\u0019;b)f\u0004X\rC\u00043\u0005A\u0005\t\u0019A\u001a\u0002\u00119,H\u000e\\1cY\u0016\u0004\"\u0001\n\u001b\n\u0005U*#a\u0002\"p_2,\u0017M\\\u0001#i\u0016\u001cHOU1oI>lG)\u0019;b\u000f\u0016tWM]1uS>tG\u0005Z3gCVdG\u000f\n\u001a\u0016\u0003aR#aM\u001d,\u0003i\u0002\"a\u000f!\u000e\u0003qR!!\u0010 \u0002\u0013Ut7\r[3dW\u0016$'BA &\u0003)\tgN\\8uCRLwN\\\u0005\u0003\u0003r\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003u\tGo\\7jGRK\b/Z:XSRDG)\u0019;b\u000f\u0016tWM]1u_J\u001cX#\u0001#\u0011\u0007\u0015S5&D\u0001G\u0015\t9\u0005*A\u0005j[6,H/\u00192mK*\u0011\u0011*J\u0001\u000bG>dG.Z2uS>t\u0017BA&G\u0005\r\u0019V\r^\u0001\u001fCR|W.[2UsB,7oV5uQ\u0012\u000bG/Y$f]\u0016\u0014\u0018\r^8sg\u0002\u0002")
public class RandomDataGeneratorSuite
extends SparkFunSuite
implements SQLHelper {
    private final Set<DataType> atomicTypesWithDataGenerators;
    private String sparkHome;
    private volatile boolean bitmap$0;

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$(this, pairs, f);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    private String sparkHome$lzycompute() {
        RandomDataGeneratorSuite randomDataGeneratorSuite = this;
        synchronized (randomDataGeneratorSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        return !this.bitmap$0 ? this.sparkHome$lzycompute() : this.sparkHome;
    }

    public void testRandomDataGeneration(DataType dataType, boolean nullable) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1 & Serializable & scala.Serializable)java8Api -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.DATETIME_JAVA8API_ENABLED().key()), (Object)Boolean.toString(BoxesRunTime.unboxToBoolean((Object)java8Api)))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Assertion assertion;
                Function1 toCatalyst = CatalystTypeConverters$.MODULE$.createToCatalystConverter(dataType$1);
                Function0 generator = (Function0)RandomDataGenerator$.MODULE$.forType(dataType$1, nullable$1, new Random(33), RandomDataGenerator$.MODULE$.forType$default$4()).getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.fail(new StringBuilder(42).append("Random data generator was not defined for ").append(dataType$1).toString(), new Position("RandomDataGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46)));
                if (nullable$1) {
                    Iterator $org_scalatest_assert_macro_left = package$.MODULE$.Iterator().fill(100, generator);
                    Object $org_scalatest_assert_macro_right = null;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", null, $org_scalatest_assert_macro_left.contains(null), Prettifier$.MODULE$.default());
                    assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomDataGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
                } else {
                    Iterator $org_scalatest_assert_macro_left = package$.MODULE$.Iterator().fill(100, generator);
                    Object $org_scalatest_assert_macro_right = null;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", null, $org_scalatest_assert_macro_left.contains(null), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                    assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomDataGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
                }
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).foreach((Function1 & Serializable & scala.Serializable)_ -> RandomDataGeneratorSuite.$anonfun$testRandomDataGeneration$4(generator, toCatalyst, BoxesRunTime.unboxToInt((Object)_)));
            });
            return BoxedUnit.UNIT;
        });
    }

    public boolean testRandomDataGeneration$default$2() {
        return true;
    }

    public Set<DataType> atomicTypesWithDataGenerators() {
        return this.atomicTypesWithDataGenerators;
    }

    public static final /* synthetic */ Object $anonfun$testRandomDataGeneration$4(Function0 generator$1, Function1 toCatalyst$1, int _) {
        Object generatedValue = generator$1.apply();
        return toCatalyst$1.apply(generatedValue);
    }

    public static final /* synthetic */ boolean $anonfun$new$2(DataType dataType$2, boolean nullable) {
        return !(dataType$2 instanceof DecimalType);
    }

    public static final /* synthetic */ void $anonfun$new$1(RandomDataGeneratorSuite $this, DataType dataType) {
        ((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).withFilter((Function1 & Serializable & scala.Serializable)nullable -> BoxesRunTime.boxToBoolean((boolean)RandomDataGeneratorSuite.$anonfun$new$2(dataType, BoxesRunTime.unboxToBoolean((Object)nullable)))).foreach((Function1 & Serializable & scala.Serializable)nullable -> {
            $this.test(new StringBuilder(12).append(dataType).append(" (nullable=").append(BoxesRunTime.unboxToBoolean((Object)nullable)).append(")").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.testRandomDataGeneration(dataType, $this.testRandomDataGeneration$default$2()), new Position("RandomDataGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$new$5(ArrayType arrayType) {
        return RandomDataGenerator$.MODULE$.forType(arrayType.elementType(), arrayType.containsNull(), RandomDataGenerator$.MODULE$.forType$default$3(), RandomDataGenerator$.MODULE$.forType$default$4()).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$atomicTypesWithDataGenerators$1(DataType x$1) {
        return RandomDataGenerator$.MODULE$.forType(x$1, RandomDataGenerator$.MODULE$.forType$default$2(), RandomDataGenerator$.MODULE$.forType$default$3(), RandomDataGenerator$.MODULE$.forType$default$4()).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$new$9(DataType keyType$1, DataType valueType) {
        return !(keyType$1 instanceof DecimalType);
    }

    public static final /* synthetic */ void $anonfun$new$10(RandomDataGeneratorSuite $this, DataType keyType$1, DataType valueType) {
        MapType mapType = MapType$.MODULE$.apply(keyType$1, valueType);
        $this.test(String.valueOf(mapType), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.testRandomDataGeneration((DataType)mapType, $this.testRandomDataGeneration$default$2()), new Position("RandomDataGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
    }

    public static final /* synthetic */ void $anonfun$new$8(RandomDataGeneratorSuite $this, DataType keyType) {
        $this.atomicTypesWithDataGenerators().withFilter((Function1 & Serializable & scala.Serializable)valueType -> BoxesRunTime.boxToBoolean((boolean)RandomDataGeneratorSuite.$anonfun$new$9(keyType, valueType))).foreach((Function1 & Serializable & scala.Serializable)valueType -> {
            RandomDataGeneratorSuite.$anonfun$new$10($this, keyType, valueType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$13(RandomDataGeneratorSuite $this, DataType colOneType$1, DataType colTwoType) {
        StructField structField = new StructField("a", colOneType$1, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructField structField2 = new StructField("b", colTwoType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructType structType = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField2).$colon$colon((Object)structField));
        $this.test(String.valueOf(structType), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.testRandomDataGeneration((DataType)structType, $this.testRandomDataGeneration$default$2()), new Position("RandomDataGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
    }

    public static final /* synthetic */ void $anonfun$new$12(RandomDataGeneratorSuite $this, DataType colOneType) {
        $this.atomicTypesWithDataGenerators().foreach((Function1 & Serializable & scala.Serializable)colTwoType -> {
            RandomDataGeneratorSuite.$anonfun$new$13($this, colOneType, colTwoType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ Assertion $anonfun$new$16(MapType mapType$2, int seed) {
        Function0 generator = (Function0)RandomDataGenerator$.MODULE$.forType((DataType)mapType$2, false, new Random(seed), RandomDataGenerator$.MODULE$.forType$default$4()).get();
        Seq maps = (Seq)Seq$.MODULE$.fill(100, (Function0 & Serializable & scala.Serializable)() -> (Map)generator.apply());
        int expectedTotalElements = 50 * RandomDataGenerator$.MODULE$.MAX_MAP_SIZE();
        int deviation = scala.math.package$.MODULE$.abs(BoxesRunTime.unboxToInt((Object)((TraversableOnce)maps.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.size()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) - expectedTotalElements);
        double $org_scalatest_assert_macro_left = (double)deviation / (double)expectedTotalElements;
        double $org_scalatest_assert_macro_right = 0.2;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomDataGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
    }

    public static final /* synthetic */ Assertion $anonfun$new$23(AnsiIntervalType dt$1, int seed) {
        Object catalyst;
        Object convertedBack;
        Object $org_scalatest_assert_macro_right;
        Object $org_scalatest_assert_macro_left;
        Function0 generator = (Function0)RandomDataGenerator$.MODULE$.forType((DataType)dt$1, false, new Random(seed), RandomDataGenerator$.MODULE$.forType$default$4()).get();
        Function1 toCatalyst = CatalystTypeConverters$.MODULE$.createToCatalystConverter((DataType)dt$1);
        Function1 toScala = CatalystTypeConverters$.MODULE$.createToScalaConverter((DataType)dt$1);
        Object data = generator.apply();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "==", $org_scalatest_assert_macro_right, BoxesRunTime.equals((Object)($org_scalatest_assert_macro_left = data), (Object)($org_scalatest_assert_macro_right = (convertedBack = toScala.apply(catalyst = toCatalyst.apply(data))))), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomDataGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
    }

    public static final /* synthetic */ void $anonfun$new$22(AnsiIntervalType dt) {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 1000).foreach((Function1 & Serializable & scala.Serializable)seed -> RandomDataGeneratorSuite.$anonfun$new$23(dt, BoxesRunTime.unboxToInt((Object)seed)));
    }

    public RandomDataGeneratorSuite() {
        SQLHelper.$init$(this);
        DataTypeTestUtils$.MODULE$.atomicTypes().foreach((Function1 & Serializable & scala.Serializable)dataType -> {
            RandomDataGeneratorSuite.$anonfun$new$1(this, dataType);
            return BoxedUnit.UNIT;
        });
        DataTypeTestUtils$.MODULE$.atomicArrayTypes().withFilter((Function1 & Serializable & scala.Serializable)arrayType -> BoxesRunTime.boxToBoolean((boolean)RandomDataGeneratorSuite.$anonfun$new$5(arrayType))).foreach((Function1 & Serializable & scala.Serializable)arrayType -> {
            this.test(String.valueOf(arrayType), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testRandomDataGeneration((DataType)arrayType, this.testRandomDataGeneration$default$2()), new Position("RandomDataGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
            return BoxedUnit.UNIT;
        });
        this.atomicTypesWithDataGenerators = (Set)DataTypeTestUtils$.MODULE$.atomicTypes().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)RandomDataGeneratorSuite.$anonfun$atomicTypesWithDataGenerators$1(x$1)));
        this.atomicTypesWithDataGenerators().foreach((Function1 & Serializable & scala.Serializable)keyType -> {
            RandomDataGeneratorSuite.$anonfun$new$8(this, keyType);
            return BoxedUnit.UNIT;
        });
        this.atomicTypesWithDataGenerators().foreach((Function1 & Serializable & scala.Serializable)colOneType -> {
            RandomDataGeneratorSuite.$anonfun$new$12(this, colOneType);
            return BoxedUnit.UNIT;
        });
        this.test("check size of generated map", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            MapType mapType = MapType$.MODULE$.apply((DataType)IntegerType$.MODULE$, (DataType)IntegerType$.MODULE$);
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 1000).foreach((Function1 & Serializable & scala.Serializable)seed -> RandomDataGeneratorSuite.$anonfun$new$16(mapType, BoxesRunTime.unboxToInt((Object)seed)));
        }, new Position("RandomDataGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
        this.test("Use Float.NaN for all NaN values", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int bits = -6966608;
            float nan1 = Float.intBitsToFloat(bits);
            float nan2 = RandomDataGenerator$.MODULE$.intBitsToFloat(bits);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(Float.isNaN(nan1), "scala.Predef.float2Float(nan1).isNaN()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomDataGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(Float.isNaN(nan2), "scala.Predef.float2Float(nan2).isNaN()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomDataGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
            byte[] arrayExpected = ByteBuffer.allocate(4).putFloat(Float.NaN).array();
            byte[] array1 = ByteBuffer.allocate(4).putFloat(nan1).array();
            byte[] array2 = ByteBuffer.allocate(4).putFloat(nan2).array();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(Arrays.equals(array1, arrayExpected), "java.util.Arrays.equals(array1, arrayExpected)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomDataGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(Arrays.equals(array2, arrayExpected), "java.util.Arrays.equals(array2, arrayExpected)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomDataGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
        }, new Position("RandomDataGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
        this.test("Use Double.NaN for all NaN values", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int bits = -6966608;
            double nan1 = Double.longBitsToDouble(bits);
            double nan2 = RandomDataGenerator$.MODULE$.longBitsToDouble(bits);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(Double.isNaN(nan1), "scala.Predef.double2Double(nan1).isNaN()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomDataGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(Double.isNaN(nan2), "scala.Predef.double2Double(nan2).isNaN()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomDataGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
            byte[] arrayExpected = ByteBuffer.allocate(8).putDouble(Double.NaN).array();
            byte[] array1 = ByteBuffer.allocate(8).putDouble(nan1).array();
            byte[] array2 = ByteBuffer.allocate(8).putDouble(nan2).array();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(Arrays.equals(array1, arrayExpected), "java.util.Arrays.equals(array1, arrayExpected)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomDataGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(Arrays.equals(array2, arrayExpected), "java.util.Arrays.equals(array2, arrayExpected)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomDataGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
        }, new Position("RandomDataGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
        this.test("SPARK-35116: The generated data fits the precision of DayTimeIntervalType in spark", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)DataTypeTestUtils$.MODULE$.dayTimeIntervalTypes().$plus$plus(DataTypeTestUtils$.MODULE$.yearMonthIntervalTypes(), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)dt -> {
            RandomDataGeneratorSuite.$anonfun$new$22(dt);
            return BoxedUnit.UNIT;
        }), new Position("RandomDataGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
    }
}

