/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.plans;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import java.util.TimeZone;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.package$;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionSet;
import org.apache.spark.sql.catalyst.expressions.ExpressionSet$;
import org.apache.spark.sql.catalyst.expressions.InputFileName;
import org.apache.spark.sql.catalyst.expressions.IsNotNull;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.Predicate;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.expressions.Rand$;
import org.apache.spark.sql.catalyst.plans.FullOuter$;
import org.apache.spark.sql.catalyst.plans.Inner$;
import org.apache.spark.sql.catalyst.plans.JoinType;
import org.apache.spark.sql.catalyst.plans.LeftOuter$;
import org.apache.spark.sql.catalyst.plans.LeftSemi$;
import org.apache.spark.sql.catalyst.plans.PlanTest;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.RightOuter$;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.Expand;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StringType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t4AAB\u0004\u0001)!)Q\u0004\u0001C\u0001=!)\u0001\u0005\u0001C\u0005C!)\u0001\u0005\u0001C\u0005\u007f!)a\t\u0001C\u0005\u000f\")1\u000b\u0001C\u0005)\nQ2i\u001c8tiJ\f\u0017N\u001c;Qe>\u0004\u0018mZ1uS>t7+^5uK*\u0011\u0001\"C\u0001\u0006a2\fgn\u001d\u0006\u0003\u0015-\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003\u00195\t1a]9m\u0015\tqq\"A\u0003ta\u0006\u00148N\u0003\u0002\u0011#\u00051\u0011\r]1dQ\u0016T\u0011AE\u0001\u0004_J<7\u0001A\n\u0004\u0001UI\u0002C\u0001\f\u0018\u001b\u0005i\u0011B\u0001\r\u000e\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u0011!dG\u0007\u0002\u000f%\u0011Ad\u0002\u0002\t!2\fg\u000eV3ti\u00061A(\u001b8jiz\"\u0012a\b\t\u00035\u0001\tQB]3t_24XmQ8mk6tGc\u0001\u0012)aA\u00111EJ\u0007\u0002I)\u0011Q%C\u0001\fKb\u0004(/Z:tS>t7/\u0003\u0002(I\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\t\u000b%\u0012\u0001\u0019\u0001\u0016\u0002\u0005Q\u0014\bCA\u0016/\u001b\u0005a#BA\u0017\b\u0003\u001dawnZ5dC2L!a\f\u0017\u0003\u001b1{7-\u00197SK2\fG/[8o\u0011\u0015\t$\u00011\u00013\u0003)\u0019w\u000e\\;n]:\u000bW.\u001a\t\u0003gqr!\u0001\u000e\u001e\u0011\u0005UBT\"\u0001\u001c\u000b\u0005]\u001a\u0012A\u0002\u001fs_>$hHC\u0001:\u0003\u0015\u00198-\u00197b\u0013\tY\u0004(\u0001\u0004Qe\u0016$WMZ\u0005\u0003{y\u0012aa\u0015;sS:<'BA\u001e9)\r\u0011\u0003)\u0012\u0005\u0006\u0003\u000e\u0001\rAQ\u0001\u0005a2\fg\u000e\u0005\u0002,\u0007&\u0011A\t\f\u0002\f\u0019><\u0017nY1m!2\fg\u000eC\u00032\u0007\u0001\u0007!'A\twKJLg-_\"p]N$(/Y5oiN$2\u0001\u0013'R!\tI%*D\u00019\u0013\tY\u0005H\u0001\u0003V]&$\b\"B'\u0005\u0001\u0004q\u0015!\u00024pk:$\u0007CA\u0012P\u0013\t\u0001FEA\u0007FqB\u0014Xm]:j_:\u001cV\r\u001e\u0005\u0006%\u0012\u0001\rAT\u0001\tKb\u0004Xm\u0019;fI\u0006\u00012-Y:u/&$\b\u000eV5nKj{g.\u001a\u000b\u0004+bS\u0006CA\u0012W\u0013\t9FE\u0001\u0003DCN$\b\"B-\u0006\u0001\u0004\u0011\u0013\u0001B3yaJDQaW\u0003A\u0002q\u000b\u0001\u0002Z1uCRK\b/\u001a\t\u0003;\u0002l\u0011A\u0018\u0006\u0003?.\tQ\u0001^=qKNL!!\u00190\u0003\u0011\u0011\u000bG/\u0019+za\u0016\u0004")
public class ConstraintPropagationSuite
extends SparkFunSuite
implements PlanTest {
    private String sparkHome;
    private volatile boolean bitmap$0;

    @Override
    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$(this, plan);
    }

    @Override
    public LogicalPlan rewriteNameFromAttrNullability(LogicalPlan plan) {
        return PlanTestBase.rewriteNameFromAttrNullability$(this, plan);
    }

    @Override
    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$(this, plan);
    }

    @Override
    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public boolean comparePlans$default$3() {
        return PlanTestBase.comparePlans$default$3$(this);
    }

    @Override
    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$(this, e1, e2);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$(this, pairs, f);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression buildBalancedPredicate(Seq<Expression> expressions, Function2<Expression, Expression, Expression> op) {
        return PredicateHelper.buildBalancedPredicate$((PredicateHelper)this, expressions, op);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public boolean isNullIntolerant(Expression expr) {
        return PredicateHelper.isNullIntolerant$((PredicateHelper)this, (Expression)expr);
    }

    public Seq<Attribute> outputWithNullability(Seq<Attribute> output, Seq<ExprId> nonNullAttrExprIds) {
        return PredicateHelper.outputWithNullability$((PredicateHelper)this, output, nonNullAttrExprIds);
    }

    public boolean isLikelySelective(Expression e) {
        return PredicateHelper.isLikelySelective$((PredicateHelper)this, (Expression)e);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Seq<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    private String sparkHome$lzycompute() {
        ConstraintPropagationSuite constraintPropagationSuite = this;
        synchronized (constraintPropagationSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        return !this.bitmap$0 ? this.sparkHome$lzycompute() : this.sparkHome;
    }

    private Expression resolveColumn(LocalRelation tr, String columnName) {
        return this.resolveColumn(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)tr).analyze(), columnName);
    }

    private Expression resolveColumn(LogicalPlan plan, String columnName) {
        return (Expression)plan.resolveQuoted(columnName, package$.MODULE$.caseInsensitiveResolution()).get();
    }

    private void verifyConstraints(ExpressionSet found, ExpressionSet expected) {
        ExpressionSet missing = expected.$minus$minus((GenTraversableOnce)found);
        ExpressionSet extra = found.$minus$minus((GenTraversableOnce)expected);
        if (missing.nonEmpty() || extra.nonEmpty()) {
            throw this.fail(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(187).append("\n           |== FAIL: Constraints do not match ===\n           |Found: ").append(found.mkString(",")).append("\n           |Expected: ").append(expected.mkString(",")).append("\n           |== Result ==\n           |Missing: ").append((Object)(missing.isEmpty() ? "N/A" : missing.mkString(","))).append("\n           |Found but not expected: ").append((Object)(extra.isEmpty() ? "N/A" : extra.mkString(","))).append("\n         ").toString())).stripMargin(), new Position("ConstraintPropagationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
        }
    }

    private Cast castWithTimeZone(Expression expr, DataType dataType) {
        return new Cast(expr, dataType, Option$.MODULE$.apply((Object)TimeZone.getDefault().getID()), Cast$.MODULE$.apply$default$4());
    }

    public ConstraintPropagationSuite() {
        AliasHelper.$init$((AliasHelper)this);
        PredicateHelper.$init$((PredicateHelper)this);
        SQLHelper.$init$(this);
        SQLConfHelper.$init$((SQLConfHelper)this);
        PlanTestBase.$init$(this);
        this.test("propagating constraints in filters", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LocalRelation tr = LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).string(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).int()}));
            ExpressionSet $org_scalatest_assert_macro_left = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)tr).analyze().constraints();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ConstraintPropagationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
            ExpressionSet $org_scalatest_assert_macro_left2 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)tr).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(10)))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).attr(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).attr()}))).analyze().constraints();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ConstraintPropagationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
            this.verifyConstraints(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)tr).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(10)))).analyze().constraints(), ExpressionSet$.MODULE$.apply((TraversableOnce)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression(this.resolveColumn(tr, "a")).$greater((Expression)package.expressions$.MODULE$.intToLiteral(10)), (List)new .colon.colon((Object)new IsNotNull(this.resolveColumn(tr, "a")), (List)Nil$.MODULE$))));
            this.verifyConstraints(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)tr).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(10)))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).attr(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).attr()}))).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).attr()).$eq$bang$eq((Expression)package.expressions$.MODULE$.intToLiteral(100)))).analyze().constraints(), ExpressionSet$.MODULE$.apply((TraversableOnce)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression(this.resolveColumn(tr, "a")).$greater((Expression)package.expressions$.MODULE$.intToLiteral(10)), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression(this.resolveColumn(tr, "c")).$eq$bang$eq((Expression)package.expressions$.MODULE$.intToLiteral(100)), (List)new .colon.colon((Object)new IsNotNull(this.resolveColumn(tr, "a")), (List)new .colon.colon((Object)new IsNotNull(this.resolveColumn(tr, "c")), (List)Nil$.MODULE$))))));
        }, new Position("ConstraintPropagationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
        this.test("propagating constraints in aggregate", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LocalRelation tr = LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).string(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).int()}));
            ExpressionSet $org_scalatest_assert_macro_left = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)tr).analyze().constraints();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ConstraintPropagationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
            LogicalPlan aliasedRelation = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)tr).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(10))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).attr()).$less((Expression)package.expressions$.MODULE$.intToLiteral(5))))).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).as("c1"), (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.count((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.count$default$2())).as("a3")}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c1")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a3"))}))).analyze();
            this.verifyConstraints(package.plans$.MODULE$.DslLogicalPlan(aliasedRelation).analyze().constraints(), ExpressionSet$.MODULE$.apply((TraversableOnce)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression(this.resolveColumn(package.plans$.MODULE$.DslLogicalPlan(aliasedRelation).analyze(), "c1")).$greater((Expression)package.expressions$.MODULE$.intToLiteral(10)), (List)new .colon.colon((Object)new IsNotNull(this.resolveColumn(package.plans$.MODULE$.DslLogicalPlan(aliasedRelation).analyze(), "c1")), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression(this.resolveColumn(package.plans$.MODULE$.DslLogicalPlan(aliasedRelation).analyze(), "a")).$less((Expression)package.expressions$.MODULE$.intToLiteral(5)), (List)new .colon.colon((Object)new IsNotNull(this.resolveColumn(package.plans$.MODULE$.DslLogicalPlan(aliasedRelation).analyze(), "a")), (List)new .colon.colon((Object)new IsNotNull(this.resolveColumn(package.plans$.MODULE$.DslLogicalPlan(aliasedRelation).analyze(), "a3")), (List)Nil$.MODULE$)))))));
        }, new Position("ConstraintPropagationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
        this.test("propagating constraints in expand", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LocalRelation tr = LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).int()}));
            ExpressionSet $org_scalatest_assert_macro_left = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)tr).analyze().constraints();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ConstraintPropagationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
            LogicalPlan notNullRelation = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)tr).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(10))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).attr()).$less((Expression)package.expressions$.MODULE$.intToLiteral(5)))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(2))));
            this.verifyConstraints(package.plans$.MODULE$.DslLogicalPlan(notNullRelation).analyze().constraints(), ExpressionSet$.MODULE$.apply((TraversableOnce)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression(this.resolveColumn(package.plans$.MODULE$.DslLogicalPlan(notNullRelation).analyze(), "c")).$greater((Expression)package.expressions$.MODULE$.intToLiteral(10)), (List)new .colon.colon((Object)new IsNotNull(this.resolveColumn(package.plans$.MODULE$.DslLogicalPlan(notNullRelation).analyze(), "c")), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression(this.resolveColumn(package.plans$.MODULE$.DslLogicalPlan(notNullRelation).analyze(), "a")).$less((Expression)package.expressions$.MODULE$.intToLiteral(5)), (List)new .colon.colon((Object)new IsNotNull(this.resolveColumn(package.plans$.MODULE$.DslLogicalPlan(notNullRelation).analyze(), "a")), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression(this.resolveColumn(package.plans$.MODULE$.DslLogicalPlan(notNullRelation).analyze(), "b")).$greater((Expression)package.expressions$.MODULE$.intToLiteral(2)), (List)new .colon.colon((Object)new IsNotNull(this.resolveColumn(package.plans$.MODULE$.DslLogicalPlan(notNullRelation).analyze(), "b")), (List)Nil$.MODULE$))))))));
            Expand expand = new Expand((Seq)new .colon.colon((Object)((Seq)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c")), (List)new .colon.colon((Object)Literal$.MODULE$.create(null, (DataType)StringType$.MODULE$), (List)new .colon.colon((Object)package.expressions$.MODULE$.intToLiteral(1), (List)Nil$.MODULE$)))), (List)new .colon.colon((Object)((Seq)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c")), (List)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (List)new .colon.colon((Object)package.expressions$.MODULE$.intToLiteral(2), (List)Nil$.MODULE$)))), (List)Nil$.MODULE$)), (Seq)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c")), (List)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "gid")).int(), (List)Nil$.MODULE$))), (LogicalPlan)new Project((Seq)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (List)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c")), (List)Nil$.MODULE$)), notNullRelation));
            this.verifyConstraints(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)expand).analyze().constraints(), ExpressionSet$.MODULE$.apply((TraversableOnce)Nil$.MODULE$));
        }, new Position("ConstraintPropagationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
        this.test("propagating constraints in aliases", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LocalRelation tr = LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).string(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).int()}));
            ExpressionSet $org_scalatest_assert_macro_left = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)tr).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(10)))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).as((Symbol)SymbolLiteral.bootstrap("apply", "x")), (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).as((Symbol)SymbolLiteral.bootstrap("apply", "y"))}))).analyze().constraints();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ConstraintPropagationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
            LogicalPlan aliasedRelation = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)tr).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(10)))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).as((Symbol)SymbolLiteral.bootstrap("apply", "x")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).as((Symbol)SymbolLiteral.bootstrap("apply", "y")), (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).as((Symbol)SymbolLiteral.bootstrap("apply", "z"))}));
            this.verifyConstraints(package.plans$.MODULE$.DslLogicalPlan(aliasedRelation).analyze().constraints(), ExpressionSet$.MODULE$.apply((TraversableOnce)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression(this.resolveColumn(package.plans$.MODULE$.DslLogicalPlan(aliasedRelation).analyze(), "x")).$greater((Expression)package.expressions$.MODULE$.intToLiteral(10)), (List)new .colon.colon((Object)new IsNotNull(this.resolveColumn(package.plans$.MODULE$.DslLogicalPlan(aliasedRelation).analyze(), "x")), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression(this.resolveColumn(package.plans$.MODULE$.DslLogicalPlan(aliasedRelation).analyze(), "b")).$less$eq$greater(this.resolveColumn(package.plans$.MODULE$.DslLogicalPlan(aliasedRelation).analyze(), "y")), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression(this.resolveColumn(package.plans$.MODULE$.DslLogicalPlan(aliasedRelation).analyze(), "z")).$less$eq$greater(this.resolveColumn(package.plans$.MODULE$.DslLogicalPlan(aliasedRelation).analyze(), "x")), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression(this.resolveColumn(package.plans$.MODULE$.DslLogicalPlan(aliasedRelation).analyze(), "z")).$greater((Expression)package.expressions$.MODULE$.intToLiteral(10)), (List)new .colon.colon((Object)new IsNotNull(this.resolveColumn(package.plans$.MODULE$.DslLogicalPlan(aliasedRelation).analyze(), "z")), (List)Nil$.MODULE$))))))));
            LogicalPlan multiAlias = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)tr).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).$plus((Expression)package.expressions$.MODULE$.intToLiteral(10))))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).as((Symbol)SymbolLiteral.bootstrap("apply", "x")), (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).as((Symbol)SymbolLiteral.bootstrap("apply", "y"))}));
            this.verifyConstraints(package.plans$.MODULE$.DslLogicalPlan(multiAlias).analyze().constraints(), ExpressionSet$.MODULE$.apply((TraversableOnce)new .colon.colon((Object)new IsNotNull(this.resolveColumn(package.plans$.MODULE$.DslLogicalPlan(multiAlias).analyze(), "x")), (List)new .colon.colon((Object)new IsNotNull(this.resolveColumn(package.plans$.MODULE$.DslLogicalPlan(multiAlias).analyze(), "y")), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression(this.resolveColumn(package.plans$.MODULE$.DslLogicalPlan(multiAlias).analyze(), "x")).$eq$eq$eq(package.expressions$.MODULE$.DslExpression(this.resolveColumn(package.plans$.MODULE$.DslLogicalPlan(multiAlias).analyze(), "y")).$plus((Expression)package.expressions$.MODULE$.intToLiteral(10))), (List)Nil$.MODULE$)))));
        }, new Position("ConstraintPropagationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
        this.test("propagating constraints in union", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LocalRelation tr1 = LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).int()}));
            LocalRelation tr2 = LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "d")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "e")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "f")).int()}));
            LocalRelation tr3 = LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "g")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "h")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "i")).int()}));
            ExpressionSet $org_scalatest_assert_macro_left = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)tr1).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(10)))).union(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)tr2).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "e")).attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(10)))).union(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)tr3).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "i")).attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(10)))))).analyze().constraints();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ConstraintPropagationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
            this.verifyConstraints(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)tr1).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(10)))).union(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)tr2).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "d")).attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(10)))).union(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)tr3).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "g")).attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(10)))))).analyze().constraints(), ExpressionSet$.MODULE$.apply((TraversableOnce)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression(this.resolveColumn(tr1, "a")).$greater((Expression)package.expressions$.MODULE$.intToLiteral(10)), (List)new .colon.colon((Object)new IsNotNull(this.resolveColumn(tr1, "a")), (List)Nil$.MODULE$))));
            Expression a = this.resolveColumn(tr1, "a");
            this.verifyConstraints(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)tr1).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(10)))).union(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)tr2).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "d")).attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(11))))).analyze().constraints(), ExpressionSet$.MODULE$.apply((TraversableOnce)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression(a).$greater((Expression)package.expressions$.MODULE$.intToLiteral(10))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression(a).$greater((Expression)package.expressions$.MODULE$.intToLiteral(11))), (List)new .colon.colon((Object)new IsNotNull(a), (List)Nil$.MODULE$))));
            Expression b = this.resolveColumn(tr1, "b");
            this.verifyConstraints(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)tr1).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(10))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).attr()).$less((Expression)package.expressions$.MODULE$.intToLiteral(10))))).union(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)tr2).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "d")).attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(11))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "e")).attr()).$less((Expression)package.expressions$.MODULE$.intToLiteral(11)))))).analyze().constraints(), ExpressionSet$.MODULE$.apply((TraversableOnce)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression(a).$greater((Expression)package.expressions$.MODULE$.intToLiteral(10))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression(a).$greater((Expression)package.expressions$.MODULE$.intToLiteral(11))), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression(b).$less((Expression)package.expressions$.MODULE$.intToLiteral(10))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression(b).$less((Expression)package.expressions$.MODULE$.intToLiteral(11))), (List)new .colon.colon((Object)new IsNotNull(a), (List)new .colon.colon((Object)new IsNotNull(b), (List)Nil$.MODULE$))))));
        }, new Position("ConstraintPropagationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
        this.test("propagating constraints in intersect", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LocalRelation tr1 = LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).int()}));
            LocalRelation tr2 = LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).int()}));
            this.verifyConstraints(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)tr1).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(10)))).intersect(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)tr2).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).attr()).$less((Expression)package.expressions$.MODULE$.intToLiteral(100))), false)).analyze().constraints(), ExpressionSet$.MODULE$.apply((TraversableOnce)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression(this.resolveColumn(tr1, "a")).$greater((Expression)package.expressions$.MODULE$.intToLiteral(10)), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression(this.resolveColumn(tr1, "b")).$less((Expression)package.expressions$.MODULE$.intToLiteral(100)), (List)new .colon.colon((Object)new IsNotNull(this.resolveColumn(tr1, "a")), (List)new .colon.colon((Object)new IsNotNull(this.resolveColumn(tr1, "b")), (List)Nil$.MODULE$))))));
        }, new Position("ConstraintPropagationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
        this.test("propagating constraints in except", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LocalRelation tr1 = LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).int()}));
            LocalRelation tr2 = LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).int()}));
            this.verifyConstraints(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)tr1).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(10)))).except(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)tr2).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).attr()).$less((Expression)package.expressions$.MODULE$.intToLiteral(100))), false)).analyze().constraints(), ExpressionSet$.MODULE$.apply((TraversableOnce)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression(this.resolveColumn(tr1, "a")).$greater((Expression)package.expressions$.MODULE$.intToLiteral(10)), (List)new .colon.colon((Object)new IsNotNull(this.resolveColumn(tr1, "a")), (List)Nil$.MODULE$))));
        }, new Position("ConstraintPropagationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 198));
        this.test("propagating constraints in inner join", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan tr1 = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).int()}))).subquery((Symbol)SymbolLiteral.bootstrap("apply", "tr1"));
            LogicalPlan tr2 = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "d")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "e")).int()}))).subquery((Symbol)SymbolLiteral.bootstrap("apply", "tr2"));
            this.verifyConstraints(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(tr1).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(10)))).join(package.plans$.MODULE$.DslLogicalPlan(tr2).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "d")).attr()).$less((Expression)package.expressions$.MODULE$.intToLiteral(100))), (JoinType)Inner$.MODULE$, (Option)new Some((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("tr1.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("tr2.a").attr())))).analyze().constraints(), ExpressionSet$.MODULE$.apply((TraversableOnce)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression((Expression)tr1.resolveQuoted("a", package$.MODULE$.caseInsensitiveResolution()).get()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(10)), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression((Expression)tr2.resolveQuoted("d", package$.MODULE$.caseInsensitiveResolution()).get()).$less((Expression)package.expressions$.MODULE$.intToLiteral(100)), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression((Expression)tr1.resolveQuoted("a", package$.MODULE$.caseInsensitiveResolution()).get()).$eq$eq$eq((Expression)tr2.resolveQuoted("a", package$.MODULE$.caseInsensitiveResolution()).get()), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression((Expression)tr2.resolveQuoted("a", package$.MODULE$.caseInsensitiveResolution()).get()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(10)), (List)new .colon.colon((Object)new IsNotNull((Expression)tr2.resolveQuoted("a", package$.MODULE$.caseInsensitiveResolution()).get()), (List)new .colon.colon((Object)new IsNotNull((Expression)tr1.resolveQuoted("a", package$.MODULE$.caseInsensitiveResolution()).get()), (List)new .colon.colon((Object)new IsNotNull((Expression)tr2.resolveQuoted("d", package$.MODULE$.caseInsensitiveResolution()).get()), (List)Nil$.MODULE$)))))))));
        }, new Position("ConstraintPropagationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 209));
        this.test("propagating constraints in left-semi join", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan tr1 = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).int()}))).subquery((Symbol)SymbolLiteral.bootstrap("apply", "tr1"));
            LogicalPlan tr2 = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "d")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "e")).int()}))).subquery((Symbol)SymbolLiteral.bootstrap("apply", "tr2"));
            this.verifyConstraints(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(tr1).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(10)))).join(package.plans$.MODULE$.DslLogicalPlan(tr2).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "d")).attr()).$less((Expression)package.expressions$.MODULE$.intToLiteral(100))), (JoinType)LeftSemi$.MODULE$, (Option)new Some((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("tr1.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("tr2.a").attr())))).analyze().constraints(), ExpressionSet$.MODULE$.apply((TraversableOnce)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression((Expression)tr1.resolveQuoted("a", package$.MODULE$.caseInsensitiveResolution()).get()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(10)), (List)new .colon.colon((Object)new IsNotNull((Expression)tr1.resolveQuoted("a", package$.MODULE$.caseInsensitiveResolution()).get()), (List)Nil$.MODULE$))));
        }, new Position("ConstraintPropagationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 226));
        this.test("propagating constraints in left-outer join", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan tr1 = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).int()}))).subquery((Symbol)SymbolLiteral.bootstrap("apply", "tr1"));
            LogicalPlan tr2 = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "d")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "e")).int()}))).subquery((Symbol)SymbolLiteral.bootstrap("apply", "tr2"));
            this.verifyConstraints(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(tr1).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(10)))).join(package.plans$.MODULE$.DslLogicalPlan(tr2).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "d")).attr()).$less((Expression)package.expressions$.MODULE$.intToLiteral(100))), (JoinType)LeftOuter$.MODULE$, (Option)new Some((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("tr1.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("tr2.a").attr())))).analyze().constraints(), ExpressionSet$.MODULE$.apply((TraversableOnce)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression((Expression)tr1.resolveQuoted("a", package$.MODULE$.caseInsensitiveResolution()).get()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(10)), (List)new .colon.colon((Object)new IsNotNull((Expression)tr1.resolveQuoted("a", package$.MODULE$.caseInsensitiveResolution()).get()), (List)Nil$.MODULE$))));
        }, new Position("ConstraintPropagationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 237));
        this.test("propagating constraints in right-outer join", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan tr1 = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).int()}))).subquery((Symbol)SymbolLiteral.bootstrap("apply", "tr1"));
            LogicalPlan tr2 = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "d")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "e")).int()}))).subquery((Symbol)SymbolLiteral.bootstrap("apply", "tr2"));
            this.verifyConstraints(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(tr1).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(10)))).join(package.plans$.MODULE$.DslLogicalPlan(tr2).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "d")).attr()).$less((Expression)package.expressions$.MODULE$.intToLiteral(100))), (JoinType)RightOuter$.MODULE$, (Option)new Some((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("tr1.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("tr2.a").attr())))).analyze().constraints(), ExpressionSet$.MODULE$.apply((TraversableOnce)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression((Expression)tr2.resolveQuoted("d", package$.MODULE$.caseInsensitiveResolution()).get()).$less((Expression)package.expressions$.MODULE$.intToLiteral(100)), (List)new .colon.colon((Object)new IsNotNull((Expression)tr2.resolveQuoted("d", package$.MODULE$.caseInsensitiveResolution()).get()), (List)Nil$.MODULE$))));
        }, new Position("ConstraintPropagationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 248));
        this.test("propagating constraints in full-outer join", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            LogicalPlan tr1 = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).int()}))).subquery((Symbol)SymbolLiteral.bootstrap("apply", "tr1"));
            LogicalPlan tr2 = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "d")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "e")).int()}))).subquery((Symbol)SymbolLiteral.bootstrap("apply", "tr2"));
            ExpressionSet $org_scalatest_assert_macro_left = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(tr1).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(10)))).join(package.plans$.MODULE$.DslLogicalPlan(tr2).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "d")).attr()).$less((Expression)package.expressions$.MODULE$.intToLiteral(100))), (JoinType)FullOuter$.MODULE$, (Option)new Some((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("tr1.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("tr2.a").attr())))).analyze().constraints();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ConstraintPropagationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 262));
        }, new Position("ConstraintPropagationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 259));
        this.test("infer additional constraints in filters", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LocalRelation tr = LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).int()}));
            this.verifyConstraints(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)tr).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(10))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).attr())))).analyze().constraints(), ExpressionSet$.MODULE$.apply((TraversableOnce)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression(this.resolveColumn(tr, "a")).$greater((Expression)package.expressions$.MODULE$.intToLiteral(10)), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression(this.resolveColumn(tr, "b")).$greater((Expression)package.expressions$.MODULE$.intToLiteral(10)), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression(this.resolveColumn(tr, "a")).$eq$eq$eq(this.resolveColumn(tr, "b")), (List)new .colon.colon((Object)new IsNotNull(this.resolveColumn(tr, "a")), (List)new .colon.colon((Object)new IsNotNull(this.resolveColumn(tr, "b")), (List)Nil$.MODULE$)))))));
        }, new Position("ConstraintPropagationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 267));
        this.test("infer constraints on cast", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LocalRelation tr = LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).long(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "d")).long(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "e")).int()}));
            this.verifyConstraints(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)tr).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).attr())).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).attr()).$plus((Expression)package.expressions$.MODULE$.intToLiteral(100))).$greater((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "d")).attr()))).$amp$amp((Expression)new IsNotNull((Expression)new Cast((Expression)new Cast(this.resolveColumn(tr, "e"), (DataType)LongType$.MODULE$, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4()), (DataType)LongType$.MODULE$, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4()))))).analyze().constraints(), ExpressionSet$.MODULE$.apply((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Predicate[]{package.expressions$.MODULE$.DslExpression((Expression)this.castWithTimeZone(this.resolveColumn(tr, "a"), (DataType)LongType$.MODULE$)).$eq$eq$eq(this.resolveColumn(tr, "b")), package.expressions$.MODULE$.DslExpression((Expression)this.castWithTimeZone(package.expressions$.MODULE$.DslExpression(this.resolveColumn(tr, "c")).$plus((Expression)package.expressions$.MODULE$.intToLiteral(100)), (DataType)LongType$.MODULE$)).$greater(this.resolveColumn(tr, "d")), new IsNotNull(this.resolveColumn(tr, "a")), new IsNotNull(this.resolveColumn(tr, "b")), new IsNotNull(this.resolveColumn(tr, "c")), new IsNotNull(this.resolveColumn(tr, "d")), new IsNotNull(this.resolveColumn(tr, "e")), new IsNotNull((Expression)this.castWithTimeZone((Expression)this.castWithTimeZone(this.resolveColumn(tr, "e"), (DataType)LongType$.MODULE$), (DataType)LongType$.MODULE$))}))));
        }, new Position("ConstraintPropagationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 280));
        this.test("infer isnotnull constraints from compound expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LocalRelation tr = LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).long(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "d")).long(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "e")).int()}));
            this.verifyConstraints(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)tr).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).attr()).$plus((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).attr())).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).attr())).$amp$amp((Expression)new IsNotNull((Expression)new Cast((Expression)new Cast((Expression)new Cast(this.resolveColumn(tr, "e"), (DataType)LongType$.MODULE$, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4()), (DataType)LongType$.MODULE$, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4()), (DataType)LongType$.MODULE$, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4()))))).analyze().constraints(), ExpressionSet$.MODULE$.apply((TraversableOnce)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)this.castWithTimeZone(this.resolveColumn(tr, "a"), (DataType)LongType$.MODULE$)).$plus(this.resolveColumn(tr, "b"))).$eq$eq$eq((Expression)this.castWithTimeZone(this.resolveColumn(tr, "c"), (DataType)LongType$.MODULE$)), (List)new .colon.colon((Object)new IsNotNull(this.resolveColumn(tr, "a")), (List)new .colon.colon((Object)new IsNotNull(this.resolveColumn(tr, "b")), (List)new .colon.colon((Object)new IsNotNull(this.resolveColumn(tr, "c")), (List)new .colon.colon((Object)new IsNotNull(this.resolveColumn(tr, "e")), (List)new .colon.colon((Object)new IsNotNull((Expression)this.castWithTimeZone((Expression)this.castWithTimeZone((Expression)this.castWithTimeZone(this.resolveColumn(tr, "e"), (DataType)LongType$.MODULE$), (DataType)LongType$.MODULE$), (DataType)LongType$.MODULE$)), (List)Nil$.MODULE$))))))));
            this.verifyConstraints(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)tr).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).attr()).$times((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).attr())).$plus((Expression)package.expressions$.MODULE$.intToLiteral(100))).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).attr())).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "d")).$div((Expression)package.expressions$.MODULE$.intToLiteral(10))).$eq$eq$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "e")))))).analyze().constraints(), ExpressionSet$.MODULE$.apply((TraversableOnce)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)this.castWithTimeZone(this.resolveColumn(tr, "a"), (DataType)LongType$.MODULE$)).$times(this.resolveColumn(tr, "b"))).$plus((Expression)this.castWithTimeZone((Expression)package.expressions$.MODULE$.intToLiteral(100), (DataType)LongType$.MODULE$))).$eq$eq$eq((Expression)this.castWithTimeZone(this.resolveColumn(tr, "c"), (DataType)LongType$.MODULE$)), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)this.castWithTimeZone(this.resolveColumn(tr, "d"), (DataType)DoubleType$.MODULE$)).$div((Expression)this.castWithTimeZone((Expression)package.expressions$.MODULE$.intToLiteral(10), (DataType)DoubleType$.MODULE$))).$eq$eq$eq((Expression)this.castWithTimeZone(this.resolveColumn(tr, "e"), (DataType)DoubleType$.MODULE$)), (List)new .colon.colon((Object)new IsNotNull(this.resolveColumn(tr, "a")), (List)new .colon.colon((Object)new IsNotNull(this.resolveColumn(tr, "b")), (List)new .colon.colon((Object)new IsNotNull(this.resolveColumn(tr, "c")), (List)new .colon.colon((Object)new IsNotNull(this.resolveColumn(tr, "d")), (List)new .colon.colon((Object)new IsNotNull(this.resolveColumn(tr, "e")), (List)Nil$.MODULE$)))))))));
            this.verifyConstraints(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)tr).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).attr()).$times((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).attr())).$minus((Expression)package.expressions$.MODULE$.intToLiteral(10))).$greater$eq((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).attr())).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "d")).$div((Expression)package.expressions$.MODULE$.intToLiteral(10))).$less((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "e")))))).analyze().constraints(), ExpressionSet$.MODULE$.apply((TraversableOnce)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)this.castWithTimeZone(this.resolveColumn(tr, "a"), (DataType)LongType$.MODULE$)).$times(this.resolveColumn(tr, "b"))).$minus((Expression)this.castWithTimeZone((Expression)package.expressions$.MODULE$.intToLiteral(10), (DataType)LongType$.MODULE$))).$greater$eq((Expression)this.castWithTimeZone(this.resolveColumn(tr, "c"), (DataType)LongType$.MODULE$)), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)this.castWithTimeZone(this.resolveColumn(tr, "d"), (DataType)DoubleType$.MODULE$)).$div((Expression)this.castWithTimeZone((Expression)package.expressions$.MODULE$.intToLiteral(10), (DataType)DoubleType$.MODULE$))).$less((Expression)this.castWithTimeZone(this.resolveColumn(tr, "e"), (DataType)DoubleType$.MODULE$)), (List)new .colon.colon((Object)new IsNotNull(this.resolveColumn(tr, "a")), (List)new .colon.colon((Object)new IsNotNull(this.resolveColumn(tr, "b")), (List)new .colon.colon((Object)new IsNotNull(this.resolveColumn(tr, "c")), (List)new .colon.colon((Object)new IsNotNull(this.resolveColumn(tr, "d")), (List)new .colon.colon((Object)new IsNotNull(this.resolveColumn(tr, "e")), (List)Nil$.MODULE$)))))))));
            this.verifyConstraints(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)tr).where((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).attr()).$plus((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).attr())).$minus(package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).attr()).$times((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "d")).attr()))).$greater(package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "e")).attr()).$times((Expression)package.expressions$.MODULE$.intToLiteral(1000))))).analyze().constraints(), ExpressionSet$.MODULE$.apply((TraversableOnce)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)this.castWithTimeZone(this.resolveColumn(tr, "a"), (DataType)LongType$.MODULE$)).$plus(this.resolveColumn(tr, "b"))).$minus(package.expressions$.MODULE$.DslExpression((Expression)this.castWithTimeZone(this.resolveColumn(tr, "c"), (DataType)LongType$.MODULE$)).$times(this.resolveColumn(tr, "d")))).$greater((Expression)this.castWithTimeZone(package.expressions$.MODULE$.DslExpression(this.resolveColumn(tr, "e")).$times((Expression)package.expressions$.MODULE$.intToLiteral(1000)), (DataType)LongType$.MODULE$)), (List)new .colon.colon((Object)new IsNotNull(this.resolveColumn(tr, "a")), (List)new .colon.colon((Object)new IsNotNull(this.resolveColumn(tr, "b")), (List)new .colon.colon((Object)new IsNotNull(this.resolveColumn(tr, "c")), (List)new .colon.colon((Object)new IsNotNull(this.resolveColumn(tr, "d")), (List)new .colon.colon((Object)new IsNotNull(this.resolveColumn(tr, "e")), (List)Nil$.MODULE$))))))));
            this.verifyConstraints(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)tr).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).attr())).$amp$amp((Expression)new IsNotNull((Expression)new IsNotNull(this.resolveColumn(tr, "b")))))).analyze().constraints(), ExpressionSet$.MODULE$.apply((TraversableOnce)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression(this.resolveColumn(tr, "a")).$eq$eq$eq(this.resolveColumn(tr, "c")), (List)new .colon.colon((Object)new IsNotNull((Expression)new IsNotNull(this.resolveColumn(tr, "b"))), (List)new .colon.colon((Object)new IsNotNull(this.resolveColumn(tr, "a")), (List)new .colon.colon((Object)new IsNotNull(this.resolveColumn(tr, "c")), (List)Nil$.MODULE$))))));
            this.verifyConstraints(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)tr).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1))).$amp$amp((Expression)new IsNotNull(this.resolveColumn(tr, "b")))).$amp$amp((Expression)new IsNotNull(this.resolveColumn(tr, "c"))))).analyze().constraints(), ExpressionSet$.MODULE$.apply((TraversableOnce)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression(this.resolveColumn(tr, "a")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)), (List)new .colon.colon((Object)new IsNotNull(this.resolveColumn(tr, "c")), (List)new .colon.colon((Object)new IsNotNull(this.resolveColumn(tr, "a")), (List)new .colon.colon((Object)new IsNotNull(this.resolveColumn(tr, "b")), (List)Nil$.MODULE$))))));
        }, new Position("ConstraintPropagationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 297));
        this.test("infer IsNotNull constraints from non-nullable attributes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Attribute[] attributeArray = new Attribute[3];
            attributeArray[0] = package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int();
            String x$1 = "b";
            IntegerType$ x$2 = IntegerType$.MODULE$;
            boolean x$3 = false;
            Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, (DataType)x$2, x$3, x$4);
            Seq x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, (DataType)x$2, x$3, x$4);
            attributeArray[1] = new AttributeReference(x$1, (DataType)x$2, x$3, x$4, x$5, x$6);
            String x$7 = "c";
            StringType$ x$8 = StringType$.MODULE$;
            boolean x$9 = false;
            Metadata x$10 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$11 = AttributeReference$.MODULE$.apply$default$5(x$7, (DataType)x$8, x$9, x$10);
            Seq x$12 = AttributeReference$.MODULE$.apply$default$6(x$7, (DataType)x$8, x$9, x$10);
            attributeArray[2] = new AttributeReference(x$7, (DataType)x$8, x$9, x$10, x$11, x$12);
            LocalRelation tr = LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])attributeArray));
            this.verifyConstraints(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)tr).analyze().constraints(), ExpressionSet$.MODULE$.apply((TraversableOnce)new .colon.colon((Object)new IsNotNull(this.resolveColumn(tr, "b")), (List)new .colon.colon((Object)new IsNotNull(this.resolveColumn(tr, "c")), (List)Nil$.MODULE$))));
        }, new Position("ConstraintPropagationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 377));
        this.test("not infer non-deterministic constraints", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LocalRelation tr = LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).string(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).int()}));
            this.verifyConstraints(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)tr).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).attr()).$eq$eq$eq((Expression)Rand$.MODULE$.apply(0L)))).analyze().constraints(), ExpressionSet$.MODULE$.apply((TraversableOnce)new .colon.colon((Object)new IsNotNull(this.resolveColumn(tr, "a")), (List)Nil$.MODULE$)));
            this.verifyConstraints(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)tr).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).attr()).$eq$eq$eq((Expression)new InputFileName()))).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).attr()).$eq$bang$eq((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).attr()))).analyze().constraints(), ExpressionSet$.MODULE$.apply((TraversableOnce)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression(this.resolveColumn(tr, "a")).$eq$bang$eq(this.resolveColumn(tr, "c")), (List)new .colon.colon((Object)new IsNotNull(this.resolveColumn(tr, "a")), (List)new .colon.colon((Object)new IsNotNull(this.resolveColumn(tr, "c")), (List)Nil$.MODULE$)))));
        }, new Position("ConstraintPropagationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 385));
        this.test("enable/disable constraint propagation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LocalRelation tr = LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).string(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).int()}));
            LogicalPlan filterRelation = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)tr).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(10)));
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CONSTRAINT_PROPAGATION_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                ExpressionSet $org_scalatest_assert_macro_left = package.plans$.MODULE$.DslLogicalPlan(filterRelation).analyze().constraints();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "nonEmpty", $org_scalatest_assert_macro_left.nonEmpty(), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ConstraintPropagationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 407));
            });
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CONSTRAINT_PROPAGATION_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                ExpressionSet $org_scalatest_assert_macro_left = package.plans$.MODULE$.DslLogicalPlan(filterRelation).analyze().constraints();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ConstraintPropagationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 411));
            });
            LogicalPlan aliasedRelation = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)tr).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(10))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).attr()).$less((Expression)package.expressions$.MODULE$.intToLiteral(5))))).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).as("c1"), (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.count((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.count$default$2())).as("a3")}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c1")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a3"))}));
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CONSTRAINT_PROPAGATION_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                ExpressionSet $org_scalatest_assert_macro_left = package.plans$.MODULE$.DslLogicalPlan(aliasedRelation).analyze().constraints();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "nonEmpty", $org_scalatest_assert_macro_left.nonEmpty(), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ConstraintPropagationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 418));
            });
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CONSTRAINT_PROPAGATION_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                ExpressionSet $org_scalatest_assert_macro_left = package.plans$.MODULE$.DslLogicalPlan(aliasedRelation).analyze().constraints();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ConstraintPropagationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 422));
            });
        }, new Position("ConstraintPropagationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 402));
    }
}

