/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.optimizer;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeMap$;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.optimizer.BuildLeft$;
import org.apache.spark.sql.catalyst.optimizer.BuildRight$;
import org.apache.spark.sql.catalyst.optimizer.BuildSide;
import org.apache.spark.sql.catalyst.optimizer.JoinSelectionHelper;
import org.apache.spark.sql.catalyst.plans.Inner$;
import org.apache.spark.sql.catalyst.plans.JoinType;
import org.apache.spark.sql.catalyst.plans.PlanTest;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.BROADCAST$;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat;
import org.apache.spark.sql.catalyst.plans.logical.HintInfo;
import org.apache.spark.sql.catalyst.plans.logical.Join;
import org.apache.spark.sql.catalyst.plans.logical.JoinHint;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.NO_BROADCAST_HASH$;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.plans.logical.SHUFFLE_HASH$;
import org.apache.spark.sql.catalyst.statsEstimation.StatsTestPlan;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.SymbolLiteral;

@ScalaSignature(bytes="\u0006\u0001)3A\u0001D\u0007\u00015!)\u0011\u0006\u0001C\u0001U!9A\u0006\u0001b\u0001\n\u0013i\u0003B\u0002\u001b\u0001A\u0003%a\u0006C\u00046\u0001\t\u0007I\u0011B\u0017\t\rY\u0002\u0001\u0015!\u0003/\u0011\u001d9\u0004A1A\u0005\naBa!\u0012\u0001!\u0002\u0013I\u0004b\u0002$\u0001\u0005\u0004%I\u0001\u000f\u0005\u0007\u000f\u0002\u0001\u000b\u0011B\u001d\t\u000f!\u0003!\u0019!C\u0005q!1\u0011\n\u0001Q\u0001\ne\u0012\u0001DS8j]N+G.Z2uS>t\u0007*\u001a7qKJ\u001cV/\u001b;f\u0015\tqq\"A\u0005paRLW.\u001b>fe*\u0011\u0001#E\u0001\tG\u0006$\u0018\r\\=ti*\u0011!cE\u0001\u0004gFd'B\u0001\u000b\u0016\u0003\u0015\u0019\b/\u0019:l\u0015\t1r#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00021\u0005\u0019qN]4\u0004\u0001M!\u0001aG\u0010&!\taR$D\u0001\u0014\u0013\tq2CA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u0003A\rj\u0011!\t\u0006\u0003E=\tQ\u0001\u001d7b]NL!\u0001J\u0011\u0003\u0011Ac\u0017M\u001c+fgR\u0004\"AJ\u0014\u000e\u00035I!\u0001K\u0007\u0003'){\u0017N\\*fY\u0016\u001cG/[8o\u0011\u0016d\u0007/\u001a:\u0002\rqJg.\u001b;?)\u0005Y\u0003C\u0001\u0014\u0001\u0003\u0011aWM\u001a;\u0016\u00039\u0002\"a\f\u001a\u000e\u0003AR!!M\b\u0002\u001fM$\u0018\r^:FgRLW.\u0019;j_:L!a\r\u0019\u0003\u001bM#\u0018\r^:UKN$\b\u000b\\1o\u0003\u0015aWM\u001a;!\u0003\u0015\u0011\u0018n\u001a5u\u0003\u0019\u0011\u0018n\u001a5uA\u0005i\u0001.\u001b8u\u0005J|\u0017\rZ2bgR,\u0012!\u000f\t\u0004uuzT\"A\u001e\u000b\u0003q\nQa]2bY\u0006L!AP\u001e\u0003\tM{W.\u001a\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0003\u0005\u0006\nq\u0001\\8hS\u000e\fG.\u0003\u0002E\u0003\nA\u0001*\u001b8u\u0013:4w.\u0001\biS:$(I]8bI\u000e\f7\u000f\u001e\u0011\u0002%!Lg\u000e\u001e(piR{'I]8bI\u000e\f7\u000f^\u0001\u0014Q&tGOT8u)>\u0014%o\\1eG\u0006\u001cH\u000fI\u0001\u0010Q&tGo\u00155vM\u001adW\rS1tQ\u0006\u0001\u0002.\u001b8u'\",hM\u001a7f\u0011\u0006\u001c\b\u000e\t")
public class JoinSelectionHelperSuite
extends SparkFunSuite
implements PlanTest,
JoinSelectionHelper {
    private final StatsTestPlan left;
    private final StatsTestPlan right;
    private final Some<HintInfo> hintBroadcast;
    private final Some<HintInfo> hintNotToBroadcast;
    private final Some<HintInfo> hintShuffleHash;
    private String sparkHome;
    private volatile boolean bitmap$0;

    public Option<BuildSide> getBroadcastBuildSide(LogicalPlan left, LogicalPlan right, JoinType joinType, JoinHint hint, boolean hintOnly, SQLConf conf) {
        return JoinSelectionHelper.getBroadcastBuildSide$((JoinSelectionHelper)this, (LogicalPlan)left, (LogicalPlan)right, (JoinType)joinType, (JoinHint)hint, (boolean)hintOnly, (SQLConf)conf);
    }

    public Option<BuildSide> getShuffleHashJoinBuildSide(LogicalPlan left, LogicalPlan right, JoinType joinType, JoinHint hint, boolean hintOnly, SQLConf conf) {
        return JoinSelectionHelper.getShuffleHashJoinBuildSide$((JoinSelectionHelper)this, (LogicalPlan)left, (LogicalPlan)right, (JoinType)joinType, (JoinHint)hint, (boolean)hintOnly, (SQLConf)conf);
    }

    public BuildSide getSmallerSide(LogicalPlan left, LogicalPlan right) {
        return JoinSelectionHelper.getSmallerSide$((JoinSelectionHelper)this, (LogicalPlan)left, (LogicalPlan)right);
    }

    public boolean canBroadcastBySize(LogicalPlan plan, SQLConf conf) {
        return JoinSelectionHelper.canBroadcastBySize$((JoinSelectionHelper)this, (LogicalPlan)plan, (SQLConf)conf);
    }

    public boolean canBuildBroadcastLeft(JoinType joinType) {
        return JoinSelectionHelper.canBuildBroadcastLeft$((JoinSelectionHelper)this, (JoinType)joinType);
    }

    public boolean canBuildBroadcastRight(JoinType joinType) {
        return JoinSelectionHelper.canBuildBroadcastRight$((JoinSelectionHelper)this, (JoinType)joinType);
    }

    public boolean canBuildShuffledHashJoinLeft(JoinType joinType) {
        return JoinSelectionHelper.canBuildShuffledHashJoinLeft$((JoinSelectionHelper)this, (JoinType)joinType);
    }

    public boolean canBuildShuffledHashJoinRight(JoinType joinType) {
        return JoinSelectionHelper.canBuildShuffledHashJoinRight$((JoinSelectionHelper)this, (JoinType)joinType);
    }

    public boolean canPlanAsBroadcastHashJoin(Join join, SQLConf conf) {
        return JoinSelectionHelper.canPlanAsBroadcastHashJoin$((JoinSelectionHelper)this, (Join)join, (SQLConf)conf);
    }

    public boolean canPruneLeft(JoinType joinType) {
        return JoinSelectionHelper.canPruneLeft$((JoinSelectionHelper)this, (JoinType)joinType);
    }

    public boolean canPruneRight(JoinType joinType) {
        return JoinSelectionHelper.canPruneRight$((JoinSelectionHelper)this, (JoinType)joinType);
    }

    public boolean hintToBroadcastLeft(JoinHint hint) {
        return JoinSelectionHelper.hintToBroadcastLeft$((JoinSelectionHelper)this, (JoinHint)hint);
    }

    public boolean hintToBroadcastRight(JoinHint hint) {
        return JoinSelectionHelper.hintToBroadcastRight$((JoinSelectionHelper)this, (JoinHint)hint);
    }

    public boolean hintToNotBroadcastLeft(JoinHint hint) {
        return JoinSelectionHelper.hintToNotBroadcastLeft$((JoinSelectionHelper)this, (JoinHint)hint);
    }

    public boolean hintToNotBroadcastRight(JoinHint hint) {
        return JoinSelectionHelper.hintToNotBroadcastRight$((JoinSelectionHelper)this, (JoinHint)hint);
    }

    public boolean hintToShuffleHashJoinLeft(JoinHint hint) {
        return JoinSelectionHelper.hintToShuffleHashJoinLeft$((JoinSelectionHelper)this, (JoinHint)hint);
    }

    public boolean hintToShuffleHashJoinRight(JoinHint hint) {
        return JoinSelectionHelper.hintToShuffleHashJoinRight$((JoinSelectionHelper)this, (JoinHint)hint);
    }

    public boolean hintToPreferShuffleHashJoinLeft(JoinHint hint) {
        return JoinSelectionHelper.hintToPreferShuffleHashJoinLeft$((JoinSelectionHelper)this, (JoinHint)hint);
    }

    public boolean hintToPreferShuffleHashJoinRight(JoinHint hint) {
        return JoinSelectionHelper.hintToPreferShuffleHashJoinRight$((JoinSelectionHelper)this, (JoinHint)hint);
    }

    public boolean hintToPreferShuffleHashJoin(JoinHint hint) {
        return JoinSelectionHelper.hintToPreferShuffleHashJoin$((JoinSelectionHelper)this, (JoinHint)hint);
    }

    public boolean hintToShuffleHashJoin(JoinHint hint) {
        return JoinSelectionHelper.hintToShuffleHashJoin$((JoinSelectionHelper)this, (JoinHint)hint);
    }

    public boolean hintToSortMergeJoin(JoinHint hint) {
        return JoinSelectionHelper.hintToSortMergeJoin$((JoinSelectionHelper)this, (JoinHint)hint);
    }

    public boolean hintToShuffleReplicateNL(JoinHint hint) {
        return JoinSelectionHelper.hintToShuffleReplicateNL$((JoinSelectionHelper)this, (JoinHint)hint);
    }

    @Override
    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$(this, plan);
    }

    @Override
    public LogicalPlan rewriteNameFromAttrNullability(LogicalPlan plan) {
        return PlanTestBase.rewriteNameFromAttrNullability$(this, plan);
    }

    @Override
    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$(this, plan);
    }

    @Override
    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public boolean comparePlans$default$3() {
        return PlanTestBase.comparePlans$default$3$(this);
    }

    @Override
    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$(this, e1, e2);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$(this, pairs, f);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression buildBalancedPredicate(Seq<Expression> expressions, Function2<Expression, Expression, Expression> op) {
        return PredicateHelper.buildBalancedPredicate$((PredicateHelper)this, expressions, op);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public boolean isNullIntolerant(Expression expr) {
        return PredicateHelper.isNullIntolerant$((PredicateHelper)this, (Expression)expr);
    }

    public Seq<Attribute> outputWithNullability(Seq<Attribute> output, Seq<ExprId> nonNullAttrExprIds) {
        return PredicateHelper.outputWithNullability$((PredicateHelper)this, output, nonNullAttrExprIds);
    }

    public boolean isLikelySelective(Expression e) {
        return PredicateHelper.isLikelySelective$((PredicateHelper)this, (Expression)e);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Seq<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    private String sparkHome$lzycompute() {
        JoinSelectionHelperSuite joinSelectionHelperSuite = this;
        synchronized (joinSelectionHelperSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        return !this.bitmap$0 ? this.sparkHome$lzycompute() : this.sparkHome;
    }

    private StatsTestPlan left() {
        return this.left;
    }

    private StatsTestPlan right() {
        return this.right;
    }

    private Some<HintInfo> hintBroadcast() {
        return this.hintBroadcast;
    }

    private Some<HintInfo> hintNotToBroadcast() {
        return this.hintNotToBroadcast;
    }

    private Some<HintInfo> hintShuffleHash() {
        return this.hintShuffleHash;
    }

    public JoinSelectionHelperSuite() {
        AliasHelper.$init$((AliasHelper)this);
        PredicateHelper.$init$((PredicateHelper)this);
        SQLHelper.$init$(this);
        SQLConfHelper.$init$((SQLConfHelper)this);
        PlanTestBase.$init$(this);
        JoinSelectionHelper.$init$((JoinSelectionHelper)this);
        Seq x$1 = (Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int(), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int(), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).int(), (List)Nil$.MODULE$)));
        BigInt x$2 = BigInt$.MODULE$.int2bigInt(20000000);
        Some x$3 = new Some((Object)BigInt$.MODULE$.int2bigInt(20000000));
        AttributeMap x$4 = AttributeMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.left = new StatsTestPlan((Seq<Attribute>)x$1, x$2, (AttributeMap<ColumnStat>)x$4, (Option<BigInt>)x$3);
        Seq x$5 = (Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "d")).int(), (List)Nil$.MODULE$);
        BigInt x$6 = BigInt$.MODULE$.int2bigInt(1000);
        Some x$7 = new Some((Object)BigInt$.MODULE$.int2bigInt(1000));
        AttributeMap x$8 = AttributeMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.right = new StatsTestPlan((Seq<Attribute>)x$5, x$6, (AttributeMap<ColumnStat>)x$8, (Option<BigInt>)x$7);
        this.hintBroadcast = new Some((Object)new HintInfo((Option)new Some((Object)BROADCAST$.MODULE$)));
        this.hintNotToBroadcast = new Some((Object)new HintInfo((Option)new Some((Object)NO_BROADCAST_HASH$.MODULE$)));
        this.hintShuffleHash = new Some((Object)new HintInfo((Option)new Some((Object)SHUFFLE_HASH$.MODULE$)));
        this.test("getBroadcastBuildSide (hintOnly = true) return BuildLeft with only a left hint", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Option<BuildSide> broadcastSide = this.getBroadcastBuildSide(this.left(), this.right(), (JoinType)Inner$.MODULE$, new JoinHint(this.hintBroadcast(), (Option)None$.MODULE$), true, SQLConf$.MODULE$.get());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(broadcastSide);
            Some $org_scalatest_assert_macro_right = new Some((Object)BuildLeft$.MODULE$);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinSelectionHelperSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
        }, new Position("JoinSelectionHelperSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
        this.test("getBroadcastBuildSide (hintOnly = true) return BuildRight with only a right hint", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Option<BuildSide> broadcastSide = this.getBroadcastBuildSide(this.left(), this.right(), (JoinType)Inner$.MODULE$, new JoinHint((Option)None$.MODULE$, this.hintBroadcast()), true, SQLConf$.MODULE$.get());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(broadcastSide);
            Some $org_scalatest_assert_macro_right = new Some((Object)BuildRight$.MODULE$);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinSelectionHelperSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
        }, new Position("JoinSelectionHelperSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
        this.test("getBroadcastBuildSide (hintOnly = true) return smaller side with both having hints", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Option<BuildSide> broadcastSide = this.getBroadcastBuildSide(this.left(), this.right(), (JoinType)Inner$.MODULE$, new JoinHint(this.hintBroadcast(), this.hintBroadcast()), true, SQLConf$.MODULE$.get());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(broadcastSide);
            Some $org_scalatest_assert_macro_right = new Some((Object)BuildRight$.MODULE$);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinSelectionHelperSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
        }, new Position("JoinSelectionHelperSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
        this.test("getBroadcastBuildSide (hintOnly = true) return None when no side has a hint", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Option<BuildSide> broadcastSide = this.getBroadcastBuildSide(this.left(), this.right(), (JoinType)Inner$.MODULE$, new JoinHint((Option)None$.MODULE$, (Option)None$.MODULE$), true, SQLConf$.MODULE$.get());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(broadcastSide);
            None$ $org_scalatest_assert_macro_right = None$.MODULE$;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinSelectionHelperSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        }, new Position("JoinSelectionHelperSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
        this.test("getBroadcastBuildSide (hintOnly = false) return BuildRight when right is broadcastable", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Option<BuildSide> broadcastSide = this.getBroadcastBuildSide(this.left(), this.right(), (JoinType)Inner$.MODULE$, new JoinHint((Option)None$.MODULE$, (Option)None$.MODULE$), false, SQLConf$.MODULE$.get());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(broadcastSide);
            Some $org_scalatest_assert_macro_right = new Some((Object)BuildRight$.MODULE$);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinSelectionHelperSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
        }, new Position("JoinSelectionHelperSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
        this.test("getBroadcastBuildSide (hintOnly = false) return None when right has no broadcast hint", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Option<BuildSide> broadcastSide = this.getBroadcastBuildSide(this.left(), this.right(), (JoinType)Inner$.MODULE$, new JoinHint((Option)None$.MODULE$, this.hintNotToBroadcast()), false, SQLConf$.MODULE$.get());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(broadcastSide);
            None$ $org_scalatest_assert_macro_right = None$.MODULE$;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinSelectionHelperSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
        }, new Position("JoinSelectionHelperSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
        this.test("getShuffleHashJoinBuildSide (hintOnly = true) return BuildLeft with only a left hint", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Option<BuildSide> broadcastSide = this.getShuffleHashJoinBuildSide(this.left(), this.right(), (JoinType)Inner$.MODULE$, new JoinHint(this.hintShuffleHash(), (Option)None$.MODULE$), true, SQLConf$.MODULE$.get());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(broadcastSide);
            Some $org_scalatest_assert_macro_right = new Some((Object)BuildLeft$.MODULE$);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinSelectionHelperSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
        }, new Position("JoinSelectionHelperSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
        this.test("getShuffleHashJoinBuildSide (hintOnly = true) return BuildRight with only a right hint", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Option<BuildSide> broadcastSide = this.getShuffleHashJoinBuildSide(this.left(), this.right(), (JoinType)Inner$.MODULE$, new JoinHint((Option)None$.MODULE$, this.hintShuffleHash()), true, SQLConf$.MODULE$.get());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(broadcastSide);
            Some $org_scalatest_assert_macro_right = new Some((Object)BuildRight$.MODULE$);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinSelectionHelperSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
        }, new Position("JoinSelectionHelperSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
        this.test("getShuffleHashJoinBuildSide (hintOnly = true) return smaller side when both have hints", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Option<BuildSide> broadcastSide = this.getShuffleHashJoinBuildSide(this.left(), this.right(), (JoinType)Inner$.MODULE$, new JoinHint(this.hintShuffleHash(), this.hintShuffleHash()), true, SQLConf$.MODULE$.get());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(broadcastSide);
            Some $org_scalatest_assert_macro_right = new Some((Object)BuildRight$.MODULE$);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinSelectionHelperSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
        }, new Position("JoinSelectionHelperSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
        this.test("getShuffleHashJoinBuildSide (hintOnly = true) return None when no side has a hint", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Option<BuildSide> broadcastSide = this.getShuffleHashJoinBuildSide(this.left(), this.right(), (JoinType)Inner$.MODULE$, new JoinHint((Option)None$.MODULE$, (Option)None$.MODULE$), true, SQLConf$.MODULE$.get());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(broadcastSide);
            None$ $org_scalatest_assert_macro_right = None$.MODULE$;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinSelectionHelperSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
        }, new Position("JoinSelectionHelperSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
        this.test("getShuffleHashJoinBuildSide (hintOnly = false) return BuildRight when right is smaller", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Option<BuildSide> broadcastSide = this.getBroadcastBuildSide(this.left(), this.right(), (JoinType)Inner$.MODULE$, new JoinHint((Option)None$.MODULE$, (Option)None$.MODULE$), false, SQLConf$.MODULE$.get());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(broadcastSide);
            Some $org_scalatest_assert_macro_right = new Some((Object)BuildRight$.MODULE$);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinSelectionHelperSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
        }, new Position("JoinSelectionHelperSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165));
        this.test("getSmallerSide should return BuildRight", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.getSmallerSide(this.left(), this.right()));
            BuildRight$ $org_scalatest_assert_macro_right = BuildRight$.MODULE$;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinSelectionHelperSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178));
        }, new Position("JoinSelectionHelperSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
        this.test("canBroadcastBySize should return true if the plan size is less than 10MB", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)this.canBroadcastBySize(this.left(), SQLConf$.MODULE$.get())));
            boolean $org_scalatest_assert_macro_right = false;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinSelectionHelperSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 182));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)this.canBroadcastBySize(this.right(), SQLConf$.MODULE$.get())));
            boolean $org_scalatest_assert_macro_right2 = true;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinSelectionHelperSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
        }, new Position("JoinSelectionHelperSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 181));
    }
}

