/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.sql.Timestamp;
import java.time.DateTimeException;
import java.time.ZoneId;
import org.apache.spark.SparkArithmeticException;
import org.apache.spark.SparkRuntimeException;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.expressions.CastBase;
import org.apache.spark.sql.catalyst.expressions.CastSuiteBase;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.util.DateTimeTestUtils$;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypeTestUtils$;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.FractionalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001e4Qa\u0003\u0007\u0002\u0002eAQ\u0001\n\u0001\u0005\u0002\u0015BQa\n\u0001\u0005\n!BQa\u000e\u0001\u0005\naBQA\u000f\u0001\u0005\nmBq\u0001\u0015\u0001\u0012\u0002\u0013%\u0011\u000bC\u0003;\u0001\u0011%A\fC\u0003;\u0001\u0011%A\rC\u0003h\u0001\u0011E\u0001\u000eC\u0003p\u0001\u0011E\u0001\u000fC\u0003u\u0001\u0011%QOA\tB]NL7)Y:u'VLG/\u001a\"bg\u0016T!!\u0004\b\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003\u001fA\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003#I\t1a]9m\u0015\t\u0019B#A\u0003ta\u0006\u00148N\u0003\u0002\u0016-\u00051\u0011\r]1dQ\u0016T\u0011aF\u0001\u0004_J<7\u0001A\n\u0004\u0001iq\u0002CA\u000e\u001d\u001b\u0005a\u0011BA\u000f\r\u00055\u0019\u0015m\u001d;Tk&$XMQ1tKB\u0011qDI\u0007\u0002A)\u0011\u0011\u0005E\u0001\u0007KJ\u0014xN]:\n\u0005\r\u0002#aD)vKJLXI\u001d:peN\u0014\u0015m]3\u0002\rqJg.\u001b;?)\u00051\u0003CA\u000e\u0001\u0003A!Xm\u001d;J]Rl\u0015\r_!oI6Kg\u000e\u0006\u0002*_A\u0011!&L\u0007\u0002W)\tA&A\u0003tG\u0006d\u0017-\u0003\u0002/W\t!QK\\5u\u0011\u0015\u0001$\u00011\u00012\u0003\t!G\u000f\u0005\u00023k5\t1G\u0003\u00025!\u0005)A/\u001f9fg&\u0011ag\r\u0002\t\t\u0006$\u0018\rV=qK\u0006\tB/Z:u\u0019>tw-T1y\u0003:$W*\u001b8\u0015\u0005%J\u0004\"\u0002\u0019\u0004\u0001\u0004\t\u0014AC2bgR,%O]'tOR!Ah\u0012'O!\tiDI\u0004\u0002?\u0005B\u0011qhK\u0007\u0002\u0001*\u0011\u0011\tG\u0001\u0007yI|w\u000e\u001e \n\u0005\r[\u0013A\u0002)sK\u0012,g-\u0003\u0002F\r\n11\u000b\u001e:j]\u001eT!aQ\u0016\t\u000b!#\u0001\u0019A%\u0002\u0003Y\u0004\"A\u000b&\n\u0005-[#aA!os\")Q\n\u0002a\u0001c\u0005\u0011Ao\u001c\u0005\b\u001f\u0012\u0001\n\u00111\u00012\u0003\u00111'o\\7\u0002)\r\f7\u000f^#se6\u001bx\r\n3fM\u0006,H\u000e\u001e\u00134+\u0005\u0011&FA\u0019TW\u0005!\u0006CA+[\u001b\u00051&BA,Y\u0003%)hn\u00195fG.,GM\u0003\u0002ZW\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005m3&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dKR!A(\u00182d\u0011\u0015qf\u00011\u0001`\u0003\u0005a\u0007CA\u000ea\u0013\t\tGBA\u0004MSR,'/\u00197\t\u000b53\u0001\u0019A\u0019\t\u000b=3\u0001\u0019A\u0019\u0015\u0007q*g\rC\u0003_\u000f\u0001\u0007q\fC\u0003N\u000f\u0001\u0007\u0011'A\fdQ\u0016\u001c7nQ1tiR{g*^7fe&\u001cWI\u001d:peR)\u0011&\u001b6l[\")a\f\u0003a\u0001?\")Q\n\u0003a\u0001c!)A\u000e\u0003a\u0001c\u0005QR\r\u001f9fGR,G\rR1uCRK\b/Z%o\u000bJ\u0014xN]'tO\")a\u000e\u0003a\u0001\u0013\u0006iAO]=DCN$(+Z:vYR\fqc\u00195fG.\u001c\u0015m\u001d;U_\n{w\u000e\\3b]\u0016\u0013(o\u001c:\u0015\t%\n(o\u001d\u0005\u0006=&\u0001\ra\u0018\u0005\u0006\u001b&\u0001\r!\r\u0005\u0006]&\u0001\r!S\u0001\u0013G\u0006\u001cHo\u0014<fe\u001adwn^#se6\u001bx\r\u0006\u0003=m^D\b\"\u0002%\u000b\u0001\u0004I\u0005\"B(\u000b\u0001\u0004\t\u0004\"B'\u000b\u0001\u0004\t\u0004")
public abstract class AnsiCastSuiteBase
extends CastSuiteBase
implements QueryErrorsBase {
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$((QueryErrorsBase)this, (Object)v, (DataType)t);
    }

    public String toSQLStmt(String text) {
        return QueryErrorsBase.toSQLStmt$((QueryErrorsBase)this, (String)text);
    }

    public String toSQLId(Seq<String> parts) {
        return QueryErrorsBase.toSQLId$((QueryErrorsBase)this, parts);
    }

    public String toSQLId(String parts) {
        return QueryErrorsBase.toSQLId$((QueryErrorsBase)this, (String)parts);
    }

    public String toSQLType(DataType t) {
        return QueryErrorsBase.toSQLType$((QueryErrorsBase)this, (DataType)t);
    }

    public String toSQLConf(String conf) {
        return QueryErrorsBase.toSQLConf$((QueryErrorsBase)this, (String)conf);
    }

    public String toDSOption(String option) {
        return QueryErrorsBase.toDSOption$((QueryErrorsBase)this, (String)option);
    }

    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$((QueryErrorsBase)this, (Expression)e);
    }

    private void testIntMaxAndMin(DataType dt) {
        Seq $org_scalatest_assert_macro_left = (Seq)new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)ShortType$.MODULE$, (List)new .colon.colon((Object)ByteType$.MODULE$, (List)Nil$.MODULE$)));
        DataType $org_scalatest_assert_macro_right = dt;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0x80000000L, -2147483649L}))).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)value -> {
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToLong((long)value), dt, this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(Decimal$.MODULE$.apply(Long.toString(value)), dt, this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(new Literal((Object)BoxesRunTime.boxToFloat((float)((float)((double)value * 1.5))), (DataType)FloatType$.MODULE$), dt, this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(new Literal((Object)BoxesRunTime.boxToDouble((double)((double)value * 1.0)), (DataType)DoubleType$.MODULE$), dt, this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
        });
    }

    private void testLongMaxAndMin(DataType dt) {
        Seq $org_scalatest_assert_macro_left = (Seq)new .colon.colon((Object)LongType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$));
        DataType $org_scalatest_assert_macro_right = dt;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
        ((IterableLike)new .colon.colon((Object)Decimal$.MODULE$.apply(Long.MAX_VALUE).$plus(Decimal$.MODULE$.apply(1)), (List)new .colon.colon((Object)Decimal$.MODULE$.apply(Long.MIN_VALUE).$minus(Decimal$.MODULE$.apply(1)), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)value -> {
            AnsiCastSuiteBase.$anonfun$testLongMaxAndMin$1(this, dt, value);
            return BoxedUnit.UNIT;
        });
    }

    private String castErrMsg(Object v, DataType to, DataType from) {
        return new StringBuilder(67).append("The value ").append(this.toSQLValue(v, from)).append(" of the type ").append(this.toSQLType(from)).append(" ").append("cannot be cast to ").append(this.toSQLType(to)).append(" because it is malformed.").toString();
    }

    private String castErrMsg(Literal l, DataType to, DataType from) {
        return new StringBuilder(67).append("The value ").append(this.toSQLValue(l.eval(l.eval$default$1()), from)).append(" of the type ").append(this.toSQLType(from)).append(" ").append("cannot be cast to ").append(this.toSQLType(to)).append(" because it is malformed.").toString();
    }

    private String castErrMsg(Literal l, DataType to) {
        return this.castErrMsg(l, to, l.dataType());
    }

    private DataType castErrMsg$default$3() {
        return StringType$.MODULE$;
    }

    public void checkCastToNumericError(Literal l, DataType to, DataType expectedDataTypeInErrorMsg, Object tryCastResult) {
        this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(l, to, this.cast$default$3()), this.castErrMsg("true", expectedDataTypeInErrorMsg, this.castErrMsg$default$3()), ClassTag$.MODULE$.apply(NumberFormatException.class));
    }

    public void checkCastToBooleanError(Literal l, DataType to, Object tryCastResult) {
        this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(l, to, this.cast$default$3()), "cannot be cast to \"BOOLEAN\"", ClassTag$.MODULE$.apply(SparkRuntimeException.class));
    }

    private String castOverflowErrMsg(Object v, DataType from, DataType to) {
        return new StringBuilder(62).append("The value ").append(this.toSQLValue(v, from)).append(" of the type ").append(this.toSQLType(from)).append(" cannot be ").append("cast to ").append(this.toSQLType(to)).append(" due to an overflow.").toString();
    }

    public static final /* synthetic */ void $anonfun$testLongMaxAndMin$1(AnsiCastSuiteBase $this, DataType dt$2, Decimal value) {
        $this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> $this.cast(value, dt$2, $this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
        $this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> $this.cast(BoxesRunTime.boxToFloat((float)value.$times(Decimal$.MODULE$.apply(1.1)).toFloat()), dt$2, $this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
        $this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> $this.cast(BoxesRunTime.boxToDouble((double)value.$times(Decimal$.MODULE$.apply(1.1)).toDouble()), dt$2, $this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
    }

    public static final /* synthetic */ void $anonfun$new$6(AnsiCastSuiteBase $this, byte value) {
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> $this.cast(BoxesRunTime.boxToByte((byte)value), (DataType)ByteType$.MODULE$, $this.cast$default$3()), BoxesRunTime.boxToByte((byte)value), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> $this.cast(Byte.toString(value), (DataType)ByteType$.MODULE$, $this.cast$default$3()), BoxesRunTime.boxToByte((byte)value), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> $this.cast(Decimal$.MODULE$.apply(Byte.toString(value)), (DataType)ByteType$.MODULE$, $this.cast$default$3()), BoxesRunTime.boxToByte((byte)value), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> $this.cast(new Literal((Object)BoxesRunTime.boxToFloat((float)value), (DataType)FloatType$.MODULE$), (DataType)ByteType$.MODULE$, $this.cast$default$3()), BoxesRunTime.boxToByte((byte)value), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> $this.cast(new Literal((Object)BoxesRunTime.boxToDouble((double)value), (DataType)DoubleType$.MODULE$), (DataType)ByteType$.MODULE$, $this.cast$default$3()), BoxesRunTime.boxToByte((byte)value), $this.checkEvaluation$default$3());
    }

    public static final /* synthetic */ void $anonfun$new$17(AnsiCastSuiteBase $this, short value) {
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> $this.cast(BoxesRunTime.boxToShort((short)value), (DataType)ShortType$.MODULE$, $this.cast$default$3()), BoxesRunTime.boxToShort((short)value), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> $this.cast(Short.toString(value), (DataType)ShortType$.MODULE$, $this.cast$default$3()), BoxesRunTime.boxToShort((short)value), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> $this.cast(Decimal$.MODULE$.apply(Short.toString(value)), (DataType)ShortType$.MODULE$, $this.cast$default$3()), BoxesRunTime.boxToShort((short)value), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> $this.cast(new Literal((Object)BoxesRunTime.boxToFloat((float)value), (DataType)FloatType$.MODULE$), (DataType)ShortType$.MODULE$, $this.cast$default$3()), BoxesRunTime.boxToShort((short)value), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> $this.cast(new Literal((Object)BoxesRunTime.boxToDouble((double)value), (DataType)DoubleType$.MODULE$), (DataType)ShortType$.MODULE$, $this.cast$default$3()), BoxesRunTime.boxToShort((short)value), $this.checkEvaluation$default$3());
    }

    private final void check$1(String value, DataType dataType) {
        this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(value, dataType, this.cast$default$3()), this.castErrMsg(value, dataType, this.castErrMsg$default$3()), ClassTag$.MODULE$.apply(NumberFormatException.class));
    }

    public static final /* synthetic */ void $anonfun$new$51(AnsiCastSuiteBase $this, IntegralType dataType) {
        $this.check$1("string", (DataType)dataType);
        $this.check$1("123-string", (DataType)dataType);
        $this.check$1("2020-07-19", (DataType)dataType);
        $this.check$1("1.23", (DataType)dataType);
    }

    public static final /* synthetic */ void $anonfun$new$52(AnsiCastSuiteBase $this, FractionalType dataType) {
        $this.check$1("string", (DataType)dataType);
        $this.check$1("123.000.00", (DataType)dataType);
        $this.check$1("abc.com", (DataType)dataType);
    }

    private final void checkCastToTimestampError$1(Literal l, DataType to) {
        this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(l, to, this.cast$default$3()), "cannot be cast to \"TIMESTAMP\" because it is malformed", ClassTag$.MODULE$.apply(DateTimeException.class));
    }

    public static final /* synthetic */ CastBase $anonfun$new$83(AnsiCastSuiteBase $this, Literal array$1, DataType to$4) {
        return $this.cast(array$1, to$4, $this.cast$default$3());
    }

    public static final /* synthetic */ CastBase $anonfun$new$84(AnsiCastSuiteBase $this, Literal overflowArray$1, DataType to$4) {
        return $this.cast(overflowArray$1, to$4, $this.cast$default$3());
    }

    public static final /* synthetic */ CastBase $anonfun$new$90(AnsiCastSuiteBase $this, Literal map$1, DataType to$5) {
        return $this.cast(map$1, to$5, $this.cast$default$3());
    }

    public static final /* synthetic */ CastBase $anonfun$new$96(AnsiCastSuiteBase $this, Literal struct$1, DataType to$6) {
        return $this.cast(struct$1, to$6, $this.cast$default$3());
    }

    public static final /* synthetic */ CastBase $anonfun$new$97(AnsiCastSuiteBase $this, Literal overflowStruct$1, DataType to$6) {
        return $this.cast(overflowStruct$1, to$6, $this.cast$default$3());
    }

    private final void checkCastWithParseError$1(String str, ZoneId zid$1) {
        this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(Literal$.MODULE$.apply((Object)str), (DataType)TimestampType$.MODULE$, (Option<String>)Option$.MODULE$.apply((Object)zid$1.getId())), this.castErrMsg(str, (DataType)TimestampType$.MODULE$, this.castErrMsg$default$3()), ClassTag$.MODULE$.apply(DateTimeException.class));
    }

    public static final /* synthetic */ void $anonfun$new$101(AnsiCastSuiteBase $this, ZoneId zid) {
        $this.checkCastWithParseError$1("123", zid);
        $this.checkCastWithParseError$1("2015-03-18 123142", zid);
        $this.checkCastWithParseError$1("2015-03-18T123123", zid);
        $this.checkCastWithParseError$1("2015-03-18X", zid);
        $this.checkCastWithParseError$1("2015/03/18", zid);
        $this.checkCastWithParseError$1("2015.03.18", zid);
        $this.checkCastWithParseError$1("20150318", zid);
        $this.checkCastWithParseError$1("2015-031-8", zid);
        $this.checkCastWithParseError$1("2015-03-18T12:03:17-0:70", zid);
        $this.checkCastWithParseError$1("abdef", zid);
    }

    private final void checkCastWithParseError$2(String str, ZoneId zid$2) {
        this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(Literal$.MODULE$.apply((Object)str), (DataType)DateType$.MODULE$, (Option<String>)Option$.MODULE$.apply((Object)zid$2.getId())), this.castErrMsg(str, (DataType)DateType$.MODULE$, this.castErrMsg$default$3()), ClassTag$.MODULE$.apply(DateTimeException.class));
    }

    public static final /* synthetic */ void $anonfun$new$104(AnsiCastSuiteBase $this, ZoneId zid) {
        $this.checkCastWithParseError$2("2015-13-18", zid);
        $this.checkCastWithParseError$2("2015-03-128", zid);
        $this.checkCastWithParseError$2("2015/03/18", zid);
        $this.checkCastWithParseError$2("2015.03.18", zid);
        $this.checkCastWithParseError$2("20150318", zid);
        $this.checkCastWithParseError$2("2015-031-8", zid);
        $this.checkCastWithParseError$2("2015-03-18ABC", zid);
        $this.checkCastWithParseError$2("abdef", zid);
    }

    public AnsiCastSuiteBase() {
        QueryErrorsBase.$init$((QueryErrorsBase)this);
        this.test("ANSI mode: Throw exception on casting out-of-range value to byte type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.testIntMaxAndMin((DataType)ByteType$.MODULE$);
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{128, -129}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)value -> {
                this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToInteger((int)value), (DataType)ByteType$.MODULE$, this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
                this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(new Literal((Object)BoxesRunTime.boxToFloat((float)value), (DataType)FloatType$.MODULE$), (DataType)ByteType$.MODULE$, this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
                this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(new Literal((Object)BoxesRunTime.boxToDouble((double)value), (DataType)DoubleType$.MODULE$), (DataType)ByteType$.MODULE$, this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
            });
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{127, (byte)0, -128}))).foreach((Function1 & Serializable & scala.Serializable)value -> {
                AnsiCastSuiteBase.$anonfun$new$6(this, BoxesRunTime.unboxToByte((Object)value));
                return BoxedUnit.UNIT;
            });
        }, new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
        this.test("ANSI mode: Throw exception on casting out-of-range value to short type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.testIntMaxAndMin((DataType)ShortType$.MODULE$);
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{32768, -32769}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)value -> {
                this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToInteger((int)value), (DataType)ShortType$.MODULE$, this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
                this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(new Literal((Object)BoxesRunTime.boxToFloat((float)value), (DataType)FloatType$.MODULE$), (DataType)ShortType$.MODULE$, this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
                this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(new Literal((Object)BoxesRunTime.boxToDouble((double)value), (DataType)DoubleType$.MODULE$), (DataType)ShortType$.MODULE$, this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
            });
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapShortArray(new short[]{Short.MAX_VALUE, (short)0, Short.MIN_VALUE}))).foreach((Function1 & Serializable & scala.Serializable)value -> {
                AnsiCastSuiteBase.$anonfun$new$17(this, BoxesRunTime.unboxToShort((Object)value));
                return BoxedUnit.UNIT;
            });
        }, new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
        this.test("ANSI mode: Throw exception on casting out-of-range value to int type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.testIntMaxAndMin((DataType)IntegerType$.MODULE$);
            this.testLongMaxAndMin((DataType)IntegerType$.MODULE$);
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{Integer.MAX_VALUE, 0, Integer.MIN_VALUE}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)value -> {
                this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToInteger((int)value), (DataType)IntegerType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToInteger((int)value), this.checkEvaluation$default$3());
                this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(Integer.toString(value), (DataType)IntegerType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToInteger((int)value), this.checkEvaluation$default$3());
                this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(Decimal$.MODULE$.apply(Integer.toString(value)), (DataType)IntegerType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToInteger((int)value), this.checkEvaluation$default$3());
                this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(new Literal((Object)BoxesRunTime.boxToDouble((double)((double)value * 1.0)), (DataType)DoubleType$.MODULE$), (DataType)IntegerType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToInteger((int)value), this.checkEvaluation$default$3());
            });
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToDouble((double)2.1474836479E9), (DataType)IntegerType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToDouble((double)-2.1474836489E9), (DataType)IntegerType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToInteger((int)Integer.MIN_VALUE), this.checkEvaluation$default$3());
        }, new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
        this.test("ANSI mode: Throw exception on casting out-of-range value to long type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.testLongMaxAndMin((DataType)LongType$.MODULE$);
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{Long.MAX_VALUE, 0L, Long.MIN_VALUE}))).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)value -> {
                this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToLong((long)value), (DataType)LongType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToLong((long)value), this.checkEvaluation$default$3());
                this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(Long.toString(value), (DataType)LongType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToLong((long)value), this.checkEvaluation$default$3());
                this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(Decimal$.MODULE$.apply(Long.toString(value)), (DataType)LongType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToLong((long)value), this.checkEvaluation$default$3());
            });
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToFloat((float)9.223372E18f), (DataType)LongType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToLong((long)Long.MAX_VALUE), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToFloat((float)-9.223372E18f), (DataType)LongType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToLong((long)Long.MIN_VALUE), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToDouble((double)9.223372036854776E18), (DataType)LongType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToLong((long)Long.MAX_VALUE), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToDouble((double)-9.223372036854776E18), (DataType)LongType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToLong((long)Long.MIN_VALUE), this.checkEvaluation$default$3());
        }, new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
        this.test("ANSI mode: Throw exception on casting out-of-range value to decimal type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(Literal$.MODULE$.apply((Object)"134.12"), (DataType)new DecimalType(3, 2), this.cast$default$3()), "cannot be represented", ClassTag$.MODULE$.apply(ArithmeticException.class));
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(Literal$.MODULE$.apply((Object)package$.MODULE$.BigDecimal().apply(134.12)), (DataType)new DecimalType(3, 2), this.cast$default$3()), "cannot be represented", ClassTag$.MODULE$.apply(ArithmeticException.class));
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)134.12)), (DataType)new DecimalType(3, 2), this.cast$default$3()), "cannot be represented", ClassTag$.MODULE$.apply(ArithmeticException.class));
        }, new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
        this.test("ANSI mode: disallow type conversions between Numeric types and Date type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkInvalidCastFromNumericType((DataType)DateType$.MODULE$);
            ObjectRef errorMsg = ObjectRef.create((Object)"you can use function DATE_FROM_UNIX_DATE instead");
            this.verifyCastFailure(this.cast(Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)0L)), (DataType)DateType$.MODULE$, this.cast$default$3()), (Option<String>)new Some((Object)((String)errorMsg.elem)));
            Literal dateLiteral = new Literal((Object)BoxesRunTime.boxToInteger((int)1), (DataType)DateType$.MODULE$);
            errorMsg.elem = "you can use function UNIX_DATE instead";
            DataTypeTestUtils$.MODULE$.numericTypes().foreach((Function1 & Serializable & scala.Serializable)numericType -> {
                this.verifyCastFailure(this.cast(dateLiteral, (DataType)numericType, this.cast$default$3()), (Option<String>)new Some((Object)((String)errorMsg.elem)));
                return BoxedUnit.UNIT;
            });
        }, new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
        this.test("ANSI mode: disallow type conversions between Numeric types and Binary type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkInvalidCastFromNumericType((DataType)BinaryType$.MODULE$);
            Literal binaryLiteral = new Literal((Object)new byte[(byte)1], (DataType)BinaryType$.MODULE$);
            DataTypeTestUtils$.MODULE$.numericTypes().foreach((Function1 & Serializable & scala.Serializable)numericType -> {
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.cast(binaryLiteral, (DataType)numericType, this.cast$default$3()).checkInputDataTypes().isFailure(), "AnsiCastSuiteBase.this.cast(binaryLiteral, numericType, AnsiCastSuiteBase.this.cast$default$3).checkInputDataTypes().isFailure", Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
            });
        }, new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
        this.test("ANSI mode: disallow type conversions between Datatime types and Boolean types", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Literal timestampLiteral = new Literal((Object)BoxesRunTime.boxToLong((long)1L), (DataType)TimestampType$.MODULE$);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.cast(timestampLiteral, (DataType)BooleanType$.MODULE$, this.cast$default$3()).checkInputDataTypes().isFailure(), "AnsiCastSuiteBase.this.cast(timestampLiteral, org.apache.spark.sql.types.BooleanType, AnsiCastSuiteBase.this.cast$default$3).checkInputDataTypes().isFailure", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
            Literal dateLiteral = new Literal((Object)BoxesRunTime.boxToInteger((int)1), (DataType)DateType$.MODULE$);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.cast(dateLiteral, (DataType)BooleanType$.MODULE$, this.cast$default$3()).checkInputDataTypes().isFailure(), "AnsiCastSuiteBase.this.cast(dateLiteral, org.apache.spark.sql.types.BooleanType, AnsiCastSuiteBase.this.cast$default$3).checkInputDataTypes().isFailure", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
            Literal booleanLiteral = new Literal((Object)BoxesRunTime.boxToBoolean((boolean)true), (DataType)BooleanType$.MODULE$);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(this.cast(booleanLiteral, (DataType)TimestampType$.MODULE$, this.cast$default$3()).checkInputDataTypes().isFailure(), "AnsiCastSuiteBase.this.cast(booleanLiteral, org.apache.spark.sql.types.TimestampType, AnsiCastSuiteBase.this.cast$default$3).checkInputDataTypes().isFailure", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(this.cast(booleanLiteral, (DataType)DateType$.MODULE$, this.cast$default$3()).checkInputDataTypes().isFailure(), "AnsiCastSuiteBase.this.cast(booleanLiteral, org.apache.spark.sql.types.DateType, AnsiCastSuiteBase.this.cast$default$3).checkInputDataTypes().isFailure", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
        }, new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
        this.test("cast from invalid string to numeric should throw NumberFormatException", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ((IterableLike)new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)ShortType$.MODULE$, (List)new .colon.colon((Object)ByteType$.MODULE$, (List)new .colon.colon((Object)LongType$.MODULE$, (List)Nil$.MODULE$))))).foreach((Function1 & Serializable & scala.Serializable)dataType -> {
                AnsiCastSuiteBase.$anonfun$new$51(this, dataType);
                return BoxedUnit.UNIT;
            });
            ((IterableLike)new .colon.colon((Object)DoubleType$.MODULE$, (List)new .colon.colon((Object)FloatType$.MODULE$, (List)new .colon.colon((Object)DecimalType$.MODULE$.USER_DEFAULT(), (List)Nil$.MODULE$)))).foreach((Function1 & Serializable & scala.Serializable)dataType -> {
                AnsiCastSuiteBase.$anonfun$new$52(this, dataType);
                return BoxedUnit.UNIT;
            });
        }, new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
        this.test("cast from invalid string array to numeric array should throw NumberFormatException", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Literal array = Literal$.MODULE$.create((Object)new .colon.colon((Object)"123", (List)new .colon.colon((Object)"true", (List)new .colon.colon((Object)"f", (List)new .colon.colon(null, (List)Nil$.MODULE$)))), (DataType)new ArrayType((DataType)StringType$.MODULE$, true));
            this.checkCastToNumericError(array, (DataType)new ArrayType((DataType)ByteType$.MODULE$, true), (DataType)ByteType$.MODULE$, Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)((byte)123)), null, null, null})));
            this.checkCastToNumericError(array, (DataType)new ArrayType((DataType)ShortType$.MODULE$, true), (DataType)ShortType$.MODULE$, Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)((short)123)), null, null, null})));
            this.checkCastToNumericError(array, (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), (DataType)IntegerType$.MODULE$, Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)123), null, null, null})));
            this.checkCastToNumericError(array, (DataType)new ArrayType((DataType)LongType$.MODULE$, true), (DataType)LongType$.MODULE$, Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)123L), null, null, null})));
        }, new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 215));
        this.test("Fast fail for cast string type to decimal type in ansi mode", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast("12345678901234567890123456789012345678", (DataType)new DecimalType(38, 0), this.cast$default$3()), Decimal$.MODULE$.apply("12345678901234567890123456789012345678"), this.checkEvaluation$default$3());
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast("123456789012345678901234567890123456789", (DataType)new DecimalType(38, 0), this.cast$default$3()), "out of decimal type range", ClassTag$.MODULE$.apply(ArithmeticException.class));
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast("12345678901234567890123456789012345678", (DataType)new DecimalType(38, 1), this.cast$default$3()), "cannot be represented as Decimal(38, 1)", ClassTag$.MODULE$.apply(ArithmeticException.class));
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast("0.00000000000000000000000000000000000001", (DataType)new DecimalType(38, 0), this.cast$default$3()), Decimal$.MODULE$.apply("0"), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast("0.00000000000000000000000000000000000000000001", (DataType)new DecimalType(38, 0), this.cast$default$3()), Decimal$.MODULE$.apply("0"), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast("0.00000000000000000000000000000000000001", (DataType)new DecimalType(38, 18), this.cast$default$3()), Decimal$.MODULE$.apply("0E-18"), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast("6E-120", (DataType)new DecimalType(38, 0), this.cast$default$3()), Decimal$.MODULE$.apply("0"), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast("6E+37", (DataType)new DecimalType(38, 0), this.cast$default$3()), Decimal$.MODULE$.apply("60000000000000000000000000000000000000"), this.checkEvaluation$default$3());
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast("6E+38", (DataType)new DecimalType(38, 0), this.cast$default$3()), "out of decimal type range", ClassTag$.MODULE$.apply(ArithmeticException.class));
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast("6E+37", (DataType)new DecimalType(38, 1), this.cast$default$3()), "cannot be represented as Decimal(38, 1)", ClassTag$.MODULE$.apply(ArithmeticException.class));
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast("abcd", (DataType)new DecimalType(38, 1), this.cast$default$3()), this.castErrMsg("abcd", (DataType)new DecimalType(38, 1), this.castErrMsg$default$3()), ClassTag$.MODULE$.apply(NumberFormatException.class));
        }, new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 229));
        this.test("ANSI mode: cast string to boolean with parse error", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkCastToBooleanError(Literal$.MODULE$.apply((Object)"abc"), (DataType)BooleanType$.MODULE$, null);
            this.checkCastToBooleanError(Literal$.MODULE$.apply((Object)""), (DataType)BooleanType$.MODULE$, null);
        }, new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 267));
        this.test("cast from timestamp II", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkCastToTimestampError$1(Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)Double.NaN)), (DataType)TimestampType$.MODULE$);
            this.checkCastToTimestampError$1(Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)Double.POSITIVE_INFINITY)), (DataType)TimestampType$.MODULE$);
            this.checkCastToTimestampError$1(Literal$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)Float.NaN)), (DataType)TimestampType$.MODULE$);
            this.checkCastToTimestampError$1(Literal$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)Float.POSITIVE_INFINITY)), (DataType)TimestampType$.MODULE$);
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{Long.MIN_VALUE, Long.MAX_VALUE, Long.MIN_VALUE, Long.MAX_VALUE}))).foreach((Function1)(JFunction1.mcVD.sp & Serializable & scala.Serializable)v -> this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)v)), (DataType)TimestampType$.MODULE$, this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(SparkArithmeticException.class)));
        }, new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 272));
        this.test("cast a timestamp before the epoch 1970-01-01 00:00:00Z II", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DateTimeTestUtils$.MODULE$.withDefaultTimeZone(DateTimeTestUtils$.MODULE$.UTC(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Timestamp negativeTs = Timestamp.valueOf("1900-05-05 18:34:56.1");
            long $org_scalatest_assert_macro_left = negativeTs.getTime();
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 297));
            ((IterableLike)new .colon.colon((Object)ByteType$.MODULE$, (List)new .colon.colon((Object)ShortType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$)))).foreach((Function1 & Serializable & scala.Serializable)dt -> {
                this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> $this.cast(negativeTs$1, (DataType)dt, $this.cast$default$3()), this.castOverflowErrMsg(negativeTs, (DataType)TimestampType$.MODULE$, (DataType)dt), ClassTag$.MODULE$.apply(SparkArithmeticException.class));
                return BoxedUnit.UNIT;
            });
        }), new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 294));
        this.test("cast a timestamp before the epoch 1970-01-01 00:00:00Z", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DateTimeTestUtils$.MODULE$.withDefaultTimeZone(DateTimeTestUtils$.MODULE$.UTC(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Timestamp negativeTs = Timestamp.valueOf("1900-05-05 18:34:56.1");
            long $org_scalatest_assert_macro_left = negativeTs.getTime();
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 309));
            ((IterableLike)new .colon.colon((Object)ByteType$.MODULE$, (List)new .colon.colon((Object)ShortType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$)))).foreach((Function1 & Serializable & scala.Serializable)dt -> {
                this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> $this.cast(negativeTs$2, (DataType)dt, $this.cast$default$3()), this.castOverflowErrMsg(negativeTs, (DataType)TimestampType$.MODULE$, (DataType)dt), ClassTag$.MODULE$.apply(SparkArithmeticException.class));
                return BoxedUnit.UNIT;
            });
            long expectedSecs = Math.floorDiv(negativeTs.getTime(), 1000L);
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(negativeTs, (DataType)LongType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToLong((long)expectedSecs), this.checkEvaluation$default$3());
        }), new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 306));
        this.test("cast from array II", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            Literal array = Literal$.MODULE$.create((Object)new .colon.colon((Object)"123", (List)new .colon.colon((Object)"true", (List)new .colon.colon((Object)"f", (List)new .colon.colon(null, (List)Nil$.MODULE$)))), (DataType)new ArrayType((DataType)StringType$.MODULE$, true));
            Literal array_notNull = Literal$.MODULE$.create((Object)new .colon.colon((Object)"123", (List)new .colon.colon((Object)"true", (List)new .colon.colon((Object)"f", (List)Nil$.MODULE$))), (DataType)new ArrayType((DataType)StringType$.MODULE$, false));
            ArrayType to = new ArrayType((DataType)BooleanType$.MODULE$, true);
            CastBase ret = this.cast(array, (DataType)to, this.cast$default$3());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(ret.resolved(), "ret.resolved", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 329));
            this.checkCastToBooleanError(array, (DataType)to, Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)false), null})));
            ArrayType to2 = new ArrayType((DataType)BooleanType$.MODULE$, true);
            CastBase ret2 = this.cast(array_notNull, (DataType)to2, this.cast$default$3());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(ret2.resolved(), "ret.resolved", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 336));
            this.checkCastToBooleanError(array_notNull, (DataType)to2, Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)false)})));
            CastBase ret3 = this.cast(array_notNull, (DataType)new ArrayType((DataType)BooleanType$.MODULE$, false), this.cast$default$3());
            boolean $org_scalatest_assert_macro_left = ret3.resolved();
            boolean $org_scalatest_assert_macro_right = !this.isTryCast();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 342));
            if (!this.isTryCast()) {
                this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> ret3, "cannot be cast to \"BOOLEAN\"", ClassTag$.MODULE$.apply(SparkRuntimeException.class));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        }, new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 320));
        this.test("cast from array III", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            if (!this.isTryCast()) {
                ArrayType from = new ArrayType((DataType)DoubleType$.MODULE$, false);
                Literal array = Literal$.MODULE$.create((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 2.0})), (DataType)from);
                ArrayType to = new ArrayType((DataType)IntegerType$.MODULE$, false);
                Object answer = Literal$.MODULE$.create((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (DataType)to).value();
                this.checkEvaluation((Function0<Expression>)((Function0 & Serializable & scala.Serializable)() -> AnsiCastSuiteBase.$anonfun$new$83(this, array, (DataType)to)), answer, this.checkEvaluation$default$3());
                Literal overflowArray = Literal$.MODULE$.create((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.147483648E9})), (DataType)from);
                this.checkExceptionInExpression((Function0<Expression>)((Function0 & Serializable & scala.Serializable)() -> AnsiCastSuiteBase.$anonfun$new$84(this, overflowArray, (DataType)to)), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        }, new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 350));
        this.test("cast from map II", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            Literal map = Literal$.MODULE$.create((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"123"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)"f"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"d"), null)})), (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)StringType$.MODULE$, true));
            Literal map_notNull = Literal$.MODULE$.create((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"123"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)"f")})), (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)StringType$.MODULE$, false));
            this.checkNullCast((DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)IntegerType$.MODULE$), (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)StringType$.MODULE$));
            MapType to = new MapType((DataType)StringType$.MODULE$, (DataType)BooleanType$.MODULE$, true);
            CastBase ret = this.cast(map, (DataType)to, this.cast$default$3());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(ret.resolved(), "ret.resolved", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 376));
            this.checkCastToBooleanError(map, (DataType)to, Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), null), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)BoxesRunTime.boxToBoolean((boolean)true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)BoxesRunTime.boxToBoolean((boolean)false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"d"), null)})));
            MapType to2 = new MapType((DataType)StringType$.MODULE$, (DataType)BooleanType$.MODULE$, true);
            CastBase ret2 = this.cast(map_notNull, (DataType)to2, this.cast$default$3());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(ret2.resolved(), "ret.resolved", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 383));
            this.checkCastToBooleanError(map_notNull, (DataType)to2, Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), null), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)BoxesRunTime.boxToBoolean((boolean)true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)BoxesRunTime.boxToBoolean((boolean)false))})));
            CastBase ret3 = this.cast(map, (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, true), this.cast$default$3());
            boolean $org_scalatest_assert_macro_left = ret3.resolved();
            boolean $org_scalatest_assert_macro_right = !this.isTryCast();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 389));
            if (!this.isTryCast()) {
                this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> ret3, this.castErrMsg("a", (DataType)IntegerType$.MODULE$, this.castErrMsg$default$3()), ClassTag$.MODULE$.apply(NumberFormatException.class));
            }
            CastBase ret4 = this.cast(map_notNull, (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)BooleanType$.MODULE$, false), this.cast$default$3());
            boolean $org_scalatest_assert_macro_left2 = ret4.resolved();
            boolean $org_scalatest_assert_macro_right2 = !this.isTryCast();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 399));
            if (!this.isTryCast()) {
                this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> ret4, this.castErrMsg("123", (DataType)BooleanType$.MODULE$, this.castErrMsg$default$3()), ClassTag$.MODULE$.apply(SparkRuntimeException.class));
            }
            CastBase ret5 = this.cast(map_notNull, (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, true), this.cast$default$3());
            boolean $org_scalatest_assert_macro_left3 = ret5.resolved();
            boolean $org_scalatest_assert_macro_right3 = !this.isTryCast();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 409));
            if (!this.isTryCast()) {
                this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> ret5, this.castErrMsg("a", (DataType)IntegerType$.MODULE$, this.castErrMsg$default$3()), ClassTag$.MODULE$.apply(NumberFormatException.class));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        }, new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 363));
        this.test("cast from map III", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            if (!this.isTryCast()) {
                MapType from = new MapType((DataType)DoubleType$.MODULE$, (DataType)DoubleType$.MODULE$, false);
                Literal map = Literal$.MODULE$.create((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)1.0)), (Object)BoxesRunTime.boxToDouble((double)2.0))})), (DataType)from);
                MapType to = new MapType((DataType)IntegerType$.MODULE$, (DataType)IntegerType$.MODULE$, false);
                Object answer = Literal$.MODULE$.create((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)2))})), (DataType)to).value();
                this.checkEvaluation((Function0<Expression>)((Function0 & Serializable & scala.Serializable)() -> AnsiCastSuiteBase.$anonfun$new$90(this, map, (DataType)to)), answer, this.checkEvaluation$default$3());
                ((IterableLike)new .colon.colon((Object)Literal$.MODULE$.create((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)2.147483648E9)), (Object)BoxesRunTime.boxToDouble((double)2.0))})), (DataType)from), (List)new .colon.colon((Object)Literal$.MODULE$.create((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)1.0)), (Object)BoxesRunTime.boxToDouble((double)-2.147483649E9))})), (DataType)from), (List)Nil$.MODULE$))).foreach(arg_0 -> AnsiCastSuiteBase.$anonfun$new$91$adapted(this, (DataType)to, arg_0));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        }, new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 418));
        this.test("cast from struct II", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            this.checkNullCast((DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("a", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("b", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))), (DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("a", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("b", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))));
            Literal struct = Literal$.MODULE$.create((Object)InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{UTF8String.fromString((String)"123"), UTF8String.fromString((String)"true"), UTF8String.fromString((String)"f"), null})), (DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("a", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("b", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("c", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("d", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))))));
            Literal struct_notNull = Literal$.MODULE$.create((Object)InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{UTF8String.fromString((String)"123"), UTF8String.fromString((String)"true"), UTF8String.fromString((String)"f")})), (DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("a", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("b", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("c", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))));
            StructType to = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("a", (DataType)BooleanType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("b", (DataType)BooleanType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("c", (DataType)BooleanType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("d", (DataType)BooleanType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))));
            CastBase ret = this.cast(struct, (DataType)to, this.cast$default$3());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(ret.resolved(), "ret.resolved", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 471));
            this.checkCastToBooleanError(struct, (DataType)to, InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)false), null})));
            StructType to2 = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("a", (DataType)BooleanType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("b", (DataType)BooleanType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("c", (DataType)BooleanType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))));
            CastBase ret2 = this.cast(struct_notNull, (DataType)to2, this.cast$default$3());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(ret2.resolved(), "ret.resolved", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 481));
            this.checkCastToBooleanError(struct_notNull, (DataType)to2, InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)false)})));
            CastBase ret3 = this.cast(struct_notNull, (DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("a", (DataType)BooleanType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("b", (DataType)BooleanType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("c", (DataType)BooleanType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))), this.cast$default$3());
            boolean $org_scalatest_assert_macro_left = ret3.resolved();
            boolean $org_scalatest_assert_macro_right = !this.isTryCast();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 490));
            if (!this.isTryCast()) {
                this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> ret3, this.castErrMsg("123", (DataType)BooleanType$.MODULE$, this.castErrMsg$default$3()), ClassTag$.MODULE$.apply(SparkRuntimeException.class));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        }, new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 434));
        this.test("cast from struct III", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            if (!this.isTryCast()) {
                StructType from = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("a", (DataType)DoubleType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
                Literal struct = Literal$.MODULE$.create((Object)InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)1.0)})), (DataType)from);
                StructType to = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("a", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
                Object answer = Literal$.MODULE$.create((Object)InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})), (DataType)to).value();
                this.checkEvaluation((Function0<Expression>)((Function0 & Serializable & scala.Serializable)() -> AnsiCastSuiteBase.$anonfun$new$96(this, struct, (DataType)to)), answer, this.checkEvaluation$default$3());
                Literal overflowStruct = Literal$.MODULE$.create((Object)InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)2.147483648E9)})), (DataType)from);
                this.checkExceptionInExpression((Function0<Expression>)((Function0 & Serializable & scala.Serializable)() -> AnsiCastSuiteBase.$anonfun$new$97(this, overflowStruct, (DataType)to)), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        }, new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 499));
        this.test("complex casting", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            Literal complex = Literal$.MODULE$.create((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new .colon.colon((Object)"123", (List)new .colon.colon((Object)"true", (List)new .colon.colon((Object)"f", (List)Nil$.MODULE$))), Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"123"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)"f")})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)}))})), (DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("a", (DataType)new ArrayType((DataType)StringType$.MODULE$, false), true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("m", (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)StringType$.MODULE$, false), true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("s", (DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("i", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))));
            CastBase ret = this.cast(complex, (DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("a", (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("m", (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)BooleanType$.MODULE$, false), true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("s", (DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("l", (DataType)LongType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))), this.cast$default$3());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)ret.resolved()));
            boolean $org_scalatest_assert_macro_right = !this.isTryCast();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 536));
            if (!this.isTryCast()) {
                this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> ret, this.castErrMsg("true", (DataType)IntegerType$.MODULE$, this.castErrMsg$default$3()), ClassTag$.MODULE$.apply(NumberFormatException.class));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        }, new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 512));
        this.test("ANSI mode: cast string to timestamp with parse error", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DateTimeTestUtils$.MODULE$.outstandingZoneIds().foreach((Function1 & Serializable & scala.Serializable)zid -> {
            AnsiCastSuiteBase.$anonfun$new$101(this, zid);
            return BoxedUnit.UNIT;
        }), new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 544));
        this.test("ANSI mode: cast string to date with parse error", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DateTimeTestUtils$.MODULE$.outstandingZoneIds().foreach((Function1 & Serializable & scala.Serializable)zid -> {
            AnsiCastSuiteBase.$anonfun$new$104(this, zid);
            return BoxedUnit.UNIT;
        }), new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 565));
        this.test("SPARK-26218: Fix the corner case of codegen when casting float to Integer", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(this.cast(Literal$.MODULE$.apply((Object)"2147483648"), (DataType)FloatType$.MODULE$, this.cast$default$3()), (DataType)IntegerType$.MODULE$, this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class)), new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 584));
        this.test("SPARK-35720: cast invalid string input to timestamp without time zone", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"00:00:00", (List)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"123", (List)new .colon.colon((Object)"a2021-06-17", (List)new .colon.colon((Object)"2021-06-17abc", (List)new .colon.colon((Object)"2021-06-17 00:00:00ABC", (List)Nil$.MODULE$))))))).foreach((Function1 & Serializable & scala.Serializable)invalidInput -> {
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> $this.cast(invalidInput, (DataType)TimestampNTZType$.MODULE$, $this.cast$default$3()), this.castErrMsg(invalidInput, (DataType)TimestampNTZType$.MODULE$, this.castErrMsg$default$3()), ClassTag$.MODULE$.apply(DateTimeException.class));
            return BoxedUnit.UNIT;
        }), new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 589));
    }

    public static final /* synthetic */ Object $anonfun$new$91$adapted(AnsiCastSuiteBase $this, DataType to$5, Literal overflowMap) {
        $this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> $this.cast(overflowMap, to$5, $this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
        return BoxedUnit.UNIT;
    }
}

