/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.expressions.JoinedRow;
import org.apache.spark.sql.connector.catalog.BufferedRows;
import org.apache.spark.sql.connector.metric.CustomTaskMetric;
import org.apache.spark.sql.connector.read.PartitionReader;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-a\u0001\u0002\b\u0010\tqA\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\tm\u0001\u0011\t\u0011)A\u0005o!AQ\n\u0001B\u0001B\u0003%a\n\u0003\u0005V\u0001\t\u0005\t\u0015!\u0003W\u0011\u0015I\u0006\u0001\"\u0001[\u0011\u0015\u0001\u0007\u0001\"\u0003b\u0011\u001d!\u0007\u00011A\u0005\n\u0015DqA\u001b\u0001A\u0002\u0013%1\u000e\u0003\u0004r\u0001\u0001\u0006KA\u001a\u0005\u0006e\u0002!\te\u001d\u0005\u0006o\u0002!\t\u0005\u001f\u0005\u0006s\u0002!\tE\u001f\u0005\u0006w\u0002!I\u0001 \u0002\u0013\u0005V4g-\u001a:fIJ{wo\u001d*fC\u0012,'O\u0003\u0002\u0011#\u000591-\u0019;bY><'B\u0001\n\u0014\u0003%\u0019wN\u001c8fGR|'O\u0003\u0002\u0015+\u0005\u00191/\u001d7\u000b\u0005Y9\u0012!B:qCJ\\'B\u0001\r\u001a\u0003\u0019\t\u0007/Y2iK*\t!$A\u0002pe\u001e\u001c\u0001aE\u0002\u0001;\u0015\u0002\"AH\u0012\u000e\u0003}Q!\u0001I\u0011\u0002\t1\fgn\u001a\u0006\u0002E\u0005!!.\u0019<b\u0013\t!sD\u0001\u0004PE*,7\r\u001e\t\u0004M%ZS\"A\u0014\u000b\u0005!\n\u0012\u0001\u0002:fC\u0012L!AK\u0014\u0003\u001fA\u000b'\u000f^5uS>t'+Z1eKJ\u0004\"\u0001L\u0018\u000e\u00035R!AL\n\u0002\u0011\r\fG/\u00197zgRL!\u0001M\u0017\u0003\u0017%sG/\u001a:oC2\u0014vn^\u0001\na\u0006\u0014H/\u001b;j_:\u0004\"a\r\u001b\u000e\u0003=I!!N\b\u0003\u0019\t+hMZ3sK\u0012\u0014vn^:\u0002'5,G/\u00193bi\u0006\u001cu\u000e\\;n]:\u000bW.Z:\u0011\u0007a\u0012UI\u0004\u0002:\u007f9\u0011!(P\u0007\u0002w)\u0011AhG\u0001\u0007yI|w\u000e\u001e \n\u0003y\nQa]2bY\u0006L!\u0001Q!\u0002\u000fA\f7m[1hK*\ta(\u0003\u0002D\t\n\u00191+Z9\u000b\u0005\u0001\u000b\u0005C\u0001$K\u001d\t9\u0005\n\u0005\u0002;\u0003&\u0011\u0011*Q\u0001\u0007!J,G-\u001a4\n\u0005-c%AB*ue&twM\u0003\u0002J\u0003\u0006\u0011bn\u001c8NKR\fG-\u0019;b\u0007>dW/\u001c8t!\rA$i\u0014\t\u0003!Nk\u0011!\u0015\u0006\u0003%N\tQ\u0001^=qKNL!\u0001V)\u0003\u0017M#(/^2u\r&,G\u000eZ\u0001\fi\u0006\u0014G.Z*dQ\u0016l\u0017\r\u0005\u0002Q/&\u0011\u0001,\u0015\u0002\u000b'R\u0014Xo\u0019;UsB,\u0017A\u0002\u001fj]&$h\bF\u0003\\9vsv\f\u0005\u00024\u0001!)\u0011'\u0002a\u0001e!)a'\u0002a\u0001o!)Q*\u0002a\u0001\u001d\")Q+\u0002a\u0001-\u0006Y\u0011\r\u001a3NKR\fG-\u0019;b)\tY#\rC\u0003d\r\u0001\u00071&A\u0002s_^\fQ!\u001b8eKb,\u0012A\u001a\t\u0003O\"l\u0011!Q\u0005\u0003S\u0006\u00131!\u00138u\u0003%Ig\u000eZ3y?\u0012*\u0017\u000f\u0006\u0002m_B\u0011q-\\\u0005\u0003]\u0006\u0013A!\u00168ji\"9\u0001\u000fCA\u0001\u0002\u00041\u0017a\u0001=%c\u00051\u0011N\u001c3fq\u0002\nAA\\3yiR\tA\u000f\u0005\u0002hk&\u0011a/\u0011\u0002\b\u0005>|G.Z1o\u0003\r9W\r\u001e\u000b\u0002W\u0005)1\r\\8tKR\tA.A\tfqR\u0014\u0018m\u0019;GS\u0016dGMV1mk\u0016$r!`A\u0001\u0003\u000b\tI\u0001\u0005\u0002h}&\u0011q0\u0011\u0002\u0004\u0003:L\bBBA\u0002\u001b\u0001\u0007q*A\u0003gS\u0016dG\r\u0003\u0004\u0002\b5\u0001\rAV\u0001\u0007g\u000eDW-\\1\t\u000b\rl\u0001\u0019A\u0016")
public class BufferedRowsReader
implements PartitionReader<InternalRow> {
    private final BufferedRows partition;
    private final Seq<String> metadataColumnNames;
    private final Seq<StructField> nonMetadataColumns;
    private final StructType tableSchema;
    private int index;

    public CustomTaskMetric[] currentMetricsValues() {
        return super.currentMetricsValues();
    }

    private InternalRow addMetadata(InternalRow row) {
        GenericInternalRow metadataRow = new GenericInternalRow((Object[])((TraversableOnce)this.metadataColumnNames.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Integer n;
            String string = x0$1;
            if ("index".equals(string)) {
                n = BoxesRunTime.boxToInteger((int)this.index());
            } else if ("_partition".equals(string)) {
                n = UTF8String.fromString((String)$this.partition.key());
            } else {
                throw new MatchError((Object)string);
            }
            return n;
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Any()));
        return new JoinedRow(row, (InternalRow)metadataRow);
    }

    private int index() {
        return this.index;
    }

    private void index_$eq(int x$1) {
        this.index = x$1;
    }

    public boolean next() {
        this.index_$eq(this.index() + 1);
        return this.index() < this.partition.rows().length();
    }

    public InternalRow get() {
        InternalRow originalRow = (InternalRow)this.partition.rows().apply(this.index());
        Object[] values = new Object[this.nonMetadataColumns.length()];
        ((IterableLike)this.nonMetadataColumns.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            BufferedRowsReader.$anonfun$get$1(this, values, originalRow, x0$1);
            return BoxedUnit.UNIT;
        });
        return this.addMetadata((InternalRow)new GenericInternalRow(values));
    }

    public void close() {
    }

    private Object extractFieldValue(StructField field, StructType schema, InternalRow row) {
        Object object;
        int index = schema.fieldIndex(field.name());
        DataType dataType = field.dataType();
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            StructField[] fields = structType.fields();
            if (row.isNullAt(index)) {
                return null;
            }
            InternalRow childRow = (InternalRow)row.toSeq(schema).apply(index);
            StructType childSchema = (StructType)schema.apply(index).dataType();
            Object[] resultValue = new Object[fields.length];
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                BufferedRowsReader.$anonfun$extractFieldValue$1(this, childSchema, childRow, resultValue, x0$1);
                return BoxedUnit.UNIT;
            });
            object = new GenericInternalRow(resultValue);
        } else {
            object = row.get(index, dataType);
        }
        return object;
    }

    public static final /* synthetic */ void $anonfun$get$1(BufferedRowsReader $this, Object[] values$1, InternalRow originalRow$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        StructField col = (StructField)tuple2._1();
        int idx = tuple2._2$mcI$sp();
        values$1[idx] = $this.extractFieldValue(col, $this.tableSchema, originalRow$1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$extractFieldValue$1(BufferedRowsReader $this, StructType childSchema$1, InternalRow childRow$1, Object[] resultValue$1, Tuple2 x0$1) {
        Object childValue;
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        StructField childField = (StructField)tuple2._1();
        int idx = tuple2._2$mcI$sp();
        resultValue$1[idx] = childValue = $this.extractFieldValue(childField, childSchema$1, childRow$1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public BufferedRowsReader(BufferedRows partition, Seq<String> metadataColumnNames, Seq<StructField> nonMetadataColumns, StructType tableSchema) {
        this.partition = partition;
        this.metadataColumnNames = metadataColumnNames;
        this.nonMetadataColumns = nonMetadataColumns;
        this.tableSchema = tableSchema;
        this.index = -1;
    }
}

