/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.TypeCoercionSuite$;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.CastBase;
import org.apache.spark.sql.catalyst.expressions.CastSuiteBase;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.aggregate.CollectList;
import org.apache.spark.sql.catalyst.expressions.aggregate.CollectList$;
import org.apache.spark.sql.catalyst.expressions.aggregate.CollectSet;
import org.apache.spark.sql.catalyst.expressions.aggregate.CollectSet$;
import org.apache.spark.sql.catalyst.util.DateTimeTestUtils$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypeTestUtils$;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.ExampleBaseTypeUDT;
import org.apache.spark.sql.types.ExampleSubTypeUDT;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001-3A\u0001B\u0003\u0001%!)q\u0003\u0001C\u00011!)!\u0004\u0001C!7!9q\bAI\u0001\n\u0003\u0001%!C\"bgR\u001cV/\u001b;f\u0015\t1q!A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\u0005\n\u0003!\u0019\u0017\r^1msN$(B\u0001\u0006\f\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u00195\tQa\u001d9be.T!AD\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0012aA8sO\u000e\u00011C\u0001\u0001\u0014!\t!R#D\u0001\u0006\u0013\t1RAA\u0007DCN$8+^5uK\n\u000b7/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003e\u0001\"\u0001\u0006\u0001\u0002\t\r\f7\u000f\u001e\u000b\u00059}9s\u0006\u0005\u0002\u0015;%\u0011a$\u0002\u0002\t\u0007\u0006\u001cHOQ1tK\")\u0001E\u0001a\u0001C\u0005\ta\u000f\u0005\u0002#K5\t1EC\u0001%\u0003\u0015\u00198-\u00197b\u0013\t13EA\u0002B]fDQ\u0001\u000b\u0002A\u0002%\n!\u0002^1sO\u0016$H+\u001f9f!\tQS&D\u0001,\u0015\ta\u0013\"A\u0003usB,7/\u0003\u0002/W\tAA)\u0019;b)f\u0004X\rC\u00041\u0005A\u0005\t\u0019A\u0019\u0002\u0015QLW.\u001a.p]\u0016LE\rE\u0002#eQJ!aM\u0012\u0003\r=\u0003H/[8o!\t)DH\u0004\u00027uA\u0011qgI\u0007\u0002q)\u0011\u0011(E\u0001\u0007yI|w\u000e\u001e \n\u0005m\u001a\u0013A\u0002)sK\u0012,g-\u0003\u0002>}\t11\u000b\u001e:j]\u001eT!aO\u0012\u0002\u001d\r\f7\u000f\u001e\u0013eK\u001a\fW\u000f\u001c;%gU\t\u0011I\u000b\u00022\u0005.\n1\t\u0005\u0002E\u00136\tQI\u0003\u0002G\u000f\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003\u0011\u000e\n!\"\u00198o_R\fG/[8o\u0013\tQUIA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class CastSuite
extends CastSuiteBase {
    @Override
    public CastBase cast(Object v, DataType targetType, Option<String> timeZoneId) {
        Cast cast;
        Object object = v;
        if (object instanceof Expression) {
            Expression expression = (Expression)object;
            cast = new Cast(expression, targetType, timeZoneId, Cast$.MODULE$.apply$default$4());
        } else {
            cast = new Cast((Expression)Literal$.MODULE$.apply(v), targetType, timeZoneId, Cast$.MODULE$.apply$default$4());
        }
        return cast;
    }

    @Override
    public Option<String> cast$default$3() {
        return None$.MODULE$;
    }

    public CastSuite() {
        this.test("null cast #2", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkNullCast((DataType)DateType$.MODULE$, (DataType)BooleanType$.MODULE$);
            this.checkNullCast((DataType)TimestampType$.MODULE$, (DataType)BooleanType$.MODULE$);
            this.checkNullCast((DataType)BooleanType$.MODULE$, (DataType)TimestampType$.MODULE$);
            DataTypeTestUtils$.MODULE$.numericTypes().foreach((Function1 & Serializable & scala.Serializable)dt -> {
                this.checkNullCast((DataType)dt, (DataType)TimestampType$.MODULE$);
                return BoxedUnit.UNIT;
            });
            DataTypeTestUtils$.MODULE$.numericTypes().foreach((Function1 & Serializable & scala.Serializable)dt -> {
                this.checkNullCast((DataType)TimestampType$.MODULE$, (DataType)dt);
                return BoxedUnit.UNIT;
            });
            DataTypeTestUtils$.MODULE$.numericTypes().foreach((Function1 & Serializable & scala.Serializable)dt -> {
                this.checkNullCast((DataType)DateType$.MODULE$, (DataType)dt);
                return BoxedUnit.UNIT;
            });
        }, new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
        this.test("cast from long #2", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToLong((long)123L), (DataType)new DecimalType(3, 1), this.cast$default$3()), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToLong((long)123L), (DataType)new DecimalType(2, 0), this.cast$default$3()), null, this.checkEvaluation$default$3());
        }, new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
        this.test("cast from int #2", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(this.cast(BoxesRunTime.boxToInteger((int)1000), (DataType)TimestampType$.MODULE$, this.cast$default$3()), (DataType)LongType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToLong((long)1000), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(this.cast(BoxesRunTime.boxToInteger((int)-1200), (DataType)TimestampType$.MODULE$, this.cast$default$3()), (DataType)LongType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToLong((long)-1200), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToInteger((int)123), (DataType)new DecimalType(3, 1), this.cast$default$3()), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToInteger((int)123), (DataType)new DecimalType(2, 0), this.cast$default$3()), null, this.checkEvaluation$default$3());
        }, new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
        this.test("cast string to date #2", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new Cast((Expression)Literal$.MODULE$.apply((Object)"2015-03-18X"), (DataType)DateType$.MODULE$, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4()), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new Cast((Expression)Literal$.MODULE$.apply((Object)"2015/03/18"), (DataType)DateType$.MODULE$, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4()), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new Cast((Expression)Literal$.MODULE$.apply((Object)"2015.03.18"), (DataType)DateType$.MODULE$, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4()), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new Cast((Expression)Literal$.MODULE$.apply((Object)"20150318"), (DataType)DateType$.MODULE$, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4()), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new Cast((Expression)Literal$.MODULE$.apply((Object)"2015-031-8"), (DataType)DateType$.MODULE$, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4()), null, this.checkEvaluation$default$3());
        }, new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
        this.test("casting to fixed-precision decimals", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)this.cast(BoxesRunTime.boxToInteger((int)123), (DataType)DecimalType$.MODULE$.USER_DEFAULT(), this.cast$default$3()).nullable()));
            boolean $org_scalatest_assert_macro_right = false;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.cast(BoxesRunTime.boxToFloat((float)10.03f), (DataType)DecimalType$.MODULE$.SYSTEM_DEFAULT(), this.cast$default$3()).nullable(), "CastSuite.this.cast(10.03, org.apache.spark.sql.types.DecimalType.SYSTEM_DEFAULT, CastSuite.this.cast$default$3).nullable", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(this.cast(BoxesRunTime.boxToDouble((double)10.03), (DataType)DecimalType$.MODULE$.SYSTEM_DEFAULT(), this.cast$default$3()).nullable(), "CastSuite.this.cast(10.03, org.apache.spark.sql.types.DecimalType.SYSTEM_DEFAULT, CastSuite.this.cast$default$3).nullable", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)this.cast(Decimal$.MODULE$.apply(10.03), (DataType)DecimalType$.MODULE$.SYSTEM_DEFAULT(), this.cast$default$3()).nullable()));
            boolean $org_scalatest_assert_macro_right2 = false;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(this.cast(BoxesRunTime.boxToInteger((int)123), (DataType)new DecimalType(2, 1), this.cast$default$3()).nullable(), "CastSuite.this.cast(123, org.apache.spark.sql.types.DecimalType.apply(2, 1), CastSuite.this.cast$default$3).nullable", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(this.cast(BoxesRunTime.boxToFloat((float)10.03f), (DataType)new DecimalType(2, 1), this.cast$default$3()).nullable(), "CastSuite.this.cast(10.03, org.apache.spark.sql.types.DecimalType.apply(2, 1), CastSuite.this.cast$default$3).nullable", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(this.cast(BoxesRunTime.boxToDouble((double)10.03), (DataType)new DecimalType(2, 1), this.cast$default$3()).nullable(), "CastSuite.this.cast(10.03, org.apache.spark.sql.types.DecimalType.apply(2, 1), CastSuite.this.cast$default$3).nullable", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(this.cast(Decimal$.MODULE$.apply(10.03), (DataType)new DecimalType(2, 1), this.cast$default$3()).nullable(), "CastSuite.this.cast(org.apache.spark.sql.types.Decimal.apply(10.03), org.apache.spark.sql.types.DecimalType.apply(2, 1), CastSuite.this.cast$default$3).nullable", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)this.cast(BoxesRunTime.boxToInteger((int)123), (DataType)DecimalType$.MODULE$.IntDecimal(), this.cast$default$3()).nullable()));
            boolean $org_scalatest_assert_macro_right3 = false;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool(this.cast(BoxesRunTime.boxToFloat((float)10.03f), (DataType)DecimalType$.MODULE$.FloatDecimal(), this.cast$default$3()).nullable(), "CastSuite.this.cast(10.03, org.apache.spark.sql.types.DecimalType.FloatDecimal, CastSuite.this.cast$default$3).nullable", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.simpleMacroBool(this.cast(BoxesRunTime.boxToDouble((double)10.03), (DataType)DecimalType$.MODULE$.DoubleDecimal(), this.cast$default$3()).nullable(), "CastSuite.this.cast(10.03, org.apache.spark.sql.types.DecimalType.DoubleDecimal, CastSuite.this.cast$default$3).nullable", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)this.cast(Decimal$.MODULE$.apply(10.03), (DataType)new DecimalType(4, 2), this.cast$default$3()).nullable()));
            boolean $org_scalatest_assert_macro_right4 = false;
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)this.cast(Decimal$.MODULE$.apply(10.03), (DataType)new DecimalType(5, 3), this.cast$default$3()).nullable()));
            boolean $org_scalatest_assert_macro_right5 = false;
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.simpleMacroBool(this.cast(Decimal$.MODULE$.apply(10.03), (DataType)new DecimalType(3, 1), this.cast$default$3()).nullable(), "CastSuite.this.cast(org.apache.spark.sql.types.Decimal.apply(10.03), org.apache.spark.sql.types.DecimalType.apply(3, 1), CastSuite.this.cast$default$3).nullable", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)this.cast(Decimal$.MODULE$.apply(10.03), (DataType)new DecimalType(4, 1), this.cast$default$3()).nullable()));
            boolean $org_scalatest_assert_macro_right6 = false;
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.simpleMacroBool(this.cast(Decimal$.MODULE$.apply(9.95), (DataType)new DecimalType(2, 1), this.cast$default$3()).nullable(), "CastSuite.this.cast(org.apache.spark.sql.types.Decimal.apply(9.95), org.apache.spark.sql.types.DecimalType.apply(2, 1), CastSuite.this.cast$default$3).nullable", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)this.cast(Decimal$.MODULE$.apply(9.95), (DataType)new DecimalType(3, 1), this.cast$default$3()).nullable()));
            boolean $org_scalatest_assert_macro_right7 = false;
            Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)this.cast(BoxesRunTime.boxToBoolean((boolean)true), (DataType)DecimalType$.MODULE$.SYSTEM_DEFAULT(), this.cast$default$3()).nullable()));
            boolean $org_scalatest_assert_macro_right8 = false;
            Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
            Bool $org_scalatest_assert_macro_expr19 = Bool$.MODULE$.simpleMacroBool(this.cast(BoxesRunTime.boxToBoolean((boolean)true), (DataType)new DecimalType(1, 1), this.cast$default$3()).nullable(), "CastSuite.this.cast(true, org.apache.spark.sql.types.DecimalType.apply(1, 1), CastSuite.this.cast$default$3).nullable", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr19, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToDouble((double)10.03), (DataType)DecimalType$.MODULE$.SYSTEM_DEFAULT(), this.cast$default$3()), Decimal$.MODULE$.apply(10.03), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToDouble((double)10.03), (DataType)new DecimalType(4, 2), this.cast$default$3()), Decimal$.MODULE$.apply(10.03), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToDouble((double)10.03), (DataType)new DecimalType(3, 1), this.cast$default$3()), Decimal$.MODULE$.apply(10.0), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToDouble((double)10.03), (DataType)new DecimalType(2, 0), this.cast$default$3()), Decimal$.MODULE$.apply(10), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToDouble((double)10.03), (DataType)new DecimalType(1, 0), this.cast$default$3()), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToDouble((double)10.03), (DataType)new DecimalType(2, 1), this.cast$default$3()), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToDouble((double)10.03), (DataType)new DecimalType(3, 2), this.cast$default$3()), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(Decimal$.MODULE$.apply(10.03), (DataType)new DecimalType(3, 1), this.cast$default$3()), Decimal$.MODULE$.apply(10.0), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(Decimal$.MODULE$.apply(10.03), (DataType)new DecimalType(3, 2), this.cast$default$3()), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToDouble((double)10.05), (DataType)DecimalType$.MODULE$.SYSTEM_DEFAULT(), this.cast$default$3()), Decimal$.MODULE$.apply(10.05), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToDouble((double)10.05), (DataType)new DecimalType(4, 2), this.cast$default$3()), Decimal$.MODULE$.apply(10.05), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToDouble((double)10.05), (DataType)new DecimalType(3, 1), this.cast$default$3()), Decimal$.MODULE$.apply(10.1), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToDouble((double)10.05), (DataType)new DecimalType(2, 0), this.cast$default$3()), Decimal$.MODULE$.apply(10), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToDouble((double)10.05), (DataType)new DecimalType(1, 0), this.cast$default$3()), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToDouble((double)10.05), (DataType)new DecimalType(2, 1), this.cast$default$3()), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToDouble((double)10.05), (DataType)new DecimalType(3, 2), this.cast$default$3()), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(Decimal$.MODULE$.apply(10.05), (DataType)new DecimalType(3, 1), this.cast$default$3()), Decimal$.MODULE$.apply(10.1), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(Decimal$.MODULE$.apply(10.05), (DataType)new DecimalType(3, 2), this.cast$default$3()), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToDouble((double)9.95), (DataType)new DecimalType(3, 2), this.cast$default$3()), Decimal$.MODULE$.apply(9.95), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToDouble((double)9.95), (DataType)new DecimalType(3, 1), this.cast$default$3()), Decimal$.MODULE$.apply(10.0), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToDouble((double)9.95), (DataType)new DecimalType(2, 0), this.cast$default$3()), Decimal$.MODULE$.apply(10), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToDouble((double)9.95), (DataType)new DecimalType(2, 1), this.cast$default$3()), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToDouble((double)9.95), (DataType)new DecimalType(1, 0), this.cast$default$3()), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(Decimal$.MODULE$.apply(9.95), (DataType)new DecimalType(3, 1), this.cast$default$3()), Decimal$.MODULE$.apply(10.0), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(Decimal$.MODULE$.apply(9.95), (DataType)new DecimalType(1, 0), this.cast$default$3()), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToDouble((double)-9.95), (DataType)new DecimalType(3, 2), this.cast$default$3()), Decimal$.MODULE$.apply(-9.95), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToDouble((double)-9.95), (DataType)new DecimalType(3, 1), this.cast$default$3()), Decimal$.MODULE$.apply(-10.0), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToDouble((double)-9.95), (DataType)new DecimalType(2, 0), this.cast$default$3()), Decimal$.MODULE$.apply(-10), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToDouble((double)-9.95), (DataType)new DecimalType(2, 1), this.cast$default$3()), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToDouble((double)-9.95), (DataType)new DecimalType(1, 0), this.cast$default$3()), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(Decimal$.MODULE$.apply(-9.95), (DataType)new DecimalType(3, 1), this.cast$default$3()), Decimal$.MODULE$.apply(-10.0), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(Decimal$.MODULE$.apply(-9.95), (DataType)new DecimalType(1, 0), this.cast$default$3()), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(Decimal$.MODULE$.apply("1003"), (DataType)DecimalType$.MODULE$.SYSTEM_DEFAULT(), this.cast$default$3()), Decimal$.MODULE$.apply(1003), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(Decimal$.MODULE$.apply("1003"), (DataType)new DecimalType(4, 0), this.cast$default$3()), Decimal$.MODULE$.apply(1003), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(Decimal$.MODULE$.apply("1003"), (DataType)new DecimalType(3, 0), this.cast$default$3()), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(Decimal$.MODULE$.apply("995"), (DataType)new DecimalType(3, 0), this.cast$default$3()), Decimal$.MODULE$.apply(995), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToDouble((double)Double.NaN), (DataType)DecimalType$.MODULE$.SYSTEM_DEFAULT(), this.cast$default$3()), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToDouble((double)Double.POSITIVE_INFINITY), (DataType)DecimalType$.MODULE$.SYSTEM_DEFAULT(), this.cast$default$3()), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToFloat((float)Float.NaN), (DataType)DecimalType$.MODULE$.SYSTEM_DEFAULT(), this.cast$default$3()), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToFloat((float)Float.POSITIVE_INFINITY), (DataType)DecimalType$.MODULE$.SYSTEM_DEFAULT(), this.cast$default$3()), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToDouble((double)Double.NaN), (DataType)new DecimalType(2, 1), this.cast$default$3()), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToDouble((double)Double.POSITIVE_INFINITY), (DataType)new DecimalType(2, 1), this.cast$default$3()), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToFloat((float)Float.NaN), (DataType)new DecimalType(2, 1), this.cast$default$3()), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToFloat((float)Float.POSITIVE_INFINITY), (DataType)new DecimalType(2, 1), this.cast$default$3()), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToBoolean((boolean)true), (DataType)new DecimalType(2, 1), this.cast$default$3()), Decimal$.MODULE$.apply(1), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToBoolean((boolean)true), (DataType)new DecimalType(1, 1), this.cast$default$3()), null, this.checkEvaluation$default$3());
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_ALLOW_NEGATIVE_SCALE_OF_DECIMAL_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.cast(Decimal$.MODULE$.apply("1003"), (DataType)new DecimalType(3, -1), this.cast$default$3()).nullable(), "CastSuite.this.cast(org.apache.spark.sql.types.Decimal.apply(\"1003\"), org.apache.spark.sql.types.DecimalType.apply(3, -1), CastSuite.this.cast$default$3).nullable", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)this.cast(Decimal$.MODULE$.apply("1003"), (DataType)new DecimalType(4, -1), this.cast$default$3()).nullable()));
                boolean $org_scalatest_assert_macro_right = false;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(this.cast(Decimal$.MODULE$.apply("995"), (DataType)new DecimalType(2, -1), this.cast$default$3()).nullable(), "CastSuite.this.cast(org.apache.spark.sql.types.Decimal.apply(\"995\"), org.apache.spark.sql.types.DecimalType.apply(2, -1), CastSuite.this.cast$default$3).nullable", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)this.cast(Decimal$.MODULE$.apply("995"), (DataType)new DecimalType(3, -1), this.cast$default$3()).nullable()));
                boolean $org_scalatest_assert_macro_right2 = false;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
                this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(Decimal$.MODULE$.apply("1003"), (DataType)new DecimalType(3, -1), this.cast$default$3()), Decimal$.MODULE$.apply(1000), this.checkEvaluation$default$3());
                this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(Decimal$.MODULE$.apply("1003"), (DataType)new DecimalType(2, -2), this.cast$default$3()), Decimal$.MODULE$.apply(1000), this.checkEvaluation$default$3());
                this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(Decimal$.MODULE$.apply("1003"), (DataType)new DecimalType(1, -2), this.cast$default$3()), null, this.checkEvaluation$default$3());
                this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(Decimal$.MODULE$.apply("1003"), (DataType)new DecimalType(2, -1), this.cast$default$3()), null, this.checkEvaluation$default$3());
                this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(Decimal$.MODULE$.apply("995"), (DataType)new DecimalType(3, -1), this.cast$default$3()), Decimal$.MODULE$.apply(1000), this.checkEvaluation$default$3());
                this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(Decimal$.MODULE$.apply("995"), (DataType)new DecimalType(2, -2), this.cast$default$3()), Decimal$.MODULE$.apply(1000), this.checkEvaluation$default$3());
                this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(Decimal$.MODULE$.apply("995"), (DataType)new DecimalType(2, -1), this.cast$default$3()), null, this.checkEvaluation$default$3());
                this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(Decimal$.MODULE$.apply("995"), (DataType)new DecimalType(1, -2), this.cast$default$3()), null, this.checkEvaluation$default$3());
            });
        }, new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
        this.test("SPARK-28470: Cast should honor nullOnOverflow property", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ANSI_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new Cast((Expression)Literal$.MODULE$.apply((Object)"134.12"), (DataType)new DecimalType(3, 2), Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4()), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new Cast((Expression)Literal$.MODULE$.apply((Object)Timestamp.valueOf("2019-07-25 22:04:36")), (DataType)new DecimalType(3, 2), Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4()), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new Cast((Expression)Literal$.MODULE$.apply((Object)package$.MODULE$.BigDecimal().apply(134.12)), (DataType)new DecimalType(3, 2), Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4()), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new Cast((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)134.12)), (DataType)new DecimalType(3, 2), Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4()), null, this.checkEvaluation$default$3());
        }), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
        this.test("collect_list/collect_set can cast to ArrayType not containsNull", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            CollectList list = new CollectList((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), CollectList$.MODULE$.apply$default$2(), CollectList$.MODULE$.apply$default$3());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(Cast$.MODULE$.canCast(list.dataType(), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false)), "Cast.canCast(list.dataType, org.apache.spark.sql.types.ArrayType.apply(org.apache.spark.sql.types.IntegerType, false))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
            CollectSet set = new CollectSet((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), CollectSet$.MODULE$.apply$default$2(), CollectSet$.MODULE$.apply$default$3());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(Cast$.MODULE$.canCast(set.dataType(), (DataType)new ArrayType((DataType)StringType$.MODULE$, false)), "Cast.canCast(set.dataType, org.apache.spark.sql.types.ArrayType.apply(org.apache.spark.sql.types.StringType, false))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 191));
        }, new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
        this.test("NullTypes should be able to cast to any complex types", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(Cast$.MODULE$.canCast((DataType)new ArrayType((DataType)NullType$.MODULE$, true), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true)), "Cast.canCast(org.apache.spark.sql.types.ArrayType.apply(org.apache.spark.sql.types.NullType, true), org.apache.spark.sql.types.ArrayType.apply(org.apache.spark.sql.types.IntegerType, true))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(Cast$.MODULE$.canCast((DataType)new ArrayType((DataType)NullType$.MODULE$, false), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true)), "Cast.canCast(org.apache.spark.sql.types.ArrayType.apply(org.apache.spark.sql.types.NullType, false), org.apache.spark.sql.types.ArrayType.apply(org.apache.spark.sql.types.IntegerType, true))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(Cast$.MODULE$.canCast((DataType)new MapType((DataType)NullType$.MODULE$, (DataType)NullType$.MODULE$, true), (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)IntegerType$.MODULE$, true)), "Cast.canCast(org.apache.spark.sql.types.MapType.apply(org.apache.spark.sql.types.NullType, org.apache.spark.sql.types.NullType, true), org.apache.spark.sql.types.MapType.apply(org.apache.spark.sql.types.IntegerType, org.apache.spark.sql.types.IntegerType, true))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 198));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(Cast$.MODULE$.canCast((DataType)new MapType((DataType)NullType$.MODULE$, (DataType)NullType$.MODULE$, false), (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)IntegerType$.MODULE$, true)), "Cast.canCast(org.apache.spark.sql.types.MapType.apply(org.apache.spark.sql.types.NullType, org.apache.spark.sql.types.NullType, false), org.apache.spark.sql.types.MapType.apply(org.apache.spark.sql.types.IntegerType, org.apache.spark.sql.types.IntegerType, true))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200));
            StructField structField = new StructField("a", (DataType)NullType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
            StructField structField2 = new StructField("a", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(Cast$.MODULE$.canCast((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField)), (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField2))), "Cast.canCast(org.apache.spark.sql.types.StructType.apply({\n  <synthetic> <artifact> val x$1: org.apache.spark.sql.types.StructField = org.apache.spark.sql.types.StructField.apply(\"a\", org.apache.spark.sql.types.NullType, true, org.apache.spark.sql.types.StructField.apply$default$4);\n  scala.collection.immutable.Nil.::[org.apache.spark.sql.types.StructField](x$1)\n}), org.apache.spark.sql.types.StructType.apply({\n  <synthetic> <artifact> val x$2: org.apache.spark.sql.types.StructField = org.apache.spark.sql.types.StructField.apply(\"a\", org.apache.spark.sql.types.IntegerType, true, org.apache.spark.sql.types.StructField.apply$default$4);\n  scala.collection.immutable.Nil.::[org.apache.spark.sql.types.StructField](x$2)\n}))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 203));
            StructField structField3 = new StructField("a", (DataType)NullType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
            StructField structField4 = new StructField("a", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(Cast$.MODULE$.canCast((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField3)), (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField4))), "Cast.canCast(org.apache.spark.sql.types.StructType.apply({\n  <synthetic> <artifact> val x$3: org.apache.spark.sql.types.StructField = org.apache.spark.sql.types.StructField.apply(\"a\", org.apache.spark.sql.types.NullType, false, org.apache.spark.sql.types.StructField.apply$default$4);\n  scala.collection.immutable.Nil.::[org.apache.spark.sql.types.StructField](x$3)\n}), org.apache.spark.sql.types.StructType.apply({\n  <synthetic> <artifact> val x$4: org.apache.spark.sql.types.StructField = org.apache.spark.sql.types.StructField.apply(\"a\", org.apache.spark.sql.types.IntegerType, true, org.apache.spark.sql.types.StructField.apply$default$4);\n  scala.collection.immutable.Nil.::[org.apache.spark.sql.types.StructField](x$4)\n}))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 206));
        }, new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 194));
        this.test("cast string to boolean II", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast("abc", (DataType)BooleanType$.MODULE$, this.cast$default$3()), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast("", (DataType)BooleanType$.MODULE$, this.cast$default$3()), null, this.checkEvaluation$default$3());
        }, new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 211));
        this.test("cast from array II", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Literal array = Literal$.MODULE$.create((Object)new .colon.colon((Object)"123", (List)new .colon.colon((Object)"true", (List)new .colon.colon((Object)"f", (List)new .colon.colon(null, (List)Nil$.MODULE$)))), (DataType)new ArrayType((DataType)StringType$.MODULE$, true));
            Literal array_notNull = Literal$.MODULE$.create((Object)new .colon.colon((Object)"123", (List)new .colon.colon((Object)"true", (List)new .colon.colon((Object)"f", (List)Nil$.MODULE$))), (DataType)new ArrayType((DataType)StringType$.MODULE$, false));
            CastBase ret = this.cast(array, (DataType)new ArrayType((DataType)BooleanType$.MODULE$, true), this.cast$default$3());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(ret.resolved(), "ret.resolved", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 224));
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> ret, Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)false), null})), this.checkEvaluation$default$3());
            CastBase ret2 = this.cast(array_notNull, (DataType)new ArrayType((DataType)BooleanType$.MODULE$, true), this.cast$default$3());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(ret2.resolved(), "ret.resolved", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 230));
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> ret2, Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)false)})), this.checkEvaluation$default$3());
        }, new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 216));
        this.test("cast from map II", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Literal map = Literal$.MODULE$.create((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"123"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)"f"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"d"), null)})), (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)StringType$.MODULE$, true));
            Literal map_notNull = Literal$.MODULE$.create((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"123"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)"f")})), (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)StringType$.MODULE$, false));
            CastBase ret = this.cast(map, (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)BooleanType$.MODULE$, true), this.cast$default$3());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(ret.resolved(), "ret.resolved", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 245));
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> ret, Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), null), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)BoxesRunTime.boxToBoolean((boolean)true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)BoxesRunTime.boxToBoolean((boolean)false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"d"), null)})), this.checkEvaluation$default$3());
            CastBase ret2 = this.cast(map_notNull, (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)BooleanType$.MODULE$, true), this.cast$default$3());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(ret2.resolved(), "ret.resolved", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 251));
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> ret2, Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), null), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)BoxesRunTime.boxToBoolean((boolean)true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)BoxesRunTime.boxToBoolean((boolean)false))})), this.checkEvaluation$default$3());
        }, new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235));
        this.test("cast from struct II", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkNullCast((DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("a", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("b", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))), (DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("a", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("b", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))));
            Literal struct = Literal$.MODULE$.create((Object)InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{UTF8String.fromString((String)"123"), UTF8String.fromString((String)"true"), UTF8String.fromString((String)"f"), null})), (DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("a", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("b", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("c", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("d", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))))));
            Literal struct_notNull = Literal$.MODULE$.create((Object)InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{UTF8String.fromString((String)"123"), UTF8String.fromString((String)"true"), UTF8String.fromString((String)"f")})), (DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("a", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("b", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("c", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))));
            CastBase ret = this.cast(struct, (DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("a", (DataType)BooleanType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("b", (DataType)BooleanType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("c", (DataType)BooleanType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("d", (DataType)BooleanType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))))), this.cast$default$3());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(ret.resolved(), "ret.resolved", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 292));
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> ret, InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)false), null})), this.checkEvaluation$default$3());
            CastBase ret2 = this.cast(struct_notNull, (DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("a", (DataType)BooleanType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("b", (DataType)BooleanType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("c", (DataType)BooleanType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))), this.cast$default$3());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(ret2.resolved(), "ret.resolved", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 301));
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> ret2, InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)false)})), this.checkEvaluation$default$3());
        }, new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 256));
        this.test("SPARK-31227: Non-nullable null type should not coerce to nullable type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> TypeCoercionSuite$.MODULE$.allTypes().foreach((Function1 & Serializable & scala.Serializable)t -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(Cast$.MODULE$.canCast((DataType)new ArrayType((DataType)NullType$.MODULE$, false), (DataType)new ArrayType(t, false)), "Cast.canCast(org.apache.spark.sql.types.ArrayType.apply(org.apache.spark.sql.types.NullType, false), org.apache.spark.sql.types.ArrayType.apply(t, false))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 308));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(Cast$.MODULE$.canCast((DataType)new MapType((DataType)NullType$.MODULE$, (DataType)NullType$.MODULE$, false), (DataType)new MapType(t, t, false)), "Cast.canCast(org.apache.spark.sql.types.MapType.apply(org.apache.spark.sql.types.NullType, org.apache.spark.sql.types.NullType, false), org.apache.spark.sql.types.MapType.apply(t, t, false))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 310));
            StructField structField = new StructField("a", (DataType)NullType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
            StructField structField2 = new StructField("a", t, false, StructField$.MODULE$.apply$default$4());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(Cast$.MODULE$.canCast((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField)), (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField2))), "Cast.canCast(org.apache.spark.sql.types.StructType.apply({\n  <synthetic> <artifact> val x$5: org.apache.spark.sql.types.StructField = org.apache.spark.sql.types.StructField.apply(\"a\", org.apache.spark.sql.types.NullType, false, org.apache.spark.sql.types.StructField.apply$default$4);\n  scala.collection.immutable.Nil.::[org.apache.spark.sql.types.StructField](x$5)\n}), org.apache.spark.sql.types.StructType.apply({\n  <synthetic> <artifact> val x$6: org.apache.spark.sql.types.StructField = org.apache.spark.sql.types.StructField.apply(\"a\", t, false, org.apache.spark.sql.types.StructField.apply$default$4);\n  scala.collection.immutable.Nil.::[org.apache.spark.sql.types.StructField](x$6)\n}))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 313));
        }), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 306));
        this.test("Cast should output null for invalid strings when ANSI is not enabled.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ANSI_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast("abdef", (DataType)DecimalType$.MODULE$.USER_DEFAULT(), this.cast$default$3()), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast("2012-12-11", (DataType)DoubleType$.MODULE$, this.cast$default$3()), null, this.checkEvaluation$default$3());
            Literal array = Literal$.MODULE$.create((Object)new .colon.colon((Object)"123", (List)new .colon.colon((Object)"true", (List)new .colon.colon((Object)"f", (List)new .colon.colon(null, (List)Nil$.MODULE$)))), (DataType)new ArrayType((DataType)StringType$.MODULE$, true));
            Literal array_notNull = Literal$.MODULE$.create((Object)new .colon.colon((Object)"123", (List)new .colon.colon((Object)"true", (List)new .colon.colon((Object)"f", (List)Nil$.MODULE$))), (DataType)new ArrayType((DataType)StringType$.MODULE$, false));
            CastBase ret = this.cast(array, (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), this.cast$default$3());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(ret.resolved(), "ret.resolved", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 332));
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> ret, Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)123), null, null, null})), this.checkEvaluation$default$3());
            CastBase ret2 = this.cast(array, (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), this.cast$default$3());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)ret2.resolved()));
            boolean $org_scalatest_assert_macro_right = false;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 337));
            CastBase ret3 = this.cast(array_notNull, (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), this.cast$default$3());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(ret3.resolved(), "ret.resolved", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 341));
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> ret3, Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)123), null, null})), this.checkEvaluation$default$3());
            CastBase ret4 = this.cast(array_notNull, (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), this.cast$default$3());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)ret4.resolved()));
            boolean $org_scalatest_assert_macro_right2 = false;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 346));
            Literal map = Literal$.MODULE$.create((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"123"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)"f"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"d"), null)})), (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)StringType$.MODULE$, true));
            Literal map_notNull = Literal$.MODULE$.create((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"123"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)"f")})), (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)StringType$.MODULE$, false));
            CastBase ret5 = this.cast(map, (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)IntegerType$.MODULE$, true), this.cast$default$3());
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(ret5.resolved(), "ret.resolved", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 359));
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> ret5, Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)123)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), null), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), null), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"d"), null)})), this.checkEvaluation$default$3());
            CastBase ret6 = this.cast(map, (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)IntegerType$.MODULE$, false), this.cast$default$3());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)ret6.resolved()));
            boolean $org_scalatest_assert_macro_right3 = false;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 364));
            CastBase ret7 = this.cast(map_notNull, (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)IntegerType$.MODULE$, true), this.cast$default$3());
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(ret7.resolved(), "ret.resolved", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 368));
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> ret7, Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)123)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), null), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), null)})), this.checkEvaluation$default$3());
            CastBase ret8 = this.cast(map_notNull, (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)IntegerType$.MODULE$, false), this.cast$default$3());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)ret8.resolved()));
            boolean $org_scalatest_assert_macro_right4 = false;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 373));
            Literal struct = Literal$.MODULE$.create((Object)InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{UTF8String.fromString((String)"123"), UTF8String.fromString((String)"true"), UTF8String.fromString((String)"f"), null})), (DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("a", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("b", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("c", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("d", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))))));
            Literal struct_notNull = Literal$.MODULE$.create((Object)InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{UTF8String.fromString((String)"123"), UTF8String.fromString((String)"true"), UTF8String.fromString((String)"f")})), (DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("a", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("b", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("c", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))));
            CastBase ret9 = this.cast(struct, (DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("a", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("b", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("c", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("d", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))))), this.cast$default$3());
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(ret9.resolved(), "ret.resolved", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 404));
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> ret9, InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)123), null, null, null})), this.checkEvaluation$default$3());
            CastBase ret10 = this.cast(struct, (DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("a", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("b", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("c", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("d", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))))), this.cast$default$3());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)ret10.resolved()));
            boolean $org_scalatest_assert_macro_right5 = false;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 413));
            CastBase ret11 = this.cast(struct_notNull, (DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("a", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("b", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("c", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))), this.cast$default$3());
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.simpleMacroBool(ret11.resolved(), "ret.resolved", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 420));
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> ret11, InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)123), null, null})), this.checkEvaluation$default$3());
            CastBase ret12 = this.cast(struct_notNull, (DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("a", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("b", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("c", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))), this.cast$default$3());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)ret12.resolved()));
            boolean $org_scalatest_assert_macro_right6 = false;
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 428));
            ((IterableLike)new .colon.colon((Object)DoubleType$.MODULE$, (List)new .colon.colon((Object)FloatType$.MODULE$, (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)dataType -> {
                this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> $this.cast("badvalue", (DataType)dataType, $this.cast$default$3()), null, this.checkEvaluation$default$3());
                return BoxedUnit.UNIT;
            });
        }), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 319));
        this.test("cast from date", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Date d = Date.valueOf("1970-01-01");
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(d, (DataType)ShortType$.MODULE$, this.cast$default$3()), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(d, (DataType)IntegerType$.MODULE$, this.cast$default$3()), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(d, (DataType)LongType$.MODULE$, this.cast$default$3()), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(d, (DataType)FloatType$.MODULE$, this.cast$default$3()), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(d, (DataType)DoubleType$.MODULE$, this.cast$default$3()), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(d, (DataType)DecimalType$.MODULE$.SYSTEM_DEFAULT(), this.cast$default$3()), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(d, (DataType)new DecimalType(10, 2), this.cast$default$3()), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(d, (DataType)StringType$.MODULE$, this.cast$default$3()), "1970-01-01", this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(this.cast(d, (DataType)TimestampType$.MODULE$, DateTimeTestUtils$.MODULE$.UTC_OPT()), (DataType)StringType$.MODULE$, DateTimeTestUtils$.MODULE$.UTC_OPT()), "1970-01-01 00:00:00", this.checkEvaluation$default$3());
        }, new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 438));
        this.test("cast from timestamp", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int millis = 15003;
            int seconds = millis * 1000 + 3;
            Timestamp ts = new Timestamp(millis);
            Timestamp tss = new Timestamp(seconds);
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(ts, (DataType)ShortType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToShort((short)((short)15)), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(ts, (DataType)IntegerType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToInteger((int)15), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(ts, (DataType)LongType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToLong((long)15), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(ts, (DataType)FloatType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToFloat((float)15.003f), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(ts, (DataType)DoubleType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToDouble((double)15.003), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(this.cast(tss, (DataType)ShortType$.MODULE$, this.cast$default$3()), (DataType)TimestampType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToLong((long)(DateTimeUtils$.MODULE$.fromJavaTimestamp(ts) * 1000L)), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(this.cast(tss, (DataType)IntegerType$.MODULE$, this.cast$default$3()), (DataType)TimestampType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToLong((long)(DateTimeUtils$.MODULE$.fromJavaTimestamp(ts) * 1000L)), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(this.cast(tss, (DataType)LongType$.MODULE$, this.cast$default$3()), (DataType)TimestampType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToLong((long)(DateTimeUtils$.MODULE$.fromJavaTimestamp(ts) * 1000L)), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(this.cast(BoxesRunTime.boxToFloat((float)((float)millis / (float)1000L)), (DataType)TimestampType$.MODULE$, this.cast$default$3()), (DataType)FloatType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToFloat((float)((float)millis / (float)1000L)), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(this.cast(BoxesRunTime.boxToDouble((double)((double)millis / (double)1000L)), (DataType)TimestampType$.MODULE$, this.cast$default$3()), (DataType)DoubleType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToDouble((double)((double)millis / (double)1000L)), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(this.cast(Decimal$.MODULE$.apply(1), (DataType)TimestampType$.MODULE$, this.cast$default$3()), (DataType)DecimalType$.MODULE$.SYSTEM_DEFAULT(), this.cast$default$3()), Decimal$.MODULE$.apply(1), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(this.cast(BoxesRunTime.boxToDouble((double)1.0E-6), (DataType)TimestampType$.MODULE$, this.cast$default$3()), (DataType)DoubleType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToDouble((double)1.0E-6), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToDouble((double)Double.NaN), (DataType)TimestampType$.MODULE$, this.cast$default$3()), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToDouble((double)Double.POSITIVE_INFINITY), (DataType)TimestampType$.MODULE$, this.cast$default$3()), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToFloat((float)Float.NaN), (DataType)TimestampType$.MODULE$, this.cast$default$3()), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToFloat((float)Float.POSITIVE_INFINITY), (DataType)TimestampType$.MODULE$, this.cast$default$3()), null, this.checkEvaluation$default$3());
        }, new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 454));
        this.test("cast a timestamp before the epoch 1970-01-01 00:00:00Z", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DateTimeTestUtils$.MODULE$.withDefaultTimeZone(DateTimeTestUtils$.MODULE$.UTC(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Timestamp negativeTs = Timestamp.valueOf("1900-05-05 18:34:56.1");
            long $org_scalatest_assert_macro_left = negativeTs.getTime();
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 493));
            long expectedSecs = Math.floorDiv(negativeTs.getTime(), 1000L);
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(negativeTs, (DataType)ByteType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToByte((byte)((byte)expectedSecs)), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(negativeTs, (DataType)ShortType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToShort((short)((short)expectedSecs)), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(negativeTs, (DataType)IntegerType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToInteger((int)((int)expectedSecs)), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(negativeTs, (DataType)LongType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToLong((long)expectedSecs), this.checkEvaluation$default$3());
        }), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 490));
        this.test("SPARK-32828: cast from a derived user-defined type to a base type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Literal v = Literal$.MODULE$.create((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})), (DataType)new ExampleSubTypeUDT());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(v, (DataType)new ExampleBaseTypeUDT(), this.cast$default$3()), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})), this.checkEvaluation$default$3());
        }, new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 502));
        this.test("Fast fail for cast string type to decimal type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast("12345678901234567890123456789012345678", (DataType)new DecimalType(38, 0), this.cast$default$3()), Decimal$.MODULE$.apply("12345678901234567890123456789012345678"), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast("123456789012345678901234567890123456789", (DataType)new DecimalType(38, 0), this.cast$default$3()), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast("12345678901234567890123456789012345678", (DataType)new DecimalType(38, 1), this.cast$default$3()), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast("0.00000000000000000000000000000000000001", (DataType)new DecimalType(38, 0), this.cast$default$3()), Decimal$.MODULE$.apply("0"), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast("0.00000000000000000000000000000000000000000001", (DataType)new DecimalType(38, 0), this.cast$default$3()), Decimal$.MODULE$.apply("0"), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast("0.00000000000000000000000000000000000001", (DataType)new DecimalType(38, 18), this.cast$default$3()), Decimal$.MODULE$.apply("0E-18"), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast("6E-120", (DataType)new DecimalType(38, 0), this.cast$default$3()), Decimal$.MODULE$.apply("0"), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast("6E+37", (DataType)new DecimalType(38, 0), this.cast$default$3()), Decimal$.MODULE$.apply("60000000000000000000000000000000000000"), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast("6E+38", (DataType)new DecimalType(38, 0), this.cast$default$3()), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast("6E+37", (DataType)new DecimalType(38, 1), this.cast$default$3()), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast("abcd", (DataType)new DecimalType(38, 1), this.cast$default$3()), null, this.checkEvaluation$default$3());
        }, new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 507));
        this.test("data type casting II", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(this.cast(this.cast(this.cast(this.cast(this.cast("5", (DataType)ByteType$.MODULE$, this.cast$default$3()), (DataType)TimestampType$.MODULE$, this.cast$default$3()), (DataType)DecimalType$.MODULE$.SYSTEM_DEFAULT(), this.cast$default$3()), (DataType)LongType$.MODULE$, this.cast$default$3()), (DataType)StringType$.MODULE$, this.cast$default$3()), (DataType)ShortType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToShort((short)((short)5)), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(this.cast(this.cast(this.cast(this.cast(this.cast("5", (DataType)TimestampType$.MODULE$, DateTimeTestUtils$.MODULE$.UTC_OPT()), (DataType)ByteType$.MODULE$, this.cast$default$3()), (DataType)DecimalType$.MODULE$.SYSTEM_DEFAULT(), this.cast$default$3()), (DataType)LongType$.MODULE$, this.cast$default$3()), (DataType)StringType$.MODULE$, this.cast$default$3()), (DataType)ShortType$.MODULE$, this.cast$default$3()), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(this.cast(this.cast(this.cast(this.cast(this.cast("5", (DataType)DecimalType$.MODULE$.SYSTEM_DEFAULT(), this.cast$default$3()), (DataType)ByteType$.MODULE$, this.cast$default$3()), (DataType)TimestampType$.MODULE$, this.cast$default$3()), (DataType)LongType$.MODULE$, this.cast$default$3()), (DataType)StringType$.MODULE$, this.cast$default$3()), (DataType)ShortType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToShort((short)((short)5)), this.checkEvaluation$default$3());
        }, new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 530));
        this.test("Cast from double II", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(this.cast(BoxesRunTime.boxToDouble((double)1.0), (DataType)TimestampType$.MODULE$, this.cast$default$3()), (DataType)DoubleType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToDouble((double)1.0), this.checkEvaluation$default$3()), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 544));
        this.test("SPARK-34727: cast from float II", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkCast(BoxesRunTime.boxToFloat((float)1.6777215E7f), Instant.ofEpochSecond(0xFFFFFFL)), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 548));
        this.test("SPARK-34744: Improve error message for casting cause overflow error", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ANSI_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String e3;
            String e2;
            String e1;
            String $org_scalatest_assert_macro_left = e1 = ((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> {
                Cast qual$1 = new Cast((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)128)), (DataType)ByteType$.MODULE$, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4());
                InternalRow x$1 = qual$1.eval$default$1();
                return qual$1.eval(x$1);
            }, ClassTag$.MODULE$.apply(ArithmeticException.class), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 554))).getMessage();
            String $org_scalatest_assert_macro_right = "Casting 128 to tinyint causes overflow";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 557));
            String $org_scalatest_assert_macro_left2 = e2 = ((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> {
                Cast qual$2 = new Cast((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)32768)), (DataType)ShortType$.MODULE$, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4());
                InternalRow x$2 = qual$2.eval$default$1();
                return qual$2.eval(x$2);
            }, ClassTag$.MODULE$.apply(ArithmeticException.class), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 558))).getMessage();
            String $org_scalatest_assert_macro_right2 = "Casting 32768 to smallint causes overflow";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 561));
            String $org_scalatest_assert_macro_left3 = e3 = ((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> {
                Cast qual$3 = new Cast((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)0x80000000L)), (DataType)IntegerType$.MODULE$, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4());
                InternalRow x$3 = qual$3.eval$default$1();
                return qual$3.eval(x$3);
            }, ClassTag$.MODULE$.apply(ArithmeticException.class), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 562))).getMessage();
            String $org_scalatest_assert_macro_right3 = "Casting 2147483648 to int causes overflow";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 565));
        }), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 552));
        this.test("SPARK-35720: cast invalid string input to timestamp without time zone", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"00:00:00", (List)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"123", (List)new .colon.colon((Object)"a2021-06-17", (List)new .colon.colon((Object)"2021-06-17abc", (List)new .colon.colon((Object)"2021-06-17 00:00:00ABC", (List)Nil$.MODULE$))))))).foreach((Function1 & Serializable & scala.Serializable)invalidInput -> {
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> $this.cast(invalidInput, (DataType)TimestampNTZType$.MODULE$, $this.cast$default$3()), null, this.checkEvaluation$default$3());
            return BoxedUnit.UNIT;
        }), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 569));
        this.test("SPARK-36286: invalid string cast to timestamp", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(Literal$.MODULE$.apply((Object)"2015-03-18T"), (DataType)TimestampType$.MODULE$, this.cast$default$3()), null, this.checkEvaluation$default$3()), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 580));
    }
}

