/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.DateTimeException;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.expressions.CastBase;
import org.apache.spark.sql.catalyst.expressions.CastSuiteBase;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.util.DateTimeTestUtils$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypeTestUtils$;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.FractionalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t3QAB\u0004\u0002\u0002QAQ!\u0007\u0001\u0005\u0002iAQ\u0001\b\u0001\u0005\nuAQ\u0001\f\u0001\u0005\n5BQa\f\u0001\u0005\u0012ABQ!\u0010\u0001\u0005\u0012y\u0012\u0011#\u00118tS\u000e\u000b7\u000f^*vSR,')Y:f\u0015\tA\u0011\"A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\u0006\f\u0003!\u0019\u0017\r^1msN$(B\u0001\u0007\u000e\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u001d=\tQa\u001d9be.T!\u0001E\t\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0011\u0012aA8sO\u000e\u00011C\u0001\u0001\u0016!\t1r#D\u0001\b\u0013\tArAA\u0007DCN$8+^5uK\n\u000b7/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003m\u0001\"A\u0006\u0001\u0002!Q,7\u000f^%oi6\u000b\u00070\u00118e\u001b&tGC\u0001\u0010%!\ty\"%D\u0001!\u0015\u0005\t\u0013!B:dC2\f\u0017BA\u0012!\u0005\u0011)f.\u001b;\t\u000b\u0015\u0012\u0001\u0019\u0001\u0014\u0002\u0005\u0011$\bCA\u0014+\u001b\u0005A#BA\u0015\f\u0003\u0015!\u0018\u0010]3t\u0013\tY\u0003F\u0001\u0005ECR\fG+\u001f9f\u0003E!Xm\u001d;M_:<W*\u0019=B]\u0012l\u0015N\u001c\u000b\u0003=9BQ!J\u0002A\u0002\u0019\nqc\u00195fG.\u001c\u0015m\u001d;U_:+X.\u001a:jG\u0016\u0013(o\u001c:\u0015\ty\td\u0007\u000f\u0005\u0006e\u0011\u0001\raM\u0001\u0002YB\u0011a\u0003N\u0005\u0003k\u001d\u0011q\u0001T5uKJ\fG\u000eC\u00038\t\u0001\u0007a%\u0001\u0002u_\")\u0011\b\u0002a\u0001u\u0005iAO]=DCN$(+Z:vYR\u0004\"aH\u001e\n\u0005q\u0002#aA!os\u000692\r[3dW\u000e\u000b7\u000f\u001e+p\u0005>|G.Z1o\u000bJ\u0014xN\u001d\u000b\u0005=}\u0002\u0015\tC\u00033\u000b\u0001\u00071\u0007C\u00038\u000b\u0001\u0007a\u0005C\u0003:\u000b\u0001\u0007!\b")
public abstract class AnsiCastSuiteBase
extends CastSuiteBase {
    private void testIntMaxAndMin(DataType dt) {
        Seq $org_scalatest_assert_macro_left = (Seq)new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)ShortType$.MODULE$, (List)new .colon.colon((Object)ByteType$.MODULE$, (List)Nil$.MODULE$)));
        DataType $org_scalatest_assert_macro_right = dt;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0x80000000L, -2147483649L}))).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)value -> {
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToLong((long)value), dt, this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(Decimal$.MODULE$.apply(Long.toString(value)), dt, this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(new Literal((Object)BoxesRunTime.boxToFloat((float)((float)((double)value * 1.5))), (DataType)FloatType$.MODULE$), dt, this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(new Literal((Object)BoxesRunTime.boxToDouble((double)((double)value * 1.0)), (DataType)DoubleType$.MODULE$), dt, this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
        });
    }

    private void testLongMaxAndMin(DataType dt) {
        Seq $org_scalatest_assert_macro_left = (Seq)new .colon.colon((Object)LongType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$));
        DataType $org_scalatest_assert_macro_right = dt;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
        ((IterableLike)new .colon.colon((Object)Decimal$.MODULE$.apply(Long.MAX_VALUE).$plus(Decimal$.MODULE$.apply(1)), (List)new .colon.colon((Object)Decimal$.MODULE$.apply(Long.MIN_VALUE).$minus(Decimal$.MODULE$.apply(1)), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)value -> {
            AnsiCastSuiteBase.$anonfun$testLongMaxAndMin$1(this, dt, value);
            return BoxedUnit.UNIT;
        });
    }

    public void checkCastToNumericError(Literal l, DataType to, Object tryCastResult) {
        this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(l, to, this.cast$default$3()), "invalid input syntax for type numeric: true", ClassTag$.MODULE$.apply(NumberFormatException.class));
    }

    public void checkCastToBooleanError(Literal l, DataType to, Object tryCastResult) {
        this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(l, to, this.cast$default$3()), "invalid input syntax for type boolean", ClassTag$.MODULE$.apply(UnsupportedOperationException.class));
    }

    public static final /* synthetic */ void $anonfun$testLongMaxAndMin$1(AnsiCastSuiteBase $this, DataType dt$2, Decimal value) {
        $this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> $this.cast(value, dt$2, $this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
        $this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> $this.cast(BoxesRunTime.boxToFloat((float)value.$times(Decimal$.MODULE$.apply(1.1)).toFloat()), dt$2, $this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
        $this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> $this.cast(BoxesRunTime.boxToDouble((double)value.$times(Decimal$.MODULE$.apply(1.1)).toDouble()), dt$2, $this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
    }

    public static final /* synthetic */ void $anonfun$new$6(AnsiCastSuiteBase $this, byte value) {
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> $this.cast(BoxesRunTime.boxToByte((byte)value), (DataType)ByteType$.MODULE$, $this.cast$default$3()), BoxesRunTime.boxToByte((byte)value), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> $this.cast(Byte.toString(value), (DataType)ByteType$.MODULE$, $this.cast$default$3()), BoxesRunTime.boxToByte((byte)value), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> $this.cast(Decimal$.MODULE$.apply(Byte.toString(value)), (DataType)ByteType$.MODULE$, $this.cast$default$3()), BoxesRunTime.boxToByte((byte)value), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> $this.cast(new Literal((Object)BoxesRunTime.boxToFloat((float)value), (DataType)FloatType$.MODULE$), (DataType)ByteType$.MODULE$, $this.cast$default$3()), BoxesRunTime.boxToByte((byte)value), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> $this.cast(new Literal((Object)BoxesRunTime.boxToDouble((double)value), (DataType)DoubleType$.MODULE$), (DataType)ByteType$.MODULE$, $this.cast$default$3()), BoxesRunTime.boxToByte((byte)value), $this.checkEvaluation$default$3());
    }

    public static final /* synthetic */ void $anonfun$new$17(AnsiCastSuiteBase $this, short value) {
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> $this.cast(BoxesRunTime.boxToShort((short)value), (DataType)ShortType$.MODULE$, $this.cast$default$3()), BoxesRunTime.boxToShort((short)value), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> $this.cast(Short.toString(value), (DataType)ShortType$.MODULE$, $this.cast$default$3()), BoxesRunTime.boxToShort((short)value), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> $this.cast(Decimal$.MODULE$.apply(Short.toString(value)), (DataType)ShortType$.MODULE$, $this.cast$default$3()), BoxesRunTime.boxToShort((short)value), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> $this.cast(new Literal((Object)BoxesRunTime.boxToFloat((float)value), (DataType)FloatType$.MODULE$), (DataType)ShortType$.MODULE$, $this.cast$default$3()), BoxesRunTime.boxToShort((short)value), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> $this.cast(new Literal((Object)BoxesRunTime.boxToDouble((double)value), (DataType)DoubleType$.MODULE$), (DataType)ShortType$.MODULE$, $this.cast$default$3()), BoxesRunTime.boxToShort((short)value), $this.checkEvaluation$default$3());
    }

    public static final /* synthetic */ void $anonfun$new$52(AnsiCastSuiteBase $this, IntegralType dataType) {
        $this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> $this.cast("string", (DataType)dataType, $this.cast$default$3()), "invalid input syntax for type numeric: string", ClassTag$.MODULE$.apply(NumberFormatException.class));
        $this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> $this.cast("123-string", (DataType)dataType, $this.cast$default$3()), "invalid input syntax for type numeric: 123-string", ClassTag$.MODULE$.apply(NumberFormatException.class));
        $this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> $this.cast("2020-07-19", (DataType)dataType, $this.cast$default$3()), "invalid input syntax for type numeric: 2020-07-19", ClassTag$.MODULE$.apply(NumberFormatException.class));
        $this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> $this.cast("1.23", (DataType)dataType, $this.cast$default$3()), "invalid input syntax for type numeric: 1.23", ClassTag$.MODULE$.apply(NumberFormatException.class));
    }

    public static final /* synthetic */ void $anonfun$new$57(AnsiCastSuiteBase $this, FractionalType dataType) {
        $this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> $this.cast("string", (DataType)dataType, $this.cast$default$3()), "invalid input syntax for type numeric: string", ClassTag$.MODULE$.apply(NumberFormatException.class));
        $this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> $this.cast("123.000.00", (DataType)dataType, $this.cast$default$3()), "invalid input syntax for type numeric: 123.000.00", ClassTag$.MODULE$.apply(NumberFormatException.class));
        $this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> $this.cast("abc.com", (DataType)dataType, $this.cast$default$3()), "invalid input syntax for type numeric: abc.com", ClassTag$.MODULE$.apply(NumberFormatException.class));
    }

    private final void checkCastWithParseError$1(String str, ZoneId zid$1) {
        this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(Literal$.MODULE$.apply((Object)str), (DataType)TimestampType$.MODULE$, (Option<String>)Option$.MODULE$.apply((Object)zid$1.getId())), new StringBuilder(30).append("Cannot cast ").append(str).append(" to TimestampType.").toString(), ClassTag$.MODULE$.apply(DateTimeException.class));
    }

    public static final /* synthetic */ void $anonfun$new$79(AnsiCastSuiteBase $this, ZoneId zid) {
        $this.checkCastWithParseError$1("123", zid);
        $this.checkCastWithParseError$1("2015-03-18 123142", zid);
        $this.checkCastWithParseError$1("2015-03-18T123123", zid);
        $this.checkCastWithParseError$1("2015-03-18X", zid);
        $this.checkCastWithParseError$1("2015/03/18", zid);
        $this.checkCastWithParseError$1("2015.03.18", zid);
        $this.checkCastWithParseError$1("20150318", zid);
        $this.checkCastWithParseError$1("2015-031-8", zid);
        $this.checkCastWithParseError$1("2015-03-18T12:03:17-0:70", zid);
        $this.checkCastWithParseError$1("abdef", zid);
    }

    private final void checkCastWithParseError$2(String str, ZoneId zid$2) {
        this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(Literal$.MODULE$.apply((Object)str), (DataType)DateType$.MODULE$, (Option<String>)Option$.MODULE$.apply((Object)zid$2.getId())), new StringBuilder(25).append("Cannot cast ").append(str).append(" to DateType.").toString(), ClassTag$.MODULE$.apply(DateTimeException.class));
    }

    public static final /* synthetic */ void $anonfun$new$82(AnsiCastSuiteBase $this, ZoneId zid) {
        $this.checkCastWithParseError$2("2015-13-18", zid);
        $this.checkCastWithParseError$2("2015-03-128", zid);
        $this.checkCastWithParseError$2("2015/03/18", zid);
        $this.checkCastWithParseError$2("2015.03.18", zid);
        $this.checkCastWithParseError$2("20150318", zid);
        $this.checkCastWithParseError$2("2015-031-8", zid);
        $this.checkCastWithParseError$2("2015-03-18ABC", zid);
        $this.checkCastWithParseError$2("abdef", zid);
    }

    public AnsiCastSuiteBase() {
        this.test("ANSI mode: Throw exception on casting out-of-range value to byte type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.testIntMaxAndMin((DataType)ByteType$.MODULE$);
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{128, -129}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)value -> {
                this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToInteger((int)value), (DataType)ByteType$.MODULE$, this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
                this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(new Literal((Object)BoxesRunTime.boxToFloat((float)value), (DataType)FloatType$.MODULE$), (DataType)ByteType$.MODULE$, this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
                this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(new Literal((Object)BoxesRunTime.boxToDouble((double)value), (DataType)DoubleType$.MODULE$), (DataType)ByteType$.MODULE$, this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
            });
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{127, (byte)0, -128}))).foreach((Function1 & Serializable & scala.Serializable)value -> {
                AnsiCastSuiteBase.$anonfun$new$6(this, BoxesRunTime.unboxToByte((Object)value));
                return BoxedUnit.UNIT;
            });
        }, new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
        this.test("ANSI mode: Throw exception on casting out-of-range value to short type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.testIntMaxAndMin((DataType)ShortType$.MODULE$);
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{32768, -32769}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)value -> {
                this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToInteger((int)value), (DataType)ShortType$.MODULE$, this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
                this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(new Literal((Object)BoxesRunTime.boxToFloat((float)value), (DataType)FloatType$.MODULE$), (DataType)ShortType$.MODULE$, this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
                this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(new Literal((Object)BoxesRunTime.boxToDouble((double)value), (DataType)DoubleType$.MODULE$), (DataType)ShortType$.MODULE$, this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
            });
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapShortArray(new short[]{Short.MAX_VALUE, (short)0, Short.MIN_VALUE}))).foreach((Function1 & Serializable & scala.Serializable)value -> {
                AnsiCastSuiteBase.$anonfun$new$17(this, BoxesRunTime.unboxToShort((Object)value));
                return BoxedUnit.UNIT;
            });
        }, new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
        this.test("ANSI mode: Throw exception on casting out-of-range value to int type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.testIntMaxAndMin((DataType)IntegerType$.MODULE$);
            this.testLongMaxAndMin((DataType)IntegerType$.MODULE$);
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{Integer.MAX_VALUE, 0, Integer.MIN_VALUE}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)value -> {
                this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToInteger((int)value), (DataType)IntegerType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToInteger((int)value), this.checkEvaluation$default$3());
                this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(Integer.toString(value), (DataType)IntegerType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToInteger((int)value), this.checkEvaluation$default$3());
                this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(Decimal$.MODULE$.apply(Integer.toString(value)), (DataType)IntegerType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToInteger((int)value), this.checkEvaluation$default$3());
                this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(new Literal((Object)BoxesRunTime.boxToDouble((double)((double)value * 1.0)), (DataType)DoubleType$.MODULE$), (DataType)IntegerType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToInteger((int)value), this.checkEvaluation$default$3());
            });
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToDouble((double)2.1474836479E9), (DataType)IntegerType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToDouble((double)-2.1474836489E9), (DataType)IntegerType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToInteger((int)Integer.MIN_VALUE), this.checkEvaluation$default$3());
        }, new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
        this.test("ANSI mode: Throw exception on casting out-of-range value to long type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.testLongMaxAndMin((DataType)LongType$.MODULE$);
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{Long.MAX_VALUE, 0L, Long.MIN_VALUE}))).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)value -> {
                this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToLong((long)value), (DataType)LongType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToLong((long)value), this.checkEvaluation$default$3());
                this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(Long.toString(value), (DataType)LongType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToLong((long)value), this.checkEvaluation$default$3());
                this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(Decimal$.MODULE$.apply(Long.toString(value)), (DataType)LongType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToLong((long)value), this.checkEvaluation$default$3());
            });
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToFloat((float)9.223372E18f), (DataType)LongType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToLong((long)Long.MAX_VALUE), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToFloat((float)-9.223372E18f), (DataType)LongType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToLong((long)Long.MIN_VALUE), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToDouble((double)9.223372036854776E18), (DataType)LongType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToLong((long)Long.MAX_VALUE), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToDouble((double)-9.223372036854776E18), (DataType)LongType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToLong((long)Long.MIN_VALUE), this.checkEvaluation$default$3());
        }, new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
        this.test("ANSI mode: Throw exception on casting out-of-range value to decimal type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(Literal$.MODULE$.apply((Object)"134.12"), (DataType)new DecimalType(3, 2), this.cast$default$3()), "cannot be represented", ClassTag$.MODULE$.apply(ArithmeticException.class));
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(Literal$.MODULE$.apply((Object)package$.MODULE$.BigDecimal().apply(134.12)), (DataType)new DecimalType(3, 2), this.cast$default$3()), "cannot be represented", ClassTag$.MODULE$.apply(ArithmeticException.class));
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)134.12)), (DataType)new DecimalType(3, 2), this.cast$default$3()), "cannot be represented", ClassTag$.MODULE$.apply(ArithmeticException.class));
        }, new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
        this.test("ANSI mode: disallow type conversions between Numeric types and Timestamp type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkInvalidCastFromNumericType((DataType)TimestampType$.MODULE$);
            ObjectRef errorMsg = ObjectRef.create((Object)"you can use functions TIMESTAMP_SECONDS/TIMESTAMP_MILLIS/TIMESTAMP_MICROS instead");
            this.verifyCastFailure(this.cast(Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)0L)), (DataType)TimestampType$.MODULE$, this.cast$default$3()), (Option<String>)new Some((Object)((String)errorMsg.elem)));
            Literal timestampLiteral = new Literal((Object)BoxesRunTime.boxToLong((long)1L), (DataType)TimestampType$.MODULE$);
            errorMsg.elem = "you can use functions UNIX_SECONDS/UNIX_MILLIS/UNIX_MICROS instead.";
            DataTypeTestUtils$.MODULE$.numericTypes().foreach((Function1 & Serializable & scala.Serializable)numericType -> {
                this.verifyCastFailure(this.cast(timestampLiteral, (DataType)numericType, this.cast$default$3()), (Option<String>)new Some((Object)((String)errorMsg.elem)));
                return BoxedUnit.UNIT;
            });
        }, new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
        this.test("ANSI mode: disallow type conversions between Numeric types and Date type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkInvalidCastFromNumericType((DataType)DateType$.MODULE$);
            ObjectRef errorMsg = ObjectRef.create((Object)"you can use function DATE_FROM_UNIX_DATE instead");
            this.verifyCastFailure(this.cast(Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)0L)), (DataType)DateType$.MODULE$, this.cast$default$3()), (Option<String>)new Some((Object)((String)errorMsg.elem)));
            Literal dateLiteral = new Literal((Object)BoxesRunTime.boxToInteger((int)1), (DataType)DateType$.MODULE$);
            errorMsg.elem = "you can use function UNIX_DATE instead";
            DataTypeTestUtils$.MODULE$.numericTypes().foreach((Function1 & Serializable & scala.Serializable)numericType -> {
                this.verifyCastFailure(this.cast(dateLiteral, (DataType)numericType, this.cast$default$3()), (Option<String>)new Some((Object)((String)errorMsg.elem)));
                return BoxedUnit.UNIT;
            });
        }, new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
        this.test("ANSI mode: disallow type conversions between Numeric types and Binary type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkInvalidCastFromNumericType((DataType)BinaryType$.MODULE$);
            Literal binaryLiteral = new Literal((Object)new byte[(byte)1], (DataType)BinaryType$.MODULE$);
            DataTypeTestUtils$.MODULE$.numericTypes().foreach((Function1 & Serializable & scala.Serializable)numericType -> {
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.cast(binaryLiteral, (DataType)numericType, this.cast$default$3()).checkInputDataTypes().isFailure(), "AnsiCastSuiteBase.this.cast(binaryLiteral, numericType, AnsiCastSuiteBase.this.cast$default$3).checkInputDataTypes().isFailure", Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
            });
        }, new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
        this.test("ANSI mode: disallow type conversions between Datatime types and Boolean types", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Literal timestampLiteral = new Literal((Object)BoxesRunTime.boxToLong((long)1L), (DataType)TimestampType$.MODULE$);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.cast(timestampLiteral, (DataType)BooleanType$.MODULE$, this.cast$default$3()).checkInputDataTypes().isFailure(), "AnsiCastSuiteBase.this.cast(timestampLiteral, org.apache.spark.sql.types.BooleanType, AnsiCastSuiteBase.this.cast$default$3).checkInputDataTypes().isFailure", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
            Literal dateLiteral = new Literal((Object)BoxesRunTime.boxToInteger((int)1), (DataType)DateType$.MODULE$);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.cast(dateLiteral, (DataType)BooleanType$.MODULE$, this.cast$default$3()).checkInputDataTypes().isFailure(), "AnsiCastSuiteBase.this.cast(dateLiteral, org.apache.spark.sql.types.BooleanType, AnsiCastSuiteBase.this.cast$default$3).checkInputDataTypes().isFailure", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
            Literal booleanLiteral = new Literal((Object)BoxesRunTime.boxToBoolean((boolean)true), (DataType)BooleanType$.MODULE$);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(this.cast(booleanLiteral, (DataType)TimestampType$.MODULE$, this.cast$default$3()).checkInputDataTypes().isFailure(), "AnsiCastSuiteBase.this.cast(booleanLiteral, org.apache.spark.sql.types.TimestampType, AnsiCastSuiteBase.this.cast$default$3).checkInputDataTypes().isFailure", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(this.cast(booleanLiteral, (DataType)DateType$.MODULE$, this.cast$default$3()).checkInputDataTypes().isFailure(), "AnsiCastSuiteBase.this.cast(booleanLiteral, org.apache.spark.sql.types.DateType, AnsiCastSuiteBase.this.cast$default$3).checkInputDataTypes().isFailure", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
        }, new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
        this.test("cast from invalid string to numeric should throw NumberFormatException", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ((IterableLike)new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)ShortType$.MODULE$, (List)new .colon.colon((Object)ByteType$.MODULE$, (List)new .colon.colon((Object)LongType$.MODULE$, (List)Nil$.MODULE$))))).foreach((Function1 & Serializable & scala.Serializable)dataType -> {
                AnsiCastSuiteBase.$anonfun$new$52(this, dataType);
                return BoxedUnit.UNIT;
            });
            ((IterableLike)new .colon.colon((Object)DoubleType$.MODULE$, (List)new .colon.colon((Object)FloatType$.MODULE$, (List)new .colon.colon((Object)DecimalType$.MODULE$.USER_DEFAULT(), (List)Nil$.MODULE$)))).foreach((Function1 & Serializable & scala.Serializable)dataType -> {
                AnsiCastSuiteBase.$anonfun$new$57(this, dataType);
                return BoxedUnit.UNIT;
            });
        }, new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
        this.test("cast from invalid string array to numeric array should throw NumberFormatException", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Literal array = Literal$.MODULE$.create((Object)new .colon.colon((Object)"123", (List)new .colon.colon((Object)"true", (List)new .colon.colon((Object)"f", (List)new .colon.colon(null, (List)Nil$.MODULE$)))), (DataType)new ArrayType((DataType)StringType$.MODULE$, true));
            this.checkCastToNumericError(array, (DataType)new ArrayType((DataType)ByteType$.MODULE$, true), Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)((byte)123)), null, null, null})));
            this.checkCastToNumericError(array, (DataType)new ArrayType((DataType)ShortType$.MODULE$, true), Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)((short)123)), null, null, null})));
            this.checkCastToNumericError(array, (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)123), null, null, null})));
            this.checkCastToNumericError(array, (DataType)new ArrayType((DataType)LongType$.MODULE$, true), Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)123L), null, null, null})));
        }, new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 211));
        this.test("Fast fail for cast string type to decimal type in ansi mode", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast("12345678901234567890123456789012345678", (DataType)new DecimalType(38, 0), this.cast$default$3()), Decimal$.MODULE$.apply("12345678901234567890123456789012345678"), this.checkEvaluation$default$3());
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast("123456789012345678901234567890123456789", (DataType)new DecimalType(38, 0), this.cast$default$3()), "out of decimal type range", ClassTag$.MODULE$.apply(ArithmeticException.class));
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast("12345678901234567890123456789012345678", (DataType)new DecimalType(38, 1), this.cast$default$3()), "cannot be represented as Decimal(38, 1)", ClassTag$.MODULE$.apply(ArithmeticException.class));
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast("0.00000000000000000000000000000000000001", (DataType)new DecimalType(38, 0), this.cast$default$3()), Decimal$.MODULE$.apply("0"), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast("0.00000000000000000000000000000000000000000001", (DataType)new DecimalType(38, 0), this.cast$default$3()), Decimal$.MODULE$.apply("0"), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast("0.00000000000000000000000000000000000001", (DataType)new DecimalType(38, 18), this.cast$default$3()), Decimal$.MODULE$.apply("0E-18"), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast("6E-120", (DataType)new DecimalType(38, 0), this.cast$default$3()), Decimal$.MODULE$.apply("0"), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast("6E+37", (DataType)new DecimalType(38, 0), this.cast$default$3()), Decimal$.MODULE$.apply("60000000000000000000000000000000000000"), this.checkEvaluation$default$3());
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast("6E+38", (DataType)new DecimalType(38, 0), this.cast$default$3()), "out of decimal type range", ClassTag$.MODULE$.apply(ArithmeticException.class));
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast("6E+37", (DataType)new DecimalType(38, 1), this.cast$default$3()), "cannot be represented as Decimal(38, 1)", ClassTag$.MODULE$.apply(ArithmeticException.class));
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast("abcd", (DataType)new DecimalType(38, 1), this.cast$default$3()), "invalid input syntax for type numeric", ClassTag$.MODULE$.apply(NumberFormatException.class));
        }, new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 225));
        this.test("ANSI mode: cast string to boolean with parse error", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkCastToBooleanError(Literal$.MODULE$.apply((Object)"abc"), (DataType)BooleanType$.MODULE$, null);
            this.checkCastToBooleanError(Literal$.MODULE$.apply((Object)""), (DataType)BooleanType$.MODULE$, null);
        }, new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 263));
        this.test("cast from array II", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Literal array = Literal$.MODULE$.create((Object)new .colon.colon((Object)"123", (List)new .colon.colon((Object)"true", (List)new .colon.colon((Object)"f", (List)new .colon.colon(null, (List)Nil$.MODULE$)))), (DataType)new ArrayType((DataType)StringType$.MODULE$, true));
            Literal array_notNull = Literal$.MODULE$.create((Object)new .colon.colon((Object)"123", (List)new .colon.colon((Object)"true", (List)new .colon.colon((Object)"f", (List)Nil$.MODULE$))), (DataType)new ArrayType((DataType)StringType$.MODULE$, false));
            ArrayType to = new ArrayType((DataType)BooleanType$.MODULE$, true);
            CastBase ret = this.cast(array, (DataType)to, this.cast$default$3());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(ret.resolved(), "ret.resolved", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 277));
            this.checkCastToBooleanError(array, (DataType)to, Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)false), null})));
            ArrayType to2 = new ArrayType((DataType)BooleanType$.MODULE$, true);
            CastBase ret2 = this.cast(array_notNull, (DataType)to2, this.cast$default$3());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(ret2.resolved(), "ret.resolved", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 284));
            this.checkCastToBooleanError(array_notNull, (DataType)to2, Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)false)})));
        }, new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 268));
        this.test("cast from map II", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Literal map = Literal$.MODULE$.create((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"123"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)"f"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"d"), null)})), (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)StringType$.MODULE$, true));
            Literal map_notNull = Literal$.MODULE$.create((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"123"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)"f")})), (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)StringType$.MODULE$, false));
            this.checkNullCast((DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)IntegerType$.MODULE$), (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)StringType$.MODULE$));
            MapType to = new MapType((DataType)StringType$.MODULE$, (DataType)BooleanType$.MODULE$, true);
            CastBase ret = this.cast(map, (DataType)to, this.cast$default$3());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(ret.resolved(), "ret.resolved", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 302));
            this.checkCastToBooleanError(map, (DataType)to, Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), null), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)BoxesRunTime.boxToBoolean((boolean)true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)BoxesRunTime.boxToBoolean((boolean)false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"d"), null)})));
            MapType to2 = new MapType((DataType)StringType$.MODULE$, (DataType)BooleanType$.MODULE$, true);
            CastBase ret2 = this.cast(map_notNull, (DataType)to2, this.cast$default$3());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(ret2.resolved(), "ret.resolved", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 309));
            this.checkCastToBooleanError(map_notNull, (DataType)to2, Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), null), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)BoxesRunTime.boxToBoolean((boolean)true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)BoxesRunTime.boxToBoolean((boolean)false))})));
        }, new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 289));
        this.test("cast from struct II", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkNullCast((DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("a", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("b", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))), (DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("a", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("b", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))));
            Literal struct = Literal$.MODULE$.create((Object)InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{UTF8String.fromString((String)"123"), UTF8String.fromString((String)"true"), UTF8String.fromString((String)"f"), null})), (DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("a", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("b", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("c", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("d", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))))));
            Literal struct_notNull = Literal$.MODULE$.create((Object)InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{UTF8String.fromString((String)"123"), UTF8String.fromString((String)"true"), UTF8String.fromString((String)"f")})), (DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("a", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("b", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("c", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))));
            StructType to = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("a", (DataType)BooleanType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("b", (DataType)BooleanType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("c", (DataType)BooleanType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("d", (DataType)BooleanType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))));
            CastBase ret = this.cast(struct, (DataType)to, this.cast$default$3());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(ret.resolved(), "ret.resolved", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 351));
            this.checkCastToBooleanError(struct, (DataType)to, InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)false), null})));
            StructType to2 = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("a", (DataType)BooleanType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("b", (DataType)BooleanType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("c", (DataType)BooleanType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))));
            CastBase ret2 = this.cast(struct_notNull, (DataType)to2, this.cast$default$3());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(ret2.resolved(), "ret.resolved", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 361));
            this.checkCastToBooleanError(struct_notNull, (DataType)to2, InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)false)})));
        }, new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 314));
        this.test("ANSI mode: cast string to timestamp with parse error", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DateTimeTestUtils$.MODULE$.outstandingZoneIds().foreach((Function1 & Serializable & scala.Serializable)zid -> {
            AnsiCastSuiteBase.$anonfun$new$79(this, zid);
            return BoxedUnit.UNIT;
        }), new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 366));
        this.test("ANSI mode: cast string to date with parse error", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DateTimeTestUtils$.MODULE$.outstandingZoneIds().foreach((Function1 & Serializable & scala.Serializable)zid -> {
            AnsiCastSuiteBase.$anonfun$new$82(this, zid);
            return BoxedUnit.UNIT;
        }), new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 387));
        this.test("SPARK-26218: Fix the corner case of codegen when casting float to Integer", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(this.cast(Literal$.MODULE$.apply((Object)"2147483648"), (DataType)FloatType$.MODULE$, this.cast$default$3()), (DataType)IntegerType$.MODULE$, this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class)), new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 406));
        this.test("SPARK-35720: cast invalid string input to timestamp without time zone", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"00:00:00", (List)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"123", (List)new .colon.colon((Object)"a2021-06-17", (List)new .colon.colon((Object)"2021-06-17abc", (List)new .colon.colon((Object)"2021-06-17 00:00:00ABC", (List)Nil$.MODULE$))))))).foreach((Function1 & Serializable & scala.Serializable)invalidInput -> {
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> $this.cast(invalidInput, (DataType)TimestampNTZType$.MODULE$, $this.cast$default$3()), new StringBuilder(32).append("Cannot cast ").append(invalidInput).append(" to TimestampNTZType").toString(), ClassTag$.MODULE$.apply(DateTimeException.class));
            return BoxedUnit.UNIT;
        }), new Position("AnsiCastSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 411));
    }
}

