/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GetTimestamp;
import org.apache.spark.sql.catalyst.expressions.GetTimestamp$;
import org.apache.spark.sql.catalyst.expressions.ParseToTimestampLTZ$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.Unevaluable;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Enumeration;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(timestamp_str[, fmt]) - Parses the `timestamp_str` expression with the `fmt` expression\n      to a timestamp with local time zone. Returns null with invalid input. By default, it follows casting rules to\n      a timestamp if the `fmt` is omitted.\n  ", arguments="\n    Arguments:\n      * timestamp_str - A string to be parsed to timestamp with local time zone.\n      * fmt - Timestamp format pattern to follow. See <a href=\"https://spark.apache.org/docs/latest/sql-ref-datetime-pattern.html\">Datetime Patterns</a> for valid\n              date and time format patterns.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('2016-12-31 00:12:00');\n       2016-12-31 00:12:00\n      > SELECT _FUNC_('2016-12-31', 'yyyy-MM-dd');\n       2016-12-31 00:00:00\n  ", group="datetime_funcs", since="3.3.0")
@ScalaSignature(bytes="\u0006\u0001\u0005eg\u0001\u0002\u0011\"\u0001:B\u0001b\u0010\u0001\u0003\u0016\u0004%\t\u0001\u0011\u0005\t\t\u0002\u0011\t\u0012)A\u0005\u0003\"AQ\t\u0001BK\u0002\u0013\u0005a\t\u0003\u0005K\u0001\tE\t\u0015!\u0003H\u0011!Y\u0005A!f\u0001\n\u0003\u0001\u0005\u0002\u0003'\u0001\u0005#\u0005\u000b\u0011B!\t\u000b5\u0003A\u0011\u0001(\t\u000b5\u0003A\u0011A*\t\u000b5\u0003A\u0011\u0001,\t\u000ba\u0003A\u0011I-\t\u000b%\u0004A\u0011\t6\t\u000b9\u0004A\u0011I8\t\u000ba\u0004A\u0011I=\t\u000f\u0005\u0005\u0001\u0001\"\u0015\u0002\u0004!I\u0011\u0011\u0002\u0001\u0002\u0002\u0013\u0005\u00111\u0002\u0005\n\u0003'\u0001\u0011\u0013!C\u0001\u0003+A\u0011\"a\u000b\u0001#\u0003%\t!!\f\t\u0013\u0005E\u0002!%A\u0005\u0002\u0005U\u0001\"CA\u001a\u0001\u0005\u0005I\u0011IA\u001b\u0011%\t)\u0005AA\u0001\n\u0003\t9\u0005C\u0005\u0002P\u0001\t\t\u0011\"\u0001\u0002R!I\u0011q\u000b\u0001\u0002\u0002\u0013\u0005\u0013\u0011\f\u0005\n\u0003K\u0002\u0011\u0011!C\u0001\u0003OB\u0011\"!\u001d\u0001\u0003\u0003%\t%a\u001d\b\u0013\u0005u\u0015%!A\t\u0002\u0005}e\u0001\u0003\u0011\"\u0003\u0003E\t!!)\t\r5SB\u0011AAX\u0011%\t\tLGA\u0001\n\u000b\n\u0019\fC\u0005\u00026j\t\t\u0011\"!\u00028\"I\u0011q\u0018\u000e\u0002\u0002\u0013\u0005\u0015\u0011\u0019\u0005\n\u0003\u001fT\u0012\u0011!C\u0005\u0003#\u00141\u0003U1sg\u0016$v\u000eV5nKN$\u0018-\u001c9M)jS!AI\u0012\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003I\u0015\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003M\u001d\n1a]9m\u0015\tA\u0013&A\u0003ta\u0006\u00148N\u0003\u0002+W\u00051\u0011\r]1dQ\u0016T\u0011\u0001L\u0001\u0004_J<7\u0001A\n\u0006\u0001=\u001ad\u0007\u0010\t\u0003aEj\u0011!I\u0005\u0003e\u0005\u0012q\"\u00168bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003aQJ!!N\u0011\u0003%I+h\u000e^5nKJ+\u0007\u000f\\1dK\u0006\u0014G.\u001a\t\u0003oij\u0011\u0001\u000f\u0006\u0002s\u0005)1oY1mC&\u00111\b\u000f\u0002\b!J|G-^2u!\t9T(\u0003\u0002?q\ta1+\u001a:jC2L'0\u00192mK\u0006!A.\u001a4u+\u0005\t\u0005C\u0001\u0019C\u0013\t\u0019\u0015E\u0001\u0006FqB\u0014Xm]:j_:\fQ\u0001\\3gi\u0002\naAZ8s[\u0006$X#A$\u0011\u0007]B\u0015)\u0003\u0002Jq\t1q\n\u001d;j_:\fqAZ8s[\u0006$\b%A\u0003dQ&dG-\u0001\u0004dQ&dG\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\t=\u0003\u0016K\u0015\t\u0003a\u0001AQaP\u0004A\u0002\u0005CQ!R\u0004A\u0002\u001dCQaS\u0004A\u0002\u0005#2a\u0014+V\u0011\u0015y\u0004\u00021\u0001B\u0011\u0015)\u0005\u00021\u0001B)\tyu\u000bC\u0003@\u0013\u0001\u0007\u0011)A\u0007gY\u0006$\u0018I]4v[\u0016tGo]\u000b\u00025B\u00191l\u00194\u000f\u0005q\u000bgBA/a\u001b\u0005q&BA0.\u0003\u0019a$o\\8u}%\t\u0011(\u0003\u0002cq\u00059\u0001/Y2lC\u001e,\u0017B\u00013f\u0005!IE/\u001a:bi>\u0014(B\u000129!\t9t-\u0003\u0002iq\t\u0019\u0011I\\=\u0002\u001b\u0015D\bO]:SKBd\u0017mY3e+\u0005Y\u0007cA.m\u0003&\u0011Q.\u001a\u0002\u0004'\u0016\f\u0018A\u00039sKR$\u0018PT1nKV\t\u0001\u000f\u0005\u0002rk:\u0011!o\u001d\t\u0003;bJ!\u0001\u001e\u001d\u0002\rA\u0013X\rZ3g\u0013\t1xO\u0001\u0004TiJLgn\u001a\u0006\u0003ib\n\u0001\u0002Z1uCRK\b/Z\u000b\u0002uB\u00111P`\u0007\u0002y*\u0011Q0J\u0001\u0006if\u0004Xm]\u0005\u0003\u007fr\u0014\u0001\u0002R1uCRK\b/Z\u0001\u0015o&$\bNT3x\u0007\"LG\u000eZ%oi\u0016\u0014h.\u00197\u0015\u0007=\u000b)\u0001\u0003\u0004\u0002\b9\u0001\r!Q\u0001\t]\u0016<8\t[5mI\u0006!1m\u001c9z)\u001dy\u0015QBA\b\u0003#AqaP\b\u0011\u0002\u0003\u0007\u0011\tC\u0004F\u001fA\u0005\t\u0019A$\t\u000f-{\u0001\u0013!a\u0001\u0003\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\fU\r\t\u0015\u0011D\u0016\u0003\u00037\u0001B!!\b\u0002(5\u0011\u0011q\u0004\u0006\u0005\u0003C\t\u0019#A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\u0005\u001d\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002*\u0005}!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAA\u0018U\r9\u0015\u0011D\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011q\u0007\t\u0005\u0003s\t\u0019%\u0004\u0002\u0002<)!\u0011QHA \u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0005\u0013\u0001\u00026bm\u0006L1A^A\u001e\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\tI\u0005E\u00028\u0003\u0017J1!!\u00149\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\r1\u00171\u000b\u0005\n\u0003+*\u0012\u0011!a\u0001\u0003\u0013\n1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA.!\u0015\ti&a\u0019g\u001b\t\tyFC\u0002\u0002ba\n!bY8mY\u0016\u001cG/[8o\u0013\r!\u0017qL\u0001\tG\u0006tW)];bYR!\u0011\u0011NA8!\r9\u00141N\u0005\u0004\u0003[B$a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003+:\u0012\u0011!a\u0001M\u00061Q-];bYN$B!!\u001b\u0002v!A\u0011Q\u000b\r\u0002\u0002\u0003\u0007a\rK\f\u0001\u0003s\ny(!!\u0002\u0006\u0006\u001d\u00151RAG\u0003#\u000b\u0019*a&\u0002\u001aB\u0019\u0001'a\u001f\n\u0007\u0005u\u0014EA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005\r\u0015Aa\u0003\u000bA\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006\u0006^5nKN$\u0018-\u001c9`gR\u00148\f\f\u0011g[Rl\u0016\u0006I\u0017!!\u0006\u00148/Z:!i\",\u0007\u0005\u0019;j[\u0016\u001cH/Y7q?N$(\u000f\u0019\u0011fqB\u0014Xm]:j_:\u0004s/\u001b;iAQDW\r\t1g[R\u0004\u0007%\u001a=qe\u0016\u001c8/[8o\u0015\u0001\u0002\u0003\u0005\t\u0011!i>\u0004\u0013\r\t;j[\u0016\u001cH/Y7qA]LG\u000f\u001b\u0011m_\u000e\fG\u000e\t;j[\u0016\u0004#p\u001c8f]\u0001\u0012V\r^;s]N\u0004c.\u001e7mA]LG\u000f\u001b\u0011j]Z\fG.\u001b3!S:\u0004X\u000f\u001e\u0018!\u0005f\u0004C-\u001a4bk2$H\u0006I5uA\u0019|G\u000e\\8xg\u0002\u001a\u0017m\u001d;j]\u001e\u0004#/\u001e7fg\u0002\"xN\u0003\u0011!A\u0001\u0002\u0003%\u0019\u0011uS6,7\u000f^1na\u0002Jg\r\t;iK\u0002\u0002g-\u001c;aA%\u001c\be\\7jiR,GM\f\u0006!A\u0005I\u0011M]4v[\u0016tGo]\u0011\u0003\u0003\u0013\u000b!q\r\u0006!A\u0001\u0002\u0013I]4v[\u0016tGo\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011+AQLW.Z:uC6\u0004xl\u001d;sA5\u0002\u0013\tI:ue&tw\r\t;pA\t,\u0007\u0005]1sg\u0016$\u0007\u0005^8!i&lWm\u001d;b[B\u0004s/\u001b;iA1|7-\u00197!i&lW\r\t>p]\u0016t#\u0002\t\u0011!A\u0001\u0002#\u0006\t4ni\u0002j\u0003\u0005V5nKN$\u0018-\u001c9!M>\u0014X.\u0019;!a\u0006$H/\u001a:oAQ|\u0007EZ8mY><h\u0006I*fK\u0002b\u0014\r\t5sK\u001al$\u0005\u001b;uaNTtfL:qCJ\\g&\u00199bG\",gf\u001c:h_\u0011|7m]\u0018mCR,7\u000f^\u0018tc2l#/\u001a4.I\u0006$X\r^5nK6\u0002\u0018\r\u001e;fe:t\u0003\u000e^7mEy\"\u0015\r^3uS6,\u0007\u0005U1ui\u0016\u0014hn\u001d\u001f0Cz\u0002cm\u001c:!m\u0006d\u0017\u000e\u001a\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011eCR,\u0007%\u00198eAQLW.\u001a\u0011g_Jl\u0017\r\u001e\u0011qCR$XM\u001d8t])\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\ty)AA)\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":#\u0007M\u00197[E\u0012TfM\u0019!aAR\u0014G\r\u001e1a\u001dJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001a1cYj\u0013GM\u00174c\u0001\u0002\u0004GO\u00193uA\u0002$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u00143aE2T&\r\u001a.gE:C\u0006I\u0014zsfLX&T'.I\u0012<\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00113aE2T&\r\u001a.gE\u0002\u0003\u0007\r\u001e1ai\u0002\u0004G\u0003\u0011!\u0003\u00159'o\\;qC\t\t)*\u0001\beCR,G/[7f?\u001a,hnY:\u0002\u000bMLgnY3\"\u0005\u0005m\u0015!B\u001a/g9\u0002\u0014a\u0005)beN,Gk\u001c+j[\u0016\u001cH/Y7q\u0019RS\u0006C\u0001\u0019\u001b'\u0011Q\u00121\u0015\u001f\u0011\u0011\u0005\u0015\u00161V!H\u0003>k!!a*\u000b\u0007\u0005%\u0006(A\u0004sk:$\u0018.\\3\n\t\u00055\u0016q\u0015\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u001cDCAAP\u0003!!xn\u0015;sS:<GCAA\u001c\u0003\u0015\t\u0007\u000f\u001d7z)\u001dy\u0015\u0011XA^\u0003{CQaP\u000fA\u0002\u0005CQ!R\u000fA\u0002\u001dCQaS\u000fA\u0002\u0005\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002D\u0006-\u0007\u0003B\u001cI\u0003\u000b\u0004baNAd\u0003\u001e\u000b\u0015bAAeq\t1A+\u001e9mKNB\u0001\"!4\u001f\u0003\u0003\u0005\raT\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a5\u0011\t\u0005e\u0012Q[\u0005\u0005\u0003/\fYD\u0001\u0004PE*,7\r\u001e")
public class ParseToTimestampLTZ
extends UnaryExpression
implements RuntimeReplaceable,
Serializable {
    private final Expression left;
    private final Option<Expression> format;
    private final Expression child;
    private Expression canonicalized;
    private final Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<Expression, Option<Expression>, Expression>> unapply(ParseToTimestampLTZ parseToTimestampLTZ) {
        return ParseToTimestampLTZ$.MODULE$.unapply(parseToTimestampLTZ);
    }

    public static Function1<Tuple3<Expression, Option<Expression>, Expression>, ParseToTimestampLTZ> tupled() {
        return ParseToTimestampLTZ$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Option<Expression>, Function1<Expression, ParseToTimestampLTZ>>> curried() {
        return ParseToTimestampLTZ$.MODULE$.curried();
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public String sql() {
        return RuntimeReplaceable.sql$(this);
    }

    @Override
    public String mkString(Seq<String> childrenString) {
        return RuntimeReplaceable.mkString$(this, childrenString);
    }

    @Override
    public final boolean foldable() {
        return Unevaluable.foldable$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Unevaluable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Unevaluable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return Unevaluable.doGenCode$(this, ctx, ev);
    }

    private Expression canonicalized$lzycompute() {
        ParseToTimestampLTZ parseToTimestampLTZ = this;
        synchronized (parseToTimestampLTZ) {
            if (!this.bitmap$0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = true;
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        return !this.bitmap$0 ? this.canonicalized$lzycompute() : this.canonicalized;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression left() {
        return this.left;
    }

    public Option<Expression> format() {
        return this.format;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Iterator<Object> flatArguments() {
        return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray(new Object[]{this.left(), this.format()}));
    }

    @Override
    public Seq<Expression> exprsReplaced() {
        Expression expression = this.left();
        return (Seq)Option$.MODULE$.option2Iterable(this.format()).toSeq().$plus$colon((Object)expression, Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public String prettyName() {
        return "to_timestamp_ltz";
    }

    @Override
    public DataType dataType() {
        return TimestampType$.MODULE$;
    }

    @Override
    public ParseToTimestampLTZ withNewChildInternal(Expression newChild) {
        Expression x$1 = newChild;
        Expression x$2 = this.copy$default$1();
        Option<Expression> x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, x$1);
    }

    public ParseToTimestampLTZ copy(Expression left, Option<Expression> format, Expression child) {
        return new ParseToTimestampLTZ(left, format, child);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Option<Expression> copy$default$2() {
        return this.format();
    }

    public Expression copy$default$3() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "ParseToTimestampLTZ";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.left();
                break;
            }
            case 1: {
                object = this.format();
                break;
            }
            case 2: {
                object = this.child();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ParseToTimestampLTZ;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ParseToTimestampLTZ)) return false;
        boolean bl = true;
        if (!bl) return false;
        ParseToTimestampLTZ parseToTimestampLTZ = (ParseToTimestampLTZ)x$1;
        Expression expression = this.left();
        Expression expression2 = parseToTimestampLTZ.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.format();
        Option<Expression> option2 = parseToTimestampLTZ.format();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Expression expression3 = this.child();
        Expression expression4 = parseToTimestampLTZ.child();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!parseToTimestampLTZ.canEqual(this)) return false;
        return true;
    }

    public ParseToTimestampLTZ(Expression left, Option<Expression> format, Expression child) {
        this.left = left;
        this.format = format;
        this.child = child;
        Unevaluable.$init$(this);
        RuntimeReplaceable.$init$(this);
    }

    public ParseToTimestampLTZ(Expression left, Expression format) {
        this(left, (Option<Expression>)Option$.MODULE$.apply((Object)format), new GetTimestamp(left, format, TimestampType$.MODULE$, GetTimestamp$.MODULE$.apply$default$4(), GetTimestamp$.MODULE$.apply$default$5()));
    }

    public ParseToTimestampLTZ(Expression left) {
        this(left, (Option<Expression>)None$.MODULE$, new Cast(left, TimestampType$.MODULE$, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4()));
    }
}

