/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.expressions;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.connector.expressions.BucketTransform$;
import org.apache.spark.sql.connector.expressions.DaysTransform$;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.FieldReference;
import org.apache.spark.sql.connector.expressions.HoursTransform$;
import org.apache.spark.sql.connector.expressions.IdentityTransform$;
import org.apache.spark.sql.connector.expressions.Literal;
import org.apache.spark.sql.connector.expressions.MonthsTransform$;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.connector.expressions.YearsTransform$;
import org.apache.spark.sql.types.DataType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001=3A!\u0002\u0004\u0001'!)\u0001\u0004\u0001C\u00013!)A\u0004\u0001C\u0005;!)!\u0007\u0001C\u0005g!)q\t\u0001C\u0005\u0011\n9BK]1og\u001a|'/\\#yiJ\f7\r^8s'VLG/\u001a\u0006\u0003\u000f!\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011\u0011BC\u0001\nG>tg.Z2u_JT!a\u0003\u0007\u0002\u0007M\fHN\u0003\u0002\u000e\u001d\u0005)1\u000f]1sW*\u0011q\u0002E\u0001\u0007CB\f7\r[3\u000b\u0003E\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u000b\u0011\u0005U1R\"\u0001\u0007\n\u0005]a!!D*qCJ\\g)\u001e8Tk&$X-\u0001\u0004=S:LGO\u0010\u000b\u00025A\u00111\u0004A\u0007\u0002\r\u0005\u0019A.\u001b;\u0016\u0005y!CCA\u00101!\rY\u0002EI\u0005\u0003C\u0019\u0011q\u0001T5uKJ\fG\u000e\u0005\u0002$I1\u0001A!B\u0013\u0003\u0005\u00041#!\u0001+\u0012\u0005\u001dj\u0003C\u0001\u0015,\u001b\u0005I#\"\u0001\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00051J#a\u0002(pi\"Lgn\u001a\t\u0003Q9J!aL\u0015\u0003\u0007\u0005s\u0017\u0010C\u00032\u0005\u0001\u0007!%A\u0004mSR,'/\u00197\u0002\u0007I,g\r\u0006\u00025oA\u00111$N\u0005\u0003m\u0019\u0011aBT1nK\u0012\u0014VMZ3sK:\u001cW\rC\u00039\u0007\u0001\u0007\u0011(A\u0003oC6,7\u000fE\u0002)uqJ!aO\u0015\u0003\u0015q\u0012X\r]3bi\u0016$g\b\u0005\u0002>\t:\u0011aH\u0011\t\u0003\u007f%j\u0011\u0001\u0011\u0006\u0003\u0003J\ta\u0001\u0010:p_Rt\u0014BA\"*\u0003\u0019\u0001&/\u001a3fM&\u0011QI\u0012\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\rK\u0013!\u0003;sC:\u001chm\u001c:n)\rIEJ\u0014\t\u00037)K!a\u0013\u0004\u0003\u0013Q\u0013\u0018M\\:g_Jl\u0007\"B'\u0005\u0001\u0004a\u0014\u0001\u00024v]\u000eDQA\r\u0003A\u0002Q\u0002")
public class TransformExtractorSuite
extends SparkFunSuite {
    public <T> Literal<T> org$apache$spark$sql$connector$expressions$TransformExtractorSuite$$lit(T literal) {
        return new Literal<T>(null, literal){
            private final Object literal$1;

            public T value() {
                return (T)this.literal$1;
            }

            public DataType dataType() {
                return Literal$.MODULE$.apply(this.literal$1).dataType();
            }

            public String describe() {
                return this.literal$1.toString();
            }
            {
                this.literal$1 = literal$1;
            }
        };
    }

    private NamedReference ref(Seq<String> names) {
        return new NamedReference(null, names){
            private final Seq names$1;

            public String[] fieldNames() {
                return (String[])this.names$1.toArray(ClassTag$.MODULE$.apply(String.class));
            }

            public String describe() {
                return this.names$1.mkString(".");
            }
            {
                this.names$1 = names$1;
            }
        };
    }

    private Transform transform(String func, NamedReference ref) {
        return new Transform(null, func, ref){
            private final String func$1;
            private final NamedReference ref$1;

            public String name() {
                return this.func$1;
            }

            public NamedReference[] references() {
                return (NamedReference[])((Object[])new NamedReference[]{this.ref$1});
            }

            public Expression[] arguments() {
                return (Expression[])((Object[])new Expression[]{this.ref$1});
            }

            public String describe() {
                return this.ref$1.describe();
            }
            {
                this.func$1 = func$1;
                this.ref$1 = ref$1;
            }
        };
    }

    public TransformExtractorSuite() {
        this.test("Identity extractor", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            FieldReference fieldReference;
            FieldReference fieldReference2;
            Transform transform = this.transform("identity", this.ref((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})));
            Option option = IdentityTransform$.MODULE$.unapply(transform);
            if (option.isEmpty() || (fieldReference2 = (FieldReference)option.get()) == null) {
                throw this.fail("Did not match IdentityTransform extractor", new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
            }
            Seq seq = fieldReference2.parts();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(seq);
            Seq $org_scalatest_assert_macro_right = (Seq)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)Nil$.MODULE$));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertion assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
            Transform transform2 = this.transform("unknown", this.ref((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})));
            Option option2 = IdentityTransform$.MODULE$.unapply(transform2);
            if (!option2.isEmpty() && (fieldReference = (FieldReference)option2.get()) != null) {
                throw this.fail("Matched unknown transform", new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return boxedUnit;
        }, new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
        this.test("Years extractor", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            FieldReference fieldReference;
            FieldReference fieldReference2;
            Transform transform = this.transform("years", this.ref((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})));
            Option option = YearsTransform$.MODULE$.unapply(transform);
            if (option.isEmpty() || (fieldReference2 = (FieldReference)option.get()) == null) {
                throw this.fail("Did not match YearsTransform extractor", new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
            }
            Seq seq = fieldReference2.parts();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(seq);
            Seq $org_scalatest_assert_macro_right = (Seq)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)Nil$.MODULE$));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertion assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
            Transform transform2 = this.transform("unknown", this.ref((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})));
            Option option2 = YearsTransform$.MODULE$.unapply(transform2);
            if (!option2.isEmpty() && (fieldReference = (FieldReference)option2.get()) != null) {
                throw this.fail("Matched unknown transform", new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return boxedUnit;
        }, new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
        this.test("Months extractor", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            FieldReference fieldReference;
            FieldReference fieldReference2;
            Transform transform = this.transform("months", this.ref((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})));
            Option option = MonthsTransform$.MODULE$.unapply(transform);
            if (option.isEmpty() || (fieldReference2 = (FieldReference)option.get()) == null) {
                throw this.fail("Did not match MonthsTransform extractor", new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
            }
            Seq seq = fieldReference2.parts();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(seq);
            Seq $org_scalatest_assert_macro_right = (Seq)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)Nil$.MODULE$));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertion assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
            Transform transform2 = this.transform("unknown", this.ref((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})));
            Option option2 = MonthsTransform$.MODULE$.unapply(transform2);
            if (!option2.isEmpty() && (fieldReference = (FieldReference)option2.get()) != null) {
                throw this.fail("Matched unknown transform", new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return boxedUnit;
        }, new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
        this.test("Days extractor", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            FieldReference fieldReference;
            FieldReference fieldReference2;
            Transform transform = this.transform("days", this.ref((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})));
            Option option = DaysTransform$.MODULE$.unapply(transform);
            if (option.isEmpty() || (fieldReference2 = (FieldReference)option.get()) == null) {
                throw this.fail("Did not match DaysTransform extractor", new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
            }
            Seq seq = fieldReference2.parts();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(seq);
            Seq $org_scalatest_assert_macro_right = (Seq)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)Nil$.MODULE$));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertion assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
            Transform transform2 = this.transform("unknown", this.ref((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})));
            Option option2 = DaysTransform$.MODULE$.unapply(transform2);
            if (!option2.isEmpty() && (fieldReference = (FieldReference)option2.get()) != null) {
                throw this.fail("Matched unknown transform", new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return boxedUnit;
        }, new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
        this.test("Hours extractor", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            FieldReference fieldReference;
            FieldReference fieldReference2;
            Transform transform = this.transform("hours", this.ref((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})));
            Option option = HoursTransform$.MODULE$.unapply(transform);
            if (option.isEmpty() || (fieldReference2 = (FieldReference)option.get()) == null) {
                throw this.fail("Did not match HoursTransform extractor", new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
            }
            Seq seq = fieldReference2.parts();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(seq);
            Seq $org_scalatest_assert_macro_right = (Seq)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)Nil$.MODULE$));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertion assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
            Transform transform2 = this.transform("unknown", this.ref((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})));
            Option option2 = HoursTransform$.MODULE$.unapply(transform2);
            if (!option2.isEmpty() && (fieldReference = (FieldReference)option2.get()) != null) {
                throw this.fail("Matched unknown transform", new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return boxedUnit;
        }, new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
        this.test("Bucket extractor", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            NamedReference namedReference;
            int numBuckets;
            block5: {
                block4: {
                    NamedReference col = this.ref((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"}));
                    Transform bucketTransform = new Transform(this, col){
                        private final /* synthetic */ TransformExtractorSuite $outer;
                        private final NamedReference col$1;

                        public String name() {
                            return "bucket";
                        }

                        public NamedReference[] references() {
                            return (NamedReference[])((Object[])new NamedReference[]{this.col$1});
                        }

                        public Expression[] arguments() {
                            return (Expression[])((Object[])new Expression[]{this.$outer.org$apache$spark$sql$connector$expressions$TransformExtractorSuite$$lit(BoxesRunTime.boxToInteger((int)16)), this.col$1});
                        }

                        public String describe() {
                            return new StringBuilder(12).append("bucket(16, ").append(this.col$1.describe()).append(")").toString();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.col$1 = col$1;
                        }
                    };
                    Transform transform = bucketTransform;
                    Option option = BucketTransform$.MODULE$.unapply(transform);
                    if (option.isEmpty()) break block4;
                    numBuckets = ((Tuple2)option.get())._1$mcI$sp();
                    namedReference = (NamedReference)((Tuple2)option.get())._2();
                    if (namedReference instanceof FieldReference) break block5;
                }
                throw this.fail("Did not match BucketTransform extractor", new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
            }
            FieldReference fieldReference = (FieldReference)namedReference;
            Seq seq = fieldReference.parts();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)numBuckets));
            int $org_scalatest_assert_macro_right = 16;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(seq);
            Seq $org_scalatest_assert_macro_right2 = (Seq)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)Nil$.MODULE$));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertion assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
            Transform transform = this.transform("unknown", this.ref((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})));
            Option option = BucketTransform$.MODULE$.unapply(transform);
            if (!option.isEmpty()) {
                throw this.fail("Matched unknown transform", new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return boxedUnit;
        }, new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
    }
}

