/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.NamespaceAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchFunctionException;
import org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.connector.catalog.BufferedRows;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.Catalogs$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.InMemoryCatalog;
import org.apache.spark.sql.connector.catalog.InMemoryPartitionTable;
import org.apache.spark.sql.connector.catalog.InMemoryPartitionTableCatalog;
import org.apache.spark.sql.connector.catalog.InMemoryTable;
import org.apache.spark.sql.connector.catalog.NamespaceChange;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.connector.catalog.functions.BoundFunction;
import org.apache.spark.sql.connector.catalog.functions.ScalarFunction;
import org.apache.spark.sql.connector.catalog.functions.UnboundFunction;
import org.apache.spark.sql.connector.expressions.LogicalExpressions$;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001%4Aa\u0004\t\u0001;!)!\u0005\u0001C\u0001G!9a\u0005\u0001b\u0001\n\u00139\u0003BB\u001f\u0001A\u0003%\u0001\u0006C\u0004?\u0001\t\u0007I\u0011B \t\r\u0019\u0003\u0001\u0015!\u0003A\u0011\u00159\u0005\u0001\"\u0003I\u0011\u001da\u0005A1A\u0005\n5Caa\u0016\u0001!\u0002\u0013q\u0005b\u0002-\u0001\u0005\u0004%I!\u0017\u0005\u0007;\u0002\u0001\u000b\u0011\u0002.\t\u000fy\u0003!\u0019!C\u00053\"1q\f\u0001Q\u0001\niCq\u0001\u0019\u0001C\u0002\u0013\u0005\u0011\r\u0003\u0004i\u0001\u0001\u0006IA\u0019\u0002\r\u0007\u0006$\u0018\r\\8h'VLG/\u001a\u0006\u0003#I\tqaY1uC2|wM\u0003\u0002\u0014)\u0005I1m\u001c8oK\u000e$xN\u001d\u0006\u0003+Y\t1a]9m\u0015\t9\u0002$A\u0003ta\u0006\u00148N\u0003\u0002\u001a5\u00051\u0011\r]1dQ\u0016T\u0011aG\u0001\u0004_J<7\u0001A\n\u0003\u0001y\u0001\"a\b\u0011\u000e\u0003YI!!\t\f\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f\u0003\u0019a\u0014N\\5u}Q\tA\u0005\u0005\u0002&\u00015\t\u0001#\u0001\u0006f[B$\u0018\u0010\u0015:paN,\u0012\u0001\u000b\t\u0005S9\u0002\u0004'D\u0001+\u0015\tYC&\u0001\u0003vi&d'\"A\u0017\u0002\t)\fg/Y\u0005\u0003_)\u00121!T1q!\t\t$H\u0004\u00023qA\u00111GN\u0007\u0002i)\u0011Q\u0007H\u0001\u0007yI|w\u000e\u001e \u000b\u0003]\nQa]2bY\u0006L!!\u000f\u001c\u0002\rA\u0013X\rZ3g\u0013\tYDH\u0001\u0004TiJLgn\u001a\u0006\u0003sY\n1\"Z7qif\u0004&o\u001c9tA\u000511o\u00195f[\u0006,\u0012\u0001\u0011\t\u0003\u0003\u0012k\u0011A\u0011\u0006\u0003\u0007R\tQ\u0001^=qKNL!!\u0012\"\u0003\u0015M#(/^2u)f\u0004X-A\u0004tG\",W.\u0019\u0011\u0002\u00159,woQ1uC2|w\rF\u0001J!\t)#*\u0003\u0002L!\ty\u0011J\\'f[>\u0014\u0018pQ1uC2|w-\u0001\u0004uKN$hj]\u000b\u0002\u001dB\u0019q\n\u0015*\u000e\u0003YJ!!\u0015\u001c\u0003\u000b\u0005\u0013(/Y=\u0011\u0005M3V\"\u0001+\u000b\u0005Uc\u0013\u0001\u00027b]\u001eL!a\u000f+\u0002\u000fQ,7\u000f\u001e(tA\u0005IA/Z:u\u0013\u0012,g\u000e^\u000b\u00025B\u0011QeW\u0005\u00039B\u0011!\"\u00133f]RLg-[3s\u0003)!Xm\u001d;JI\u0016tG\u000fI\u0001\ri\u0016\u001cH/\u00133f]RtUm^\u0001\u000ei\u0016\u001cH/\u00133f]RtUm\u001e\u0011\u0002\u0011\u0019,hn\u0019;j_:,\u0012A\u0019\t\u0003G\u001al\u0011\u0001\u001a\u0006\u0003KB\t\u0011BZ;oGRLwN\\:\n\u0005\u001d$'aD+oE>,h\u000e\u001a$v]\u000e$\u0018n\u001c8\u0002\u0013\u0019,hn\u0019;j_:\u0004\u0003")
public class CatalogSuite
extends SparkFunSuite {
    private final java.util.Map<String, String> emptyProps = Collections.emptyMap();
    private final StructType schema = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("data", (DataType)StringType$.MODULE$);
    private final String[] testNs = (String[])((Object[])new String[]{"`", "."});
    private final Identifier testIdent = Identifier.of((String[])this.testNs(), (String)"test_table");
    private final Identifier testIdentNew = Identifier.of((String[])this.testNs(), (String)"test_table_new");
    private final UnboundFunction function;

    private java.util.Map<String, String> emptyProps() {
        return this.emptyProps;
    }

    private StructType schema() {
        return this.schema;
    }

    /*
     * WARNING - void declaration
     */
    private InMemoryCatalog newCatalog() {
        void var1_1;
        InMemoryCatalog newCatalog = new InMemoryCatalog();
        newCatalog.initialize("test", CaseInsensitiveStringMap.empty());
        return var1_1;
    }

    private String[] testNs() {
        return this.testNs;
    }

    private Identifier testIdent() {
        return this.testIdent;
    }

    private Identifier testIdentNew() {
        return this.testIdentNew;
    }

    public UnboundFunction function() {
        return this.function;
    }

    public CatalogSuite() {
        this.test("Catalogs can load the catalog", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            SQLConf conf = new SQLConf();
            conf.setConfString("spark.sql.catalog.test", catalog.getClass().getName());
            CatalogPlugin loaded = Catalogs$.MODULE$.load("test", conf);
            Class<?> $org_scalatest_assert_macro_left = loaded.getClass();
            Class<?> $org_scalatest_assert_macro_right = catalog.getClass();
            Class<?> clazz = $org_scalatest_assert_macro_left;
            Class<?> clazz2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "==", $org_scalatest_assert_macro_right, !(clazz != null ? !clazz.equals(clazz2) : clazz2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
        this.test("listTables", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Identifier ident1 = Identifier.of((String[])((String[])((Object[])new String[]{"ns"})), (String)"test_table_1");
            Identifier ident2 = Identifier.of((String[])((String[])((Object[])new String[]{"ns"})), (String)"test_table_2");
            Identifier ident3 = Identifier.of((String[])((String[])((Object[])new String[]{"ns2"})), (String)"test_table_1");
            this.intercept((Function0 & Serializable & scala.Serializable)() -> catalog.listTables((String[])((Object[])new String[]{"ns"})), ClassTag$.MODULE$.apply(NoSuchNamespaceException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
            catalog.createTable(ident1, this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            Set $org_scalatest_assert_macro_left = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])catalog.listTables((String[])((Object[])new String[]{"ns"})))).toSet();
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Identifier[]{ident1}));
            Set set = $org_scalatest_assert_macro_left;
            Set set2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> catalog.listTables((String[])((Object[])new String[]{"ns2"})), ClassTag$.MODULE$.apply(NoSuchNamespaceException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
            catalog.createTable(ident3, this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            catalog.createTable(ident2, this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            Set $org_scalatest_assert_macro_left2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])catalog.listTables((String[])((Object[])new String[]{"ns"})))).toSet();
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Identifier[]{ident1, ident2}));
            Set set3 = $org_scalatest_assert_macro_left2;
            Set set4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
            Set $org_scalatest_assert_macro_left3 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])catalog.listTables((String[])((Object[])new String[]{"ns2"})))).toSet();
            Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Identifier[]{ident3}));
            Set set5 = $org_scalatest_assert_macro_left3;
            Set set6 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(set5 != null ? !set5.equals(set6) : set6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
            catalog.dropTable(ident1);
            Set $org_scalatest_assert_macro_left4 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])catalog.listTables((String[])((Object[])new String[]{"ns"})))).toSet();
            Set $org_scalatest_assert_macro_right4 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Identifier[]{ident2}));
            Set set7 = $org_scalatest_assert_macro_left4;
            Set set8 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(set7 != null ? !set7.equals(set8) : set8 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
            catalog.dropTable(ident2);
            Object[] $org_scalatest_assert_macro_left5 = Predef$.MODULE$.refArrayOps((Object[])catalog.listTables((String[])((Object[])new String[]{"ns"})));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left5), "isEmpty", new ArrayOps.ofRef($org_scalatest_assert_macro_left5).isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
            Set $org_scalatest_assert_macro_left6 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])catalog.listTables((String[])((Object[])new String[]{"ns2"})))).toSet();
            Set $org_scalatest_assert_macro_right5 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Identifier[]{ident3}));
            Set set9 = $org_scalatest_assert_macro_left6;
            Set set10 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right5, !(set9 != null ? !set9.equals(set10) : set10 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
        this.test("createTable", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Seq parsed;
            InMemoryCatalog catalog = this.newCatalog();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(CatalogSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            Seq $org_scalatest_assert_macro_left = parsed = CatalystSqlParser$.MODULE$.parseMultipartIdentifier(table.name());
            Seq $org_scalatest_assert_macro_right = (Seq)new .colon.colon((Object)"test", (List)new .colon.colon((Object)"`", (List)new .colon.colon((Object)".", (List)new .colon.colon((Object)"test_table", (List)Nil$.MODULE$))));
            Seq seq = $org_scalatest_assert_macro_left;
            Seq seq2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(seq2) : seq2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
            StructType $org_scalatest_assert_macro_left2 = table.schema();
            StructType $org_scalatest_assert_macro_right2 = this.schema();
            StructType structType = $org_scalatest_assert_macro_left2;
            StructType structType2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
            scala.collection.mutable.Map $org_scalatest_assert_macro_left3 = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(table.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            scala.collection.mutable.Map map = $org_scalatest_assert_macro_left3;
            scala.collection.immutable.Map map2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(map != null ? !map.equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(CatalogSuite.this.testIdent)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
        this.test("createTable: with properties", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Seq parsed;
            InMemoryCatalog catalog = this.newCatalog();
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("property", "value");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(CatalogSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), properties);
            Seq $org_scalatest_assert_macro_left = parsed = CatalystSqlParser$.MODULE$.parseMultipartIdentifier(table.name());
            Seq $org_scalatest_assert_macro_right = (Seq)new .colon.colon((Object)"test", (List)new .colon.colon((Object)"`", (List)new .colon.colon((Object)".", (List)new .colon.colon((Object)"test_table", (List)Nil$.MODULE$))));
            Seq seq = $org_scalatest_assert_macro_left;
            Seq seq2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(seq2) : seq2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
            StructType $org_scalatest_assert_macro_left2 = table.schema();
            StructType $org_scalatest_assert_macro_right2 = this.schema();
            StructType structType = $org_scalatest_assert_macro_left2;
            StructType structType2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
            java.util.Map $org_scalatest_assert_macro_left3 = table.properties();
            HashMap<String, String> $org_scalatest_assert_macro_right3 = properties;
            java.util.Map map = $org_scalatest_assert_macro_left3;
            HashMap<String, String> hashMap = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", $org_scalatest_assert_macro_right3, !(map != null ? !((Object)map).equals(hashMap) : hashMap != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(CatalogSuite.this.testIdent)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
        this.test("createTable: table already exists", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(CatalogSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            TableAlreadyExistsException exc = (TableAlreadyExistsException)this.intercept((Function0 & Serializable & scala.Serializable)() -> catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps()), ClassTag$.MODULE$.apply(TableAlreadyExistsException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
            String $org_scalatest_assert_macro_left = exc.message();
            String $org_scalatest_assert_macro_right = CatalogV2Implicits$.MODULE$.IdentifierHelper(this.testIdent()).quoted();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
            String $org_scalatest_assert_macro_left2 = exc.message();
            String $org_scalatest_assert_macro_right2 = "already exists";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(CatalogSuite.this.testIdent)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
        this.test("tableExists", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(CatalogSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
            catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(CatalogSuite.this.testIdent)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
            catalog.dropTable(this.testIdent());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(CatalogSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
        this.test("loadTable", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            Table loaded = catalog.loadTable(this.testIdent());
            String $org_scalatest_assert_macro_left = table.name();
            String $org_scalatest_assert_macro_right = loaded.name();
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
            StructType $org_scalatest_assert_macro_left2 = table.schema();
            StructType $org_scalatest_assert_macro_right2 = loaded.schema();
            StructType structType = $org_scalatest_assert_macro_left2;
            StructType structType2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
            java.util.Map $org_scalatest_assert_macro_left3 = table.properties();
            java.util.Map $org_scalatest_assert_macro_right3 = loaded.properties();
            java.util.Map map = $org_scalatest_assert_macro_left3;
            java.util.Map map2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(map != null ? !((Object)map).equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
        this.test("loadTable: table does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            NoSuchTableException exc = (NoSuchTableException)this.intercept((Function0 & Serializable & scala.Serializable)() -> catalog.loadTable(this.testIdent()), ClassTag$.MODULE$.apply(NoSuchTableException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
            String $org_scalatest_assert_macro_left = exc.message();
            String $org_scalatest_assert_macro_right = CatalogV2Implicits$.MODULE$.IdentifierHelper(this.testIdent()).quoted();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
            String $org_scalatest_assert_macro_left2 = exc.message();
            String $org_scalatest_assert_macro_right2 = "not found";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
        this.test("invalidateTable", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            catalog.invalidateTable(this.testIdent());
            Table loaded = catalog.loadTable(this.testIdent());
            String $org_scalatest_assert_macro_left = table.name();
            String $org_scalatest_assert_macro_right = loaded.name();
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
            StructType $org_scalatest_assert_macro_left2 = table.schema();
            StructType $org_scalatest_assert_macro_right2 = loaded.schema();
            StructType structType = $org_scalatest_assert_macro_left2;
            StructType structType2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
            java.util.Map $org_scalatest_assert_macro_left3 = table.properties();
            java.util.Map $org_scalatest_assert_macro_right3 = loaded.properties();
            java.util.Map map = $org_scalatest_assert_macro_left3;
            java.util.Map map2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(map != null ? !((Object)map).equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 188));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178));
        this.test("invalidateTable: table does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)catalog.tableExists(this.testIdent())));
            boolean $org_scalatest_assert_macro_right = false;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 194));
            catalog.invalidateTable(this.testIdent());
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 191));
        this.test("alterTable: add property", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            scala.collection.mutable.Map $org_scalatest_assert_macro_left = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(table.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            scala.collection.mutable.Map map = $org_scalatest_assert_macro_left;
            scala.collection.immutable.Map map2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(map != null ? !map.equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 204));
            Table updated = catalog.alterTable(this.testIdent(), (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.setProperty((String)"prop-1", (String)"1")}));
            scala.collection.mutable.Map $org_scalatest_assert_macro_left2 = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(updated.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prop-1"), (Object)"1")}));
            scala.collection.mutable.Map map3 = $org_scalatest_assert_macro_left2;
            scala.collection.immutable.Map map4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(map3 != null ? !map3.equals(map4) : map4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 207));
            Table loaded = catalog.loadTable(this.testIdent());
            scala.collection.mutable.Map $org_scalatest_assert_macro_left3 = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(loaded.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prop-1"), (Object)"1")}));
            scala.collection.mutable.Map map5 = $org_scalatest_assert_macro_left3;
            scala.collection.immutable.Map map6 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(map5 != null ? !map5.equals(map6) : map6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 210));
            scala.collection.mutable.Map $org_scalatest_assert_macro_left4 = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(table.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right4 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            scala.collection.mutable.Map map7 = $org_scalatest_assert_macro_left4;
            scala.collection.immutable.Map map8 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(map7 != null ? !map7.equals(map8) : map8 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 212));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 199));
        this.test("alterTable: add property to existing", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("prop-1", "1");
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), properties);
            scala.collection.mutable.Map $org_scalatest_assert_macro_left = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(table.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prop-1"), (Object)"1")}));
            scala.collection.mutable.Map map = $org_scalatest_assert_macro_left;
            scala.collection.immutable.Map map2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(map != null ? !map.equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 223));
            Table updated = catalog.alterTable(this.testIdent(), (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.setProperty((String)"prop-2", (String)"2")}));
            scala.collection.mutable.Map $org_scalatest_assert_macro_left2 = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(updated.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prop-1"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prop-2"), (Object)"2")}));
            scala.collection.mutable.Map map3 = $org_scalatest_assert_macro_left2;
            scala.collection.immutable.Map map4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(map3 != null ? !map3.equals(map4) : map4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 226));
            Table loaded = catalog.loadTable(this.testIdent());
            scala.collection.mutable.Map $org_scalatest_assert_macro_left3 = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(loaded.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prop-1"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prop-2"), (Object)"2")}));
            scala.collection.mutable.Map map5 = $org_scalatest_assert_macro_left3;
            scala.collection.immutable.Map map6 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(map5 != null ? !map5.equals(map6) : map6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 229));
            scala.collection.mutable.Map $org_scalatest_assert_macro_left4 = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(table.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right4 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prop-1"), (Object)"1")}));
            scala.collection.mutable.Map map7 = $org_scalatest_assert_macro_left4;
            scala.collection.immutable.Map map8 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(map7 != null ? !map7.equals(map8) : map8 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 231));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 215));
        this.test("alterTable: remove existing property", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("prop-1", "1");
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), properties);
            scala.collection.mutable.Map $org_scalatest_assert_macro_left = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(table.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prop-1"), (Object)"1")}));
            scala.collection.mutable.Map map = $org_scalatest_assert_macro_left;
            scala.collection.immutable.Map map2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(map != null ? !map.equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242));
            Table updated = catalog.alterTable(this.testIdent(), (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.removeProperty((String)"prop-1")}));
            scala.collection.mutable.Map $org_scalatest_assert_macro_left2 = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(updated.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            scala.collection.mutable.Map map3 = $org_scalatest_assert_macro_left2;
            scala.collection.immutable.Map map4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(map3 != null ? !map3.equals(map4) : map4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 245));
            Table loaded = catalog.loadTable(this.testIdent());
            scala.collection.mutable.Map $org_scalatest_assert_macro_left3 = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(loaded.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            scala.collection.mutable.Map map5 = $org_scalatest_assert_macro_left3;
            scala.collection.immutable.Map map6 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(map5 != null ? !map5.equals(map6) : map6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 248));
            scala.collection.mutable.Map $org_scalatest_assert_macro_left4 = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(table.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right4 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prop-1"), (Object)"1")}));
            scala.collection.mutable.Map map7 = $org_scalatest_assert_macro_left4;
            scala.collection.immutable.Map map8 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(map7 != null ? !map7.equals(map8) : map8 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 250));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 234));
        this.test("alterTable: remove missing property", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            scala.collection.mutable.Map $org_scalatest_assert_macro_left = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(table.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            scala.collection.mutable.Map map = $org_scalatest_assert_macro_left;
            scala.collection.immutable.Map map2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(map != null ? !map.equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 258));
            Table updated = catalog.alterTable(this.testIdent(), (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.removeProperty((String)"prop-1")}));
            scala.collection.mutable.Map $org_scalatest_assert_macro_left2 = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(updated.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            scala.collection.mutable.Map map3 = $org_scalatest_assert_macro_left2;
            scala.collection.immutable.Map map4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(map3 != null ? !map3.equals(map4) : map4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 261));
            Table loaded = catalog.loadTable(this.testIdent());
            scala.collection.mutable.Map $org_scalatest_assert_macro_left3 = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(loaded.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            scala.collection.mutable.Map map5 = $org_scalatest_assert_macro_left3;
            scala.collection.immutable.Map map6 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(map5 != null ? !map5.equals(map6) : map6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 264));
            scala.collection.mutable.Map $org_scalatest_assert_macro_left4 = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(table.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right4 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            scala.collection.mutable.Map map7 = $org_scalatest_assert_macro_left4;
            scala.collection.immutable.Map map8 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(map7 != null ? !map7.equals(map8) : map8 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 266));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 253));
        this.test("alterTable: add top-level column", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = this.schema();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 274));
            Table updated = catalog.alterTable(this.testIdent(), (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.addColumn((String[])((String[])((Object[])new String[]{"ts"})), (DataType)TimestampType$.MODULE$)}));
            StructType $org_scalatest_assert_macro_left2 = updated.schema();
            StructType $org_scalatest_assert_macro_right2 = this.schema().add("ts", (DataType)TimestampType$.MODULE$);
            StructType structType3 = $org_scalatest_assert_macro_left2;
            StructType structType4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 278));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 269));
        this.test("alterTable: add required column", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = this.schema();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 286));
            Table updated = catalog.alterTable(this.testIdent(), (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.addColumn((String[])((String[])((Object[])new String[]{"ts"})), (DataType)TimestampType$.MODULE$, (boolean)false)}));
            StructType $org_scalatest_assert_macro_left2 = updated.schema();
            StructType $org_scalatest_assert_macro_right2 = this.schema().add("ts", (DataType)TimestampType$.MODULE$, false);
            StructType structType3 = $org_scalatest_assert_macro_left2;
            StructType structType4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 291));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 281));
        this.test("alterTable: add column with comment", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = this.schema();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 299));
            Table updated = catalog.alterTable(this.testIdent(), (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.addColumn((String[])((String[])((Object[])new String[]{"ts"})), (DataType)TimestampType$.MODULE$, (boolean)false, (String)"comment text")}));
            StructField field = new StructField("ts", (DataType)TimestampType$.MODULE$, false, StructField$.MODULE$.apply$default$4()).withComment("comment text");
            StructType $org_scalatest_assert_macro_left2 = updated.schema();
            StructType $org_scalatest_assert_macro_right2 = this.schema().add(field);
            StructType structType3 = $org_scalatest_assert_macro_left2;
            StructType structType4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 305));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 294));
        this.test("alterTable: add nested column", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            StructType pointStruct = new StructType().add("x", (DataType)DoubleType$.MODULE$).add("y", (DataType)DoubleType$.MODULE$);
            StructType tableSchema = this.schema().add("point", (DataType)pointStruct);
            Table table = catalog.createTable(this.testIdent(), tableSchema, (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = tableSchema;
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 316));
            Table updated = catalog.alterTable(this.testIdent(), (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.addColumn((String[])((String[])((Object[])new String[]{"point", "z"})), (DataType)DoubleType$.MODULE$)}));
            StructType expectedSchema = this.schema().add("point", (DataType)pointStruct.add("z", (DataType)DoubleType$.MODULE$));
            StructType $org_scalatest_assert_macro_left2 = updated.schema();
            StructType $org_scalatest_assert_macro_right2 = expectedSchema;
            StructType structType3 = $org_scalatest_assert_macro_left2;
            StructType structType4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 323));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 308));
        this.test("alterTable: add column to primitive field fails", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = this.schema();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 331));
            IllegalArgumentException exc = (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> catalog.alterTable(this.testIdent(), (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.addColumn((String[])((String[])((Object[])new String[]{"data", "ts"})), (DataType)TimestampType$.MODULE$)})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 333));
            String $org_scalatest_assert_macro_left2 = exc.getMessage();
            String $org_scalatest_assert_macro_right2 = "Not a struct";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 337));
            String $org_scalatest_assert_macro_left3 = exc.getMessage();
            String $org_scalatest_assert_macro_right3 = "data";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 338));
            StructType $org_scalatest_assert_macro_left4 = catalog.loadTable(this.testIdent()).schema();
            StructType $org_scalatest_assert_macro_right4 = this.schema();
            StructType structType3 = $org_scalatest_assert_macro_left4;
            StructType structType4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 341));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 326));
        this.test("alterTable: add field to missing column fails", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = this.schema();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 349));
            IllegalArgumentException exc = (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> catalog.alterTable(this.testIdent(), (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.addColumn((String[])((String[])((Object[])new String[]{"missing_col", "new_field"})), (DataType)StringType$.MODULE$)})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 351));
            String $org_scalatest_assert_macro_left2 = exc.getMessage();
            String $org_scalatest_assert_macro_right2 = "missing_col";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 356));
            String $org_scalatest_assert_macro_left3 = exc.getMessage();
            String $org_scalatest_assert_macro_right3 = "Cannot find";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 357));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 344));
        this.test("alterTable: update column data type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = this.schema();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 365));
            Table updated = catalog.alterTable(this.testIdent(), (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.updateColumnType((String[])((String[])((Object[])new String[]{"id"})), (DataType)LongType$.MODULE$)}));
            StructType expectedSchema = new StructType().add("id", (DataType)LongType$.MODULE$).add("data", (DataType)StringType$.MODULE$);
            StructType $org_scalatest_assert_macro_left2 = updated.schema();
            StructType $org_scalatest_assert_macro_right2 = expectedSchema;
            StructType structType3 = $org_scalatest_assert_macro_left2;
            StructType structType4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 370));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 360));
        this.test("alterTable: update column nullability", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            StructType originalSchema = new StructType().add("id", (DataType)IntegerType$.MODULE$, false).add("data", (DataType)StringType$.MODULE$);
            Table table = catalog.createTable(this.testIdent(), originalSchema, (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = originalSchema;
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 381));
            Table updated = catalog.alterTable(this.testIdent(), (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.updateColumnNullability((String[])((String[])((Object[])new String[]{"id"})), (boolean)true)}));
            StructType expectedSchema = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("data", (DataType)StringType$.MODULE$);
            StructType $org_scalatest_assert_macro_left2 = updated.schema();
            StructType $org_scalatest_assert_macro_right2 = expectedSchema;
            StructType structType3 = $org_scalatest_assert_macro_left2;
            StructType structType4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 387));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 373));
        this.test("alterTable: update missing column fails", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = this.schema();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 395));
            IllegalArgumentException exc = (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> catalog.alterTable(this.testIdent(), (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.updateColumnType((String[])((String[])((Object[])new String[]{"missing_col"})), (DataType)LongType$.MODULE$)})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 397));
            String $org_scalatest_assert_macro_left2 = exc.getMessage();
            String $org_scalatest_assert_macro_right2 = "missing_col";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 402));
            String $org_scalatest_assert_macro_left3 = exc.getMessage();
            String $org_scalatest_assert_macro_right3 = "Cannot find";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 403));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 390));
        this.test("alterTable: add comment", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = this.schema();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 411));
            Table updated = catalog.alterTable(this.testIdent(), (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.updateColumnComment((String[])((String[])((Object[])new String[]{"id"})), (String)"comment text")}));
            StructType expectedSchema = new StructType().add("id", (DataType)IntegerType$.MODULE$, true, "comment text").add("data", (DataType)StringType$.MODULE$);
            StructType $org_scalatest_assert_macro_left2 = updated.schema();
            StructType $org_scalatest_assert_macro_right2 = expectedSchema;
            StructType structType3 = $org_scalatest_assert_macro_left2;
            StructType structType4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 419));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 406));
        this.test("alterTable: replace comment", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = this.schema();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 427));
            catalog.alterTable(this.testIdent(), (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.updateColumnComment((String[])((String[])((Object[])new String[]{"id"})), (String)"comment text")}));
            StructType expectedSchema = new StructType().add("id", (DataType)IntegerType$.MODULE$, true, "replacement comment").add("data", (DataType)StringType$.MODULE$);
            Table updated = catalog.alterTable(this.testIdent(), (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.updateColumnComment((String[])((String[])((Object[])new String[]{"id"})), (String)"replacement comment")}));
            StructType $org_scalatest_assert_macro_left2 = updated.schema();
            StructType $org_scalatest_assert_macro_right2 = expectedSchema;
            StructType structType3 = $org_scalatest_assert_macro_left2;
            StructType structType4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 438));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 422));
        this.test("alterTable: add comment to missing column fails", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = this.schema();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 446));
            IllegalArgumentException exc = (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> catalog.alterTable(this.testIdent(), (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.updateColumnComment((String[])((String[])((Object[])new String[]{"missing_col"})), (String)"comment")})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 448));
            String $org_scalatest_assert_macro_left2 = exc.getMessage();
            String $org_scalatest_assert_macro_right2 = "missing_col";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 453));
            String $org_scalatest_assert_macro_left3 = exc.getMessage();
            String $org_scalatest_assert_macro_right3 = "Cannot find";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 454));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 441));
        this.test("alterTable: rename top-level column", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = this.schema();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 462));
            Table updated = catalog.alterTable(this.testIdent(), (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.renameColumn((String[])((String[])((Object[])new String[]{"id"})), (String)"some_id")}));
            StructType expectedSchema = new StructType().add("some_id", (DataType)IntegerType$.MODULE$).add("data", (DataType)StringType$.MODULE$);
            StructType $org_scalatest_assert_macro_left2 = updated.schema();
            StructType $org_scalatest_assert_macro_right2 = expectedSchema;
            StructType structType3 = $org_scalatest_assert_macro_left2;
            StructType structType4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 468));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 457));
        this.test("alterTable: rename nested column", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            StructType pointStruct = new StructType().add("x", (DataType)DoubleType$.MODULE$).add("y", (DataType)DoubleType$.MODULE$);
            StructType tableSchema = this.schema().add("point", (DataType)pointStruct);
            Table table = catalog.createTable(this.testIdent(), tableSchema, (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = tableSchema;
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 479));
            Table updated = catalog.alterTable(this.testIdent(), (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.renameColumn((String[])((String[])((Object[])new String[]{"point", "x"})), (String)"first")}));
            StructType newPointStruct = new StructType().add("first", (DataType)DoubleType$.MODULE$).add("y", (DataType)DoubleType$.MODULE$);
            StructType expectedSchema = this.schema().add("point", (DataType)newPointStruct);
            StructType $org_scalatest_assert_macro_left2 = updated.schema();
            StructType $org_scalatest_assert_macro_right2 = expectedSchema;
            StructType structType3 = $org_scalatest_assert_macro_left2;
            StructType structType4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 487));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 471));
        this.test("alterTable: rename struct column", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            StructType pointStruct = new StructType().add("x", (DataType)DoubleType$.MODULE$).add("y", (DataType)DoubleType$.MODULE$);
            StructType tableSchema = this.schema().add("point", (DataType)pointStruct);
            Table table = catalog.createTable(this.testIdent(), tableSchema, (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = tableSchema;
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 498));
            Table updated = catalog.alterTable(this.testIdent(), (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.renameColumn((String[])((String[])((Object[])new String[]{"point"})), (String)"p")}));
            StructType newPointStruct = new StructType().add("x", (DataType)DoubleType$.MODULE$).add("y", (DataType)DoubleType$.MODULE$);
            StructType expectedSchema = this.schema().add("p", (DataType)newPointStruct);
            StructType $org_scalatest_assert_macro_left2 = updated.schema();
            StructType $org_scalatest_assert_macro_right2 = expectedSchema;
            StructType structType3 = $org_scalatest_assert_macro_left2;
            StructType structType4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 506));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 490));
        this.test("alterTable: rename missing column fails", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = this.schema();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 514));
            IllegalArgumentException exc = (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> catalog.alterTable(this.testIdent(), (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.renameColumn((String[])((String[])((Object[])new String[]{"missing_col"})), (String)"new_name")})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 516));
            String $org_scalatest_assert_macro_left2 = exc.getMessage();
            String $org_scalatest_assert_macro_right2 = "missing_col";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 521));
            String $org_scalatest_assert_macro_left3 = exc.getMessage();
            String $org_scalatest_assert_macro_right3 = "Cannot find";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 522));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 509));
        this.test("alterTable: multiple changes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            StructType pointStruct = new StructType().add("x", (DataType)DoubleType$.MODULE$).add("y", (DataType)DoubleType$.MODULE$);
            StructType tableSchema = this.schema().add("point", (DataType)pointStruct);
            Table table = catalog.createTable(this.testIdent(), tableSchema, (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = tableSchema;
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 533));
            Table updated = catalog.alterTable(this.testIdent(), (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.renameColumn((String[])((String[])((Object[])new String[]{"point", "x"})), (String)"first"), TableChange.renameColumn((String[])((String[])((Object[])new String[]{"point", "y"})), (String)"second")}));
            StructType newPointStruct = new StructType().add("first", (DataType)DoubleType$.MODULE$).add("second", (DataType)DoubleType$.MODULE$);
            StructType expectedSchema = this.schema().add("point", (DataType)newPointStruct);
            StructType $org_scalatest_assert_macro_left2 = updated.schema();
            StructType $org_scalatest_assert_macro_right2 = expectedSchema;
            StructType structType3 = $org_scalatest_assert_macro_left2;
            StructType structType4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 542));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 525));
        this.test("alterTable: delete top-level column", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = this.schema();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 550));
            Table updated = catalog.alterTable(this.testIdent(), (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.deleteColumn((String[])((String[])((Object[])new String[]{"id"})))}));
            StructType expectedSchema = new StructType().add("data", (DataType)StringType$.MODULE$);
            StructType $org_scalatest_assert_macro_left2 = updated.schema();
            StructType $org_scalatest_assert_macro_right2 = expectedSchema;
            StructType structType3 = $org_scalatest_assert_macro_left2;
            StructType structType4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 556));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 545));
        this.test("alterTable: delete nested column", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            StructType pointStruct = new StructType().add("x", (DataType)DoubleType$.MODULE$).add("y", (DataType)DoubleType$.MODULE$);
            StructType tableSchema = this.schema().add("point", (DataType)pointStruct);
            Table table = catalog.createTable(this.testIdent(), tableSchema, (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = tableSchema;
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 567));
            Table updated = catalog.alterTable(this.testIdent(), (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.deleteColumn((String[])((String[])((Object[])new String[]{"point", "y"})))}));
            StructType newPointStruct = new StructType().add("x", (DataType)DoubleType$.MODULE$);
            StructType expectedSchema = this.schema().add("point", (DataType)newPointStruct);
            StructType $org_scalatest_assert_macro_left2 = updated.schema();
            StructType $org_scalatest_assert_macro_right2 = expectedSchema;
            StructType structType3 = $org_scalatest_assert_macro_left2;
            StructType structType4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 575));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 559));
        this.test("alterTable: delete missing column fails", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = this.schema();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 583));
            IllegalArgumentException exc = (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> catalog.alterTable(this.testIdent(), (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.deleteColumn((String[])((String[])((Object[])new String[]{"missing_col"})))})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 585));
            String $org_scalatest_assert_macro_left2 = exc.getMessage();
            String $org_scalatest_assert_macro_right2 = "missing_col";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 589));
            String $org_scalatest_assert_macro_left3 = exc.getMessage();
            String $org_scalatest_assert_macro_right3 = "Cannot find";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 590));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 578));
        this.test("alterTable: delete missing nested column fails", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            StructType pointStruct = new StructType().add("x", (DataType)DoubleType$.MODULE$).add("y", (DataType)DoubleType$.MODULE$);
            StructType tableSchema = this.schema().add("point", (DataType)pointStruct);
            Table table = catalog.createTable(this.testIdent(), tableSchema, (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = tableSchema;
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 601));
            IllegalArgumentException exc = (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> catalog.alterTable(this.testIdent(), (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.deleteColumn((String[])((String[])((Object[])new String[]{"point", "z"})))})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 603));
            String $org_scalatest_assert_macro_left2 = exc.getMessage();
            String $org_scalatest_assert_macro_right2 = "z";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 607));
            String $org_scalatest_assert_macro_left3 = exc.getMessage();
            String $org_scalatest_assert_macro_right3 = "Cannot find";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 608));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 593));
        this.test("alterTable: table does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            NoSuchTableException exc = (NoSuchTableException)this.intercept((Function0 & Serializable & scala.Serializable)() -> catalog.alterTable(this.testIdent(), (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.setProperty((String)"prop", (String)"val")})), ClassTag$.MODULE$.apply(NoSuchTableException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 614));
            String $org_scalatest_assert_macro_left = exc.message();
            String $org_scalatest_assert_macro_right = CatalogV2Implicits$.MODULE$.IdentifierHelper(this.testIdent()).quoted();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 618));
            String $org_scalatest_assert_macro_left2 = exc.message();
            String $org_scalatest_assert_macro_right2 = "not found";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 619));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 611));
        this.test("dropTable", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(CatalogSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 625));
            catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(CatalogSuite.this.testIdent)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 629));
            boolean wasDropped = catalog.dropTable(this.testIdent());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(wasDropped, "wasDropped", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 633));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(CatalogSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 634));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 622));
        this.test("dropTable: table does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(CatalogSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 640));
            boolean wasDropped = catalog.dropTable(this.testIdent());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(wasDropped, "wasDropped", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 644));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(CatalogSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 645));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 637));
        this.test("purgeTable", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            return (UnsupportedOperationException)this.intercept((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> catalog.purgeTable(this.testIdent()), ClassTag$.MODULE$.apply(UnsupportedOperationException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 650));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 648));
        this.test("renameTable", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(CatalogSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 656));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdentNew()), "catalog.tableExists(CatalogSuite.this.testIdentNew)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 657));
            catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(CatalogSuite.this.testIdent)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 661));
            catalog.renameTable(this.testIdent(), this.testIdentNew());
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(CatalogSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 664));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdentNew()), "catalog.tableExists(CatalogSuite.this.testIdentNew)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 665));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 653));
        this.test("renameTable: fail if table does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            NoSuchTableException exc = (NoSuchTableException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> catalog.renameTable(this.testIdent(), this.testIdentNew()), ClassTag$.MODULE$.apply(NoSuchTableException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 671));
            String $org_scalatest_assert_macro_left = exc.message();
            String $org_scalatest_assert_macro_right = CatalogV2Implicits$.MODULE$.IdentifierHelper(this.testIdent()).quoted();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 675));
            String $org_scalatest_assert_macro_left2 = exc.message();
            String $org_scalatest_assert_macro_right2 = "not found";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 676));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 668));
        this.test("renameTable: fail if new table name already exists", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(CatalogSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 682));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdentNew()), "catalog.tableExists(CatalogSuite.this.testIdentNew)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 683));
            catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            catalog.createTable(this.testIdentNew(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(CatalogSuite.this.testIdent)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 688));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdentNew()), "catalog.tableExists(CatalogSuite.this.testIdentNew)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 689));
            TableAlreadyExistsException exc = (TableAlreadyExistsException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> catalog.renameTable(this.testIdent(), this.testIdentNew()), ClassTag$.MODULE$.apply(TableAlreadyExistsException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 691));
            String $org_scalatest_assert_macro_left = exc.message();
            String $org_scalatest_assert_macro_right = CatalogV2Implicits$.MODULE$.IdentifierHelper(this.testIdentNew()).quoted();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 695));
            String $org_scalatest_assert_macro_left2 = exc.message();
            String $org_scalatest_assert_macro_right2 = "already exists";
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 696));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 679));
        this.test("listNamespaces: list namespaces from metadata", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            catalog.createNamespace((String[])((Object[])new String[]{"ns1"}), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)"value")}))).asJava());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(catalog.listNamespaces());
            String[][] $org_scalatest_assert_macro_right = (String[][])((Object[])new String[][]{(String[])((Object[])new String[]{"ns1"})});
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 703));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(catalog.listNamespaces((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))));
            String[][] $org_scalatest_assert_macro_right2 = (String[][])((Object[])new String[][]{(String[])((Object[])new String[]{"ns1"})});
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 704));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(catalog.listNamespaces((String[])((Object[])new String[]{"ns1"})));
            Object[] $org_scalatest_assert_macro_right3 = (Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Nothing());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 705));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 699));
        this.test("listNamespaces: list namespaces from tables", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Identifier ident1 = Identifier.of((String[])((String[])((Object[])new String[]{"ns1", "ns2"})), (String)"test_table_1");
            Identifier ident2 = Identifier.of((String[])((String[])((Object[])new String[]{"ns1", "ns2"})), (String)"test_table_2");
            catalog.createTable(ident1, this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            catalog.createTable(ident2, this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(catalog.listNamespaces());
            String[][] $org_scalatest_assert_macro_right = (String[][])((Object[])new String[][]{(String[])((Object[])new String[]{"ns1"})});
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 716));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(catalog.listNamespaces((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))));
            String[][] $org_scalatest_assert_macro_right2 = (String[][])((Object[])new String[][]{(String[])((Object[])new String[]{"ns1"})});
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 717));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(catalog.listNamespaces((String[])((Object[])new String[]{"ns1"})));
            String[][] $org_scalatest_assert_macro_right3 = (String[][])((Object[])new String[][]{(String[])((Object[])new String[]{"ns1", "ns2"})});
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 718));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(catalog.listNamespaces((String[])((Object[])new String[]{"ns1", "ns2"})));
            Object[] $org_scalatest_assert_macro_right4 = (Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Nothing());
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 719));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 708));
        this.test("listNamespaces: list namespaces from metadata and tables", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Identifier ident1 = Identifier.of((String[])((String[])((Object[])new String[]{"ns1", "ns2"})), (String)"test_table_1");
            Identifier ident2 = Identifier.of((String[])((String[])((Object[])new String[]{"ns1", "ns2"})), (String)"test_table_2");
            catalog.createNamespace((String[])((Object[])new String[]{"ns1"}), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)"value")}))).asJava());
            catalog.createTable(ident1, this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            catalog.createTable(ident2, this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(catalog.listNamespaces());
            String[][] $org_scalatest_assert_macro_right = (String[][])((Object[])new String[][]{(String[])((Object[])new String[]{"ns1"})});
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 731));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(catalog.listNamespaces((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))));
            String[][] $org_scalatest_assert_macro_right2 = (String[][])((Object[])new String[][]{(String[])((Object[])new String[]{"ns1"})});
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 732));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(catalog.listNamespaces((String[])((Object[])new String[]{"ns1"})));
            String[][] $org_scalatest_assert_macro_right3 = (String[][])((Object[])new String[][]{(String[])((Object[])new String[]{"ns1", "ns2"})});
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 733));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(catalog.listNamespaces((String[])((Object[])new String[]{"ns1", "ns2"})));
            Object[] $org_scalatest_assert_macro_right4 = (Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Nothing());
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 734));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 722));
        this.test("loadNamespaceMetadata: fail if no metadata or tables exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            NoSuchNamespaceException exc = (NoSuchNamespaceException)this.intercept((Function0 & Serializable & scala.Serializable)() -> catalog.loadNamespaceMetadata(this.testNs()), ClassTag$.MODULE$.apply(NoSuchNamespaceException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 740));
            String $org_scalatest_assert_macro_left = exc.getMessage();
            String $org_scalatest_assert_macro_right = CatalogV2Implicits$.MODULE$.NamespaceHelper(this.testNs()).quoted();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 744));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 737));
        this.test("loadNamespaceMetadata: no metadata, table exists", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            java.util.Map<String, String> metadata = catalog.loadNamespaceMetadata(this.testNs());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(JavaConverters$.MODULE$.mapAsScalaMapConverter(metadata).asScala());
            scala.collection.immutable.Map $org_scalatest_assert_macro_right = Predef$.MODULE$.Map().empty();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 754));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 747));
        this.test("loadNamespaceMetadata: metadata exists, no tables", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            catalog.createNamespace(this.testNs(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)"value")}))).asJava());
            java.util.Map<String, String> metadata = catalog.loadNamespaceMetadata(this.testNs());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(JavaConverters$.MODULE$.mapAsScalaMapConverter(metadata).asScala());
            scala.collection.immutable.Map $org_scalatest_assert_macro_right = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)"value")}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 764));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 757));
        this.test("loadNamespaceMetadata: metadata and table exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            catalog.createNamespace(this.testNs(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)"value")}))).asJava());
            catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            java.util.Map<String, String> metadata = catalog.loadNamespaceMetadata(this.testNs());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(JavaConverters$.MODULE$.mapAsScalaMapConverter(metadata).asScala());
            scala.collection.immutable.Map $org_scalatest_assert_macro_right = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)"value")}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 775));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 767));
        this.test("createNamespace: basic behavior", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            catalog.createNamespace(this.testNs(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)"value")}))).asJava());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)catalog.namespaceExists(this.testNs())));
            boolean $org_scalatest_assert_macro_right = true;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 783));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(JavaConverters$.MODULE$.mapAsScalaMapConverter(catalog.loadNamespaceMetadata(this.testNs())).asScala());
            scala.collection.immutable.Map $org_scalatest_assert_macro_right2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)"value")}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 784));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 778));
        this.test("createNamespace: fail if metadata already exists", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            catalog.createNamespace(this.testNs(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)"value")}))).asJava());
            NamespaceAlreadyExistsException exc = (NamespaceAlreadyExistsException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> catalog.createNamespace(this.testNs(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)"value")}))).asJava()), ClassTag$.MODULE$.apply(NamespaceAlreadyExistsException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 792));
            String $org_scalatest_assert_macro_left = exc.getMessage();
            String $org_scalatest_assert_macro_right = CatalogV2Implicits$.MODULE$.NamespaceHelper(this.testNs()).quoted();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 796));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)catalog.namespaceExists(this.testNs())));
            boolean $org_scalatest_assert_macro_right2 = true;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 797));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(JavaConverters$.MODULE$.mapAsScalaMapConverter(catalog.loadNamespaceMetadata(this.testNs())).asScala());
            scala.collection.immutable.Map $org_scalatest_assert_macro_right3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)"value")}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 798));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 787));
        this.test("createNamespace: fail if namespace already exists from table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)catalog.namespaceExists(this.testNs())));
            boolean $org_scalatest_assert_macro_right = true;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 806));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(JavaConverters$.MODULE$.mapAsScalaMapConverter(catalog.loadNamespaceMetadata(this.testNs())).asScala());
            scala.collection.immutable.Map $org_scalatest_assert_macro_right2 = Predef$.MODULE$.Map().empty();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 807));
            NamespaceAlreadyExistsException exc = (NamespaceAlreadyExistsException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> catalog.createNamespace(this.testNs(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)"value")}))).asJava()), ClassTag$.MODULE$.apply(NamespaceAlreadyExistsException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 809));
            String $org_scalatest_assert_macro_left3 = exc.getMessage();
            String $org_scalatest_assert_macro_right3 = CatalogV2Implicits$.MODULE$.NamespaceHelper(this.testNs()).quoted();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 813));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)catalog.namespaceExists(this.testNs())));
            boolean $org_scalatest_assert_macro_right4 = true;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 814));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(JavaConverters$.MODULE$.mapAsScalaMapConverter(catalog.loadNamespaceMetadata(this.testNs())).asScala());
            scala.collection.immutable.Map $org_scalatest_assert_macro_right5 = Predef$.MODULE$.Map().empty();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 815));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 801));
        this.test("dropNamespace: drop missing namespace", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)catalog.namespaceExists(this.testNs())));
            boolean $org_scalatest_assert_macro_right = false;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 821));
            boolean ret = catalog.dropNamespace(this.testNs());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)ret));
            boolean $org_scalatest_assert_macro_right2 = false;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 825));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 818));
        this.test("dropNamespace: drop empty namespace", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            catalog.createNamespace(this.testNs(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)"value")}))).asJava());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)catalog.namespaceExists(this.testNs())));
            boolean $org_scalatest_assert_macro_right = true;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 833));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(JavaConverters$.MODULE$.mapAsScalaMapConverter(catalog.loadNamespaceMetadata(this.testNs())).asScala());
            scala.collection.immutable.Map $org_scalatest_assert_macro_right2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)"value")}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 834));
            boolean ret = catalog.dropNamespace(this.testNs());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)ret));
            boolean $org_scalatest_assert_macro_right3 = true;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 838));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)catalog.namespaceExists(this.testNs())));
            boolean $org_scalatest_assert_macro_right4 = false;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 839));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 828));
        this.test("dropNamespace: drop even if it's not empty", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            catalog.createNamespace(this.testNs(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)"value")}))).asJava());
            catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(catalog.dropNamespace(this.testNs()), "catalog.dropNamespace(CatalogSuite.this.testNs)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 848));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.namespaceExists(this.testNs()), "catalog.namespaceExists(CatalogSuite.this.testNs)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 850));
            return (NoSuchNamespaceException)this.intercept((Function0 & Serializable & scala.Serializable)() -> catalog.listTables(this.testNs()), ClassTag$.MODULE$.apply(NoSuchNamespaceException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 851));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
        this.test("alterNamespace: basic behavior", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            catalog.createNamespace(this.testNs(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)"value")}))).asJava());
            catalog.alterNamespace(this.testNs(), (Seq<NamespaceChange>)Predef$.MODULE$.wrapRefArray((Object[])new NamespaceChange[]{NamespaceChange.setProperty((String)"property2", (String)"value2")}));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(JavaConverters$.MODULE$.mapAsScalaMapConverter(catalog.loadNamespaceMetadata(this.testNs())).asScala());
            scala.collection.immutable.Map $org_scalatest_assert_macro_right = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)"value"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property2"), (Object)"value2")}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 860));
            catalog.alterNamespace(this.testNs(), (Seq<NamespaceChange>)Predef$.MODULE$.wrapRefArray((Object[])new NamespaceChange[]{NamespaceChange.removeProperty((String)"property2"), NamespaceChange.setProperty((String)"property3", (String)"value3")}));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(JavaConverters$.MODULE$.mapAsScalaMapConverter(catalog.loadNamespaceMetadata(this.testNs())).asScala());
            scala.collection.immutable.Map $org_scalatest_assert_macro_right2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)"value"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property3"), (Object)"value3")}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 866));
            catalog.alterNamespace(this.testNs(), (Seq<NamespaceChange>)Predef$.MODULE$.wrapRefArray((Object[])new NamespaceChange[]{NamespaceChange.removeProperty((String)"property3")}));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(JavaConverters$.MODULE$.mapAsScalaMapConverter(catalog.loadNamespaceMetadata(this.testNs())).asScala());
            scala.collection.immutable.Map $org_scalatest_assert_macro_right3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)"value")}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 870));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 854));
        this.test("alterNamespace: create metadata if missing and table exists", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            catalog.alterNamespace(this.testNs(), (Seq<NamespaceChange>)Predef$.MODULE$.wrapRefArray((Object[])new NamespaceChange[]{NamespaceChange.setProperty((String)"property", (String)"value")}));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(JavaConverters$.MODULE$.mapAsScalaMapConverter(catalog.loadNamespaceMetadata(this.testNs())).asScala());
            scala.collection.immutable.Map $org_scalatest_assert_macro_right = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)"value")}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 880));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 873));
        this.test("alterNamespace: fail if no metadata or table exists", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            NoSuchNamespaceException exc = (NoSuchNamespaceException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> catalog.alterNamespace(this.testNs(), (Seq<NamespaceChange>)Predef$.MODULE$.wrapRefArray((Object[])new NamespaceChange[]{NamespaceChange.setProperty((String)"property", (String)"value")})), ClassTag$.MODULE$.apply(NoSuchNamespaceException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 886));
            String $org_scalatest_assert_macro_left = exc.getMessage();
            String $org_scalatest_assert_macro_right = CatalogV2Implicits$.MODULE$.NamespaceHelper(this.testNs()).quoted();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 890));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 883));
        this.test("truncate non-partitioned table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            InMemoryTable table = (InMemoryTable)catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            table.withData((BufferedRows[])((Object[])new BufferedRows[]{new BufferedRows("3").withRow(InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), "abc", "3"}))), new BufferedRows("4").withRow(InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "def", "4"})))}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(table.truncateTable(), "table.truncateTable()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 901));
            Seq<InternalRow> $org_scalatest_assert_macro_left = table.rows();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 902));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 893));
        this.test("truncate partitioned table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryPartitionTableCatalog partCatalog = new InMemoryPartitionTableCatalog();
            partCatalog.initialize("test", CaseInsensitiveStringMap.empty());
            Table table = partCatalog.createTable(this.testIdent(), new StructType().add("col0", (DataType)IntegerType$.MODULE$).add("part0", (DataType)IntegerType$.MODULE$), (Transform[])((Object[])new Transform[]{LogicalExpressions$.MODULE$.identity(LogicalExpressions$.MODULE$.parseReference("part0"))}), Collections.emptyMap());
            InMemoryPartitionTable partTable = (InMemoryPartitionTable)table;
            InternalRow partIdent = InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)}));
            InternalRow partIdent1 = InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)}));
            partTable.createPartition(partIdent, new HashMap<String, String>());
            partTable.createPartition(partIdent1, new HashMap<String, String>());
            partTable.withData((BufferedRows[])((Object[])new BufferedRows[]{new BufferedRows("0").withRow(InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0)}))), new BufferedRows("1").withRow(InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})))}));
            InternalRow[] $org_scalatest_assert_macro_left = partTable.listPartitionIdentifiers((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), InternalRow$.MODULE$.empty());
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 925));
            Seq<InternalRow> $org_scalatest_assert_macro_left2 = partTable.rows();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 926));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(partTable.truncateTable(), "partTable.truncateTable()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 927));
            InternalRow[] $org_scalatest_assert_macro_left3 = partTable.listPartitionIdentifiers((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), InternalRow$.MODULE$.empty());
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 928));
            Seq<InternalRow> $org_scalatest_assert_macro_left4 = partTable.rows();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left4, "isEmpty", $org_scalatest_assert_macro_left4.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 929));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 905));
        this.function = new UnboundFunction(null){

            public BoundFunction bind(StructType inputType) {
                return new ScalarFunction<Object>(null){

                    public Object produceResult(InternalRow x$1) {
                        return super.produceResult(x$1);
                    }

                    public DataType[] inputTypes() {
                        return (DataType[])((Object[])new DataType[]{IntegerType$.MODULE$});
                    }

                    public DataType resultType() {
                        return IntegerType$.MODULE$;
                    }

                    public String name() {
                        return "my_bound_function";
                    }
                };
            }

            public String description() {
                return "my_function";
            }

            public String name() {
                return "my_function";
            }
        };
        this.test("list functions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Identifier ident1 = Identifier.of((String[])((String[])((Object[])new String[]{"ns1", "ns2"})), (String)"func1");
            Identifier ident2 = Identifier.of((String[])((String[])((Object[])new String[]{"ns1", "ns2"})), (String)"func2");
            Identifier ident3 = Identifier.of((String[])((String[])((Object[])new String[]{"ns1", "ns3"})), (String)"func3");
            catalog.createNamespace((String[])((Object[])new String[]{"ns1", "ns2"}), this.emptyProps());
            catalog.createNamespace((String[])((Object[])new String[]{"ns1", "ns3"}), this.emptyProps());
            catalog.createFunction(ident1, this.function());
            catalog.createFunction(ident2, this.function());
            catalog.createFunction(ident3, this.function());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])catalog.listFunctions((String[])((Object[])new String[]{"ns1", "ns2"})))).toSet());
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Identifier[]{ident1, ident2}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 954));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])catalog.listFunctions((String[])((Object[])new String[]{"ns1", "ns3"})))).toSet());
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Identifier[]{ident3}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 955));
            Set $org_scalatest_assert_macro_left3 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])catalog.listFunctions((String[])((Object[])new String[]{"ns1"})))).toSet();
            Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
            Set set = $org_scalatest_assert_macro_left3;
            Set set2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 956));
            return (NoSuchNamespaceException)this.intercept((Function0 & Serializable & scala.Serializable)() -> catalog.listFunctions((String[])((Object[])new String[]{"ns2"})), ClassTag$.MODULE$.apply(NoSuchNamespaceException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 957));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 942));
        this.test("lookup function", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Identifier ident = Identifier.of((String[])((String[])((Object[])new String[]{"ns"})), (String)"func");
            catalog.createNamespace((String[])((Object[])new String[]{"ns"}), this.emptyProps());
            catalog.createFunction(ident, this.function());
            UnboundFunction $org_scalatest_assert_macro_left = catalog.loadFunction(ident);
            UnboundFunction $org_scalatest_assert_macro_right = this.function();
            UnboundFunction unboundFunction = $org_scalatest_assert_macro_left;
            UnboundFunction unboundFunction2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(unboundFunction != null ? !unboundFunction.equals(unboundFunction2) : unboundFunction2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 966));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> catalog.loadFunction(Identifier.of((String[])((String[])((Object[])new String[]{"ns"})), (String)"func1")), ClassTag$.MODULE$.apply(NoSuchFunctionException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 967));
            return (NoSuchFunctionException)this.intercept((Function0 & Serializable & scala.Serializable)() -> catalog.loadFunction(Identifier.of((String[])((String[])((Object[])new String[]{"ns1"})), (String)"func")), ClassTag$.MODULE$.apply(NoSuchFunctionException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 968));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 960));
    }
}

