/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.parser;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.ZoneId;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.FunctionIdentifier;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.AnalysisTest;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.analysis.MultiAlias;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedFunction;
import org.apache.spark.sql.catalyst.analysis.UnresolvedFunction$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedStar;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Add;
import org.apache.spark.sql.catalyst.expressions.Add$;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.And;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.CaseKeyWhen$;
import org.apache.spark.sql.catalyst.expressions.CaseWhen$;
import org.apache.spark.sql.catalyst.expressions.CreateStruct$;
import org.apache.spark.sql.catalyst.expressions.CurrentDate;
import org.apache.spark.sql.catalyst.expressions.CurrentDate$;
import org.apache.spark.sql.catalyst.expressions.CurrentRow$;
import org.apache.spark.sql.catalyst.expressions.CurrentTimestamp;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.Exists;
import org.apache.spark.sql.catalyst.expressions.Exists$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.FrameType;
import org.apache.spark.sql.catalyst.expressions.GreaterThan;
import org.apache.spark.sql.catalyst.expressions.InSubquery;
import org.apache.spark.sql.catalyst.expressions.LambdaFunction;
import org.apache.spark.sql.catalyst.expressions.LambdaFunction$;
import org.apache.spark.sql.catalyst.expressions.ListQuery;
import org.apache.spark.sql.catalyst.expressions.ListQuery$;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.Not;
import org.apache.spark.sql.catalyst.expressions.Or;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.expressions.RangeFrame$;
import org.apache.spark.sql.catalyst.expressions.RowFrame$;
import org.apache.spark.sql.catalyst.expressions.ScalarSubquery;
import org.apache.spark.sql.catalyst.expressions.ScalarSubquery$;
import org.apache.spark.sql.catalyst.expressions.SpecifiedWindowFrame;
import org.apache.spark.sql.catalyst.expressions.UnaryMinus;
import org.apache.spark.sql.catalyst.expressions.UnaryMinus$;
import org.apache.spark.sql.catalyst.expressions.UnboundedFollowing$;
import org.apache.spark.sql.catalyst.expressions.UnboundedPreceding$;
import org.apache.spark.sql.catalyst.expressions.UnresolvedNamedLambdaVariable;
import org.apache.spark.sql.catalyst.expressions.UnresolvedWindowExpression;
import org.apache.spark.sql.catalyst.expressions.UnspecifiedFrame$;
import org.apache.spark.sql.catalyst.expressions.WindowExpression;
import org.apache.spark.sql.catalyst.expressions.WindowFrame;
import org.apache.spark.sql.catalyst.expressions.WindowSpecDefinition;
import org.apache.spark.sql.catalyst.expressions.WindowSpecReference;
import org.apache.spark.sql.catalyst.expressions.aggregate.First;
import org.apache.spark.sql.catalyst.expressions.aggregate.Last;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.catalyst.parser.ExpressionParserSuite$;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.catalyst.parser.ParserInterface;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.catalyst.util.DateTimeTestUtils$;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.BigDecimal$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005ec\u0001\u0002\n\u0014\u0001\u0001BQa\u000b\u0001\u0005\u00021BQa\f\u0001\u0005\u0004ABq\u0001\u0013\u0001C\u0002\u0013\u0005\u0011\n\u0003\u0004N\u0001\u0001\u0006IA\u0013\u0005\u0006\u001d\u0002!\ta\u0014\u0005\bE\u0002\t\n\u0011\"\u0001d\u0011\u0015q\u0007\u0001\"\u0003p\u0011\u00151\b\u0001\"\u0001x\u0011\u001dy\b!%A\u0005\u0002\rDq!!\u0001\u0001\t\u0013\t\u0019\u0001C\u0005\u0002\u0016\u0001\u0011\r\u0011\"\u0001\u0002\u0018!A\u00111\u0007\u0001!\u0002\u0013\tI\u0002C\u0005\u00026\u0001\u0011\r\u0011\"\u0001\u0002\u0018!A\u0011q\u0007\u0001!\u0002\u0013\tI\u0002C\u0004\u0002:\u0001!\t!a\u000f\t\u000f\u0005%\u0003\u0001\"\u0001\u0002L!9\u0011\u0011\u000b\u0001\u0005\u0002\u0005M#!F#yaJ,7o]5p]B\u000b'o]3s'VLG/\u001a\u0006\u0003)U\ta\u0001]1sg\u0016\u0014(B\u0001\f\u0018\u0003!\u0019\u0017\r^1msN$(B\u0001\r\u001a\u0003\r\u0019\u0018\u000f\u001c\u0006\u00035m\tQa\u001d9be.T!\u0001H\u000f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0012aA8sO\u000e\u00011c\u0001\u0001\"KA\u0011!eI\u0007\u00023%\u0011A%\u0007\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0011\u0005\u0019JS\"A\u0014\u000b\u0005!*\u0012\u0001C1oC2L8/[:\n\u0005):#\u0001D!oC2L8/[:UKN$\u0018A\u0002\u001fj]&$h\bF\u0001.!\tq\u0003!D\u0001\u0014\u0003=\u0019HO]5oOR{W\u000b\u0016$9'R\u0014HCA\u0019:!\t\u0011t'D\u00014\u0015\t!T'A\u0003usB,7O\u0003\u000273\u00051QO\\:bM\u0016L!\u0001O\u001a\u0003\u0015U#f\tO*ue&tw\rC\u0003;\u0005\u0001\u00071(A\u0002tiJ\u0004\"\u0001P#\u000f\u0005u\u001a\u0005C\u0001 B\u001b\u0005y$B\u0001! \u0003\u0019a$o\\8u})\t!)A\u0003tG\u0006d\u0017-\u0003\u0002E\u0003\u00061\u0001K]3eK\u001aL!AR$\u0003\rM#(/\u001b8h\u0015\t!\u0015)A\u0007eK\u001a\fW\u000f\u001c;QCJ\u001cXM]\u000b\u0002\u0015:\u0011afS\u0005\u0003\u0019N\t\u0011cQ1uC2L8\u000f^*rYB\u000b'o]3s\u00039!WMZ1vYR\u0004\u0016M]:fe\u0002\n1\"Y:tKJ$X)];bYR!\u0001\u000b\u0016,_!\t\t&+D\u0001B\u0013\t\u0019\u0016I\u0001\u0003V]&$\b\"B+\u0006\u0001\u0004Y\u0014AC:rY\u000e{W.\\1oI\")q+\u0002a\u00011\u0006\tQ\r\u0005\u0002Z96\t!L\u0003\u0002\\+\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0013\ti&L\u0001\u0006FqB\u0014Xm]:j_:Dq\u0001F\u0003\u0011\u0002\u0003\u0007q\f\u0005\u0002/A&\u0011\u0011m\u0005\u0002\u0010!\u0006\u00148/\u001a:J]R,'OZ1dK\u0006)\u0012m]:feR,\u0015/^1mI\u0011,g-Y;mi\u0012\u001aT#\u00013+\u0005}+7&\u00014\u0011\u0005\u001ddW\"\u00015\u000b\u0005%T\u0017!C;oG\",7m[3e\u0015\tY\u0017)\u0001\u0006b]:|G/\u0019;j_:L!!\u001c5\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0005j]R,'oY3qiR\u0019\u0001\u000b]9\t\u000bU;\u0001\u0019A\u001e\t\u000bI<\u0001\u0019A:\u0002\u00115,7o]1hKN\u00042!\u0015;<\u0013\t)\u0018I\u0001\u0006=e\u0016\u0004X-\u0019;fIz\n!\"Y:tKJ$XI^1m)\u0011\u0001\u00060\u001f@\t\u000bUC\u0001\u0019A\u001e\t\u000biD\u0001\u0019A>\u0002\r\u0015D\b/Z2u!\t\tF0\u0003\u0002~\u0003\n\u0019\u0011I\\=\t\u000fQA\u0001\u0013!a\u0001?\u0006!\u0012m]:feR,e/\u00197%I\u00164\u0017-\u001e7uIM\n!\u0001\u001c<\u0015\t\u0005\u0015\u00111\u0002\t\u00043\u0006\u001d\u0011bAA\u00055\niRK\u001c:fg>dg/\u001a3OC6,G\rT1nE\u0012\fg+\u0019:jC\ndW\rC\u0004\u0002\u000e)\u0001\r!a\u0004\u0002\u0003M\u00042!UA\t\u0013\r\t\u0019\"\u0011\u0002\u0007'fl'm\u001c7\u0002\u001fel\u0017J\u001c;feZ\fG.\u00168jiN,\"!!\u0007\u0011\r\u0005m\u0011\u0011EA\u0013\u001b\t\tiBC\u0002\u0002 \u0005\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\u0019#!\b\u0003\u0007M+\u0017\u000f\u0005\u0003\u0002(\u0005ERBAA\u0015\u0015\u0011\tY#!\f\u0002\t1\fgn\u001a\u0006\u0003\u0003_\tAA[1wC&\u0019a)!\u000b\u0002!el\u0017J\u001c;feZ\fG.\u00168jiN\u0004\u0013a\u00043u\u0013:$XM\u001d<bYVs\u0017\u000e^:\u0002!\u0011$\u0018J\u001c;feZ\fG.\u00168jiN\u0004\u0013!E=n\u0013:$XM\u001d<bY2KG/\u001a:bYR1\u0011QHA\"\u0003\u000f\u00022!WA \u0013\r\t\tE\u0017\u0002\b\u0019&$XM]1m\u0011\u0019\t)e\u0004a\u0001w\u0005\tQ\u000f\u0003\u0004\u0002\u000e=\u0001\raO\u0001\u0012IRLe\u000e^3sm\u0006dG*\u001b;fe\u0006dGCBA\u001f\u0003\u001b\ny\u0005\u0003\u0004\u0002FA\u0001\ra\u000f\u0005\u0007\u0003\u001b\u0001\u0002\u0019A\u001e\u0002+1,w-Y2z\u0013:$XM\u001d<bY2KG/\u001a:bYR1\u0011QHA+\u0003/Ba!!\u0012\u0012\u0001\u0004Y\u0004BBA\u0007#\u0001\u00071\b")
public class ExpressionParserSuite
extends SparkFunSuite
implements AnalysisTest {
    private final CatalystSqlParser$ defaultParser;
    private final Seq<String> ymIntervalUnits;
    private final Seq<String> dtIntervalUnits;
    private String sparkHome;
    private volatile boolean bitmap$0;

    @Override
    public /* synthetic */ void org$apache$spark$sql$catalyst$analysis$AnalysisTest$$super$comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public Seq<Rule<LogicalPlan>> extendedAnalysisRules() {
        return AnalysisTest.extendedAnalysisRules$(this);
    }

    @Override
    public void createTempView(SessionCatalog catalog, String name, LogicalPlan plan, boolean overrideIfExists) {
        AnalysisTest.createTempView$(this, catalog, name, plan, overrideIfExists);
    }

    @Override
    public void createGlobalTempView(SessionCatalog catalog, String name, LogicalPlan plan, boolean overrideIfExists) {
        AnalysisTest.createGlobalTempView$(this, catalog, name, plan, overrideIfExists);
    }

    @Override
    public Analyzer getAnalyzer() {
        return AnalysisTest.getAnalyzer$(this);
    }

    @Override
    public void checkAnalysis(LogicalPlan inputPlan, LogicalPlan expectedPlan, boolean caseSensitive) {
        AnalysisTest.checkAnalysis$(this, inputPlan, expectedPlan, caseSensitive);
    }

    @Override
    public boolean checkAnalysis$default$3() {
        return AnalysisTest.checkAnalysis$default$3$(this);
    }

    @Override
    public void checkAnalysisWithoutViewWrapper(LogicalPlan inputPlan, LogicalPlan expectedPlan, boolean caseSensitive, boolean inlineCTE) {
        AnalysisTest.checkAnalysisWithoutViewWrapper$(this, inputPlan, expectedPlan, caseSensitive, inlineCTE);
    }

    @Override
    public boolean checkAnalysisWithoutViewWrapper$default$3() {
        return AnalysisTest.checkAnalysisWithoutViewWrapper$default$3$(this);
    }

    @Override
    public boolean checkAnalysisWithoutViewWrapper$default$4() {
        return AnalysisTest.checkAnalysisWithoutViewWrapper$default$4$(this);
    }

    @Override
    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        AnalysisTest.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public boolean comparePlans$default$3() {
        return AnalysisTest.comparePlans$default$3$(this);
    }

    @Override
    public void assertAnalysisSuccess(LogicalPlan inputPlan, boolean caseSensitive) {
        AnalysisTest.assertAnalysisSuccess$(this, inputPlan, caseSensitive);
    }

    @Override
    public boolean assertAnalysisSuccess$default$2() {
        return AnalysisTest.assertAnalysisSuccess$default$2$(this);
    }

    @Override
    public void assertAnalysisError(LogicalPlan inputPlan, Seq<String> expectedErrors, boolean caseSensitive) {
        AnalysisTest.assertAnalysisError$(this, inputPlan, expectedErrors, caseSensitive);
    }

    @Override
    public boolean assertAnalysisError$default$3() {
        return AnalysisTest.assertAnalysisError$default$3$(this);
    }

    @Override
    public void interceptParseException(Function1<String, Object> parser, String sqlCommand, Seq<String> messages) {
        AnalysisTest.interceptParseException$(this, parser, sqlCommand, messages);
    }

    @Override
    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$(this, plan);
    }

    @Override
    public LogicalPlan rewriteNameFromAttrNullability(LogicalPlan plan) {
        return PlanTestBase.rewriteNameFromAttrNullability$(this, plan);
    }

    @Override
    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$(this, plan);
    }

    @Override
    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$(this, e1, e2);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$(this, pairs, f);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression buildBalancedPredicate(Seq<Expression> expressions, Function2<Expression, Expression, Expression> op) {
        return PredicateHelper.buildBalancedPredicate$((PredicateHelper)this, expressions, op);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public boolean isNullIntolerant(Expression expr) {
        return PredicateHelper.isNullIntolerant$((PredicateHelper)this, (Expression)expr);
    }

    public Seq<Attribute> outputWithNullability(Seq<Attribute> output, Seq<ExprId> nonNullAttrExprIds) {
        return PredicateHelper.outputWithNullability$((PredicateHelper)this, output, nonNullAttrExprIds);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Seq<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    private String sparkHome$lzycompute() {
        ExpressionParserSuite expressionParserSuite = this;
        synchronized (expressionParserSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        return !this.bitmap$0 ? this.sparkHome$lzycompute() : this.sparkHome;
    }

    public UTF8String stringToUTF8Str(String str) {
        return UTF8String.fromString((String)str);
    }

    public CatalystSqlParser$ defaultParser() {
        return this.defaultParser;
    }

    public void assertEqual(String sqlCommand, Expression e, ParserInterface parser) {
        this.compareExpressions(parser.parseExpression(sqlCommand), e);
    }

    public ParserInterface assertEqual$default$3() {
        return this.defaultParser();
    }

    private void intercept(String sqlCommand, Seq<String> messages) {
        this.interceptParseException((Function1<String, Object>)(Function1 & Serializable & scala.Serializable)sqlText -> this.defaultParser().parseExpression(sqlText), sqlCommand, messages);
    }

    public void assertEval(String sqlCommand, Object expect, ParserInterface parser) {
        Expression qual$1 = parser.parseExpression(sqlCommand);
        InternalRow x$1 = qual$1.eval$default$1();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(qual$1.eval(x$1));
        Object $org_scalatest_assert_macro_right = expect;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
    }

    public ParserInterface assertEval$default$3() {
        return this.defaultParser();
    }

    private UnresolvedNamedLambdaVariable lv(Symbol s) {
        return new UnresolvedNamedLambdaVariable((Seq)new .colon.colon((Object)s.name(), (List)Nil$.MODULE$));
    }

    public Seq<String> ymIntervalUnits() {
        return this.ymIntervalUnits;
    }

    public Seq<String> dtIntervalUnits() {
        return this.dtIntervalUnits;
    }

    public Literal ymIntervalLiteral(String u, String s) {
        Period period;
        String string = u;
        if ("year".equals(string)) {
            period = Period.ofYears(Integer.parseInt(s));
        } else if ("month".equals(string)) {
            period = Period.ofMonths(Integer.parseInt(s));
        } else {
            throw new MatchError((Object)string);
        }
        Period period2 = period;
        return Literal$.MODULE$.create((Object)period2, (DataType)YearMonthIntervalType$.MODULE$.apply(BoxesRunTime.unboxToByte((Object)YearMonthIntervalType$.MODULE$.stringToField().apply((Object)u))));
    }

    public Literal dtIntervalLiteral(String u, String s) {
        Tuple2 tuple2;
        String string = u;
        String string2 = "second";
        long value = !(string != null ? !string.equals(string2) : string2 != null) ? scala.package$.MODULE$.BigDecimal().apply(s).$times(BigDecimal$.MODULE$.long2bigDecimal(1000000000L)).toLong() : Long.parseLong(s);
        String string3 = u;
        if ("week".equals(string3)) {
            tuple2 = new Tuple2((Object)Duration.ofDays(value * 7L), (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.DAY()));
        } else if ("day".equals(string3)) {
            tuple2 = new Tuple2((Object)Duration.ofDays(value), (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.DAY()));
        } else if ("hour".equals(string3)) {
            tuple2 = new Tuple2((Object)Duration.ofHours(value), (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.HOUR()));
        } else if ("minute".equals(string3)) {
            tuple2 = new Tuple2((Object)Duration.ofMinutes(value), (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.MINUTE()));
        } else if ("second".equals(string3)) {
            tuple2 = new Tuple2((Object)Duration.ofNanos(value), (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.SECOND()));
        } else if ("millisecond".equals(string3)) {
            tuple2 = new Tuple2((Object)Duration.ofMillis(value), (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.SECOND()));
        } else if ("microsecond".equals(string3)) {
            tuple2 = new Tuple2((Object)Duration.ofNanos(value * 1000L), (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.SECOND()));
        } else {
            throw new MatchError((Object)string3);
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        Duration duration = (Duration)tuple22._1();
        byte field = BoxesRunTime.unboxToByte((Object)tuple22._2());
        Tuple2 tuple23 = new Tuple2((Object)duration, (Object)BoxesRunTime.boxToByte((byte)field));
        Tuple2 tuple24 = tuple23;
        Duration duration2 = (Duration)tuple24._1();
        byte field2 = BoxesRunTime.unboxToByte((Object)tuple24._2());
        return Literal$.MODULE$.create((Object)duration2, (DataType)DayTimeIntervalType$.MODULE$.apply(field2));
    }

    public Literal legacyIntervalLiteral(String u, String s) {
        return Literal$.MODULE$.apply((Object)IntervalUtils$.MODULE$.stringToInterval(this.stringToUTF8Str(new StringBuilder(1).append(s).append(" ").append(u.toString()).toString())));
    }

    public static final /* synthetic */ String $anonfun$new$5(int x) {
        return new StringBuilder(4).append(x).append(" == ").append(x).toString();
    }

    private final void testVeryBinaryExpression$1(String op, Class clazz) {
        String sql = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 1000).map((Function1 & Serializable & scala.Serializable)x -> ExpressionParserSuite.$anonfun$new$5(BoxesRunTime.unboxToInt((Object)x)), IndexedSeq$.MODULE$.canBuildFrom())).mkString(op);
        Expression e = this.defaultParser().parseExpression(sql);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)e.collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = A1 instanceof EqualTo ? BoxesRunTime.boxToBoolean((boolean)true) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Expression x1) {
                Expression expression = x1;
                boolean bl = expression instanceof EqualTo;
                return bl;
            }
        }).size()));
        int $org_scalatest_assert_macro_right = 1000;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)e.collect((PartialFunction)new scala.Serializable(null, clazz){
            public static final long serialVersionUID = 0L;
            private final Class clazz$1;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                Object object = this.clazz$1.isInstance(A1) ? BoxesRunTime.boxToBoolean((boolean)true) : function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(Expression x2) {
                Expression expression = x2;
                boolean bl = this.clazz$1.isInstance(expression);
                return bl;
            }
            {
                this.clazz$1 = clazz$1;
            }
        }).size()));
        int $org_scalatest_assert_macro_right2 = 999;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
    }

    public static final /* synthetic */ void $anonfun$new$17(ExpressionParserSuite $this, String quantifier) {
        $this.assertEqual(new StringBuilder(22).append("a like ").append(quantifier).append(" ('foo%', 'b%')").toString(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).likeAny((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("foo%"), package.expressions$.MODULE$.stringToLiteral("b%")})), $this.assertEqual$default$3());
        $this.assertEqual(new StringBuilder(26).append("a not like ").append(quantifier).append(" ('foo%', 'b%')").toString(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).notLikeAny((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("foo%"), package.expressions$.MODULE$.stringToLiteral("b%")})), $this.assertEqual$default$3());
        $this.assertEqual(new StringBuilder(28).append("not (a like ").append(quantifier).append(" ('foo%', 'b%'))").toString(), (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).likeAny((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("foo%"), package.expressions$.MODULE$.stringToLiteral("b%")}))).unary_$bang(), $this.assertEqual$default$3());
    }

    private static final Expression windowed$1(Seq partitioning, Seq ordering, WindowFrame frame, UnresolvedFunction func$1) {
        return new WindowExpression((Expression)func$1, new WindowSpecDefinition(partitioning, ordering, frame));
    }

    private static final Seq windowed$default$1$1() {
        return (Seq)Nil$.MODULE$;
    }

    private static final Seq windowed$default$2$1() {
        return (Seq)Nil$.MODULE$;
    }

    private static final WindowFrame windowed$default$3$1() {
        return UnspecifiedFrame$.MODULE$;
    }

    private static final Expression windowed$2(Seq partitioning, Seq ordering, WindowFrame frame, UnresolvedFunction func$2) {
        return new WindowExpression((Expression)func$2, new WindowSpecDefinition(partitioning, ordering, frame));
    }

    private static final Seq windowed$default$1$2() {
        return (Seq)Nil$.MODULE$;
    }

    private static final Seq windowed$default$2$2() {
        return (Seq)Nil$.MODULE$;
    }

    private static final WindowFrame windowed$default$3$2() {
        return UnspecifiedFrame$.MODULE$;
    }

    public static final /* synthetic */ void $anonfun$new$29(ExpressionParserSuite $this, String frameTypeSql$1, Product frameType$1, UnresolvedFunction func$2, Tuple3 x0$2) {
        Tuple3 tuple3 = x0$2;
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        String boundarySql = (String)tuple3._1();
        Expression begin = (Expression)tuple3._2();
        Expression end = (Expression)tuple3._3();
        String query = new StringBuilder(41).append("foo(*) over (partition by a order by b ").append(frameTypeSql$1).append(" ").append(boundarySql).append(")").toString();
        Expression expr = ExpressionParserSuite.windowed$2((Seq)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).asc(), (List)Nil$.MODULE$), (WindowFrame)new SpecifiedWindowFrame((FrameType)frameType$1, begin, end), func$2);
        $this.assertEqual(query, expr, $this.assertEqual$default$3());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$28(ExpressionParserSuite $this, Seq boundaries$1, UnresolvedFunction func$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String frameTypeSql = (String)tuple2._1();
        Product frameType = (Product)tuple2._2();
        boundaries$1.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            ExpressionParserSuite.$anonfun$new$29($this, frameTypeSql, frameType, func$2, x0$2);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final void checkTimestampNTZAndLTZ$1() {
        this.assertEqual("tImEstAmp_LTZ '2016-03-11 20:54:00.000'", (Expression)Literal$.MODULE$.apply((Object)Timestamp.valueOf("2016-03-11 20:54:00.000")), this.assertEqual$default$3());
        this.intercept("timestamP_LTZ '2016-33-11 20:54:00.000'", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot parse the TIMESTAMP_LTZ value"}));
        this.assertEqual("tImEstAmp_Ntz '2016-03-11 20:54:00.000'", (Expression)Literal$.MODULE$.apply((Object)LocalDateTime.parse("2016-03-11T20:54:00.000")), this.assertEqual$default$3());
        this.intercept("tImEstAmp_Ntz '2016-33-11 20:54:00.000'", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot parse the TIMESTAMP_NTZ value"}));
    }

    public static final /* synthetic */ byte $anonfun$new$40(int x$1) {
        return (byte)x$1;
    }

    public static final /* synthetic */ byte $anonfun$new$41(int x$2) {
        return (byte)x$2;
    }

    private final void testDecimal$1(String value) {
        this.assertEqual(value, (Expression)Literal$.MODULE$.apply((Object)scala.package$.MODULE$.BigDecimal().apply(value).underlying()), this.assertEqual$default$3());
    }

    private final void testDecimal$2(String value, ParserInterface parser) {
        this.assertEqual(value, (Expression)Literal$.MODULE$.apply((Object)scala.package$.MODULE$.BigDecimal().apply(value).underlying()), parser);
    }

    public static final /* synthetic */ void $anonfun$new$51(ExpressionParserSuite $this, String intervalValue$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String sign = (String)tuple2._1();
        Expression expectedLiteral = (Expression)tuple2._2();
        $this.assertEqual(new StringBuilder(9).append(sign).append("interval ").append(intervalValue$1).toString(), expectedLiteral, $this.assertEqual$default$3());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final void checkIntervals$1(String intervalValue, Literal expected) {
        ((IterableLike)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)""), (Object)expected), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"-"), (Object)new UnaryMinus((Expression)expected, UnaryMinus$.MODULE$.apply$default$2())), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ExpressionParserSuite.$anonfun$new$51(this, intervalValue, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$54(ExpressionParserSuite $this, String unit$1, String form$1, String value) {
        Literal expected = $this.ymIntervalLiteral(unit$1, value);
        $this.checkIntervals$1(new StringBuilder(1).append(value).append(" ").append(unit$1).append(form$1).toString(), expected);
        $this.checkIntervals$1(new StringBuilder(3).append("'").append(value).append("' ").append(unit$1).append(form$1).toString(), expected);
    }

    public static final /* synthetic */ void $anonfun$new$57(ExpressionParserSuite $this, String unit$2, String form$2, String value) {
        Literal expected = $this.dtIntervalLiteral(unit$2, value);
        $this.checkIntervals$1(new StringBuilder(1).append(value).append(" ").append(unit$2).append(form$2).toString(), expected);
        $this.checkIntervals$1(new StringBuilder(3).append("'").append(value).append("' ").append(unit$2).append(form$2).toString(), expected);
    }

    public static final /* synthetic */ void $anonfun$new$61(ExpressionParserSuite $this, String unit$3, String form$3, String value) {
        Literal expected = $this.legacyIntervalLiteral(unit$3, value);
        $this.checkIntervals$1(new StringBuilder(1).append(value).append(" ").append(unit$3).append(form$3).toString(), expected);
        $this.checkIntervals$1(new StringBuilder(3).append("'").append(value).append("' ").append(unit$3).append(form$3).toString(), expected);
    }

    public static final /* synthetic */ void $anonfun$new$63(ExpressionParserSuite $this, String value) {
        Literal result = Literal$.MODULE$.apply((Object)IntervalUtils$.MODULE$.fromYearMonthString(value));
        $this.checkIntervals$1(new StringBuilder(16).append("'").append(value).append("' year to month").toString(), result);
    }

    public static final /* synthetic */ void $anonfun$new$64(ExpressionParserSuite $this, String value) {
        Literal result = Literal$.MODULE$.apply((Object)IntervalUtils$.MODULE$.fromDayTimeString(value));
        $this.checkIntervals$1(new StringBuilder(16).append("'").append(value).append("' day to second").toString(), result);
    }

    public static final /* synthetic */ void $anonfun$new$65(ExpressionParserSuite $this, String value) {
        Literal result = Literal$.MODULE$.apply((Object)IntervalUtils$.MODULE$.fromDayTimeString(value, DayTimeIntervalType$.MODULE$.HOUR(), DayTimeIntervalType$.MODULE$.SECOND()));
        $this.checkIntervals$1(new StringBuilder(17).append("'").append(value).append("' hour to second").toString(), result);
    }

    private static final long toMicros$1(LocalDateTime time, ZoneId zid$1) {
        long seconds = time.atZone(zid$1).toInstant().getEpochSecond();
        return TimeUnit.SECONDS.toMicros(seconds);
    }

    public ExpressionParserSuite() {
        AliasHelper.$init$((AliasHelper)this);
        PredicateHelper.$init$((PredicateHelper)this);
        SQLHelper.$init$(this);
        SQLConfHelper.$init$((SQLConfHelper)this);
        PlanTestBase.$init$(this);
        AnalysisTest.$init$(this);
        this.defaultParser = CatalystSqlParser$.MODULE$;
        this.test("star expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("*", (Expression)new UnresolvedStar((Option)None$.MODULE$), this.assertEqual$default$3());
            this.assertEqual("a.b.*", (Expression)new UnresolvedStar(Option$.MODULE$.apply((Object)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)Nil$.MODULE$)))), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
        this.test("named expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            CallSite r0 = SymbolLiteral.bootstrap("apply", "a");
            this.assertEqual("a", (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)r0), this.assertEqual$default$3());
            NamedExpression r1 = package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).as("b");
            this.assertEqual("a as b", (Expression)r1, this.assertEqual$default$3());
            this.assertEqual("a b", (Expression)r1, this.assertEqual$default$3());
            this.assertEqual("a as (b, c)", (Expression)new MultiAlias((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Seq)new .colon.colon((Object)"b", (List)new .colon.colon((Object)"c", (List)Nil$.MODULE$))), this.assertEqual$default$3());
            this.assertEqual("a() (b, c)", (Expression)new MultiAlias((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).function((Seq)Nil$.MODULE$), (Seq)new .colon.colon((Object)"b", (List)new .colon.colon((Object)"c", (List)Nil$.MODULE$))), this.assertEqual$default$3());
            this.assertEqual("1SL", (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "1SL")), this.assertEqual$default$3());
            this.assertEqual("a.* b", (Expression)package.expressions$.MODULE$.DslExpression((Expression)new UnresolvedStar(Option$.MODULE$.apply((Object)new .colon.colon((Object)"a", (List)Nil$.MODULE$)))).as((Symbol)SymbolLiteral.bootstrap("apply", "b")), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
        this.test("binary logical expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("a and b", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$amp$amp((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a or b", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$bar$bar((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a and b or c and d", (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$amp$amp((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")))).$bar$bar((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).$amp$amp((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "d")))), this.assertEqual$default$3());
            this.assertEqual("a or b or c and d", (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$bar$bar((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")))).$bar$bar((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).$amp$amp((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "d")))), this.assertEqual$default$3());
            this.assertEqual("a or b or c or d or e or f", (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$bar$bar((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")))).$bar$bar((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c")))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "d")).$bar$bar((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "e")))).$bar$bar((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "f")))), this.assertEqual$default$3());
            this.assertEqual("a and b and c and d and e and f", (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$amp$amp((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")))).$amp$amp((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c")))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "d")).$amp$amp((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "e")))).$amp$amp((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "f")))), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
        this.test("long binary logical expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.testVeryBinaryExpression$1(" AND ", And.class);
            this.testVeryBinaryExpression$1(" OR ", Or.class);
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
        this.test("not expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("not a", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).unary_$bang(), this.assertEqual$default$3());
            this.assertEqual("!a", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).unary_$bang(), this.assertEqual$default$3());
            this.assertEqual("not true > true", (Expression)new Not((Expression)new GreaterThan((Expression)package.expressions$.MODULE$.booleanToLiteral(true), (Expression)package.expressions$.MODULE$.booleanToLiteral(true))), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
        this.test("exists expression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.assertEqual("exists (select 1 from b where b.x = a.x)", (Expression)new Exists(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b.x")).$eq$eq$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a.x"))))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.intToLiteral(1)})), Exists$.MODULE$.apply$default$2(), Exists$.MODULE$.apply$default$3(), Exists$.MODULE$.apply$default$4()), this.assertEqual$default$3()), new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
        this.test("comparison expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("a = b", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a == b", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a <=> b", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$less$eq$greater((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a <> b", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$bang$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a != b", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$bang$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a < b", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$less((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a <= b", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$less$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a !> b", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$less$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a > b", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a >= b", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a !< b", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
        this.test("between expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("a between b and c", (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")))).$amp$amp((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$less$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c")))), this.assertEqual$default$3());
            this.assertEqual("a not between b and c", (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")))).$amp$amp((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$less$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c"))))).unary_$bang(), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
        this.test("in expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("a in (b, c, d)", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).in((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "d"))})), this.assertEqual$default$3());
            this.assertEqual("a not in (b, c, d)", (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).in((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "d"))}))).unary_$bang(), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
        this.test("in sub-query", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("a in (select b from c)", (Expression)new InSubquery((Seq)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (List)Nil$.MODULE$), new ListQuery(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))})), ListQuery$.MODULE$.apply$default$2(), ListQuery$.MODULE$.apply$default$3(), ListQuery$.MODULE$.apply$default$4(), ListQuery$.MODULE$.apply$default$5())), this.assertEqual$default$3());
            this.assertEqual("(a, b, c) in (select d, e, f from g)", (Expression)new InSubquery((Seq)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (List)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), (List)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c")), (List)Nil$.MODULE$))), new ListQuery(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"g"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "d")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "e")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "f"))})), ListQuery$.MODULE$.apply$default$2(), ListQuery$.MODULE$.apply$default$3(), ListQuery$.MODULE$.apply$default$4(), ListQuery$.MODULE$.apply$default$5())), this.assertEqual$default$3());
            this.assertEqual("(a, b) in (select c from d)", (Expression)new InSubquery((Seq)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (List)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), (List)Nil$.MODULE$)), new ListQuery(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c"))})), ListQuery$.MODULE$.apply$default$2(), ListQuery$.MODULE$.apply$default$3(), ListQuery$.MODULE$.apply$default$4(), ListQuery$.MODULE$.apply$default$5())), this.assertEqual$default$3());
            this.assertEqual("(a) in (select b from c)", (Expression)new InSubquery((Seq)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (List)Nil$.MODULE$), new ListQuery(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))})), ListQuery$.MODULE$.apply$default$2(), ListQuery$.MODULE$.apply$default$3(), ListQuery$.MODULE$.apply$default$4(), ListQuery$.MODULE$.apply$default$5())), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165));
        this.test("like expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            package.ExpressionConversions.DslSymbol qual$1 = package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a"));
            Literal x$1 = package.expressions$.MODULE$.stringToLiteral("pattern%");
            char x$2 = qual$1.like$default$2();
            this.assertEqual("a like 'pattern%'", qual$1.like((Expression)x$1, x$2), this.assertEqual$default$3());
            package.ExpressionConversions.DslSymbol qual$2 = package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a"));
            Literal x$3 = package.expressions$.MODULE$.stringToLiteral("pattern%");
            char x$4 = qual$2.like$default$2();
            this.assertEqual("a not like 'pattern%'", (Expression)package.expressions$.MODULE$.DslExpression(qual$2.like((Expression)x$3, x$4)).unary_$bang(), this.assertEqual$default$3());
            this.assertEqual("a rlike 'pattern%'", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).rlike((Expression)package.expressions$.MODULE$.stringToLiteral("pattern%")), this.assertEqual$default$3());
            this.assertEqual("a not rlike 'pattern%'", (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).rlike((Expression)package.expressions$.MODULE$.stringToLiteral("pattern%"))).unary_$bang(), this.assertEqual$default$3());
            this.assertEqual("a regexp 'pattern%'", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).rlike((Expression)package.expressions$.MODULE$.stringToLiteral("pattern%")), this.assertEqual$default$3());
            this.assertEqual("a not regexp 'pattern%'", (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).rlike((Expression)package.expressions$.MODULE$.stringToLiteral("pattern%"))).unary_$bang(), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
        this.test("like escape expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String message = "Escape string must contain only one character.";
            this.assertEqual("a like 'pattern%' escape '#'", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).like((Expression)package.expressions$.MODULE$.stringToLiteral("pattern%"), '#'), this.assertEqual$default$3());
            this.assertEqual("a like 'pattern%' escape '\"'", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).like((Expression)package.expressions$.MODULE$.stringToLiteral("pattern%"), '\"'), this.assertEqual$default$3());
            this.intercept("a like 'pattern%' escape '##'", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{message}));
            this.intercept("a like 'pattern%' escape ''", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{message}));
            this.assertEqual("a not like 'pattern%' escape '#'", (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).like((Expression)package.expressions$.MODULE$.stringToLiteral("pattern%"), '#')).unary_$bang(), this.assertEqual$default$3());
            this.assertEqual("a not like 'pattern%' escape '\"'", (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).like((Expression)package.expressions$.MODULE$.stringToLiteral("pattern%"), '\"')).unary_$bang(), this.assertEqual$default$3());
            this.intercept("a not like 'pattern%' escape '\"/'", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{message}));
            this.intercept("a not like 'pattern%' escape ''", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{message}));
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
        this.test("like expressions with ESCAPED_STRING_LITERALS = true", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ESCAPED_STRING_LITERALS().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            CatalystSqlParser parser = new CatalystSqlParser();
            this.assertEqual("a rlike '^\\x20[\\x20-\\x23]+$'", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).rlike((Expression)package.expressions$.MODULE$.stringToLiteral("^\\x20[\\x20-\\x23]+$")), (ParserInterface)parser);
            this.assertEqual("a rlike 'pattern\\\\'", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).rlike((Expression)package.expressions$.MODULE$.stringToLiteral("pattern\\\\")), (ParserInterface)parser);
            this.assertEqual("a rlike 'pattern\\t\\n'", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).rlike((Expression)package.expressions$.MODULE$.stringToLiteral("pattern\\t\\n")), (ParserInterface)parser);
        }), new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 204));
        this.test("(NOT) LIKE (ANY | SOME | ALL) expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ((IterableLike)new .colon.colon((Object)"any", (List)new .colon.colon((Object)"some", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)quantifier -> {
                ExpressionParserSuite.$anonfun$new$17(this, quantifier);
                return BoxedUnit.UNIT;
            });
            this.assertEqual("a like all ('foo%', 'b%')", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).likeAll((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("foo%"), package.expressions$.MODULE$.stringToLiteral("b%")})), this.assertEqual$default$3());
            this.assertEqual("a not like all ('foo%', 'b%')", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).notLikeAll((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("foo%"), package.expressions$.MODULE$.stringToLiteral("b%")})), this.assertEqual$default$3());
            this.assertEqual("not (a like all ('foo%', 'b%'))", (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).likeAll((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("foo%"), package.expressions$.MODULE$.stringToLiteral("b%")}))).unary_$bang(), this.assertEqual$default$3());
            ((IterableLike)new .colon.colon((Object)"any", (List)new .colon.colon((Object)"some", (List)new .colon.colon((Object)"all", (List)Nil$.MODULE$)))).foreach((Function1 & Serializable & scala.Serializable)quantifier -> {
                this.intercept(new StringBuilder(9).append("a like ").append(quantifier).append("()").toString(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected something between '(' and ')'"}));
                return BoxedUnit.UNIT;
            });
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 213));
        this.test("is null expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("a is null", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).isNull(), this.assertEqual$default$3());
            this.assertEqual("a is not null", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).isNotNull(), this.assertEqual$default$3());
            this.assertEqual("a = b is null", (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")))).isNull(), this.assertEqual$default$3());
            this.assertEqual("a = b is not null", (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")))).isNotNull(), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 228));
        this.test("is distinct expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("a is distinct from b", (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$less$eq$greater((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")))).unary_$bang(), this.assertEqual$default$3());
            this.assertEqual("a is not distinct from b", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$less$eq$greater((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235));
        this.test("binary arithmetic expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("a * b", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$times((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a / b", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$div((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a DIV b", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).div((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a % b", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$percent((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a + b", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$plus((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a - b", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$minus((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a & b", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$amp((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a ^ b", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$up((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a | b", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$bar((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a * t | b ^ c & d - e + f % g DIV h / i * k", package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$times((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "t")))).$bar(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).$up(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).$amp(package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "d")).$minus((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "e")))).$plus(package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "f")).$percent((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "g")))).div((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "h")))).$div((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "i")))).$times((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "k"))))))), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 240));
        this.test("unary arithmetic expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("+a", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).unary_$plus(), this.assertEqual$default$3());
            this.assertEqual("-a", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).unary_$minus(), this.assertEqual$default$3());
            this.assertEqual("~a", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).unary_$tilde(), this.assertEqual$default$3());
            this.assertEqual("-+~~a", package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).unary_$tilde()).unary_$tilde()).unary_$plus()).unary_$minus(), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 258));
        this.test("cast expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("cast(a as int)", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).cast((DataType)IntegerType$.MODULE$), this.assertEqual$default$3());
            this.assertEqual("cast(a as timestamp)", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).cast((DataType)TimestampType$.MODULE$), this.assertEqual$default$3());
            this.assertEqual("cast(a as array<int>)", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).cast((DataType)ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$)), this.assertEqual$default$3());
            this.assertEqual("cast(cast(a as int) as long)", package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).cast((DataType)IntegerType$.MODULE$)).cast((DataType)LongType$.MODULE$), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 265));
        this.test("function expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("foo()", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "foo")).function((Seq)Nil$.MODULE$), this.assertEqual$default$3());
            this.assertEqual("foo.bar()", (Expression)UnresolvedFunction$.MODULE$.apply(new FunctionIdentifier("bar", (Option)new Some((Object)"foo")), (Seq)Nil$.MODULE$, false), this.assertEqual$default$3());
            this.assertEqual("foo(*)", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "foo")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})), this.assertEqual$default$3());
            this.assertEqual("count(*)", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "count")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.intToLiteral(1)})), this.assertEqual$default$3());
            this.assertEqual("foo(a, b)", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "foo")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))})), this.assertEqual$default$3());
            this.assertEqual("foo(all a, b)", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "foo")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))})), this.assertEqual$default$3());
            this.assertEqual("foo(distinct a, b)", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "foo")).distinctFunction((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))})), this.assertEqual$default$3());
            this.assertEqual("grouping(distinct a, b)", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "grouping")).distinctFunction((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))})), this.assertEqual$default$3());
            this.assertEqual("`select`(all a, b)", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "select")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))})), this.assertEqual$default$3());
            this.intercept("foo(a x)", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"extraneous input 'x'"}));
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 273));
        this.test("lambda functions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("x -> x + 1", (Expression)new LambdaFunction(package.expressions$.MODULE$.DslExpression((Expression)this.lv((Symbol)SymbolLiteral.bootstrap("apply", "x"))).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1)), (Seq)new .colon.colon((Object)this.lv((Symbol)SymbolLiteral.bootstrap("apply", "x")), (List)Nil$.MODULE$), LambdaFunction$.MODULE$.apply$default$3()), this.assertEqual$default$3());
            this.assertEqual("(x, y) -> x + y", (Expression)new LambdaFunction(package.expressions$.MODULE$.DslExpression((Expression)this.lv((Symbol)SymbolLiteral.bootstrap("apply", "x"))).$plus((Expression)this.lv((Symbol)SymbolLiteral.bootstrap("apply", "y"))), (Seq)new .colon.colon((Object)this.lv((Symbol)SymbolLiteral.bootstrap("apply", "x")), (List)new .colon.colon((Object)this.lv((Symbol)SymbolLiteral.bootstrap("apply", "y")), (List)Nil$.MODULE$)), LambdaFunction$.MODULE$.apply$default$3()), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 289));
        this.test("window function expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            UnresolvedFunction func = package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "foo")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            this.assertEqual("foo(*) over w1", (Expression)new UnresolvedWindowExpression((Expression)func, new WindowSpecReference("w1")), this.assertEqual$default$3());
            this.assertEqual("foo(*) over ()", ExpressionParserSuite.windowed$1(ExpressionParserSuite.windowed$default$1$1(), ExpressionParserSuite.windowed$default$2$1(), ExpressionParserSuite.windowed$default$3$1(), func), this.assertEqual$default$3());
            this.assertEqual("foo(*) over (partition by a, b)", ExpressionParserSuite.windowed$1((Seq)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (List)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), (List)Nil$.MODULE$)), ExpressionParserSuite.windowed$default$2$1(), ExpressionParserSuite.windowed$default$3$1(), func), this.assertEqual$default$3());
            this.assertEqual("foo(*) over (distribute by a, b)", ExpressionParserSuite.windowed$1((Seq)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (List)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), (List)Nil$.MODULE$)), ExpressionParserSuite.windowed$default$2$1(), ExpressionParserSuite.windowed$default$3$1(), func), this.assertEqual$default$3());
            this.assertEqual("foo(*) over (cluster by a, b)", ExpressionParserSuite.windowed$1((Seq)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (List)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), (List)Nil$.MODULE$)), ExpressionParserSuite.windowed$default$2$1(), ExpressionParserSuite.windowed$default$3$1(), func), this.assertEqual$default$3());
            this.assertEqual("foo(*) over (order by a desc, b asc)", ExpressionParserSuite.windowed$1((Seq)Nil$.MODULE$, (Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).desc(), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).asc(), (List)Nil$.MODULE$)), ExpressionParserSuite.windowed$default$3$1(), func), this.assertEqual$default$3());
            this.assertEqual("foo(*) over (sort by a desc, b asc)", ExpressionParserSuite.windowed$1((Seq)Nil$.MODULE$, (Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).desc(), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).asc(), (List)Nil$.MODULE$)), ExpressionParserSuite.windowed$default$3$1(), func), this.assertEqual$default$3());
            this.assertEqual("foo(*) over (partition by a, b order by c)", ExpressionParserSuite.windowed$1((Seq)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (List)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), (List)Nil$.MODULE$)), (Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).asc(), (List)Nil$.MODULE$), ExpressionParserSuite.windowed$default$3$1(), func), this.assertEqual$default$3());
            this.assertEqual("foo(*) over (distribute by a, b sort by c)", ExpressionParserSuite.windowed$1((Seq)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (List)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), (List)Nil$.MODULE$)), (Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).asc(), (List)Nil$.MODULE$), ExpressionParserSuite.windowed$default$3$1(), func), this.assertEqual$default$3());
            this.assertEqual("sum(product + 1) over (partition by ((product) + (1)) order by 2)", (Expression)new WindowExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "sum")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "product")).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1))})), new WindowSpecDefinition((Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "product")).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1)), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2))).asc(), (List)Nil$.MODULE$), (WindowFrame)UnspecifiedFrame$.MODULE$)), this.assertEqual$default$3());
            this.assertEqual("sum(product + 1) over (partition by ((product / 2) + 1) order by 2)", (Expression)new WindowExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "sum")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "product")).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1))})), new WindowSpecDefinition((Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "product")).$div((Expression)package.expressions$.MODULE$.intToLiteral(2))).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1)), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2))).asc(), (List)Nil$.MODULE$), (WindowFrame)UnspecifiedFrame$.MODULE$)), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 294));
        this.test("range/rows window function expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            UnresolvedFunction func = package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "foo")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            Seq frameTypes = (Seq)new .colon.colon((Object)new Tuple2((Object)"rows", (Object)RowFrame$.MODULE$), (List)new .colon.colon((Object)new Tuple2((Object)"range", (Object)RangeFrame$.MODULE$), (List)Nil$.MODULE$));
            Seq boundaries = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"unbounded preceding", (Object)UnboundedPreceding$.MODULE$, (Object)CurrentRow$.MODULE$), new Tuple3((Object)"2147483648 preceding", (Object)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)0x80000000L))).unary_$minus(), (Object)CurrentRow$.MODULE$), new Tuple3((Object)"10 preceding", (Object)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10))).unary_$minus(), (Object)CurrentRow$.MODULE$), new Tuple3((Object)"3 + 1 preceding", (Object)package.expressions$.MODULE$.DslExpression((Expression)new Add((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), Add$.MODULE$.apply$default$3())).unary_$minus(), (Object)CurrentRow$.MODULE$), new Tuple3((Object)"0 preceding", (Object)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0))).unary_$minus(), (Object)CurrentRow$.MODULE$), new Tuple3((Object)"current row", (Object)CurrentRow$.MODULE$, (Object)CurrentRow$.MODULE$), new Tuple3((Object)"0 following", (Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0)), (Object)CurrentRow$.MODULE$), new Tuple3((Object)"3 + 1 following", (Object)new Add((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), Add$.MODULE$.apply$default$3()), (Object)CurrentRow$.MODULE$), new Tuple3((Object)"10 following", (Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10)), (Object)CurrentRow$.MODULE$), new Tuple3((Object)"2147483649 following", (Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)0x80000001L)), (Object)CurrentRow$.MODULE$), new Tuple3((Object)"unbounded following", (Object)UnboundedFollowing$.MODULE$, (Object)CurrentRow$.MODULE$), new Tuple3((Object)"between unbounded preceding and 5 following", (Object)UnboundedPreceding$.MODULE$, (Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)5))), new Tuple3((Object)"between unbounded preceding and 3 + 1 following", (Object)UnboundedPreceding$.MODULE$, (Object)new Add((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), Add$.MODULE$.apply$default$3())), new Tuple3((Object)"between unbounded preceding and 2147483649 following", (Object)UnboundedPreceding$.MODULE$, (Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)0x80000001L))), new Tuple3((Object)"between unbounded preceding and current row", (Object)UnboundedPreceding$.MODULE$, (Object)CurrentRow$.MODULE$), new Tuple3((Object)"between 2147483648 preceding and current row", (Object)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)0x80000000L))).unary_$minus(), (Object)CurrentRow$.MODULE$), new Tuple3((Object)"between 10 preceding and current row", (Object)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10))).unary_$minus(), (Object)CurrentRow$.MODULE$), new Tuple3((Object)"between 3 + 1 preceding and current row", (Object)package.expressions$.MODULE$.DslExpression((Expression)new Add((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), Add$.MODULE$.apply$default$3())).unary_$minus(), (Object)CurrentRow$.MODULE$), new Tuple3((Object)"between 0 preceding and current row", (Object)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0))).unary_$minus(), (Object)CurrentRow$.MODULE$), new Tuple3((Object)"between current row and current row", (Object)CurrentRow$.MODULE$, (Object)CurrentRow$.MODULE$), new Tuple3((Object)"between current row and 0 following", (Object)CurrentRow$.MODULE$, (Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0))), new Tuple3((Object)"between current row and 5 following", (Object)CurrentRow$.MODULE$, (Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)5))), new Tuple3((Object)"between current row and 3 + 1 following", (Object)CurrentRow$.MODULE$, (Object)new Add((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), Add$.MODULE$.apply$default$3())), new Tuple3((Object)"between current row and 2147483649 following", (Object)CurrentRow$.MODULE$, (Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)0x80000001L))), new Tuple3((Object)"between current row and unbounded following", (Object)CurrentRow$.MODULE$, (Object)UnboundedFollowing$.MODULE$), new Tuple3((Object)"between 2147483648 preceding and unbounded following", (Object)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)0x80000000L))).unary_$minus(), (Object)UnboundedFollowing$.MODULE$), new Tuple3((Object)"between 10 preceding and unbounded following", (Object)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10))).unary_$minus(), (Object)UnboundedFollowing$.MODULE$), new Tuple3((Object)"between 3 + 1 preceding and unbounded following", (Object)package.expressions$.MODULE$.DslExpression((Expression)new Add((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), Add$.MODULE$.apply$default$3())).unary_$minus(), (Object)UnboundedFollowing$.MODULE$), new Tuple3((Object)"between 0 preceding and unbounded following", (Object)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0))).unary_$minus(), (Object)UnboundedFollowing$.MODULE$), new Tuple3((Object)"between 10 preceding and 5 following", (Object)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10))).unary_$minus(), (Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)5))), new Tuple3((Object)"between unbounded preceding and unbounded following", (Object)UnboundedPreceding$.MODULE$, (Object)UnboundedFollowing$.MODULE$)}));
            frameTypes.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                ExpressionParserSuite.$anonfun$new$28(this, boundaries, func, x0$1);
                return BoxedUnit.UNIT;
            });
            this.intercept("foo(*) over (partition by a order by b rows exp(b) preceding)", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Frame bound value must be a literal."}));
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 325));
        this.test("row constructor", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("(a, b)", (Expression)CreateStruct$.MODULE$.apply((Seq)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (List)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), (List)Nil$.MODULE$))), this.assertEqual$default$3());
            this.assertEqual("(a, b, c)", (Expression)CreateStruct$.MODULE$.apply((Seq)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (List)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), (List)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c")), (List)Nil$.MODULE$)))), this.assertEqual$default$3());
            this.assertEqual("(a as b, b as c)", (Expression)CreateStruct$.MODULE$.apply((Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).as((Symbol)SymbolLiteral.bootstrap("apply", "b")), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).as((Symbol)SymbolLiteral.bootstrap("apply", "c")), (List)Nil$.MODULE$))), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 395));
        this.test("scalar sub-query", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("(select max(val) from tbl) > current", (Expression)package.expressions$.MODULE$.DslExpression((Expression)new ScalarSubquery(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "max")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "val"))}))})), ScalarSubquery$.MODULE$.apply$default$2(), ScalarSubquery$.MODULE$.apply$default$3(), ScalarSubquery$.MODULE$.apply$default$4())).$greater((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "current"))), this.assertEqual$default$3());
            this.assertEqual("a = (select b from s)", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq((Expression)new ScalarSubquery(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"s"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))})), ScalarSubquery$.MODULE$.apply$default$2(), ScalarSubquery$.MODULE$.apply$default$3(), ScalarSubquery$.MODULE$.apply$default$4())), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 402));
        this.test("case when", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("case a when 1 then b when 2 then c else d end", (Expression)CaseKeyWhen$.MODULE$.apply((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Seq)new .colon.colon((Object)package.expressions$.MODULE$.intToLiteral(1), (List)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), (List)new .colon.colon((Object)package.expressions$.MODULE$.intToLiteral(2), (List)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c")), (List)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "d")), (List)Nil$.MODULE$)))))), this.assertEqual$default$3());
            this.assertEqual("case (a or b) when true then c when false then d else e end", (Expression)CaseKeyWhen$.MODULE$.apply((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$bar$bar((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), (Seq)new .colon.colon((Object)package.expressions$.MODULE$.booleanToLiteral(true), (List)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c")), (List)new .colon.colon((Object)package.expressions$.MODULE$.booleanToLiteral(false), (List)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "d")), (List)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "e")), (List)Nil$.MODULE$)))))), this.assertEqual$default$3());
            this.assertEqual("case 'a'='a' when true then 1 end", (Expression)CaseKeyWhen$.MODULE$.apply((Expression)package.expressions$.MODULE$.DslString("a").$eq$eq$eq((Expression)package.expressions$.MODULE$.stringToLiteral("a")), (Seq)new .colon.colon((Object)package.expressions$.MODULE$.booleanToLiteral(true), (List)new .colon.colon((Object)package.expressions$.MODULE$.intToLiteral(1), (List)Nil$.MODULE$))), this.assertEqual$default$3());
            this.assertEqual("case when a = 1 then b when a = 2 then c else d end", (Expression)CaseWhen$.MODULE$.apply((Seq)new .colon.colon((Object)new Tuple2((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)), (Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).expr()), (List)new .colon.colon((Object)new Tuple2((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)), (Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).expr()), (List)Nil$.MODULE$)), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "d"))), this.assertEqual$default$3());
            this.assertEqual("case when (1) + case when a > b then c else d end then f else g end", (Expression)CaseWhen$.MODULE$.apply((Seq)new .colon.colon((Object)new Tuple2((Object)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))).$plus((Expression)CaseWhen$.MODULE$.apply((Seq)new .colon.colon((Object)new Tuple2((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), (Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).expr()), (List)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "d")).expr())), (Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "f")).expr()), (List)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "g"))), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 411));
        this.test("dereference", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("a.b", (Expression)UnresolvedAttribute$.MODULE$.apply("a.b"), this.assertEqual$default$3());
            this.assertEqual("`select`.b", (Expression)UnresolvedAttribute$.MODULE$.apply("select.b"), this.assertEqual$default$3());
            this.assertEqual("(a + b).b", (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$plus((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")))).getField("b"), this.assertEqual$default$3());
            this.assertEqual("struct(a, b).b", (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.namedStruct((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{Literal$.MODULE$.apply((Object)"a"), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), Literal$.MODULE$.apply((Object)"b"), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}))).getField("b"), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 424));
        this.test("reference", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("a", (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), this.assertEqual$default$3());
            this.assertEqual("1a", (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "1a")), this.assertEqual$default$3());
            this.assertEqual("`select`", (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "select")), this.assertEqual$default$3());
            this.assertEqual("columns", (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "columns")), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 433));
        this.test("subscript", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("a[b]", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).getItem((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a[1 + 1]", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).getItem(package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1))), this.assertEqual$default$3());
            this.assertEqual("`c`.a[b]", (Expression)package.expressions$.MODULE$.DslAttr(UnresolvedAttribute$.MODULE$.apply("c.a")).getItem((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 447));
        this.test("parenthesis", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("(a)", (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), this.assertEqual$default$3());
            this.assertEqual("r * (a + b)", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "r")).$times(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$plus((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")))), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 453));
        this.test("type constructors", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("dAte '2016-03-11'", (Expression)Literal$.MODULE$.apply((Object)Date.valueOf("2016-03-11")), this.assertEqual$default$3());
            this.intercept("DAtE 'mar 11 2016'", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot parse the DATE value"}));
            this.assertEqual("tImEstAmp '2016-03-11 20:54:00.000'", (Expression)Literal$.MODULE$.apply((Object)Timestamp.valueOf("2016-03-11 20:54:00.000")), this.assertEqual$default$3());
            this.intercept("timestamP '2016-33-11 20:54:00.000'", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot parse the TIMESTAMP value"}));
            this.checkTimestampNTZAndLTZ$1();
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.TIMESTAMP_TYPE().key()), (Object)SQLConf.TimestampTypes$.MODULE$.TIMESTAMP_NTZ().toString())}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.assertEqual("tImEstAmp '2016-03-11 20:54:00.000'", (Expression)Literal$.MODULE$.apply((Object)LocalDateTime.parse("2016-03-11T20:54:00.000")), this.assertEqual$default$3());
                this.intercept("timestamP '2016-33-11 20:54:00.000'", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot parse the TIMESTAMP value"}));
                this.assertEqual("tImEstAmp '1970-01-01 00:00:00.000 +01:00'", (Expression)new Literal((Object)BoxesRunTime.boxToLong((long)-3600000000L), (DataType)TimestampType$.MODULE$), this.assertEqual$default$3());
                this.checkTimestampNTZAndLTZ$1();
            });
            Literal ymIntervalLiteral = Literal$.MODULE$.create((Object)Period.of(1, 2, 0), (DataType)YearMonthIntervalType$.MODULE$.apply());
            this.assertEqual("InterVal 'interval 1 year 2 month'", (Expression)ymIntervalLiteral, this.assertEqual$default$3());
            this.assertEqual("INTERVAL '1 year 2 month'", (Expression)ymIntervalLiteral, this.assertEqual$default$3());
            this.intercept("Interval 'interval 1 yearsss 2 monthsss'", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot parse the INTERVAL value: interval 1 yearsss 2 monthsss"}));
            this.assertEqual("-interval '1 year 2 month'", (Expression)new UnaryMinus((Expression)ymIntervalLiteral, UnaryMinus$.MODULE$.apply$default$2()), this.assertEqual$default$3());
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ExpressionParserSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_catalyst_parser_ExpressionParserSuite$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("java.time.Duration").asType().toTypeConstructor();
                }

                public Org_apache_spark_sql_catalyst_parser_ExpressionParserSuite$$typecreator1$1(ExpressionParserSuite $outer) {
                }
            }
            Literal dtIntervalLiteral = Literal$.MODULE$.create((Object)Duration.ofDays(1L).plusHours(2L).plusMinutes(3L).plusSeconds(4L).plusMillis(5L).plusNanos(6000L), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_catalyst_parser_ExpressionParserSuite$$typecreator1$1(null)));
            this.assertEqual("InterVal 'interval 1 day 2 hour 3 minute 4.005006 second'", (Expression)dtIntervalLiteral, this.assertEqual$default$3());
            this.assertEqual("INTERVAL '1 day 2 hour 3 minute 4.005006 second'", (Expression)dtIntervalLiteral, this.assertEqual$default$3());
            this.intercept("Interval 'interval 1 daysss 2 hoursss'", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot parse the INTERVAL value: interval 1 daysss 2 hoursss"}));
            this.assertEqual("-interval '1 day 2 hour 3 minute 4.005006 second'", (Expression)new UnaryMinus((Expression)dtIntervalLiteral, UnaryMinus$.MODULE$.apply$default$2()), this.assertEqual$default$3());
            this.intercept("INTERVAL '1 year 2 second'", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot mix year-month and day-time fields: INTERVAL '1 year 2 second'"}));
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_INTERVAL_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Literal intervalLiteral = Literal$.MODULE$.apply((Object)IntervalUtils$.MODULE$.stringToInterval(this.stringToUTF8Str("interval 3 month 1 hour")));
                this.assertEqual("InterVal 'interval 3 month 1 hour'", (Expression)intervalLiteral, this.assertEqual$default$3());
                this.assertEqual("INTERVAL '3 month 1 hour'", (Expression)intervalLiteral, this.assertEqual$default$3());
                this.intercept("Interval 'interval 3 monthsss 1 hoursss'", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot parse the INTERVAL value"}));
                this.assertEqual("-interval '3 month 1 hour'", (Expression)new UnaryMinus((Expression)Literal$.MODULE$.apply((Object)IntervalUtils$.MODULE$.stringToInterval(this.stringToUTF8Str("interval 3 month 1 hour"))), UnaryMinus$.MODULE$.apply$default$2()), this.assertEqual$default$3());
                String intervalStrWithAllUnits = "1 year 3 months 2 weeks 2 days 1 hour 3 minutes 2 seconds 100 millisecond 200 microseconds";
                this.assertEqual(new StringBuilder(11).append("interval '").append(intervalStrWithAllUnits).append("'").toString(), (Expression)Literal$.MODULE$.apply((Object)IntervalUtils$.MODULE$.stringToInterval(this.stringToUTF8Str(intervalStrWithAllUnits))), this.assertEqual$default$3());
            });
            this.assertEqual("X'A'", (Expression)Literal$.MODULE$.apply(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(new int[]{10})).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToByte((byte)ExpressionParserSuite.$anonfun$new$40(BoxesRunTime.unboxToInt((Object)x$1))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()))), this.assertEqual$default$3());
            this.assertEqual("x'A10C'", (Expression)Literal$.MODULE$.apply(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(new int[]{161, 12})).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToByte((byte)ExpressionParserSuite.$anonfun$new$41(BoxesRunTime.unboxToInt((Object)x$2))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()))), this.assertEqual$default$3());
            this.intercept("x'A1OC'", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            this.intercept("GEO '(10,-6)'", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Literals of type 'GEO' are currently not supported."}));
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 458));
        this.test("literals", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("null", (Expression)Literal$.MODULE$.apply(null), this.assertEqual$default$3());
            this.assertEqual("trUe", (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true)), this.assertEqual$default$3());
            this.assertEqual("False", (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false)), this.assertEqual$default$3());
            this.assertEqual("787324", (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)787324)), this.assertEqual$default$3());
            this.assertEqual("7873247234798249234", (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)7873247234798249234L)), this.assertEqual$default$3());
            this.testDecimal$1("78732472347982492793712334");
            this.testDecimal$1("7873247234798249279371.2334");
            this.assertEqual("9.0e1", (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)90)), this.assertEqual$default$3());
            this.assertEqual(".9e+2", (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)90)), this.assertEqual$default$3());
            this.assertEqual("0.9e+2", (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)90)), this.assertEqual$default$3());
            this.assertEqual("900e-1BD", (Expression)Literal$.MODULE$.apply((Object)scala.package$.MODULE$.BigDecimal().apply("900e-1").underlying()), this.assertEqual$default$3());
            this.assertEqual("900.0E-1BD", (Expression)Literal$.MODULE$.apply((Object)scala.package$.MODULE$.BigDecimal().apply("900.0E-1").underlying()), this.assertEqual$default$3());
            this.assertEqual("9.e+1BD", (Expression)Literal$.MODULE$.apply((Object)scala.package$.MODULE$.BigDecimal().apply("9.e+1").underlying()), this.assertEqual$default$3());
            this.intercept(".e3", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            this.assertEqual("10Y", (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToByte((byte)((byte)10))), this.assertEqual$default$3());
            this.intercept("-1000Y", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(26).append("does not fit in range [").append(-128).append(", ").append(127).append("]").toString()}));
            this.assertEqual("10S", (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToShort((short)((short)10))), this.assertEqual$default$3());
            this.intercept("40000S", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(26).append("does not fit in range [").append(Short.MIN_VALUE).append(", ").append(Short.MAX_VALUE).append("]").toString()}));
            this.assertEqual("10L", (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)10L)), this.assertEqual$default$3());
            this.intercept("78732472347982492793712334L", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(26).append("does not fit in range [").append(Long.MIN_VALUE).append(", ").append(Long.MAX_VALUE).append("]").toString()}));
            this.assertEqual("10.0D", (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)10.0)), this.assertEqual$default$3());
            this.intercept("-1.8E308D", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"does not fit in range"}));
            this.intercept("1.8E308D", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"does not fit in range"}));
            this.assertEqual("90912830918230182310293801923652346786BD", (Expression)Literal$.MODULE$.apply((Object)scala.package$.MODULE$.BigDecimal().apply("90912830918230182310293801923652346786").underlying()), this.assertEqual$default$3());
            this.assertEqual("123.0E-28BD", (Expression)Literal$.MODULE$.apply((Object)scala.package$.MODULE$.BigDecimal().apply("123.0E-28").underlying()), this.assertEqual$default$3());
            this.assertEqual("123.08BD", (Expression)Literal$.MODULE$.apply((Object)scala.package$.MODULE$.BigDecimal().apply("123.08").underlying()), this.assertEqual$default$3());
            this.intercept("1.20E-38BD", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"decimal can only support precision up to 38"}));
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 534));
        this.test("SPARK-30252: Decimal should set zero scale rather than negative scale by default", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("123.0BD", (Expression)new Literal((Object)Decimal$.MODULE$.apply(scala.package$.MODULE$.BigDecimal().apply("123.0")), (DataType)new DecimalType(4, 1)), this.assertEqual$default$3());
            this.assertEqual("123BD", (Expression)new Literal((Object)Decimal$.MODULE$.apply(scala.package$.MODULE$.BigDecimal().apply("123")), (DataType)new DecimalType(3, 0)), this.assertEqual$default$3());
            this.assertEqual("123E10BD", (Expression)new Literal((Object)Decimal$.MODULE$.apply(scala.package$.MODULE$.BigDecimal().apply("123E10")), (DataType)new DecimalType(13, 0)), this.assertEqual$default$3());
            this.assertEqual("123E+10BD", (Expression)new Literal((Object)Decimal$.MODULE$.apply(scala.package$.MODULE$.BigDecimal().apply("123E+10")), (DataType)new DecimalType(13, 0)), this.assertEqual$default$3());
            this.assertEqual("123E-10BD", (Expression)new Literal((Object)Decimal$.MODULE$.apply(scala.package$.MODULE$.BigDecimal().apply("123E-10")), (DataType)new DecimalType(10, 10)), this.assertEqual$default$3());
            this.assertEqual("1.23E10BD", (Expression)new Literal((Object)Decimal$.MODULE$.apply(scala.package$.MODULE$.BigDecimal().apply("1.23E10")), (DataType)new DecimalType(11, 0)), this.assertEqual$default$3());
            this.assertEqual("-1.23E10BD", (Expression)new Literal((Object)Decimal$.MODULE$.apply(scala.package$.MODULE$.BigDecimal().apply("-1.23E10")), (DataType)new DecimalType(11, 0)), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 591));
        this.test("SPARK-29956: scientific decimal should be parsed as Decimal in legacy mode", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_EXPONENT_LITERAL_AS_DECIMAL_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            CatalystSqlParser parser = new CatalystSqlParser();
            this.testDecimal$2("9e1", (ParserInterface)parser);
            this.testDecimal$2("9e-1", (ParserInterface)parser);
            this.testDecimal$2("-9e1", (ParserInterface)parser);
            this.testDecimal$2("9.0e1", (ParserInterface)parser);
            this.testDecimal$2(".9e+2", (ParserInterface)parser);
            this.testDecimal$2("0.9e+2", (ParserInterface)parser);
        }), new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 601));
        this.test("strings", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)escape -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ESCAPED_STRING_LITERALS().key()), (Object)Boolean.toString(BoxesRunTime.unboxToBoolean((Object)escape)))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                CatalystSqlParser parser = new CatalystSqlParser();
                $this.assertEqual("\"hello\"", (Expression)package.expressions$.MODULE$.stringToLiteral("hello"), (ParserInterface)parser);
                $this.assertEqual("'hello'", (Expression)package.expressions$.MODULE$.stringToLiteral("hello"), (ParserInterface)parser);
                $this.assertEqual("\"hello\" 'world'", (Expression)package.expressions$.MODULE$.stringToLiteral("helloworld"), (ParserInterface)parser);
                $this.assertEqual("'hello' \" \" 'world'", (Expression)package.expressions$.MODULE$.stringToLiteral("hello world"), (ParserInterface)parser);
                $this.assertEqual("'pattern%'", (Expression)package.expressions$.MODULE$.stringToLiteral("pattern%"), (ParserInterface)parser);
                $this.assertEqual("'no-pattern\\%'", (Expression)package.expressions$.MODULE$.stringToLiteral("no-pattern\\%"), (ParserInterface)parser);
                if (escape) {
                    $this.assertEqual("'pattern\\\\%'", (Expression)package.expressions$.MODULE$.stringToLiteral("pattern\\\\%"), (ParserInterface)parser);
                    $this.assertEqual("'pattern\\\\\\%'", (Expression)package.expressions$.MODULE$.stringToLiteral("pattern\\\\\\%"), (ParserInterface)parser);
                    $this.assertEqual("'\\0'", (Expression)package.expressions$.MODULE$.stringToLiteral("\\0"), (ParserInterface)parser);
                    ParseException e = (ParseException)$this.intercept((Function0 & Serializable & scala.Serializable)() -> parser.parseExpression("'''"), ClassTag$.MODULE$.apply(ParseException.class), new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 653));
                    String $org_scalatest_assert_macro_left = e.message();
                    String $org_scalatest_assert_macro_right = "extraneous input '''";
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 654));
                    $this.assertEqual("'\\\"'", (Expression)package.expressions$.MODULE$.stringToLiteral("\\\""), (ParserInterface)parser);
                    $this.assertEqual("'\\b'", (Expression)package.expressions$.MODULE$.stringToLiteral("\\b"), (ParserInterface)parser);
                    $this.assertEqual("'\\n'", (Expression)package.expressions$.MODULE$.stringToLiteral("\\n"), (ParserInterface)parser);
                    $this.assertEqual("'\\r'", (Expression)package.expressions$.MODULE$.stringToLiteral("\\r"), (ParserInterface)parser);
                    $this.assertEqual("'\\t'", (Expression)package.expressions$.MODULE$.stringToLiteral("\\t"), (ParserInterface)parser);
                    $this.assertEqual("'\\110\\145\\154\\154\\157\\041'", (Expression)package.expressions$.MODULE$.stringToLiteral("\\110\\145\\154\\154\\157\\041"), (ParserInterface)parser);
                    $this.assertEqual("'\\u0057\\u006F\\u0072\\u006C\\u0064\\u0020\\u003A\\u0029'", (Expression)package.expressions$.MODULE$.stringToLiteral("\\u0057\\u006F\\u0072\\u006C\\u0064\\u0020\\u003A\\u0029"), (ParserInterface)parser);
                } else {
                    $this.assertEqual("'pattern\\\\%'", (Expression)package.expressions$.MODULE$.stringToLiteral("pattern\\%"), (ParserInterface)parser);
                    $this.assertEqual("'pattern\\\\\\%'", (Expression)package.expressions$.MODULE$.stringToLiteral("pattern\\\\%"), (ParserInterface)parser);
                    $this.assertEqual("'\\0'", (Expression)package.expressions$.MODULE$.stringToLiteral("\u0000"), (ParserInterface)parser);
                    $this.assertEqual("'\\''", (Expression)package.expressions$.MODULE$.stringToLiteral("'"), (ParserInterface)parser);
                    $this.assertEqual("'\\\"'", (Expression)package.expressions$.MODULE$.stringToLiteral("\""), (ParserInterface)parser);
                    $this.assertEqual("'\\b'", (Expression)package.expressions$.MODULE$.stringToLiteral("\b"), (ParserInterface)parser);
                    $this.assertEqual("'\\n'", (Expression)package.expressions$.MODULE$.stringToLiteral("\n"), (ParserInterface)parser);
                    $this.assertEqual("'\\r'", (Expression)package.expressions$.MODULE$.stringToLiteral("\r"), (ParserInterface)parser);
                    $this.assertEqual("'\\t'", (Expression)package.expressions$.MODULE$.stringToLiteral("\t"), (ParserInterface)parser);
                    $this.assertEqual("'\\Z'", (Expression)package.expressions$.MODULE$.stringToLiteral("\u001a"), (ParserInterface)parser);
                    $this.assertEqual("'\\110\\145\\154\\154\\157\\041'", (Expression)package.expressions$.MODULE$.stringToLiteral("Hello!"), (ParserInterface)parser);
                    $this.assertEqual("'\\u0057\\u006F\\u0072\\u006C\\u0064\\u0020\\u003A\\u0029'", (Expression)package.expressions$.MODULE$.stringToLiteral("World :)"), (ParserInterface)parser);
                }
            });
            return BoxedUnit.UNIT;
        }), new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 616));
        this.ymIntervalUnits = (Seq)new .colon.colon((Object)"year", (List)new .colon.colon((Object)"month", (List)Nil$.MODULE$));
        this.dtIntervalUnits = (Seq)new .colon.colon((Object)"week", (List)new .colon.colon((Object)"day", (List)new .colon.colon((Object)"hour", (List)new .colon.colon((Object)"minute", (List)new .colon.colon((Object)"second", (List)new .colon.colon((Object)"millisecond", (List)new .colon.colon((Object)"microsecond", (List)Nil$.MODULE$)))))));
        this.test("intervals", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.intercept("interval", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"at least one time unit should be given for interval literal"}));
            Seq forms = (Seq)new .colon.colon((Object)"", (List)new .colon.colon((Object)"s", (List)Nil$.MODULE$));
            Seq values = (Seq)new .colon.colon((Object)"0", (List)new .colon.colon((Object)"10", (List)new .colon.colon((Object)"-7", (List)new .colon.colon((Object)"21", (List)Nil$.MODULE$))));
            this.ymIntervalUnits().foreach((Function1 & Serializable & scala.Serializable)unit -> {
                forms.foreach((Function1 & Serializable & scala.Serializable)form -> {
                    values$1.foreach((Function1 & Serializable & scala.Serializable)value -> {
                        ExpressionParserSuite.$anonfun$new$54($this, unit$1, form, value);
                        return BoxedUnit.UNIT;
                    });
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            });
            this.dtIntervalUnits().foreach((Function1 & Serializable & scala.Serializable)unit -> {
                forms.foreach((Function1 & Serializable & scala.Serializable)form -> {
                    values$1.foreach((Function1 & Serializable & scala.Serializable)value -> {
                        ExpressionParserSuite.$anonfun$new$57($this, unit$2, form, value);
                        return BoxedUnit.UNIT;
                    });
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            });
            this.checkIntervals$1("13.123456789 seconds", this.dtIntervalLiteral("second", "13.123456789"));
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_INTERVAL_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                ((IterableLike)this.ymIntervalUnits().$plus$plus(this.dtIntervalUnits(), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)unit -> {
                    forms.foreach((Function1 & Serializable & scala.Serializable)form -> {
                        values$1.foreach((Function1 & Serializable & scala.Serializable)value -> {
                            ExpressionParserSuite.$anonfun$new$61($this, unit$3, form, value);
                            return BoxedUnit.UNIT;
                        });
                        return BoxedUnit.UNIT;
                    });
                    return BoxedUnit.UNIT;
                });
                this.checkIntervals$1("-13.123456789 second", Literal$.MODULE$.apply((Object)new CalendarInterval(0, 0, DateTimeTestUtils$.MODULE$.secFrac(-13, -123, -456))));
                this.checkIntervals$1("13.123456 second", Literal$.MODULE$.apply((Object)new CalendarInterval(0, 0, DateTimeTestUtils$.MODULE$.secFrac(13, 123, 456))));
                this.checkIntervals$1("1.001 second", Literal$.MODULE$.apply((Object)IntervalUtils$.MODULE$.stringToInterval(this.stringToUTF8Str("1 second 1 millisecond"))));
            });
            this.intercept("interval 10 nanoseconds", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid unit 'nanoseconds'"}));
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_INTERVAL_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Seq yearMonthValues = (Seq)new .colon.colon((Object)"123-10", (List)new .colon.colon((Object)"496-0", (List)new .colon.colon((Object)"-2-3", (List)new .colon.colon((Object)"-123-0", (List)new .colon.colon((Object)"\t -1-2\t", (List)Nil$.MODULE$)))));
                yearMonthValues.foreach((Function1 & Serializable & scala.Serializable)value -> {
                    ExpressionParserSuite.$anonfun$new$63(this, value);
                    return BoxedUnit.UNIT;
                });
                Seq datTimeValues = (Seq)new .colon.colon((Object)"99 11:22:33.123456789", (List)new .colon.colon((Object)"-99 11:22:33.123456789", (List)new .colon.colon((Object)"10 9:8:7.123456789", (List)new .colon.colon((Object)"1 0:0:0", (List)new .colon.colon((Object)"-1 0:0:0", (List)new .colon.colon((Object)"1 0:0:1", (List)new .colon.colon((Object)"\t 1 0:0:1 ", (List)Nil$.MODULE$)))))));
                datTimeValues.foreach((Function1 & Serializable & scala.Serializable)value -> {
                    ExpressionParserSuite.$anonfun$new$64(this, value);
                    return BoxedUnit.UNIT;
                });
                Seq hourTimeValues = (Seq)new .colon.colon((Object)"11:22:33.123456789", (List)new .colon.colon((Object)"9:8:7.123456789", (List)new .colon.colon((Object)"-19:18:17.123456789", (List)new .colon.colon((Object)"0:0:0", (List)new .colon.colon((Object)"0:0:1", (List)Nil$.MODULE$)))));
                hourTimeValues.foreach((Function1 & Serializable & scala.Serializable)value -> {
                    ExpressionParserSuite.$anonfun$new$65(this, value);
                    return BoxedUnit.UNIT;
                });
            });
            this.intercept("interval '10' month to second", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Intervals FROM month TO second are not supported."}));
            this.checkIntervals$1("10 years 3 months", Literal$.MODULE$.create((Object)Period.of(10, 3, 0), (DataType)YearMonthIntervalType$.MODULE$.apply()));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ExpressionParserSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_catalyst_parser_ExpressionParserSuite$$typecreator2$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("java.time.Duration").asType().toTypeConstructor();
                }

                public Org_apache_spark_sql_catalyst_parser_ExpressionParserSuite$$typecreator2$1(ExpressionParserSuite $outer) {
                }
            }
            this.checkIntervals$1("8 days 2 hours 3 minutes 21 seconds", Literal$.MODULE$.create((Object)Duration.ofDays(8L).plusHours(2L).plusMinutes(3L).plusSeconds(21L), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_catalyst_parser_ExpressionParserSuite$$typecreator2$1(null))));
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)legacyEnabled -> {
                this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_INTERVAL_ENABLED().key()), (Object)Boolean.toString(BoxesRunTime.unboxToBoolean((Object)legacyEnabled)))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    String intervalStr = "3 monThs 4 dayS 22 sEcond 1 millisecond";
                    if (legacyEnabled) {
                        $this.checkIntervals$1(intervalStr, Literal$.MODULE$.apply((Object)new CalendarInterval(3, 4, 22001000L)));
                    } else {
                        $this.intercept(new StringBuilder(9).append("interval ").append(intervalStr).toString(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(52).append("Cannot mix year-month and day-time fields: interval ").append(intervalStr).toString()}));
                    }
                });
                return BoxedUnit.UNIT;
            });
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 734));
        this.test("composed expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("1 + r.r As q", (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))).$plus((Expression)UnresolvedAttribute$.MODULE$.apply("r.r"))).as("q"), this.assertEqual$default$3());
            this.assertEqual("1 - f('o', o(bar))", package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))).$minus((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "f")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("o"), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "o")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "bar"))}))}))), this.assertEqual$default$3());
            this.intercept("1 - f('o', o(bar)) hello * world", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mismatched input '*'"}));
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 863));
        this.test("SPARK-17364, fully qualified column name which starts with number", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("123_", (Expression)UnresolvedAttribute$.MODULE$.apply("123_"), this.assertEqual$default$3());
            this.assertEqual("1a.123_", (Expression)UnresolvedAttribute$.MODULE$.apply("1a.123_"), this.assertEqual$default$3());
            this.assertEqual("a.123A", (Expression)UnresolvedAttribute$.MODULE$.apply("a.123A"), this.assertEqual$default$3());
            this.assertEqual("a.123E3_column", (Expression)UnresolvedAttribute$.MODULE$.apply("a.123E3_column"), this.assertEqual$default$3());
            this.assertEqual("a.123D_column", (Expression)UnresolvedAttribute$.MODULE$.apply("a.123D_column"), this.assertEqual$default$3());
            this.assertEqual("a.123BD_column", (Expression)UnresolvedAttribute$.MODULE$.apply("a.123BD_column"), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 869));
        this.test("SPARK-17832 function identifier contains backtick", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            FunctionIdentifier complexName = new FunctionIdentifier("`ba`r", (Option)new Some((Object)"`fo`o"));
            this.assertEqual(complexName.quotedString(), (Expression)new UnresolvedAttribute((Seq)new .colon.colon((Object)"`fo`o", (List)new .colon.colon((Object)"`ba`r", (List)Nil$.MODULE$))), this.assertEqual$default$3());
            this.intercept(complexName.unquotedString(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mismatched input"}));
            FunctionIdentifier complexName2 = new FunctionIdentifier("ba``r", (Option)new Some((Object)"fo``o"));
            this.assertEqual(complexName2.quotedString(), (Expression)new UnresolvedAttribute((Seq)new .colon.colon((Object)"fo``o", (List)new .colon.colon((Object)"ba``r", (List)Nil$.MODULE$))), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 882));
        this.test("SPARK-19526 Support ignore nulls keywords for first and last", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("first(a ignore nulls)", (Expression)new First((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), true).toAggregateExpression(), this.assertEqual$default$3());
            this.assertEqual("first(a)", (Expression)new First((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), false).toAggregateExpression(), this.assertEqual$default$3());
            this.assertEqual("last(a ignore nulls)", (Expression)new Last((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), true).toAggregateExpression(), this.assertEqual$default$3());
            this.assertEqual("last(a)", (Expression)new Last((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), false).toAggregateExpression(), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 891));
        this.test("timestamp literals", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DateTimeTestUtils$.MODULE$.outstandingZoneIds().foreach((Function1 & Serializable & scala.Serializable)zid -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key()), (Object)zid.getId())}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.assertEval("TIMESTAMP '2019-01-14 20:54:00.000'", BoxesRunTime.boxToLong((long)ExpressionParserSuite.toMicros$1(LocalDateTime.of(2019, 1, 14, 20, 54), zid)), $this.assertEval$default$3());
                $this.assertEval("Timestamp '2000-01-01T00:55:00'", BoxesRunTime.boxToLong((long)ExpressionParserSuite.toMicros$1(LocalDateTime.of(2000, 1, 1, 0, 55), zid)), $this.assertEval$default$3());
                $this.assertEval("TIMESTAMP '2019-01-16 20:50:00.567000+01:00'", BoxesRunTime.boxToLong((long)1547668200567000L), $this.assertEval$default$3());
            });
            return BoxedUnit.UNIT;
        }), new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 898));
        this.test("date literals", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DateTimeTestUtils$.MODULE$.outstandingTimezonesIds().foreach((Function1 & Serializable & scala.Serializable)timeZone -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key()), (Object)timeZone)}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.assertEval("DATE '2019-01-14'", BoxesRunTime.boxToInteger((int)17910), $this.assertEval$default$3());
                $this.assertEval("DATE '2019-01'", BoxesRunTime.boxToInteger((int)17897), $this.assertEval$default$3());
                $this.assertEval("DATE '2019'", BoxesRunTime.boxToInteger((int)17897), $this.assertEval$default$3());
            });
            return BoxedUnit.UNIT;
        }), new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 920));
        this.test("current date/timestamp braceless expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ANSI_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.assertEqual("current_date", (Expression)new CurrentDate(CurrentDate$.MODULE$.apply$default$1()), this.assertEqual$default$3());
                this.assertEqual("current_timestamp", (Expression)new CurrentTimestamp(), this.assertEqual$default$3());
            });
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ANSI_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.assertEqual("current_date", (Expression)UnresolvedAttribute$.MODULE$.quoted("current_date"), this.assertEqual$default$3());
                this.assertEqual("current_timestamp", (Expression)UnresolvedAttribute$.MODULE$.quoted("current_timestamp"), this.assertEqual$default$3());
            });
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 930));
    }
}

