/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.optimizer;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.Coalesce;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.Not;
import org.apache.spark.sql.catalyst.expressions.Predicate;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateExpression;
import org.apache.spark.sql.catalyst.expressions.aggregate.First;
import org.apache.spark.sql.catalyst.optimizer.OptimizeIn$;
import org.apache.spark.sql.catalyst.optimizer.ReplaceOperatorSuite$Optimize$;
import org.apache.spark.sql.catalyst.plans.JoinType;
import org.apache.spark.sql.catalyst.plans.LeftAnti$;
import org.apache.spark.sql.catalyst.plans.LeftSemi$;
import org.apache.spark.sql.catalyst.plans.PlanTest;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.Deduplicate;
import org.apache.spark.sql.catalyst.plans.logical.Distinct;
import org.apache.spark.sql.catalyst.plans.logical.Except;
import org.apache.spark.sql.catalyst.plans.logical.Filter;
import org.apache.spark.sql.catalyst.plans.logical.Intersect;
import org.apache.spark.sql.catalyst.plans.logical.Join;
import org.apache.spark.sql.catalyst.plans.logical.JoinHint$;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.StringContext;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u001d3Aa\u0002\u0005\u0001+!)\u0001\u0005\u0001C\u0001C\u001d)A\u0005\u0001E\u0001K\u0019)q\u0005\u0001E\u0001Q!)\u0001e\u0001C\u0001k!9ag\u0001b\u0001\n\u00039\u0004B\u0002$\u0004A\u0003%\u0001H\u0001\u000bSKBd\u0017mY3Pa\u0016\u0014\u0018\r^8s'VLG/\u001a\u0006\u0003\u0013)\t\u0011b\u001c9uS6L'0\u001a:\u000b\u0005-a\u0011\u0001C2bi\u0006d\u0017p\u001d;\u000b\u00055q\u0011aA:rY*\u0011q\u0002E\u0001\u0006gB\f'o\u001b\u0006\u0003#I\ta!\u00199bG\",'\"A\n\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u00011\"\u0004\u0005\u0002\u001815\ta\"\u0003\u0002\u001a\u001d\ti1\u000b]1sW\u001a+hnU;ji\u0016\u0004\"a\u0007\u0010\u000e\u0003qQ!!\b\u0006\u0002\u000bAd\u0017M\\:\n\u0005}a\"\u0001\u0003)mC:$Vm\u001d;\u0002\rqJg.\u001b;?)\u0005\u0011\u0003CA\u0012\u0001\u001b\u0005A\u0011\u0001C(qi&l\u0017N_3\u0011\u0005\u0019\u001aQ\"\u0001\u0001\u0003\u0011=\u0003H/[7ju\u0016\u001c\"aA\u0015\u0011\u0007)js&D\u0001,\u0015\ta#\"A\u0003sk2,7/\u0003\u0002/W\ta!+\u001e7f\u000bb,7-\u001e;peB\u0011\u0001gM\u0007\u0002c)\u0011!\u0007H\u0001\bY><\u0017nY1m\u0013\t!\u0014GA\u0006M_\u001eL7-\u00197QY\u0006tG#A\u0013\u0002\u000f\t\fGo\u00195fgV\t\u0001\bE\u0002:\u0001\nk\u0011A\u000f\u0006\u0003wq\n\u0011\"[7nkR\f'\r\\3\u000b\u0005ur\u0014AC2pY2,7\r^5p]*\tq(A\u0003tG\u0006d\u0017-\u0003\u0002Bu\t!A*[:u!\t\u0019E)D\u0001\u0004\u0013\t)UFA\u0003CCR\u001c\u0007.\u0001\u0005cCR\u001c\u0007.Z:!\u0001")
public class ReplaceOperatorSuite
extends SparkFunSuite
implements PlanTest {
    private volatile ReplaceOperatorSuite$Optimize$ Optimize$module;
    private String sparkHome;
    private volatile boolean bitmap$0;

    @Override
    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$(this, plan);
    }

    @Override
    public LogicalPlan rewriteNameFromAttrNullability(LogicalPlan plan) {
        return PlanTestBase.rewriteNameFromAttrNullability$(this, plan);
    }

    @Override
    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$(this, plan);
    }

    @Override
    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public boolean comparePlans$default$3() {
        return PlanTestBase.comparePlans$default$3$(this);
    }

    @Override
    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$(this, e1, e2);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$(this, pairs, f);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression buildBalancedPredicate(Seq<Expression> expressions, Function2<Expression, Expression, Expression> op) {
        return PredicateHelper.buildBalancedPredicate$((PredicateHelper)this, expressions, op);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public boolean isNullIntolerant(Expression expr) {
        return PredicateHelper.isNullIntolerant$((PredicateHelper)this, (Expression)expr);
    }

    public Seq<Attribute> outputWithNullability(Seq<Attribute> output, Seq<ExprId> nonNullAttrExprIds) {
        return PredicateHelper.outputWithNullability$((PredicateHelper)this, output, nonNullAttrExprIds);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Seq<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    public ReplaceOperatorSuite$Optimize$ Optimize() {
        if (this.Optimize$module == null) {
            this.Optimize$lzycompute$1();
        }
        return this.Optimize$module;
    }

    private String sparkHome$lzycompute() {
        ReplaceOperatorSuite replaceOperatorSuite = this;
        synchronized (replaceOperatorSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        return !this.bitmap$0 ? this.sparkHome$lzycompute() : this.sparkHome;
    }

    private final void Optimize$lzycompute$1() {
        ReplaceOperatorSuite replaceOperatorSuite = this;
        synchronized (replaceOperatorSuite) {
            if (this.Optimize$module == null) {
                this.Optimize$module = new ReplaceOperatorSuite$Optimize$(this);
            }
        }
    }

    public ReplaceOperatorSuite() {
        AliasHelper.$init$((AliasHelper)this);
        PredicateHelper.$init$((PredicateHelper)this);
        SQLHelper.$init$(this);
        SQLConfHelper.$init$((SQLConfHelper)this);
        PlanTestBase.$init$(this);
        this.test("replace Intersect with Left-semi Join", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LocalRelation table1 = LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int()}));
            LocalRelation table2 = LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "d")).int()}));
            Intersect query = new Intersect((LogicalPlan)table1, (LogicalPlan)table2, false);
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)query).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Aggregate(table1.output(), table1.output(), (LogicalPlan)new Join((LogicalPlan)table1, (LogicalPlan)table2, (JoinType)LeftSemi$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$less$eq$greater((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c")))).$amp$amp((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).$less$eq$greater((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "d"))))), JoinHint$.MODULE$.NONE()))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("ReplaceOperatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
        this.test("replace Except with Filter while both the nodes are of type Filter", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            AttributeReference attributeA = package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int();
            AttributeReference attributeB = package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int();
            LocalRelation table1 = LocalRelation$.MODULE$.fromExternalRows((Seq)new .colon.colon((Object)attributeA, (List)new .colon.colon((Object)attributeB, (List)Nil$.MODULE$)), (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})), (List)Nil$.MODULE$));
            Filter table2 = new Filter((Expression)package.expressions$.MODULE$.DslExpression((Expression)attributeB).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)), (LogicalPlan)new Filter((Expression)package.expressions$.MODULE$.DslExpression((Expression)attributeA).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)), (LogicalPlan)table1));
            Filter table3 = new Filter((Expression)package.expressions$.MODULE$.DslExpression((Expression)attributeB).$less((Expression)package.expressions$.MODULE$.intToLiteral(1)), (LogicalPlan)new Filter((Expression)package.expressions$.MODULE$.DslExpression((Expression)attributeA).$greater$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)), (LogicalPlan)table1));
            Except query = new Except((LogicalPlan)table2, (LogicalPlan)table3, false);
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)query).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Aggregate(table1.output(), table1.output(), (LogicalPlan)new Filter((Expression)new Not((Expression)new Coalesce((Seq)new .colon.colon((Object)((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)attributeA).$greater$eq((Expression)package.expressions$.MODULE$.intToLiteral(2))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)attributeB).$less((Expression)package.expressions$.MODULE$.intToLiteral(1)))), (List)new .colon.colon((Object)Literal$.MODULE$.FalseLiteral(), (List)Nil$.MODULE$)))), (LogicalPlan)new Filter((Expression)package.expressions$.MODULE$.DslExpression((Expression)attributeB).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)), (LogicalPlan)new Filter((Expression)package.expressions$.MODULE$.DslExpression((Expression)attributeA).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)), (LogicalPlan)table1))))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("ReplaceOperatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
        this.test("replace Except with Filter while only right node is of type Filter", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            AttributeReference attributeA = package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int();
            AttributeReference attributeB = package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int();
            LocalRelation table1 = LocalRelation$.MODULE$.fromExternalRows((Seq)new .colon.colon((Object)attributeA, (List)new .colon.colon((Object)attributeB, (List)Nil$.MODULE$)), (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})), (List)Nil$.MODULE$));
            Filter table2 = new Filter((Expression)package.expressions$.MODULE$.DslExpression((Expression)attributeB).$less((Expression)package.expressions$.MODULE$.intToLiteral(1)), (LogicalPlan)new Filter((Expression)package.expressions$.MODULE$.DslExpression((Expression)attributeA).$greater$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)), (LogicalPlan)table1));
            Except query = new Except((LogicalPlan)table1, (LogicalPlan)table2, false);
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)query).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Aggregate(table1.output(), table1.output(), (LogicalPlan)new Filter((Expression)new Not((Expression)new Coalesce((Seq)new .colon.colon((Object)((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)attributeA).$greater$eq((Expression)package.expressions$.MODULE$.intToLiteral(2))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)attributeB).$less((Expression)package.expressions$.MODULE$.intToLiteral(1)))), (List)new .colon.colon((Object)Literal$.MODULE$.FalseLiteral(), (List)Nil$.MODULE$)))), (LogicalPlan)table1))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("ReplaceOperatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
        this.test("replace Except with Filter while both the nodes are of type Project", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            AttributeReference attributeA = package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int();
            AttributeReference attributeB = package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int();
            LocalRelation table1 = LocalRelation$.MODULE$.fromExternalRows((Seq)new .colon.colon((Object)attributeA, (List)new .colon.colon((Object)attributeB, (List)Nil$.MODULE$)), (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})), (List)Nil$.MODULE$));
            Project table2 = new Project((Seq)new .colon.colon((Object)attributeA, (List)new .colon.colon((Object)attributeB, (List)Nil$.MODULE$)), (LogicalPlan)table1);
            Project table3 = new Project((Seq)new .colon.colon((Object)attributeA, (List)new .colon.colon((Object)attributeB, (List)Nil$.MODULE$)), (LogicalPlan)new Filter((Expression)package.expressions$.MODULE$.DslExpression((Expression)attributeB).$less((Expression)package.expressions$.MODULE$.intToLiteral(1)), (LogicalPlan)new Filter((Expression)package.expressions$.MODULE$.DslExpression((Expression)attributeA).$greater$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)), (LogicalPlan)table1)));
            Except query = new Except((LogicalPlan)table2, (LogicalPlan)table3, false);
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)query).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Aggregate(table1.output(), table1.output(), (LogicalPlan)new Filter((Expression)new Not((Expression)new Coalesce((Seq)new .colon.colon((Object)((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)attributeA).$greater$eq((Expression)package.expressions$.MODULE$.intToLiteral(2))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)attributeB).$less((Expression)package.expressions$.MODULE$.intToLiteral(1)))), (List)new .colon.colon((Object)Literal$.MODULE$.FalseLiteral(), (List)Nil$.MODULE$)))), (LogicalPlan)new Project((Seq)new .colon.colon((Object)attributeA, (List)new .colon.colon((Object)attributeB, (List)Nil$.MODULE$)), (LogicalPlan)table1)))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("ReplaceOperatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
        this.test("replace Except with Filter while only right node is of type Project", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            AttributeReference attributeA = package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int();
            AttributeReference attributeB = package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int();
            LocalRelation table1 = LocalRelation$.MODULE$.fromExternalRows((Seq)new .colon.colon((Object)attributeA, (List)new .colon.colon((Object)attributeB, (List)Nil$.MODULE$)), (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})), (List)Nil$.MODULE$));
            Filter table2 = new Filter((Expression)package.expressions$.MODULE$.DslExpression((Expression)attributeB).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)), (LogicalPlan)new Filter((Expression)package.expressions$.MODULE$.DslExpression((Expression)attributeA).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)), (LogicalPlan)table1));
            Project table3 = new Project((Seq)new .colon.colon((Object)attributeA, (List)new .colon.colon((Object)attributeB, (List)Nil$.MODULE$)), (LogicalPlan)new Filter((Expression)package.expressions$.MODULE$.DslExpression((Expression)attributeB).$less((Expression)package.expressions$.MODULE$.intToLiteral(1)), (LogicalPlan)new Filter((Expression)package.expressions$.MODULE$.DslExpression((Expression)attributeA).$greater$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)), (LogicalPlan)table1)));
            Except query = new Except((LogicalPlan)table2, (LogicalPlan)table3, false);
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)query).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Aggregate(table1.output(), table1.output(), (LogicalPlan)new Filter((Expression)new Not((Expression)new Coalesce((Seq)new .colon.colon((Object)((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)attributeA).$greater$eq((Expression)package.expressions$.MODULE$.intToLiteral(2))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)attributeB).$less((Expression)package.expressions$.MODULE$.intToLiteral(1)))), (List)new .colon.colon((Object)Literal$.MODULE$.FalseLiteral(), (List)Nil$.MODULE$)))), (LogicalPlan)new Filter((Expression)package.expressions$.MODULE$.DslExpression((Expression)attributeB).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)), (LogicalPlan)new Filter((Expression)package.expressions$.MODULE$.DslExpression((Expression)attributeA).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)), (LogicalPlan)table1))))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("ReplaceOperatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
        this.test("replace Except with Filter while left node is Project and right node is Filter", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            AttributeReference attributeA = package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int();
            AttributeReference attributeB = package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int();
            LocalRelation table1 = LocalRelation$.MODULE$.fromExternalRows((Seq)new .colon.colon((Object)attributeA, (List)new .colon.colon((Object)attributeB, (List)Nil$.MODULE$)), (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})), (List)Nil$.MODULE$));
            Project table2 = new Project((Seq)new .colon.colon((Object)attributeA, (List)new .colon.colon((Object)attributeB, (List)Nil$.MODULE$)), (LogicalPlan)new Filter((Expression)package.expressions$.MODULE$.DslExpression((Expression)attributeB).$less((Expression)package.expressions$.MODULE$.intToLiteral(1)), (LogicalPlan)new Filter((Expression)package.expressions$.MODULE$.DslExpression((Expression)attributeA).$greater$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)), (LogicalPlan)table1)));
            Filter table3 = new Filter((Expression)package.expressions$.MODULE$.DslExpression((Expression)attributeB).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)), (LogicalPlan)new Filter((Expression)package.expressions$.MODULE$.DslExpression((Expression)attributeA).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)), (LogicalPlan)table1));
            Except query = new Except((LogicalPlan)table2, (LogicalPlan)table3, false);
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)query).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Aggregate(table1.output(), table1.output(), (LogicalPlan)new Filter((Expression)new Not((Expression)new Coalesce((Seq)new .colon.colon((Object)((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)attributeA).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)attributeB).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)))), (List)new .colon.colon((Object)Literal$.MODULE$.FalseLiteral(), (List)Nil$.MODULE$)))), (LogicalPlan)new Project((Seq)new .colon.colon((Object)attributeA, (List)new .colon.colon((Object)attributeB, (List)Nil$.MODULE$)), (LogicalPlan)new Filter((Expression)package.expressions$.MODULE$.DslExpression((Expression)attributeB).$less((Expression)package.expressions$.MODULE$.intToLiteral(1)), (LogicalPlan)new Filter((Expression)package.expressions$.MODULE$.DslExpression((Expression)attributeA).$greater$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)), (LogicalPlan)table1)))))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("ReplaceOperatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
        this.test("replace Except with Left-anti Join", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LocalRelation table1 = LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int()}));
            LocalRelation table2 = LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "d")).int()}));
            Except query = new Except((LogicalPlan)table1, (LogicalPlan)table2, false);
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)query).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Aggregate(table1.output(), table1.output(), (LogicalPlan)new Join((LogicalPlan)table1, (LogicalPlan)table2, (JoinType)LeftAnti$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$less$eq$greater((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c")))).$amp$amp((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).$less$eq$greater((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "d"))))), JoinHint$.MODULE$.NONE()))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("ReplaceOperatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
        this.test("replace Except with Filter when only right filter can be applied to the left", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LocalRelation table = new LocalRelation((Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int(), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int(), (List)Nil$.MODULE$)), LocalRelation$.MODULE$.apply$default$2(), LocalRelation$.MODULE$.apply$default$3());
            LogicalPlan left = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)table).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).$less((Expression)package.expressions$.MODULE$.intToLiteral(1)))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))}))).as("left");
            LogicalPlan right = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)table).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).$less((Expression)package.expressions$.MODULE$.intToLiteral(3)))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))}))).as("right");
            Except query = new Except(left, right, false);
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)query).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Aggregate(left.output(), right.output(), (LogicalPlan)new Join(left, right, (JoinType)LeftAnti$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"left.a"}))).$((Seq)Nil$.MODULE$)).$less$eq$greater((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"right.a"}))).$((Seq)Nil$.MODULE$))), JoinHint$.MODULE$.NONE()))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("ReplaceOperatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
        this.test("replace Distinct with Aggregate", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LocalRelation input = LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int()}));
            Distinct query = new Distinct((LogicalPlan)input);
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)query).analyze());
            Aggregate correctAnswer = new Aggregate(input.output(), input.output(), (LogicalPlan)input);
            this.comparePlans(optimized, (LogicalPlan)correctAnswer, this.comparePlans$default$3());
        }, new Position("ReplaceOperatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
        this.test("replace batch Deduplicate with Aggregate", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LocalRelation input = LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int()}));
            Attribute attrA = (Attribute)input.output().apply(0);
            Attribute attrB = (Attribute)input.output().apply(1);
            Deduplicate query = new Deduplicate((Seq)new .colon.colon((Object)attrA, (List)Nil$.MODULE$), (LogicalPlan)input);
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)query).analyze());
            AggregateExpression x$1 = new First((Expression)attrB).toAggregateExpression();
            String x$2 = attrB.name();
            ExprId x$3 = attrB.exprId();
            Seq x$4 = Alias$.MODULE$.apply$default$4((Expression)x$1, x$2);
            Option x$5 = Alias$.MODULE$.apply$default$5((Expression)x$1, x$2);
            Seq x$6 = Alias$.MODULE$.apply$default$6((Expression)x$1, x$2);
            Aggregate correctAnswer = new Aggregate((Seq)new .colon.colon((Object)attrA, (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)attrA, (List)new .colon.colon((Object)new Alias((Expression)x$1, x$2, x$3, x$4, x$5, x$6), (List)Nil$.MODULE$)), (LogicalPlan)input);
            this.comparePlans(optimized, (LogicalPlan)correctAnswer, this.comparePlans$default$3());
        }, new Position("ReplaceOperatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 194));
        this.test("add one grouping key if necessary when replace Deduplicate with Aggregate", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LocalRelation input = LocalRelation$.MODULE$.apply((Seq)Nil$.MODULE$);
            Deduplicate query = new Deduplicate((Seq)Nil$.MODULE$, (LogicalPlan)input);
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)query).analyze());
            Aggregate correctAnswer = new Aggregate((Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), (List)Nil$.MODULE$), input.output(), (LogicalPlan)input);
            this.comparePlans(optimized, (LogicalPlan)correctAnswer, this.comparePlans$default$3());
        }, new Position("ReplaceOperatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 213));
        this.test("don't replace streaming Deduplicate", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq x$7 = (Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int(), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int(), (List)Nil$.MODULE$));
            boolean x$8 = true;
            Seq x$9 = LocalRelation$.MODULE$.apply$default$2();
            LocalRelation input = new LocalRelation(x$7, x$9, x$8);
            Attribute attrA = (Attribute)input.output().apply(0);
            Deduplicate query = new Deduplicate((Seq)new .colon.colon((Object)attrA, (List)Nil$.MODULE$), (LogicalPlan)input);
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)query).analyze());
            this.comparePlans(optimized, (LogicalPlan)query, this.comparePlans$default$3());
        }, new Position("ReplaceOperatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 221));
        this.test("SPARK-26366: ReplaceExceptWithFilter should handle properly NULL", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LocalRelation basePlan = new LocalRelation((Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int(), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int(), (List)Nil$.MODULE$)), LocalRelation$.MODULE$.apply$default$2(), LocalRelation$.MODULE$.apply$default$3());
            LogicalPlan otherPlan = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)basePlan).where((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).in((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.intToLiteral(1), package.expressions$.MODULE$.intToLiteral(2)}))).$bar$bar(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).in((Seq)Nil$.MODULE$)));
            Except except = new Except((LogicalPlan)basePlan, otherPlan, false);
            LogicalPlan result = OptimizeIn$.MODULE$.apply((LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)except).analyze()));
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Aggregate(basePlan.output(), basePlan.output(), (LogicalPlan)new Filter((Expression)package.expressions$.MODULE$.DslExpression((Expression)new Coalesce((Seq)new .colon.colon((Object)((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).in((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.intToLiteral(1), package.expressions$.MODULE$.intToLiteral(2)}))).$bar$bar((Expression)new If((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).isNotNull(), (Expression)Literal$.MODULE$.FalseLiteral(), (Expression)new Literal(null, (DataType)BooleanType$.MODULE$)))), (List)new .colon.colon((Object)Literal$.MODULE$.FalseLiteral(), (List)Nil$.MODULE$)))).unary_$bang(), (LogicalPlan)basePlan))).analyze();
            this.comparePlans(result, correctAnswer, this.comparePlans$default$3());
        }, new Position("ReplaceOperatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 230));
        this.test("SPARK-26366: ReplaceExceptWithFilter should not transform non-deterministic", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LocalRelation basePlan = new LocalRelation((Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int(), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int(), (List)Nil$.MODULE$)), LocalRelation$.MODULE$.apply$default$2(), LocalRelation$.MODULE$.apply$default$3());
            LogicalPlan otherPlan = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)basePlan).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater(package.expressions$.MODULE$.rand(1L)));
            Except except = new Except((LogicalPlan)basePlan, otherPlan, false);
            LogicalPlan result = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)except).analyze());
            Predicate condition = (Predicate)((TraversableOnce)((TraversableLike)basePlan.output().zip((GenIterable)otherPlan.output(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Attribute a1 = (Attribute)tuple2._1();
                Attribute a2 = (Attribute)tuple2._2();
                Predicate predicate = package.expressions$.MODULE$.DslExpression((Expression)a1).$less$eq$greater((Expression)a2);
                return predicate;
            }, Seq$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(x$2, x$3) -> package.expressions$.MODULE$.DslExpression((Expression)x$2).$amp$amp((Expression)x$3));
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Aggregate(basePlan.output(), otherPlan.output(), (LogicalPlan)new Join((LogicalPlan)basePlan, otherPlan, (JoinType)LeftAnti$.MODULE$, Option$.MODULE$.apply((Object)condition), JoinHint$.MODULE$.NONE()))).analyze();
            this.comparePlans(result, correctAnswer, this.comparePlans$default$3());
        }, new Position("ReplaceOperatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 243));
    }
}

