/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.CurrentRow$;
import org.apache.spark.sql.catalyst.expressions.DateAddInterval;
import org.apache.spark.sql.catalyst.expressions.DateAddInterval$;
import org.apache.spark.sql.catalyst.expressions.DatetimeSub;
import org.apache.spark.sql.catalyst.expressions.DoubleLiteral$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.FloatLiteral$;
import org.apache.spark.sql.catalyst.expressions.FrameType;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.RangeFrame$;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.expressions.SpecifiedWindowFrame;
import org.apache.spark.sql.catalyst.expressions.TimeAdd;
import org.apache.spark.sql.catalyst.expressions.TimeAdd$;
import org.apache.spark.sql.catalyst.expressions.UnboundedPreceding$;
import org.apache.spark.sql.catalyst.expressions.WindowFrame;
import org.apache.spark.sql.catalyst.expressions.WindowSpecDefinition;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Symbol;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001Q2Aa\u0001\u0003\u0001#!)a\u0003\u0001C\u0001/!)!\u0004\u0001C\t7\tIR\t\u001f9sKN\u001c\u0018n\u001c8T#2\u0013U/\u001b7eKJ\u001cV/\u001b;f\u0015\t)a!A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0004\t\u0003!\u0019\u0017\r^1msN$(BA\u0005\u000b\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u00171\tQa\u001d9be.T!!\u0004\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0011aA8sO\u000e\u00011C\u0001\u0001\u0013!\t\u0019B#D\u0001\u000b\u0013\t)\"BA\u0007Ta\u0006\u00148NR;o'VLG/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003a\u0001\"!\u0007\u0001\u000e\u0003\u0011\t\u0001b\u00195fG.\u001c\u0016\u000b\u0014\u000b\u00049\t:\u0003CA\u000f!\u001b\u0005q\"\"A\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005r\"\u0001B+oSRDQa\t\u0002A\u0002\u0011\n\u0011!\u001a\t\u00033\u0015J!A\n\u0003\u0003\u0015\u0015C\bO]3tg&|g\u000eC\u0003)\u0005\u0001\u0007\u0011&A\u0006fqB,7\r^3e'Fc\u0005C\u0001\u00162\u001d\tYs\u0006\u0005\u0002-=5\tQF\u0003\u0002/!\u00051AH]8pizJ!\u0001\r\u0010\u0002\rA\u0013X\rZ3g\u0013\t\u00114G\u0001\u0004TiJLgn\u001a\u0006\u0003ay\u0001")
public class ExpressionSQLBuilderSuite
extends SparkFunSuite {
    public void checkSQL(Expression e, String expectedSQL) {
        String actualSQL = e.sql();
        try {
            String $org_scalatest_assert_macro_left = actualSQL;
            String $org_scalatest_assert_macro_right = expectedSQL;
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExpressionSQLBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 36));
        }
        catch (Throwable cause) {
            throw this.fail(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(121).append("Wrong SQL generated for the following expression:\n             |\n             |").append(e.prettyName()).append("\n             |\n             |").append(cause).append("\n           ").toString())).stripMargin(), new Position("ExpressionSQLBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
        }
        if (e instanceof Literal) {
            DataType dataType = e.dataType();
            TimestampType$ timestampType$ = TimestampType$.MODULE$;
            if (dataType == null ? timestampType$ != null : !dataType.equals(timestampType$)) {
                float f;
                Expression qual$1 = CatalystSqlParser$.MODULE$.parseExpression(actualSQL);
                InternalRow x$1 = qual$1.eval$default$1();
                Object roundTrippedValue = qual$1.eval(x$1);
                Expression expression = e;
                Option option = FloatLiteral$.MODULE$.unapply((Object)expression);
                if (!option.isEmpty() && Float.isNaN(f = BoxesRunTime.unboxToFloat((Object)option.get()))) {
                    Object $org_scalatest_assert_macro_left = roundTrippedValue;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool($org_scalatest_assert_macro_left, "isInstanceOf", "scala.Float", $org_scalatest_assert_macro_left instanceof Float, Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExpressionSQLBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(Float.isNaN(BoxesRunTime.unboxToFloat((Object)roundTrippedValue)), "scala.Predef.float2Float(roundTrippedValue.asInstanceOf[Float]).isNaN()", Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExpressionSQLBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    double d;
                    Option option2 = DoubleLiteral$.MODULE$.unapply((Object)expression);
                    if (!option2.isEmpty() && Double.isNaN(d = BoxesRunTime.unboxToDouble((Object)option2.get()))) {
                        Object $org_scalatest_assert_macro_left = roundTrippedValue;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool($org_scalatest_assert_macro_left, "isInstanceOf", "scala.Double", $org_scalatest_assert_macro_left instanceof Double, Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExpressionSQLBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(Double.isNaN(BoxesRunTime.unboxToDouble((Object)roundTrippedValue)), "scala.Predef.double2Double(roundTrippedValue.asInstanceOf[Double]).isNaN()", Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExpressionSQLBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (expression instanceof Literal) {
                        Literal literal = (Literal)expression;
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(literal.value());
                        Object $org_scalatest_assert_macro_right = roundTrippedValue;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExpressionSQLBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        throw new MatchError((Object)expression);
                    }
                }
            }
        }
    }

    public static final /* synthetic */ byte $anonfun$new$2(int x$1) {
        return (byte)x$1;
    }

    public ExpressionSQLBuilderSuite() {
        this.test("literal", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkSQL((Expression)Literal$.MODULE$.apply((Object)"foo"), "'foo'");
            this.checkSQL((Expression)Literal$.MODULE$.apply((Object)"\"foo\""), "'\"foo\"'");
            this.checkSQL((Expression)Literal$.MODULE$.apply((Object)"'foo'"), "'\\'foo\\''");
            this.checkSQL((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToByte((byte)1)), "1Y");
            this.checkSQL((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToShort((short)2)), "2S");
            this.checkSQL((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)4)), "4");
            this.checkSQL((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)8L)), "8L");
            this.checkSQL((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)1.5f)), "CAST('1.5' AS FLOAT)");
            this.checkSQL((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)Float.POSITIVE_INFINITY)), "CAST('Infinity' AS FLOAT)");
            this.checkSQL((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)Float.NEGATIVE_INFINITY)), "CAST('-Infinity' AS FLOAT)");
            this.checkSQL((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)Float.NaN)), "CAST('NaN' AS FLOAT)");
            this.checkSQL((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)Float.MIN_VALUE)), "CAST('1.4E-45' AS FLOAT)");
            this.checkSQL((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)2.5)), "2.5D");
            this.checkSQL((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)Double.POSITIVE_INFINITY)), "CAST('Infinity' AS DOUBLE)");
            this.checkSQL((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)Double.NEGATIVE_INFINITY)), "CAST('-Infinity' AS DOUBLE)");
            this.checkSQL((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)Double.NaN)), "CAST('NaN' AS DOUBLE)");
            this.checkSQL((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)Double.MIN_VALUE)), "4.9E-324D");
            this.checkSQL((Expression)Literal$.MODULE$.apply((Object)package$.MODULE$.BigDecimal().apply("10.0000000").underlying()), "10.0000000BD");
            this.checkSQL((Expression)Literal$.MODULE$.apply(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(new int[]{1, 163})).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToByte((byte)ExpressionSQLBuilderSuite.$anonfun$new$2(BoxesRunTime.unboxToInt((Object)x$1))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()))), "X'01A3'");
            Instant timestamp = LocalDateTime.of(2016, 1, 1, 0, 0, 0, 987654321).atZone(DateTimeUtils$.MODULE$.getZoneId(SQLConf$.MODULE$.get().sessionLocalTimeZone())).toInstant();
            this.checkSQL((Expression)Literal$.MODULE$.apply((Object)timestamp), "TIMESTAMP '2016-01-01 00:00:00.987654'");
        }, new Position("ExpressionSQLBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
        this.test("attributes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkSQL((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int(), "a");
            this.checkSQL((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "foo bar")).int(), "`foo bar`");
            this.checkSQL((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "int")).int(), "int");
        }, new Position("ExpressionSQLBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
        this.test("binary comparisons", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkSQL((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int()), "(a = b)");
            this.checkSQL((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int()).$less$eq$greater((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int()), "(a <=> b)");
            this.checkSQL((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int()).$eq$bang$eq((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int()), "(NOT (a = b))");
            this.checkSQL((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int()).$less((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int()), "(a < b)");
            this.checkSQL((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int()).$less$eq((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int()), "(a <= b)");
            this.checkSQL((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int()).$greater((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int()), "(a > b)");
            this.checkSQL((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int()).$greater$eq((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int()), "(a >= b)");
            this.checkSQL(package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int()).in((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).int()})), "(a IN (b, c))");
            this.checkSQL(package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int()).in((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.intToLiteral(1), package.expressions$.MODULE$.intToLiteral(2)})), "(a IN (1, 2))");
            this.checkSQL((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int()).isNull(), "(a IS NULL)");
            this.checkSQL((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int()).isNotNull(), "(a IS NOT NULL)");
        }, new Position("ExpressionSQLBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
        this.test("logical operators", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkSQL((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).boolean()).$amp$amp((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).boolean()), "(a AND b)");
            this.checkSQL((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).boolean()).$bar$bar((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).boolean()), "(a OR b)");
            this.checkSQL((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).boolean()).unary_$bang(), "(NOT a)");
            this.checkSQL((Expression)new If((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).boolean(), (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int(), (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).int()), "(IF(a, b, c))");
        }, new Position("ExpressionSQLBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
        this.test("arithmetic expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkSQL(package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int()).$plus((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int()), "(a + b)");
            this.checkSQL(package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int()).$minus((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int()), "(a - b)");
            this.checkSQL(package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int()).$times((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int()), "(a * b)");
            this.checkSQL(package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int()).$div((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int()), "(a / b)");
            this.checkSQL(package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int()).$percent((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int()), "(a % b)");
            this.checkSQL(package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int()).unary_$minus(), "(- a)");
            this.checkSQL(package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int()).$plus((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int())).unary_$minus(), "(- (a + b))");
        }, new Position("ExpressionSQLBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
        this.test("window specification", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SpecifiedWindowFrame frame = new SpecifiedWindowFrame((FrameType)RangeFrame$.MODULE$, (Expression)UnboundedPreceding$.MODULE$, (Expression)CurrentRow$.MODULE$);
            AttributeReference attributeReference = package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int();
            this.checkSQL((Expression)new WindowSpecDefinition((Seq)Nil$.MODULE$.$colon$colon((Object)attributeReference), (Seq)Nil$.MODULE$, (WindowFrame)frame), new StringBuilder(17).append("(PARTITION BY a ").append(frame.sql()).append(")").toString());
            AttributeReference attributeReference2 = package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int();
            AttributeReference attributeReference3 = package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).string();
            this.checkSQL((Expression)new WindowSpecDefinition((Seq)Nil$.MODULE$.$colon$colon((Object)attributeReference3).$colon$colon((Object)attributeReference2), (Seq)Nil$.MODULE$, (WindowFrame)frame), new StringBuilder(20).append("(PARTITION BY a, b ").append(frame.sql()).append(")").toString());
            SortOrder sortOrder = package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int()).asc();
            this.checkSQL((Expression)new WindowSpecDefinition((Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$.$colon$colon((Object)sortOrder), (WindowFrame)frame), new StringBuilder(29).append("(ORDER BY a ASC NULLS FIRST ").append(frame.sql()).append(")").toString());
            SortOrder sortOrder2 = package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int()).asc();
            SortOrder sortOrder3 = package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).string()).desc();
            this.checkSQL((Expression)new WindowSpecDefinition((Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$.$colon$colon((Object)sortOrder3).$colon$colon((Object)sortOrder2), (WindowFrame)frame), new StringBuilder(48).append("(ORDER BY a ASC NULLS FIRST, b DESC NULLS LAST ").append(frame.sql()).append(")").toString());
            AttributeReference attributeReference4 = package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int();
            AttributeReference attributeReference5 = package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).string();
            SortOrder sortOrder4 = package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).int()).asc();
            SortOrder sortOrder5 = package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "d")).string()).desc();
            this.checkSQL((Expression)new WindowSpecDefinition((Seq)Nil$.MODULE$.$colon$colon((Object)attributeReference5).$colon$colon((Object)attributeReference4), (Seq)Nil$.MODULE$.$colon$colon((Object)sortOrder5).$colon$colon((Object)sortOrder4), (WindowFrame)frame), new StringBuilder(66).append("(PARTITION BY a, b ORDER BY c ASC NULLS FIRST, d DESC NULLS LAST ").append(frame.sql()).append(")").toString());
        }, new Position("ExpressionSQLBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
        this.test("interval arithmetic", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Literal interval = Literal$.MODULE$.apply((Object)new CalendarInterval(0, 0, 3600000000L));
            this.checkSQL((Expression)new TimeAdd((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)interval, TimeAdd$.MODULE$.apply$default$3()), "a + INTERVAL '1 hours'");
            this.checkSQL((Expression)new DatetimeSub((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)interval, (Expression)Literal$.MODULE$.default((DataType)TimestampType$.MODULE$)), "a - INTERVAL '1 hours'");
            this.checkSQL((Expression)new DateAddInterval((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)interval, DateAddInterval$.MODULE$.apply$default$3(), DateAddInterval$.MODULE$.apply$default$4()), "a + INTERVAL '1 hours'");
        }, new Position("ExpressionSQLBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
    }
}

