/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.avro;

import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.QueryTest$;
import org.apache.spark.sql.avro.functions;
import org.apache.spark.sql.test.TestSparkSession;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class JavaAvroFunctionsSuite {
    private transient TestSparkSession spark;

    @Before
    public void setUp() {
        this.spark = new TestSparkSession();
    }

    @After
    public void tearDown() {
        this.spark.stop();
    }

    @Test
    public void testToAvroFromAvro() {
        Dataset rangeDf = this.spark.range(10L);
        Dataset df = rangeDf.select(new Column[]{rangeDf.col("id"), rangeDf.col("id").cast("string").as("str")});
        Dataset avroDF = df.select(new Column[]{functions.to_avro((Column)df.col("id")).as("a"), functions.to_avro((Column)df.col("str")).as("b")});
        String avroTypeLong = "{\"type\": \"int\", \"name\": \"id\"}";
        String avroTypeStr = "{\"type\": \"string\", \"name\": \"str\"}";
        Dataset actual = avroDF.select(new Column[]{functions.from_avro((Column)avroDF.col("a"), (String)avroTypeLong), functions.from_avro((Column)avroDF.col("b"), (String)avroTypeStr)});
        QueryTest$.MODULE$.checkAnswer(actual, df.collectAsList());
    }
}

