/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.avro;

import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URI;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import org.apache.avro.Conversions;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.io.DatumWriter;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.QueryTest;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.test.SQLTestData;
import org.apache.spark.sql.test.SQLTestData$internalImplicits$;
import org.apache.spark.sql.test.SQLTestUtils;
import org.apache.spark.sql.test.SQLTestUtilsBase;
import org.apache.spark.sql.test.SQLTestUtilsBase$testImplicits$;
import org.apache.spark.sql.test.SharedSparkSession;
import org.apache.spark.sql.test.SharedSparkSessionBase;
import org.apache.spark.sql.test.TestSparkSession;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Tag;
import org.scalatest.concurrent.AbstractPatienceConfiguration;
import org.scalatest.concurrent.AbstractPatienceConfiguration$PatienceConfig$;
import org.scalatest.concurrent.Eventually;
import org.scalatest.concurrent.PatienceConfiguration;
import org.scalatest.concurrent.ScaledTimeSpans;
import org.scalatest.enablers.Retrying;
import org.scalatest.funsuite.AnyFunSuiteLike;
import org.scalatest.time.Span;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001-4Qa\u0004\t\u0002\u0002mAQA\n\u0001\u0005\u0002\u001dBqA\u000b\u0001C\u0002\u0013\u00051\u0006\u0003\u0004:\u0001\u0001\u0006I\u0001\f\u0005\bu\u0001\u0011\r\u0011\"\u0001<\u0011\u00191\u0005\u0001)A\u0005y!)q\t\u0001C\u0001\u0011\"91\n\u0001b\u0001\n\u0003Y\u0003B\u0002'\u0001A\u0003%A\u0006C\u0004N\u0001\t\u0007I\u0011\u0001(\t\rY\u0003\u0001\u0015!\u0003P\u0011\u00159\u0006\u0001\"\u0001Y\u0011\u001dQ\u0006A1A\u0005\u0002mCa\u0001\u001a\u0001!\u0002\u0013a\u0006\"B3\u0001\t\u00031'\u0001F!we>dunZ5dC2$\u0016\u0010]3Tk&$XM\u0003\u0002\u0012%\u0005!\u0011M\u001e:p\u0015\t\u0019B#A\u0002tc2T!!\u0006\f\u0002\u000bM\u0004\u0018M]6\u000b\u0005]A\u0012AB1qC\u000eDWMC\u0001\u001a\u0003\ry'oZ\u0002\u0001'\r\u0001A\u0004\t\t\u0003;yi\u0011AE\u0005\u0003?I\u0011\u0011\"U;fef$Vm\u001d;\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0005\r\u0012\u0012\u0001\u0002;fgRL!!\n\u0012\u0003%MC\u0017M]3e'B\f'o[*fgNLwN\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003!\u0002\"!\u000b\u0001\u000e\u0003A\t!\u0002Z1uKN\u001b\u0007.Z7b+\u0005a\u0003CA\u00177\u001d\tqC\u0007\u0005\u00020e5\t\u0001G\u0003\u000225\u00051AH]8pizR\u0011aM\u0001\u0006g\u000e\fG.Y\u0005\u0003kI\na\u0001\u0015:fI\u00164\u0017BA\u001c9\u0005\u0019\u0019FO]5oO*\u0011QGM\u0001\fI\u0006$XmU2iK6\f\u0007%A\u0007eCR,\u0017J\u001c9vi\u0012\u000bG/Y\u000b\u0002yA\u0019Q\b\u0011\"\u000e\u0003yR!a\u0010\u001a\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002B}\t\u00191+Z9\u0011\u0005\r#U\"\u0001\u001a\n\u0005\u0015\u0013$aA%oi\u0006qA-\u0019;f\u0013:\u0004X\u000f\u001e#bi\u0006\u0004\u0013\u0001\u00033bi\u00164\u0015\u000e\\3\u0015\u00051J\u0005\"\u0002&\u0007\u0001\u0004a\u0013\u0001\u00029bi\"\fq\u0002^5nKN$\u0018-\u001c9TG\",W.Y\u0001\u0011i&lWm\u001d;b[B\u001c6\r[3nC\u0002\n!\u0003^5nKN$\u0018-\u001c9J]B,H\u000fR1uCV\tq\nE\u0002>\u0001B\u0003RaQ)T'NK!A\u0015\u001a\u0003\rQ+\b\u000f\\34!\t\u0019E+\u0003\u0002Ve\t!Aj\u001c8h\u0003M!\u0018.\\3ti\u0006l\u0007/\u00138qkR$\u0015\r^1!\u00035!\u0018.\\3ti\u0006l\u0007OR5mKR\u0011A&\u0017\u0005\u0006\u0015.\u0001\r\u0001L\u0001\u0011I\u0016\u001c\u0017.\\1m\u0013:\u0004X\u000f\u001e#bi\u0006,\u0012\u0001\u0018\t\u0004{\u0001k\u0006C\u00010d\u001b\u0005y&B\u00011b\u0003\u0011a\u0017M\\4\u000b\u0003\t\fAA[1wC&\u0011qgX\u0001\u0012I\u0016\u001c\u0017.\\1m\u0013:\u0004X\u000f\u001e#bi\u0006\u0004\u0013\u0001\u00063fG&l\u0017\r\\*dQ\u0016l\u0017-\u00118e\r&dW\r\u0006\u0002hUB!1\t\u001b\u0017-\u0013\tI'G\u0001\u0004UkBdWM\r\u0005\u0006\u0015:\u0001\r\u0001\f")
public abstract class AvroLogicalTypeSuite
extends QueryTest
implements SharedSparkSession {
    private final String dateSchema;
    private final Seq<Object> dateInputData;
    private final String timestampSchema;
    private final Seq<Tuple3<Object, Object, Object>> timestampInputData;
    private final Seq<String> decimalInputData;
    private final boolean enableAutoThreadAudit;
    private TestSparkSession org$apache$spark$sql$test$SharedSparkSessionBase$$_spark;
    private boolean org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests;
    private Function1<String, Dataset<Row>> sql;
    private volatile SQLTestUtilsBase$testImplicits$ testImplicits$module;
    private volatile SQLTestData$internalImplicits$ internalImplicits$module;
    private Dataset<Row> emptyTestData;
    private Dataset<Row> testData;
    private Dataset<Row> testData2;
    private Dataset<Row> testData3;
    private Dataset<Row> negativeData;
    private Dataset<Row> largeAndSmallInts;
    private Dataset<Row> decimalData;
    private Dataset<Row> binaryData;
    private Dataset<Row> upperCaseData;
    private Dataset<Row> lowerCaseData;
    private Dataset<Row> lowerCaseDataWithDuplicates;
    private RDD<SQLTestData.ArrayData> arrayData;
    private RDD<SQLTestData.MapData> mapData;
    private RDD<SQLTestData.IntervalData> calendarIntervalData;
    private RDD<SQLTestData.StringData> repeatedData;
    private RDD<SQLTestData.StringData> nullableRepeatedData;
    private Dataset<Row> nullInts;
    private Dataset<Row> allNulls;
    private Dataset<Row> nullStrings;
    private Dataset<Row> tableName;
    private RDD<String> unparsedStrings;
    private RDD<SQLTestData.IntField> withEmptyParts;
    private Dataset<Row> person;
    private Dataset<Row> salary;
    private Dataset<Row> complexData;
    private Dataset<Row> courseSales;
    private Dataset<Row> trainingSales;
    private Dataset<Row> intervalData;
    private final AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    private volatile AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig$module;
    private volatile int bitmap$0;

    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$beforeAll() {
        SharedSparkSessionBase.beforeAll$((SharedSparkSessionBase)this);
    }

    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$afterAll() {
        SharedSparkSessionBase.afterAll$((SharedSparkSessionBase)this);
    }

    public void beforeAll() {
        SharedSparkSession.beforeAll$((SharedSparkSession)this);
    }

    public void afterAll() {
        SharedSparkSession.afterAll$((SharedSparkSession)this);
    }

    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$beforeAll() {
        SQLTestUtils.beforeAll$((SQLTestUtils)this);
    }

    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$afterAll() {
        super.afterAll();
    }

    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
    }

    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    public SparkConf sparkConf() {
        return SharedSparkSessionBase.sparkConf$((SharedSparkSessionBase)this);
    }

    public SparkSession spark() {
        return SharedSparkSessionBase.spark$((SharedSparkSessionBase)this);
    }

    public SQLContext sqlContext() {
        return SharedSparkSessionBase.sqlContext$((SharedSparkSessionBase)this);
    }

    public TestSparkSession createSparkSession() {
        return SharedSparkSessionBase.createSparkSession$((SharedSparkSessionBase)this);
    }

    public void initializeSession() {
        SharedSparkSessionBase.initializeSession$((SharedSparkSessionBase)this);
    }

    public void beforeEach() {
        SharedSparkSessionBase.beforeEach$((SharedSparkSessionBase)this);
    }

    public void afterEach() {
        SharedSparkSessionBase.afterEach$((SharedSparkSessionBase)this);
    }

    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtils$$super$beforeAll() {
        super.beforeAll();
    }

    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtils$$super$withTempDir(Function1 f) {
        super.withTempDir(f);
    }

    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtils$$super$test(String testName, Seq testTags, Function0 testFun, Position pos) {
        AnyFunSuiteLike.test$((AnyFunSuiteLike)this, (String)testName, (Seq)testTags, (Function0)testFun, (Position)pos);
    }

    public void withTempDir(Function1<File, BoxedUnit> f) {
        SQLTestUtils.withTempDir$((SQLTestUtils)this, f);
    }

    public void testWithWholeStageCodegenOnAndOff(String testName, Function1<String, BoxedUnit> f) {
        SQLTestUtils.testWithWholeStageCodegenOnAndOff$((SQLTestUtils)this, (String)testName, f);
    }

    public void setupTestData() {
        SQLTestUtils.setupTestData$((SQLTestUtils)this);
    }

    public void testQuietly(String name, Function0<BoxedUnit> f) {
        SQLTestUtils.testQuietly$((SQLTestUtils)this, (String)name, f);
    }

    public void test(String testName, Seq<Tag> testTags, Function0<Object> testFun, Position pos) {
        SQLTestUtils.test$((SQLTestUtils)this, (String)testName, testTags, testFun, (Position)pos);
    }

    public void testWithUninterruptibleThread(String name, boolean quietly, Function0<BoxedUnit> body) {
        SQLTestUtils.testWithUninterruptibleThread$((SQLTestUtils)this, (String)name, (boolean)quietly, body);
    }

    public boolean testWithUninterruptibleThread$default$2() {
        return SQLTestUtils.testWithUninterruptibleThread$default$2$((SQLTestUtils)this);
    }

    public void withResourceTempPath(String resourcePath, Function1<File, BoxedUnit> f) {
        SQLTestUtils.withResourceTempPath$((SQLTestUtils)this, (String)resourcePath, f);
    }

    public void waitForTasksToFinish() {
        SQLTestUtils.waitForTasksToFinish$((SQLTestUtils)this);
    }

    public void withTempPaths(int numPaths, Function1<Seq<File>, BoxedUnit> f) {
        SQLTestUtils.withTempPaths$((SQLTestUtils)this, (int)numPaths, f);
    }

    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtilsBase$$super$withSQLConf(Seq pairs, Function0 f) {
        SQLHelper.withSQLConf$((SQLHelper)this, (Seq)pairs, (Function0)f);
    }

    public SparkContext sparkContext() {
        return SQLTestUtilsBase.sparkContext$((SQLTestUtilsBase)this);
    }

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withSQLConf$((SQLTestUtilsBase)this, pairs, f);
    }

    public void withUserDefinedFunction(Seq<Tuple2<String, Object>> functions2, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withUserDefinedFunction$((SQLTestUtilsBase)this, functions2, f);
    }

    public void withTempView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withTempView$((SQLTestUtilsBase)this, viewNames, f);
    }

    public void withGlobalTempView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withGlobalTempView$((SQLTestUtilsBase)this, viewNames, f);
    }

    public void withTable(Seq<String> tableNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withTable$((SQLTestUtilsBase)this, tableNames, f);
    }

    public void withView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withView$((SQLTestUtilsBase)this, viewNames, f);
    }

    public void withCache(Seq<String> cacheNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withCache$((SQLTestUtilsBase)this, cacheNames, f);
    }

    public void uncacheTable(String tableName) {
        SQLTestUtilsBase.uncacheTable$((SQLTestUtilsBase)this, (String)tableName);
    }

    public void withTempDatabase(Function1<String, BoxedUnit> f) {
        SQLTestUtilsBase.withTempDatabase$((SQLTestUtilsBase)this, f);
    }

    public void withDatabase(Seq<String> dbNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withDatabase$((SQLTestUtilsBase)this, dbNames, f);
    }

    public void withNamespace(Seq<String> namespaces, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withNamespace$((SQLTestUtilsBase)this, namespaces, f);
    }

    public void withLocale(String language, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withLocale$((SQLTestUtilsBase)this, (String)language, f);
    }

    public void activateDatabase(String db, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.activateDatabase$((SQLTestUtilsBase)this, (String)db, f);
    }

    public Dataset<Row> stripSparkFilter(Dataset<Row> df) {
        return SQLTestUtilsBase.stripSparkFilter$((SQLTestUtilsBase)this, df);
    }

    public Dataset<Row> logicalPlanToSparkQuery(LogicalPlan plan) {
        return SQLTestUtilsBase.logicalPlanToSparkQuery$((SQLTestUtilsBase)this, (LogicalPlan)plan);
    }

    public URI makeQualifiedPath(String path) {
        return SQLTestUtilsBase.makeQualifiedPath$((SQLTestUtilsBase)this, (String)path);
    }

    public String testFile(String fileName) {
        return SQLTestUtilsBase.testFile$((SQLTestUtilsBase)this, (String)fileName);
    }

    public long getLocalDirSize(File file) {
        return SQLTestUtilsBase.getLocalDirSize$((SQLTestUtilsBase)this, (File)file);
    }

    public void loadTestData() {
        SQLTestData.loadTestData$((SQLTestData)this);
    }

    public <T> T eventually(PatienceConfiguration.Timeout timeout, PatienceConfiguration.Interval interval, Function0<T> fun, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, (PatienceConfiguration.Interval)interval, fun, retrying, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Timeout timeout, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Interval interval, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Interval)interval, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public <T> T eventually(Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public AbstractPatienceConfiguration.PatienceConfig patienceConfig() {
        return PatienceConfiguration.patienceConfig$((PatienceConfiguration)this);
    }

    public PatienceConfiguration.Timeout timeout(Span value) {
        return PatienceConfiguration.timeout$((PatienceConfiguration)this, (Span)value);
    }

    public PatienceConfiguration.Interval interval(Span value) {
        return PatienceConfiguration.interval$((PatienceConfiguration)this, (Span)value);
    }

    public final Span scaled(Span span) {
        return ScaledTimeSpans.scaled$((ScaledTimeSpans)this, (Span)span);
    }

    public double spanScaleFactor() {
        return ScaledTimeSpans.spanScaleFactor$((ScaledTimeSpans)this);
    }

    public boolean enableAutoThreadAudit() {
        return this.enableAutoThreadAudit;
    }

    public void org$apache$spark$sql$test$SharedSparkSession$_setter_$enableAutoThreadAudit_$eq(boolean x$1) {
        this.enableAutoThreadAudit = x$1;
    }

    public TestSparkSession org$apache$spark$sql$test$SharedSparkSessionBase$$_spark() {
        return this.org$apache$spark$sql$test$SharedSparkSessionBase$$_spark;
    }

    public void org$apache$spark$sql$test$SharedSparkSessionBase$$_spark_$eq(TestSparkSession x$1) {
        this.org$apache$spark$sql$test$SharedSparkSessionBase$$_spark = x$1;
    }

    public boolean org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests() {
        return this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests;
    }

    public void org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests_$eq(boolean x$1) {
        this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests = x$1;
    }

    private Function1<String, Dataset<Row>> sql$lzycompute() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if ((this.bitmap$0 & 1) == 0) {
                this.sql = SQLTestUtilsBase.sql$((SQLTestUtilsBase)this);
                this.bitmap$0 |= 1;
            }
        }
        return this.sql;
    }

    public Function1<String, Dataset<Row>> sql() {
        return (this.bitmap$0 & 1) == 0 ? this.sql$lzycompute() : this.sql;
    }

    public SQLTestUtilsBase$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    public SQLTestData$internalImplicits$ org$apache$spark$sql$test$SQLTestData$$internalImplicits() {
        if (this.internalImplicits$module == null) {
            this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$lzycompute$1();
        }
        return this.internalImplicits$module;
    }

    private Dataset<Row> emptyTestData$lzycompute() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if ((this.bitmap$0 & 2) == 0) {
                this.emptyTestData = SQLTestData.emptyTestData$((SQLTestData)this);
                this.bitmap$0 |= 2;
            }
        }
        return this.emptyTestData;
    }

    public Dataset<Row> emptyTestData() {
        return (this.bitmap$0 & 2) == 0 ? this.emptyTestData$lzycompute() : this.emptyTestData;
    }

    private Dataset<Row> testData$lzycompute() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if ((this.bitmap$0 & 4) == 0) {
                this.testData = SQLTestData.testData$((SQLTestData)this);
                this.bitmap$0 |= 4;
            }
        }
        return this.testData;
    }

    public Dataset<Row> testData() {
        return (this.bitmap$0 & 4) == 0 ? this.testData$lzycompute() : this.testData;
    }

    private Dataset<Row> testData2$lzycompute() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if ((this.bitmap$0 & 8) == 0) {
                this.testData2 = SQLTestData.testData2$((SQLTestData)this);
                this.bitmap$0 |= 8;
            }
        }
        return this.testData2;
    }

    public Dataset<Row> testData2() {
        return (this.bitmap$0 & 8) == 0 ? this.testData2$lzycompute() : this.testData2;
    }

    private Dataset<Row> testData3$lzycompute() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.testData3 = SQLTestData.testData3$((SQLTestData)this);
                this.bitmap$0 |= 0x10;
            }
        }
        return this.testData3;
    }

    public Dataset<Row> testData3() {
        return (this.bitmap$0 & 0x10) == 0 ? this.testData3$lzycompute() : this.testData3;
    }

    private Dataset<Row> negativeData$lzycompute() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.negativeData = SQLTestData.negativeData$((SQLTestData)this);
                this.bitmap$0 |= 0x20;
            }
        }
        return this.negativeData;
    }

    public Dataset<Row> negativeData() {
        return (this.bitmap$0 & 0x20) == 0 ? this.negativeData$lzycompute() : this.negativeData;
    }

    private Dataset<Row> largeAndSmallInts$lzycompute() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.largeAndSmallInts = SQLTestData.largeAndSmallInts$((SQLTestData)this);
                this.bitmap$0 |= 0x40;
            }
        }
        return this.largeAndSmallInts;
    }

    public Dataset<Row> largeAndSmallInts() {
        return (this.bitmap$0 & 0x40) == 0 ? this.largeAndSmallInts$lzycompute() : this.largeAndSmallInts;
    }

    private Dataset<Row> decimalData$lzycompute() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.decimalData = SQLTestData.decimalData$((SQLTestData)this);
                this.bitmap$0 |= 0x80;
            }
        }
        return this.decimalData;
    }

    public Dataset<Row> decimalData() {
        return (this.bitmap$0 & 0x80) == 0 ? this.decimalData$lzycompute() : this.decimalData;
    }

    private Dataset<Row> binaryData$lzycompute() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.binaryData = SQLTestData.binaryData$((SQLTestData)this);
                this.bitmap$0 |= 0x100;
            }
        }
        return this.binaryData;
    }

    public Dataset<Row> binaryData() {
        return (this.bitmap$0 & 0x100) == 0 ? this.binaryData$lzycompute() : this.binaryData;
    }

    private Dataset<Row> upperCaseData$lzycompute() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if ((this.bitmap$0 & 0x200) == 0) {
                this.upperCaseData = SQLTestData.upperCaseData$((SQLTestData)this);
                this.bitmap$0 |= 0x200;
            }
        }
        return this.upperCaseData;
    }

    public Dataset<Row> upperCaseData() {
        return (this.bitmap$0 & 0x200) == 0 ? this.upperCaseData$lzycompute() : this.upperCaseData;
    }

    private Dataset<Row> lowerCaseData$lzycompute() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if ((this.bitmap$0 & 0x400) == 0) {
                this.lowerCaseData = SQLTestData.lowerCaseData$((SQLTestData)this);
                this.bitmap$0 |= 0x400;
            }
        }
        return this.lowerCaseData;
    }

    public Dataset<Row> lowerCaseData() {
        return (this.bitmap$0 & 0x400) == 0 ? this.lowerCaseData$lzycompute() : this.lowerCaseData;
    }

    private Dataset<Row> lowerCaseDataWithDuplicates$lzycompute() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if ((this.bitmap$0 & 0x800) == 0) {
                this.lowerCaseDataWithDuplicates = SQLTestData.lowerCaseDataWithDuplicates$((SQLTestData)this);
                this.bitmap$0 |= 0x800;
            }
        }
        return this.lowerCaseDataWithDuplicates;
    }

    public Dataset<Row> lowerCaseDataWithDuplicates() {
        return (this.bitmap$0 & 0x800) == 0 ? this.lowerCaseDataWithDuplicates$lzycompute() : this.lowerCaseDataWithDuplicates;
    }

    private RDD<SQLTestData.ArrayData> arrayData$lzycompute() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if ((this.bitmap$0 & 0x1000) == 0) {
                this.arrayData = SQLTestData.arrayData$((SQLTestData)this);
                this.bitmap$0 |= 0x1000;
            }
        }
        return this.arrayData;
    }

    public RDD<SQLTestData.ArrayData> arrayData() {
        return (this.bitmap$0 & 0x1000) == 0 ? this.arrayData$lzycompute() : this.arrayData;
    }

    private RDD<SQLTestData.MapData> mapData$lzycompute() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if ((this.bitmap$0 & 0x2000) == 0) {
                this.mapData = SQLTestData.mapData$((SQLTestData)this);
                this.bitmap$0 |= 0x2000;
            }
        }
        return this.mapData;
    }

    public RDD<SQLTestData.MapData> mapData() {
        return (this.bitmap$0 & 0x2000) == 0 ? this.mapData$lzycompute() : this.mapData;
    }

    private RDD<SQLTestData.IntervalData> calendarIntervalData$lzycompute() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if ((this.bitmap$0 & 0x4000) == 0) {
                this.calendarIntervalData = SQLTestData.calendarIntervalData$((SQLTestData)this);
                this.bitmap$0 |= 0x4000;
            }
        }
        return this.calendarIntervalData;
    }

    public RDD<SQLTestData.IntervalData> calendarIntervalData() {
        return (this.bitmap$0 & 0x4000) == 0 ? this.calendarIntervalData$lzycompute() : this.calendarIntervalData;
    }

    private RDD<SQLTestData.StringData> repeatedData$lzycompute() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if ((this.bitmap$0 & 0x8000) == 0) {
                this.repeatedData = SQLTestData.repeatedData$((SQLTestData)this);
                this.bitmap$0 |= 0x8000;
            }
        }
        return this.repeatedData;
    }

    public RDD<SQLTestData.StringData> repeatedData() {
        return (this.bitmap$0 & 0x8000) == 0 ? this.repeatedData$lzycompute() : this.repeatedData;
    }

    private RDD<SQLTestData.StringData> nullableRepeatedData$lzycompute() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if ((this.bitmap$0 & 0x10000) == 0) {
                this.nullableRepeatedData = SQLTestData.nullableRepeatedData$((SQLTestData)this);
                this.bitmap$0 |= 0x10000;
            }
        }
        return this.nullableRepeatedData;
    }

    public RDD<SQLTestData.StringData> nullableRepeatedData() {
        return (this.bitmap$0 & 0x10000) == 0 ? this.nullableRepeatedData$lzycompute() : this.nullableRepeatedData;
    }

    private Dataset<Row> nullInts$lzycompute() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if ((this.bitmap$0 & 0x20000) == 0) {
                this.nullInts = SQLTestData.nullInts$((SQLTestData)this);
                this.bitmap$0 |= 0x20000;
            }
        }
        return this.nullInts;
    }

    public Dataset<Row> nullInts() {
        return (this.bitmap$0 & 0x20000) == 0 ? this.nullInts$lzycompute() : this.nullInts;
    }

    private Dataset<Row> allNulls$lzycompute() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if ((this.bitmap$0 & 0x40000) == 0) {
                this.allNulls = SQLTestData.allNulls$((SQLTestData)this);
                this.bitmap$0 |= 0x40000;
            }
        }
        return this.allNulls;
    }

    public Dataset<Row> allNulls() {
        return (this.bitmap$0 & 0x40000) == 0 ? this.allNulls$lzycompute() : this.allNulls;
    }

    private Dataset<Row> nullStrings$lzycompute() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if ((this.bitmap$0 & 0x80000) == 0) {
                this.nullStrings = SQLTestData.nullStrings$((SQLTestData)this);
                this.bitmap$0 |= 0x80000;
            }
        }
        return this.nullStrings;
    }

    public Dataset<Row> nullStrings() {
        return (this.bitmap$0 & 0x80000) == 0 ? this.nullStrings$lzycompute() : this.nullStrings;
    }

    private Dataset<Row> tableName$lzycompute() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if ((this.bitmap$0 & 0x100000) == 0) {
                this.tableName = SQLTestData.tableName$((SQLTestData)this);
                this.bitmap$0 |= 0x100000;
            }
        }
        return this.tableName;
    }

    public Dataset<Row> tableName() {
        return (this.bitmap$0 & 0x100000) == 0 ? this.tableName$lzycompute() : this.tableName;
    }

    private RDD<String> unparsedStrings$lzycompute() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if ((this.bitmap$0 & 0x200000) == 0) {
                this.unparsedStrings = SQLTestData.unparsedStrings$((SQLTestData)this);
                this.bitmap$0 |= 0x200000;
            }
        }
        return this.unparsedStrings;
    }

    public RDD<String> unparsedStrings() {
        return (this.bitmap$0 & 0x200000) == 0 ? this.unparsedStrings$lzycompute() : this.unparsedStrings;
    }

    private RDD<SQLTestData.IntField> withEmptyParts$lzycompute() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if ((this.bitmap$0 & 0x400000) == 0) {
                this.withEmptyParts = SQLTestData.withEmptyParts$((SQLTestData)this);
                this.bitmap$0 |= 0x400000;
            }
        }
        return this.withEmptyParts;
    }

    public RDD<SQLTestData.IntField> withEmptyParts() {
        return (this.bitmap$0 & 0x400000) == 0 ? this.withEmptyParts$lzycompute() : this.withEmptyParts;
    }

    private Dataset<Row> person$lzycompute() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if ((this.bitmap$0 & 0x800000) == 0) {
                this.person = SQLTestData.person$((SQLTestData)this);
                this.bitmap$0 |= 0x800000;
            }
        }
        return this.person;
    }

    public Dataset<Row> person() {
        return (this.bitmap$0 & 0x800000) == 0 ? this.person$lzycompute() : this.person;
    }

    private Dataset<Row> salary$lzycompute() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if ((this.bitmap$0 & 0x1000000) == 0) {
                this.salary = SQLTestData.salary$((SQLTestData)this);
                this.bitmap$0 |= 0x1000000;
            }
        }
        return this.salary;
    }

    public Dataset<Row> salary() {
        return (this.bitmap$0 & 0x1000000) == 0 ? this.salary$lzycompute() : this.salary;
    }

    private Dataset<Row> complexData$lzycompute() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if ((this.bitmap$0 & 0x2000000) == 0) {
                this.complexData = SQLTestData.complexData$((SQLTestData)this);
                this.bitmap$0 |= 0x2000000;
            }
        }
        return this.complexData;
    }

    public Dataset<Row> complexData() {
        return (this.bitmap$0 & 0x2000000) == 0 ? this.complexData$lzycompute() : this.complexData;
    }

    private Dataset<Row> courseSales$lzycompute() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if ((this.bitmap$0 & 0x4000000) == 0) {
                this.courseSales = SQLTestData.courseSales$((SQLTestData)this);
                this.bitmap$0 |= 0x4000000;
            }
        }
        return this.courseSales;
    }

    public Dataset<Row> courseSales() {
        return (this.bitmap$0 & 0x4000000) == 0 ? this.courseSales$lzycompute() : this.courseSales;
    }

    private Dataset<Row> trainingSales$lzycompute() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if ((this.bitmap$0 & 0x8000000) == 0) {
                this.trainingSales = SQLTestData.trainingSales$((SQLTestData)this);
                this.bitmap$0 |= 0x8000000;
            }
        }
        return this.trainingSales;
    }

    public Dataset<Row> trainingSales() {
        return (this.bitmap$0 & 0x8000000) == 0 ? this.trainingSales$lzycompute() : this.trainingSales;
    }

    private Dataset<Row> intervalData$lzycompute() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if ((this.bitmap$0 & 0x10000000) == 0) {
                this.intervalData = SQLTestData.intervalData$((SQLTestData)this);
                this.bitmap$0 |= 0x10000000;
            }
        }
        return this.intervalData;
    }

    public Dataset<Row> intervalData() {
        return (this.bitmap$0 & 0x10000000) == 0 ? this.intervalData$lzycompute() : this.intervalData;
    }

    public AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig() {
        return this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    }

    public final void org$scalatest$concurrent$PatienceConfiguration$_setter_$org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig_$eq(AbstractPatienceConfiguration.PatienceConfig x$1) {
        this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig = x$1;
    }

    public AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig() {
        if (this.PatienceConfig$module == null) {
            this.PatienceConfig$lzycompute$1();
        }
        return this.PatienceConfig$module;
    }

    public String dateSchema() {
        return this.dateSchema;
    }

    public Seq<Object> dateInputData() {
        return this.dateInputData;
    }

    public String dateFile(String path) {
        Schema schema = new Schema.Parser().parse(this.dateSchema());
        GenericDatumWriter datumWriter = new GenericDatumWriter(schema);
        DataFileWriter dataFileWriter = new DataFileWriter((DatumWriter)datumWriter);
        String result = new StringBuilder(10).append(path).append("/test.avro").toString();
        dataFileWriter.create(schema, new File(result));
        this.dateInputData().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x -> {
            GenericData.Record record = new GenericData.Record(schema);
            record.put("date", (Object)BoxesRunTime.boxToInteger((int)x));
            dataFileWriter.append((Object)record);
        });
        dataFileWriter.flush();
        dataFileWriter.close();
        return result;
    }

    public String timestampSchema() {
        return this.timestampSchema;
    }

    public Seq<Tuple3<Object, Object, Object>> timestampInputData() {
        return this.timestampInputData;
    }

    public String timestampFile(String path) {
        Schema schema = new Schema.Parser().parse(this.timestampSchema());
        GenericDatumWriter datumWriter = new GenericDatumWriter(schema);
        DataFileWriter dataFileWriter = new DataFileWriter((DatumWriter)datumWriter);
        String result = new StringBuilder(10).append(path).append("/test.avro").toString();
        dataFileWriter.create(schema, new File(result));
        this.timestampInputData().foreach((Function1 & Serializable & scala.Serializable)t -> {
            AvroLogicalTypeSuite.$anonfun$timestampFile$1(schema, dataFileWriter, t);
            return BoxedUnit.UNIT;
        });
        dataFileWriter.flush();
        dataFileWriter.close();
        return result;
    }

    public Seq<String> decimalInputData() {
        return this.decimalInputData;
    }

    public Tuple2<String, String> decimalSchemaAndFile(String path) {
        int precision = 4;
        int scale = 2;
        String bytesFieldName = "bytes";
        String bytesSchema = new StringBuilder(114).append("{\n         \"type\":\"bytes\",\n         \"logicalType\":\"decimal\",\n         \"precision\":").append(precision).append(",\n         \"scale\":").append(scale).append("\n      }\n    ").toString();
        String fixedFieldName = "fixed";
        String fixedSchema = new StringBuilder(156).append("{\n         \"type\":\"fixed\",\n         \"size\":5,\n         \"logicalType\":\"decimal\",\n         \"precision\":").append(precision).append(",\n         \"scale\":").append(scale).append(",\n         \"name\":\"foo\"\n      }\n    ").toString();
        String avroSchema = new StringBuilder(200).append("\n      {\n        \"namespace\": \"logical\",\n        \"type\": \"record\",\n        \"name\": \"test\",\n        \"fields\": [\n          {\"name\": \"").append(bytesFieldName).append("\", \"type\": ").append(bytesSchema).append("},\n          {\"name\": \"").append(fixedFieldName).append("\", \"type\": ").append(fixedSchema).append("}\n        ]\n      }\n    ").toString();
        Schema schema = new Schema.Parser().parse(avroSchema);
        GenericDatumWriter datumWriter = new GenericDatumWriter(schema);
        DataFileWriter dataFileWriter = new DataFileWriter((DatumWriter)datumWriter);
        Conversions.DecimalConversion decimalConversion = new Conversions.DecimalConversion();
        String avroFile = new StringBuilder(10).append(path).append("/test.avro").toString();
        dataFileWriter.create(schema, new File(avroFile));
        LogicalTypes.Decimal logicalType = LogicalTypes.decimal((int)precision, (int)scale);
        this.decimalInputData().foreach((Function1 & Serializable & scala.Serializable)x -> {
            AvroLogicalTypeSuite.$anonfun$decimalSchemaAndFile$1(schema, scale, decimalConversion, bytesFieldName, logicalType, fixedFieldName, dataFileWriter, x);
            return BoxedUnit.UNIT;
        });
        dataFileWriter.flush();
        dataFileWriter.close();
        return new Tuple2((Object)avroSchema, (Object)avroFile);
    }

    private final void testImplicits$lzycompute$1() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new SQLTestUtilsBase$testImplicits$((SQLTestUtilsBase)this);
            }
        }
    }

    private final void org$apache$spark$sql$test$SQLTestData$$internalImplicits$lzycompute$1() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if (this.internalImplicits$module == null) {
                this.internalImplicits$module = new SQLTestData$internalImplicits$((SQLTestData)this);
            }
        }
    }

    private final void PatienceConfig$lzycompute$1() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if (this.PatienceConfig$module == null) {
                this.PatienceConfig$module = new AbstractPatienceConfiguration$PatienceConfig$((AbstractPatienceConfiguration)this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$new$6(AvroLogicalTypeSuite $this, Dataset df$1, Seq expected$1, File path) {
        df$1.write().format("avro").save(path.toString());
        $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().read().format("avro").load(path.toString()), expected$1);
    }

    public static final /* synthetic */ void $anonfun$new$2(AvroLogicalTypeSuite $this, File dir) {
        Seq expected = (Seq)$this.dateInputData().map((Function1 & Serializable & scala.Serializable)t -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DateTimeUtils$.MODULE$.toJavaDate(BoxesRunTime.unboxToInt((Object)t))})), Seq$.MODULE$.canBuildFrom());
        String dateAvro = $this.dateFile(dir.getAbsolutePath());
        Dataset df = $this.spark().read().format("avro").load(dateAvro);
        $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> df, expected);
        $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().read().format("avro").option("avroSchema", $this.dateSchema()).load(dateAvro), expected);
        $this.withTempPath((Function1 & Serializable & scala.Serializable)path -> {
            AvroLogicalTypeSuite.$anonfun$new$6($this, df, expected, path);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$timestampFile$1(Schema schema$2, DataFileWriter dataFileWriter$2, Tuple3 t) {
        GenericData.Record record = new GenericData.Record(schema$2);
        record.put("timestamp_millis", t._1());
        record.put("timestamp_micros", (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)t._2()) * 1000L)));
        record.put("long", t._3());
        dataFileWriter$2.append((Object)record);
    }

    public static final /* synthetic */ void $anonfun$new$12(AvroLogicalTypeSuite $this, Dataset df$2, Seq expected$2, File path) {
        df$2.write().format("avro").save(path.toString());
        $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().read().format("avro").load(path.toString()), expected$2);
    }

    public static final /* synthetic */ void $anonfun$new$9(AvroLogicalTypeSuite $this, File dir) {
        Seq expected = (Seq)$this.timestampInputData().map((Function1 & Serializable & scala.Serializable)t -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new Timestamp(BoxesRunTime.unboxToLong((Object)t._1()))})), Seq$.MODULE$.canBuildFrom());
        String timestampAvro = $this.timestampFile(dir.getAbsolutePath());
        Dataset df = $this.spark().read().format("avro").load(timestampAvro).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{$this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "timestamp_millis"))}));
        $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> df, expected);
        $this.withTempPath((Function1 & Serializable & scala.Serializable)path -> {
            AvroLogicalTypeSuite.$anonfun$new$12($this, df, expected, path);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$18(AvroLogicalTypeSuite $this, Dataset df$3, Seq expected$3, File path) {
        df$3.write().format("avro").save(path.toString());
        $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().read().format("avro").load(path.toString()), expected$3);
    }

    public static final /* synthetic */ void $anonfun$new$15(AvroLogicalTypeSuite $this, File dir) {
        Seq expected = (Seq)$this.timestampInputData().map((Function1 & Serializable & scala.Serializable)t -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new Timestamp(BoxesRunTime.unboxToLong((Object)t._2()))})), Seq$.MODULE$.canBuildFrom());
        String timestampAvro = $this.timestampFile(dir.getAbsolutePath());
        Dataset df = $this.spark().read().format("avro").load(timestampAvro).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{$this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "timestamp_micros"))}));
        $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> df, expected);
        $this.withTempPath((Function1 & Serializable & scala.Serializable)path -> {
            AvroLogicalTypeSuite.$anonfun$new$18($this, df, expected, path);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$23(AvroLogicalTypeSuite $this, Dataset df$4, String userSpecifiedTimestampSchema$1, Seq expected$4, File path) {
        df$4.write().format("avro").option("avroSchema", userSpecifiedTimestampSchema$1).save(path.toString());
        $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().read().format("avro").load(path.toString()), expected$4);
    }

    public static final /* synthetic */ void $anonfun$new$21(AvroLogicalTypeSuite $this, File dir) {
        String timestampAvro = $this.timestampFile(dir.getAbsolutePath());
        Dataset df = $this.spark().read().format("avro").load(timestampAvro).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{$this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "timestamp_millis")), $this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "timestamp_micros"))}));
        Seq expected = (Seq)$this.timestampInputData().map((Function1 & Serializable & scala.Serializable)t -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new Timestamp(BoxesRunTime.unboxToLong((Object)t._1())), new Timestamp(BoxesRunTime.unboxToLong((Object)t._2()))})), Seq$.MODULE$.canBuildFrom());
        String userSpecifiedTimestampSchema = "\n      {\n        \"namespace\": \"logical\",\n        \"type\": \"record\",\n        \"name\": \"test\",\n        \"fields\": [\n          {\"name\": \"timestamp_millis\",\n            \"type\": [{\"type\": \"long\",\"logicalType\": \"timestamp-micros\"}, \"null\"]},\n          {\"name\": \"timestamp_micros\",\n            \"type\": [{\"type\": \"long\",\"logicalType\": \"timestamp-millis\"}, \"null\"]}\n        ]\n      }\n    ";
        $this.withTempPath((Function1 & Serializable & scala.Serializable)path -> {
            AvroLogicalTypeSuite.$anonfun$new$23($this, df, userSpecifiedTimestampSchema, expected, path);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$26(AvroLogicalTypeSuite $this, File dir) {
        String timestampAvro = $this.timestampFile(dir.getAbsolutePath());
        StructField structField = new StructField("long", (DataType)TimestampType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructType schema = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField));
        Dataset df = $this.spark().read().format("avro").schema(schema).load(timestampAvro).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{$this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "long"))}));
        Seq expected = (Seq)$this.timestampInputData().map((Function1 & Serializable & scala.Serializable)t -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new Timestamp(BoxesRunTime.unboxToLong((Object)t._3()))})), Seq$.MODULE$.canBuildFrom());
        $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> df, expected);
    }

    public static final /* synthetic */ void $anonfun$new$30(AvroLogicalTypeSuite $this, File dir) {
        String timestampAvro = $this.timestampFile(dir.getAbsolutePath());
        Seq expected = (Seq)$this.timestampInputData().map((Function1 & Serializable & scala.Serializable)t -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new Timestamp(BoxesRunTime.unboxToLong((Object)t._1())), new Timestamp(BoxesRunTime.unboxToLong((Object)t._2())), t._3()})), Seq$.MODULE$.canBuildFrom());
        Dataset df = $this.spark().read().format("avro").option("avroSchema", $this.timestampSchema()).load(timestampAvro);
        $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> df, expected);
    }

    public static final /* synthetic */ void $anonfun$decimalSchemaAndFile$1(Schema schema$3, int scale$1, Conversions.DecimalConversion decimalConversion$1, String bytesFieldName$1, LogicalTypes.Decimal logicalType$1, String fixedFieldName$1, DataFileWriter dataFileWriter$3, String x) {
        GenericData.Record avroRec = new GenericData.Record(schema$3);
        BigDecimal decimal = new BigDecimal(x).setScale(scale$1);
        ByteBuffer bytes = decimalConversion$1.toBytes(decimal, schema$3.getField(bytesFieldName$1).schema(), (LogicalType)logicalType$1);
        avroRec.put(bytesFieldName$1, (Object)bytes);
        GenericFixed fixed = decimalConversion$1.toFixed(decimal, schema$3.getField(fixedFieldName$1).schema(), (LogicalType)logicalType$1);
        avroRec.put(fixedFieldName$1, (Object)fixed);
        dataFileWriter$3.append((Object)avroRec);
    }

    public static final /* synthetic */ void $anonfun$new$38(AvroLogicalTypeSuite $this, Dataset df$7, Seq expected$5, File path) {
        df$7.write().format("avro").save(path.toString());
        $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().read().format("avro").load(path.toString()), expected$5);
    }

    public static final /* synthetic */ void $anonfun$new$34(AvroLogicalTypeSuite $this, File dir) {
        Tuple2<String, String> tuple2 = $this.decimalSchemaAndFile(dir.getAbsolutePath());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String avroSchema = (String)tuple2._1();
        String avroFile = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)avroSchema, (Object)avroFile);
        Tuple2 tuple23 = tuple22;
        String avroSchema2 = (String)tuple23._1();
        String avroFile2 = (String)tuple23._2();
        Seq expected = (Seq)$this.decimalInputData().map((Function1 & Serializable & scala.Serializable)x -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new BigDecimal((String)x), new BigDecimal((String)x)})), Seq$.MODULE$.canBuildFrom());
        Dataset df = $this.spark().read().format("avro").load(avroFile2);
        $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> df, expected);
        $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().read().format("avro").option("avroSchema", avroSchema2).load(avroFile2), expected);
        $this.withTempPath((Function1 & Serializable & scala.Serializable)path -> {
            AvroLogicalTypeSuite.$anonfun$new$38($this, df, expected, path);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$43(AvroLogicalTypeSuite $this, Dataset df$8, String specifiedSchema$1, Seq expected$6, File path) {
        df$8.write().format("avro").option("avroSchema", specifiedSchema$1).save(path.toString());
        $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().read().format("avro").load(path.toString()), expected$6);
    }

    public static final /* synthetic */ void $anonfun$new$41(AvroLogicalTypeSuite $this, String specifiedSchema$1, File dir) {
        Tuple2<String, String> tuple2 = $this.decimalSchemaAndFile(dir.getAbsolutePath());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String avroSchema = (String)tuple2._1();
        String avroFile = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)avroSchema, (Object)avroFile);
        Tuple2 tuple23 = tuple22;
        String avroSchema2 = (String)tuple23._1();
        String avroFile2 = (String)tuple23._2();
        String $org_scalatest_assert_macro_left = specifiedSchema$1;
        String $org_scalatest_assert_macro_right = avroSchema2;
        String string = $org_scalatest_assert_macro_left;
        String string2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", (Object)$org_scalatest_assert_macro_right, string == null ? string2 != null : !string.equals(string2), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AvroLogicalTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 311));
        Seq expected = (Seq)$this.decimalInputData().map((Function1 & Serializable & scala.Serializable)x -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new BigDecimal((String)x), new BigDecimal((String)x)})), Seq$.MODULE$.canBuildFrom());
        Dataset df = $this.spark().read().format("avro").load(avroFile2);
        $this.withTempPath((Function1 & Serializable & scala.Serializable)path -> {
            AvroLogicalTypeSuite.$anonfun$new$43($this, df, specifiedSchema$1, expected, path);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$46(AvroLogicalTypeSuite $this, File dir) {
        String msg;
        Schema schema = new Schema.Parser().parse("{\n        \"namespace\": \"logical\",\n        \"type\": \"record\",\n        \"name\": \"test\",\n        \"fields\": [{\n          \"name\": \"decimal\",\n          \"type\": {\"type\": \"bytes\", \"logicalType\": \"decimal\", \"precision\": 4, \"scale\": 2}\n        }]\n      }");
        GenericDatumWriter datumWriter = new GenericDatumWriter(schema);
        DataFileWriter dataFileWriter = new DataFileWriter((DatumWriter)datumWriter);
        dataFileWriter.create(schema, new File(new StringBuilder(5).append(dir).append(".avro").toString()));
        GenericData.Record avroRec = new GenericData.Record(schema);
        BigDecimal decimal = new BigDecimal("0.12345678901234567890123456789012345678");
        ByteBuffer bytes = new Conversions.DecimalConversion().toBytes(decimal, schema, (LogicalType)LogicalTypes.decimal((int)39, (int)38));
        avroRec.put("decimal", (Object)bytes);
        dataFileWriter.append((Object)avroRec);
        dataFileWriter.flush();
        dataFileWriter.close();
        String $org_scalatest_assert_macro_left = msg = ((Throwable)$this.intercept((Function0 & Serializable & scala.Serializable)() -> (Row[])$this.spark().read().format("avro").load(new StringBuilder(5).append(dir).append(".avro").toString()).collect(), ClassTag$.MODULE$.apply(SparkException.class), new Position("AvroLogicalTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 345))).getCause().getMessage();
        String $org_scalatest_assert_macro_right = "Unscaled value too large for precision";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AvroLogicalTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 348));
    }

    public AvroLogicalTypeSuite() {
        ScaledTimeSpans.$init$((ScaledTimeSpans)this);
        AbstractPatienceConfiguration.$init$((AbstractPatienceConfiguration)this);
        PatienceConfiguration.$init$((PatienceConfiguration)this);
        Eventually.$init$((Eventually)this);
        SQLTestData.$init$((SQLTestData)this);
        SQLTestUtilsBase.$init$((SQLTestUtilsBase)this);
        SQLTestUtils.$init$((SQLTestUtils)this);
        SharedSparkSessionBase.$init$((SharedSparkSessionBase)this);
        SharedSparkSession.$init$((SharedSparkSession)this);
        this.dateSchema = "\n      {\n        \"namespace\": \"logical\",\n        \"type\": \"record\",\n        \"name\": \"test\",\n        \"fields\": [\n          {\"name\": \"date\", \"type\": {\"type\": \"int\", \"logicalType\": \"date\"}}\n        ]\n      }\n    ";
        this.dateInputData = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 365, 0}));
        this.test("Logical type: date", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            AvroLogicalTypeSuite.$anonfun$new$2(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("AvroLogicalTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
        this.timestampSchema = "\n      {\n        \"namespace\": \"logical\",\n        \"type\": \"record\",\n        \"name\": \"test\",\n        \"fields\": [\n          {\"name\": \"timestamp_millis\", \"type\": {\"type\": \"long\",\"logicalType\": \"timestamp-millis\"}},\n          {\"name\": \"timestamp_micros\", \"type\": {\"type\": \"long\",\"logicalType\": \"timestamp-micros\"}},\n          {\"name\": \"long\", \"type\": \"long\"}\n        ]\n      }\n    ";
        this.timestampInputData = (Seq)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)1000L), (Object)BoxesRunTime.boxToLong((long)2000L), (Object)BoxesRunTime.boxToLong((long)3000L)), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)666000L), (Object)BoxesRunTime.boxToLong((long)999000L), (Object)BoxesRunTime.boxToLong((long)777000L)), (List)Nil$.MODULE$));
        this.test("Logical type: timestamp_millis", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            AvroLogicalTypeSuite.$anonfun$new$9(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("AvroLogicalTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
        this.test("Logical type: timestamp_micros", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            AvroLogicalTypeSuite.$anonfun$new$15(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("AvroLogicalTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
        this.test("Logical type: user specified output schema with different timestamp types", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            AvroLogicalTypeSuite.$anonfun$new$21(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("AvroLogicalTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
        this.test("Read Long type as Timestamp", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            AvroLogicalTypeSuite.$anonfun$new$26(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("AvroLogicalTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
        this.test("Logical type: user specified read schema", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            AvroLogicalTypeSuite.$anonfun$new$30(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("AvroLogicalTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
        this.decimalInputData = (Seq)new .colon.colon((Object)"1.23", (List)new .colon.colon((Object)"4.56", (List)new .colon.colon((Object)"78.90", (List)new .colon.colon((Object)"-1", (List)new .colon.colon((Object)"-2.31", (List)Nil$.MODULE$)))));
        this.test("Logical type: Decimal", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            AvroLogicalTypeSuite.$anonfun$new$34(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("AvroLogicalTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 266));
        this.test("Logical type: write Decimal with BYTES type", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String specifiedSchema = "\n      {\n        \"type\" : \"record\",\n        \"name\" : \"topLevelRecord\",\n        \"namespace\" : \"topLevelRecord\",\n        \"fields\" : [ {\n          \"name\" : \"bytes\",\n          \"type\" : [ {\n            \"type\" : \"bytes\",\n            \"namespace\" : \"topLevelRecord.bytes\",\n            \"logicalType\" : \"decimal\",\n            \"precision\" : 4,\n            \"scale\" : 2\n          }, \"null\" ]\n        }, {\n          \"name\" : \"fixed\",\n          \"type\" : [ {\n            \"type\" : \"bytes\",\n            \"logicalType\" : \"decimal\",\n            \"precision\" : 4,\n            \"scale\" : 2\n          }, \"null\" ]\n        } ]\n      }\n    ";
            this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
                AvroLogicalTypeSuite.$anonfun$new$41(this, specifiedSchema, dir);
                return BoxedUnit.UNIT;
            });
        }, new Position("AvroLogicalTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 283));
        this.test("Logical type: Decimal with too large precision", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            AvroLogicalTypeSuite.$anonfun$new$46(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("AvroLogicalTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 323));
    }
}

