/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.s3a;

import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URI;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ScalaSignature;
import scala.runtime.LambdaDeserialize;
import scala.util.Properties$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ma\u0001B\r\u001b\u0001\rB\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006I!\u0010\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005\t\")1\n\u0001C\u0001\u0019\"9\u0011\u000b\u0001b\u0001\n\u0013\u0011\u0006B\u0002,\u0001A\u0003%1\u000bC\u0004X\u0001\t\u0007I\u0011\u0002*\t\ra\u0003\u0001\u0015!\u0003T\u0011\u001dI\u0006A1A\u0005\nICaA\u0017\u0001!\u0002\u0013\u0019\u0006bB.\u0001\u0005\u0004%IA\u0015\u0005\u00079\u0002\u0001\u000b\u0011B*\t\u000fu\u0003\u0001\u0019!C\u0005%\"9a\f\u0001a\u0001\n\u0013y\u0006B\u00025\u0001A\u0003&1\u000bC\u0004j\u0001\u0001\u0007I\u0011\u0002*\t\u000f)\u0004\u0001\u0019!C\u0005W\"1Q\u000e\u0001Q!\nMCQA\u001c\u0001\u0005B=DQa\u001d\u0001\u0005BQDQ!\u001e\u0001\u0005\nYDa!a\u0001\u0001\t\u00131\bbBA\u0003\u0001\u0011%\u0011q\u0001\u0005\u0007\u0003\u001b\u0001A\u0011\u0002;\t\u000f\u0005=\u0001\u0001\"\u0003\u0002\u0012\taRI_*qCJ\\\u0017iV*De\u0016$WM\u001c;jC2\u0004&o\u001c<jI\u0016\u0014(BA\u000e\u001d\u0003\r\u00198'\u0019\u0006\u0003;y\tQa\u001d9be.T!a\b\u0011\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0013aA8sO\u000e\u00011\u0003\u0002\u0001%YY\u0002\"!\n\u0016\u000e\u0003\u0019R!a\n\u0015\u0002\t1\fgn\u001a\u0006\u0002S\u0005!!.\u0019<b\u0013\tYcE\u0001\u0004PE*,7\r\u001e\t\u0003[Qj\u0011A\f\u0006\u0003_A\nA!Y;uQ*\u0011\u0011GM\u0001\nC6\f'p\u001c8boNT\u0011aM\u0001\u0004G>l\u0017BA\u001b/\u0005Y\tukU\"sK\u0012,g\u000e^5bYN\u0004&o\u001c<jI\u0016\u0014\bCA\u001c;\u001b\u0005A$BA\u001d\u001d\u0003!Ig\u000e^3s]\u0006d\u0017BA\u001e9\u0005\u001daunZ4j]\u001e\f1!\u001e:j!\tq\u0014)D\u0001@\u0015\t\u0001\u0005&A\u0002oKRL!AQ \u0003\u0007U\u0013\u0016*\u0001\u0003d_:4\u0007CA#J\u001b\u00051%BA\"H\u0015\tAe$\u0001\u0004iC\u0012|w\u000e]\u0005\u0003\u0015\u001a\u0013QbQ8oM&<WO]1uS>t\u0017A\u0002\u001fj]&$h\bF\u0002N\u001fB\u0003\"A\u0014\u0001\u000e\u0003iAQ\u0001P\u0002A\u0002uBQaQ\u0002A\u0002\u0011\u000b1cS3z\u0019>\u001c\u0017\r^5p]B\u0013x\u000e]3sif,\u0012a\u0015\t\u0003KQK!!\u0016\u0014\u0003\rM#(/\u001b8h\u0003QYU-\u001f'pG\u0006$\u0018n\u001c8Qe>\u0004XM\u001d;zA\u0005AB)\u001a4bk2$\u0018iY2fgN\\U-\u001f'pG\u0006$\u0018n\u001c8\u00023\u0011+g-Y;mi\u0006\u001b7-Z:t\u0017\u0016LHj\\2bi&|g\u000eI\u0001 '\u0016\u0014h/[2f\u0003\u000e\u001cw.\u001e8u\u0003\u000e\u001cWm]:LKfdunY1uS>t\u0017\u0001I*feZL7-Z!dG>,h\u000e^!dG\u0016\u001c8oS3z\u0019>\u001c\u0017\r^5p]\u0002\n\u0001\u0004R3gCVdGoU3de\u0016$8*Z=M_\u000e\fG/[8o\u0003e!UMZ1vYR\u001cVm\u0019:fi.+\u0017\u0010T8dCRLwN\u001c\u0011\u0002\u0013\u0005\u001c7-Z:t\u0017\u0016L\u0018!D1dG\u0016\u001c8oS3z?\u0012*\u0017\u000f\u0006\u0002aMB\u0011\u0011\rZ\u0007\u0002E*\t1-A\u0003tG\u0006d\u0017-\u0003\u0002fE\n!QK\\5u\u0011\u001d9W\"!AA\u0002M\u000b1\u0001\u001f\u00132\u0003)\t7mY3tg.+\u0017\u0010I\u0001\ng\u0016\u001c'/\u001a;LKf\fQb]3de\u0016$8*Z=`I\u0015\fHC\u00011m\u0011\u001d9\u0007#!AA\u0002M\u000b!b]3de\u0016$8*Z=!\u000399W\r^\"sK\u0012,g\u000e^5bYN$\u0012\u0001\u001d\t\u0003[EL!A\u001d\u0018\u0003\u001d\u0005;6k\u0011:fI\u0016tG/[1mg\u00069!/\u001a4sKNDG#\u00011\u0002'\u001d,G/\u00169eCR,G-Q2dKN\u001c8*Z=\u0015\u0003]\u0004\"\u0001_@\u000f\u0005el\bC\u0001>c\u001b\u0005Y(B\u0001?#\u0003\u0019a$o\\8u}%\u0011aPY\u0001\u0007!J,G-\u001a4\n\u0007U\u000b\tA\u0003\u0002\u007fE\u0006\u0019r-\u001a;Va\u0012\fG/\u001a3TK\u000e\u0014X\r^&fs\u0006\u0011r-\u001a;LKf4%o\\7M_\u000e\fG/[8o)\r9\u0018\u0011\u0002\u0005\u0007\u0003\u00171\u0002\u0019A<\u0002\u0017-,\u0017\u0010T8dCRLwN\\\u0001\u0016gR\f'\u000f^&fsV\u0003H-\u0019;f\u001b>t\u0017\u000e^8s\u0003Q9W\r^!dG\u0016\u001c8oS3z\u0019>\u001c\u0017\r^5p]V\tq\u000f")
public class EzSparkAWSCredentialProvider
implements AWSCredentialsProvider,
Logging {
    private final Configuration conf;
    private final String KeyLocationProperty;
    private final String DefaultAccessKeyLocation;
    private final String ServiceAccountAccessKeyLocation;
    private final String DefaultSecretKeyLocation;
    private String accessKey;
    private String secretKey;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private String KeyLocationProperty() {
        return this.KeyLocationProperty;
    }

    private String DefaultAccessKeyLocation() {
        return this.DefaultAccessKeyLocation;
    }

    private String ServiceAccountAccessKeyLocation() {
        return this.ServiceAccountAccessKeyLocation;
    }

    private String DefaultSecretKeyLocation() {
        return this.DefaultSecretKeyLocation;
    }

    private String accessKey() {
        return this.accessKey;
    }

    private void accessKey_$eq(String x$1) {
        this.accessKey = x$1;
    }

    private String secretKey() {
        return this.secretKey;
    }

    private void secretKey_$eq(String x$1) {
        this.secretKey = x$1;
    }

    public AWSCredentials getCredentials() {
        return new BasicAWSCredentials(this.accessKey(), this.secretKey());
    }

    public void refresh() {
        this.accessKey_$eq(this.getUpdatedAccessKey());
        this.secretKey_$eq(this.getUpdatedSecretKey());
    }

    private String getUpdatedAccessKey() {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Updating accessKey");
        String accessKeyLocation = this.getAccessKeyLocation();
        accessKeyLocation = Properties$.MODULE$.envOrElse("AWS_ACCESS_KEY_LOCATION", accessKeyLocation);
        accessKeyLocation = this.conf.getTrimmed(this.KeyLocationProperty(), accessKeyLocation);
        return this.getKeyFromLocation(accessKeyLocation);
    }

    private String getUpdatedSecretKey() {
        String string;
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Updating secretKey");
        String secretKeyLocation = Properties$.MODULE$.envOrElse("AWS_SECRET_KEY_LOCATION", this.DefaultSecretKeyLocation());
        try {
            string = this.getKeyFromLocation(secretKeyLocation);
        }
        catch (AmazonClientException amazonClientException) {
            string = "defaultSecretKeyValue";
        }
        return string;
    }

    private String getKeyFromLocation(String keyLocation) {
        String string;
        if (keyLocation.isEmpty()) {
            throw new AmazonClientException("Key path is not set");
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Reading key from location: ").append(keyLocation).toString());
        try (BufferedSource keySource = Source$.MODULE$.fromFile(keyLocation, Codec$.MODULE$.fallbackSystemCodec());){
            string = keySource.mkString().trim();
        }
        return string;
    }

    private void startKeyUpdateMonitor() {
        String accessKeyLocation = Properties$.MODULE$.envOrElse("AWS_ACCESS_KEY_LOCATION", this.DefaultAccessKeyLocation());
        File accessKeyFile = new File(accessKeyLocation);
        FileAlterationObserver observer = new FileAlterationObserver(accessKeyFile.getParent());
        observer.addListener(new FileAlterationListener(this, accessKeyFile){
            private final /* synthetic */ EzSparkAWSCredentialProvider $outer;
            private final File accessKeyFile$1;

            public void onFileChange(File file) {
                String string = file.getName();
                String string2 = this.accessKeyFile$1.getName();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    this.$outer.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Access key file changed: ").append(file.getName()).toString());
                    this.$outer.refresh();
                    return;
                }
            }

            public void onFileCreate(File file) {
                String string = file.getName();
                String string2 = this.accessKeyFile$1.getName();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    this.$outer.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Access key file created: ").append(file.getName()).toString());
                    this.$outer.refresh();
                    return;
                }
            }

            public void onFileDelete(File file) {
            }

            public void onDirectoryChange(File directory) {
            }

            public void onDirectoryCreate(File directory) {
            }

            public void onDirectoryDelete(File directory) {
            }

            public void onStart(FileAlterationObserver observer) {
            }

            public void onStop(FileAlterationObserver observer) {
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.accessKeyFile$1 = accessKeyFile$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onFileChange$1(java.io.File ), $anonfun$onFileCreate$1(java.io.File )}, serializedLambda);
            }
        });
        FileAlterationMonitor monitor = new FileAlterationMonitor(10000L, new FileAlterationObserver[]{observer});
        try {
            monitor.start();
        }
        catch (Exception e) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error starting file monitor", e);
        }
    }

    private String getAccessKeyLocation() {
        if (new File(this.DefaultAccessKeyLocation()).exists()) {
            return this.DefaultAccessKeyLocation();
        }
        return this.ServiceAccountAccessKeyLocation();
    }

    public EzSparkAWSCredentialProvider(URI uri, Configuration conf) {
        this.conf = conf;
        Logging.$init$((Logging)this);
        this.KeyLocationProperty = "fs.s3a.access.key.location";
        this.DefaultAccessKeyLocation = "/etc/secrets/ezua/.auth_token";
        this.ServiceAccountAccessKeyLocation = "/run/secrets/kubernetes.io/serviceaccount/token";
        this.DefaultSecretKeyLocation = "";
        this.accessKey = "";
        this.secretKey = "";
        this.refresh();
        this.startKeyUpdateMonitor();
    }
}

