/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.unixusersync.poc;

import org.apache.ranger.unixusersync.poc.InvalidUserException;

public class ListRangerUser {
    private final String uid;
    private final String uname;
    private final String gid;

    public static ListRangerUser parseUser(String userLine) throws InvalidUserException {
        if (userLine == null) {
            throw new IllegalArgumentException("userLine cannot be null");
        }
        String line = userLine.trim();
        if (line.startsWith("#") || line.isEmpty()) {
            return null;
        }
        String[] parts = line.split(":");
        if (parts.length < 3) {
            throw new InvalidUserException(userLine + "must be in the format of name:passwd:gid[:userlist]", line);
        }
        try {
            String uname = parts[0];
            String uid = parts[2];
            String gid = parts[3];
            ListRangerUser xaUser = new ListRangerUser(uname, uid, gid);
            return xaUser;
        }
        catch (NumberFormatException ex) {
            throw new InvalidUserException(userLine + " uid must be a number", line);
        }
    }

    public ListRangerUser(String nm, String userid, String grpid) {
        this.uname = nm;
        this.uid = userid;
        this.gid = grpid;
    }

    public String getGid() {
        return this.gid;
    }

    public String getName() {
        return this.uname;
    }

    public String getUid() {
        return this.uid;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.uname);
        sb.append(":");
        sb.append(this.uid);
        sb.append(":");
        sb.append(this.gid);
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }
}

