/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.trino.authorizer;

import com.google.common.collect.ImmutableList;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.connector.CatalogSchemaRoutineName;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.security.AccessDeniedException;
import io.trino.spi.security.Identity;
import io.trino.spi.security.Privilege;
import io.trino.spi.security.SystemAccessControl;
import io.trino.spi.security.SystemSecurityContext;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.security.ViewExpression;
import io.trino.spi.type.Type;
import java.io.IOException;
import java.net.URL;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.ranger.authorization.trino.authorizer.RangerTrinoAccessRequest;
import org.apache.ranger.authorization.trino.authorizer.RangerTrinoResource;
import org.apache.ranger.authorization.trino.authorizer.TrinoAccessType;
import org.apache.ranger.plugin.audit.RangerDefaultAuditHandler;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerAccessResultProcessor;
import org.apache.ranger.plugin.service.RangerBasePlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerSystemAccessControl
implements SystemAccessControl {
    private static Logger LOG = LoggerFactory.getLogger(RangerSystemAccessControl.class);
    public static final String RANGER_CONFIG_KEYTAB = "ranger.keytab";
    public static final String RANGER_CONFIG_PRINCIPAL = "ranger.principal";
    public static final String RANGER_CONFIG_USE_UGI = "ranger.use_ugi";
    public static final String RANGER_CONFIG_HADOOP_CONFIG = "ranger.hadoop_config";
    public static final String RANGER_TRINO_DEFAULT_HADOOP_CONF = "trino-ranger-site.xml";
    public static final String RANGER_TRINO_SERVICETYPE = "trino";
    public static final String RANGER_TRINO_APPID = "trino";
    private final RangerBasePlugin rangerPlugin;
    private boolean useUgi = false;

    public RangerSystemAccessControl(Map<String, String> config) {
        URL url;
        Configuration hadoopConf = new Configuration();
        if (config.get(RANGER_CONFIG_HADOOP_CONFIG) != null) {
            url = hadoopConf.getResource(config.get(RANGER_CONFIG_HADOOP_CONFIG));
            if (url == null) {
                LOG.warn("Hadoop config " + config.get(RANGER_CONFIG_HADOOP_CONFIG) + " not found");
            } else {
                hadoopConf.addResource(url);
            }
        } else {
            url = hadoopConf.getResource(RANGER_TRINO_DEFAULT_HADOOP_CONF);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Trying to load Hadoop config from " + url + " (can be null)");
            }
            if (url != null) {
                hadoopConf.addResource(url);
            }
        }
        UserGroupInformation.setConfiguration((Configuration)hadoopConf);
        if (config.get(RANGER_CONFIG_KEYTAB) != null && config.get(RANGER_CONFIG_PRINCIPAL) != null) {
            String keytab = config.get(RANGER_CONFIG_KEYTAB);
            String principal = config.get(RANGER_CONFIG_PRINCIPAL);
            LOG.info("Performing kerberos login with principal " + principal + " and keytab " + keytab);
            try {
                UserGroupInformation.loginUserFromKeytab((String)principal, (String)keytab);
            }
            catch (IOException ioe) {
                LOG.error("Kerberos login failed", (Throwable)ioe);
                throw new RuntimeException(ioe);
            }
        }
        if (config.getOrDefault(RANGER_CONFIG_USE_UGI, "false").equalsIgnoreCase("true")) {
            this.useUgi = true;
        }
        this.rangerPlugin = new RangerBasePlugin("trino", "trino");
        this.rangerPlugin.init();
        this.rangerPlugin.setResultProcessor((RangerAccessResultProcessor)new RangerDefaultAuditHandler());
    }

    private RangerAccessResult getDataMaskResult(RangerTrinoAccessRequest request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getDataMaskResult(request=" + (Object)((Object)request) + ")");
        }
        RangerAccessResult ret = this.rangerPlugin.evalDataMaskPolicies((RangerAccessRequest)request, null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getDataMaskResult(request=" + (Object)((Object)request) + "): ret=" + ret);
        }
        return ret;
    }

    private RangerAccessResult getRowFilterResult(RangerTrinoAccessRequest request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getRowFilterResult(request=" + (Object)((Object)request) + ")");
        }
        RangerAccessResult ret = this.rangerPlugin.evalRowFilterPolicies((RangerAccessRequest)request, null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getRowFilterResult(request=" + (Object)((Object)request) + "): ret=" + ret);
        }
        return ret;
    }

    private boolean isDataMaskEnabled(RangerAccessResult result) {
        return result != null && result.isMaskEnabled();
    }

    private boolean isRowFilterEnabled(RangerAccessResult result) {
        return result != null && result.isRowFilterEnabled();
    }

    public Optional<ViewExpression> getRowFilter(SystemSecurityContext context, CatalogSchemaTableName tableName) {
        RangerTrinoAccessRequest request = this.createAccessRequest(RangerSystemAccessControl.createResource(tableName), context, TrinoAccessType.SELECT);
        RangerAccessResult result = this.getRowFilterResult(request);
        ViewExpression viewExpression = null;
        if (this.isRowFilterEnabled(result)) {
            String filter = result.getFilterExpr();
            viewExpression = new ViewExpression(context.getIdentity().getUser(), Optional.of(tableName.getCatalogName()), Optional.of(tableName.getSchemaTableName().getSchemaName()), filter);
        }
        return Optional.ofNullable(viewExpression);
    }

    public List<ViewExpression> getRowFilters(SystemSecurityContext context, CatalogSchemaTableName tableName) {
        return (List)this.getRowFilter(context, tableName).map(ImmutableList::of).orElseGet(ImmutableList::of);
    }

    public Optional<ViewExpression> getColumnMask(SystemSecurityContext context, CatalogSchemaTableName tableName, String columnName, Type type) {
        RangerTrinoAccessRequest request = this.createAccessRequest(RangerSystemAccessControl.createResource(tableName.getCatalogName(), tableName.getSchemaTableName().getSchemaName(), tableName.getSchemaTableName().getTableName(), Optional.of(columnName)), context, TrinoAccessType.SELECT);
        RangerAccessResult result = this.getDataMaskResult(request);
        ViewExpression viewExpression = null;
        if (this.isDataMaskEnabled(result)) {
            String maskType = result.getMaskType();
            RangerServiceDef.RangerDataMaskTypeDef maskTypeDef = result.getMaskTypeDef();
            String transformer = null;
            if (maskTypeDef != null) {
                transformer = maskTypeDef.getTransformer();
            }
            if (StringUtils.equalsIgnoreCase((String)maskType, (String)"MASK_NULL")) {
                transformer = "NULL";
            } else if (StringUtils.equalsIgnoreCase((String)maskType, (String)"CUSTOM")) {
                String maskedValue = result.getMaskedValue();
                transformer = maskedValue == null ? "NULL" : maskedValue;
            }
            if (StringUtils.isNotEmpty((String)transformer)) {
                transformer = transformer.replace("{col}", columnName).replace("{type}", type.getDisplayName());
            }
            viewExpression = new ViewExpression(context.getIdentity().getUser(), Optional.of(tableName.getCatalogName()), Optional.of(tableName.getSchemaTableName().getSchemaName()), transformer);
            if (LOG.isDebugEnabled()) {
                LOG.debug("getColumnMask: user: %s, catalog: %s, schema: %s, transformer: %s");
            }
        }
        return Optional.ofNullable(viewExpression);
    }

    public List<ViewExpression> getColumnMasks(SystemSecurityContext context, CatalogSchemaTableName tableName, String columnName, Type type) {
        return (List)this.getColumnMask(context, tableName, columnName, type).map(ImmutableList::of).orElseGet(ImmutableList::of);
    }

    public Set<String> filterCatalogs(SystemSecurityContext context, Set<String> catalogs) {
        LOG.debug("==> RangerSystemAccessControl.filterCatalogs(" + catalogs + ")");
        HashSet<String> filteredCatalogs = new HashSet<String>(catalogs.size());
        for (String catalog : catalogs) {
            if (!this.hasPermission(RangerSystemAccessControl.createResource(catalog), context, TrinoAccessType.SELECT)) continue;
            filteredCatalogs.add(catalog);
        }
        return filteredCatalogs;
    }

    public Set<String> filterSchemas(SystemSecurityContext context, String catalogName, Set<String> schemaNames) {
        LOG.debug("==> RangerSystemAccessControl.filterSchemas(" + catalogName + ")");
        HashSet<String> filteredSchemaNames = new HashSet<String>(schemaNames.size());
        for (String schemaName : schemaNames) {
            if (!this.hasPermission(RangerSystemAccessControl.createResource(catalogName, schemaName), context, TrinoAccessType.SELECT)) continue;
            filteredSchemaNames.add(schemaName);
        }
        return filteredSchemaNames;
    }

    public Set<SchemaTableName> filterTables(SystemSecurityContext context, String catalogName, Set<SchemaTableName> tableNames) {
        LOG.debug("==> RangerSystemAccessControl.filterTables(" + catalogName + ")");
        HashSet<SchemaTableName> filteredTableNames = new HashSet<SchemaTableName>(tableNames.size());
        for (SchemaTableName tableName : tableNames) {
            RangerTrinoResource res = RangerSystemAccessControl.createResource(catalogName, tableName.getSchemaName(), tableName.getTableName());
            if (!this.hasPermission(res, context, TrinoAccessType.SELECT)) continue;
            filteredTableNames.add(tableName);
        }
        return filteredTableNames;
    }

    public void checkCanSetSystemSessionProperty(SystemSecurityContext context, String propertyName) {
        if (!this.hasPermission(RangerSystemAccessControl.createSystemPropertyResource(propertyName), context, TrinoAccessType.ALTER)) {
            LOG.debug("RangerSystemAccessControl.checkCanSetSystemSessionProperty denied");
            AccessDeniedException.denySetSystemSessionProperty((String)propertyName);
        }
    }

    public void checkCanImpersonateUser(SystemSecurityContext context, String userName) {
        if (!this.hasPermission(RangerSystemAccessControl.createUserResource(userName), context, TrinoAccessType.IMPERSONATE)) {
            LOG.debug("RangerSystemAccessControl.checkCanImpersonateUser(" + userName + ") denied");
            AccessDeniedException.denyImpersonateUser((String)context.getIdentity().getUser(), (String)userName);
        }
    }

    public void checkCanSetUser(Optional<Principal> principal, String userName) {
    }

    public void checkCanSetCatalogSessionProperty(SystemSecurityContext context, String catalogName, String propertyName) {
        if (!this.hasPermission(RangerSystemAccessControl.createCatalogSessionResource(catalogName, propertyName), context, TrinoAccessType.ALTER)) {
            LOG.debug("RangerSystemAccessControl.checkCanSetSystemSessionProperty(" + catalogName + ") denied");
            AccessDeniedException.denySetCatalogSessionProperty((String)catalogName, (String)propertyName);
        }
    }

    public void checkCanShowRoles(SystemSecurityContext context) {
    }

    public void checkCanShowCurrentRoles(SystemSecurityContext context) {
    }

    public void checkCanShowRoleGrants(SystemSecurityContext context) {
    }

    public void checkCanAccessCatalog(SystemSecurityContext context, String catalogName) {
        if (!this.hasPermission(RangerSystemAccessControl.createResource(catalogName), context, TrinoAccessType.USE)) {
            LOG.debug("RangerSystemAccessControl.checkCanAccessCatalog(" + catalogName + ") denied");
            AccessDeniedException.denyCatalogAccess((String)catalogName);
        }
    }

    public void checkCanShowSchemas(SystemSecurityContext context, String catalogName) {
        if (!this.hasPermission(RangerSystemAccessControl.createResource(catalogName), context, TrinoAccessType.SHOW)) {
            LOG.debug("RangerSystemAccessControl.checkCanShowSchemas(" + catalogName + ") denied");
            AccessDeniedException.denyShowSchemas((String)catalogName);
        }
    }

    public void checkCanSetSchemaAuthorization(SystemSecurityContext context, CatalogSchemaName schema, TrinoPrincipal principal) {
        if (!this.hasPermission(RangerSystemAccessControl.createResource(schema.getCatalogName(), schema.getSchemaName()), context, TrinoAccessType.GRANT)) {
            LOG.debug("RangerSystemAccessControl.checkCanSetSchemaAuthorization(" + schema.getSchemaName() + ") denied");
            AccessDeniedException.denySetSchemaAuthorization((String)schema.getSchemaName(), (TrinoPrincipal)principal);
        }
    }

    public void checkCanShowCreateSchema(SystemSecurityContext context, CatalogSchemaName schema) {
        if (!this.hasPermission(RangerSystemAccessControl.createResource(schema.getCatalogName(), schema.getSchemaName()), context, TrinoAccessType.SHOW)) {
            LOG.debug("RangerSystemAccessControl.checkCanShowCreateSchema(" + schema.getSchemaName() + ") denied");
            AccessDeniedException.denyShowCreateSchema((String)schema.getSchemaName());
        }
    }

    public void checkCanCreateSchema(SystemSecurityContext context, CatalogSchemaName schema) {
        if (!this.hasPermission(RangerSystemAccessControl.createResource(schema.getCatalogName()), context, TrinoAccessType.CREATE)) {
            LOG.debug("RangerSystemAccessControl.checkCanCreateSchema(" + schema.getSchemaName() + ") denied");
            AccessDeniedException.denyCreateSchema((String)schema.getSchemaName());
        }
    }

    public void checkCanDropSchema(SystemSecurityContext context, CatalogSchemaName schema) {
        if (!this.hasPermission(RangerSystemAccessControl.createResource(schema.getCatalogName(), schema.getSchemaName()), context, TrinoAccessType.DROP)) {
            LOG.debug("RangerSystemAccessControl.checkCanDropSchema(" + schema.getSchemaName() + ") denied");
            AccessDeniedException.denyDropSchema((String)schema.getSchemaName());
        }
    }

    public void checkCanRenameSchema(SystemSecurityContext context, CatalogSchemaName schema, String newSchemaName) {
        RangerTrinoResource res = RangerSystemAccessControl.createResource(schema.getCatalogName(), schema.getSchemaName());
        if (!this.hasPermission(res, context, TrinoAccessType.ALTER)) {
            LOG.debug("RangerSystemAccessControl.checkCanRenameSchema(" + schema.getSchemaName() + ") denied");
            AccessDeniedException.denyRenameSchema((String)schema.getSchemaName(), (String)newSchemaName);
        }
    }

    public void checkCanShowTables(SystemSecurityContext context, CatalogSchemaName schema) {
        if (!this.hasPermission(RangerSystemAccessControl.createResource(schema), context, TrinoAccessType.SHOW)) {
            LOG.debug("RangerSystemAccessControl.checkCanShowTables(" + schema.toString() + ") denied");
            AccessDeniedException.denyShowTables((String)schema.toString());
        }
    }

    public void checkCanShowCreateTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        if (!this.hasPermission(RangerSystemAccessControl.createResource(table), context, TrinoAccessType.SHOW)) {
            LOG.debug("RangerSystemAccessControl.checkCanShowTables(" + table.toString() + ") denied");
            AccessDeniedException.denyShowCreateTable((String)table.toString());
        }
    }

    public void checkCanCreateTable(SystemSecurityContext context, CatalogSchemaTableName table, Map<String, Object> properties) {
        if (!this.hasPermission(RangerSystemAccessControl.createResource(table.getCatalogName(), table.getSchemaTableName().getSchemaName()), context, TrinoAccessType.CREATE)) {
            LOG.debug("RangerSystemAccessControl.checkCanCreateTable(" + table.getSchemaTableName().getTableName() + ") denied");
            AccessDeniedException.denyCreateTable((String)table.getSchemaTableName().getTableName());
        }
    }

    public void checkCanDropTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        if (!this.hasPermission(RangerSystemAccessControl.createResource(table), context, TrinoAccessType.DROP)) {
            LOG.debug("RangerSystemAccessControl.checkCanDropTable(" + table.getSchemaTableName().getTableName() + ") denied");
            AccessDeniedException.denyDropTable((String)table.getSchemaTableName().getTableName());
        }
    }

    public void checkCanRenameTable(SystemSecurityContext context, CatalogSchemaTableName table, CatalogSchemaTableName newTable) {
        RangerTrinoResource res = RangerSystemAccessControl.createResource(table);
        if (!this.hasPermission(res, context, TrinoAccessType.ALTER)) {
            LOG.debug("RangerSystemAccessControl.checkCanRenameTable(" + table.getSchemaTableName().getTableName() + ") denied");
            AccessDeniedException.denyRenameTable((String)table.getSchemaTableName().getTableName(), (String)newTable.getSchemaTableName().getTableName());
        }
    }

    public void checkCanInsertIntoTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        RangerTrinoResource res = RangerSystemAccessControl.createResource(table);
        if (!this.hasPermission(res, context, TrinoAccessType.INSERT)) {
            LOG.debug("RangerSystemAccessControl.checkCanInsertIntoTable(" + table.getSchemaTableName().getTableName() + ") denied");
            AccessDeniedException.denyInsertTable((String)table.getSchemaTableName().getTableName());
        }
    }

    public void checkCanDeleteFromTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        if (!this.hasPermission(RangerSystemAccessControl.createResource(table), context, TrinoAccessType.DELETE)) {
            LOG.debug("RangerSystemAccessControl.checkCanDeleteFromTable(" + table.getSchemaTableName().getTableName() + ") denied");
            AccessDeniedException.denyDeleteTable((String)table.getSchemaTableName().getTableName());
        }
    }

    public void checkCanTruncateTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        if (!this.hasPermission(RangerSystemAccessControl.createResource(table), context, TrinoAccessType.DELETE)) {
            LOG.debug("RangerSystemAccessControl.checkCanTruncateTable(" + table.getSchemaTableName().getTableName() + ") denied");
            AccessDeniedException.denyTruncateTable((String)table.getSchemaTableName().getTableName());
        }
    }

    public void checkCanGrantTablePrivilege(SystemSecurityContext context, Privilege privilege, CatalogSchemaTableName table, TrinoPrincipal grantee, boolean withGrantOption) {
        if (!this.hasPermission(RangerSystemAccessControl.createResource(table), context, TrinoAccessType.GRANT)) {
            LOG.debug("RangerSystemAccessControl.checkCanGrantTablePrivilege(" + table + ") denied");
            AccessDeniedException.denyGrantTablePrivilege((String)privilege.toString(), (String)table.toString());
        }
    }

    public void checkCanRevokeTablePrivilege(SystemSecurityContext context, Privilege privilege, CatalogSchemaTableName table, TrinoPrincipal revokee, boolean grantOptionFor) {
        if (!this.hasPermission(RangerSystemAccessControl.createResource(table), context, TrinoAccessType.REVOKE)) {
            LOG.debug("RangerSystemAccessControl.checkCanRevokeTablePrivilege(" + table + ") denied");
            AccessDeniedException.denyRevokeTablePrivilege((String)privilege.toString(), (String)table.toString());
        }
    }

    public void checkCanSetTableComment(SystemSecurityContext context, CatalogSchemaTableName table) {
        if (!this.hasPermission(RangerSystemAccessControl.createResource(table), context, TrinoAccessType.ALTER)) {
            LOG.debug("RangerSystemAccessControl.checkCanSetTableComment(" + table.toString() + ") denied");
            AccessDeniedException.denyCommentTable((String)table.toString());
        }
    }

    public void checkCanSetColumnComment(SystemSecurityContext context, CatalogSchemaTableName table) {
        if (!this.hasPermission(RangerSystemAccessControl.createResource(table), context, TrinoAccessType.ALTER)) {
            LOG.debug("RangerSystemAccessControl.checkCanSetColumnComment(" + table.toString() + ") denied");
            AccessDeniedException.denyCommentColumn((String)table.toString());
        }
    }

    public void checkCanCreateView(SystemSecurityContext context, CatalogSchemaTableName view) {
        if (!this.hasPermission(RangerSystemAccessControl.createResource(view.getCatalogName(), view.getSchemaTableName().getSchemaName()), context, TrinoAccessType.CREATE)) {
            LOG.debug("RangerSystemAccessControl.checkCanCreateView(" + view.getSchemaTableName().getTableName() + ") denied");
            AccessDeniedException.denyCreateView((String)view.getSchemaTableName().getTableName());
        }
    }

    public void checkCanDropView(SystemSecurityContext context, CatalogSchemaTableName view) {
        if (!this.hasPermission(RangerSystemAccessControl.createResource(view), context, TrinoAccessType.DROP)) {
            LOG.debug("RangerSystemAccessControl.checkCanDropView(" + view.getSchemaTableName().getTableName() + ") denied");
            AccessDeniedException.denyDropView((String)view.getSchemaTableName().getTableName());
        }
    }

    public void checkCanSetViewAuthorization(SystemSecurityContext context, CatalogSchemaTableName view, TrinoPrincipal principal) {
        if (!this.hasPermission(RangerSystemAccessControl.createResource(view), context, TrinoAccessType.ALTER)) {
            LOG.debug("RangerSystemAccessControl.checkCanSetViewAuthorization(" + view.getSchemaTableName().getTableName() + ") denied");
            AccessDeniedException.denySetViewAuthorization((String)view.toString(), (TrinoPrincipal)principal);
        }
    }

    public void checkCanCreateViewWithSelectFromColumns(SystemSecurityContext context, CatalogSchemaTableName table, Set<String> columns) {
        try {
            this.checkCanCreateView(context, table);
        }
        catch (AccessDeniedException ade) {
            LOG.debug("RangerSystemAccessControl.checkCanCreateViewWithSelectFromColumns(" + table.getSchemaTableName().getTableName() + ") denied");
            AccessDeniedException.denyCreateViewWithSelect((String)table.getSchemaTableName().getTableName(), (Identity)context.getIdentity());
        }
    }

    public void checkCanCreateMaterializedView(SystemSecurityContext context, CatalogSchemaTableName materializedView, Map<String, Object> properties) {
        if (!this.hasPermission(RangerSystemAccessControl.createResource(materializedView), context, TrinoAccessType.CREATE)) {
            LOG.debug("RangerSystemAccessControl.checkCanCreateMaterializedView( " + materializedView.getSchemaTableName().getTableName() + ") denied");
            AccessDeniedException.denyCreateMaterializedView((String)materializedView.getSchemaTableName().getTableName());
        }
    }

    public void checkCanDropMaterializedView(SystemSecurityContext context, CatalogSchemaTableName materializedView) {
        if (!this.hasPermission(RangerSystemAccessControl.createResource(materializedView), context, TrinoAccessType.DROP)) {
            LOG.debug("RangerSystemAccessControl.checkCanDropMaterializedView(" + materializedView.getSchemaTableName().getTableName() + ") denied");
            AccessDeniedException.denyCreateView((String)materializedView.getSchemaTableName().getTableName());
        }
    }

    public void checkCanRenameView(SystemSecurityContext context, CatalogSchemaTableName view, CatalogSchemaTableName newView) {
        if (!this.hasPermission(RangerSystemAccessControl.createResource(view), context, TrinoAccessType.ALTER)) {
            LOG.debug("RangerSystemAccessControl.checkCanRenameView(" + view.toString() + ") denied");
            AccessDeniedException.denyRenameView((String)view.toString(), (String)newView.toString());
        }
    }

    public void checkCanAddColumn(SystemSecurityContext context, CatalogSchemaTableName table) {
        RangerTrinoResource res = RangerSystemAccessControl.createResource(table);
        if (!this.hasPermission(res, context, TrinoAccessType.ALTER)) {
            AccessDeniedException.denyAddColumn((String)table.getSchemaTableName().getTableName());
        }
    }

    public void checkCanDropColumn(SystemSecurityContext context, CatalogSchemaTableName table) {
        RangerTrinoResource res = RangerSystemAccessControl.createResource(table);
        if (!this.hasPermission(res, context, TrinoAccessType.DROP)) {
            LOG.debug("RangerSystemAccessControl.checkCanDropColumn(" + table.getSchemaTableName().getTableName() + ") denied");
            AccessDeniedException.denyDropColumn((String)table.getSchemaTableName().getTableName());
        }
    }

    public void checkCanRenameColumn(SystemSecurityContext context, CatalogSchemaTableName table) {
        RangerTrinoResource res = RangerSystemAccessControl.createResource(table);
        if (!this.hasPermission(res, context, TrinoAccessType.ALTER)) {
            LOG.debug("RangerSystemAccessControl.checkCanRenameColumn(" + table.getSchemaTableName().getTableName() + ") denied");
            AccessDeniedException.denyRenameColumn((String)table.getSchemaTableName().getTableName());
        }
    }

    public void checkCanShowColumns(SystemSecurityContext context, CatalogSchemaTableName table) {
        if (!this.hasPermission(RangerSystemAccessControl.createResource(table), context, TrinoAccessType.SHOW)) {
            LOG.debug("RangerSystemAccessControl.checkCanShowTables(" + table.toString() + ") denied");
            AccessDeniedException.denyShowColumns((String)table.toString());
        }
    }

    public void checkCanSelectFromColumns(SystemSecurityContext context, CatalogSchemaTableName table, Set<String> columns) {
        for (RangerTrinoResource res : RangerSystemAccessControl.createResource(table, columns)) {
            if (this.hasPermission(res, context, TrinoAccessType.SELECT)) continue;
            LOG.debug("RangerSystemAccessControl.checkCanSelectFromColumns(" + table.getSchemaTableName().getTableName() + ") denied");
            AccessDeniedException.denySelectColumns((String)table.getSchemaTableName().getTableName(), columns);
        }
    }

    public Set<String> filterColumns(SystemSecurityContext context, CatalogSchemaTableName table, Set<String> columns) {
        return columns;
    }

    public void checkCanExecuteQuery(SystemSecurityContext context) {
    }

    public void checkCanViewQueryOwnedBy(SystemSecurityContext context, String queryOwner) {
        if (!this.hasPermission(RangerSystemAccessControl.createUserResource(queryOwner), context, TrinoAccessType.IMPERSONATE)) {
            LOG.debug("RangerSystemAccessControl.checkCanViewQueryOwnedBy(" + queryOwner + ") denied");
            AccessDeniedException.denyImpersonateUser((String)context.getIdentity().getUser(), (String)queryOwner);
        }
    }

    public Set<String> filterViewQueryOwnedBy(SystemSecurityContext context, Set<String> queryOwners) {
        return queryOwners;
    }

    public void checkCanKillQueryOwnedBy(SystemSecurityContext context, String queryOwner) {
        if (!this.hasPermission(RangerSystemAccessControl.createUserResource(queryOwner), context, TrinoAccessType.IMPERSONATE)) {
            LOG.debug("RangerSystemAccessControl.checkCanKillQueryOwnedBy(" + queryOwner + ") denied");
            AccessDeniedException.denyImpersonateUser((String)context.getIdentity().getUser(), (String)queryOwner);
        }
    }

    public void checkCanGrantExecuteFunctionPrivilege(SystemSecurityContext context, String function, TrinoPrincipal grantee, boolean grantOption) {
        if (!this.hasPermission(RangerSystemAccessControl.createFunctionResource(function), context, TrinoAccessType.GRANT)) {
            LOG.debug("RangerSystemAccessControl.checkCanGrantExecuteFunctionPrivilege(" + function + ") denied");
            AccessDeniedException.denyGrantExecuteFunctionPrivilege((String)function, (Identity)context.getIdentity(), (String)grantee.getName());
        }
    }

    public void checkCanExecuteFunction(SystemSecurityContext context, String function) {
        if (!this.hasPermission(RangerSystemAccessControl.createFunctionResource(function), context, TrinoAccessType.EXECUTE)) {
            LOG.debug("RangerSystemAccessControl.checkCanExecuteFunction(" + function + ") denied");
            AccessDeniedException.denyExecuteFunction((String)function);
        }
    }

    public void checkCanExecuteProcedure(SystemSecurityContext context, CatalogSchemaRoutineName procedure) {
        if (!this.hasPermission(RangerSystemAccessControl.createProcedureResource(procedure), context, TrinoAccessType.EXECUTE)) {
            LOG.debug("RangerSystemAccessControl.checkCanExecuteFunction(" + procedure.getSchemaRoutineName().getRoutineName() + ") denied");
            AccessDeniedException.denyExecuteProcedure((String)procedure.getSchemaRoutineName().getRoutineName());
        }
    }

    public void checkCanExecuteTableProcedure(SystemSecurityContext context, CatalogSchemaTableName catalogSchemaTableName, String procedure) {
        if (!this.hasPermission(RangerSystemAccessControl.createResource(catalogSchemaTableName), context, TrinoAccessType.ALTER)) {
            LOG.debug("RangerSystemAccessControl.checkCanExecuteFunction(" + procedure + ") denied");
            AccessDeniedException.denyExecuteTableProcedure((String)catalogSchemaTableName.toString(), (String)procedure);
        }
    }

    private RangerTrinoAccessRequest createAccessRequest(RangerTrinoResource resource, SystemSecurityContext context, TrinoAccessType accessType) {
        HashSet<String> userGroups = null;
        if (this.useUgi) {
            String[] groups;
            UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)context.getIdentity().getUser());
            String[] stringArray = groups = ugi != null ? ugi.getGroupNames() : null;
            if (groups != null && groups.length > 0) {
                userGroups = new HashSet<String>(Arrays.asList(groups));
            }
        } else {
            userGroups = context.getIdentity().getGroups();
        }
        RangerTrinoAccessRequest request = new RangerTrinoAccessRequest(resource, context.getIdentity().getUser(), (Set<String>)userGroups, accessType);
        return request;
    }

    private boolean hasPermission(RangerTrinoResource resource, SystemSecurityContext context, TrinoAccessType accessType) {
        boolean ret = false;
        RangerTrinoAccessRequest request = this.createAccessRequest(resource, context, accessType);
        RangerAccessResult result = this.rangerPlugin.isAccessAllowed((RangerAccessRequest)request);
        if (result != null && result.getIsAllowed()) {
            ret = true;
        }
        return ret;
    }

    private static RangerTrinoResource createUserResource(String userName) {
        RangerTrinoResource res = new RangerTrinoResource();
        res.setValue("trinouser", userName);
        return res;
    }

    private static RangerTrinoResource createFunctionResource(String function) {
        RangerTrinoResource res = new RangerTrinoResource();
        res.setValue("function", function);
        return res;
    }

    private static RangerTrinoResource createProcedureResource(CatalogSchemaRoutineName procedure) {
        RangerTrinoResource res = new RangerTrinoResource();
        res.setValue("catalog", procedure.getCatalogName());
        res.setValue("schema", procedure.getSchemaRoutineName().getSchemaName());
        res.setValue("procedure", procedure.getSchemaRoutineName().getRoutineName());
        return res;
    }

    private static RangerTrinoResource createCatalogSessionResource(String catalogName, String propertyName) {
        RangerTrinoResource res = new RangerTrinoResource();
        res.setValue("catalog", catalogName);
        res.setValue("sessionproperty", propertyName);
        return res;
    }

    private static RangerTrinoResource createSystemPropertyResource(String property) {
        RangerTrinoResource res = new RangerTrinoResource();
        res.setValue("systemproperty", property);
        return res;
    }

    private static RangerTrinoResource createResource(CatalogSchemaName catalogSchemaName) {
        return RangerSystemAccessControl.createResource(catalogSchemaName.getCatalogName(), catalogSchemaName.getSchemaName());
    }

    private static RangerTrinoResource createResource(CatalogSchemaTableName catalogSchemaTableName) {
        return RangerSystemAccessControl.createResource(catalogSchemaTableName.getCatalogName(), catalogSchemaTableName.getSchemaTableName().getSchemaName(), catalogSchemaTableName.getSchemaTableName().getTableName());
    }

    private static RangerTrinoResource createResource(String catalogName) {
        return new RangerTrinoResource(catalogName, Optional.empty(), Optional.empty());
    }

    private static RangerTrinoResource createResource(String catalogName, String schemaName) {
        return new RangerTrinoResource(catalogName, Optional.of(schemaName), Optional.empty());
    }

    private static RangerTrinoResource createResource(String catalogName, String schemaName, String tableName) {
        return new RangerTrinoResource(catalogName, Optional.of(schemaName), Optional.of(tableName));
    }

    private static RangerTrinoResource createResource(String catalogName, String schemaName, String tableName, Optional<String> column) {
        return new RangerTrinoResource(catalogName, Optional.of(schemaName), Optional.of(tableName), column);
    }

    private static List<RangerTrinoResource> createResource(CatalogSchemaTableName table, Set<String> columns) {
        ArrayList<RangerTrinoResource> colRequests = new ArrayList<RangerTrinoResource>();
        if (columns.size() > 0) {
            for (String column : columns) {
                RangerTrinoResource rangerTrinoResource = RangerSystemAccessControl.createResource(table.getCatalogName(), table.getSchemaTableName().getSchemaName(), table.getSchemaTableName().getTableName(), Optional.of(column));
                colRequests.add(rangerTrinoResource);
            }
        } else {
            colRequests.add(RangerSystemAccessControl.createResource(table.getCatalogName(), table.getSchemaTableName().getSchemaName(), table.getSchemaTableName().getTableName(), Optional.empty()));
        }
        return colRequests;
    }
}

