/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.trino.authorizer;

import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.connector.CatalogSchemaRoutineName;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.security.Privilege;
import io.trino.spi.security.SystemAccessControl;
import io.trino.spi.security.SystemSecurityContext;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.security.ViewExpression;
import io.trino.spi.type.Type;
import java.security.Principal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import org.apache.ranger.authorization.trino.authorizer.RangerConfig;
import org.apache.ranger.plugin.classloader.RangerPluginClassLoader;

public class RangerSystemAccessControl
implements SystemAccessControl {
    private static final String RANGER_PLUGIN_TYPE = "trino";
    private static final String RANGER_TRINO_AUTHORIZER_IMPL_CLASSNAME = "org.apache.ranger.authorization.trino.authorizer.RangerSystemAccessControl";
    private final RangerPluginClassLoader rangerPluginClassLoader;
    private final SystemAccessControl systemAccessControlImpl;

    @Inject
    public RangerSystemAccessControl(RangerConfig config) {
        try {
            this.rangerPluginClassLoader = RangerPluginClassLoader.getInstance((String)RANGER_PLUGIN_TYPE, this.getClass());
            Class<?> cls = Class.forName(RANGER_TRINO_AUTHORIZER_IMPL_CLASSNAME, true, (ClassLoader)this.rangerPluginClassLoader);
            this.activatePluginClassLoader();
            HashMap<String, String> configMap = new HashMap<String, String>();
            if (config.getKeytab() != null && config.getPrincipal() != null) {
                configMap.put("ranger.keytab", config.getKeytab());
                configMap.put("ranger.principal", config.getPrincipal());
            }
            configMap.put("ranger.use_ugi", Boolean.toString(config.isUseUgi()));
            if (config.getHadoopConfigPath() != null) {
                configMap.put("ranger.hadoop_config", config.getHadoopConfigPath());
            }
            this.systemAccessControlImpl = (SystemAccessControl)cls.getDeclaredConstructor(Map.class).newInstance(configMap);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    public void checkCanSetSystemSessionProperty(SystemSecurityContext context, String propertyName) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanSetSystemSessionProperty(context, propertyName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    public void checkCanAccessCatalog(SystemSecurityContext context, String catalogName) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanAccessCatalog(context, catalogName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> filterCatalogs(SystemSecurityContext context, Set<String> catalogs) {
        Set filteredCatalogs;
        try {
            this.activatePluginClassLoader();
            filteredCatalogs = this.systemAccessControlImpl.filterCatalogs(context, catalogs);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        return filteredCatalogs;
    }

    public void checkCanCreateSchema(SystemSecurityContext context, CatalogSchemaName schema) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanCreateSchema(context, schema);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    public void checkCanDropSchema(SystemSecurityContext context, CatalogSchemaName schema) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanDropSchema(context, schema);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkCanRenameSchema(SystemSecurityContext context, CatalogSchemaName schema, String newSchemaName) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanRenameSchema(context, schema, newSchemaName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    public void checkCanShowSchemas(SystemSecurityContext context, String catalogName) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanShowSchemas(context, catalogName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> filterSchemas(SystemSecurityContext context, String catalogName, Set<String> schemaNames) {
        Set filteredSchemas;
        try {
            this.activatePluginClassLoader();
            filteredSchemas = this.systemAccessControlImpl.filterSchemas(context, catalogName, schemaNames);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        return filteredSchemas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkCanCreateTable(SystemSecurityContext context, CatalogSchemaTableName table, Map<String, Object> properties) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanCreateTable(context, table, properties);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    public void checkCanDropTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanDropTable(context, table);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkCanRenameTable(SystemSecurityContext context, CatalogSchemaTableName table, CatalogSchemaTableName newTable) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanRenameTable(context, table, newTable);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<SchemaTableName> filterTables(SystemSecurityContext context, String catalogName, Set<SchemaTableName> tableNames) {
        Set filteredTableNames;
        try {
            this.activatePluginClassLoader();
            filteredTableNames = this.systemAccessControlImpl.filterTables(context, catalogName, tableNames);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        return filteredTableNames;
    }

    public void checkCanAddColumn(SystemSecurityContext context, CatalogSchemaTableName table) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanAddColumn(context, table);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    public void checkCanDropColumn(SystemSecurityContext context, CatalogSchemaTableName table) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanDropColumn(context, table);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    public void checkCanRenameColumn(SystemSecurityContext context, CatalogSchemaTableName table) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanRenameColumn(context, table);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkCanSelectFromColumns(SystemSecurityContext context, CatalogSchemaTableName table, Set<String> columns) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanSelectFromColumns(context, table, columns);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    public void checkCanInsertIntoTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanInsertIntoTable(context, table);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    public void checkCanDeleteFromTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanDeleteFromTable(context, table);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    public void checkCanTruncateTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanTruncateTable(context, table);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    public void checkCanCreateView(SystemSecurityContext context, CatalogSchemaTableName view) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanCreateView(context, view);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkCanCreateMaterializedView(SystemSecurityContext context, CatalogSchemaTableName materializedView, Map<String, Object> properties) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanCreateMaterializedView(context, materializedView, properties);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    public void checkCanDropMaterializedView(SystemSecurityContext context, CatalogSchemaTableName materializedView) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanDropMaterializedView(context, materializedView);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    public void checkCanDropView(SystemSecurityContext context, CatalogSchemaTableName view) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanDropView(context, view);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkCanSetViewAuthorization(SystemSecurityContext context, CatalogSchemaTableName view, TrinoPrincipal principal) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanSetViewAuthorization(context, view, principal);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkCanCreateViewWithSelectFromColumns(SystemSecurityContext context, CatalogSchemaTableName table, Set<String> columns) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanCreateViewWithSelectFromColumns(context, table, columns);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkCanSetCatalogSessionProperty(SystemSecurityContext context, String catalogName, String propertyName) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanSetCatalogSessionProperty(context, catalogName, propertyName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    public void checkCanImpersonateUser(SystemSecurityContext context, String userName) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanImpersonateUser(context, userName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    public void checkCanExecuteQuery(SystemSecurityContext context) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanExecuteQuery(context);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    public void checkCanViewQueryOwnedBy(SystemSecurityContext context, String queryOwner) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanViewQueryOwnedBy(context, queryOwner);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> filterViewQueryOwnedBy(SystemSecurityContext context, Set<String> queryOwners) {
        Set filteredQueryOwners;
        try {
            this.activatePluginClassLoader();
            filteredQueryOwners = this.systemAccessControlImpl.filterViewQueryOwnedBy(context, queryOwners);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        return filteredQueryOwners;
    }

    public void checkCanKillQueryOwnedBy(SystemSecurityContext context, String queryOwner) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanKillQueryOwnedBy(context, queryOwner);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    public void checkCanShowCreateTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanShowCreateTable(context, table);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    public void checkCanSetTableComment(SystemSecurityContext context, CatalogSchemaTableName table) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanSetTableComment(context, table);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    public void checkCanSetColumnComment(SystemSecurityContext context, CatalogSchemaTableName table) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanSetColumnComment(context, table);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    public void checkCanShowTables(SystemSecurityContext context, CatalogSchemaName schema) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanShowTables(context, schema);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    public void checkCanShowColumns(SystemSecurityContext context, CatalogSchemaTableName table) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanShowColumns(context, table);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> filterColumns(SystemSecurityContext context, CatalogSchemaTableName table, Set<String> columns) {
        Set filteredColumns;
        try {
            this.activatePluginClassLoader();
            filteredColumns = this.systemAccessControlImpl.filterColumns(context, table, columns);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        return filteredColumns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkCanRenameView(SystemSecurityContext context, CatalogSchemaTableName view, CatalogSchemaTableName newView) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanRenameView(context, view, newView);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkCanGrantTablePrivilege(SystemSecurityContext context, Privilege privilege, CatalogSchemaTableName table, TrinoPrincipal grantee, boolean withGrantOption) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanGrantTablePrivilege(context, privilege, table, grantee, withGrantOption);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkCanRevokeTablePrivilege(SystemSecurityContext context, Privilege privilege, CatalogSchemaTableName table, TrinoPrincipal revokee, boolean grantOptionFor) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanRevokeTablePrivilege(context, privilege, table, revokee, grantOptionFor);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    public void checkCanShowRoles(SystemSecurityContext context) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanShowRoles(context);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    public void checkCanShowCurrentRoles(SystemSecurityContext context) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanShowCurrentRoles(context);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    public void checkCanShowRoleGrants(SystemSecurityContext context) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanShowRoleGrants(context);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<ViewExpression> getRowFilter(SystemSecurityContext context, CatalogSchemaTableName tableName) {
        Optional viewExpression;
        try {
            this.activatePluginClassLoader();
            viewExpression = this.systemAccessControlImpl.getRowFilter(context, tableName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        return viewExpression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ViewExpression> getRowFilters(SystemSecurityContext context, CatalogSchemaTableName tableName) {
        List viewExpressionList;
        try {
            this.activatePluginClassLoader();
            viewExpressionList = this.systemAccessControlImpl.getRowFilters(context, tableName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        return viewExpressionList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<ViewExpression> getColumnMask(SystemSecurityContext context, CatalogSchemaTableName tableName, String columnName, Type type) {
        Optional viewExpression;
        try {
            this.activatePluginClassLoader();
            viewExpression = this.systemAccessControlImpl.getColumnMask(context, tableName, columnName, type);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        return viewExpression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ViewExpression> getColumnMasks(SystemSecurityContext context, CatalogSchemaTableName tableName, String columnName, Type type) {
        List viewExpressionList;
        try {
            this.activatePluginClassLoader();
            viewExpressionList = this.systemAccessControlImpl.getColumnMasks(context, tableName, columnName, type);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        return viewExpressionList;
    }

    public void checkCanSetUser(Optional<Principal> principal, String userName) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanSetUser(principal, userName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkCanGrantExecuteFunctionPrivilege(SystemSecurityContext context, String functionName, TrinoPrincipal grantee, boolean grantOption) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanGrantExecuteFunctionPrivilege(context, functionName, grantee, grantOption);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkCanSetSchemaAuthorization(SystemSecurityContext context, CatalogSchemaName schema, TrinoPrincipal principal) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanSetSchemaAuthorization(context, schema, principal);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    public void checkCanShowCreateSchema(SystemSecurityContext context, CatalogSchemaName schemaName) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanShowCreateSchema(context, schemaName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    public void checkCanExecuteProcedure(SystemSecurityContext systemSecurityContext, CatalogSchemaRoutineName procedure) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanExecuteProcedure(systemSecurityContext, procedure);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkCanExecuteTableProcedure(SystemSecurityContext systemSecurityContext, CatalogSchemaTableName catalogSchemaTableName, String procedure) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanExecuteTableProcedure(systemSecurityContext, catalogSchemaTableName, procedure);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    public void checkCanExecuteFunction(SystemSecurityContext systemSecurityContext, String functionName) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanExecuteFunction(systemSecurityContext, functionName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    private void activatePluginClassLoader() {
        if (this.rangerPluginClassLoader != null) {
            this.rangerPluginClassLoader.activate();
        }
    }

    private void deactivatePluginClassLoader() {
        if (this.rangerPluginClassLoader != null) {
            this.rangerPluginClassLoader.deactivate();
        }
    }
}

