/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.knox.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.ranger.plugin.client.BaseClient;
import org.apache.ranger.plugin.client.HadoopException;
import org.apache.ranger.plugin.util.JsonUtilsV2;
import org.apache.ranger.plugin.util.PasswordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KnoxClient {
    private static final String EXPECTED_MIME_TYPE = "application/json";
    private static final Logger LOG = LoggerFactory.getLogger(KnoxClient.class);
    private String knoxUrl;
    private String userName;
    private String password;

    public KnoxClient(String knoxUrl, String userName, String password) {
        LOG.debug("Constructed KnoxClient with knoxUrl: " + knoxUrl + ", userName: " + userName);
        this.knoxUrl = knoxUrl;
        this.userName = userName;
        this.password = password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> getTopologyList(String topologyNameMatching, List<String> knoxTopologyList) {
        LOG.debug("Getting Knox topology list for topologyNameMatching : " + topologyNameMatching);
        ArrayList<String> topologyList = new ArrayList<String>();
        String errMsg = " You can still save the repository and start creating policies, but you would not be able to use autocomplete for resource names. Check ranger-admin logs in $RANGER_HOME/ranger-admin/ews/log/ for more info.";
        if (topologyNameMatching == null || topologyNameMatching.trim().isEmpty()) {
            topologyNameMatching = "";
        }
        String decryptedPwd = null;
        try {
            decryptedPwd = PasswordUtils.decryptPassword((String)this.password);
        }
        catch (Exception ex) {
            LOG.info("Password decryption failed; trying knox connection with received password string");
            decryptedPwd = null;
        }
        finally {
            if (decryptedPwd == null) {
                decryptedPwd = this.password;
            }
        }
        try {
            Client client = null;
            ClientResponse response = null;
            try {
                client = Client.create();
                client.addFilter((ClientFilter)new HTTPBasicAuthFilter(this.userName, decryptedPwd));
                WebResource webResource = client.resource(this.knoxUrl);
                response = (ClientResponse)webResource.accept(new String[]{EXPECTED_MIME_TYPE}).get(ClientResponse.class);
                LOG.debug("Knox topology list response: " + response);
                if (response == null) {
                    String msgDesc = "Unable to get a valid response for getTopologyList() call for KnoxUrl : [" + this.knoxUrl + "] - got null response.";
                    LOG.error(msgDesc);
                    HadoopException hdpException = new HadoopException(msgDesc);
                    hdpException.generateResponseDataMap(false, msgDesc, msgDesc + errMsg, null, null);
                    throw hdpException;
                }
                if (response.getStatus() != 200) {
                    LOG.error("Got invalid REST response from: " + this.knoxUrl + ", responseStatus: " + response.getStatus());
                } else {
                    String jsonString = (String)response.getEntity(String.class);
                    LOG.debug("Knox topology list response JSON string: " + jsonString);
                    JsonNode rootNode = JsonUtilsV2.getMapper().readTree(jsonString);
                    JsonNode topologyNode = rootNode.findValue("topology");
                    if (topologyNode == null) {
                        ArrayList<String> arrayList = topologyList;
                        return arrayList;
                    }
                    Iterator elements = topologyNode.elements();
                    while (elements.hasNext()) {
                        JsonNode element = (JsonNode)elements.next();
                        JsonNode nameElement = element.get("name");
                        if (nameElement == null) continue;
                        String topologyName = nameElement.asText();
                        LOG.debug("Found Knox topologyName: " + topologyName);
                        if (knoxTopologyList != null && topologyName != null && knoxTopologyList.contains(topologyNameMatching) || topologyName == null || !"*".equals(topologyNameMatching) && !topologyName.startsWith(topologyNameMatching)) continue;
                        topologyList.add(topologyName);
                    }
                }
            }
            finally {
                if (response != null) {
                    response.close();
                }
                if (client != null) {
                    client.destroy();
                }
            }
        }
        catch (HadoopException he) {
            throw he;
        }
        catch (Throwable t) {
            String msgDesc = "Exception on REST call to KnoxUrl : " + this.knoxUrl + ".";
            HadoopException hdpException = new HadoopException(msgDesc, t);
            LOG.error(msgDesc, t);
            hdpException.generateResponseDataMap(false, BaseClient.getMessage((Throwable)t), msgDesc + errMsg, null, null);
            throw hdpException;
        }
        if (!LOG.isDebugEnabled()) return topologyList;
        LOG.debug("<== KnoxClient.getTopologyList() Topology Matching: " + topologyNameMatching + " Result : " + ((Object)topologyList).toString());
        return topologyList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getServiceList(List<String> knoxTopologyList, String serviceNameMatching, List<String> knoxServiceList) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> KnoxClient.getServiceList() Service Name: " + serviceNameMatching);
        }
        ArrayList<String> serviceList = new ArrayList<String>();
        String errMsg = " You can still save the repository and start creating policies, but you would not be able to use autocomplete for resource names. Check ranger-admin logs in $RANGER_HOME/ranger-admin/ews/log/ for more info.";
        if (serviceNameMatching == null || serviceNameMatching.trim().isEmpty()) {
            serviceNameMatching = "";
        }
        String decryptedPwd = null;
        try {
            decryptedPwd = PasswordUtils.decryptPassword((String)this.password);
        }
        catch (Exception ex) {
            LOG.info("Password decryption failed; trying knox connection with received password string");
            decryptedPwd = null;
        }
        finally {
            if (decryptedPwd == null) {
                decryptedPwd = this.password;
            }
        }
        try {
            Client client = null;
            ClientResponse response = null;
            try {
                client = Client.create();
                client.addFilter((ClientFilter)new HTTPBasicAuthFilter(this.userName, decryptedPwd));
                for (String topologyName : knoxTopologyList) {
                    WebResource webResource = client.resource(this.knoxUrl + "/" + topologyName);
                    response = (ClientResponse)webResource.accept(new String[]{EXPECTED_MIME_TYPE}).get(ClientResponse.class);
                    LOG.debug("Knox service lookup response: " + response);
                    if (response != null) {
                        if (response.getStatus() == 200) {
                            JsonNode servicesNode;
                            String jsonString = (String)response.getEntity(String.class);
                            LOG.debug("Knox service lookup response JSON string: " + jsonString);
                            JsonNode rootNode = JsonUtilsV2.getMapper().readTree(jsonString);
                            JsonNode topologyNode = rootNode.findValue("topology");
                            if (topologyNode == null || (servicesNode = topologyNode.get("service")) == null) continue;
                            Iterator services = servicesNode.elements();
                            while (services.hasNext()) {
                                JsonNode service = (JsonNode)services.next();
                                JsonNode serviceElement = service.get("role");
                                if (serviceElement == null) continue;
                                String serviceName = serviceElement.asText();
                                LOG.debug("Knox serviceName: " + serviceName);
                                if (serviceName == null || knoxServiceList != null && knoxServiceList.contains(serviceName) || !serviceName.startsWith(serviceNameMatching) && !"*".equals(serviceNameMatching)) continue;
                                serviceList.add(serviceName);
                            }
                            continue;
                        }
                        LOG.error("Got invalid  REST response from: " + this.knoxUrl + ", responsStatus: " + response.getStatus());
                        continue;
                    }
                    String msgDesc = "Unable to get a valid response for getServiceList() call for KnoxUrl : [" + this.knoxUrl + "] - got null response.";
                    LOG.error(msgDesc);
                    HadoopException hdpException = new HadoopException(msgDesc);
                    hdpException.generateResponseDataMap(false, msgDesc, msgDesc + errMsg, null, null);
                    throw hdpException;
                }
            }
            finally {
                if (response != null) {
                    response.close();
                }
                if (client != null) {
                    client.destroy();
                }
            }
        }
        catch (HadoopException he) {
            throw he;
        }
        catch (Throwable t) {
            String msgDesc = "Exception on REST call to KnoxUrl : " + this.knoxUrl + ".";
            HadoopException hdpException = new HadoopException(msgDesc, t);
            LOG.error(msgDesc, t);
            hdpException.generateResponseDataMap(false, BaseClient.getMessage((Throwable)t), msgDesc + errMsg, null, null);
            throw hdpException;
        }
        return serviceList;
    }

    public static void main(String[] args) {
        List<String> topologyList;
        KnoxClient knoxClient = null;
        if (args.length != 3) {
            System.err.println("USAGE: java " + KnoxClient.class.getName() + " knoxUrl userName password [sslConfigFileName]");
            System.exit(1);
        }
        if ((topologyList = (knoxClient = new KnoxClient(args[0], args[1], args[2])).getTopologyList("", null)) == null || topologyList.isEmpty()) {
            System.out.println("No knox topologies found");
        } else {
            List<String> serviceList = knoxClient.getServiceList(topologyList, "*", null);
            if (serviceList == null || serviceList.isEmpty()) {
                System.out.println("No services found for knox topology: ");
            } else {
                for (String service : serviceList) {
                    System.out.println("\tFound service for topology: " + service);
                }
            }
        }
    }

    public static Map<String, Object> connectionTest(String serviceName, Map<String, String> configs) {
        String errMsg = " You can still save the repository and start creating policies, but you would not be able to use autocomplete for resource names. Check ranger-admin logs in $RANGER_HOME/ranger-admin/ews/log/ for more info.";
        boolean connectivityStatus = false;
        HashMap<String, Object> responseData = new HashMap<String, Object>();
        KnoxClient knoxClient = KnoxClient.getKnoxClient(serviceName, configs);
        List<String> strList = KnoxClient.getKnoxResources(knoxClient, "", null, null, null);
        if (strList != null && strList.size() != 0) {
            connectivityStatus = true;
        }
        if (connectivityStatus) {
            String successMsg = "ConnectionTest Successful";
            BaseClient.generateResponseDataMap((boolean)connectivityStatus, (String)successMsg, (String)successMsg, null, null, responseData);
        } else {
            String failureMsg = "Unable to retrieve any topologies/services using given parameters.";
            BaseClient.generateResponseDataMap((boolean)connectivityStatus, (String)failureMsg, (String)(failureMsg + errMsg), null, null, responseData);
        }
        return responseData;
    }

    public static KnoxClient getKnoxClient(String serviceName, Map<String, String> configs) {
        KnoxClient knoxClient = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Getting knoxClient for ServiceName: " + serviceName);
            LOG.debug("configMap: " + configs);
        }
        String errMsg = " You can still save the repository and start creating policies, but you would not be able to use autocomplete for resource names. Check ranger-admin logs in $RANGER_HOME/ranger-admin/ews/log/ for more info.";
        if (configs == null || configs.isEmpty()) {
            String msgDesc = "Could not connect as Connection ConfigMap is empty.";
            LOG.error(msgDesc);
            HadoopException hdpException = new HadoopException(msgDesc);
            hdpException.generateResponseDataMap(false, msgDesc, msgDesc + errMsg, null, null);
            throw hdpException;
        }
        String knoxUrl = configs.get("knox.url");
        String knoxAdminUser = configs.get("username");
        String knoxAdminPassword = configs.get("password");
        knoxClient = new KnoxClient(knoxUrl, knoxAdminUser, knoxAdminPassword);
        return knoxClient;
    }

    public static List<String> getKnoxResources(final KnoxClient knoxClient, String topologyName, String serviceName, List<String> knoxTopologyList, List<String> knoxServiceList) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> KnoxClient.getKnoxResource topology: " + topologyName + "Service Name: " + serviceName);
        }
        ArrayList<String> resultList = new ArrayList();
        String errMsg = " You can still save the repository and start creating policies, but you would not be able to use autocomplete for resource names. Check ranger-admin logs in $RANGER_HOME/ranger-admin/ews/log/ for more info.";
        try {
            Callable<List<String>> callableObj;
            if (knoxClient == null) {
                String msgDesc = "Unable to get knox resources: knoxClient is null.";
                LOG.error(msgDesc);
                HadoopException hdpException = new HadoopException(msgDesc);
                hdpException.generateResponseDataMap(false, msgDesc, msgDesc + errMsg, null, null);
                throw hdpException;
            }
            if (serviceName != null) {
                final String finalServiceNameMatching = serviceName.trim();
                final List<String> finalknoxServiceList = knoxServiceList;
                final List<String> finalTopologyList = knoxTopologyList;
                callableObj = new Callable<List<String>>(){

                    @Override
                    public List<String> call() {
                        return knoxClient.getServiceList(finalTopologyList, finalServiceNameMatching, finalknoxServiceList);
                    }
                };
            } else {
                final String finalTopologyNameMatching = topologyName == null ? "" : topologyName.trim();
                final List<String> finalknoxTopologyList = knoxTopologyList;
                callableObj = new Callable<List<String>>(){

                    @Override
                    public List<String> call() {
                        return knoxClient.getTopologyList(finalTopologyNameMatching, finalknoxTopologyList);
                    }
                };
            }
            resultList = KnoxClient.timedTask(callableObj, 5L, TimeUnit.SECONDS);
        }
        catch (HadoopException he) {
            throw he;
        }
        catch (Exception e) {
            String msgDesc = "Unable to get knox resources.";
            LOG.error(msgDesc, (Throwable)e);
            HadoopException hdpException = new HadoopException(msgDesc);
            hdpException.generateResponseDataMap(false, BaseClient.getMessage((Throwable)e), msgDesc + errMsg, null, null);
            throw hdpException;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== KnoxClient.getKnoxResources() Result : " + resultList);
        }
        return resultList;
    }

    public static <T> T timedTask(Callable<T> callableObj, long timeout, TimeUnit timeUnit) throws Exception {
        return callableObj.call();
    }
}

