/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key.kms.server;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.crypto.key.kms.KMSClientProvider;
import org.apache.hadoop.crypto.key.kms.server.KMSACLsType;
import org.apache.hadoop.crypto.key.kms.server.KMSAudit;
import org.apache.hadoop.crypto.key.kms.server.KMSMDCFilter;
import org.apache.hadoop.crypto.key.kms.server.KMSServerJSONUtils;
import org.apache.hadoop.crypto.key.kms.server.KMSWebApp;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.delegation.web.HttpUserGroupInformation;
import org.apache.hadoop.util.KMSUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1")
@InterfaceAudience.Private
public class KMS {
    static final Logger LOG = LoggerFactory.getLogger(KMS.class);
    private static final String KEY_NAME_VALIDATION = "[a-z,A-Z,0-9](?!.*--)(?!.*__)(?!.*-_)(?!.*_-)[\\w\\-\\_]*";
    private static final int MAX_NUM_PER_BATCH = 10000;
    private final KeyProviderCryptoExtension provider = KMSWebApp.getKeyProvider();
    private final KMSAudit kmsAudit = KMSWebApp.getKMSAudit();

    @POST
    @Path(value="keys")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createKey(Map jsonKey, @Context HttpServletRequest request) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> createKey()");
        }
        try {
            KMSWebApp.getAdminCallsMeter().mark();
            UserGroupInformation user = HttpUserGroupInformation.get();
            String name = (String)jsonKey.get("name");
            KMSUtil.checkNotEmpty((String)name, (String)"name");
            this.validateKeyName(name);
            this.assertAccess(KMSACLsType.Type.CREATE, user, KMSOp.CREATE_KEY, name, request.getRemoteAddr());
            String cipher = (String)jsonKey.get("cipher");
            String material = (String)jsonKey.get("material");
            int length = jsonKey.containsKey("length") ? (Integer)jsonKey.get("length") : 0;
            String description = (String)jsonKey.get("description");
            if (LOG.isDebugEnabled()) {
                LOG.debug("Creating key: name={}, cipher={}, keyLength={}, description={}", new Object[]{name, cipher, length, description});
            }
            Map attributes = (Map)jsonKey.get("attributes");
            if (material != null) {
                this.assertAccess(KMSACLsType.Type.SET_KEY_MATERIAL, user, KMSOp.CREATE_KEY, name, request.getRemoteAddr());
            }
            KeyProvider.Options options = new KeyProvider.Options(KMSWebApp.getConfiguration());
            if (cipher != null) {
                options.setCipher(cipher);
            }
            if (length != 0) {
                options.setBitLength(length);
            }
            options.setDescription(description);
            options.setAttributes(attributes);
            KeyProvider.KeyVersion keyVersion = (KeyProvider.KeyVersion)user.doAs(() -> {
                KeyProvider.KeyVersion ret = material != null ? this.provider.createKey(name, Base64.decodeBase64((String)material), options) : this.provider.createKey(name, options);
                this.provider.flush();
                return ret;
            });
            this.kmsAudit.ok(user, KMSOp.CREATE_KEY, name, "UserProvidedMaterial:" + (material != null) + " Description:" + description);
            if (!KMSWebApp.getACLs().hasAccess(KMSACLsType.Type.GET, user, request.getRemoteAddr())) {
                keyVersion = KMS.removeKeyMaterial(keyVersion);
            }
            Map json = KMSUtil.toJSON((KeyProvider.KeyVersion)keyVersion);
            String requestURL = KMSMDCFilter.getURL();
            int idx = requestURL.lastIndexOf("keys");
            requestURL = requestURL.substring(0, idx);
            Response response = Response.created((URI)KMS.getKeyURI("/v1", name)).type("application/json").header("Location", (Object)KMS.getKeyURI(requestURL, name)).entity((Object)json).build();
            return response;
        }
        catch (Exception e) {
            LOG.error("Exception in createKey.", (Throwable)e);
            throw e;
        }
        finally {
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== createKey()");
            }
        }
    }

    @DELETE
    @Path(value="key/{name:.*}")
    public Response deleteKey(@PathParam(value="name") String name, @Context HttpServletRequest request) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> deleteKey({})", (Object)name);
        }
        try {
            KMSWebApp.getAdminCallsMeter().mark();
            UserGroupInformation user = HttpUserGroupInformation.get();
            this.assertAccess(KMSACLsType.Type.DELETE, user, KMSOp.DELETE_KEY, name, request.getRemoteAddr());
            KMSUtil.checkNotEmpty((String)name, (String)"name");
            user.doAs(() -> {
                this.provider.deleteKey(name);
                this.provider.flush();
                return null;
            });
            this.kmsAudit.ok(user, KMSOp.DELETE_KEY, name, "");
            Response response = Response.ok().build();
            return response;
        }
        catch (Exception e) {
            LOG.error("Exception in deleteKey.", (Throwable)e);
            throw e;
        }
        finally {
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== deleteKey({})", (Object)name);
            }
        }
    }

    @POST
    @Path(value="key/{name:.*}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response rolloverKey(@PathParam(value="name") String name, Map jsonMaterial, @Context HttpServletRequest request) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> rolloverKey({})", (Object)name);
        }
        try {
            KMSWebApp.getAdminCallsMeter().mark();
            UserGroupInformation user = HttpUserGroupInformation.get();
            this.assertAccess(KMSACLsType.Type.ROLLOVER, user, KMSOp.ROLL_NEW_VERSION, name, request.getRemoteAddr());
            KMSUtil.checkNotEmpty((String)name, (String)"name");
            String material = (String)jsonMaterial.get("material");
            if (material != null) {
                this.assertAccess(KMSACLsType.Type.SET_KEY_MATERIAL, user, KMSOp.ROLL_NEW_VERSION, name, request.getRemoteAddr());
            }
            KeyProvider.KeyVersion keyVersion = (KeyProvider.KeyVersion)user.doAs(() -> {
                KeyProvider.KeyVersion ret = material != null ? this.provider.rollNewVersion(name, Base64.decodeBase64((String)material)) : this.provider.rollNewVersion(name);
                this.provider.flush();
                return ret;
            });
            this.kmsAudit.ok(user, KMSOp.ROLL_NEW_VERSION, name, "UserProvidedMaterial:" + (material != null) + " NewVersion:" + keyVersion.getVersionName());
            if (!KMSWebApp.getACLs().hasAccess(KMSACLsType.Type.GET, user, request.getRemoteAddr())) {
                keyVersion = KMS.removeKeyMaterial(keyVersion);
            }
            Map json = KMSUtil.toJSON((KeyProvider.KeyVersion)keyVersion);
            Response response = Response.ok().type("application/json").entity((Object)json).build();
            return response;
        }
        catch (Exception e) {
            LOG.error("Exception in rolloverKey.", (Throwable)e);
            throw e;
        }
        finally {
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== rolloverKey({})", (Object)name);
            }
        }
    }

    @POST
    @Path(value="key/{name:.*}/_invalidatecache")
    public Response invalidateCache(@PathParam(value="name") String name) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> invalidateCache({})", (Object)name);
        }
        try {
            KMSWebApp.getAdminCallsMeter().mark();
            KMSUtil.checkNotEmpty((String)name, (String)"name");
            UserGroupInformation user = HttpUserGroupInformation.get();
            this.assertAccess(KMSACLsType.Type.ROLLOVER, user, KMSOp.INVALIDATE_CACHE, name);
            user.doAs(() -> {
                this.provider.invalidateCache(name);
                this.provider.flush();
                return null;
            });
            this.kmsAudit.ok(user, KMSOp.INVALIDATE_CACHE, name, "");
            Response response = Response.ok().build();
            return response;
        }
        catch (Exception e) {
            LOG.error("Exception in invalidateCache for key name {}.", (Object)name, (Object)e);
            throw e;
        }
        finally {
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== invalidateCache({})", (Object)name);
            }
        }
    }

    @GET
    @Path(value="keys/metadata")
    @Produces(value={"application/json"})
    public Response getKeysMetadata(@QueryParam(value="key") List<String> keyNamesList, @Context HttpServletRequest request) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getKeysMetadata()");
        }
        try {
            KMSWebApp.getAdminCallsMeter().mark();
            UserGroupInformation user = HttpUserGroupInformation.get();
            String[] keyNames = keyNamesList.toArray(new String[0]);
            this.assertAccess(KMSACLsType.Type.GET_METADATA, user, KMSOp.GET_KEYS_METADATA, request.getRemoteAddr());
            KeyProvider.Metadata[] keysMeta = (KeyProvider.Metadata[])user.doAs(() -> this.provider.getKeysMetadata(keyNames));
            List json = KMSServerJSONUtils.toJSON(keyNames, keysMeta);
            this.kmsAudit.ok(user, KMSOp.GET_KEYS_METADATA, "");
            Response response = Response.ok().type("application/json").entity((Object)json).build();
            return response;
        }
        catch (Exception e) {
            LOG.error("Exception in getKeysmetadata.", (Throwable)e);
            throw e;
        }
        finally {
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== getKeysMetadata()");
            }
        }
    }

    @GET
    @Path(value="keys/names")
    @Produces(value={"application/json"})
    public Response getKeyNames(@Context HttpServletRequest request) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getKeyNames()");
        }
        try {
            KMSWebApp.getAdminCallsMeter().mark();
            UserGroupInformation user = HttpUserGroupInformation.get();
            this.assertAccess(KMSACLsType.Type.GET_KEYS, user, KMSOp.GET_KEYS, request.getRemoteAddr());
            List json = (List)user.doAs(() -> ((KeyProviderCryptoExtension)this.provider).getKeys());
            this.kmsAudit.ok(user, KMSOp.GET_KEYS, "");
            Response response = Response.ok().type("application/json").entity((Object)json).build();
            return response;
        }
        catch (Exception e) {
            LOG.error("Exception in getkeyNames.", (Throwable)e);
            throw e;
        }
        finally {
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== getKeyNames()");
            }
        }
    }

    @GET
    @Path(value="key/{name:.*}")
    public Response getKey(@PathParam(value="name") String name, @Context HttpServletRequest request) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getKey({})", (Object)name);
        }
        try {
            Response response = this.getMetadata(name, request);
            return response;
        }
        catch (Exception e) {
            LOG.error("Exception in getKey.", (Throwable)e);
            throw e;
        }
        finally {
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== getKey({})", (Object)name);
            }
        }
    }

    @GET
    @Path(value="key/{name:.*}/_metadata")
    @Produces(value={"application/json"})
    public Response getMetadata(@PathParam(value="name") String name, @Context HttpServletRequest request) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getMetadata({})", (Object)name);
        }
        try {
            UserGroupInformation user = HttpUserGroupInformation.get();
            KMSUtil.checkNotEmpty((String)name, (String)"name");
            KMSWebApp.getAdminCallsMeter().mark();
            this.assertAccess(KMSACLsType.Type.GET_METADATA, user, KMSOp.GET_METADATA, name, request.getRemoteAddr());
            KeyProvider.Metadata metadata = (KeyProvider.Metadata)user.doAs(() -> this.provider.getMetadata(name));
            Map json = KMSServerJSONUtils.toJSON(name, metadata);
            this.kmsAudit.ok(user, KMSOp.GET_METADATA, name, "");
            Response response = Response.ok().type("application/json").entity((Object)json).build();
            return response;
        }
        catch (Exception e) {
            LOG.error("Exception in getMetadata.", (Throwable)e);
            throw e;
        }
        finally {
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== getMetadata({})", (Object)name);
            }
        }
    }

    @GET
    @Path(value="key/{name:.*}/_currentversion")
    @Produces(value={"application/json"})
    public Response getCurrentVersion(@PathParam(value="name") String name, @Context HttpServletRequest request) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getCurrentVersion({})", (Object)name);
        }
        try {
            UserGroupInformation user = HttpUserGroupInformation.get();
            KMSUtil.checkNotEmpty((String)name, (String)"name");
            KMSWebApp.getKeyCallsMeter().mark();
            this.assertAccess(KMSACLsType.Type.GET, user, KMSOp.GET_CURRENT_KEY, name, request.getRemoteAddr());
            KeyProvider.KeyVersion keyVersion = (KeyProvider.KeyVersion)user.doAs(() -> this.provider.getCurrentKey(name));
            Map json = KMSUtil.toJSON((KeyProvider.KeyVersion)keyVersion);
            this.kmsAudit.ok(user, KMSOp.GET_CURRENT_KEY, name, "");
            Response response = Response.ok().type("application/json").entity((Object)json).build();
            return response;
        }
        catch (Exception e) {
            LOG.error("Exception in getCurrentVersion.", (Throwable)e);
            throw e;
        }
        finally {
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== getCurrentVersion({})", (Object)name);
            }
        }
    }

    @GET
    @Path(value="keyversion/{versionName:.*}")
    @Produces(value={"application/json"})
    public Response getKeyVersion(@PathParam(value="versionName") String versionName, @Context HttpServletRequest request) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getKeyVersion({})", (Object)versionName);
        }
        try {
            UserGroupInformation user = HttpUserGroupInformation.get();
            KMSUtil.checkNotEmpty((String)versionName, (String)"versionName");
            KMSWebApp.getKeyCallsMeter().mark();
            this.assertAccess(KMSACLsType.Type.GET, user, KMSOp.GET_KEY_VERSION, request.getRemoteAddr());
            KeyProvider.KeyVersion keyVersion = (KeyProvider.KeyVersion)user.doAs(() -> this.provider.getKeyVersion(versionName));
            if (keyVersion != null) {
                this.kmsAudit.ok(user, KMSOp.GET_KEY_VERSION, keyVersion.getName(), "");
            }
            Map json = KMSUtil.toJSON((KeyProvider.KeyVersion)keyVersion);
            Response response = Response.ok().type("application/json").entity((Object)json).build();
            return response;
        }
        catch (Exception e) {
            LOG.error("Exception in getKeyVersion.", (Throwable)e);
            throw e;
        }
        finally {
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== getKeyVersion({})", (Object)versionName);
            }
        }
    }

    @GET
    @Path(value="key/{name:.*}/_eek")
    @Produces(value={"application/json"})
    public Response generateEncryptedKeys(@PathParam(value="name") String name, @QueryParam(value="eek_op") String edekOp, @DefaultValue(value="1") @QueryParam(value="num_keys") int numKeys, @Context HttpServletRequest request) throws Exception {
        Response response;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> generateEncryptedKeys(name={}, eekOp={}, numKeys={})", new Object[]{name, edekOp, numKeys});
        }
        try {
            ArrayList<Map> retJSON;
            UserGroupInformation user = HttpUserGroupInformation.get();
            KMSUtil.checkNotEmpty((String)name, (String)"name");
            KMSUtil.checkNotNull((Object)edekOp, (String)"eekOp");
            if (edekOp.equals("generate")) {
                this.assertAccess(KMSACLsType.Type.GENERATE_EEK, user, KMSOp.GENERATE_EEK, name, request.getRemoteAddr());
                LinkedList retEdeks = new LinkedList();
                try {
                    user.doAs(() -> {
                        for (int i = 0; i < numKeys; ++i) {
                            retEdeks.add(this.provider.generateEncryptedKey(name));
                        }
                        return null;
                    });
                }
                catch (Exception e) {
                    LOG.error("Exception in generateEncryptedKeys:", (Throwable)e);
                    throw new IOException(e);
                }
                this.kmsAudit.ok(user, KMSOp.GENERATE_EEK, name, "");
                retJSON = new ArrayList<Map>();
                for (KeyProviderCryptoExtension.EncryptedKeyVersion edek : retEdeks) {
                    retJSON.add(KMSUtil.toJSON((KeyProviderCryptoExtension.EncryptedKeyVersion)edek));
                }
            } else {
                StringBuilder error = new StringBuilder("IllegalArgumentException Wrong ");
                error.append("eek_op").append(" value, it must be ").append("generate").append(" or ").append("decrypt");
                LOG.error(error.toString());
                throw new IllegalArgumentException(error.toString());
            }
            KMSWebApp.getGenerateEEKCallsMeter().mark();
            response = Response.ok().type("application/json").entity(retJSON).build();
        }
        catch (Exception e) {
            try {
                LOG.error("Exception in generateEncryptedKeys.", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("<== generateEncryptedKeys(name={}, eekOp={}, numKeys={})", new Object[]{name, edekOp, numKeys});
                }
                throw throwable;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== generateEncryptedKeys(name={}, eekOp={}, numKeys={})", new Object[]{name, edekOp, numKeys});
        }
        return response;
    }

    @POST
    @Path(value="key/{name:.*}/_reencryptbatch")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response reencryptEncryptedKeys(@PathParam(value="name") String name, List<Map> jsonPayload) throws Exception {
        Response response;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> reencryptEncryptedKeys(name={}, count={})", (Object)name, (Object)(jsonPayload != null ? jsonPayload.size() : 0));
        }
        try {
            Stopwatch sw = Stopwatch.createStarted();
            KMSUtil.checkNotEmpty((String)name, (String)"name");
            KMSUtil.checkNotNull(jsonPayload, (String)"jsonPayload");
            UserGroupInformation user = HttpUserGroupInformation.get();
            KMSWebApp.getReencryptEEKBatchCallsMeter().mark();
            if (jsonPayload.size() > 10000) {
                LOG.warn("Payload size {} too big for reencryptEncryptedKeys from user {}.", (Object)jsonPayload.size(), (Object)user);
            }
            this.assertAccess(KMSACLsType.Type.GENERATE_EEK, user, KMSOp.REENCRYPT_EEK_BATCH, name);
            List ekvs = KMSUtil.parseJSONEncKeyVersions((String)name, jsonPayload);
            Preconditions.checkArgument((ekvs.size() == jsonPayload.size() ? 1 : 0) != 0, (Object)"EncryptedKey size mismatch after parsing from json");
            for (KeyProviderCryptoExtension.EncryptedKeyVersion ekv : ekvs) {
                Preconditions.checkArgument((boolean)name.equals(ekv.getEncryptionKeyName()), (Object)("All EncryptedKeys must be under the given key name " + name));
            }
            user.doAs(() -> {
                this.provider.reencryptEncryptedKeys(ekvs);
                return null;
            });
            ArrayList<Map> retJSON = new ArrayList<Map>(ekvs.size());
            for (KeyProviderCryptoExtension.EncryptedKeyVersion ekv : ekvs) {
                retJSON.add(KMSUtil.toJSON((KeyProviderCryptoExtension.EncryptedKeyVersion)ekv));
            }
            this.kmsAudit.ok(user, KMSOp.REENCRYPT_EEK_BATCH, name, "reencrypted " + ekvs.size() + " keys");
            if (LOG.isDebugEnabled()) {
                LOG.debug("reencryptEncryptedKeys {} keys for key {} took {}", new Object[]{jsonPayload.size(), name, sw.stop()});
            }
            response = Response.ok().type("application/json").entity(retJSON).build();
        }
        catch (Exception e) {
            try {
                LOG.error("Exception in reencryptEncryptedKeys.", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("<== reencryptEncryptedKeys(name={}, count={})", (Object)name, (Object)(jsonPayload != null ? jsonPayload.size() : 0));
                }
                throw throwable;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== reencryptEncryptedKeys(name={}, count={})", (Object)name, (Object)(jsonPayload != null ? jsonPayload.size() : 0));
        }
        return response;
    }

    @POST
    @Path(value="keyversion/{versionName:.*}/_eek")
    @Produces(value={"application/json"})
    public Response handleEncryptedKeyOp(@PathParam(value="versionName") String versionName, @QueryParam(value="eek_op") String eekOp, Map jsonPayload, @Context HttpServletRequest request) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> handleEncryptedKeyOp(versionName={}, eekOp={})", (Object)versionName, (Object)eekOp);
        }
        try {
            Map retJSON;
            UserGroupInformation user = HttpUserGroupInformation.get();
            KMSUtil.checkNotEmpty((String)versionName, (String)"versionName");
            KMSUtil.checkNotNull((Object)eekOp, (String)"eekOp");
            String keyName = (String)jsonPayload.get("name");
            String ivStr = (String)jsonPayload.get("iv");
            String encMaterialStr = (String)jsonPayload.get("material");
            KMSUtil.checkNotNull((Object)ivStr, (String)"iv");
            byte[] iv = Base64.decodeBase64((String)ivStr);
            KMSUtil.checkNotNull((Object)encMaterialStr, (String)"material");
            byte[] encMaterial = Base64.decodeBase64((String)encMaterialStr);
            if (eekOp.equals("decrypt")) {
                KMSWebApp.getDecryptEEKCallsMeter().mark();
                this.assertAccess(KMSACLsType.Type.DECRYPT_EEK, user, KMSOp.DECRYPT_EEK, keyName, request.getRemoteAddr());
                KeyProvider.KeyVersion retKeyVersion = (KeyProvider.KeyVersion)user.doAs(() -> {
                    KMSClientProvider.KMSEncryptedKeyVersion ekv = new KMSClientProvider.KMSEncryptedKeyVersion(keyName, versionName, iv, "EEK", encMaterial);
                    return this.provider.decryptEncryptedKey((KeyProviderCryptoExtension.EncryptedKeyVersion)ekv);
                });
                retJSON = KMSUtil.toJSON((KeyProvider.KeyVersion)retKeyVersion);
                this.kmsAudit.ok(user, KMSOp.DECRYPT_EEK, keyName, "");
            } else if (eekOp.equals("reencrypt")) {
                KMSWebApp.getReencryptEEKCallsMeter().mark();
                this.assertAccess(KMSACLsType.Type.GENERATE_EEK, user, KMSOp.REENCRYPT_EEK, keyName);
                KeyProviderCryptoExtension.EncryptedKeyVersion retEncryptedKeyVersion = (KeyProviderCryptoExtension.EncryptedKeyVersion)user.doAs(() -> {
                    KMSClientProvider.KMSEncryptedKeyVersion ekv = new KMSClientProvider.KMSEncryptedKeyVersion(keyName, versionName, iv, "EEK", encMaterial);
                    return this.provider.reencryptEncryptedKey((KeyProviderCryptoExtension.EncryptedKeyVersion)ekv);
                });
                retJSON = KMSUtil.toJSON((KeyProviderCryptoExtension.EncryptedKeyVersion)retEncryptedKeyVersion);
                this.kmsAudit.ok(user, KMSOp.REENCRYPT_EEK, keyName, "");
            } else {
                StringBuilder error = new StringBuilder("IllegalArgumentException Wrong ");
                error.append("eek_op").append(" value, it must be ").append("generate").append(" or ").append("decrypt");
                LOG.error(error.toString());
                throw new IllegalArgumentException(error.toString());
            }
            Response response = Response.ok().type("application/json").entity((Object)retJSON).build();
            return response;
        }
        catch (Exception e) {
            LOG.error("Exception in handleEncryptedKeyOp.", (Throwable)e);
            throw e;
        }
        finally {
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== handleEncryptedKeyOp(versionName={}, eekOp={})", (Object)versionName, (Object)eekOp);
            }
        }
    }

    @GET
    @Path(value="key/{name:.*}/_versions")
    @Produces(value={"application/json"})
    public Response getKeyVersions(@PathParam(value="name") String name, @Context HttpServletRequest request) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getKeyVersions({})", (Object)name);
        }
        try {
            UserGroupInformation user = HttpUserGroupInformation.get();
            KMSUtil.checkNotEmpty((String)name, (String)"name");
            KMSWebApp.getKeyCallsMeter().mark();
            this.assertAccess(KMSACLsType.Type.GET, user, KMSOp.GET_KEY_VERSIONS, name, request.getRemoteAddr());
            List ret = (List)user.doAs(() -> this.provider.getKeyVersions(name));
            List json = KMSServerJSONUtils.toJSON(ret);
            this.kmsAudit.ok(user, KMSOp.GET_KEY_VERSIONS, name, "");
            Response response = Response.ok().type("application/json").entity((Object)json).build();
            return response;
        }
        catch (Exception e) {
            LOG.error("Exception in getKeyVersions.", (Throwable)e);
            throw e;
        }
        finally {
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== getKeyVersions({})", (Object)name);
            }
        }
    }

    private void assertAccess(KMSACLsType.Type aclType, UserGroupInformation ugi, KMSOp operation, String clientIp) throws AccessControlException {
        KMSWebApp.getACLs().assertAccess(aclType, ugi, operation, null, clientIp);
    }

    private void assertAccess(KMSACLsType.Type aclType, UserGroupInformation ugi, KMSOp operation, String key, String clientIp) throws AccessControlException {
        KMSWebApp.getACLs().assertAccess(aclType, ugi, operation, key, clientIp);
    }

    private void validateKeyName(String name) {
        Pattern pattern = Pattern.compile(KEY_NAME_VALIDATION);
        Matcher matcher = pattern.matcher(name);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Key Name : " + name + ", should start with alpha/numeric letters and can have special characters - (hypen) or _ (underscore)");
        }
    }

    private static KeyProvider.KeyVersion removeKeyMaterial(KeyProvider.KeyVersion keyVersion) {
        return new KMSClientProvider.KMSKeyVersion(keyVersion.getName(), keyVersion.getVersionName(), null);
    }

    private static URI getKeyURI(String domain, String keyName) {
        return UriBuilder.fromPath((String)"{a}/{b}/{c}").build(new Object[]{domain, "key", keyName});
    }

    public static enum KMSOp {
        CREATE_KEY,
        DELETE_KEY,
        ROLL_NEW_VERSION,
        INVALIDATE_CACHE,
        GET_KEYS,
        GET_KEYS_METADATA,
        GET_KEY_VERSIONS,
        GET_METADATA,
        GET_KEY_VERSION,
        GET_CURRENT_KEY,
        GENERATE_EEK,
        DECRYPT_EEK,
        REENCRYPT_EEK,
        REENCRYPT_EEK_BATCH;

    }
}

