/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.microsoft.aad.adal4j.AsymmetricKeyCredential;
import com.microsoft.aad.adal4j.AuthenticationContext;
import com.microsoft.aad.adal4j.AuthenticationResult;
import com.microsoft.aad.adal4j.ClientCredential;
import com.microsoft.azure.keyvault.KeyVaultClient;
import com.microsoft.azure.keyvault.authentication.KeyVaultCredentials;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8DecryptorProviderBuilder;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.PKCSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureKeyVaultClientAuthenticator
extends KeyVaultCredentials {
    private static final Logger logger = LoggerFactory.getLogger(AzureKeyVaultClientAuthenticator.class);
    private final String authClientID;
    private final String authClientSecret;

    public AzureKeyVaultClientAuthenticator(String clientID, String clientSecret) {
        if (logger.isDebugEnabled()) {
            logger.debug("==> AzureKeyVaultClientAuthenticator({})", (Object)clientID);
        }
        this.authClientID = clientID;
        this.authClientSecret = clientSecret;
        if (logger.isDebugEnabled()) {
            logger.debug("<== AzureKeyVaultClientAuthenticator({})", (Object)clientID);
        }
    }

    public AzureKeyVaultClientAuthenticator(String clientID) {
        if (logger.isDebugEnabled()) {
            logger.debug("==> AzureKeyVaultClientAuthenticator({})", (Object)clientID);
        }
        this.authClientID = clientID;
        this.authClientSecret = null;
        if (logger.isDebugEnabled()) {
            logger.debug("<== AzureKeyVaultClientAuthenticator({})", (Object)clientID);
        }
    }

    public String doAuthenticate(String authorization, String resource, String scope) {
        if (logger.isDebugEnabled()) {
            logger.debug("==> doAuthenticate({}, {}, {})", new Object[]{authorization, resource, scope});
        }
        AuthenticationResult token = AzureKeyVaultClientAuthenticator.getAccessTokenFromClientCredentials(authorization, resource, this.authClientID, this.authClientSecret);
        String ret = token.getAccessToken();
        if (logger.isDebugEnabled()) {
            logger.debug("<== doAuthenticate({}, {}, {}): ret={}", new Object[]{authorization, resource, scope, ret});
        }
        return ret;
    }

    public KeyVaultClient getAuthentication(String path, String certPassword) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("==> getAuthentication({})", (Object)path);
        }
        KeyVaultClient ret = null;
        KeyCert keyCert = null;
        if (path.endsWith(".pfx")) {
            try {
                keyCert = this.readPfx(path, certPassword);
            }
            catch (Exception ex) {
                throw new Exception("Error while parsing pfx certificate. Error : " + ex);
            }
        }
        if (path.endsWith(".pem")) {
            try {
                keyCert = this.readPem(path, certPassword);
            }
            catch (Exception ex) {
                throw new Exception("Error while parsing pem certificate. Error : " + ex);
            }
        }
        final KeyCert certificateKey = keyCert;
        if (certificateKey != null) {
            final PrivateKey privateKey = certificateKey.getKey();
            ret = new KeyVaultClient((ServiceClientCredentials)new KeyVaultCredentials(){

                public String doAuthenticate(String authorization, String resource, String scope) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("==> getAuthentication().doAuthenticate({}, {}, {})", new Object[]{authorization, resource, scope});
                    }
                    ExecutorService service = null;
                    try {
                        service = Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("kms-azure-akc_acquireToken_thread").build());
                        AuthenticationContext context = new AuthenticationContext(authorization, false, service);
                        AsymmetricKeyCredential asymmetricKeyCredential = AsymmetricKeyCredential.create((String)AzureKeyVaultClientAuthenticator.this.authClientID, (PrivateKey)privateKey, (X509Certificate)certificateKey.getCertificate());
                        AuthenticationResult result = (AuthenticationResult)context.acquireToken(resource, asymmetricKeyCredential, null).get();
                        String ret = result.getAccessToken();
                        if (logger.isDebugEnabled()) {
                            logger.debug("<== getAuthentication().doAuthenticate({}, {}, {})", new Object[]{authorization, resource, scope});
                        }
                        String string = ret;
                        return string;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error while getting authenticated access token from azure key vault with certificate : " + e);
                    }
                    finally {
                        if (service != null) {
                            service.shutdown();
                        }
                    }
                }
            });
        }
        if (logger.isDebugEnabled()) {
            logger.debug("<== getAuthentication({}): ret={}", (Object)path, ret);
        }
        return ret;
    }

    private static AuthenticationResult getAccessTokenFromClientCredentials(String authorization, String resource, String clientId, String clientKey) {
        AuthenticationResult result;
        if (logger.isDebugEnabled()) {
            logger.debug("==> getAccessTokenFromClientCredentials({}, {}, {})", new Object[]{authorization, resource, clientId});
        }
        ExecutorService service = null;
        try {
            service = Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("kms-azure-cc_acquireToken-thread").build());
            AuthenticationContext context = new AuthenticationContext(authorization, false, service);
            ClientCredential credentials = new ClientCredential(clientId, clientKey);
            Future future = context.acquireToken(resource, credentials, null);
            result = (AuthenticationResult)future.get();
        }
        catch (Exception e) {
            throw new RuntimeException(" Error while getting Access token for client id: " + clientId + " and client secret. Error : " + e);
        }
        finally {
            if (service != null) {
                service.shutdown();
            }
        }
        if (result == null) {
            throw new RuntimeException("authentication result was null");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("<== getAccessTokenFromClientCredentials({}, {}, {})", new Object[]{authorization, resource, clientId});
        }
        return result;
    }

    private KeyCert readPem(String path, String password) throws IOException, CertificateException, OperatorCreationException, PKCSException {
        if (logger.isDebugEnabled()) {
            logger.debug("==> readPem({})", (Object)path);
        }
        Security.addProvider((Provider)new BouncyCastleProvider());
        PEMParser pemParser = new PEMParser((Reader)new FileReader(path));
        PrivateKey privateKey = null;
        X509Certificate cert = null;
        Object object = pemParser.readObject();
        while (object != null) {
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
            if (object instanceof X509CertificateHolder) {
                cert = new JcaX509CertificateConverter().getCertificate((X509CertificateHolder)object);
            } else if (object instanceof PKCS8EncryptedPrivateKeyInfo) {
                PKCS8EncryptedPrivateKeyInfo pinfo = (PKCS8EncryptedPrivateKeyInfo)object;
                InputDecryptorProvider provider = new JceOpenSSLPKCS8DecryptorProviderBuilder().build(password.toCharArray());
                PrivateKeyInfo info = pinfo.decryptPrivateKeyInfo(provider);
                privateKey = converter.getPrivateKey(info);
            } else if (object instanceof PrivateKeyInfo) {
                privateKey = converter.getPrivateKey((PrivateKeyInfo)object);
            }
            object = pemParser.readObject();
        }
        KeyCert keycert = new KeyCert(cert, privateKey);
        pemParser.close();
        if (logger.isDebugEnabled()) {
            logger.debug("<== readPem({})", (Object)path);
        }
        return keycert;
    }

    private KeyCert readPfx(String path, String password) throws NoSuchProviderException, KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        logger.debug("==> readPfx({})", (Object)path);
        try (FileInputStream stream = new FileInputStream(path);){
            KeyCert keyCert = null;
            boolean isAliasWithPrivateKey = false;
            KeyStore store = KeyStore.getInstance("pkcs12", "SunJSSE");
            store.load(stream, password.toCharArray());
            Enumeration<String> aliases = store.aliases();
            String alias = "";
            while (aliases.hasMoreElements() && !(isAliasWithPrivateKey = store.isKeyEntry(alias = aliases.nextElement()))) {
            }
            if (isAliasWithPrivateKey) {
                X509Certificate certificate = (X509Certificate)store.getCertificate(alias);
                PrivateKey key = (PrivateKey)store.getKey(alias, password.toCharArray());
                keyCert = new KeyCert(certificate, key);
            }
            logger.debug("<== readPfx({})", (Object)path);
            KeyCert keyCert2 = keyCert;
            return keyCert2;
        }
    }

    private static class KeyCert {
        private final X509Certificate certificate;
        private final PrivateKey key;

        public KeyCert(X509Certificate certificate, PrivateKey key) {
            this.certificate = certificate;
            this.key = key;
        }

        public X509Certificate getCertificate() {
            return this.certificate;
        }

        public PrivateKey getKey() {
            return this.key;
        }
    }
}

