/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.hadoop;

import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.ranger.authorization.hadoop.RangerHdfsAuditHandler;
import org.apache.ranger.authorization.hadoop.RangerHdfsPlugin;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;

class AuthzContext {
    public final RangerHdfsPlugin plugin;
    public final String user;
    public final Set<String> userGroups;
    public final String operationName;
    public final boolean isTraverseOnlyCheck;
    public RangerHdfsAuditHandler auditHandler = null;
    private RangerAccessResult lastResult = null;

    public AuthzContext(RangerHdfsPlugin plugin, UserGroupInformation ugi, String operationName, boolean isTraverseOnlyCheck) {
        this.plugin = plugin;
        this.user = ugi != null ? ugi.getShortUserName() : null;
        this.userGroups = ugi != null ? Sets.newHashSet((Object[])ugi.getGroupNames()) : null;
        this.operationName = operationName;
        this.isTraverseOnlyCheck = isTraverseOnlyCheck;
    }

    public void saveResult(RangerAccessResult result) {
        if (result != null) {
            this.lastResult = result;
        }
    }

    public RangerAccessResult getLastResult() {
        return this.lastResult;
    }
}

