/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyevaluator;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.conditionevaluator.RangerConditionEvaluator;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngineOptions;
import org.apache.ranger.plugin.util.RangerPerfTracer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerCustomConditionEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(RangerCustomConditionEvaluator.class);
    private static final Logger PERF_POLICY_INIT_LOG = RangerPerfTracer.getPerfLogger("policy.init");
    private static final Logger PERF_POLICYITEM_INIT_LOG = RangerPerfTracer.getPerfLogger("policyitem.init");
    private static final Logger PERF_POLICYCONDITION_INIT_LOG = RangerPerfTracer.getPerfLogger("policycondition.init");

    public List<RangerConditionEvaluator> getRangerPolicyConditionEvaluator(RangerPolicy policy, RangerServiceDef serviceDef, RangerPolicyEngineOptions options) {
        ArrayList<RangerConditionEvaluator> conditionEvaluators = new ArrayList<RangerConditionEvaluator>();
        if (!this.getConditionsDisabledOption(options) && CollectionUtils.isNotEmpty(policy.getConditions())) {
            RangerPerfTracer perf = null;
            long policyId = policy.getId();
            if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICY_INIT_LOG)) {
                perf = RangerPerfTracer.getPerfTracer(PERF_POLICY_INIT_LOG, "RangerCustomConditionEvaluator.init(policyId=" + policyId + ")");
            }
            for (RangerPolicy.RangerPolicyItemCondition condition : policy.getConditions()) {
                RangerServiceDef.RangerPolicyConditionDef conditionDef = this.getConditionDef(condition.getType(), serviceDef);
                if (conditionDef == null) {
                    LOG.error("RangerCustomConditionEvaluator.getRangerPolicyConditionEvaluator(policyId=" + policyId + "): conditionDef '" + condition.getType() + "' not found. Ignoring the condition");
                    continue;
                }
                RangerConditionEvaluator conditionEvaluator = this.newConditionEvaluator(conditionDef.getEvaluator());
                if (conditionEvaluator != null) {
                    conditionEvaluator.setServiceDef(serviceDef);
                    conditionEvaluator.setConditionDef(conditionDef);
                    conditionEvaluator.setPolicyItemCondition(condition);
                    RangerPerfTracer perfConditionInit = null;
                    if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYCONDITION_INIT_LOG)) {
                        perfConditionInit = RangerPerfTracer.getPerfTracer(PERF_POLICYCONDITION_INIT_LOG, "RangerConditionEvaluator.init(policyId=" + policyId + "policyConditionType=" + condition.getType() + ")");
                    }
                    conditionEvaluator.init();
                    RangerPerfTracer.log(perfConditionInit);
                    conditionEvaluators.add(conditionEvaluator);
                    continue;
                }
                LOG.error("RangerCustomConditionEvaluator.getRangerPolicyConditionEvaluator(policyId=" + policyId + "): failed to init Policy ConditionEvaluator '" + condition.getType() + "'; evaluatorClassName='" + conditionDef.getEvaluator() + "'");
            }
            RangerPerfTracer.log(perf);
        }
        return conditionEvaluators;
    }

    public List<RangerConditionEvaluator> getPolicyItemConditionEvaluator(RangerPolicy policy, RangerPolicy.RangerPolicyItem policyItem, RangerServiceDef serviceDef, RangerPolicyEngineOptions options, int policyItemIndex) {
        ArrayList<RangerConditionEvaluator> conditionEvaluators = new ArrayList<RangerConditionEvaluator>();
        if (!this.getConditionsDisabledOption(options) && CollectionUtils.isNotEmpty(policyItem.getConditions())) {
            RangerPerfTracer perf = null;
            Long policyId = policy.getId();
            if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYITEM_INIT_LOG)) {
                perf = RangerPerfTracer.getPerfTracer(PERF_POLICYITEM_INIT_LOG, "RangerPolicyItemEvaluator.getRangerPolicyConditionEvaluator(policyId=" + policyId + ",policyItemIndex=" + policyItemIndex + ")");
            }
            for (RangerPolicy.RangerPolicyItemCondition condition : policyItem.getConditions()) {
                RangerServiceDef.RangerPolicyConditionDef conditionDef = this.getConditionDef(condition.getType(), serviceDef);
                if (conditionDef == null) {
                    LOG.error("RangerCustomConditionEvaluator.getPolicyItemConditionEvaluator(policyId=" + policyId + "): conditionDef '" + condition.getType() + "' not found. Ignoring the condition");
                    continue;
                }
                RangerConditionEvaluator conditionEvaluator = this.newConditionEvaluator(conditionDef.getEvaluator());
                if (conditionEvaluator != null) {
                    conditionEvaluator.setServiceDef(serviceDef);
                    conditionEvaluator.setConditionDef(conditionDef);
                    conditionEvaluator.setPolicyItemCondition(condition);
                    RangerPerfTracer perfConditionInit = null;
                    if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYCONDITION_INIT_LOG)) {
                        perfConditionInit = RangerPerfTracer.getPerfTracer(PERF_POLICYCONDITION_INIT_LOG, "RangerConditionEvaluator.init(policyId=" + policyId + ",policyItemIndex=" + policyItemIndex + ",policyConditionType=" + condition.getType() + ")");
                    }
                    conditionEvaluator.init();
                    RangerPerfTracer.log(perfConditionInit);
                    conditionEvaluators.add(conditionEvaluator);
                    continue;
                }
                LOG.error("RangerCustomConditionEvaluator.getPolicyItemConditionEvaluator(policyId=" + policyId + "): failed to init PolicyItem ConditionEvaluator '" + condition.getType() + "'; evaluatorClassName='" + conditionDef.getEvaluator() + "'");
            }
            RangerPerfTracer.log(perf);
        }
        return conditionEvaluators;
    }

    private RangerServiceDef.RangerPolicyConditionDef getConditionDef(String conditionName, RangerServiceDef serviceDef) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerCustomConditionEvaluator.getConditionDef(" + conditionName + ")");
        }
        RangerServiceDef.RangerPolicyConditionDef ret = null;
        if (serviceDef != null && CollectionUtils.isNotEmpty(serviceDef.getPolicyConditions())) {
            for (RangerServiceDef.RangerPolicyConditionDef conditionDef : serviceDef.getPolicyConditions()) {
                if (!StringUtils.equals((String)conditionName, (String)conditionDef.getName())) continue;
                ret = conditionDef;
                break;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerCustomConditionEvaluator.getConditionDef(" + conditionName + "): " + ret);
        }
        return ret;
    }

    private RangerConditionEvaluator newConditionEvaluator(String className) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerCustomConditionEvaluator.newConditionEvaluator(" + className + ")");
        }
        RangerConditionEvaluator evaluator = null;
        try {
            Class<?> matcherClass = Class.forName(className);
            evaluator = (RangerConditionEvaluator)matcherClass.newInstance();
        }
        catch (Throwable t) {
            LOG.error("RangerCustomConditionEvaluator.newConditionEvaluator(" + className + "): error instantiating evaluator", t);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerCustomConditionEvaluator.newConditionEvaluator(" + className + "): " + evaluator);
        }
        return evaluator;
    }

    private boolean getConditionsDisabledOption(RangerPolicyEngineOptions options) {
        return options != null && options.disableCustomConditions;
    }
}

