/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.contextenricher;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.contextenricher.RangerTagRetriever;
import org.apache.ranger.plugin.util.ServiceTags;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerFileBasedTagRetriever
extends RangerTagRetriever {
    private static final Logger LOG = LoggerFactory.getLogger(RangerFileBasedTagRetriever.class);
    private URL serviceTagsFileURL;
    private String serviceTagsFileName;
    private Gson gsonBuilder;
    private boolean deDupTags;

    @Override
    public void init(Map<String, String> options) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> init()");
        }
        this.gsonBuilder = new GsonBuilder().setDateFormat("yyyyMMdd-HH:mm:ss.SSS-Z").setPrettyPrinting().create();
        String serviceTagsFileNameProperty = "serviceTagsFileName";
        String serviceTagsDefaultFileName = "/testdata/test_servicetags_hive.json";
        String deDupTagsProperty = "deDupTags";
        if (StringUtils.isNotBlank((String)this.serviceName) && this.serviceDef != null && StringUtils.isNotBlank((String)this.appId)) {
            InputStream serviceTagsFileStream = null;
            this.serviceTagsFileName = options != null ? options.get(serviceTagsFileNameProperty) : null;
            String deDupTagsVal = options != null ? options.get(deDupTagsProperty) : "false";
            this.deDupTags = Boolean.parseBoolean(deDupTagsVal);
            this.serviceTagsFileName = this.serviceTagsFileName == null ? serviceTagsDefaultFileName : this.serviceTagsFileName;
            File f = new File(this.serviceTagsFileName);
            if (f.exists() && f.isFile() && f.canRead()) {
                try {
                    serviceTagsFileStream = new FileInputStream(f);
                    this.serviceTagsFileURL = f.toURI().toURL();
                }
                catch (FileNotFoundException exception) {
                    LOG.error("Error processing input file:" + this.serviceTagsFileName + " or no privilege for reading file " + this.serviceTagsFileName, (Throwable)exception);
                }
                catch (MalformedURLException malformedException) {
                    LOG.error("Error processing input file:" + this.serviceTagsFileName + " cannot be converted to URL " + this.serviceTagsFileName, (Throwable)malformedException);
                }
            } else {
                URL fileURL = this.getClass().getResource(this.serviceTagsFileName);
                if (fileURL == null && !this.serviceTagsFileName.startsWith("/")) {
                    fileURL = this.getClass().getResource("/" + this.serviceTagsFileName);
                }
                if (fileURL == null && (fileURL = ClassLoader.getSystemClassLoader().getResource(this.serviceTagsFileName)) == null && !this.serviceTagsFileName.startsWith("/")) {
                    fileURL = ClassLoader.getSystemClassLoader().getResource("/" + this.serviceTagsFileName);
                }
                if (fileURL != null) {
                    try {
                        serviceTagsFileStream = fileURL.openStream();
                        this.serviceTagsFileURL = fileURL;
                    }
                    catch (Exception exception) {
                        LOG.error(this.serviceTagsFileName + " is not a file", (Throwable)exception);
                    }
                } else {
                    LOG.warn("Error processing input file: URL not found for " + this.serviceTagsFileName + " or no privilege for reading file " + this.serviceTagsFileName);
                }
            }
            if (serviceTagsFileStream != null) {
                try {
                    serviceTagsFileStream.close();
                }
                catch (Exception exception) {}
            }
        } else {
            LOG.error("FATAL: Cannot find service/serviceDef/serviceTagsFile to use for retrieving tags. Will NOT be able to retrieve tags.");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== init() : serviceTagsFileName=" + this.serviceTagsFileName);
        }
    }

    @Override
    public ServiceTags retrieveTags(long lastKnownVersion, long lastActivationTimeInMillis) throws Exception {
        ServiceTags serviceTags;
        block19: {
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> retrieveTags(lastKnownVersion=" + lastKnownVersion + ", lastActivationTimeInMillis=" + lastActivationTimeInMillis + ", serviceTagsFilePath=" + this.serviceTagsFileName);
            }
            serviceTags = null;
            if (this.serviceTagsFileURL != null) {
                try (InputStream serviceTagsFileStream = this.serviceTagsFileURL.openStream();
                     InputStreamReader reader = new InputStreamReader(serviceTagsFileStream, Charset.forName("UTF-8"));){
                    serviceTags = (ServiceTags)this.gsonBuilder.fromJson((Reader)reader, ServiceTags.class);
                    if (serviceTags.getTagVersion() <= lastKnownVersion) {
                        serviceTags = null;
                    } else if (this.deDupTags) {
                        int countOfDuplicateTags = serviceTags.dedupTags();
                        LOG.info("Number of duplicate tags removed from the received serviceTags:[" + countOfDuplicateTags + "]. Number of tags in the de-duplicated serviceTags :[" + serviceTags.getTags().size() + "].");
                    }
                    break block19;
                }
                catch (IOException e) {
                    LOG.warn("Error processing input file: or no privilege for reading file " + this.serviceTagsFileName);
                    throw e;
                }
            }
            LOG.error("Error reading file: " + this.serviceTagsFileName);
            throw new Exception("serviceTagsFileURL is null!");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== retrieveTags(lastKnownVersion=" + lastKnownVersion + ", lastActivationTimeInMillis=" + lastActivationTimeInMillis);
        }
        return serviceTags;
    }
}

