/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.watcher;

import org.elasticsearch.client.Validatable;
import org.elasticsearch.client.ValidationException;
import org.elasticsearch.client.watcher.PutWatchRequest;

public final class GetWatchRequest
implements Validatable {
    private final String id;

    public GetWatchRequest(String watchId) {
        this.validateId(watchId);
        this.id = watchId;
    }

    private void validateId(String watchId) {
        ValidationException exception = new ValidationException();
        if (watchId == null) {
            exception.addValidationError("watch id is missing");
        } else if (!PutWatchRequest.isValidId(watchId)) {
            exception.addValidationError("watch id contains whitespace");
        }
        if (!exception.validationErrors().isEmpty()) {
            throw exception;
        }
    }

    public String getId() {
        return this.id;
    }
}

