/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import com.carrotsearch.hppc.LongHashSet;
import com.carrotsearch.hppc.LongSet;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.time.DateMathParser;
import org.elasticsearch.index.fielddata.LongScriptFieldData;
import org.elasticsearch.index.mapper.AbstractScriptFieldType;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.index.mapper.RuntimeField;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.script.CompositeFieldScript;
import org.elasticsearch.script.LongFieldScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.runtime.LongScriptFieldExistsQuery;
import org.elasticsearch.search.runtime.LongScriptFieldRangeQuery;
import org.elasticsearch.search.runtime.LongScriptFieldTermQuery;
import org.elasticsearch.search.runtime.LongScriptFieldTermsQuery;

public final class LongScriptFieldType
extends AbstractScriptFieldType<LongFieldScript.LeafFactory> {
    public static final RuntimeField.Parser PARSER = new RuntimeField.Parser(Builder::new);

    public static RuntimeField sourceOnly(String name) {
        return new Builder(name).createRuntimeField(LongFieldScript.PARSE_FROM_SOURCE);
    }

    public LongScriptFieldType(String name, LongFieldScript.Factory scriptFactory, Script script, Map<String, String> meta) {
        super(name, searchLookup -> scriptFactory.newFactory(name, script.getParams(), (SearchLookup)searchLookup), script, scriptFactory.isResultDeterministic(), meta);
    }

    @Override
    public String typeName() {
        return NumberFieldMapper.NumberType.LONG.typeName();
    }

    @Override
    public Object valueForDisplay(Object value) {
        return value;
    }

    @Override
    public DocValueFormat docValueFormat(String format, ZoneId timeZone) {
        this.checkNoTimeZone(timeZone);
        if (format == null) {
            return DocValueFormat.RAW;
        }
        return new DocValueFormat.Decimal(format);
    }

    @Override
    public LongScriptFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
        return new LongScriptFieldData.Builder(this.name(), (LongFieldScript.LeafFactory)this.leafFactory(searchLookup.get()));
    }

    @Override
    public Query existsQuery(SearchExecutionContext context) {
        this.applyScriptContext(context);
        return new LongScriptFieldExistsQuery(this.script, ((LongFieldScript.LeafFactory)this.leafFactory(context))::newInstance, this.name());
    }

    @Override
    public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, ZoneId timeZone, DateMathParser parser, SearchExecutionContext context) {
        this.applyScriptContext(context);
        return NumberFieldMapper.NumberType.longRangeQuery(lowerTerm, upperTerm, includeLower, includeUpper, (l, u) -> new LongScriptFieldRangeQuery(this.script, ((LongFieldScript.LeafFactory)this.leafFactory(context))::newInstance, this.name(), (long)l, (long)u));
    }

    @Override
    public Query termQuery(Object value, SearchExecutionContext context) {
        if (NumberFieldMapper.NumberType.hasDecimalPart(value)) {
            return Queries.newMatchNoDocsQuery("Value [" + value + "] has a decimal part");
        }
        this.applyScriptContext(context);
        return new LongScriptFieldTermQuery(this.script, ((LongFieldScript.LeafFactory)this.leafFactory(context))::newInstance, this.name(), NumberFieldMapper.NumberType.objectToLong(value, true));
    }

    @Override
    public Query termsQuery(Collection<?> values, SearchExecutionContext context) {
        if (values.isEmpty()) {
            return Queries.newMatchAllQuery();
        }
        LongHashSet terms = new LongHashSet(values.size());
        for (Object value : values) {
            if (NumberFieldMapper.NumberType.hasDecimalPart(value)) continue;
            terms.add(NumberFieldMapper.NumberType.objectToLong(value, true));
        }
        if (terms.isEmpty()) {
            return Queries.newMatchNoDocsQuery("All values have a decimal part");
        }
        this.applyScriptContext(context);
        return new LongScriptFieldTermsQuery(this.script, ((LongFieldScript.LeafFactory)this.leafFactory(context))::newInstance, this.name(), (LongSet)terms);
    }

    private static class Builder
    extends AbstractScriptFieldType.Builder<LongFieldScript.Factory> {
        Builder(String name) {
            super(name, LongFieldScript.CONTEXT);
        }

        @Override
        AbstractScriptFieldType<?> createFieldType(String name, LongFieldScript.Factory factory, Script script, Map<String, String> meta) {
            return new LongScriptFieldType(name, factory, script, meta);
        }

        @Override
        LongFieldScript.Factory getParseFromSourceFactory() {
            return LongFieldScript.PARSE_FROM_SOURCE;
        }

        @Override
        LongFieldScript.Factory getCompositeLeafFactory(Function<SearchLookup, CompositeFieldScript.LeafFactory> parentScriptFactory) {
            return LongFieldScript.leafAdapter(parentScriptFactory);
        }
    }
}

