/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.runtime;

import java.util.List;
import java.util.Objects;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.ByteRunAutomaton;
import org.elasticsearch.common.lucene.search.AutomatonQueries;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.StringFieldScript;
import org.elasticsearch.search.runtime.AbstractStringScriptFieldQuery;

public class StringScriptFieldPrefixQuery
extends AbstractStringScriptFieldQuery {
    private final String prefix;
    private final boolean caseInsensitive;

    public StringScriptFieldPrefixQuery(Script script, StringFieldScript.LeafFactory leafFactory, String fieldName, String prefix, boolean caseInsensitive) {
        super(script, leafFactory, fieldName);
        this.prefix = Objects.requireNonNull(prefix);
        this.caseInsensitive = caseInsensitive;
    }

    @Override
    protected boolean matches(List<String> values) {
        for (String value : values) {
            if (!StringScriptFieldPrefixQuery.startsWith(value, this.prefix, this.caseInsensitive)) continue;
            return true;
        }
        return false;
    }

    private static boolean startsWith(String str, String prefix, boolean ignoreCase) {
        if (str == null || prefix == null) {
            return str == null && prefix == null;
        }
        if (prefix.length() > str.length()) {
            return false;
        }
        return str.regionMatches(ignoreCase, 0, prefix, 0, prefix.length());
    }

    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.fieldName())) {
            visitor.consumeTermsMatching((Query)this, this.fieldName(), () -> new ByteRunAutomaton(this.buildAutomaton(new BytesRef((CharSequence)this.prefix))));
        }
    }

    Automaton buildAutomaton(BytesRef prefix) {
        if (this.caseInsensitive) {
            return AutomatonQueries.caseInsensitivePrefix(prefix.utf8ToString());
        }
        return PrefixQuery.toAutomaton((BytesRef)prefix);
    }

    public final String toString(String field) {
        if (this.fieldName().contentEquals(field)) {
            return this.prefix + "*";
        }
        return this.fieldName() + ":" + this.prefix + "*";
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.prefix, this.caseInsensitive);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        StringScriptFieldPrefixQuery other = (StringScriptFieldPrefixQuery)((Object)obj);
        return this.prefix.equals(other.prefix) && this.caseInsensitive == other.caseInsensitive;
    }

    String prefix() {
        return this.prefix;
    }

    boolean caseInsensitive() {
        return this.caseInsensitive;
    }
}

