/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.elasticsearch.common.geo.GeoJson;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.utils.WellKnownText;

public class GeometryFormatterFactory {
    public static final String GEOJSON = "geojson";
    public static final String WKT = "wkt";

    public static <T> Function<List<T>, List<Object>> getFormatter(String name, Function<T, Geometry> toGeometry) {
        switch (name) {
            case "geojson": {
                return geometries -> {
                    ArrayList objects = new ArrayList(geometries.size());
                    geometries.forEach(shape -> objects.add(GeoJson.toMap((Geometry)toGeometry.apply(shape))));
                    return objects;
                };
            }
            case "wkt": {
                return geometries -> {
                    ArrayList objects = new ArrayList(geometries.size());
                    geometries.forEach(shape -> objects.add(WellKnownText.toWKT((Geometry)((Geometry)toGeometry.apply(shape)))));
                    return objects;
                };
            }
        }
        throw new IllegalArgumentException("Unrecognized geometry format [" + name + "].");
    }
}

