/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.ranger.plugin.model.RangerServiceResource;
import org.apache.ranger.plugin.model.RangerTag;
import org.apache.ranger.plugin.model.RangerTagDef;
import org.apache.ranger.plugin.util.ServiceTags;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RangerServiceTags
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String OP_SET = "set";
    public static final String OP_DELETE = "delete";
    public static final String OP_REPLACE = "replace";
    private String op = "set";
    private String serviceName;
    private Map<Long, RangerTagDef> tagDefinitions;
    private Map<Long, RangerTag> tags;
    private List<RangerServiceResource> serviceResources;
    private Map<Long, List<Long>> resourceToTagIds;
    private Long tagVersion;
    private Date tagUpdateTime;

    public RangerServiceTags() {
        this(OP_SET, null, null, null, null, null, null, null);
    }

    public RangerServiceTags(String op, String serviceName, Map<Long, RangerTagDef> tagDefinitions, Map<Long, RangerTag> tags, List<RangerServiceResource> serviceResources, Map<Long, List<Long>> resourceToTagIds, Long tagVersion, Date tagUpdateTime) {
        this.setOp(op);
        this.setServiceName(serviceName);
        this.setTagDefinitions(tagDefinitions);
        this.setTags(tags);
        this.setServiceResources(serviceResources);
        this.setResourceToTagIds(resourceToTagIds);
        this.setTagVersion(tagVersion);
        this.setTagUpdateTime(tagUpdateTime);
    }

    public String getOp() {
        return this.op;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setOp(String op) {
        this.op = op;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public Map<Long, RangerTagDef> getTagDefinitions() {
        return this.tagDefinitions;
    }

    public void setTagDefinitions(Map<Long, RangerTagDef> tagDefinitions) {
        this.tagDefinitions = tagDefinitions == null ? new HashMap() : tagDefinitions;
    }

    public Map<Long, RangerTag> getTags() {
        return this.tags;
    }

    public void setTags(Map<Long, RangerTag> tags) {
        this.tags = tags == null ? new HashMap() : tags;
    }

    public List<RangerServiceResource> getServiceResources() {
        return this.serviceResources;
    }

    public void setServiceResources(List<RangerServiceResource> serviceResources) {
        this.serviceResources = serviceResources == null ? new ArrayList() : serviceResources;
    }

    public Map<Long, List<Long>> getResourceToTagIds() {
        return this.resourceToTagIds;
    }

    public void setResourceToTagIds(Map<Long, List<Long>> resourceToTagIds) {
        this.resourceToTagIds = resourceToTagIds == null ? new HashMap() : resourceToTagIds;
    }

    public Long getTagVersion() {
        return this.tagVersion;
    }

    public void setTagVersion(Long tagVersion) {
        this.tagVersion = tagVersion;
    }

    public Date getTagUpdateTime() {
        return this.tagUpdateTime;
    }

    public void setTagUpdateTime(Date tagUpdateTime) {
        this.tagUpdateTime = tagUpdateTime;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    public StringBuilder toString(StringBuilder sb) {
        sb.append("RangerServiceTags={").append("op=").append(this.op).append(", ").append("serviceName=").append(this.serviceName).append(", ").append("}");
        return sb;
    }

    public static ServiceTags toServiceTags(RangerServiceTags tags) {
        ServiceTags ret = null;
        if (tags != null) {
            ret = new ServiceTags(RangerServiceTags.toServiceTagsOp(tags.getOp()), tags.getServiceName(), tags.tagVersion, tags.getTagUpdateTime(), tags.getTagDefinitions(), tags.getTags(), tags.getServiceResources(), tags.getResourceToTagIds(), false, ServiceTags.TagsChangeExtent.ALL);
        }
        return ret;
    }

    public static RangerServiceTags toRangerServiceTags(ServiceTags tags) {
        RangerServiceTags ret = null;
        if (tags != null) {
            ret = new RangerServiceTags(RangerServiceTags.toRangerServiceTagsOp(tags.getOp()), tags.getServiceName(), tags.getTagDefinitions(), tags.getTags(), tags.getServiceResources(), tags.getResourceToTagIds(), tags.getTagVersion(), tags.getTagUpdateTime());
        }
        return ret;
    }

    private static String toServiceTagsOp(String rangerServiceTagsOp) {
        String ret = rangerServiceTagsOp;
        if (OP_SET.equals(rangerServiceTagsOp)) {
            ret = "add_or_update";
        }
        return ret;
    }

    private static String toRangerServiceTagsOp(String serviceTagsOp) {
        String ret = serviceTagsOp;
        if ("add_or_update".equals(serviceTagsOp)) {
            ret = OP_SET;
        }
        return ret;
    }
}

