/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch;

import java.util.Collections;
import java.util.List;
import org.apache.lucene.search.Query;
import org.elasticsearch.index.query.ParsedQuery;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.SearchExtBuilder;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.fetch.subphase.FetchDocValuesContext;
import org.elasticsearch.search.fetch.subphase.FetchFieldsContext;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.search.fetch.subphase.FieldAndFormat;
import org.elasticsearch.search.fetch.subphase.InnerHitsContext;
import org.elasticsearch.search.fetch.subphase.ScriptFieldsContext;
import org.elasticsearch.search.fetch.subphase.highlight.SearchHighlightContext;
import org.elasticsearch.search.internal.ContextIndexSearcher;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.lookup.SourceLookup;
import org.elasticsearch.search.rescore.RescoreContext;

public class FetchContext {
    private final SearchContext searchContext;
    private final SearchLookup searchLookup;

    public FetchContext(SearchContext searchContext) {
        this.searchContext = searchContext;
        this.searchLookup = searchContext.getSearchExecutionContext().lookup();
    }

    public String getIndexName() {
        return this.searchContext.indexShard().shardId().getIndexName();
    }

    public ContextIndexSearcher searcher() {
        return this.searchContext.searcher();
    }

    public SearchLookup searchLookup() {
        return this.searchLookup;
    }

    public Query query() {
        return this.searchContext.query();
    }

    public Query rewrittenQuery() {
        return this.searchContext.rewrittenQuery();
    }

    public ParsedQuery parsedQuery() {
        return this.searchContext.parsedQuery();
    }

    public ParsedQuery parsedPostFilter() {
        return this.searchContext.parsedPostFilter();
    }

    public FetchSourceContext fetchSourceContext() {
        return this.searchContext.fetchSourceContext();
    }

    public boolean explain() {
        return this.searchContext.explain() && this.searchContext.query() != null;
    }

    public List<RescoreContext> rescore() {
        return this.searchContext.rescore();
    }

    public boolean seqNoAndPrimaryTerm() {
        return this.searchContext.seqNoAndPrimaryTerm();
    }

    public FetchDocValuesContext docValuesContext() {
        FetchDocValuesContext dvContext = this.searchContext.docValuesContext();
        if (this.searchContext.collapse() != null) {
            String name = this.searchContext.collapse().getFieldName();
            if (dvContext == null) {
                return new FetchDocValuesContext(this.searchContext.getSearchExecutionContext(), Collections.singletonList(new FieldAndFormat(name, null)));
            }
            if (!this.searchContext.docValuesContext().fields().stream().map(ff -> ff.field).anyMatch(name::equals)) {
                dvContext.fields().add(new FieldAndFormat(name, null));
            }
        }
        return dvContext;
    }

    public SearchHighlightContext highlight() {
        return this.searchContext.highlight();
    }

    public boolean containsBrokenAnalysis(String field) {
        return this.searchContext.getSearchExecutionContext().containsBrokenAnalysis(field);
    }

    public boolean fetchScores() {
        return this.searchContext.sort() != null && this.searchContext.trackScores();
    }

    public InnerHitsContext innerHits() {
        return this.searchContext.innerHits();
    }

    public boolean version() {
        return this.searchContext.version();
    }

    public FetchFieldsContext fetchFieldsContext() {
        return this.searchContext.fetchFieldsContext();
    }

    public ScriptFieldsContext scriptFields() {
        return this.searchContext.scriptFields();
    }

    public SearchExtBuilder getSearchExt(String name) {
        return this.searchContext.getSearchExt(name);
    }

    public SearchExecutionContext getSearchExecutionContext() {
        return this.searchContext.getSearchExecutionContext();
    }

    public SourceLookup getRootSourceLookup(FetchSubPhase.HitContext hitContext) {
        if (this.searchContext instanceof InnerHitsContext.InnerHitSubContext && hitContext.hit().getNestedIdentity() != null) {
            InnerHitsContext.InnerHitSubContext innerHitsContext = (InnerHitsContext.InnerHitSubContext)this.searchContext;
            return innerHitsContext.getRootLookup();
        }
        return hitContext.sourceLookup();
    }
}

