/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.client;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Map;
import javax.security.auth.Subject;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.security.SecureClientLogin;
import org.apache.ranger.plugin.client.HadoopConfigHolder;
import org.apache.ranger.plugin.client.HadoopException;
import org.apache.ranger.plugin.util.PasswordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseClient {
    private static final Logger LOG = LoggerFactory.getLogger(BaseClient.class);
    private static final String DEFAULT_NAME_RULE = "DEFAULT";
    protected static final String DEFAULT_ERROR_MESSAGE = " You can still save the repository and start creating policies, but you would not be able to use autocomplete for resource names. Check ranger-admin logs in $RANGER_HOME/ranger-admin/ews/log/ for more info.";
    private String serviceName;
    private String defaultConfigFile;
    private Subject loginSubject;
    private HadoopConfigHolder configHolder;
    protected boolean useCleartextPassword;
    protected Map<String, String> connectionProperties;

    public BaseClient(String svcName, Map<String, String> connectionProperties) {
        this(svcName, connectionProperties, null);
    }

    public BaseClient(String serivceName, Map<String, String> connectionProperties, String defaultConfigFile) {
        this.serviceName = serivceName;
        this.connectionProperties = connectionProperties;
        this.defaultConfigFile = defaultConfigFile;
        this.init();
        this.login();
    }

    private void init() {
        this.configHolder = this.connectionProperties == null ? HadoopConfigHolder.getInstance(this.serviceName) : HadoopConfigHolder.getInstance(this.serviceName, this.connectionProperties, this.defaultConfigFile);
        this.useCleartextPassword = Boolean.parseBoolean(this.configHolder.getRangerSection().getProperty("use.cleartext.password"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void login() {
        prevCl = Thread.currentThread().getContextClassLoader();
        try {
            lookupPrincipal = SecureClientLogin.getPrincipal(this.configHolder.getLookupPrincipal(), InetAddress.getLocalHost().getCanonicalHostName());
            lookupKeytab = this.configHolder.getLookupKeytab();
            nameRules = this.configHolder.getNameRules();
            if (StringUtils.isEmpty((String)nameRules)) {
                if (BaseClient.LOG.isDebugEnabled()) {
                    BaseClient.LOG.debug("Name Rule is empty. Setting Name Rule as 'DEFAULT'");
                }
                nameRules = "DEFAULT";
            }
            userName = this.configHolder.getUserName();
            if (StringUtils.isEmpty((String)lookupPrincipal) || StringUtils.isEmpty((String)lookupKeytab)) {
                if (userName == null) {
                    throw this.createException("Unable to find login username for hadoop environment, [" + this.serviceName + "]", null);
                }
                keyTabFile = this.configHolder.getKeyTabFile();
                if (keyTabFile != null) {
                    if (this.configHolder.isKerberosAuthentication()) {
                        BaseClient.LOG.info("Init Login: security enabled, using username/keytab");
                        this.loginSubject = SecureClientLogin.loginUserFromKeytab(userName, keyTabFile, nameRules);
                    } else {
                        BaseClient.LOG.info("Init Login: using username");
                        this.loginSubject = SecureClientLogin.login(userName);
                    }
                } else {
                    encryptedPwd = this.configHolder.getPassword();
                    password = null;
                    if (encryptedPwd != null) {
                        try {
                            if (this.useCleartextPassword) ** GOTO lbl39
                            password = PasswordUtils.decryptPassword(encryptedPwd);
                        }
                        catch (Exception ex) {
                            BaseClient.LOG.info("Password decryption failed; trying connection with received password string");
                            password = null;
                        }
                        finally {
                            if (password == null) {
                                password = encryptedPwd;
                            }
                        }
                    } else {
                        BaseClient.LOG.info("Password decryption failed: no password was configured");
                    }
lbl39:
                    // 4 sources

                    if (this.configHolder.isKerberosAuthentication()) {
                        BaseClient.LOG.info("Init Login: using username/password");
                        this.loginSubject = SecureClientLogin.loginUserWithPassword(userName, password);
                    } else {
                        BaseClient.LOG.info("Init Login: security not enabled, using username");
                        this.loginSubject = SecureClientLogin.login(userName);
                    }
                }
            } else if (this.configHolder.isKerberosAuthentication()) {
                BaseClient.LOG.info("Init Lookup Login: security enabled, using lookupPrincipal/lookupKeytab");
                this.loginSubject = SecureClientLogin.loginUserFromKeytab(lookupPrincipal, lookupKeytab, nameRules);
            } else {
                BaseClient.LOG.info("Init Login: security not enabled, using username");
                this.loginSubject = SecureClientLogin.login(userName);
            }
        }
        catch (IOException ioe) {
            throw this.createException(ioe);
        }
        catch (SecurityException se) {
            throw this.createException(se);
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevCl);
        }
    }

    private HadoopException createException(Exception exp) {
        return this.createException("Unable to login to Hadoop environment [" + this.serviceName + "]", exp);
    }

    private HadoopException createException(String msgDesc, Exception exp) {
        HadoopException hdpException = new HadoopException(msgDesc, exp);
        String fullDescription = exp != null ? BaseClient.getMessage(exp) : msgDesc;
        hdpException.generateResponseDataMap(false, fullDescription + DEFAULT_ERROR_MESSAGE, msgDesc + DEFAULT_ERROR_MESSAGE, null, null);
        return hdpException;
    }

    public String getSerivceName() {
        return this.serviceName;
    }

    protected Subject getLoginSubject() {
        return this.loginSubject;
    }

    protected HadoopConfigHolder getConfigHolder() {
        return this.configHolder;
    }

    public static void generateResponseDataMap(boolean connectivityStatus, String message, String description, Long objectId, String fieldName, Map<String, Object> responseData) {
        responseData.put("connectivityStatus", connectivityStatus);
        responseData.put("message", message);
        responseData.put("description", description);
        responseData.put("objectId", objectId);
        responseData.put("fieldName", fieldName);
    }

    public static String getMessage(Throwable excp) {
        ArrayList<String> errList = new ArrayList<String>();
        while (excp != null) {
            String message = excp.getMessage();
            if (StringUtils.isNotEmpty((String)message) && !errList.contains(message + ". \n")) {
                errList.add(message + ". \n");
            }
            excp = excp.getCause();
        }
        return StringUtils.join(errList, (String)"");
    }
}

