/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.subphase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.NestedValueFetcher;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.NestedUtils;
import org.elasticsearch.search.fetch.subphase.FieldAndFormat;
import org.elasticsearch.search.fetch.subphase.UnmappedFieldFetcher;
import org.elasticsearch.search.lookup.SourceLookup;

public class FieldFetcher {
    private final Map<String, FieldContext> fieldContexts;
    private final UnmappedFieldFetcher unmappedFieldFetcher;

    public static FieldFetcher create(SearchExecutionContext context, Collection<FieldAndFormat> fieldAndFormats) {
        ArrayList<String> unmappedFetchPattern = new ArrayList<String>();
        ArrayList<ResolvedField> resolvedFields = new ArrayList<ResolvedField>();
        for (FieldAndFormat fieldAndFormat : fieldAndFormats) {
            String matchingPattern;
            String fieldPattern = fieldAndFormat.field;
            String string = matchingPattern = Regex.isSimpleMatchPattern(fieldPattern) ? fieldPattern : null;
            if (fieldAndFormat.includeUnmapped != null && fieldAndFormat.includeUnmapped.booleanValue()) {
                unmappedFetchPattern.add(fieldAndFormat.field);
            }
            for (String field : context.getMatchingFieldNames(fieldPattern)) {
                MappedFieldType ft = context.getFieldType(field);
                if (context.isMetadataField(field) && matchingPattern != null) continue;
                resolvedFields.add(new ResolvedField(field, matchingPattern, ft, fieldAndFormat.format));
            }
        }
        resolvedFields.sort(Comparator.comparing(f -> f.field));
        Map<String, FieldContext> fieldContexts = FieldFetcher.buildFieldContexts(context, "", resolvedFields, unmappedFetchPattern);
        UnmappedFieldFetcher unmappedFieldFetcher = FieldFetcher.buildUnmappedFieldFetcher(context, fieldContexts.keySet(), "", unmappedFetchPattern);
        return new FieldFetcher(fieldContexts, unmappedFieldFetcher);
    }

    private static UnmappedFieldFetcher buildUnmappedFieldFetcher(SearchExecutionContext context, Set<String> mappedFields, String nestedScope, List<String> unmappedFetchPatterns) {
        if (unmappedFetchPatterns.isEmpty()) {
            return UnmappedFieldFetcher.EMPTY;
        }
        HashSet<String> mappedAndNestedFields = new HashSet<String>(mappedFields);
        mappedAndNestedFields.addAll(context.getImmediateChildMappers(nestedScope));
        return new UnmappedFieldFetcher(mappedAndNestedFields, unmappedFetchPatterns);
    }

    private static ValueFetcher buildValueFetcher(SearchExecutionContext context, ResolvedField fieldAndFormat) {
        try {
            return fieldAndFormat.ft.valueFetcher(context, fieldAndFormat.format);
        }
        catch (IllegalArgumentException e) {
            StringBuilder error = new StringBuilder("error fetching [").append(fieldAndFormat.field).append(']');
            if (fieldAndFormat.matchingPattern != null) {
                error.append(" which matched [").append(fieldAndFormat.matchingPattern).append(']');
            }
            error.append(": ").append(e.getMessage());
            throw new IllegalArgumentException(error.toString(), e);
        }
    }

    private static Map<String, FieldContext> buildFieldContexts(SearchExecutionContext context, String nestedScope, List<ResolvedField> fields, List<String> unmappedFetchPatterns) {
        boolean includeUnmapped = !unmappedFetchPatterns.isEmpty();
        Map<String, List<ResolvedField>> fieldsByNestedMapper = NestedUtils.partitionByChildren(nestedScope, context.getImmediateChildMappers(nestedScope), fields, f -> f.field);
        LinkedHashMap<String, FieldContext> output = new LinkedHashMap<String, FieldContext>();
        for (String scope : fieldsByNestedMapper.keySet()) {
            if (nestedScope.equals(scope)) {
                for (ResolvedField ff : fieldsByNestedMapper.get(nestedScope)) {
                    output.put(ff.field, new FieldContext(ff.field, FieldFetcher.buildValueFetcher(context, ff)));
                }
                continue;
            }
            if (!includeUnmapped && fieldsByNestedMapper.get(scope).isEmpty()) continue;
            Map<String, FieldContext> scopedFields = FieldFetcher.buildFieldContexts(context, scope, fieldsByNestedMapper.get(scope), unmappedFetchPatterns);
            UnmappedFieldFetcher unmappedFieldFetcher = FieldFetcher.buildUnmappedFieldFetcher(context, scopedFields.keySet(), scope, unmappedFetchPatterns);
            NestedValueFetcher nvf = new NestedValueFetcher(scope, new FieldFetcher(scopedFields, unmappedFieldFetcher));
            output.put(scope, new FieldContext(scope, nvf));
        }
        return output;
    }

    public FieldFetcher(Map<String, FieldContext> fieldContexts, UnmappedFieldFetcher unmappedFieldFetcher) {
        this.fieldContexts = fieldContexts;
        this.unmappedFieldFetcher = unmappedFieldFetcher;
    }

    public Map<String, DocumentField> fetch(SourceLookup sourceLookup) throws IOException {
        HashMap<String, DocumentField> documentFields = new HashMap<String, DocumentField>();
        for (FieldContext context : this.fieldContexts.values()) {
            String field = context.fieldName;
            ValueFetcher valueFetcher = context.valueFetcher;
            ArrayList<Object> ignoredValues = new ArrayList<Object>();
            List<Object> parsedValues = valueFetcher.fetchValues(sourceLookup, ignoredValues);
            if (parsedValues.isEmpty() && ignoredValues.isEmpty()) continue;
            documentFields.put(field, new DocumentField(field, parsedValues, ignoredValues));
        }
        this.unmappedFieldFetcher.collectUnmapped(documentFields, sourceLookup);
        return documentFields;
    }

    public void setNextReader(LeafReaderContext readerContext) {
        for (FieldContext field : this.fieldContexts.values()) {
            field.valueFetcher.setNextReader(readerContext);
        }
    }

    private static class ResolvedField {
        String field;
        String matchingPattern;
        MappedFieldType ft;
        String format;

        ResolvedField(String field, String matchingPattern, MappedFieldType ft, String format) {
            this.field = field;
            this.matchingPattern = matchingPattern;
            this.ft = ft;
            this.format = format;
        }
    }

    private static class FieldContext {
        final String fieldName;
        final ValueFetcher valueFetcher;

        FieldContext(String fieldName, ValueFetcher valueFetcher) {
            this.fieldName = fieldName;
            this.valueFetcher = valueFetcher;
        }
    }
}

