/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.support;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.SingleBucketAggregator;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.elasticsearch.search.profile.aggregation.ProfilingAggregator;
import org.elasticsearch.search.sort.SortOrder;

public class AggregationPath {
    private static final String AGG_DELIM = ">";
    private final List<PathElement> pathElements;

    public static AggregationPath parse(String path) {
        String[] elements = Strings.tokenizeToStringArray(path, AGG_DELIM);
        ArrayList<PathElement> tokens = new ArrayList<PathElement>(elements.length);
        String[] tuple = new String[2];
        for (int i = 0; i < elements.length; ++i) {
            int index;
            String element = elements[i];
            if (i == elements.length - 1) {
                index = element.lastIndexOf(91);
                if (index >= 0) {
                    if (index == 0 || index > element.length() - 3) {
                        throw new AggregationExecutionException("Invalid path element [" + element + "] in path [" + path + "]");
                    }
                    if (element.charAt(element.length() - 1) != ']') {
                        throw new AggregationExecutionException("Invalid path element [" + element + "] in path [" + path + "]");
                    }
                    tokens.add(new PathElement(element, element.substring(0, index), element.substring(index + 1, element.length() - 1)));
                    continue;
                }
                index = element.lastIndexOf(46);
                if (index < 0) {
                    tokens.add(new PathElement(element, element, null));
                    continue;
                }
                if (index == 0 || index > element.length() - 2) {
                    throw new AggregationExecutionException("Invalid path element [" + element + "] in path [" + path + "]");
                }
                tuple = AggregationPath.split(element, index, tuple);
                tokens.add(new PathElement(element, tuple[0], tuple[1]));
                continue;
            }
            index = element.lastIndexOf(91);
            if (index >= 0) {
                if (index == 0 || index > element.length() - 3) {
                    throw new AggregationExecutionException("Invalid path element [" + element + "] in path [" + path + "]");
                }
                if (element.charAt(element.length() - 1) != ']') {
                    throw new AggregationExecutionException("Invalid path element [" + element + "] in path [" + path + "]");
                }
                tokens.add(new PathElement(element, element.substring(0, index), element.substring(index + 1, element.length() - 1)));
                continue;
            }
            tokens.add(new PathElement(element, element, null));
        }
        return new AggregationPath(tokens);
    }

    public AggregationPath(List<PathElement> tokens) {
        this.pathElements = tokens;
        if (tokens == null || tokens.size() == 0) {
            throw new IllegalArgumentException("Invalid path [" + this + "]");
        }
    }

    public String toString() {
        return Strings.arrayToDelimitedString(this.pathElements.toArray(), AGG_DELIM);
    }

    public PathElement lastPathElement() {
        return this.pathElements.get(this.pathElements.size() - 1);
    }

    public List<PathElement> getPathElements() {
        return this.pathElements;
    }

    public List<String> getPathElementsAsStringList() {
        ArrayList<String> stringPathElements = new ArrayList<String>();
        for (PathElement pathElement : this.pathElements) {
            stringPathElements.add(pathElement.name);
            if (pathElement.key == null) continue;
            stringPathElements.add(pathElement.key);
        }
        return stringPathElements;
    }

    public double resolveValue(InternalAggregations aggregations) {
        try {
            Iterator<PathElement> path = this.pathElements.iterator();
            assert (path.hasNext());
            return aggregations.sortValue(path.next(), path);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid aggregation order path [" + this + "]. " + e.getMessage(), e);
        }
    }

    public Aggregator resolveAggregator(Aggregator root) {
        Iterator<PathElement> path = this.pathElements.iterator();
        assert (path.hasNext());
        return root.resolveSortPathOnValidAgg(path.next(), path);
    }

    public Aggregator resolveTopmostAggregator(Aggregator root) {
        PathElement token = this.pathElements.get(0);
        Aggregator aggregator = ProfilingAggregator.unwrap(root.subAggregator(token.name));
        assert (aggregator instanceof SingleBucketAggregator || aggregator instanceof NumericMetricsAggregator) : "this should be picked up before aggregation execution - on validate";
        return aggregator;
    }

    public Aggregator.BucketComparator bucketComparator(Aggregator root, SortOrder order) {
        return this.resolveAggregator(root).bucketComparator(this.lastPathElement().key, order);
    }

    private static String[] split(String toSplit, int index, String[] result) {
        result[0] = toSplit.substring(0, index);
        result[1] = toSplit.substring(index + 1);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AggregationPath other = (AggregationPath)obj;
        return this.pathElements.equals(other.pathElements);
    }

    public int hashCode() {
        return this.pathElements.hashCode();
    }

    public static class PathElement {
        private final String fullName;
        public final String name;
        public final String key;

        public PathElement(String fullName, String name, String key) {
            this.fullName = fullName;
            this.name = name;
            this.key = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PathElement token = (PathElement)o;
            return Objects.equals(this.key, token.key) && Objects.equals(this.name, token.name);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
            return result;
        }

        public String toString() {
            return this.fullName;
        }
    }
}

