/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.client;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.Security;
import javax.security.auth.Subject;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginException;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.apache.jute.Record;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.ClientCnxn;
import org.apache.zookeeper.Login;
import org.apache.zookeeper.SaslClientCallbackHandler;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.client.ZKClientConfig;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.proto.GetSASLRequest;
import org.apache.zookeeper.proto.SetSASLResponse;
import org.apache.zookeeper.util.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperSaslClient {
    @Deprecated
    public static final String LOGIN_CONTEXT_NAME_KEY = "zookeeper.sasl.clientconfig";
    @Deprecated
    public static final String ENABLE_CLIENT_SASL_KEY = "zookeeper.sasl.client";
    @Deprecated
    public static final String ENABLE_CLIENT_SASL_DEFAULT = "true";
    private volatile boolean initializedLogin = false;
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperSaslClient.class);
    private Login login = null;
    private String clusterName;
    private SaslClient saslClient;
    private boolean isSASLConfigured = true;
    private final ZKClientConfig clientConfig;
    private byte[] saslToken = new byte[0];
    private String authMech;
    private SaslState saslState = SaslState.INITIAL;
    private boolean gotLastPacket = false;
    private final String configStatus;

    @Deprecated
    public static boolean isEnabled() {
        return Boolean.parseBoolean(System.getProperty(ENABLE_CLIENT_SASL_KEY, ENABLE_CLIENT_SASL_DEFAULT));
    }

    public SaslState getSaslState() {
        return this.saslState;
    }

    public String getLoginContext() {
        if (this.login != null) {
            return this.login.getLoginContextName();
        }
        return null;
    }

    public ZooKeeperSaslClient(String serverPrincipal, ZKClientConfig clientConfig, String clusterName) throws LoginException {
        String clientSection = clientConfig.getProperty(LOGIN_CONTEXT_NAME_KEY, "Client");
        this.clientConfig = clientConfig;
        AppConfigurationEntry[] entries = null;
        RuntimeException runtimeException = null;
        this.clusterName = clusterName;
        try {
            entries = Configuration.getConfiguration().getAppConfigurationEntry(clientSection);
        }
        catch (SecurityException e) {
            runtimeException = e;
        }
        catch (IllegalArgumentException e) {
            runtimeException = e;
        }
        if (entries != null) {
            this.authMech = (String)entries[0].getOptions().get("authMech");
            if (this.authMech == null) {
                this.authMech = "GSSAPI";
            }
            this.configStatus = "Will attempt to SASL-authenticate using Login Context section '" + clientSection + "', mechanism " + this.authMech + ", principal " + serverPrincipal;
            this.saslClient = this.createSaslClient(serverPrincipal, clientSection);
        } else {
            this.saslState = SaslState.FAILED;
            String explicitClientSection = clientConfig.getProperty(LOGIN_CONTEXT_NAME_KEY);
            if (explicitClientSection != null) {
                if (runtimeException != null) {
                    throw new LoginException("Zookeeper client cannot authenticate using the " + explicitClientSection + " section of the supplied JAAS configuration: '" + clientConfig.getJaasConfKey() + "' because of a RuntimeException: " + runtimeException);
                }
                throw new LoginException("Client cannot SASL-authenticate because the specified JAAS configuration section '" + explicitClientSection + "' could not be found.");
            }
            Object msg = "Will not attempt to authenticate using SASL ";
            msg = runtimeException != null ? (String)msg + "(" + runtimeException + ")" : (String)msg + "(unknown error)";
            this.configStatus = msg;
            this.isSASLConfigured = false;
            if (clientConfig.getJaasConfKey() != null) {
                if (runtimeException != null) {
                    throw new LoginException("Zookeeper client cannot authenticate using the '" + clientConfig.getProperty(LOGIN_CONTEXT_NAME_KEY, "Client") + "' section of the supplied JAAS configuration: '" + clientConfig.getJaasConfKey() + "' because of a RuntimeException: " + runtimeException);
                }
                throw new LoginException("No JAAS configuration section named '" + clientConfig.getProperty(LOGIN_CONTEXT_NAME_KEY, "Client") + "' was found in specified JAAS configuration file: '" + clientConfig.getJaasConfKey() + "'.");
            }
        }
    }

    public String getConfigStatus() {
        return this.configStatus;
    }

    public boolean isComplete() {
        return this.saslState == SaslState.COMPLETE;
    }

    public boolean isFailed() {
        return this.saslState == SaslState.FAILED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SaslClient createSaslClient(String servicePrincipal, String loginContext) throws LoginException {
        try {
            if (!this.initializedLogin) {
                ZooKeeperSaslClient zooKeeperSaslClient = this;
                synchronized (zooKeeperSaslClient) {
                    if (this.login == null) {
                        LOG.debug("JAAS loginContext is: {}", (Object)loginContext);
                        this.login = new Login(loginContext, new SaslClientCallbackHandler(null, "Client"), this.clientConfig);
                        this.login.startThreadIfNeeded();
                        this.initializedLogin = true;
                    }
                }
            }
            return SecurityUtils.createSaslClient(this.login.getSubject(), servicePrincipal, "zookeeper", "zk-sasl-md5", LOG, "Client", this.authMech, this.clusterName);
        }
        catch (LoginException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error("Exception while trying to create SASL client.", (Throwable)e);
            return null;
        }
    }

    public void respondToServer(byte[] serverToken, ClientCnxn cnxn) {
        if (this.saslClient == null) {
            LOG.error("saslClient is unexpectedly null. Cannot respond to server's SASL message; ignoring.");
            return;
        }
        if (!this.saslClient.isComplete()) {
            try {
                this.saslToken = this.createSaslToken(serverToken);
                if (this.saslToken != null) {
                    this.sendSaslPacket(this.saslToken, cnxn);
                }
            }
            catch (SaslException e) {
                LOG.error("SASL authentication failed using login context '{}'.", (Object)this.getLoginContext(), (Object)e);
                this.saslState = SaslState.FAILED;
                this.gotLastPacket = true;
            }
        }
        if (this.saslClient.isComplete()) {
            String saslMechanismName = this.saslClient.getMechanismName();
            if (serverToken == null && (saslMechanismName.equals("GSSAPI") || saslMechanismName.equals("MAPR-SECURITY") || saslMechanismName.equals("SIMPLE-SECURITY"))) {
                LOG.debug("Mechanism is GSSAPI, MAPR-SECURITY or SIMPLE-SECURITY, set gotLastPacket=true");
                this.gotLastPacket = true;
            }
            if (!(saslMechanismName.equals("GSSAPI") || saslMechanismName.equals("MAPR-SECURITY") || saslMechanismName.equals("SIMPLE-SECURITY"))) {
                LOG.debug("Mechanism " + saslMechanismName + ", setting gotLastPacket=true");
                this.gotLastPacket = true;
            }
            cnxn.saslCompleted();
        }
    }

    private byte[] createSaslToken() throws SaslException {
        this.saslState = SaslState.INTERMEDIATE;
        return this.createSaslToken(this.saslToken);
    }

    private byte[] createSaslToken(final byte[] saslToken) throws SaslException {
        if (saslToken == null) {
            this.saslState = SaslState.FAILED;
            throw new SaslException("Error in authenticating with a Zookeeper Quorum member: the quorum member's saslToken is null.");
        }
        Subject subject = this.login.getSubject();
        if (subject != null) {
            Login login = this.login;
            synchronized (login) {
                try {
                    byte[] retval = Subject.doAs(subject, new PrivilegedExceptionAction<byte[]>(){

                        @Override
                        public byte[] run() throws SaslException {
                            LOG.debug("saslClient.evaluateChallenge(len={})", (Object)saslToken.length);
                            return ZooKeeperSaslClient.this.saslClient.evaluateChallenge(saslToken);
                        }
                    });
                    return retval;
                }
                catch (PrivilegedActionException e) {
                    String error = "An error: (" + e + ") occurred when evaluating Zookeeper Quorum Member's  received SASL token.";
                    String UNKNOWN_SERVER_ERROR_TEXT = "(Mechanism level: Server not found in Kerberos database (7) - UNKNOWN_SERVER)";
                    if (e.toString().contains("(Mechanism level: Server not found in Kerberos database (7) - UNKNOWN_SERVER)")) {
                        error = error + " This may be caused by Java's being unable to resolve the Zookeeper Quorum Member's hostname correctly. You may want to try to adding '-Dsun.net.spi.nameservice.provider.1=dns,sun' to your client's JVMFLAGS environment.";
                    }
                    error = error + " Zookeeper Client will go to AUTH_FAILED state.";
                    LOG.error(error);
                    this.saslState = SaslState.FAILED;
                    throw new SaslException(error, e);
                }
            }
        }
        throw new SaslException("Cannot make SASL token without subject defined. For diagnosis, please look for WARNs and ERRORs in your log related to the Login class.");
    }

    private void sendSaslPacket(byte[] saslToken, ClientCnxn cnxn) throws SaslException {
        LOG.debug("ClientCnxn:sendSaslPacket:length={}", (Object)saslToken.length);
        GetSASLRequest request = new GetSASLRequest();
        request.setToken(saslToken);
        SetSASLResponse response = new SetSASLResponse();
        ServerSaslResponseCallback cb = new ServerSaslResponseCallback();
        try {
            cnxn.sendPacket((Record)request, (Record)response, cb, 102);
        }
        catch (IOException e) {
            throw new SaslException("Failed to send SASL packet to server.", e);
        }
    }

    private void sendSaslPacket(ClientCnxn cnxn) throws SaslException {
        LOG.debug("ClientCnxn:sendSaslPacket:length={}", (Object)this.saslToken.length);
        GetSASLRequest request = new GetSASLRequest();
        request.setToken(this.createSaslToken());
        SetSASLResponse response = new SetSASLResponse();
        ServerSaslResponseCallback cb = new ServerSaslResponseCallback();
        try {
            cnxn.sendPacket((Record)request, (Record)response, cb, 102);
        }
        catch (IOException e) {
            throw new SaslException("Failed to send SASL packet to server due to IOException:", e);
        }
    }

    public Watcher.Event.KeeperState getKeeperState() {
        if (this.saslClient != null) {
            if (this.saslState == SaslState.FAILED) {
                return Watcher.Event.KeeperState.AuthFailed;
            }
            if (this.saslClient.isComplete() && this.saslState == SaslState.INTERMEDIATE) {
                this.saslState = SaslState.COMPLETE;
                return Watcher.Event.KeeperState.SaslAuthenticated;
            }
        }
        return null;
    }

    public void initialize(ClientCnxn cnxn) throws SaslException {
        if (this.saslClient == null) {
            this.saslState = SaslState.FAILED;
            throw new SaslException("saslClient failed to initialize properly: it's null.");
        }
        if (this.saslState == SaslState.INITIAL) {
            if (this.saslClient.hasInitialResponse()) {
                this.sendSaslPacket(cnxn);
            } else {
                byte[] emptyToken = new byte[]{};
                this.sendSaslPacket(emptyToken, cnxn);
            }
            this.saslState = SaslState.INTERMEDIATE;
        }
    }

    public boolean clientTunneledAuthenticationInProgress() {
        if (!this.isSASLConfigured) {
            return false;
        }
        try {
            if (this.clientConfig.getJaasConfKey() != null || Configuration.getConfiguration() != null && Configuration.getConfiguration().getAppConfigurationEntry(this.clientConfig.getProperty(LOGIN_CONTEXT_NAME_KEY, "Client")) != null) {
                if (!this.isComplete() && !this.isFailed()) {
                    return true;
                }
                if (!this.gotLastPacket) {
                    return true;
                }
            }
            return false;
        }
        catch (SecurityException e) {
            LOG.debug("Could not retrieve login configuration", (Throwable)e);
            return false;
        }
    }

    public void shutdown() {
        if (null != this.login) {
            this.login.shutdown();
            this.login = null;
        }
    }

    static {
        String saslProviderClassName = System.getProperty("zookeeper.saslprovider");
        if (saslProviderClassName != null) {
            try {
                Class<?> clazz = Class.forName(saslProviderClassName);
                Security.addProvider((Provider)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (ClassNotFoundException e) {
                LOG.warn("ClassNotFoundException: " + saslProviderClassName, (Throwable)e);
            }
            catch (InstantiationException e) {
                LOG.warn("InstantiationException: " + saslProviderClassName, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOG.warn("IllegalAccessException: " + saslProviderClassName, (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                LOG.warn("NoSuchMethodException: " + saslProviderClassName, (Throwable)e);
            }
            catch (SecurityException e) {
                LOG.warn("SecurityException: " + saslProviderClassName, (Throwable)e);
            }
            catch (InvocationTargetException e) {
                LOG.warn("InvocationTargetException: " + saslProviderClassName, (Throwable)e);
            }
        }
    }

    public static enum SaslState {
        INITIAL,
        INTERMEDIATE,
        COMPLETE,
        FAILED;

    }

    public static class ServerSaslResponseCallback
    implements AsyncCallback.DataCallback {
        @Override
        public void processResult(int rc, String path, Object ctx, byte[] data, Stat stat) {
            ZooKeeperSaslClient client = ((ClientCnxn)ctx).getZooKeeperSaslClient();
            if (client == null) {
                LOG.warn("sasl client was unexpectedly null: cannot respond to Zookeeper server.");
                return;
            }
            byte[] usedata = data;
            if (data != null) {
                LOG.debug("ServerSaslResponseCallback(): saslToken server response: (length={})", (Object)usedata.length);
            } else {
                usedata = new byte[]{};
                LOG.debug("ServerSaslResponseCallback(): using empty data[] as server response (length={})", (Object)usedata.length);
            }
            client.respondToServer(usedata, (ClientCnxn)ctx);
        }
    }
}

