/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.search.DisiWrapper;
import org.apache.lucene.search.DisjunctionScorer;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.MathUtil;

final class DisjunctionSumScorer
extends DisjunctionScorer {
    private final List<Scorer> scorers;

    DisjunctionSumScorer(Weight weight, List<Scorer> subScorers, ScoreMode scoreMode) throws IOException {
        super(weight, subScorers, scoreMode);
        this.scorers = subScorers;
    }

    @Override
    protected float score(DisiWrapper topList) throws IOException {
        double score = 0.0;
        DisiWrapper w = topList;
        while (w != null) {
            score += (double)w.scorer.score();
            w = w.next;
        }
        return (float)score;
    }

    @Override
    public int advanceShallow(int target) throws IOException {
        int min = Integer.MAX_VALUE;
        for (Scorer scorer : this.scorers) {
            if (scorer.docID() > target) continue;
            min = Math.min(min, scorer.advanceShallow(target));
        }
        return min;
    }

    @Override
    public float getMaxScore(int upTo) throws IOException {
        double maxScore = 0.0;
        for (Scorer scorer : this.scorers) {
            if (scorer.docID() > upTo) continue;
            maxScore += (double)scorer.getMaxScore(upTo);
        }
        return (float)MathUtil.sumUpperBound(maxScore, this.scorers.size());
    }
}

