/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.kafka;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerService;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.service.RangerBaseService;
import org.apache.ranger.plugin.service.ResourceLookupContext;
import org.apache.ranger.services.kafka.client.ServiceKafkaClient;
import org.apache.ranger.services.kafka.client.ServiceKafkaConnectionMgr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerServiceKafka
extends RangerBaseService {
    private static final Logger LOG = LoggerFactory.getLogger(RangerServiceKafka.class);
    public static final String ACCESS_TYPE_DESCRIBE = "describe";

    public void init(RangerServiceDef serviceDef, RangerService service) {
        super.init(serviceDef, service);
    }

    public Map<String, Object> validateConfig() throws Exception {
        Map<String, Object> ret = new HashMap<String, Object>();
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerServiceKafka.validateConfig(" + this.serviceName + ")");
        }
        if (this.configs != null) {
            try {
                ret = ServiceKafkaConnectionMgr.connectionTest(this.serviceName, this.configs);
            }
            catch (Exception e) {
                LOG.error("<== RangerServiceKafka.validateConfig Error:" + e);
                throw e;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerServiceKafka.validateConfig(" + this.serviceName + "): ret=" + ret);
        }
        return ret;
    }

    public List<String> lookupResource(ResourceLookupContext context) throws Exception {
        List<String> ret = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerServiceKafka.lookupResource(" + this.serviceName + ")");
        }
        if (this.configs != null) {
            ServiceKafkaClient serviceKafkaClient = ServiceKafkaConnectionMgr.getKafkaClient(this.serviceName, this.configs);
            ret = serviceKafkaClient.getResources(context);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerServiceKafka.lookupResource(" + this.serviceName + "): ret=" + ret);
        }
        return ret;
    }

    public List<RangerPolicy> getDefaultRangerPolicies() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerServiceKafka.getDefaultRangerPolicies() ");
        }
        List ret = super.getDefaultRangerPolicies();
        String authType = this.getConfig().get("hadoop.security.authentication", "simple");
        if (StringUtils.equalsIgnoreCase((String)authType, (String)"kerberos")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Auth type is kerberos");
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Auth type is " + authType);
            }
            for (RangerPolicy defaultPolicy : ret) {
                if (!defaultPolicy.getName().contains("all")) continue;
                for (RangerPolicy.RangerPolicyItem defaultPolicyItem : defaultPolicy.getPolicyItems()) {
                    defaultPolicyItem.getGroups().add("public");
                }
            }
        }
        for (RangerPolicy defaultPolicy : ret) {
            if (!defaultPolicy.getName().contains("all") || !StringUtils.isNotBlank((String)this.lookUpUser)) continue;
            RangerPolicy.RangerPolicyItem policyItemForLookupUser = new RangerPolicy.RangerPolicyItem();
            policyItemForLookupUser.setUsers(Collections.singletonList(this.lookUpUser));
            policyItemForLookupUser.setAccesses(Collections.singletonList(new RangerPolicy.RangerPolicyItemAccess(ACCESS_TYPE_DESCRIBE)));
            policyItemForLookupUser.setDelegateAdmin(Boolean.valueOf(false));
            defaultPolicy.getPolicyItems().add(policyItemForLookupUser);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerServiceKafka.getDefaultRangerPolicies() ");
        }
        return ret;
    }
}

